// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkSurfaceLICInterface_DCpy.h"

const char *vtkSurfaceLICInterface_DCpy =
"//VTK::System::Dec\n"
"\n"
"\n"
"// This shader copies fragments and depths to the output buffer\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"uniform sampler2D texDepth;     // z values from vertex shader\n"
"uniform sampler2D texRGBColors; // final rgb LIC colors\n"
"\n"
"in vec2 tcoordVC;\n"
"\n"
"void main()\n"
"{\n"
"  gl_FragDepth = texture2D(texDepth, tcoordVC).x;\n"
"  gl_FragData[0] = texture2D(texRGBColors, tcoordVC);\n"
"\n"
"  // since we render a screen aligned quad\n"
"  // we're going to be writing fragments\n"
"  // not touched by the original geometry\n"
"  // it's critical not to modify those\n"
"  // fragments.\n"
"  if (gl_FragDepth == 1.0)\n"
"    {\n"
"    discard;\n"
"    }\n"
"}\n"
"";
