// python wrapper for vtkAMRVolumeMapper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAMRVolumeMapper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAMRVolumeMapper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAMRVolumeMapper_ClassNew(); }


static PyObject *
PyvtkAMRVolumeMapper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAMRVolumeMapper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAMRVolumeMapper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAMRVolumeMapper *tempr = vtkAMRVolumeMapper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAMRVolumeMapper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAMRVolumeMapper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAMRVolumeMapper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAMRVolumeMapper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetInputData_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkImageData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImageData"))
  {
    if (ap.IsBound())
    {
      op->SetInputData(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInputData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetInputData_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkDataSet *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkDataSet"))
  {
    if (ap.IsBound())
    {
      op->SetInputData(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInputData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetInputData_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkRectilinearGrid *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRectilinearGrid"))
  {
    if (ap.IsBound())
    {
      op->SetInputData(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInputData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetInputData_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkOverlappingAMR *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOverlappingAMR"))
  {
    if (ap.IsBound())
    {
      op->SetInputData(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInputData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkAMRVolumeMapper_SetInputData_Methods[] = {
  {"SetInputData", PyvtkAMRVolumeMapper_SetInputData_s1, METH_VARARGS,
   "@V *vtkImageData"},
  {"SetInputData", PyvtkAMRVolumeMapper_SetInputData_s2, METH_VARARGS,
   "@V *vtkDataSet"},
  {"SetInputData", PyvtkAMRVolumeMapper_SetInputData_s3, METH_VARARGS,
   "@V *vtkRectilinearGrid"},
  {"SetInputData", PyvtkAMRVolumeMapper_SetInputData_s4, METH_VARARGS,
   "@V *vtkOverlappingAMR"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkAMRVolumeMapper_SetInputData(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkAMRVolumeMapper_SetInputData_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetInputData");
  return nullptr;
}


static PyObject *
PyvtkAMRVolumeMapper_SetInputConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetInputConnection(temp0, temp1);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInputConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetInputConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetInputConnection(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInputConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetInputConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkAMRVolumeMapper_SetInputConnection_s1(self, args);
    case 1:
      return PyvtkAMRVolumeMapper_SetInputConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetInputConnection");
  return nullptr;
}


static PyObject *
PyvtkAMRVolumeMapper_GetBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBounds() :
      op->vtkAMRVolumeMapper::GetBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_GetBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetBounds(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::GetBounds(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_GetBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkAMRVolumeMapper_GetBounds_s1(self, args);
    case 1:
      return PyvtkAMRVolumeMapper_GetBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetBounds");
  return nullptr;
}


static PyObject *
PyvtkAMRVolumeMapper_SetScalarMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScalarMode(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetScalarMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetBlendMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlendMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlendMode(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetBlendMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetBlendMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlendMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBlendMode() :
      op->vtkAMRVolumeMapper::GetBlendMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SelectScalarArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectScalarArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectScalarArray(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SelectScalarArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SelectScalarArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectScalarArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectScalarArray(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SelectScalarArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkAMRVolumeMapper_SelectScalarArray_Methods[] = {
  {"SelectScalarArray", PyvtkAMRVolumeMapper_SelectScalarArray_s1, METH_VARARGS,
   "@i"},
  {"SelectScalarArray", PyvtkAMRVolumeMapper_SelectScalarArray_s2, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkAMRVolumeMapper_SelectScalarArray(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkAMRVolumeMapper_SelectScalarArray_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SelectScalarArray");
  return nullptr;
}


static PyObject *
PyvtkAMRVolumeMapper_GetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetArrayName() :
      op->vtkAMRVolumeMapper::GetArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetArrayId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetArrayId() :
      op->vtkAMRVolumeMapper::GetArrayId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetArrayAccessMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayAccessMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetArrayAccessMode() :
      op->vtkAMRVolumeMapper::GetArrayAccessMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetScalarModeAsString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScalarModeAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetScalarModeAsString() :
      op->vtkAMRVolumeMapper::GetScalarModeAsString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetCropping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCropping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCropping(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetCropping(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetCropping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCropping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCropping() :
      op->vtkAMRVolumeMapper::GetCropping());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetCroppingRegionPlanes_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCroppingRegionPlanes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetCroppingRegionPlanes(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetCroppingRegionPlanes(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetCroppingRegionPlanes_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCroppingRegionPlanes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCroppingRegionPlanes(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetCroppingRegionPlanes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetCroppingRegionPlanes(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyvtkAMRVolumeMapper_SetCroppingRegionPlanes_s1(self, args);
    case 1:
      return PyvtkAMRVolumeMapper_SetCroppingRegionPlanes_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCroppingRegionPlanes");
  return nullptr;
}


static PyObject *
PyvtkAMRVolumeMapper_GetCroppingRegionPlanes_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCroppingRegionPlanes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetCroppingRegionPlanes(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::GetCroppingRegionPlanes(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_GetCroppingRegionPlanes_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCroppingRegionPlanes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCroppingRegionPlanes() :
      op->vtkAMRVolumeMapper::GetCroppingRegionPlanes());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_GetCroppingRegionPlanes(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkAMRVolumeMapper_GetCroppingRegionPlanes_s1(self, args);
    case 0:
      return PyvtkAMRVolumeMapper_GetCroppingRegionPlanes_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetCroppingRegionPlanes");
  return nullptr;
}


static PyObject *
PyvtkAMRVolumeMapper_SetCroppingRegionFlags(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCroppingRegionFlags");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCroppingRegionFlags(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetCroppingRegionFlags(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetCroppingRegionFlags(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCroppingRegionFlags");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCroppingRegionFlags() :
      op->vtkAMRVolumeMapper::GetCroppingRegionFlags());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetRequestedRenderMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedRenderMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedRenderMode(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetRequestedRenderMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetRequestedRenderMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequestedRenderMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRequestedRenderMode() :
      op->vtkAMRVolumeMapper::GetRequestedRenderMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetRequestedRenderModeToDefault(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedRenderModeToDefault");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedRenderModeToDefault();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetRequestedRenderModeToDefault();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetRequestedRenderModeToRayCastAndTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedRenderModeToRayCastAndTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedRenderModeToRayCastAndTexture();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetRequestedRenderModeToRayCastAndTexture();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetRequestedRenderModeToRayCast(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedRenderModeToRayCast");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedRenderModeToRayCast();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetRequestedRenderModeToRayCast();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetRequestedRenderModeToTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedRenderModeToTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedRenderModeToTexture();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetRequestedRenderModeToTexture();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetRequestedRenderModeToGPU(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedRenderModeToGPU");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedRenderModeToGPU();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetRequestedRenderModeToGPU();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetInterpolationMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolationMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolationMode(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInterpolationMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetInterpolationMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInterpolationMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInterpolationMode() :
      op->vtkAMRVolumeMapper::GetInterpolationMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetInterpolationModeToNearestNeighbor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolationModeToNearestNeighbor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolationModeToNearestNeighbor();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInterpolationModeToNearestNeighbor();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetInterpolationModeToLinear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolationModeToLinear");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolationModeToLinear();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInterpolationModeToLinear();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetInterpolationModeToCubic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolationModeToCubic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolationModeToCubic();
    }
    else
    {
      op->vtkAMRVolumeMapper::SetInterpolationModeToCubic();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetNumberOfSamples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfSamples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfSamples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetNumberOfSamples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetNumberOfSamples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfSamples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  const size_t size0 = 3;
  int temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfSamples(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetNumberOfSamples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAMRVolumeMapper_SetNumberOfSamples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkAMRVolumeMapper_SetNumberOfSamples_s1(self, args);
    case 1:
      return PyvtkAMRVolumeMapper_SetNumberOfSamples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetNumberOfSamples");
  return nullptr;
}


static PyObject *
PyvtkAMRVolumeMapper_GetNumberOfSamples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfSamples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetNumberOfSamples() :
      op->vtkAMRVolumeMapper::GetNumberOfSamples());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkRenderer *temp0 = nullptr;
  vtkVolume *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkRenderer") &&
      ap.GetVTKObject(temp1, "vtkVolume"))
  {
    if (ap.IsBound())
    {
      op->Render(temp0, temp1);
    }
    else
    {
      op->vtkAMRVolumeMapper::Render(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_ReleaseGraphicsResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseGraphicsResources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkWindow"))
  {
    if (ap.IsBound())
    {
      op->ReleaseGraphicsResources(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::ReleaseGraphicsResources(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_UpdateResampler(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateResampler");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkRenderer *temp0 = nullptr;
  vtkOverlappingAMR *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkRenderer") &&
      ap.GetVTKObject(temp1, "vtkOverlappingAMR"))
  {
    if (ap.IsBound())
    {
      op->UpdateResampler(temp0, temp1);
    }
    else
    {
      op->vtkAMRVolumeMapper::UpdateResampler(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_UpdateResamplerFrustrumMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateResamplerFrustrumMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  vtkRenderer *temp0 = nullptr;
  vtkOverlappingAMR *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkRenderer") &&
      ap.GetVTKObject(temp1, "vtkOverlappingAMR"))
  {
    if (ap.IsBound())
    {
      op->UpdateResamplerFrustrumMethod(temp0, temp1);
    }
    else
    {
      op->vtkAMRVolumeMapper::UpdateResamplerFrustrumMethod(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetRequestedResamplingMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedResamplingMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedResamplingMode(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetRequestedResamplingMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetRequestedResamplingMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequestedResamplingMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRequestedResamplingMode() :
      op->vtkAMRVolumeMapper::GetRequestedResamplingMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetFreezeFocalPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFreezeFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFreezeFocalPoint(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetFreezeFocalPoint(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetFreezeFocalPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFreezeFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFreezeFocalPoint() :
      op->vtkAMRVolumeMapper::GetFreezeFocalPoint());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetResamplerUpdateTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResamplerUpdateTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetResamplerUpdateTolerance(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetResamplerUpdateTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetResamplerUpdateTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResamplerUpdateTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetResamplerUpdateTolerance() :
      op->vtkAMRVolumeMapper::GetResamplerUpdateTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_SetUseDefaultThreading(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseDefaultThreading");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseDefaultThreading(temp0);
    }
    else
    {
      op->vtkAMRVolumeMapper::SetUseDefaultThreading(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_GetUseDefaultThreading(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseDefaultThreading");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRVolumeMapper *op = static_cast<vtkAMRVolumeMapper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseDefaultThreading() :
      op->vtkAMRVolumeMapper::GetUseDefaultThreading());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRVolumeMapper_ComputeResamplerBoundsFrustumMethod(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ComputeResamplerBoundsFrustumMethod");

  vtkCamera *temp0 = nullptr;
  vtkRenderer *temp1 = nullptr;
  const size_t size2 = 6;
  double temp2[6];
  const size_t size3 = 6;
  double temp3[6];
  double save3[6];
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkCamera") &&
      ap.GetVTKObject(temp1, "vtkRenderer") &&
      ap.GetArray(temp2, size2) &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    bool tempr = vtkAMRVolumeMapper::ComputeResamplerBoundsFrustumMethod(temp0, temp1, temp2, temp3);

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkAMRVolumeMapper_Methods[] = {
  {"IsTypeOf", PyvtkAMRVolumeMapper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAMRVolumeMapper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAMRVolumeMapper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAMRVolumeMapper\nC++: static vtkAMRVolumeMapper *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAMRVolumeMapper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAMRVolumeMapper\nC++: vtkAMRVolumeMapper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAMRVolumeMapper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAMRVolumeMapper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetInputData", PyvtkAMRVolumeMapper_SetInputData, METH_VARARGS,
   "SetInputData(self, __a:vtkImageData) -> None\nC++: void SetInputData(vtkImageData *) override;\nSetInputData(self, __a:vtkDataSet) -> None\nC++: void SetInputData(vtkDataSet *) override;\nSetInputData(self, __a:vtkRectilinearGrid) -> None\nC++: void SetInputData(vtkRectilinearGrid *) override;\nSetInputData(self, __a:vtkOverlappingAMR) -> None\nC++: virtual void SetInputData(vtkOverlappingAMR *)\n\nSet the input data\n"},
  {"SetInputConnection", PyvtkAMRVolumeMapper_SetInputConnection, METH_VARARGS,
   "SetInputConnection(self, port:int, input:vtkAlgorithmOutput)\n    -> None\nC++: void SetInputConnection(int port, vtkAlgorithmOutput *input)\n    override;\nSetInputConnection(self, input:vtkAlgorithmOutput) -> None\nC++: void SetInputConnection(vtkAlgorithmOutput *input) override;\n\nSet the connection for the given input port index.  Each input\nport of a filter has a specific purpose.  A port may have zero or\nmore connections and the required number is specified by each\nfilter.  Setting the connection with this method removes all\nother connections from the port.  To add more than one connection\nuse AddInputConnection().\n\n* The input for the connection is the output port of another\n* filter, which is obtained with GetOutputPort().  Typical usage\n  is\n\n* filter2->SetInputConnection(0, filter1->GetOutputPort(0)).\n"},
  {"GetBounds", PyvtkAMRVolumeMapper_GetBounds, METH_VARARGS,
   "GetBounds(self) -> (float, float, float, float, float, float)\nC++: double *GetBounds() override;\nGetBounds(self, bounds:[float, float, float, float, float, float])\n     -> None\nC++: void GetBounds(double bounds[6]) override;\n\nReturn bounding box (array of six doubles) of data expressed as\n(xmin,xmax, ymin,ymax, zmin,zmax).\n"},
  {"SetScalarMode", PyvtkAMRVolumeMapper_SetScalarMode, METH_VARARGS,
   "SetScalarMode(self, mode:int) -> None\nC++: void SetScalarMode(int mode) override;\n\nControl how the mapper works with scalar point data and cell\nattribute data.  By default (ScalarModeToDefault), the mapper\nwill use point data, and if no point data is available, then cell\ndata is used. Alternatively you can explicitly set the mapper to\nuse point data (ScalarModeToUsePointData) or cell data\n(ScalarModeToUseCellData). You can also choose to get the scalars\nfrom an array in point field data (ScalarModeToUsePointFieldData)\nor cell field data (ScalarModeToUseCellFieldData).  If scalars\nare coming from a field data array, you must call\nSelectScalarArray.\n"},
  {"SetBlendMode", PyvtkAMRVolumeMapper_SetBlendMode, METH_VARARGS,
   "SetBlendMode(self, mode:int) -> None\nC++: void SetBlendMode(int mode) override;\n\nSet/Get the blend mode. Additive blend mode adds scalars along\nthe ray and multiply them by their opacity mapping value.\n"},
  {"GetBlendMode", PyvtkAMRVolumeMapper_GetBlendMode, METH_VARARGS,
   "GetBlendMode(self) -> int\nC++: int GetBlendMode() override;\n\n"},
  {"SelectScalarArray", PyvtkAMRVolumeMapper_SelectScalarArray, METH_VARARGS,
   "SelectScalarArray(self, arrayNum:int) -> None\nC++: void SelectScalarArray(int arrayNum) override;\nSelectScalarArray(self, arrayName:str) -> None\nC++: void SelectScalarArray(const char *arrayName) override;\n\nWhen ScalarMode is set to UsePointFieldData or UseCellFieldData,\nyou can specify which scalar array to use during rendering. The\ntransfer function in the vtkVolumeProperty (attached to the\ncalling vtkVolume) will decide how to convert vectors to colors.\n"},
  {"GetArrayName", PyvtkAMRVolumeMapper_GetArrayName, METH_VARARGS,
   "GetArrayName(self) -> str\nC++: char *GetArrayName() override;\n\nGet the array name or number and component to use for rendering.\n"},
  {"GetArrayId", PyvtkAMRVolumeMapper_GetArrayId, METH_VARARGS,
   "GetArrayId(self) -> int\nC++: int GetArrayId() override;\n\n"},
  {"GetArrayAccessMode", PyvtkAMRVolumeMapper_GetArrayAccessMode, METH_VARARGS,
   "GetArrayAccessMode(self) -> int\nC++: int GetArrayAccessMode() override;\n\n"},
  {"GetScalarModeAsString", PyvtkAMRVolumeMapper_GetScalarModeAsString, METH_VARARGS,
   "GetScalarModeAsString(self) -> str\nC++: const char *GetScalarModeAsString()\n\nReturn the method for obtaining scalar data.\n"},
  {"SetCropping", PyvtkAMRVolumeMapper_SetCropping, METH_VARARGS,
   "SetCropping(self, __a:int) -> None\nC++: void SetCropping(vtkTypeBool) override;\n\nTurn On/Off orthogonal cropping. (Clipping planes are\nperpendicular to the coordinate axes.)\n"},
  {"GetCropping", PyvtkAMRVolumeMapper_GetCropping, METH_VARARGS,
   "GetCropping(self) -> int\nC++: vtkTypeBool GetCropping() override;\n\n"},
  {"SetCroppingRegionPlanes", PyvtkAMRVolumeMapper_SetCroppingRegionPlanes, METH_VARARGS,
   "SetCroppingRegionPlanes(self, arg1:float, arg2:float, arg3:float,\n    arg4:float, arg5:float, arg6:float) -> None\nC++: void SetCroppingRegionPlanes(double arg1, double arg2,\n    double arg3, double arg4, double arg5, double arg6) override;\nSetCroppingRegionPlanes(self, planes:(float, float, float, float,\n    float, float)) -> None\nC++: void SetCroppingRegionPlanes(const double *planes) override;\n\nSet/Get the Cropping Region Planes ( xmin, xmax, ymin, ymax,\nzmin, zmax ) These planes are defined in volume coordinates -\nspacing and origin are considered.\n"},
  {"GetCroppingRegionPlanes", PyvtkAMRVolumeMapper_GetCroppingRegionPlanes, METH_VARARGS,
   "GetCroppingRegionPlanes(self, planes:[float, float, float, float,\n    float, float]) -> None\nC++: void GetCroppingRegionPlanes(double *planes) override;\nGetCroppingRegionPlanes(self) -> (float, float, float, float,\n    float, float)\nC++: double *GetCroppingRegionPlanes() override;\n\n"},
  {"SetCroppingRegionFlags", PyvtkAMRVolumeMapper_SetCroppingRegionFlags, METH_VARARGS,
   "SetCroppingRegionFlags(self, mode:int) -> None\nC++: void SetCroppingRegionFlags(int mode) override;\n\nSet the flags for the cropping regions. The clipping planes\ndivide the volume into 27 regions - there is one bit for each\nregion. The regions start from the one containing voxel (0,0,0),\nmoving along the x axis fastest, the y axis next, and the z axis\nslowest. These are represented from the lowest bit to bit number\n27 in the integer containing the flags. There are several\nconvenience functions to set some common configurations -\nsubvolume (the default), fence (between any of the clip plane\npairs), inverted fence, cross (between any two of the clip plane\npairs) and inverted cross.\n"},
  {"GetCroppingRegionFlags", PyvtkAMRVolumeMapper_GetCroppingRegionFlags, METH_VARARGS,
   "GetCroppingRegionFlags(self) -> int\nC++: int GetCroppingRegionFlags() override;\n\n"},
  {"SetRequestedRenderMode", PyvtkAMRVolumeMapper_SetRequestedRenderMode, METH_VARARGS,
   "SetRequestedRenderMode(self, mode:int) -> None\nC++: void SetRequestedRenderMode(int mode)\n\nSet the requested render mode. The default is\nvtkSmartVolumeMapper::DefaultRenderMode.\n"},
  {"GetRequestedRenderMode", PyvtkAMRVolumeMapper_GetRequestedRenderMode, METH_VARARGS,
   "GetRequestedRenderMode(self) -> int\nC++: int GetRequestedRenderMode()\n\n"},
  {"SetRequestedRenderModeToDefault", PyvtkAMRVolumeMapper_SetRequestedRenderModeToDefault, METH_VARARGS,
   "SetRequestedRenderModeToDefault(self) -> None\nC++: void SetRequestedRenderModeToDefault()\n\nSet the requested render mode to\nvtkAMRVolumeMapper::DefaultRenderMode. This is the best option\nfor an application that must adapt to different data types,\nhardware, and rendering parameters.\n"},
  {"SetRequestedRenderModeToRayCastAndTexture", PyvtkAMRVolumeMapper_SetRequestedRenderModeToRayCastAndTexture, METH_VARARGS,
   "SetRequestedRenderModeToRayCastAndTexture(self) -> None\nC++: void SetRequestedRenderModeToRayCastAndTexture()\n\nSet the requested render mode to\nvtkAMRVolumeMapper::RayCastAndTextureRenderMode. This is a good\noption if you want to avoid using advanced OpenGL functionality,\nbut would still like to used 3D texture mapping, if available,\nfor interactive rendering.\n"},
  {"SetRequestedRenderModeToRayCast", PyvtkAMRVolumeMapper_SetRequestedRenderModeToRayCast, METH_VARARGS,
   "SetRequestedRenderModeToRayCast(self) -> None\nC++: void SetRequestedRenderModeToRayCast()\n\nSet the requested render mode to\nvtkAMRVolumeMapper::RayCastRenderMode. This option will use\nsoftware rendering exclusively. This is a good option if you know\nthere is no hardware acceleration.\n"},
  {"SetRequestedRenderModeToTexture", PyvtkAMRVolumeMapper_SetRequestedRenderModeToTexture, METH_VARARGS,
   "SetRequestedRenderModeToTexture(self) -> None\nC++: void SetRequestedRenderModeToTexture()\n\nSet the requested render mode to\nvtkAMRVolumeMapper::TextureRenderMode. This is a good option if\nyou want to use 3D texture mapping, if available, for interactive\nrendering.\n"},
  {"SetRequestedRenderModeToGPU", PyvtkAMRVolumeMapper_SetRequestedRenderModeToGPU, METH_VARARGS,
   "SetRequestedRenderModeToGPU(self) -> None\nC++: void SetRequestedRenderModeToGPU()\n\nSet the requested render mode to\nvtkAMRVolumeMapper::GPURenderMode. This will do the volume\nrendering on the GPU\n"},
  {"SetInterpolationMode", PyvtkAMRVolumeMapper_SetInterpolationMode, METH_VARARGS,
   "SetInterpolationMode(self, mode:int) -> None\nC++: void SetInterpolationMode(int mode)\n\nSet interpolation mode for downsampling (lowres GPU) (initial\nvalue: cubic).\n"},
  {"GetInterpolationMode", PyvtkAMRVolumeMapper_GetInterpolationMode, METH_VARARGS,
   "GetInterpolationMode(self) -> int\nC++: int GetInterpolationMode()\n\n"},
  {"SetInterpolationModeToNearestNeighbor", PyvtkAMRVolumeMapper_SetInterpolationModeToNearestNeighbor, METH_VARARGS,
   "SetInterpolationModeToNearestNeighbor(self) -> None\nC++: void SetInterpolationModeToNearestNeighbor()\n\n"},
  {"SetInterpolationModeToLinear", PyvtkAMRVolumeMapper_SetInterpolationModeToLinear, METH_VARARGS,
   "SetInterpolationModeToLinear(self) -> None\nC++: void SetInterpolationModeToLinear()\n\n"},
  {"SetInterpolationModeToCubic", PyvtkAMRVolumeMapper_SetInterpolationModeToCubic, METH_VARARGS,
   "SetInterpolationModeToCubic(self) -> None\nC++: void SetInterpolationModeToCubic()\n\n"},
  {"SetNumberOfSamples", PyvtkAMRVolumeMapper_SetNumberOfSamples, METH_VARARGS,
   "SetNumberOfSamples(self, _arg1:int, _arg2:int, _arg3:int) -> None\nC++: virtual void SetNumberOfSamples(int _arg1, int _arg2,\n    int _arg3)\nSetNumberOfSamples(self, _arg:(int, int, int)) -> None\nC++: virtual void SetNumberOfSamples(const int _arg[3])\n\nSet/Get the number of samples/cells along the i/j/k directions.\nThe default is 128x128x128\n"},
  {"GetNumberOfSamples", PyvtkAMRVolumeMapper_GetNumberOfSamples, METH_VARARGS,
   "GetNumberOfSamples(self) -> (int, int, int)\nC++: virtual int *GetNumberOfSamples()\n\n"},
  {"Render", PyvtkAMRVolumeMapper_Render, METH_VARARGS,
   "Render(self, ren:vtkRenderer, vol:vtkVolume) -> None\nC++: void Render(vtkRenderer *ren, vtkVolume *vol) override;\n\nWARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE DO NOT\nUSE THIS METHOD OUTSIDE OF THE RENDERING PROCESS Render the\nvolume\n"},
  {"ReleaseGraphicsResources", PyvtkAMRVolumeMapper_ReleaseGraphicsResources, METH_VARARGS,
   "ReleaseGraphicsResources(self, __a:vtkWindow) -> None\nC++: void ReleaseGraphicsResources(vtkWindow *) override;\n\nWARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Release\nany graphics resources that are being consumed by this mapper.\nThe parameter window could be used to determine which graphic\nresources to release.\n"},
  {"UpdateResampler", PyvtkAMRVolumeMapper_UpdateResampler, METH_VARARGS,
   "UpdateResampler(self, ren:vtkRenderer, amr:vtkOverlappingAMR)\n    -> None\nC++: void UpdateResampler(vtkRenderer *ren,\n    vtkOverlappingAMR *amr)\n\n"},
  {"UpdateResamplerFrustrumMethod", PyvtkAMRVolumeMapper_UpdateResamplerFrustrumMethod, METH_VARARGS,
   "UpdateResamplerFrustrumMethod(self, ren:vtkRenderer,\n    amr:vtkOverlappingAMR) -> None\nC++: void UpdateResamplerFrustrumMethod(vtkRenderer *ren,\n    vtkOverlappingAMR *amr)\n\n"},
  {"SetRequestedResamplingMode", PyvtkAMRVolumeMapper_SetRequestedResamplingMode, METH_VARARGS,
   "SetRequestedResamplingMode(self, _arg:int) -> None\nC++: virtual void SetRequestedResamplingMode(int _arg)\n\nSelect the type of resampling technique approach to use.\n"},
  {"GetRequestedResamplingMode", PyvtkAMRVolumeMapper_GetRequestedResamplingMode, METH_VARARGS,
   "GetRequestedResamplingMode(self) -> int\nC++: virtual int GetRequestedResamplingMode()\n\n"},
  {"SetFreezeFocalPoint", PyvtkAMRVolumeMapper_SetFreezeFocalPoint, METH_VARARGS,
   "SetFreezeFocalPoint(self, _arg:bool) -> None\nC++: virtual void SetFreezeFocalPoint(bool _arg)\n\n"},
  {"GetFreezeFocalPoint", PyvtkAMRVolumeMapper_GetFreezeFocalPoint, METH_VARARGS,
   "GetFreezeFocalPoint(self) -> bool\nC++: virtual bool GetFreezeFocalPoint()\n\n"},
  {"SetResamplerUpdateTolerance", PyvtkAMRVolumeMapper_SetResamplerUpdateTolerance, METH_VARARGS,
   "SetResamplerUpdateTolerance(self, _arg:float) -> None\nC++: virtual void SetResamplerUpdateTolerance(double _arg)\n\nSets/Gets the tolerance used to determine if the resampler needs\nto be updated. Default is 10e-8\n"},
  {"GetResamplerUpdateTolerance", PyvtkAMRVolumeMapper_GetResamplerUpdateTolerance, METH_VARARGS,
   "GetResamplerUpdateTolerance(self) -> float\nC++: virtual double GetResamplerUpdateTolerance()\n\n"},
  {"SetUseDefaultThreading", PyvtkAMRVolumeMapper_SetUseDefaultThreading, METH_VARARGS,
   "SetUseDefaultThreading(self, _arg:bool) -> None\nC++: virtual void SetUseDefaultThreading(bool _arg)\n\nSets/Gets a flag that indicates the internal volume mapper should\nuse the  default number of threads.  This is useful in\napplications such as ParaView that will turn off multiple threads\nby default. Default is false\n"},
  {"GetUseDefaultThreading", PyvtkAMRVolumeMapper_GetUseDefaultThreading, METH_VARARGS,
   "GetUseDefaultThreading(self) -> bool\nC++: virtual bool GetUseDefaultThreading()\n\n"},
  {"ComputeResamplerBoundsFrustumMethod", PyvtkAMRVolumeMapper_ComputeResamplerBoundsFrustumMethod, METH_VARARGS,
   "ComputeResamplerBoundsFrustumMethod(camera:vtkCamera,\n    renderer:vtkRenderer, data_bounds:(float, float, float, float,\n     float, float), out_bounds:[float, float, float, float, float,\n     float]) -> bool\nC++: static bool ComputeResamplerBoundsFrustumMethod(\n    vtkCamera *camera, vtkRenderer *renderer,\n    const double data_bounds[6], double out_bounds[6])\n\nUtility method used by UpdateResamplerFrustrumMethod() to compute\nthe bounds.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAMRVolumeMapper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("input_data"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetInputData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetInputData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_data"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetInputData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetInputData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_data"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetInputData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetInputData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_connection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetInputConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetInputConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scalar_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetScalarMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetScalarMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScalarMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("blend_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetBlendMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetBlendMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetBlendMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBlendMode/SetBlendMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cropping"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetCropping(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetCropping(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetCropping(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCropping/SetCropping\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cropping_region_planes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetCroppingRegionPlanes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetCroppingRegionPlanes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetCroppingRegionPlanes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCroppingRegionPlanes/SetCroppingRegionPlanes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cropping_region_flags"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetCroppingRegionFlags(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetCroppingRegionFlags(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetCroppingRegionFlags(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCroppingRegionFlags/SetCroppingRegionFlags\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("requested_render_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetRequestedRenderMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetRequestedRenderMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetRequestedRenderMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRequestedRenderMode/SetRequestedRenderMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpolation_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetInterpolationMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetInterpolationMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetInterpolationMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInterpolationMode/SetInterpolationMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("requested_resampling_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetRequestedResamplingMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetRequestedResamplingMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetRequestedResamplingMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRequestedResamplingMode/SetRequestedResamplingMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("freeze_focal_point"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetFreezeFocalPoint(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetFreezeFocalPoint(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetFreezeFocalPoint(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFreezeFocalPoint/SetFreezeFocalPoint\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("resampler_update_tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetResamplerUpdateTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetResamplerUpdateTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetResamplerUpdateTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetResamplerUpdateTolerance/SetResamplerUpdateTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_default_threading"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetUseDefaultThreading(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetUseDefaultThreading(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetUseDefaultThreading(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseDefaultThreading/SetUseDefaultThreading\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("array_access_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetArrayAccessMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetArrayAccessMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("array_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetArrayId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetArrayId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_samples"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRVolumeMapper_GetNumberOfSamples(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRVolumeMapper_SetNumberOfSamples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRVolumeMapper_SetNumberOfSamples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfSamples/SetNumberOfSamples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAMRVolumeMapper_Doc =
  "vtkAMRVolumeMapper - AMR class for a volume mapper\n\n"
  "Superclass: vtkVolumeMapper\n\n"
  "vtkAMRVolumeMapper is the definition of a volume mapper. for AMR\n"
  "Structured Data\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAMRVolumeMapper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingVolumeAMR.vtkAMRVolumeMapper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAMRVolumeMapper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAMRVolumeMapper_StaticNew()
{
  return vtkAMRVolumeMapper::New();
}

PyObject *PyvtkAMRVolumeMapper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAMRVolumeMapper_Type, PyvtkAMRVolumeMapper_Methods,
    "vtkAMRVolumeMapper",
 &PyvtkAMRVolumeMapper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkVolumeMapper");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 7; c++)
  {
    static const struct { const char *name; int value; }
      constants[7] = {
        { "DefaultRenderMode", vtkAMRVolumeMapper::DefaultRenderMode },
        { "RayCastAndTextureRenderMode", vtkAMRVolumeMapper::RayCastAndTextureRenderMode },
        { "RayCastRenderMode", vtkAMRVolumeMapper::RayCastRenderMode },
        { "TextureRenderMode", vtkAMRVolumeMapper::TextureRenderMode },
        { "GPURenderMode", vtkAMRVolumeMapper::GPURenderMode },
        { "UndefinedRenderMode", vtkAMRVolumeMapper::UndefinedRenderMode },
        { "InvalidRenderMode", vtkAMRVolumeMapper::InvalidRenderMode },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAMRVolumeMapper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAMRVolumeMapper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAMRVolumeMapper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAMRVolumeMapper", o) != 0)
  {
    Py_DECREF(o);
  }

}

