// python wrapper for vtkClientServerCompositePass
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkClientServerCompositePass.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkClientServerCompositePass(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkClientServerCompositePass_ClassNew(); }


static PyObject *
PyvtkClientServerCompositePass_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkClientServerCompositePass::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkClientServerCompositePass::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkClientServerCompositePass *tempr = vtkClientServerCompositePass::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkClientServerCompositePass *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkClientServerCompositePass::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkClientServerCompositePass::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkClientServerCompositePass::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_ReleaseGraphicsResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseGraphicsResources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  vtkWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkWindow"))
  {
    if (ap.IsBound())
    {
      op->ReleaseGraphicsResources(temp0);
    }
    else
    {
      op->vtkClientServerCompositePass::ReleaseGraphicsResources(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkClientServerCompositePass::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkClientServerCompositePass::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_SetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  vtkRenderPass *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderPass"))
  {
    if (ap.IsBound())
    {
      op->SetRenderPass(temp0);
    }
    else
    {
      op->vtkClientServerCompositePass::SetRenderPass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_GetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderPass *tempr = (ap.IsBound() ?
      op->GetRenderPass() :
      op->vtkClientServerCompositePass::GetRenderPass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_SetPostProcessingRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPostProcessingRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  vtkRenderPass *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderPass"))
  {
    if (ap.IsBound())
    {
      op->SetPostProcessingRenderPass(temp0);
    }
    else
    {
      op->vtkClientServerCompositePass::SetPostProcessingRenderPass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_GetPostProcessingRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPostProcessingRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderPass *tempr = (ap.IsBound() ?
      op->GetPostProcessingRenderPass() :
      op->vtkClientServerCompositePass::GetPostProcessingRenderPass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_SetProcessIsServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProcessIsServer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProcessIsServer(temp0);
    }
    else
    {
      op->vtkClientServerCompositePass::SetProcessIsServer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_ProcessIsServerOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessIsServerOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ProcessIsServerOn();
    }
    else
    {
      op->vtkClientServerCompositePass::ProcessIsServerOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_ProcessIsServerOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessIsServerOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ProcessIsServerOff();
    }
    else
    {
      op->vtkClientServerCompositePass::ProcessIsServerOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_GetProcessIsServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessIsServer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetProcessIsServer() :
      op->vtkClientServerCompositePass::GetProcessIsServer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_SetServerSideRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerSideRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetServerSideRendering(temp0);
    }
    else
    {
      op->vtkClientServerCompositePass::SetServerSideRendering(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_ServerSideRenderingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ServerSideRenderingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ServerSideRenderingOn();
    }
    else
    {
      op->vtkClientServerCompositePass::ServerSideRenderingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_ServerSideRenderingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ServerSideRenderingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ServerSideRenderingOff();
    }
    else
    {
      op->vtkClientServerCompositePass::ServerSideRenderingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkClientServerCompositePass_GetServerSideRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerSideRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkClientServerCompositePass *op = static_cast<vtkClientServerCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetServerSideRendering() :
      op->vtkClientServerCompositePass::GetServerSideRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkClientServerCompositePass_Methods[] = {
  {"IsTypeOf", PyvtkClientServerCompositePass_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkClientServerCompositePass_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkClientServerCompositePass_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkClientServerCompositePass\nC++: static vtkClientServerCompositePass *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkClientServerCompositePass_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkClientServerCompositePass\nC++: vtkClientServerCompositePass *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkClientServerCompositePass_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkClientServerCompositePass_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ReleaseGraphicsResources", PyvtkClientServerCompositePass_ReleaseGraphicsResources, METH_VARARGS,
   "ReleaseGraphicsResources(self, w:vtkWindow) -> None\nC++: void ReleaseGraphicsResources(vtkWindow *w) override;\n\nRelease graphics resources and ask components to release their\nown resources.\n\\pre w_exists: w!=0\n"},
  {"GetController", PyvtkClientServerCompositePass_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\nController If it is NULL, nothing will be rendered and a warning\nwill be emitted. Initial value is a NULL pointer. This must be\nset to the socket controller used for communicating between the\nclient and the server.\n"},
  {"SetController", PyvtkClientServerCompositePass_SetController, METH_VARARGS,
   "SetController(self, controller:vtkMultiProcessController) -> None\nC++: virtual void SetController(\n    vtkMultiProcessController *controller)\n\n"},
  {"SetRenderPass", PyvtkClientServerCompositePass_SetRenderPass, METH_VARARGS,
   "SetRenderPass(self, __a:vtkRenderPass) -> None\nC++: void SetRenderPass(vtkRenderPass *)\n\nGet/Set the render pass used to do the actual rendering. When\nServerSideRendering is true, the rendering-pass is called only on\nthe server side.\n"},
  {"GetRenderPass", PyvtkClientServerCompositePass_GetRenderPass, METH_VARARGS,
   "GetRenderPass(self) -> vtkRenderPass\nC++: virtual vtkRenderPass *GetRenderPass()\n\n"},
  {"SetPostProcessingRenderPass", PyvtkClientServerCompositePass_SetPostProcessingRenderPass, METH_VARARGS,
   "SetPostProcessingRenderPass(self, __a:vtkRenderPass) -> None\nC++: void SetPostProcessingRenderPass(vtkRenderPass *)\n\nSet/Get the optional post-fetch render pass. On the\nclient-process this is called after the server-side image is\nfetched (if ServerSideRendering is true). On server-process, this\nis called after the image rendered by this->RenderPass is\ndelivered to the client (if ServerSideRendering is true). This is\noptional, so you can set this either on one of the two processes\nor both or neither.\n"},
  {"GetPostProcessingRenderPass", PyvtkClientServerCompositePass_GetPostProcessingRenderPass, METH_VARARGS,
   "GetPostProcessingRenderPass(self) -> vtkRenderPass\nC++: virtual vtkRenderPass *GetPostProcessingRenderPass()\n\n"},
  {"SetProcessIsServer", PyvtkClientServerCompositePass_SetProcessIsServer, METH_VARARGS,
   "SetProcessIsServer(self, _arg:bool) -> None\nC++: virtual void SetProcessIsServer(bool _arg)\n\nSet the current process type. This is needed since when using the\nsocket communicator there's no easy way of determining which\nprocess is the server and which one is the client.\n"},
  {"ProcessIsServerOn", PyvtkClientServerCompositePass_ProcessIsServerOn, METH_VARARGS,
   "ProcessIsServerOn(self) -> None\nC++: virtual void ProcessIsServerOn()\n\n"},
  {"ProcessIsServerOff", PyvtkClientServerCompositePass_ProcessIsServerOff, METH_VARARGS,
   "ProcessIsServerOff(self) -> None\nC++: virtual void ProcessIsServerOff()\n\n"},
  {"GetProcessIsServer", PyvtkClientServerCompositePass_GetProcessIsServer, METH_VARARGS,
   "GetProcessIsServer(self) -> bool\nC++: virtual bool GetProcessIsServer()\n\n"},
  {"SetServerSideRendering", PyvtkClientServerCompositePass_SetServerSideRendering, METH_VARARGS,
   "SetServerSideRendering(self, _arg:bool) -> None\nC++: virtual void SetServerSideRendering(bool _arg)\n\nEnable/Disable fetching of the image from the server side to the\nclient. If this flag is disabled, then this pass just acts as a\n\"pass-through\" pass. This flag must be set to the same value on\nboth the processes.\n"},
  {"ServerSideRenderingOn", PyvtkClientServerCompositePass_ServerSideRenderingOn, METH_VARARGS,
   "ServerSideRenderingOn(self) -> None\nC++: virtual void ServerSideRenderingOn()\n\n"},
  {"ServerSideRenderingOff", PyvtkClientServerCompositePass_ServerSideRenderingOff, METH_VARARGS,
   "ServerSideRenderingOff(self) -> None\nC++: virtual void ServerSideRenderingOff()\n\n"},
  {"GetServerSideRendering", PyvtkClientServerCompositePass_GetServerSideRendering, METH_VARARGS,
   "GetServerSideRendering(self) -> bool\nC++: virtual bool GetServerSideRendering()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkClientServerCompositePass_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkClientServerCompositePass_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkClientServerCompositePass_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkClientServerCompositePass_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkClientServerCompositePass_GetRenderPass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkClientServerCompositePass_SetRenderPass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkClientServerCompositePass_SetRenderPass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderPass/SetRenderPass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("post_processing_render_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkClientServerCompositePass_GetPostProcessingRenderPass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkClientServerCompositePass_SetPostProcessingRenderPass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkClientServerCompositePass_SetPostProcessingRenderPass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPostProcessingRenderPass/SetPostProcessingRenderPass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("process_is_server"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkClientServerCompositePass_GetProcessIsServer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkClientServerCompositePass_SetProcessIsServer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkClientServerCompositePass_SetProcessIsServer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProcessIsServer/SetProcessIsServer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_side_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkClientServerCompositePass_GetServerSideRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkClientServerCompositePass_SetServerSideRendering(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkClientServerCompositePass_SetServerSideRendering(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetServerSideRendering/SetServerSideRendering\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkClientServerCompositePass_Doc =
  "vtkClientServerCompositePass - vtkClientServerCompositePass is a\nrender-pass that can handle client-server image delivery.\n\n"
  "Superclass: vtkRenderPass\n\n"
  "This is designed to be used in configurations in two-processes\n"
  "configurations.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkClientServerCompositePass_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallel.vtkClientServerCompositePass", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkClientServerCompositePass_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkClientServerCompositePass_StaticNew()
{
  return vtkClientServerCompositePass::New();
}

PyObject *PyvtkClientServerCompositePass_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkClientServerCompositePass_Type, PyvtkClientServerCompositePass_Methods,
    "vtkClientServerCompositePass",
 &PyvtkClientServerCompositePass_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkRenderPass");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkClientServerCompositePass_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkClientServerCompositePass(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkClientServerCompositePass_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkClientServerCompositePass", o) != 0)
  {
    Py_DECREF(o);
  }

}

