package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetKmsInstance invokes the kms.GetKmsInstance API synchronously
func (client *Client) GetKmsInstance(request *GetKmsInstanceRequest) (response *GetKmsInstanceResponse, err error) {
	response = CreateGetKmsInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetKmsInstanceWithChan invokes the kms.GetKmsInstance API asynchronously
func (client *Client) GetKmsInstanceWithChan(request *GetKmsInstanceRequest) (<-chan *GetKmsInstanceResponse, <-chan error) {
	responseChan := make(chan *GetKmsInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetKmsInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetKmsInstanceWithCallback invokes the kms.GetKmsInstance API asynchronously
func (client *Client) GetKmsInstanceWithCallback(request *GetKmsInstanceRequest, callback func(response *GetKmsInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetKmsInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetKmsInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetKmsInstanceRequest is the request struct for api GetKmsInstance
type GetKmsInstanceRequest struct {
	*requests.RpcRequest
	KmsInstanceId string `position:"Query" name:"KmsInstanceId"`
}

// GetKmsInstanceResponse is the response struct for api GetKmsInstance
type GetKmsInstanceResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	KmsInstance KmsInstance `json:"KmsInstance" xml:"KmsInstance"`
}

// CreateGetKmsInstanceRequest creates a request to invoke GetKmsInstance API
func CreateGetKmsInstanceRequest() (request *GetKmsInstanceRequest) {
	request = &GetKmsInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "GetKmsInstance", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetKmsInstanceResponse creates a response to parse from GetKmsInstance response
func CreateGetKmsInstanceResponse() (response *GetKmsInstanceResponse) {
	response = &GetKmsInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
