package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePolicy invokes the kms.UpdatePolicy API synchronously
func (client *Client) UpdatePolicy(request *UpdatePolicyRequest) (response *UpdatePolicyResponse, err error) {
	response = CreateUpdatePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePolicyWithChan invokes the kms.UpdatePolicy API asynchronously
func (client *Client) UpdatePolicyWithChan(request *UpdatePolicyRequest) (<-chan *UpdatePolicyResponse, <-chan error) {
	responseChan := make(chan *UpdatePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePolicyWithCallback invokes the kms.UpdatePolicy API asynchronously
func (client *Client) UpdatePolicyWithCallback(request *UpdatePolicyRequest, callback func(response *UpdatePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdatePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePolicyRequest is the request struct for api UpdatePolicy
type UpdatePolicyRequest struct {
	*requests.RpcRequest
	AccessControlRules string `position:"Query" name:"AccessControlRules"`
	Resources          string `position:"Query" name:"Resources"`
	Description        string `position:"Query" name:"Description"`
	Permissions        string `position:"Query" name:"Permissions"`
	Name               string `position:"Query" name:"Name"`
}

// UpdatePolicyResponse is the response struct for api UpdatePolicy
type UpdatePolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdatePolicyRequest creates a request to invoke UpdatePolicy API
func CreateUpdatePolicyRequest() (request *UpdatePolicyRequest) {
	request = &UpdatePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "UpdatePolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePolicyResponse creates a response to parse from UpdatePolicy response
func CreateUpdatePolicyResponse() (response *UpdatePolicyResponse) {
	response = &UpdatePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
