/* Tracking.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Tracking.vala, do not modify */

/* Ported from Chatty*/
/* https://source.puri.sm/Librem5/chatty/-/merge_requests/1229*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_UTILS_TYPE_TRACKING (tuba_utils_tracking_get_type ())
#define TUBA_UTILS_TRACKING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_UTILS_TYPE_TRACKING, TubaUtilsTracking))
#define TUBA_UTILS_TRACKING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_UTILS_TYPE_TRACKING, TubaUtilsTrackingClass))
#define TUBA_UTILS_IS_TRACKING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_UTILS_TYPE_TRACKING))
#define TUBA_UTILS_IS_TRACKING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_UTILS_TYPE_TRACKING))
#define TUBA_UTILS_TRACKING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_UTILS_TYPE_TRACKING, TubaUtilsTrackingClass))

typedef struct _TubaUtilsTracking TubaUtilsTracking;
typedef struct _TubaUtilsTrackingClass TubaUtilsTrackingClass;
typedef struct _TubaUtilsTrackingPrivate TubaUtilsTrackingPrivate;
typedef enum  {
	TUBA_UTILS_TRACKING_CLEANUP_TYPE_STRIP_TRACKING,
	TUBA_UTILS_TRACKING_CLEANUP_TYPE_SPECIFIC_LENGTH
} TubaUtilsTrackingCleanupType;

#define TUBA_UTILS_TRACKING_TYPE_CLEANUP_TYPE (tuba_utils_tracking_cleanup_type_get_type ())
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TubaUtilsParamSpecTracking TubaUtilsParamSpecTracking;

struct _TubaUtilsTracking {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TubaUtilsTrackingPrivate * priv;
};

struct _TubaUtilsTrackingClass {
	GTypeClass parent_class;
	void (*finalize) (TubaUtilsTracking *self);
};

struct _TubaUtilsParamSpecTracking {
	GParamSpec parent_instance;
};

static gpointer tuba_utils_tracking_parent_class = NULL;

VALA_EXTERN gpointer tuba_utils_tracking_ref (gpointer instance);
VALA_EXTERN void tuba_utils_tracking_unref (gpointer instance);
VALA_EXTERN GParamSpec* tuba_utils_param_spec_tracking (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void tuba_utils_value_set_tracking (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void tuba_utils_value_take_tracking (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer tuba_utils_value_get_tracking (const GValue* value);
VALA_EXTERN GType tuba_utils_tracking_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaUtilsTracking, tuba_utils_tracking_unref)
VALA_EXTERN GType tuba_utils_tracking_cleanup_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* tuba_utils_tracking_strip_utm (const gchar* url);
VALA_EXTERN GUri* tuba_utils_tracking_strip_utm_from_uri (GUri* uri,
                                              GError** error);
VALA_EXTERN gchar* tuba_utils_tracking_strip_utm_fallback (const gchar* url);
static void _vala_array_add37 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN GUri** tuba_utils_tracking_extract_uris (const gchar* content,
                                         gint* result_length1);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void _vala_array_add38 (GUri** * array,
                        gint* length,
                        gint* size,
                        GUri* value);
VALA_EXTERN gchar* tuba_utils_tracking_cleanup_content_with_uris (gchar* content,
                                                      GUri** uris,
                                                      gint uris_length1,
                                                      TubaUtilsTrackingCleanupType cleanup_type,
                                                      gint characters_reserved_per_url);
VALA_EXTERN TubaUtilsTracking* tuba_utils_tracking_new (void);
VALA_EXTERN TubaUtilsTracking* tuba_utils_tracking_construct (GType object_type);
static void tuba_utils_tracking_finalize (TubaUtilsTracking * obj);
static GType tuba_utils_tracking_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar* TUBA_UTILS_TRACKING_TRACKING_IDS[46] = {"utm_", "fbclid", "gclid", "msclkid", "mc_eid", "mibexid", "dclid", "oly_anon_id", "oly_enc_id", "_openstat", "vero_conv", "vero_id", "wickedid", "yclid", "__s", "rb_clickid", "s_cid", "ml_subscriber", "ml_subscriber_hash", "twclid", "gbraid", "wbraid", "_hsenc", "__hssc", "__hstc", "__hsfp", "hsCtaTracking", "oft_id", "oft_k", "oft_lk", "oft_d", "oft_c", "oft_ck", "oft_ids", "oft_sk", "igshid", "ad_id", "adset_id", "campaign_id", "ad_name", "adset_name", "campaign_name", "placement", "share_id", "ref", "ref_share"};
static const gchar* TUBA_UTILS_TRACKING_ALLOWED_SCHEMES[2] = {"http", "https"};

 G_GNUC_NO_INLINE static GType
tuba_utils_tracking_cleanup_type_get_type_once (void)
{
	static const GEnumValue values[] = {{TUBA_UTILS_TRACKING_CLEANUP_TYPE_STRIP_TRACKING, "TUBA_UTILS_TRACKING_CLEANUP_TYPE_STRIP_TRACKING", "strip-tracking"}, {TUBA_UTILS_TRACKING_CLEANUP_TYPE_SPECIFIC_LENGTH, "TUBA_UTILS_TRACKING_CLEANUP_TYPE_SPECIFIC_LENGTH", "specific-length"}, {0, NULL, NULL}};
	GType tuba_utils_tracking_cleanup_type_type_id;
	tuba_utils_tracking_cleanup_type_type_id = g_enum_register_static ("TubaUtilsTrackingCleanupType", values);
	return tuba_utils_tracking_cleanup_type_type_id;
}

GType
tuba_utils_tracking_cleanup_type_get_type (void)
{
	static gsize tuba_utils_tracking_cleanup_type_type_id__once = 0;
	if (g_once_init_enter (&tuba_utils_tracking_cleanup_type_type_id__once)) {
		GType tuba_utils_tracking_cleanup_type_type_id;
		tuba_utils_tracking_cleanup_type_type_id = tuba_utils_tracking_cleanup_type_get_type_once ();
		g_once_init_leave (&tuba_utils_tracking_cleanup_type_type_id__once, tuba_utils_tracking_cleanup_type_type_id);
	}
	return tuba_utils_tracking_cleanup_type_type_id__once;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
tuba_utils_tracking_strip_utm (const gchar* url)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (url != NULL, NULL);
	if (!string_contains (url, "?")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (url);
		result = _tmp0_;
		return result;
	}
	{
		GUri* uri = NULL;
		GUri* _tmp1_;
		GUri* _tmp2_ = NULL;
		GUri* _tmp3_;
		GUri* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_uri_parse (url, G_URI_FLAGS_NONE, &_inner_error0_);
		uri = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = uri;
		_tmp4_ = tuba_utils_tracking_strip_utm_from_uri (_tmp3_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_uri_unref0 (uri);
			goto __catch0_g_error;
		}
		_tmp5_ = g_uri_to_string (_tmp2_);
		result = _tmp5_;
		_g_uri_unref0 (_tmp2_);
		_g_uri_unref0 (uri);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp6_ = tuba_utils_tracking_strip_utm_fallback (url);
		result = _tmp6_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_vala_array_add37 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

GUri*
tuba_utils_tracking_strip_utm_from_uri (GUri* uri,
                                        GError** error)
{
	gchar** res_params = NULL;
	gchar** _tmp0_;
	gint res_params_length1;
	gint _res_params_size_;
	gchar* query = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp19_ = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* res_query = NULL;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GUri* _tmp30_;
	GError* _inner_error0_ = NULL;
	GUri* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	res_params = _tmp0_;
	res_params_length1 = 0;
	_res_params_size_ = res_params_length1;
	_tmp1_ = g_uri_get_query (uri);
	_tmp2_ = g_strdup (_tmp1_);
	query = _tmp2_;
	_tmp3_ = query;
	if (_tmp3_ != NULL) {
		GUriParamsIter iter = {0};
		const gchar* _tmp4_;
		gchar* key = NULL;
		gchar* val = NULL;
		_tmp4_ = query;
		g_uri_params_iter_init (&iter, _tmp4_, -1, "&;", 0);
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gboolean _tmp8_;
			gboolean not_tracking_id = FALSE;
			_tmp8_ = g_uri_params_iter_next (&iter, &_tmp6_, &_tmp7_, &_inner_error0_);
			_g_free0 (key);
			key = _tmp6_;
			_g_free0 (val);
			val = _tmp7_;
			_tmp5_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (val);
				_g_free0 (key);
				_g_free0 (query);
				res_params = (_vala_array_free (res_params, res_params_length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			}
			if (!_tmp5_) {
				break;
			}
			not_tracking_id = TRUE;
			{
				const gchar** id_collection = NULL;
				gint id_collection_length1 = 0;
				gint _id_collection_size_ = 0;
				gint id_it = 0;
				id_collection = TUBA_UTILS_TRACKING_TRACKING_IDS;
				id_collection_length1 = G_N_ELEMENTS (TUBA_UTILS_TRACKING_TRACKING_IDS);
				for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
					const gchar* id = NULL;
					id = id_collection[id_it];
					{
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						const gchar* _tmp12_;
						gboolean _tmp13_;
						_tmp9_ = key;
						_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
						_tmp11_ = _tmp10_;
						_tmp12_ = id;
						_tmp13_ = string_contains (_tmp11_, _tmp12_);
						_g_free0 (_tmp11_);
						if (_tmp13_) {
							not_tracking_id = FALSE;
							break;
						}
					}
				}
			}
			if (not_tracking_id) {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = key;
				_tmp15_ = string_to_string (_tmp14_);
				_tmp16_ = val;
				_tmp17_ = string_to_string (_tmp16_);
				_tmp18_ = g_strconcat (_tmp15_, "=", _tmp17_, NULL);
				_vala_array_add37 (&res_params, &res_params_length1, &_res_params_size_, _tmp18_);
			}
		}
		_g_free0 (val);
		_g_free0 (key);
	}
	_tmp20_ = res_params;
	_tmp20__length1 = res_params_length1;
	if (_tmp20__length1 > 0) {
		gchar** _tmp21_;
		gint _tmp21__length1;
		gchar* _tmp22_;
		_tmp21_ = res_params;
		_tmp21__length1 = res_params_length1;
		_tmp22_ = _vala_g_strjoinv ("&", _tmp21_, (gint) _tmp21__length1);
		_g_free0 (_tmp19_);
		_tmp19_ = _tmp22_;
	} else {
		_g_free0 (_tmp19_);
		_tmp19_ = NULL;
	}
	_tmp23_ = g_strdup (_tmp19_);
	res_query = _tmp23_;
	_tmp24_ = g_uri_get_scheme (uri);
	_tmp25_ = g_uri_get_userinfo (uri);
	_tmp26_ = g_uri_get_host (uri);
	_tmp27_ = g_uri_get_path (uri);
	_tmp28_ = res_query;
	_tmp29_ = g_uri_get_fragment (uri);
	_tmp30_ = g_uri_build (g_uri_get_flags (uri), _tmp24_, _tmp25_, _tmp26_, g_uri_get_port (uri), _tmp27_, _tmp28_, _tmp29_);
	result = _tmp30_;
	_g_free0 (res_query);
	_g_free0 (_tmp19_);
	_g_free0 (query);
	res_params = (_vala_array_free (res_params, res_params_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
tuba_utils_tracking_strip_utm_fallback (const gchar* url)
{
	gchar** split_url = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint split_url_length1;
	gint _split_url_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* str = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gint fragment_offset = 0;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* fragment = NULL;
	gchar* _tmp11_;
	gchar** query_params = NULL;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint query_params_length1;
	gint _query_params_size_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* result;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit_set (url, "?", 2);
	split_url = _tmp1_;
	split_url_length1 = _vala_array_length (_tmp0_);
	_split_url_size_ = split_url_length1;
	_tmp2_ = split_url;
	_tmp2__length1 = split_url_length1;
	_tmp3_ = _tmp2_[1];
	if (string_index_of_char (_tmp3_, (gunichar) '=', 0) == -1) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (url);
		result = _tmp4_;
		split_url = (_vala_array_free (split_url, split_url_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp5_ = split_url;
	_tmp5__length1 = split_url_length1;
	_tmp6_ = _tmp5_[0];
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat (_tmp7_, "?", NULL);
	str = _tmp8_;
	_tmp9_ = split_url;
	_tmp9__length1 = split_url_length1;
	_tmp10_ = _tmp9_[1];
	fragment_offset = string_last_index_of_char (_tmp10_, (gunichar) '#', 0);
	_tmp11_ = g_strdup ("");
	fragment = _tmp11_;
	if (fragment_offset > -1) {
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp12_ = split_url;
		_tmp12__length1 = split_url_length1;
		_tmp13_ = _tmp12_[1];
		_tmp14_ = string_substring (_tmp13_, (glong) fragment_offset, (glong) -1);
		_g_free0 (fragment);
		fragment = _tmp14_;
		_tmp15_ = split_url;
		_tmp15__length1 = split_url_length1;
		_tmp16_ = split_url;
		_tmp16__length1 = split_url_length1;
		_tmp17_ = _tmp16_[1];
		_tmp18_ = string_slice (_tmp17_, (glong) 0, (glong) fragment_offset);
		_g_free0 (_tmp15_[1]);
		_tmp15_[1] = _tmp18_;
	}
	_tmp19_ = split_url;
	_tmp19__length1 = split_url_length1;
	_tmp20_ = _tmp19_[1];
	_tmp22_ = _tmp21_ = g_strsplit_set (_tmp20_, "&", 0);
	query_params = _tmp22_;
	query_params_length1 = _vala_array_length (_tmp21_);
	_query_params_size_ = query_params_length1;
	_tmp23_ = query_params;
	_tmp23__length1 = query_params_length1;
	{
		gchar** param_collection = NULL;
		gint param_collection_length1 = 0;
		gint _param_collection_size_ = 0;
		gint param_it = 0;
		param_collection = _tmp23_;
		param_collection_length1 = _tmp23__length1;
		for (param_it = 0; param_it < param_collection_length1; param_it = param_it + 1) {
			gchar* _tmp24_;
			gchar* param = NULL;
			_tmp24_ = g_strdup (param_collection[param_it]);
			param = _tmp24_;
			{
				gboolean not_tracking_id = FALSE;
				not_tracking_id = TRUE;
				{
					const gchar** id_collection = NULL;
					gint id_collection_length1 = 0;
					gint _id_collection_size_ = 0;
					gint id_it = 0;
					id_collection = TUBA_UTILS_TRACKING_TRACKING_IDS;
					id_collection_length1 = G_N_ELEMENTS (TUBA_UTILS_TRACKING_TRACKING_IDS);
					for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
						const gchar* id = NULL;
						id = id_collection[id_it];
						{
							gint index_of_eq = 0;
							const gchar* _tmp25_;
							gboolean _tmp26_ = FALSE;
							_tmp25_ = param;
							index_of_eq = string_index_of_char (_tmp25_, (gunichar) '=', 0);
							if (index_of_eq > -1) {
								const gchar* _tmp27_;
								gchar* _tmp28_;
								gchar* _tmp29_;
								gchar* _tmp30_;
								gchar* _tmp31_;
								const gchar* _tmp32_;
								_tmp27_ = param;
								_tmp28_ = string_slice (_tmp27_, (glong) 0, (glong) index_of_eq);
								_tmp29_ = _tmp28_;
								_tmp30_ = g_utf8_strdown (_tmp29_, (gssize) -1);
								_tmp31_ = _tmp30_;
								_tmp32_ = id;
								_tmp26_ = string_contains (_tmp31_, _tmp32_);
								_g_free0 (_tmp31_);
								_g_free0 (_tmp29_);
							} else {
								_tmp26_ = FALSE;
							}
							if (_tmp26_) {
								not_tracking_id = FALSE;
								break;
							}
						}
					}
				}
				if (not_tracking_id) {
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp33_ = str;
					_tmp34_ = param;
					_tmp35_ = string_to_string (_tmp34_);
					_tmp36_ = g_strconcat (_tmp35_, "&", NULL);
					_tmp37_ = _tmp36_;
					_tmp38_ = g_strconcat (_tmp33_, _tmp37_, NULL);
					_g_free0 (str);
					str = _tmp38_;
					_g_free0 (_tmp37_);
				}
				_g_free0 (param);
			}
		}
	}
	_tmp39_ = str;
	_tmp40_ = string_slice (_tmp39_, (glong) 0, (glong) -1);
	_tmp41_ = _tmp40_;
	_tmp42_ = string_to_string (_tmp41_);
	_tmp43_ = fragment;
	_tmp44_ = string_to_string (_tmp43_);
	_tmp45_ = g_strconcat (_tmp42_, _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	_g_free0 (_tmp41_);
	result = _tmp46_;
	query_params = (_vala_array_free (query_params, query_params_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fragment);
	_g_free0 (str);
	split_url = (_vala_array_free (split_url, split_url_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gpointer
_g_uri_ref0 (gpointer self)
{
	return self ? g_uri_ref (self) : NULL;
}

static void
_vala_array_add38 (GUri** * array,
                   gint* length,
                   gint* size,
                   GUri* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GUri*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GUri**
tuba_utils_tracking_extract_uris (const gchar* content,
                                  gint* result_length1)
{
	GUri** res = NULL;
	GUri** _tmp0_;
	gint res_length1;
	gint _res_size_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	GUri** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	GUri** result;
	g_return_val_if_fail (content != NULL, NULL);
	_tmp0_ = g_new0 (GUri*, 0 + 1);
	res = _tmp0_;
	res_length1 = 0;
	_res_size_ = res_length1;
	_tmp2_ = strlen (content);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !string_contains (content, "://");
	}
	if (_tmp1_) {
		GUri** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = res;
		_tmp4__length1 = res_length1;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp6_ = _tmp5_ = g_strsplit_set (content, " \n\r\t'\"()[]", 0);
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
		word_collection = _tmp6_;
		word_collection_length1 = _vala_array_length (_tmp5_);
		for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
			gchar* _tmp7_;
			gchar* word = NULL;
			_tmp7_ = g_strdup (word_collection[word_it]);
			word = _tmp7_;
			{
				const gchar* _tmp8_;
				_tmp8_ = word;
				if (!string_contains (_tmp8_, "://")) {
					_g_free0 (word);
					continue;
				}
				{
					GUri* uri = NULL;
					const gchar* _tmp9_;
					GUri* _tmp10_;
					GUri* _tmp11_;
					const gchar* _tmp12_;
					_tmp9_ = word;
					_tmp10_ = g_uri_parse (_tmp9_, G_URI_FLAGS_ENCODED, &_inner_error0_);
					uri = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp11_ = uri;
					_tmp12_ = g_uri_get_scheme (_tmp11_);
					if (_vala_string_array_contains (TUBA_UTILS_TRACKING_ALLOWED_SCHEMES, G_N_ELEMENTS (TUBA_UTILS_TRACKING_ALLOWED_SCHEMES), _tmp12_)) {
						GUri* _tmp13_;
						GUri* _tmp14_;
						_tmp13_ = uri;
						_tmp14_ = _g_uri_ref0 (_tmp13_);
						_vala_array_add38 (&res, &res_length1, &_res_size_, _tmp14_);
					}
					_g_uri_unref0 (uri);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (word);
					word_collection = (_vala_array_free (word_collection, word_collection_length1, (GDestroyNotify) g_free), NULL);
					res = (_vala_array_free (res, res_length1, (GDestroyNotify) g_uri_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (word);
			}
		}
		word_collection = (_vala_array_free (word_collection, word_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp15_ = res;
	_tmp15__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
tuba_utils_tracking_cleanup_content_with_uris (gchar* content,
                                               GUri** uris,
                                               gint uris_length1,
                                               TubaUtilsTrackingCleanupType cleanup_type,
                                               gint characters_reserved_per_url)
{
	gint last_index = 0;
	gchar* _tmp36_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (content != NULL, NULL);
	if (uris_length1 == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (content);
		result = _tmp0_;
		_g_free0 (content);
		return result;
	}
	last_index = 0;
	switch (cleanup_type) {
		case TUBA_UTILS_TRACKING_CLEANUP_TYPE_STRIP_TRACKING:
		{
			{
				GUri** uri_collection = NULL;
				gint uri_collection_length1 = 0;
				gint _uri_collection_size_ = 0;
				gint uri_it = 0;
				uri_collection = uris;
				uri_collection_length1 = uris_length1;
				for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
					GUri* _tmp1_;
					GUri* uri = NULL;
					_tmp1_ = _g_uri_ref0 (uri_collection[uri_it]);
					uri = _tmp1_;
					{
						GUri* _tmp2_;
						const gchar* _tmp3_;
						_tmp2_ = uri;
						_tmp3_ = g_uri_get_query (_tmp2_);
						if (_tmp3_ == NULL) {
							_g_uri_unref0 (uri);
							continue;
						}
						{
							GUri* _tmp4_ = NULL;
							GUri* _tmp5_;
							GUri* _tmp6_;
							gchar* stripped = NULL;
							gchar* _tmp7_;
							gchar* original = NULL;
							GUri* _tmp8_;
							gchar* _tmp9_;
							const gchar* _tmp10_;
							GString* builder = NULL;
							GString* _tmp11_;
							GString* _tmp12_;
							const gchar* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							GString* _tmp16_;
							const gchar* _tmp17_;
							GString* _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							_tmp5_ = uri;
							_tmp6_ = tuba_utils_tracking_strip_utm_from_uri (_tmp5_, &_inner_error0_);
							_tmp4_ = _tmp6_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
							_tmp7_ = g_uri_to_string (_tmp4_);
							stripped = _tmp7_;
							_tmp8_ = uri;
							_tmp9_ = g_uri_to_string (_tmp8_);
							original = _tmp9_;
							_tmp10_ = original;
							last_index = string_index_of (content, _tmp10_, last_index);
							if (last_index == -1) {
								last_index = 0;
								_g_free0 (original);
								_g_free0 (stripped);
								_g_uri_unref0 (_tmp4_);
								_g_uri_unref0 (uri);
								continue;
							}
							_tmp11_ = g_string_new (content);
							builder = _tmp11_;
							_tmp12_ = builder;
							_tmp13_ = original;
							_tmp14_ = strlen (_tmp13_);
							_tmp15_ = _tmp14_;
							g_string_erase (_tmp12_, (gssize) last_index, (gssize) _tmp15_);
							_tmp16_ = builder;
							_tmp17_ = stripped;
							g_string_insert (_tmp16_, (gssize) last_index, _tmp17_);
							_tmp18_ = builder;
							_tmp19_ = _tmp18_->str;
							_tmp20_ = g_strdup (_tmp19_);
							_g_free0 (content);
							content = _tmp20_;
							_g_string_free0 (builder);
							_g_free0 (original);
							_g_free0 (stripped);
							_g_uri_unref0 (_tmp4_);
						}
						goto __finally0;
						__catch0_g_error:
						{
							g_clear_error (&_inner_error0_);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_uri_unref0 (uri);
							_g_free0 (content);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_g_uri_unref0 (uri);
					}
				}
			}
			break;
		}
		case TUBA_UTILS_TRACKING_CLEANUP_TYPE_SPECIFIC_LENGTH:
		{
			gchar* replacement = NULL;
			gchar* _tmp21_;
			if (characters_reserved_per_url <= 0) {
				break;
			}
			_tmp21_ = g_strnfill ((gsize) characters_reserved_per_url, 'X');
			replacement = _tmp21_;
			{
				GUri** uri_collection = NULL;
				gint uri_collection_length1 = 0;
				gint _uri_collection_size_ = 0;
				gint uri_it = 0;
				uri_collection = uris;
				uri_collection_length1 = uris_length1;
				for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
					GUri* _tmp22_;
					GUri* uri = NULL;
					_tmp22_ = _g_uri_ref0 (uri_collection[uri_it]);
					uri = _tmp22_;
					{
						gchar* original = NULL;
						GUri* _tmp23_;
						gchar* _tmp24_;
						const gchar* _tmp25_;
						GString* builder = NULL;
						GString* _tmp26_;
						GString* _tmp27_;
						const gchar* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						GString* _tmp31_;
						const gchar* _tmp32_;
						GString* _tmp33_;
						const gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp23_ = uri;
						_tmp24_ = g_uri_to_string (_tmp23_);
						original = _tmp24_;
						_tmp25_ = original;
						last_index = string_index_of (content, _tmp25_, last_index);
						if (last_index == -1) {
							last_index = 0;
							_g_free0 (original);
							_g_uri_unref0 (uri);
							continue;
						}
						_tmp26_ = g_string_new (content);
						builder = _tmp26_;
						_tmp27_ = builder;
						_tmp28_ = original;
						_tmp29_ = strlen (_tmp28_);
						_tmp30_ = _tmp29_;
						g_string_erase (_tmp27_, (gssize) last_index, (gssize) _tmp30_);
						_tmp31_ = builder;
						_tmp32_ = replacement;
						g_string_insert (_tmp31_, (gssize) last_index, _tmp32_);
						_tmp33_ = builder;
						_tmp34_ = _tmp33_->str;
						_tmp35_ = g_strdup (_tmp34_);
						_g_free0 (content);
						content = _tmp35_;
						_g_string_free0 (builder);
						_g_free0 (original);
						_g_uri_unref0 (uri);
					}
				}
			}
			_g_free0 (replacement);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp36_ = g_strdup (content);
	result = _tmp36_;
	_g_free0 (content);
	return result;
}

TubaUtilsTracking*
tuba_utils_tracking_construct (GType object_type)
{
	TubaUtilsTracking* self = NULL;
	self = (TubaUtilsTracking*) g_type_create_instance (object_type);
	return self;
}

TubaUtilsTracking*
tuba_utils_tracking_new (void)
{
	return tuba_utils_tracking_construct (TUBA_UTILS_TYPE_TRACKING);
}

static void
tuba_utils_value_tracking_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tuba_utils_value_tracking_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tuba_utils_tracking_unref (value->data[0].v_pointer);
	}
}

static void
tuba_utils_value_tracking_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tuba_utils_tracking_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tuba_utils_value_tracking_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tuba_utils_value_tracking_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TubaUtilsTracking * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tuba_utils_tracking_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tuba_utils_value_tracking_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	TubaUtilsTracking ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tuba_utils_tracking_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tuba_utils_param_spec_tracking (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	TubaUtilsParamSpecTracking* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TUBA_UTILS_TYPE_TRACKING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tuba_utils_value_get_tracking (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_UTILS_TYPE_TRACKING), NULL);
	return value->data[0].v_pointer;
}

void
tuba_utils_value_set_tracking (GValue* value,
                               gpointer v_object)
{
	TubaUtilsTracking * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_UTILS_TYPE_TRACKING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_UTILS_TYPE_TRACKING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tuba_utils_tracking_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_utils_tracking_unref (old);
	}
}

void
tuba_utils_value_take_tracking (GValue* value,
                                gpointer v_object)
{
	TubaUtilsTracking * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_UTILS_TYPE_TRACKING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_UTILS_TYPE_TRACKING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_utils_tracking_unref (old);
	}
}

static void
tuba_utils_tracking_class_init (TubaUtilsTrackingClass * klass,
                                gpointer klass_data)
{
	tuba_utils_tracking_parent_class = g_type_class_peek_parent (klass);
	((TubaUtilsTrackingClass *) klass)->finalize = tuba_utils_tracking_finalize;
}

static void
tuba_utils_tracking_instance_init (TubaUtilsTracking * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
tuba_utils_tracking_finalize (TubaUtilsTracking * obj)
{
	TubaUtilsTracking * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_UTILS_TYPE_TRACKING, TubaUtilsTracking);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
tuba_utils_tracking_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tuba_utils_value_tracking_init, tuba_utils_value_tracking_free_value, tuba_utils_value_tracking_copy_value, tuba_utils_value_tracking_peek_pointer, "p", tuba_utils_value_tracking_collect_value, "p", tuba_utils_value_tracking_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TubaUtilsTrackingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_utils_tracking_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaUtilsTracking), 0, (GInstanceInitFunc) tuba_utils_tracking_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tuba_utils_tracking_type_id;
	tuba_utils_tracking_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TubaUtilsTracking", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tuba_utils_tracking_type_id;
}

GType
tuba_utils_tracking_get_type (void)
{
	static gsize tuba_utils_tracking_type_id__once = 0;
	if (g_once_init_enter (&tuba_utils_tracking_type_id__once)) {
		GType tuba_utils_tracking_type_id;
		tuba_utils_tracking_type_id = tuba_utils_tracking_get_type_once ();
		g_once_init_leave (&tuba_utils_tracking_type_id__once, tuba_utils_tracking_type_id);
	}
	return tuba_utils_tracking_type_id__once;
}

gpointer
tuba_utils_tracking_ref (gpointer instance)
{
	TubaUtilsTracking * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tuba_utils_tracking_unref (gpointer instance)
{
	TubaUtilsTracking * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TUBA_UTILS_TRACKING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

