// python wrapper for ttkJacobiSet
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkJacobiSet.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkJacobiSet(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkJacobiSet_ClassNew(); }


static PyObject *
PyttkJacobiSet_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkJacobiSet::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkJacobiSet::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkJacobiSet *tempr = ttkJacobiSet::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkJacobiSet *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkJacobiSet::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkJacobiSet::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkJacobiSet::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkJacobiSet::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkJacobiSet::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_SetEdgeIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEdgeIds(temp0);
    }
    else
    {
      op->ttkJacobiSet::SetEdgeIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_GetEdgeIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEdgeIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEdgeIds() :
      op->ttkJacobiSet::GetEdgeIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_SetVertexScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVertexScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVertexScalars(temp0);
    }
    else
    {
      op->ttkJacobiSet::SetVertexScalars(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkJacobiSet_GetVertexScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVertexScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkJacobiSet *op = static_cast<ttkJacobiSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVertexScalars() :
      op->ttkJacobiSet::GetVertexScalars());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkJacobiSet_Methods[] = {
  {"IsTypeOf", PyttkJacobiSet_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkJacobiSet_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkJacobiSet_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkJacobiSet\nC++: static ttkJacobiSet *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkJacobiSet_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkJacobiSet\nC++: ttkJacobiSet *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkJacobiSet_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkJacobiSet_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetForceInputOffsetScalarField", PyttkJacobiSet_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetForceInputOffsetScalarField", PyttkJacobiSet_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"SetEdgeIds", PyttkJacobiSet_SetEdgeIds, METH_VARARGS,
   "SetEdgeIds(self, _arg:bool) -> None\nC++: virtual void SetEdgeIds(bool _arg)\n\n"},
  {"GetEdgeIds", PyttkJacobiSet_GetEdgeIds, METH_VARARGS,
   "GetEdgeIds(self) -> bool\nC++: virtual bool GetEdgeIds()\n\n"},
  {"SetVertexScalars", PyttkJacobiSet_SetVertexScalars, METH_VARARGS,
   "SetVertexScalars(self, _arg:bool) -> None\nC++: virtual void SetVertexScalars(bool _arg)\n\n"},
  {"GetVertexScalars", PyttkJacobiSet_GetVertexScalars, METH_VARARGS,
   "GetVertexScalars(self) -> bool\nC++: virtual bool GetVertexScalars()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkJacobiSet_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkJacobiSet_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkJacobiSet_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkJacobiSet_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkJacobiSet_GetEdgeIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkJacobiSet_SetEdgeIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkJacobiSet_SetEdgeIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEdgeIds/SetEdgeIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("vertex_scalars"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkJacobiSet_GetVertexScalars(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkJacobiSet_SetVertexScalars(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkJacobiSet_SetVertexScalars(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVertexScalars/SetVertexScalars\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkJacobiSet_Doc =
  "ttkJacobiSet - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date May 2015.\n\n"
  "TTK VTK-filter that computes the Jacobi set of a bivariate\n"
  "volumetric data-set.\n\n"
  "Given a bivariate scalar field defined on a PL 3-manifold, this\n"
  "filter produces the list of Jacobi edges (each entry is a pair given\n"
  "by the edge identifier and the Jacobi edge type).\n\n"
  "The input bivariate data must be provided as two independent scalar\n"
  "fields attached as point data to the input geometry.\n\n"
  "\\param Input Input bivariate volumetric data (vtkDataSet)\n"
  "\\param Output Output Jacobi set (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "The input data arrays needs to be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 for the U Component, 1 for the V Component\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The optional offset arrays can be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 2 for the U Offset Field, 3 for the V Offset Field\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the offset array)\n\n"
  "ote: To use this optional array, `ForceInputOffsetScalarField` needs\n"
  "to be\n"
  "enabled with the setter `setForceInputOffsetScalarField()'.\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Jacobi sets of multiple Morse functions\"\n\n"
  "Herbert Edelsbrunner, John Harer\n\n"
  "Foundations of Computational Mathematics. Cambridge University Press,\n"
  "2002.\n\n"
  "\\sa ttk::JacobiSet\n"
  "\\sa vtkReebSpace\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/builtInExample2/\"\n"
  "  > Builtin example 2\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkJacobiSet_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkJacobiSet.ttkJacobiSet", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkJacobiSet_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkJacobiSet_StaticNew()
{
  return ttkJacobiSet::New();
}

PyObject *PyttkJacobiSet_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkJacobiSet_Type, PyttkJacobiSet_Methods,
    "ttkJacobiSet",
 &PyttkJacobiSet_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkJacobiSet_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkJacobiSet(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkJacobiSet_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkJacobiSet", o) != 0)
  {
    Py_DECREF(o);
  }

}

