/* CronTab.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CronTab.vala, do not modify */

/*
 * CronTab.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CRON_TAB (cron_tab_get_type ())
#define CRON_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRON_TAB, CronTab))
#define CRON_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRON_TAB, CronTabClass))
#define IS_CRON_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRON_TAB))
#define IS_CRON_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRON_TAB))
#define CRON_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRON_TAB, CronTabClass))

typedef struct _CronTab CronTab;
typedef struct _CronTabClass CronTabClass;
typedef struct _CronTabPrivate CronTabPrivate;
enum  {
	CRON_TAB_0_PROPERTY,
	CRON_TAB_NUM_PROPERTIES
};
static GParamSpec* cron_tab_properties[CRON_TAB_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _CronTab {
	GObject parent_instance;
	CronTabPrivate * priv;
};

struct _CronTabClass {
	GObjectClass parent_class;
};

static gpointer cron_tab_parent_class = NULL;
VALA_EXTERN gchar* cron_tab_crontab_text;
gchar* cron_tab_crontab_text = NULL;

VALA_EXTERN GType cron_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CronTab, g_object_unref)
VALA_EXTERN void cron_tab_clear_cached_text (void);
VALA_EXTERN gchar* cron_tab_crontab_read_all (const gchar* user_name);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gint tee_jee_process_helper_exec_sync (const gchar* cmd,
                                       gchar** std_out,
                                       gchar** std_err);
VALA_EXTERN gboolean cron_tab_has_job (const gchar* entry,
                           gboolean partial_match,
                           gboolean use_cached_text);
VALA_EXTERN gboolean cron_tab_add_job (const gchar* entry,
                           gboolean use_cached_text);
VALA_EXTERN gchar* tee_jee_process_helper_get_temp_file_path (void);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gboolean cron_tab_remove_job (const gchar* entry,
                              gboolean use_regex,
                              gboolean use_cached_text);
VALA_EXTERN gboolean cron_tab_install (const gchar* file_path,
                           const gchar* user_name);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gboolean cron_tab_export (const gchar* file_path,
                          const gchar* user_name);
VALA_EXTERN gboolean tee_jee_file_system_file_delete (const gchar* file_path);
VALA_EXTERN gboolean cron_tab_import (const gchar* file_path,
                          const gchar* user_name);
VALA_EXTERN gboolean cron_tab_add_script_file (const gchar* file_name,
                                   const gchar* cron_dir_type,
                                   const gchar* text,
                                   gboolean stop_cron_emails);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN gboolean cron_tab_remove_script_file (const gchar* file_name,
                                      const gchar* cron_dir_type);
VALA_EXTERN CronTab* cron_tab_new (void);
VALA_EXTERN CronTab* cron_tab_construct (GType object_type);
static void cron_tab_finalize (GObject * obj);
static GType cron_tab_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
cron_tab_clear_cached_text (void)
{
	_g_free0 (cron_tab_crontab_text);
	cron_tab_crontab_text = NULL;
}

gchar*
cron_tab_crontab_read_all (const gchar* user_name)
{
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp7_;
	gint ret_val = 0;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint _tmp11_;
	gchar* result;
	g_return_val_if_fail (user_name != NULL, NULL);
	_tmp0_ = g_strdup ("crontab -l");
	cmd = _tmp0_;
	_tmp1_ = strlen (user_name);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = cmd;
		_tmp4_ = g_strdup_printf (" -u %s", user_name);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
		_g_free0 (cmd);
		cmd = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = cmd;
	tee_jee_logging_log_debug (_tmp7_);
	_tmp8_ = cmd;
	_tmp11_ = tee_jee_process_helper_exec_sync (_tmp8_, &_tmp9_, &_tmp10_);
	_g_free0 (std_out);
	std_out = _tmp9_;
	_g_free0 (std_err);
	std_err = _tmp10_;
	ret_val = _tmp11_;
	if (ret_val != 0) {
		gchar* _tmp12_;
		tee_jee_logging_log_debug (_ ("Failed to read cron tab"));
		_tmp12_ = g_strdup ("");
		result = _tmp12_;
		_g_free0 (cmd);
		_g_free0 (std_err);
		_g_free0 (std_out);
		return result;
	} else {
		result = std_out;
		_g_free0 (cmd);
		_g_free0 (std_err);
		return result;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
cron_tab_has_job (const gchar* entry,
                  gboolean partial_match,
                  gboolean use_cached_text)
{
	gchar* tab = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* lines = NULL;
	GeeArrayList* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gboolean result;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	tab = _tmp0_;
	if (use_cached_text) {
		const gchar* _tmp2_;
		_tmp2_ = cron_tab_crontab_text;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = cron_tab_crontab_text;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (tab);
		tab = _tmp4_;
	} else {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = cron_tab_crontab_read_all ("");
		_g_free0 (cron_tab_crontab_text);
		cron_tab_crontab_text = _tmp5_;
		_tmp6_ = cron_tab_crontab_text;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (tab);
		tab = _tmp7_;
	}
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	lines = _tmp8_;
	_tmp9_ = tab;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp11_;
		line_collection_length1 = _vala_array_length (_tmp10_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp12_;
			gchar* line = NULL;
			_tmp12_ = g_strdup (line_collection[line_it]);
			line = _tmp12_;
			{
				GeeArrayList* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = lines;
				_tmp14_ = line;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp15_;
		gint _line_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _line_index = 0;
		_tmp15_ = lines;
		_line_list = _tmp15_;
		_tmp16_ = _line_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_line_size = _tmp18_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gchar* line = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			const gchar* _tmp23_;
			_line_index = _line_index + 1;
			_tmp19_ = _line_index;
			_tmp20_ = _line_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _line_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _line_index);
			line = (gchar*) _tmp22_;
			_tmp23_ = line;
			if (g_strcmp0 (_tmp23_, entry) == 0) {
				result = TRUE;
				_g_free0 (line);
				_g_object_unref0 (lines);
				_g_free0 (tab);
				return result;
			} else {
				gboolean _tmp24_ = FALSE;
				if (partial_match) {
					const gchar* _tmp25_;
					_tmp25_ = line;
					_tmp24_ = string_contains (_tmp25_, entry);
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					result = TRUE;
					_g_free0 (line);
					_g_object_unref0 (lines);
					_g_free0 (tab);
					return result;
				}
			}
			_g_free0 (line);
		}
	}
	result = FALSE;
	_g_object_unref0 (lines);
	_g_free0 (tab);
	return result;
}

gboolean
cron_tab_add_job (const gchar* entry,
                  gboolean use_cached_text)
{
	gchar* tab = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* lines = NULL;
	GeeArrayList* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	GeeArrayList* _tmp24_;
	gchar* tab_new = NULL;
	gchar* _tmp25_;
	gchar* temp_file = NULL;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* cmd = NULL;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gint status = 0;
	const gchar* _tmp47_;
	gboolean result;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	tab = _tmp0_;
	if (use_cached_text) {
		const gchar* _tmp2_;
		_tmp2_ = cron_tab_crontab_text;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = cron_tab_crontab_text;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (tab);
		tab = _tmp4_;
	} else {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = cron_tab_crontab_read_all ("");
		_g_free0 (cron_tab_crontab_text);
		cron_tab_crontab_text = _tmp5_;
		_tmp6_ = cron_tab_crontab_text;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (tab);
		tab = _tmp7_;
	}
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	lines = _tmp8_;
	_tmp9_ = tab;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp11_;
		line_collection_length1 = _vala_array_length (_tmp10_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp12_;
			gchar* line = NULL;
			_tmp12_ = g_strdup (line_collection[line_it]);
			line = _tmp12_;
			{
				GeeArrayList* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = lines;
				_tmp14_ = line;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp15_;
		gint _line_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _line_index = 0;
		_tmp15_ = lines;
		_line_list = _tmp15_;
		_tmp16_ = _line_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_line_size = _tmp18_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gchar* line = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			const gchar* _tmp23_;
			_line_index = _line_index + 1;
			_tmp19_ = _line_index;
			_tmp20_ = _line_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _line_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _line_index);
			line = (gchar*) _tmp22_;
			_tmp23_ = line;
			if (g_strcmp0 (_tmp23_, entry) == 0) {
				result = TRUE;
				_g_free0 (line);
				_g_object_unref0 (lines);
				_g_free0 (tab);
				return result;
			}
			_g_free0 (line);
		}
	}
	_tmp24_ = lines;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, entry);
	_tmp25_ = g_strdup ("");
	tab_new = _tmp25_;
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp26_;
		gint _line_size = 0;
		GeeArrayList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _line_index = 0;
		_tmp26_ = lines;
		_line_list = _tmp26_;
		_tmp27_ = _line_list;
		_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_line_size = _tmp29_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gchar* line = NULL;
			GeeArrayList* _tmp32_;
			gpointer _tmp33_;
			const gchar* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			_line_index = _line_index + 1;
			_tmp30_ = _line_index;
			_tmp31_ = _line_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _line_list;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _line_index);
			line = (gchar*) _tmp33_;
			_tmp34_ = line;
			_tmp35_ = strlen (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ > 0) {
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp37_ = tab_new;
				_tmp38_ = line;
				_tmp39_ = g_strdup_printf ("%s\n", _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strconcat (_tmp37_, _tmp40_, NULL);
				_g_free0 (tab_new);
				tab_new = _tmp41_;
				_g_free0 (_tmp40_);
			}
			_g_free0 (line);
		}
	}
	_tmp42_ = tee_jee_process_helper_get_temp_file_path ();
	temp_file = _tmp42_;
	_tmp43_ = temp_file;
	_tmp44_ = tab_new;
	tee_jee_file_system_file_write (_tmp43_, _tmp44_);
	_tmp45_ = temp_file;
	_tmp46_ = g_strdup_printf ("crontab \"%s\"", _tmp45_);
	cmd = _tmp46_;
	_tmp47_ = cmd;
	status = tee_jee_process_helper_exec_sync (_tmp47_, NULL, NULL);
	if (status != 0) {
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp48_ = g_strdup_printf (": %s", entry);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strconcat (_ ("Failed to add cron job"), _tmp49_, NULL);
		_tmp51_ = _tmp50_;
		tee_jee_logging_log_error (_tmp51_, FALSE, FALSE);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp49_);
		result = FALSE;
		_g_free0 (cmd);
		_g_free0 (temp_file);
		_g_free0 (tab_new);
		_g_object_unref0 (lines);
		_g_free0 (tab);
		return result;
	} else {
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp52_ = g_strdup_printf (": %s", entry);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (_ ("Cron job added"), _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		tee_jee_logging_log_msg (_tmp55_, FALSE);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		result = TRUE;
		_g_free0 (cmd);
		_g_free0 (temp_file);
		_g_free0 (tab_new);
		_g_object_unref0 (lines);
		_g_free0 (tab);
		return result;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gboolean
cron_tab_remove_job (const gchar* entry,
                     gboolean use_regex,
                     gboolean use_cached_text)
{
	gchar* tab = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* lines = NULL;
	GeeArrayList* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	GRegex* regex = NULL;
	gboolean found = FALSE;
	gchar* tab_new = NULL;
	gchar* _tmp42_;
	gchar* temp_file = NULL;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* cmd = NULL;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gint status = 0;
	const gchar* _tmp64_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	tab = _tmp0_;
	if (use_cached_text) {
		const gchar* _tmp2_;
		_tmp2_ = cron_tab_crontab_text;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = cron_tab_crontab_text;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (tab);
		tab = _tmp4_;
	} else {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = cron_tab_crontab_read_all ("");
		_g_free0 (cron_tab_crontab_text);
		cron_tab_crontab_text = _tmp5_;
		_tmp6_ = cron_tab_crontab_text;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (tab);
		tab = _tmp7_;
	}
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	lines = _tmp8_;
	_tmp9_ = tab;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp11_;
		line_collection_length1 = _vala_array_length (_tmp10_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp12_;
			gchar* line = NULL;
			_tmp12_ = g_strdup (line_collection[line_it]);
			line = _tmp12_;
			{
				GeeArrayList* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = lines;
				_tmp14_ = line;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	regex = NULL;
	if (use_regex) {
		{
			GRegex* _tmp15_ = NULL;
			GRegex* _tmp16_;
			GRegex* _tmp17_;
			_tmp16_ = g_regex_new (entry, 0, 0, &_inner_error0_);
			_tmp15_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp17_ = _tmp15_;
			_tmp15_ = NULL;
			_g_regex_unref0 (regex);
			regex = _tmp17_;
			_g_regex_unref0 (_tmp15_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			tee_jee_logging_log_error (_tmp19_, FALSE, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp20_ = FALSE;
			_g_regex_unref0 (regex);
			_g_object_unref0 (lines);
			_g_free0 (tab);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp20_;
		}
	}
	found = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gchar* line = NULL;
				GeeArrayList* _tmp26_;
				gpointer _tmp27_;
				const gchar* _tmp28_;
				gboolean _tmp31_ = FALSE;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = lines;
				_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
				_tmp25_ = _tmp24_;
				if (!(i < _tmp25_)) {
					break;
				}
				_tmp26_ = lines;
				_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, i);
				line = (gchar*) _tmp27_;
				_tmp28_ = line;
				if (_tmp28_ != NULL) {
					const gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp29_ = line;
					_tmp30_ = string_strip (_tmp29_);
					_g_free0 (line);
					line = _tmp30_;
				}
				if (use_regex) {
					GRegex* _tmp32_;
					_tmp32_ = regex;
					_tmp31_ = _tmp32_ != NULL;
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					GMatchInfo* match = NULL;
					GRegex* _tmp33_;
					const gchar* _tmp34_;
					GMatchInfo* _tmp35_ = NULL;
					gboolean _tmp36_;
					_tmp33_ = regex;
					_tmp34_ = line;
					_tmp36_ = g_regex_match (_tmp33_, _tmp34_, 0, &_tmp35_);
					_g_match_info_unref0 (match);
					match = _tmp35_;
					if (_tmp36_) {
						GeeArrayList* _tmp37_;
						const gchar* _tmp38_;
						_tmp37_ = lines;
						_tmp38_ = line;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp37_, _tmp38_);
						found = TRUE;
					}
					_g_match_info_unref0 (match);
				} else {
					const gchar* _tmp39_;
					_tmp39_ = line;
					if (g_strcmp0 (_tmp39_, entry) == 0) {
						GeeArrayList* _tmp40_;
						const gchar* _tmp41_;
						_tmp40_ = lines;
						_tmp41_ = line;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp40_, _tmp41_);
						found = TRUE;
					}
				}
				_g_free0 (line);
			}
		}
	}
	if (!found) {
		result = TRUE;
		_g_regex_unref0 (regex);
		_g_object_unref0 (lines);
		_g_free0 (tab);
		return result;
	}
	_tmp42_ = g_strdup ("");
	tab_new = _tmp42_;
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp43_;
		gint _line_size = 0;
		GeeArrayList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _line_index = 0;
		_tmp43_ = lines;
		_line_list = _tmp43_;
		_tmp44_ = _line_list;
		_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_line_size = _tmp46_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp47_;
			gint _tmp48_;
			gchar* line = NULL;
			GeeArrayList* _tmp49_;
			gpointer _tmp50_;
			const gchar* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			_line_index = _line_index + 1;
			_tmp47_ = _line_index;
			_tmp48_ = _line_size;
			if (!(_tmp47_ < _tmp48_)) {
				break;
			}
			_tmp49_ = _line_list;
			_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _line_index);
			line = (gchar*) _tmp50_;
			_tmp51_ = line;
			_tmp52_ = strlen (_tmp51_);
			_tmp53_ = _tmp52_;
			if (_tmp53_ > 0) {
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp54_ = tab_new;
				_tmp55_ = line;
				_tmp56_ = g_strdup_printf ("%s\n", _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = g_strconcat (_tmp54_, _tmp57_, NULL);
				_g_free0 (tab_new);
				tab_new = _tmp58_;
				_g_free0 (_tmp57_);
			}
			_g_free0 (line);
		}
	}
	_tmp59_ = tee_jee_process_helper_get_temp_file_path ();
	temp_file = _tmp59_;
	_tmp60_ = temp_file;
	_tmp61_ = tab_new;
	tee_jee_file_system_file_write (_tmp60_, _tmp61_);
	_tmp62_ = temp_file;
	_tmp63_ = g_strdup_printf ("crontab \"%s\"", _tmp62_);
	cmd = _tmp63_;
	_tmp64_ = cmd;
	status = tee_jee_process_helper_exec_sync (_tmp64_, NULL, NULL);
	if (status != 0) {
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp65_ = g_strdup_printf (": %s", entry);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_ ("Failed to remove cron job"), _tmp66_, NULL);
		_tmp68_ = _tmp67_;
		tee_jee_logging_log_error (_tmp68_, FALSE, FALSE);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		result = FALSE;
		_g_free0 (cmd);
		_g_free0 (temp_file);
		_g_free0 (tab_new);
		_g_regex_unref0 (regex);
		_g_object_unref0 (lines);
		_g_free0 (tab);
		return result;
	} else {
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp69_ = g_strdup_printf (": %s", entry);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strconcat (_ ("Cron job removed"), _tmp70_, NULL);
		_tmp72_ = _tmp71_;
		tee_jee_logging_log_msg (_tmp72_, FALSE);
		_g_free0 (_tmp72_);
		_g_free0 (_tmp70_);
		result = TRUE;
		_g_free0 (cmd);
		_g_free0 (temp_file);
		_g_free0 (tab_new);
		_g_regex_unref0 (regex);
		_g_object_unref0 (lines);
		_g_free0 (tab);
		return result;
	}
}

gboolean
cron_tab_install (const gchar* file_path,
                  const gchar* user_name)
{
	gchar* cmd = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gint status = 0;
	const gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (file_path != NULL, FALSE);
	g_return_val_if_fail (user_name != NULL, FALSE);
	if (!tee_jee_file_system_file_exists (file_path)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_strdup_printf (": %s", file_path);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat (_ ("File not found"), _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		tee_jee_logging_log_error (_tmp3_, FALSE, FALSE);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		result = FALSE;
		return result;
	}
	_tmp4_ = g_strdup ("crontab");
	cmd = _tmp4_;
	_tmp5_ = strlen (user_name);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = cmd;
		_tmp8_ = g_strdup_printf (" -u %s", user_name);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
		_g_free0 (cmd);
		cmd = _tmp10_;
		_g_free0 (_tmp9_);
	}
	_tmp11_ = cmd;
	_tmp12_ = g_strdup_printf (" \"%s\"", file_path);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_g_free0 (cmd);
	cmd = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = cmd;
	tee_jee_logging_log_debug (_tmp15_);
	_tmp16_ = cmd;
	status = tee_jee_process_helper_exec_sync (_tmp16_, NULL, NULL);
	if (status != 0) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp17_ = g_strdup_printf (": %s", file_path);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_ ("Failed to install crontab file"), _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		tee_jee_logging_log_error (_tmp20_, FALSE, FALSE);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		result = FALSE;
		_g_free0 (cmd);
		return result;
	} else {
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = g_strdup_printf (": %s", file_path);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_ ("crontab file installed"), _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		tee_jee_logging_log_msg (_tmp24_, FALSE);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		result = TRUE;
		_g_free0 (cmd);
		return result;
	}
}

gboolean
cron_tab_export (const gchar* file_path,
                 const gchar* user_name)
{
	gboolean ok = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (file_path != NULL, FALSE);
	g_return_val_if_fail (user_name != NULL, FALSE);
	if (tee_jee_file_system_file_exists (file_path)) {
		tee_jee_file_system_file_delete (file_path);
	}
	_tmp0_ = cron_tab_crontab_read_all (user_name);
	_tmp1_ = _tmp0_;
	_tmp2_ = tee_jee_file_system_file_write (file_path, _tmp1_);
	_g_free0 (_tmp1_);
	ok = _tmp2_;
	if (!ok) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = g_strdup_printf (": %s", file_path);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_ ("Failed to export crontab file"), _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		tee_jee_logging_log_error (_tmp6_, FALSE, FALSE);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		result = FALSE;
		return result;
	} else {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = g_strdup_printf (": %s", file_path);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_ ("crontab file exported"), _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		tee_jee_logging_log_msg (_tmp10_, FALSE);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		result = TRUE;
		return result;
	}
}

gboolean
cron_tab_import (const gchar* file_path,
                 const gchar* user_name)
{
	gboolean result;
	g_return_val_if_fail (file_path != NULL, FALSE);
	g_return_val_if_fail (user_name != NULL, FALSE);
	result = cron_tab_install (file_path, user_name);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
cron_tab_add_script_file (const gchar* file_name,
                          const gchar* cron_dir_type,
                          const gchar* text,
                          gboolean stop_cron_emails)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	gchar* file_path = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* sh = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean result;
	g_return_val_if_fail (file_name != NULL, FALSE);
	g_return_val_if_fail (cron_dir_type != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = cron_dir_type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("d")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("hourly"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("daily"))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("weekly"))))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("monthly"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp3_ = g_strdup_printf (": %s", cron_dir_type);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strconcat ("Cron directory type parameter not valid", _tmp4_, NULL);
				_tmp6_ = _tmp5_;
				tee_jee_logging_log_error (_tmp6_, FALSE, FALSE);
				_g_free0 (_tmp6_);
				_g_free0 (_tmp4_);
				tee_jee_logging_log_error ("Expected values: d, hourly, daily, weekly, monthly", FALSE, FALSE);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp7_ = string_replace (file_name, ".", "-");
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("/etc/cron.%s/%s", cron_dir_type, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	file_path = _tmp10_;
	_tmp11_ = g_strdup ("");
	sh = _tmp11_;
	_tmp12_ = sh;
	_tmp13_ = g_strconcat (_tmp12_, "SHELL=/bin/bash" "\n", NULL);
	_g_free0 (sh);
	sh = _tmp13_;
	_tmp14_ = sh;
	_tmp15_ = g_strconcat (_tmp14_, "PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin" "\n", NULL);
	_g_free0 (sh);
	sh = _tmp15_;
	if (stop_cron_emails) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = sh;
		_tmp17_ = g_strconcat (_tmp16_, "MAILTO=\"\"" "\n", NULL);
		_g_free0 (sh);
		sh = _tmp17_;
	}
	_tmp18_ = sh;
	_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
	_g_free0 (sh);
	sh = _tmp19_;
	_tmp20_ = sh;
	_tmp21_ = g_strconcat (text, "\n", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
	_g_free0 (sh);
	sh = _tmp23_;
	_g_free0 (_tmp22_);
	_tmp25_ = file_path;
	if (tee_jee_file_system_file_exists (_tmp25_)) {
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp26_ = file_path;
		_tmp27_ = tee_jee_file_system_file_read (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = sh;
		_tmp24_ = g_strcmp0 (_tmp28_, _tmp29_) == 0;
		_g_free0 (_tmp28_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = file_path;
		_tmp31_ = g_strdup_printf (": %s", _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_ ("Cron task exists"), _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		tee_jee_logging_log_debug (_tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		result = TRUE;
		_g_free0 (sh);
		_g_free0 (file_path);
		return result;
	}
	_tmp35_ = file_path;
	_tmp36_ = sh;
	tee_jee_file_system_file_write (_tmp35_, _tmp36_);
	_tmp37_ = file_path;
	chown (_tmp37_, (uid_t) 0, (gid_t) 0);
	_tmp38_ = file_path;
	chmod (_tmp38_, (mode_t) 0644);
	_tmp39_ = file_path;
	_tmp40_ = g_strdup_printf (": %s", _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_ ("Added cron task"), _tmp41_, NULL);
	_tmp43_ = _tmp42_;
	tee_jee_logging_log_msg (_tmp43_, FALSE);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	result = TRUE;
	_g_free0 (sh);
	_g_free0 (file_path);
	return result;
}

gboolean
cron_tab_remove_script_file (const gchar* file_name,
                             const gchar* cron_dir_type)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	gchar* file_path = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean result;
	g_return_val_if_fail (file_name != NULL, FALSE);
	g_return_val_if_fail (cron_dir_type != NULL, FALSE);
	_tmp0_ = cron_dir_type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("d")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("hourly"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("daily"))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("weekly"))))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("monthly"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp3_ = g_strdup_printf (": %s", cron_dir_type);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strconcat ("Cron directory type parameter not valid", _tmp4_, NULL);
				_tmp6_ = _tmp5_;
				tee_jee_logging_log_error (_tmp6_, FALSE, FALSE);
				_g_free0 (_tmp6_);
				_g_free0 (_tmp4_);
				tee_jee_logging_log_error ("Expected values: d, hourly, daily, weekly, monthly", FALSE, FALSE);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp7_ = string_replace (file_name, ".", "-");
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("/etc/cron.%s/%s", cron_dir_type, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	file_path = _tmp10_;
	_tmp11_ = file_path;
	if (!tee_jee_file_system_file_exists (_tmp11_)) {
		result = TRUE;
		_g_free0 (file_path);
		return result;
	}
	_tmp12_ = file_path;
	tee_jee_file_system_file_delete (_tmp12_);
	_tmp13_ = file_path;
	_tmp14_ = g_strdup_printf (": %s", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_ ("Removed cron task"), _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	tee_jee_logging_log_msg (_tmp17_, FALSE);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	result = TRUE;
	_g_free0 (file_path);
	return result;
}

CronTab*
cron_tab_construct (GType object_type)
{
	CronTab * self = NULL;
	self = (CronTab*) g_object_new (object_type, NULL);
	return self;
}

CronTab*
cron_tab_new (void)
{
	return cron_tab_construct (TYPE_CRON_TAB);
}

static void
cron_tab_class_init (CronTabClass * klass,
                     gpointer klass_data)
{
	cron_tab_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = cron_tab_finalize;
}

static void
cron_tab_instance_init (CronTab * self,
                        gpointer klass)
{
}

static void
cron_tab_finalize (GObject * obj)
{
	CronTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CRON_TAB, CronTab);
	G_OBJECT_CLASS (cron_tab_parent_class)->finalize (obj);
}

static GType
cron_tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CronTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cron_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CronTab), 0, (GInstanceInitFunc) cron_tab_instance_init, NULL };
	GType cron_tab_type_id;
	cron_tab_type_id = g_type_register_static (G_TYPE_OBJECT, "CronTab", &g_define_type_info, 0);
	return cron_tab_type_id;
}

GType
cron_tab_get_type (void)
{
	static volatile gsize cron_tab_type_id__once = 0;
	if (g_once_init_enter (&cron_tab_type_id__once)) {
		GType cron_tab_type_id;
		cron_tab_type_id = cron_tab_get_type_once ();
		g_once_init_leave (&cron_tab_type_id__once, cron_tab_type_id);
	}
	return cron_tab_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

