const char metrics_tarantool_vinyl_lua[] =
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update()\n"
"    if not utils.box_is_configured() then\n"
"        return\n"
"    end\n"
"\n"
"    local vinyl_stat = box.stat.vinyl()\n"
"    collectors_list.vinyl_disk_data_size =\n"
"        utils.set_gauge('vinyl_disk_data_size', 'Amount of data stored in files',\n"
"            vinyl_stat.disk.data, nil, nil, {default = true})\n"
"    collectors_list.vinyl_disk_index_size =\n"
"        utils.set_gauge('vinyl_disk_index_size', 'Amount of index stored in files',\n"
"            vinyl_stat.disk.index, nil, nil, {default = true})\n"
"\n"
"    collectors_list.vinyl_regulator_dump_bandwidth =\n"
"        utils.set_gauge('vinyl_regulator_dump_bandwidth', 'Estimated average rate at which dumps are done',\n"
"        vinyl_stat.regulator.dump_bandwidth, nil, nil, {default = true})\n"
"    collectors_list.vinyl_regulator_write_rate =\n"
"        utils.set_gauge('vinyl_regulator_write_rate', 'Average rate at which recent writes to disk are done',\n"
"        vinyl_stat.regulator.write_rate, nil, nil, {default = true})\n"
"    collectors_list.vinyl_regulator_rate_limit =\n"
"        utils.set_gauge('vinyl_regulator_rate_limit', 'Write rate limit',\n"
"            vinyl_stat.regulator.rate_limit, nil, nil, {default = true})\n"
"    collectors_list.vinyl_regulator_dump_watermark =\n"
"        utils.set_gauge('vinyl_regulator_dump_watermark', 'Point when dumping must occur',\n"
"        vinyl_stat.regulator.dump_watermark, nil, nil, {default = true})\n"
"    if vinyl_stat.regulator.blocked_writers ~= nil then\n"
"        collectors_list.vinyl_regulator_blocked_writers =\n"
"            utils.set_gauge('vinyl_regulator_blocked_writers', 'The number of fibers that are blocked waiting ' ..\n"
"            'for Vinyl level0 memory quota',\n"
"            vinyl_stat.regulator.blocked_writers, nil, nil, {default = true})\n"
"    end\n"
"\n"
"    collectors_list.vinyl_tx_conflict =\n"
"        utils.set_gauge('vinyl_tx_conflict', 'Count of transaction conflicts',\n"
"            vinyl_stat.tx.conflict, nil, nil, {default = true})\n"
"    collectors_list.vinyl_tx_commit =\n"
"        utils.set_gauge('vinyl_tx_commit', 'Count of commits',\n"
"            vinyl_stat.tx.commit, nil, nil, {default = true})\n"
"    collectors_list.vinyl_tx_rollback =\n"
"        utils.set_gauge('vinyl_tx_rollback', 'Count of rollbacks',\n"
"            vinyl_stat.tx.rollback, nil, nil, {default = true})\n"
"    collectors_list.vinyl_tx_read_views =\n"
"        utils.set_gauge('vinyl_tx_read_views', 'Count of open read views',\n"
"            vinyl_stat.tx.read_views, nil, nil, {default = true})\n"
"\n"
"    collectors_list.vinyl_memory_tuple_cache =\n"
"        utils.set_gauge('vinyl_memory_tuple_cache', 'Number of bytes that are being used for tuple',\n"
"            vinyl_stat.memory.tuple_cache, nil, nil, {default = true})\n"
"    collectors_list.vinyl_memory_level0 =\n"
"        utils.set_gauge('vinyl_memory_level0', 'Size of in-memory storage of an LSM tree',\n"
"            vinyl_stat.memory.level0, nil, nil, {default = true})\n"
"    collectors_list.vinyl_memory_page_index =\n"
"        utils.set_gauge('vinyl_memory_page_index', 'Size of page indexes',\n"
"            vinyl_stat.memory.page_index, nil, nil, {default = true})\n"
"    collectors_list.vinyl_memory_bloom_filter =\n"
"        utils.set_gauge('vinyl_memory_bloom_filter', 'Size of bloom filter',\n"
"            vinyl_stat.memory.bloom_filter, nil, nil, {default = true})\n"
"\n"
"    collectors_list.vinyl_scheduler_tasks =\n"
"        utils.set_gauge('vinyl_scheduler_tasks', 'Vinyl tasks count',\n"
"            vinyl_stat.scheduler.tasks_inprogress, {status = 'inprogress'}, nil, {default = true})\n"
"    collectors_list.vinyl_scheduler_tasks =\n"
"        utils.set_gauge('vinyl_scheduler_tasks', 'Vinyl tasks count',\n"
"            vinyl_stat.scheduler.tasks_completed, {status = 'completed'}, nil, {default = true})\n"
"    collectors_list.vinyl_scheduler_tasks =\n"
"        utils.set_gauge('vinyl_scheduler_tasks', 'Vinyl tasks count',\n"
"            vinyl_stat.scheduler.tasks_failed, {status = 'failed'}, nil, {default = true})\n"
"\n"
"    collectors_list.vinyl_scheduler_dump_time =\n"
"        utils.set_gauge('vinyl_scheduler_dump_time', 'Total time spent by all worker threads performing dump',\n"
"            vinyl_stat.scheduler.dump_time, nil, nil, {default = true})\n"
"    collectors_list.vinyl_scheduler_dump_total =\n"
"        utils.set_counter('vinyl_scheduler_dump_total', 'The count of completed dumps',\n"
"            vinyl_stat.scheduler.dump_count, nil, nil, {default = true})\n"
"end\n"
"\n"
"return {\n"
"    update = update,\n"
"    list = collectors_list,\n"
"}\n"
""
;
