// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Package config provides interfaces to consume machine configuration values.
package config

// Config defines the interface to access contents of the machine configuration.
type Config interface { //nolint:interfacebloat
	// old v1alpha1 interface (to be decomposed as we move to multi-doc)
	Debug() bool
	Machine() MachineConfig
	Cluster() ClusterConfig

	// new multi-doc interfaces:
	//  - network
	SideroLink() SideroLinkConfig
	NetworkRules() NetworkRuleConfig
	KubespanConfig() KubespanConfig
	EthernetConfigs() []EthernetConfig
	RunDefaultDHCPOperators() bool
	NetworkStaticHostConfig() []NetworkStaticHostConfig
	NetworkHostnameConfig() NetworkHostnameConfig
	NetworkCommonLinkConfigs() []NetworkCommonLinkConfig

	// - block devices/storage:
	Volumes() VolumesConfig
	UserVolumeConfigs() []UserVolumeConfig
	RawVolumeConfigs() []RawVolumeConfig
	ExistingVolumeConfigs() []ExistingVolumeConfig
	SwapVolumeConfigs() []SwapVolumeConfig
	ZswapConfig() ZswapConfig

	// - misc:
	ExtensionServiceConfigs() []ExtensionServiceConfig
	Runtime() RuntimeConfig
	TrustedRoots() TrustedRootsConfig
	PCIDriverRebindConfig() PCIDriverRebindConfig
	OOMConfig() OOMConfig
}
