/* InputDeviceMonitor.c generated by valac 0.56.17, the Vala compiler
 * generated from InputDeviceMonitor.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016-2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.sound.h"
#include <pulse/pulseaudio.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_INPUT_DEVICE_MONITOR_0_PROPERTY,
	SOUND_INPUT_DEVICE_MONITOR_NUM_PROPERTIES
};
static GParamSpec* sound_input_device_monitor_properties[SOUND_INPUT_DEVICE_MONITOR_NUM_PROPERTIES];
#define _pa_stream_unref0(var) ((var == NULL) ? NULL : (var = (pa_stream_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pa_proplist_free0(var) ((var == NULL) ? NULL : (var = (pa_proplist_free (var), NULL)))
enum  {
	SOUND_INPUT_DEVICE_MONITOR_UPDATE_FRACTION_SIGNAL,
	SOUND_INPUT_DEVICE_MONITOR_NUM_SIGNALS
};
static guint sound_input_device_monitor_signals[SOUND_INPUT_DEVICE_MONITOR_NUM_SIGNALS] = {0};

struct _SoundInputDeviceMonitorPrivate {
	pa_stream* steam;
	SoundDevice* device;
	gboolean allow_record;
};

static gint SoundInputDeviceMonitor_private_offset;
static gpointer sound_input_device_monitor_parent_class = NULL;

static void sound_input_device_monitor_steam_read_callback (SoundInputDeviceMonitor* self,
                                                     pa_stream* s,
                                                     gsize nbytes);
static void _sound_input_device_monitor_steam_read_callback_pa_stream_requestcb (pa_stream* s,
                                                                          gsize nbytes,
                                                                          gpointer self);
static void sound_input_device_monitor_steam_suspended_callback (SoundInputDeviceMonitor* self,
                                                          pa_stream* s);
static void _sound_input_device_monitor_steam_suspended_callback_pa_stream_notifycb (pa_stream* s,
                                                                              gpointer self);
static void sound_input_device_monitor_finalize (GObject * obj);
static GType sound_input_device_monitor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sound_input_device_monitor_get_instance_private (SoundInputDeviceMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, SoundInputDeviceMonitor_private_offset);
}

SoundInputDeviceMonitor*
sound_input_device_monitor_construct (GType object_type)
{
	SoundInputDeviceMonitor * self = NULL;
	self = (SoundInputDeviceMonitor*) g_object_new (object_type, NULL);
	return self;
}

SoundInputDeviceMonitor*
sound_input_device_monitor_new (void)
{
	return sound_input_device_monitor_construct (SOUND_TYPE_INPUT_DEVICE_MONITOR);
}

void
sound_input_device_monitor_stop_record (SoundInputDeviceMonitor* self)
{
	pa_stream* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->allow_record == FALSE) {
		return;
	}
	self->priv->allow_record = FALSE;
	_tmp0_ = self->priv->steam;
	if (_tmp0_ != NULL) {
		pa_stream* _tmp1_;
		_tmp1_ = self->priv->steam;
		pa_stream_disconnect (_tmp1_);
		_pa_stream_unref0 (self->priv->steam);
		self->priv->steam = NULL;
	}
}

static void
_sound_input_device_monitor_steam_read_callback_pa_stream_requestcb (pa_stream* s,
                                                                     gsize nbytes,
                                                                     gpointer self)
{
	sound_input_device_monitor_steam_read_callback ((SoundInputDeviceMonitor*) self, s, nbytes);
}

static void
_sound_input_device_monitor_steam_suspended_callback_pa_stream_notifycb (pa_stream* s,
                                                                         gpointer self)
{
	sound_input_device_monitor_steam_suspended_callback ((SoundInputDeviceMonitor*) self, s);
}

void
sound_input_device_monitor_start_record (SoundInputDeviceMonitor* self)
{
	SoundDevice* _tmp0_;
	pa_stream* _tmp1_;
	pa_context* c = NULL;
	SoundPulseAudioManager* _tmp3_;
	pa_context* _tmp4_;
	pa_context* _tmp5_;
	pa_sample_spec ss = {0};
	pa_sample_spec _tmp6_ = {0};
	pa_proplist* props = NULL;
	pa_proplist* _tmp7_;
	pa_proplist* _tmp8_;
	pa_proplist* _tmp9_;
	pa_proplist* _tmp10_;
	pa_proplist* _tmp11_;
	pa_context* _tmp12_;
	pa_sample_spec _tmp13_;
	pa_proplist* _tmp14_;
	pa_stream* _tmp15_;
	pa_stream* _tmp16_;
	pa_stream* _tmp17_;
	pa_buffer_attr a = {0};
	pa_buffer_attr _tmp18_ = {0};
	pa_stream* _tmp19_;
	SoundDevice* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	pa_buffer_attr _tmp25_;
	g_return_if_fail (self != NULL);
	self->priv->allow_record = TRUE;
	_tmp0_ = self->priv->device;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->steam;
	if (_tmp1_ != NULL) {
		pa_stream* _tmp2_;
		_tmp2_ = self->priv->steam;
		pa_stream_disconnect (_tmp2_);
		_pa_stream_unref0 (self->priv->steam);
		self->priv->steam = NULL;
	}
	_tmp3_ = sound_pulse_audio_manager_get_default ();
	_tmp4_ = sound_pulse_audio_manager_get_context (_tmp3_);
	_tmp5_ = _tmp4_;
	c = _tmp5_;
	pa_sample_spec_init (&_tmp6_);
	_tmp6_.format = PA_SAMPLE_FLOAT32NE;
	_tmp6_.rate = (guint32) 25;
	_tmp6_.channels = (guint8) 1;
	ss = _tmp6_;
	_tmp7_ = pa_proplist_new ();
	props = _tmp7_;
	_tmp8_ = props;
	pa_proplist_sets (_tmp8_, PA_PROP_APPLICATION_NAME, "Sound Settings");
	_tmp9_ = props;
	pa_proplist_sets (_tmp9_, PA_PROP_APPLICATION_ID, "io.elementary.settings.sound");
	_tmp10_ = props;
	pa_proplist_sets (_tmp10_, PA_PROP_APPLICATION_ICON_NAME, "multimedia-volume-control");
	_tmp11_ = props;
	pa_proplist_sets (_tmp11_, PA_PROP_APPLICATION_VERSION, "0.1");
	_tmp12_ = c;
	_tmp13_ = ss;
	_tmp14_ = props;
	_tmp15_ = pa_stream_new_with_proplist (_tmp12_, _ ("Peak detect"), &_tmp13_, NULL, _tmp14_);
	_pa_stream_unref0 (self->priv->steam);
	self->priv->steam = _tmp15_;
	_tmp16_ = self->priv->steam;
	pa_stream_set_read_callback (_tmp16_, _sound_input_device_monitor_steam_read_callback_pa_stream_requestcb, self);
	_tmp17_ = self->priv->steam;
	pa_stream_set_suspended_callback (_tmp17_, _sound_input_device_monitor_steam_suspended_callback_pa_stream_notifycb, self);
	memset (&_tmp18_, 0, sizeof (pa_buffer_attr));
	_tmp18_.maxlength = G_MAXUINT32;
	_tmp18_.fragsize = (guint32) sizeof (gfloat);
	a = _tmp18_;
	_tmp19_ = self->priv->steam;
	_tmp20_ = self->priv->device;
	_tmp21_ = sound_device_get_source_index (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf ("%u", (guint) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = a;
	pa_stream_connect_record (_tmp19_, _tmp24_, &_tmp25_, (PA_STREAM_DONT_MOVE | PA_STREAM_PEAK_DETECT) | PA_STREAM_ADJUST_LATENCY);
	_g_free0 (_tmp24_);
	_pa_proplist_free0 (props);
}

void
sound_input_device_monitor_set_device (SoundInputDeviceMonitor* self,
                                       SoundDevice* device)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	self->priv->device = device;
	if (self->priv->allow_record) {
		sound_input_device_monitor_start_record (self);
	} else {
		sound_input_device_monitor_stop_record (self);
	}
}

static void
sound_input_device_monitor_steam_read_callback (SoundInputDeviceMonitor* self,
                                                pa_stream* s,
                                                gsize nbytes)
{
	void* data = NULL;
	void* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	gint _tmp2_;
	void* _tmp3_;
	gfloat v = 0.0F;
	void* _tmp4_;
	gfloat _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp2_ = pa_stream_peek (s, &_tmp0_, &_tmp1_);
	data = _tmp0_;
	nbytes = _tmp1_;
	if (_tmp2_ < 0) {
		g_warning ("InputDeviceMonitor.vala:102: Failed to read data from stream");
		return;
	}
	_tmp3_ = data;
	if (_tmp3_ == NULL) {
		pa_stream_drop (s);
		return;
	}
	_tmp4_ = data;
	_tmp5_ = ((gfloat*) _tmp4_)[(nbytes / sizeof (gfloat)) - 1];
	v = _tmp5_;
	pa_stream_drop (s);
	if (v < ((gfloat) 0)) {
		v = (gfloat) 0;
	}
	if (v > ((gfloat) 1)) {
		v = (gfloat) 1;
	}
	g_signal_emit (self, sound_input_device_monitor_signals[SOUND_INPUT_DEVICE_MONITOR_UPDATE_FRACTION_SIGNAL], 0, v);
}

static void
sound_input_device_monitor_steam_suspended_callback (SoundInputDeviceMonitor* self,
                                                     pa_stream* s)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_signal_emit (self, sound_input_device_monitor_signals[SOUND_INPUT_DEVICE_MONITOR_UPDATE_FRACTION_SIGNAL], 0, (gfloat) 0);
}

static void
sound_input_device_monitor_class_init (SoundInputDeviceMonitorClass * klass,
                                       gpointer klass_data)
{
	sound_input_device_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundInputDeviceMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sound_input_device_monitor_finalize;
	sound_input_device_monitor_signals[SOUND_INPUT_DEVICE_MONITOR_UPDATE_FRACTION_SIGNAL] = g_signal_new ("update-fraction", SOUND_TYPE_INPUT_DEVICE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__FLOAT, G_TYPE_NONE, 1, G_TYPE_FLOAT);
}

static void
sound_input_device_monitor_instance_init (SoundInputDeviceMonitor * self,
                                          gpointer klass)
{
	self->priv = sound_input_device_monitor_get_instance_private (self);
	self->priv->allow_record = FALSE;
}

static void
sound_input_device_monitor_finalize (GObject * obj)
{
	SoundInputDeviceMonitor * self;
	pa_stream* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_INPUT_DEVICE_MONITOR, SoundInputDeviceMonitor);
	_tmp0_ = self->priv->steam;
	if (_tmp0_ != NULL) {
		pa_stream* _tmp1_;
		pa_stream* _tmp2_;
		pa_stream* _tmp3_;
		_tmp1_ = self->priv->steam;
		pa_stream_set_read_callback (_tmp1_, NULL, NULL);
		_tmp2_ = self->priv->steam;
		pa_stream_set_suspended_callback (_tmp2_, NULL, NULL);
		_tmp3_ = self->priv->steam;
		pa_stream_disconnect (_tmp3_);
	}
	_pa_stream_unref0 (self->priv->steam);
	G_OBJECT_CLASS (sound_input_device_monitor_parent_class)->finalize (obj);
}

static GType
sound_input_device_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundInputDeviceMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_input_device_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundInputDeviceMonitor), 0, (GInstanceInitFunc) sound_input_device_monitor_instance_init, NULL };
	GType sound_input_device_monitor_type_id;
	sound_input_device_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "SoundInputDeviceMonitor", &g_define_type_info, 0);
	SoundInputDeviceMonitor_private_offset = g_type_add_instance_private (sound_input_device_monitor_type_id, sizeof (SoundInputDeviceMonitorPrivate));
	return sound_input_device_monitor_type_id;
}

GType
sound_input_device_monitor_get_type (void)
{
	static volatile gsize sound_input_device_monitor_type_id__once = 0;
	if (g_once_init_enter (&sound_input_device_monitor_type_id__once)) {
		GType sound_input_device_monitor_type_id;
		sound_input_device_monitor_type_id = sound_input_device_monitor_get_type_once ();
		g_once_init_leave (&sound_input_device_monitor_type_id__once, sound_input_device_monitor_type_id);
	}
	return sound_input_device_monitor_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

