/* ClearUsageDialog.c generated by valac 0.56.17, the Vala compiler
 * generated from ClearUsageDialog.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014-2023 elementary, Inc. (https://elementary.io)
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "security-privacy.h"
#include <granite-7.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <zeitgeist-datamodel.h>
#include <zeitgeist.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SECURITY_PRIVACY_WIDGETS_CLEAR_USAGE_DIALOG_0_PROPERTY,
	SECURITY_PRIVACY_WIDGETS_CLEAR_USAGE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* security_privacy_widgets_clear_usage_dialog_properties[SECURITY_PRIVACY_WIDGETS_CLEAR_USAGE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))

struct _SecurityPrivacyWidgetsClearUsageDialogPrivate {
	GraniteDatePicker* to_datepicker;
	GraniteDatePicker* from_datepicker;
	GtkCheckButton* all_time_radio;
	GtkCheckButton* from_radio;
	GtkCheckButton* past_hour_radio;
	GtkCheckButton* past_day_radio;
	GtkCheckButton* past_week_radio;
	GtkRecentManager* recent;
	GList* items;
};

struct _SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecurityPrivacyWidgetsClearUsageDialog* self;
	ZeitgeistTimeRange* tr;
	GPtrArray* events;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistLog* zg_log;
	ZeitgeistLog* _tmp3_;
	guint32* ids;
	ZeitgeistLog* _tmp4_;
	GPtrArray* _tmp5_;
	gint _tmp6_;
	guint32* _tmp7_;
	gint ids_length1;
	gint _ids_size_;
	GArray* del_ids;
	GArray* _tmp8_;
	GArray* _tmp9_;
	guint32* _tmp10_;
	gint _tmp10__length1;
	guint32* _tmp11_;
	gint _tmp11__length1;
	ZeitgeistLog* _tmp12_;
	GArray* _tmp13_;
	ZeitgeistTimeRange* _tmp14_;
	ZeitgeistTimeRange* _tmp15_;
	GError* e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_;
};

static gint SecurityPrivacyWidgetsClearUsageDialog_private_offset;
static gpointer security_privacy_widgets_clear_usage_dialog_parent_class = NULL;

static void _gtk_recent_info_unref0_ (gpointer var);
static inline void _g_list_free__gtk_recent_info_unref0_ (GList* self);
static void security_privacy_widgets_clear_usage_dialog_delete_history_data_free (gpointer _data);
static void security_privacy_widgets_clear_usage_dialog_delete_history (SecurityPrivacyWidgetsClearUsageDialog* self,
                                                                 ZeitgeistTimeRange* tr,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static void security_privacy_widgets_clear_usage_dialog_delete_history_finish (SecurityPrivacyWidgetsClearUsageDialog* self,
                                                                        GAsyncResult* _res_);
static gboolean security_privacy_widgets_clear_usage_dialog_delete_history_co (SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData* _data_);
static void _g_object_unref0_ (gpointer var);
static void security_privacy_widgets_clear_usage_dialog_delete_history_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void security_privacy_widgets_clear_usage_dialog_on_clear_data (SecurityPrivacyWidgetsClearUsageDialog* self);
static GObject * security_privacy_widgets_clear_usage_dialog_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
static void _security_privacy_widgets_clear_usage_dialog___lambda15_ (SecurityPrivacyWidgetsClearUsageDialog* self,
                                                               gint response);
static void __security_privacy_widgets_clear_usage_dialog___lambda15__gtk_dialog_response (GtkDialog* _sender,
                                                                                    gint response_id,
                                                                                    gpointer self);
static void security_privacy_widgets_clear_usage_dialog_finalize (GObject * obj);
static GType security_privacy_widgets_clear_usage_dialog_get_type_once (void);

static inline gpointer
security_privacy_widgets_clear_usage_dialog_get_instance_private (SecurityPrivacyWidgetsClearUsageDialog* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyWidgetsClearUsageDialog_private_offset);
}

static void
_gtk_recent_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}

static inline void
_g_list_free__gtk_recent_info_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gtk_recent_info_unref0_);
}

SecurityPrivacyWidgetsClearUsageDialog*
security_privacy_widgets_clear_usage_dialog_construct (GType object_type)
{
	SecurityPrivacyWidgetsClearUsageDialog * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("document-open-recent");
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("edit-delete");
	_tmp3_ = _tmp2_;
	self = (SecurityPrivacyWidgetsClearUsageDialog*) g_object_new (object_type, "buttons", GTK_BUTTONS_CANCEL, "image-icon", _tmp1_, "badge-icon", _tmp3_, "primary-text", _ ("Clear system-collected file and app usage history"), "secondary-text", _ ("The data from the selected time frame will be permanently deleted and " \
"cannot be restored"), NULL);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	return self;
}

SecurityPrivacyWidgetsClearUsageDialog*
security_privacy_widgets_clear_usage_dialog_new (void)
{
	return security_privacy_widgets_clear_usage_dialog_construct (SECURITY_PRIVACY_WIDGETS_TYPE_CLEAR_USAGE_DIALOG);
}

static void
security_privacy_widgets_clear_usage_dialog_delete_history_data_free (gpointer _data)
{
	SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->tr);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
security_privacy_widgets_clear_usage_dialog_delete_history (SecurityPrivacyWidgetsClearUsageDialog* self,
                                                            ZeitgeistTimeRange* tr,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData* _data_;
	SecurityPrivacyWidgetsClearUsageDialog* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tr != NULL);
	_data_ = g_slice_new0 (SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, security_privacy_widgets_clear_usage_dialog_delete_history_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (tr);
	_g_object_unref0 (_data_->tr);
	_data_->tr = _tmp1_;
	security_privacy_widgets_clear_usage_dialog_delete_history_co (_data_);
}

static void
security_privacy_widgets_clear_usage_dialog_delete_history_finish (SecurityPrivacyWidgetsClearUsageDialog* self,
                                                                   GAsyncResult* _res_)
{
	SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
security_privacy_widgets_clear_usage_dialog_delete_history_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	security_privacy_widgets_clear_usage_dialog_delete_history_co (_data_);
}

static gboolean
security_privacy_widgets_clear_usage_dialog_delete_history_co (SecurityPrivacyWidgetsClearUsageDialogDeleteHistoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->events = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->events;
	_data_->_tmp2_ = zeitgeist_event_new ();
	g_ptr_array_add (_data_->_tmp1_, _data_->_tmp2_);
	_data_->_tmp3_ = zeitgeist_log_new ();
	_data_->zg_log = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->zg_log;
		_data_->_tmp5_ = _data_->events;
		_data_->_tmp6_ = 0;
		_data_->_state_ = 1;
		zeitgeist_log_find_event_ids (_data_->_tmp4_, _data_->tr, _data_->_tmp5_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 0, 0, NULL, security_privacy_widgets_clear_usage_dialog_delete_history_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = zeitgeist_log_find_event_ids_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error0_);
		_data_->ids = _data_->_tmp7_;
		_data_->ids_length1 = _data_->_tmp6_;
		_data_->_ids_size_ = _data_->ids_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = g_array_new (TRUE, TRUE, sizeof (guint32));
		_data_->del_ids = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->del_ids;
		_data_->_tmp10_ = _data_->ids;
		_data_->_tmp10__length1 = _data_->ids_length1;
		_data_->_tmp11_ = _data_->ids;
		_data_->_tmp11__length1 = _data_->ids_length1;
		g_array_append_vals (_data_->_tmp9_, _data_->_tmp10_, (guint) _data_->_tmp11__length1);
		_data_->_tmp12_ = _data_->zg_log;
		_data_->_tmp13_ = _data_->del_ids;
		_data_->_state_ = 2;
		zeitgeist_log_delete_events (_data_->_tmp12_, _data_->_tmp13_, NULL, security_privacy_widgets_clear_usage_dialog_delete_history_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp14_ = zeitgeist_log_delete_events_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_g_object_unref0 (_data_->_tmp15_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_array_unref0 (_data_->del_ids);
			_data_->ids = (g_free (_data_->ids), NULL);
			goto __catch0_g_error;
		}
		_g_array_unref0 (_data_->del_ids);
		_data_->ids = (g_free (_data_->ids), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_critical ("ClearUsageDialog.vala:93: %s", _data_->_tmp17_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->zg_log);
		_g_ptr_array_unref0 (_data_->events);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->zg_log);
	_g_ptr_array_unref0 (_data_->events);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_gtk_recent_info_ref0 (gpointer self)
{
	return self ? gtk_recent_info_ref (self) : NULL;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
security_privacy_widgets_clear_usage_dialog_on_clear_data (SecurityPrivacyWidgetsClearUsageDialog* self)
{
	ZeitgeistTimeRange* tr = NULL;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->past_hour_radio;
	_tmp1_ = gtk_check_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == TRUE) {
		gint range = 0;
		gint64 end = 0LL;
		gint64 start = 0LL;
		ZeitgeistTimeRange* _tmp3_;
		ZeitgeistTimeRange* _tmp4_;
		GtkRecentManager* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		range = 360000;
		end = zeitgeist_timestamp_from_now ();
		start = end - range;
		_tmp3_ = zeitgeist_time_range_new (start, end);
		_g_object_unref0 (tr);
		tr = _tmp3_;
		_tmp4_ = tr;
		security_privacy_widgets_clear_usage_dialog_delete_history (self, _tmp4_, NULL, NULL);
		_tmp5_ = self->priv->recent;
		g_object_get (_tmp5_, "size", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		if (_tmp7_ > 0) {
			GDateTime* past_hour = NULL;
			GDateTime* _tmp8_;
			GDateTime* _tmp9_;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			GtkRecentManager* _tmp12_;
			GList* _tmp13_;
			_tmp8_ = g_date_time_new_now_local ();
			_tmp9_ = _tmp8_;
			_tmp10_ = g_date_time_add_hours (_tmp9_, -1);
			_tmp11_ = _tmp10_;
			_g_date_time_unref0 (_tmp9_);
			past_hour = _tmp11_;
			_tmp12_ = self->priv->recent;
			_tmp13_ = gtk_recent_manager_get_items (_tmp12_);
			{
				GList* recent_info_collection = NULL;
				GList* recent_info_it = NULL;
				recent_info_collection = _tmp13_;
				for (recent_info_it = recent_info_collection; recent_info_it != NULL; recent_info_it = recent_info_it->next) {
					GtkRecentInfo* recent_info = NULL;
					recent_info = (GtkRecentInfo*) recent_info_it->data;
					{
						GtkRecentInfo* _tmp14_;
						GDateTime* _tmp15_;
						GDateTime* _tmp16_;
						_tmp14_ = recent_info;
						_tmp15_ = gtk_recent_info_get_added (_tmp14_);
						_tmp16_ = past_hour;
						if (g_date_time_compare (_tmp15_, _tmp16_) >= 0) {
							{
								GtkRecentManager* _tmp17_;
								GtkRecentInfo* _tmp18_;
								const gchar* _tmp19_;
								_tmp17_ = self->priv->recent;
								_tmp18_ = recent_info;
								_tmp19_ = gtk_recent_info_get_uri (_tmp18_);
								gtk_recent_manager_remove_item (_tmp17_, _tmp19_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch0_g_error;
								}
							}
							goto __finally0;
							__catch0_g_error:
							{
								GError* err = NULL;
								GError* _tmp20_;
								const gchar* _tmp21_;
								err = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp20_ = err;
								_tmp21_ = _tmp20_->message;
								g_critical ("ClearUsageDialog.vala:116: %s", _tmp21_);
								_g_error_free0 (err);
							}
							__finally0:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								(recent_info_collection == NULL) ? NULL : (recent_info_collection = (_g_list_free__gtk_recent_info_unref0_ (recent_info_collection), NULL));
								_g_date_time_unref0 (past_hour);
								_g_object_unref0 (tr);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
				(recent_info_collection == NULL) ? NULL : (recent_info_collection = (_g_list_free__gtk_recent_info_unref0_ (recent_info_collection), NULL));
			}
			_g_date_time_unref0 (past_hour);
		}
	} else {
		GtkCheckButton* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp22_ = self->priv->past_day_radio;
		_tmp23_ = gtk_check_button_get_active (_tmp22_);
		_tmp24_ = _tmp23_;
		if (_tmp24_ == TRUE) {
			gint range = 0;
			gint64 end = 0LL;
			gint64 start = 0LL;
			ZeitgeistTimeRange* _tmp25_;
			ZeitgeistTimeRange* _tmp26_;
			GtkRecentManager* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			range = 8640000;
			end = zeitgeist_timestamp_from_now ();
			start = end - range;
			_tmp25_ = zeitgeist_time_range_new (start, end);
			_g_object_unref0 (tr);
			tr = _tmp25_;
			_tmp26_ = tr;
			security_privacy_widgets_clear_usage_dialog_delete_history (self, _tmp26_, NULL, NULL);
			_tmp27_ = self->priv->recent;
			g_object_get (_tmp27_, "size", &_tmp28_, NULL);
			_tmp29_ = _tmp28_;
			if (_tmp29_ > 0) {
				GtkRecentManager* _tmp30_;
				GList* _tmp31_;
				_tmp30_ = self->priv->recent;
				_tmp31_ = gtk_recent_manager_get_items (_tmp30_);
				(self->priv->items == NULL) ? NULL : (self->priv->items = (_g_list_free__gtk_recent_info_unref0_ (self->priv->items), NULL));
				self->priv->items = _tmp31_;
				{
					GList* _tmp32_;
					_tmp32_ = self->priv->items;
					{
						GList* item_collection = NULL;
						GList* item_it = NULL;
						item_collection = _tmp32_;
						for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
							GtkRecentInfo* _tmp33_;
							GtkRecentInfo* item = NULL;
							_tmp33_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
							item = _tmp33_;
							{
								GtkRecentInfo* _tmp34_;
								_tmp34_ = item;
								if (gtk_recent_info_get_age (_tmp34_) <= 1) {
									GtkRecentManager* _tmp35_;
									GtkRecentInfo* _tmp36_;
									const gchar* _tmp37_;
									_tmp35_ = self->priv->recent;
									_tmp36_ = item;
									_tmp37_ = gtk_recent_info_get_uri (_tmp36_);
									gtk_recent_manager_remove_item (_tmp35_, _tmp37_, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_gtk_recent_info_unref0 (item);
										goto __catch1_g_error;
									}
								}
								_gtk_recent_info_unref0 (item);
							}
						}
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* err = NULL;
					GError* _tmp38_;
					const gchar* _tmp39_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp38_ = err;
					_tmp39_ = _tmp38_->message;
					g_critical ("ClearUsageDialog.vala:139: %s", _tmp39_);
					_g_error_free0 (err);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (tr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		} else {
			GtkCheckButton* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp40_ = self->priv->past_week_radio;
			_tmp41_ = gtk_check_button_get_active (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_ == TRUE) {
				gint range = 0;
				gint64 end = 0LL;
				gint64 start = 0LL;
				ZeitgeistTimeRange* _tmp43_;
				ZeitgeistTimeRange* _tmp44_;
				GtkRecentManager* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				range = 60480000;
				end = zeitgeist_timestamp_from_now ();
				start = end - range;
				_tmp43_ = zeitgeist_time_range_new (start, end);
				_g_object_unref0 (tr);
				tr = _tmp43_;
				_tmp44_ = tr;
				security_privacy_widgets_clear_usage_dialog_delete_history (self, _tmp44_, NULL, NULL);
				_tmp45_ = self->priv->recent;
				g_object_get (_tmp45_, "size", &_tmp46_, NULL);
				_tmp47_ = _tmp46_;
				if (_tmp47_ > 0) {
					GtkRecentManager* _tmp48_;
					GList* _tmp49_;
					_tmp48_ = self->priv->recent;
					_tmp49_ = gtk_recent_manager_get_items (_tmp48_);
					(self->priv->items == NULL) ? NULL : (self->priv->items = (_g_list_free__gtk_recent_info_unref0_ (self->priv->items), NULL));
					self->priv->items = _tmp49_;
					{
						GList* _tmp50_;
						_tmp50_ = self->priv->items;
						{
							GList* item_collection = NULL;
							GList* item_it = NULL;
							item_collection = _tmp50_;
							for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
								GtkRecentInfo* _tmp51_;
								GtkRecentInfo* item = NULL;
								_tmp51_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
								item = _tmp51_;
								{
									GtkRecentInfo* _tmp52_;
									_tmp52_ = item;
									if (gtk_recent_info_get_age (_tmp52_) <= 7) {
										GtkRecentManager* _tmp53_;
										GtkRecentInfo* _tmp54_;
										const gchar* _tmp55_;
										_tmp53_ = self->priv->recent;
										_tmp54_ = item;
										_tmp55_ = gtk_recent_info_get_uri (_tmp54_);
										gtk_recent_manager_remove_item (_tmp53_, _tmp55_, &_inner_error0_);
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_gtk_recent_info_unref0 (item);
											goto __catch2_g_error;
										}
									}
									_gtk_recent_info_unref0 (item);
								}
							}
						}
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* err = NULL;
						GError* _tmp56_;
						const gchar* _tmp57_;
						err = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp56_ = err;
						_tmp57_ = _tmp56_->message;
						g_critical ("ClearUsageDialog.vala:160: %s", _tmp57_);
						_g_error_free0 (err);
					}
					__finally2:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (tr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			} else {
				GtkCheckButton* _tmp58_;
				gboolean _tmp59_;
				gboolean _tmp60_;
				_tmp58_ = self->priv->from_radio;
				_tmp59_ = gtk_check_button_get_active (_tmp58_);
				_tmp60_ = _tmp59_;
				if (_tmp60_ == TRUE) {
					gint64 start = 0LL;
					GraniteDatePicker* _tmp61_;
					GDateTime* _tmp62_;
					GDateTime* _tmp63_;
					gint64 end = 0LL;
					GraniteDatePicker* _tmp64_;
					GDateTime* _tmp65_;
					GDateTime* _tmp66_;
					ZeitgeistTimeRange* _tmp67_;
					ZeitgeistTimeRange* _tmp68_;
					GtkRecentManager* _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					_tmp61_ = self->priv->from_datepicker;
					_tmp62_ = granite_date_picker_get_date (_tmp61_);
					_tmp63_ = _tmp62_;
					start = g_date_time_to_unix (_tmp63_) * 1000;
					_tmp64_ = self->priv->to_datepicker;
					_tmp65_ = granite_date_picker_get_date (_tmp64_);
					_tmp66_ = _tmp65_;
					end = g_date_time_to_unix (_tmp66_) * 1000;
					_tmp67_ = zeitgeist_time_range_new (start, end);
					_g_object_unref0 (tr);
					tr = _tmp67_;
					_tmp68_ = tr;
					security_privacy_widgets_clear_usage_dialog_delete_history (self, _tmp68_, NULL, NULL);
					_tmp69_ = self->priv->recent;
					g_object_get (_tmp69_, "size", &_tmp70_, NULL);
					_tmp71_ = _tmp70_;
					if (_tmp71_ > 0) {
						GtkRecentManager* _tmp72_;
						GList* _tmp73_;
						_tmp72_ = self->priv->recent;
						_tmp73_ = gtk_recent_manager_get_items (_tmp72_);
						{
							GList* recent_info_collection = NULL;
							GList* recent_info_it = NULL;
							recent_info_collection = _tmp73_;
							for (recent_info_it = recent_info_collection; recent_info_it != NULL; recent_info_it = recent_info_it->next) {
								GtkRecentInfo* recent_info = NULL;
								recent_info = (GtkRecentInfo*) recent_info_it->data;
								{
									GDateTime* info_added = NULL;
									GtkRecentInfo* _tmp74_;
									GDateTime* _tmp75_;
									GDateTime* _tmp76_;
									gboolean _tmp77_ = FALSE;
									GDateTime* _tmp78_;
									GraniteDatePicker* _tmp79_;
									GDateTime* _tmp80_;
									GDateTime* _tmp81_;
									_tmp74_ = recent_info;
									_tmp75_ = gtk_recent_info_get_added (_tmp74_);
									_tmp76_ = _g_date_time_ref0 (_tmp75_);
									info_added = _tmp76_;
									_tmp78_ = info_added;
									_tmp79_ = self->priv->from_datepicker;
									_tmp80_ = granite_date_picker_get_date (_tmp79_);
									_tmp81_ = _tmp80_;
									if (g_date_time_compare (_tmp78_, _tmp81_) >= 0) {
										GDateTime* _tmp82_;
										GraniteDatePicker* _tmp83_;
										GDateTime* _tmp84_;
										GDateTime* _tmp85_;
										_tmp82_ = info_added;
										_tmp83_ = self->priv->to_datepicker;
										_tmp84_ = granite_date_picker_get_date (_tmp83_);
										_tmp85_ = _tmp84_;
										_tmp77_ = g_date_time_compare (_tmp82_, _tmp85_) <= 0;
									} else {
										_tmp77_ = FALSE;
									}
									if (_tmp77_) {
										{
											GtkRecentManager* _tmp86_;
											GtkRecentInfo* _tmp87_;
											const gchar* _tmp88_;
											_tmp86_ = self->priv->recent;
											_tmp87_ = recent_info;
											_tmp88_ = gtk_recent_info_get_uri (_tmp87_);
											gtk_recent_manager_remove_item (_tmp86_, _tmp88_, &_inner_error0_);
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
												goto __catch3_g_error;
											}
										}
										goto __finally3;
										__catch3_g_error:
										{
											GError* err = NULL;
											GError* _tmp89_;
											const gchar* _tmp90_;
											err = _inner_error0_;
											_inner_error0_ = NULL;
											_tmp89_ = err;
											_tmp90_ = _tmp89_->message;
											g_critical ("ClearUsageDialog.vala:180: %s", _tmp90_);
											_g_error_free0 (err);
										}
										__finally3:
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_date_time_unref0 (info_added);
											(recent_info_collection == NULL) ? NULL : (recent_info_collection = (_g_list_free__gtk_recent_info_unref0_ (recent_info_collection), NULL));
											_g_object_unref0 (tr);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
									}
									_g_date_time_unref0 (info_added);
								}
							}
							(recent_info_collection == NULL) ? NULL : (recent_info_collection = (_g_list_free__gtk_recent_info_unref0_ (recent_info_collection), NULL));
						}
					}
				} else {
					GtkCheckButton* _tmp91_;
					gboolean _tmp92_;
					gboolean _tmp93_;
					_tmp91_ = self->priv->all_time_radio;
					_tmp92_ = gtk_check_button_get_active (_tmp91_);
					_tmp93_ = _tmp92_;
					if (_tmp93_ == TRUE) {
						ZeitgeistTimeRange* _tmp94_;
						ZeitgeistTimeRange* _tmp95_;
						GtkRecentManager* _tmp96_;
						gint _tmp97_;
						gint _tmp98_;
						_tmp94_ = zeitgeist_time_range_new_anytime ();
						_g_object_unref0 (tr);
						tr = _tmp94_;
						_tmp95_ = tr;
						security_privacy_widgets_clear_usage_dialog_delete_history (self, _tmp95_, NULL, NULL);
						_tmp96_ = self->priv->recent;
						g_object_get (_tmp96_, "size", &_tmp97_, NULL);
						_tmp98_ = _tmp97_;
						if (_tmp98_ > 0) {
							{
								GtkRecentManager* _tmp99_;
								_tmp99_ = self->priv->recent;
								gtk_recent_manager_purge_items (_tmp99_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch4_g_error;
								}
							}
							goto __finally4;
							__catch4_g_error:
							{
								GError* err = NULL;
								GError* _tmp100_;
								const gchar* _tmp101_;
								err = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp100_ = err;
								_tmp101_ = _tmp100_->message;
								g_critical ("ClearUsageDialog.vala:194: %s", _tmp101_);
								_g_error_free0 (err);
							}
							__finally4:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (tr);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
			}
		}
	}
	gtk_widget_hide ((GtkWidget*) self);
	_g_object_unref0 (tr);
}

static void
_security_privacy_widgets_clear_usage_dialog___lambda15_ (SecurityPrivacyWidgetsClearUsageDialog* self,
                                                          gint response)
{
	if (response == ((gint) GTK_RESPONSE_APPLY)) {
		security_privacy_widgets_clear_usage_dialog_on_clear_data (self);
	}
	g_signal_emit_by_name ((GtkDialog*) self, "close");
}

static void
__security_privacy_widgets_clear_usage_dialog___lambda15__gtk_dialog_response (GtkDialog* _sender,
                                                                               gint response_id,
                                                                               gpointer self)
{
	_security_privacy_widgets_clear_usage_dialog___lambda15_ ((SecurityPrivacyWidgetsClearUsageDialog*) self, response_id);
}

static GObject *
security_privacy_widgets_clear_usage_dialog_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SecurityPrivacyWidgetsClearUsageDialog * self;
	GtkRecentManager* _tmp0_;
	GtkCheckButton* _tmp1_ = NULL;
	GtkCheckButton* _tmp2_;
	GtkCheckButton* _tmp3_;
	GtkCheckButton* _tmp4_ = NULL;
	GtkCheckButton* _tmp5_;
	GtkCheckButton* _tmp6_;
	GtkCheckButton* _tmp7_ = NULL;
	GtkCheckButton* _tmp8_;
	GtkCheckButton* _tmp9_;
	GtkCheckButton* _tmp10_ = NULL;
	GtkCheckButton* _tmp11_;
	GtkCheckButton* _tmp12_;
	GtkCheckButton* _tmp13_ = NULL;
	GraniteDatePicker* _tmp14_;
	GtkLabel* to_label = NULL;
	GtkLabel* _tmp15_;
	GraniteDatePicker* _tmp16_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkGrid* _tmp18_;
	GtkCheckButton* _tmp19_;
	GtkGrid* _tmp20_;
	GtkCheckButton* _tmp21_;
	GtkGrid* _tmp22_;
	GtkCheckButton* _tmp23_;
	GtkGrid* _tmp24_;
	GtkCheckButton* _tmp25_;
	GtkGrid* _tmp26_;
	GraniteDatePicker* _tmp27_;
	GtkGrid* _tmp28_;
	GtkLabel* _tmp29_;
	GtkGrid* _tmp30_;
	GraniteDatePicker* _tmp31_;
	GtkGrid* _tmp32_;
	GtkCheckButton* _tmp33_;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkGrid* _tmp36_;
	GtkWidget* clear_button = NULL;
	GtkWidget* _tmp37_;
	GtkWidget* _tmp38_;
	GtkWidget* _tmp39_;
	parent_class = G_OBJECT_CLASS (security_privacy_widgets_clear_usage_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_WIDGETS_TYPE_CLEAR_USAGE_DIALOG, SecurityPrivacyWidgetsClearUsageDialog);
	_tmp0_ = gtk_recent_manager_new ();
	_g_object_unref0 (self->priv->recent);
	self->priv->recent = _tmp0_;
	_tmp1_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("The past hour"));
	gtk_check_button_set_active (_tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->past_hour_radio);
	self->priv->past_hour_radio = _tmp1_;
	_tmp2_ = self->priv->past_hour_radio;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("The past day"));
	gtk_check_button_set_group (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->past_day_radio);
	self->priv->past_day_radio = _tmp4_;
	_tmp5_ = self->priv->past_hour_radio;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_tmp7_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("The past week"));
	gtk_check_button_set_group (_tmp7_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->past_week_radio);
	self->priv->past_week_radio = _tmp7_;
	_tmp8_ = self->priv->past_hour_radio;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_tmp10_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("From:"));
	gtk_check_button_set_group (_tmp10_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->from_radio);
	self->priv->from_radio = _tmp10_;
	_tmp11_ = self->priv->past_hour_radio;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_tmp13_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("All time"));
	gtk_check_button_set_group (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->all_time_radio);
	self->priv->all_time_radio = _tmp13_;
	_tmp14_ = granite_date_picker_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->from_datepicker);
	self->priv->from_datepicker = _tmp14_;
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("To:"));
	g_object_ref_sink (_tmp15_);
	to_label = _tmp15_;
	_tmp16_ = granite_date_picker_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->to_datepicker);
	self->priv->to_datepicker = _tmp16_;
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp17_, 12);
	gtk_grid_set_row_spacing (_tmp17_, 6);
	g_object_ref_sink (_tmp17_);
	grid = _tmp17_;
	_tmp18_ = grid;
	_tmp19_ = self->priv->past_hour_radio;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 0, 1, 4, 1);
	_tmp20_ = grid;
	_tmp21_ = self->priv->past_day_radio;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 2, 4, 1);
	_tmp22_ = grid;
	_tmp23_ = self->priv->past_week_radio;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 3, 4, 1);
	_tmp24_ = grid;
	_tmp25_ = self->priv->from_radio;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 4, 1, 1);
	_tmp26_ = grid;
	_tmp27_ = self->priv->from_datepicker;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 1, 4, 1, 1);
	_tmp28_ = grid;
	_tmp29_ = to_label;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 2, 4, 1, 1);
	_tmp30_ = grid;
	_tmp31_ = self->priv->to_datepicker;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 3, 4, 1, 1);
	_tmp32_ = grid;
	_tmp33_ = self->priv->all_time_radio;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 0, 5, 4, 1);
	_tmp34_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = grid;
	gtk_box_append (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Clear History"), (gint) GTK_RESPONSE_APPLY);
	_tmp38_ = _g_object_ref0 (_tmp37_);
	clear_button = _tmp38_;
	_tmp39_ = clear_button;
	gtk_widget_add_css_class (_tmp39_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __security_privacy_widgets_clear_usage_dialog___lambda15__gtk_dialog_response, self, 0);
	_g_object_unref0 (clear_button);
	_g_object_unref0 (grid);
	_g_object_unref0 (to_label);
	return obj;
}

static void
security_privacy_widgets_clear_usage_dialog_class_init (SecurityPrivacyWidgetsClearUsageDialogClass * klass,
                                                        gpointer klass_data)
{
	security_privacy_widgets_clear_usage_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyWidgetsClearUsageDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = security_privacy_widgets_clear_usage_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = security_privacy_widgets_clear_usage_dialog_finalize;
}

static void
security_privacy_widgets_clear_usage_dialog_instance_init (SecurityPrivacyWidgetsClearUsageDialog * self,
                                                           gpointer klass)
{
	self->priv = security_privacy_widgets_clear_usage_dialog_get_instance_private (self);
}

static void
security_privacy_widgets_clear_usage_dialog_finalize (GObject * obj)
{
	SecurityPrivacyWidgetsClearUsageDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_WIDGETS_TYPE_CLEAR_USAGE_DIALOG, SecurityPrivacyWidgetsClearUsageDialog);
	_g_object_unref0 (self->priv->to_datepicker);
	_g_object_unref0 (self->priv->from_datepicker);
	_g_object_unref0 (self->priv->all_time_radio);
	_g_object_unref0 (self->priv->from_radio);
	_g_object_unref0 (self->priv->past_hour_radio);
	_g_object_unref0 (self->priv->past_day_radio);
	_g_object_unref0 (self->priv->past_week_radio);
	_g_object_unref0 (self->priv->recent);
	(self->priv->items == NULL) ? NULL : (self->priv->items = (_g_list_free__gtk_recent_info_unref0_ (self->priv->items), NULL));
	G_OBJECT_CLASS (security_privacy_widgets_clear_usage_dialog_parent_class)->finalize (obj);
}

static GType
security_privacy_widgets_clear_usage_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyWidgetsClearUsageDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_widgets_clear_usage_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyWidgetsClearUsageDialog), 0, (GInstanceInitFunc) security_privacy_widgets_clear_usage_dialog_instance_init, NULL };
	GType security_privacy_widgets_clear_usage_dialog_type_id;
	security_privacy_widgets_clear_usage_dialog_type_id = g_type_register_static (GRANITE_TYPE_MESSAGE_DIALOG, "SecurityPrivacyWidgetsClearUsageDialog", &g_define_type_info, 0);
	SecurityPrivacyWidgetsClearUsageDialog_private_offset = g_type_add_instance_private (security_privacy_widgets_clear_usage_dialog_type_id, sizeof (SecurityPrivacyWidgetsClearUsageDialogPrivate));
	return security_privacy_widgets_clear_usage_dialog_type_id;
}

GType
security_privacy_widgets_clear_usage_dialog_get_type (void)
{
	static volatile gsize security_privacy_widgets_clear_usage_dialog_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_widgets_clear_usage_dialog_type_id__once)) {
		GType security_privacy_widgets_clear_usage_dialog_type_id;
		security_privacy_widgets_clear_usage_dialog_type_id = security_privacy_widgets_clear_usage_dialog_get_type_once ();
		g_once_init_leave (&security_privacy_widgets_clear_usage_dialog_type_id__once, security_privacy_widgets_clear_usage_dialog_type_id);
	}
	return security_privacy_widgets_clear_usage_dialog_type_id__once;
}

