/* HardwareView.c generated by valac 0.56.18, the Vala compiler
 * generated from HardwareView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017–2023 elementary, Inc. (https://elementary.io)
 *                         2020 Justin Haygood <jhaygood86@gmail.com>
 *                         2010 Red Hat, Inc
 *                         2008 William Jon McCann <jmccann@redhat.com>
 */

#include "system.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <polkit/polkit.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <glibtop/sysinfo.h>
#include <glibtop.h>
#include <gee.h>
#include <gudev/gudev.h>
#include <glibtop/mem.h>
#include <udisks/udisks.h>
#include <unistd.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <adwaita.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ABOUT_HARDWARE_VIEW_0_PROPERTY,
	ABOUT_HARDWARE_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_hardware_view_properties[ABOUT_HARDWARE_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AboutHardwareViewLoadFallbackManufacturerIconData AboutHardwareViewLoadFallbackManufacturerIconData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AboutHardwareViewGetGpuInfoData AboutHardwareViewGetGpuInfoData;
typedef struct _AboutHardwareViewGetGraphicsInfoData AboutHardwareViewGetGraphicsInfoData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _AboutHardwareViewGetStorageInfoData AboutHardwareViewGetStorageInfoData;

#define ABOUT_HARDWARE_VIEW_TYPE_REPLACE_STRINGS (about_hardware_view_replace_strings_get_type ())
typedef struct _AboutHardwareViewReplaceStrings AboutHardwareViewReplaceStrings;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _AboutHardwareViewGetStorageTypeData AboutHardwareViewGetStorageTypeData;
typedef struct _AboutHardwareViewGetPartitionNameData AboutHardwareViewGetPartitionNameData;
typedef struct _AboutHardwareViewGetDiskNameData AboutHardwareViewGetDiskNameData;
typedef struct _AboutHardwareViewSetHostNameData AboutHardwareViewSetHostNameData;
typedef GDBusProxy SystemInterfaceProxy;
typedef GDBusProxyClass SystemInterfaceProxyClass;
typedef struct _SystemInterfaceSetPrettyHostnameReadyData SystemInterfaceSetPrettyHostnameReadyData;
typedef struct _SystemInterfaceSetStaticHostnameReadyData SystemInterfaceSetStaticHostnameReadyData;
typedef GDBusProxy SessionManagerProxy;
typedef GDBusProxyClass SessionManagerProxyClass;
typedef GDBusProxy SwitcherooControlProxy;
typedef GDBusProxyClass SwitcherooControlProxyClass;

struct _AboutHardwareViewPrivate {
	gboolean oem_enabled;
	gchar* manufacturer_icon_path;
	gchar* manufacturer_icon_dark_path;
	gchar* manufacturer_name;
	gchar* manufacturer_support_url;
	gchar* memory;
	gchar* processor;
	gchar* product_name;
	gchar* product_version;
	SystemInterface* system_interface;
	PolkitPermission* hostname_permission;
	SessionManager* session_manager;
	SwitcherooControl* switcheroo_interface;
	GtkEntry* hostname_entry;
	GtkImage* manufacturer_logo;
	GtkLabel* primary_graphics_info;
	GtkLabel* secondary_graphics_info;
	GtkBox* graphics_box;
	GtkLabel* storage_info;
	GraniteSettings* granite_settings;
};

struct _AboutHardwareViewLoadFallbackManufacturerIconData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	SystemInterface* _tmp0_;
	GtkImage* _tmp1_;
	gchar* icon_name;
	SystemInterface* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	const gchar* _tmp12_;
};

struct _AboutHardwareViewGetGpuInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	gboolean primary;
	gchar* result;
	SessionManager* _tmp0_;
	SessionManager* _tmp1_;
	SessionManager* _tmp2_;
	SessionManager* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	SwitcherooControl* _tmp6_;
	SwitcherooControl* _tmp7_;
	SwitcherooControl* _tmp8_;
	SwitcherooControl* _tmp9_;
	GError* _vala1_e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gchar* gpu_name;
	SwitcherooControl* _tmp12_;
	gboolean _tmp13_;
	SwitcherooControl* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	SwitcherooControl* _tmp17_;
	GHashTable** _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	GHashTable** _tmp20_;
	gint _tmp20__length1;
	GHashTable** gpu_collection;
	gint gpu_collection_length1;
	gint _gpu_collection_size_;
	gint gpu_it;
	GHashTable* gpu;
	gboolean is_default;
	GHashTable* _tmp21_;
	gconstpointer _tmp22_;
	const gchar* candidate;
	GHashTable* _tmp23_;
	gconstpointer _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	SessionManager* _tmp30_;
	SessionManager* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GError* _inner_error0_;
};

struct _AboutHardwareViewGetGraphicsInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	gchar* primary_gpu;
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	gchar* secondary_gpu;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_;
	const gchar* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
};

struct _AboutHardwareViewGetStorageInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	GFile* file_root;
	GFile* _tmp0_;
	gchar* storage_capacity;
	gchar* _tmp1_;
	guint64 storage_total;
	UDisksClient* client;
	UDisksClient* _tmp2_;
	UDisksClient* _tmp3_;
	GDBusObjectManager* _tmp4_;
	GDBusObjectManager* _tmp5_;
	GList* _tmp6_;
	GList* object_collection;
	GList* object_it;
	GDBusObject* object;
	UDisksDrive* drive;
	GDBusObject* _tmp7_;
	UDisksDrive* _tmp8_;
	UDisksDrive* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	UDisksDrive* _tmp12_;
	UDisksDrive* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	UDisksDrive* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	UDisksDrive* _tmp19_;
	guint64 _tmp20_;
	guint64 _tmp21_;
	gchar* _tmp22_;
	GtkLabel* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GError* e;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GFileInfo* info;
	GFile* _tmp29_;
	GFileInfo* _tmp30_;
	GFileInfo* _tmp31_;
	gchar* _tmp32_;
	GError* _vala1_e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GtkLabel* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GError* _inner_error0_;
};

struct _AboutHardwareViewReplaceStrings {
	gchar* regex;
	gchar* replacement;
};

struct _AboutHardwareViewGetStorageTypeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	gchar* storage_capacity;
	gchar* result;
	gchar* partition_name;
	gchar* _tmp0_;
	gchar* disk_name;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* path;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* storage;
	gchar* _tmp5_;
	GFile* file;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFileInputStream* _tmp8_;
	GFile* _tmp9_;
	GFileInputStream* _tmp10_;
	GDataInputStream* dis;
	GDataInputStream* _tmp11_;
	gchar* contents;
	GDataInputStream* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _inner_error0_;
};

struct _AboutHardwareViewGetPartitionNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	gchar* result;
	gchar* df_stdout;
	gchar* partition;
	gchar* _tmp0_;
	GSubprocess* subprocess;
	GSubprocess* _tmp1_;
	GSubprocess* _tmp2_;
	gchar* _tmp3_;
	gchar** output;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint output_length1;
	gint _output_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** line_collection;
	gint line_collection_length1;
	gint _line_collection_size_;
	gint line_it;
	gchar* _tmp8_;
	gchar* line;
	const gchar* _tmp9_;
	gint idx;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

struct _AboutHardwareViewGetDiskNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	gchar* partition;
	gchar* result;
	gchar* lsblk_stout;
	gchar* disk_name;
	gchar* _tmp0_;
	GSubprocess* subprocess;
	GSubprocess* _tmp1_;
	GSubprocess* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _AboutHardwareViewSetHostNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutHardwareView* self;
	gchar* hostname;
	SystemInterface* _tmp0_;
	PolkitPermission* _tmp1_;
	gchar* static_hostname;
	gchar* _tmp2_;
	SystemInterface* _tmp3_;
	SystemInterface* _tmp4_;
	const gchar* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _SystemInterfaceSetPrettyHostnameReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* hostname;
	gboolean interactive;
};

struct _SystemInterfaceSetStaticHostnameReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* hostname;
	gboolean interactive;
};

static gint AboutHardwareView_private_offset;
static gpointer about_hardware_view_parent_class = NULL;

static void about_hardware_view_on_hostname_entry_activate (AboutHardwareView* self);
static void about_hardware_view_set_host_name (AboutHardwareView* self,
                                        const gchar* hostname,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void about_hardware_view_set_host_name_finish (AboutHardwareView* self,
                                               GAsyncResult* _res_);
static void __lambda17_ (AboutHardwareView* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void about_hardware_view_update_manufacturer_logo (AboutHardwareView* self);
static void about_hardware_view_load_fallback_manufacturer_icon (AboutHardwareView* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void about_hardware_view_load_fallback_manufacturer_icon_finish (AboutHardwareView* self,
                                                                 GAsyncResult* _res_);
static void about_hardware_view_load_fallback_manufacturer_icon_data_free (gpointer _data);
static gboolean about_hardware_view_load_fallback_manufacturer_icon_co (AboutHardwareViewLoadFallbackManufacturerIconData* _data_);
static void about_hardware_view_get_system_interface_instance (AboutHardwareView* self);
static gchar* about_hardware_view_try_get_arm_model (AboutHardwareView* self,
                                              GHashTable* values);
static gchar* about_hardware_view_get_cpu_info (AboutHardwareView* self);
static gchar* about_hardware_view_clean_name (AboutHardwareView* self,
                                       const gchar* info);
static void about_hardware_view_get_gpu_info_data_free (gpointer _data);
static void about_hardware_view_get_gpu_info (AboutHardwareView* self,
                                       gboolean primary,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gchar* about_hardware_view_get_gpu_info_finish (AboutHardwareView* self,
                                                GAsyncResult* _res_);
static gboolean about_hardware_view_get_gpu_info_co (AboutHardwareViewGetGpuInfoData* _data_);
static void about_hardware_view_get_gpu_info_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void about_hardware_view_get_graphics_info_data_free (gpointer _data);
static void about_hardware_view_get_graphics_info (AboutHardwareView* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void about_hardware_view_get_graphics_info_finish (AboutHardwareView* self,
                                                   GAsyncResult* _res_);
static gboolean about_hardware_view_get_graphics_info_co (AboutHardwareViewGetGraphicsInfoData* _data_);
static void about_hardware_view_get_graphics_info_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static gchar* about_hardware_view_get_mem_info (AboutHardwareView* self);
static gchar* about_hardware_view_custom_format_size (AboutHardwareView* self,
                                               guint64 size,
                                               gboolean iec_unit);
static void about_hardware_view_fetch_hardware_info (AboutHardwareView* self);
static void about_hardware_view_get_storage_info (AboutHardwareView* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void about_hardware_view_get_storage_info_finish (AboutHardwareView* self,
                                                  GAsyncResult* _res_);
static void about_hardware_view_get_storage_info_data_free (gpointer _data);
static gboolean about_hardware_view_get_storage_info_co (AboutHardwareViewGetStorageInfoData* _data_);
static void about_hardware_view_get_storage_info_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void about_hardware_view_get_storage_type (AboutHardwareView* self,
                                           const gchar* storage_capacity,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gchar* about_hardware_view_get_storage_type_finish (AboutHardwareView* self,
                                                    GAsyncResult* _res_);
static GType about_hardware_view_replace_strings_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static AboutHardwareViewReplaceStrings* about_hardware_view_replace_strings_dup (const AboutHardwareViewReplaceStrings* self);
static void about_hardware_view_replace_strings_free (AboutHardwareViewReplaceStrings* self);
static void about_hardware_view_replace_strings_copy (const AboutHardwareViewReplaceStrings* self,
                                               AboutHardwareViewReplaceStrings* dest);
static void about_hardware_view_replace_strings_destroy (AboutHardwareViewReplaceStrings* self);
static void about_hardware_view_get_storage_type_data_free (gpointer _data);
static gboolean about_hardware_view_get_storage_type_co (AboutHardwareViewGetStorageTypeData* _data_);
static void about_hardware_view_get_partition_name (AboutHardwareView* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gchar* about_hardware_view_get_partition_name_finish (AboutHardwareView* self,
                                                      GAsyncResult* _res_);
static void about_hardware_view_get_storage_type_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void about_hardware_view_get_disk_name (AboutHardwareView* self,
                                        const gchar* partition,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gchar* about_hardware_view_get_disk_name_finish (AboutHardwareView* self,
                                                 GAsyncResult* _res_);
static void about_hardware_view_get_partition_name_data_free (gpointer _data);
static gboolean about_hardware_view_get_partition_name_co (AboutHardwareViewGetPartitionNameData* _data_);
static void about_hardware_view_get_partition_name_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void about_hardware_view_get_disk_name_data_free (gpointer _data);
static gboolean about_hardware_view_get_disk_name_co (AboutHardwareViewGetDiskNameData* _data_);
static void about_hardware_view_get_disk_name_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void about_hardware_view_request_hostname_permission (AboutHardwareView* self);
static gboolean about_hardware_view_has_hostname_permission (AboutHardwareView* self);
static gchar* about_hardware_view_generate_hostname (AboutHardwareView* self,
                                              const gchar* pretty_hostname);
static gchar* about_hardware_view_get_host_name (AboutHardwareView* self);
static void about_hardware_view_set_host_name_data_free (gpointer _data);
static gboolean about_hardware_view_set_host_name_co (AboutHardwareViewSetHostNameData* _data_);
static void about_hardware_view_set_host_name_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static GObject * about_hardware_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _about_hardware_view___lambda18_ (AboutHardwareView* self);
static void __about_hardware_view___lambda18__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _about_hardware_view___lambda19_ (AboutHardwareView* self);
static void __about_hardware_view___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                                             gpointer self);
static void _about_hardware_view_on_hostname_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                         gpointer self);
static void _about_hardware_view___lambda20_ (AboutHardwareView* self,
                                       GtkEntryIconPosition icon_pos);
static void __about_hardware_view___lambda20__gtk_entry_icon_release (GtkEntry* _sender,
                                                               GtkEntryIconPosition icon_pos,
                                                               gpointer self);
static void about_hardware_view_finalize (GObject * obj);
static GType about_hardware_view_get_type_once (void);
static GType system_interface_get_type_once (void);
static void system_interface_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void system_interface_proxy_set_pretty_hostname_async (SystemInterface* self,
                                                       const gchar* hostname,
                                                       gboolean interactive,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void system_interface_proxy_set_pretty_hostname_finish (SystemInterface* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void system_interface_proxy_set_static_hostname_async (SystemInterface* self,
                                                       const gchar* hostname,
                                                       gboolean interactive,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void system_interface_proxy_set_static_hostname_finish (SystemInterface* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static gchar* system_interface_dbus_proxy_get_icon_name (SystemInterface* self);
static gchar* system_interface_dbus_proxy_get_pretty_hostname (SystemInterface* self);
static gchar* system_interface_dbus_proxy_get_static_hostname (SystemInterface* self);
static void system_interface_proxy_system_interface_interface_init (SystemInterfaceIface* iface);
static void _dbus_system_interface_set_pretty_hostname (SystemInterface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_system_interface_set_pretty_hostname_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_system_interface_set_static_hostname (SystemInterface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_system_interface_set_static_hostname_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void system_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* system_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static GVariant* _dbus_system_interface_get_icon_name (SystemInterface* self);
static GVariant* _dbus_system_interface_get_pretty_hostname (SystemInterface* self);
static GVariant* _dbus_system_interface_get_static_hostname (SystemInterface* self);
static gboolean system_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _system_interface_unregister_object (gpointer user_data);
static GType session_manager_get_type_once (void);
static void session_manager_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters);
static gchar* session_manager_dbus_proxy_get_renderer (SessionManager* self);
static void session_manager_proxy_session_manager_interface_init (SessionManagerIface* iface);
static void session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static GVariant* _dbus_session_manager_get_renderer (SessionManager* self);
static gboolean session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _session_manager_unregister_object (gpointer user_data);
static GType switcheroo_control_get_type_once (void);
static void switcheroo_control_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static gboolean switcheroo_control_dbus_proxy_get_has_dual_gpu (SwitcherooControl* self);
static GHashTable** switcheroo_control_dbus_proxy_get_gpus (SwitcherooControl* self,
                                                     gint* result_length1);
static void switcheroo_control_proxy_switcheroo_control_interface_init (SwitcherooControlIface* iface);
static void switcheroo_control_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* switcheroo_control_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static GVariant* _dbus_switcheroo_control_get_has_dual_gpu (SwitcherooControl* self);
static GVariant* _dbus_switcheroo_control_get_gpus (SwitcherooControl* self);
static gboolean switcheroo_control_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _switcheroo_control_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _system_interface_dbus_arg_info_set_pretty_hostname_hostname = {-1, "hostname", "s", NULL};
static const GDBusArgInfo _system_interface_dbus_arg_info_set_pretty_hostname_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_set_pretty_hostname_in[] = {&_system_interface_dbus_arg_info_set_pretty_hostname_hostname, &_system_interface_dbus_arg_info_set_pretty_hostname_interactive, NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_set_pretty_hostname_out[] = {NULL};
static const GDBusMethodInfo _system_interface_dbus_method_info_set_pretty_hostname = {-1, "SetPrettyHostname", (GDBusArgInfo **) (&_system_interface_dbus_arg_info_set_pretty_hostname_in), (GDBusArgInfo **) (&_system_interface_dbus_arg_info_set_pretty_hostname_out), NULL};
static const GDBusArgInfo _system_interface_dbus_arg_info_set_static_hostname_hostname = {-1, "hostname", "s", NULL};
static const GDBusArgInfo _system_interface_dbus_arg_info_set_static_hostname_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_set_static_hostname_in[] = {&_system_interface_dbus_arg_info_set_static_hostname_hostname, &_system_interface_dbus_arg_info_set_static_hostname_interactive, NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_set_static_hostname_out[] = {NULL};
static const GDBusMethodInfo _system_interface_dbus_method_info_set_static_hostname = {-1, "SetStaticHostname", (GDBusArgInfo **) (&_system_interface_dbus_arg_info_set_static_hostname_in), (GDBusArgInfo **) (&_system_interface_dbus_arg_info_set_static_hostname_out), NULL};
static const GDBusMethodInfo * const _system_interface_dbus_method_info[] = {&_system_interface_dbus_method_info_set_pretty_hostname, &_system_interface_dbus_method_info_set_static_hostname, NULL};
static const GDBusSignalInfo * const _system_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _system_interface_dbus_property_info_icon_name = {-1, "IconName", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _system_interface_dbus_property_info_pretty_hostname = {-1, "PrettyHostname", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _system_interface_dbus_property_info_static_hostname = {-1, "StaticHostname", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _system_interface_dbus_property_info[] = {&_system_interface_dbus_property_info_icon_name, &_system_interface_dbus_property_info_pretty_hostname, &_system_interface_dbus_property_info_static_hostname, NULL};
static const GDBusInterfaceInfo _system_interface_dbus_interface_info = {-1, "org.freedesktop.hostname1", (GDBusMethodInfo **) (&_system_interface_dbus_method_info), (GDBusSignalInfo **) (&_system_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_system_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _system_interface_dbus_interface_vtable = {system_interface_dbus_interface_method_call, system_interface_dbus_interface_get_property, system_interface_dbus_interface_set_property};
static const GDBusMethodInfo * const _session_manager_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _session_manager_dbus_property_info_renderer = {-1, "Renderer", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _session_manager_dbus_property_info[] = {&_session_manager_dbus_property_info_renderer, NULL};
static const GDBusInterfaceInfo _session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_session_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _session_manager_dbus_interface_vtable = {session_manager_dbus_interface_method_call, session_manager_dbus_interface_get_property, session_manager_dbus_interface_set_property};
static const GDBusMethodInfo * const _switcheroo_control_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _switcheroo_control_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _switcheroo_control_dbus_property_info_has_dual_gpu = {-1, "HasDualGpu", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _switcheroo_control_dbus_property_info_gpus = {-1, "GPUs", "aa{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _switcheroo_control_dbus_property_info[] = {&_switcheroo_control_dbus_property_info_has_dual_gpu, &_switcheroo_control_dbus_property_info_gpus, NULL};
static const GDBusInterfaceInfo _switcheroo_control_dbus_interface_info = {-1, "net.hadess.SwitcherooControl", (GDBusMethodInfo **) (&_switcheroo_control_dbus_method_info), (GDBusSignalInfo **) (&_switcheroo_control_dbus_signal_info), (GDBusPropertyInfo **) (&_switcheroo_control_dbus_property_info), NULL};
static const GDBusInterfaceVTable _switcheroo_control_dbus_interface_vtable = {switcheroo_control_dbus_interface_method_call, switcheroo_control_dbus_interface_get_property, switcheroo_control_dbus_interface_set_property};

static inline gpointer
about_hardware_view_get_instance_private (AboutHardwareView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutHardwareView_private_offset);
}

static void
__lambda17_ (AboutHardwareView* self,
             GObject* obj,
             GAsyncResult* res)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	g_return_if_fail (res != NULL);
	about_hardware_view_set_host_name_finish (self, res);
	_tmp0_ = self->priv->hostname_entry;
	g_object_set (_tmp0_, "secondary-icon-name", "process-completed-symbolic", NULL);
	_tmp1_ = self->priv->hostname_entry;
	g_object_set (_tmp1_, "secondary-icon-tooltip-text", _ ("Device name saved"), NULL);
	_tmp2_ = self->priv->hostname_entry;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp2_, "spin");
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ ((AboutHardwareView*) self, source_object, res);
	g_object_unref (self);
}

static void
about_hardware_view_on_hostname_entry_activate (AboutHardwareView* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hostname_entry;
	g_object_set (_tmp0_, "secondary-icon-name", "process-working-symbolic", NULL);
	_tmp1_ = self->priv->hostname_entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, "spin");
	_tmp2_ = self->priv->hostname_entry;
	_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
	_tmp4_ = _tmp3_;
	about_hardware_view_set_host_name (self, _tmp4_, ___lambda17__gasync_ready_callback, g_object_ref (self));
}

static void
about_hardware_view_update_manufacturer_logo (AboutHardwareView* self)
{
	GtkImage* _tmp17_;
	GIcon* _tmp18_;
	GIcon* _tmp19_;
	GIcon* _tmp20_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	if (self->priv->oem_enabled) {
		gchar* path = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GraniteSettings* _tmp3_;
		GraniteSettingsColorScheme _tmp4_;
		GraniteSettingsColorScheme _tmp5_;
		GFileIcon* fileicon = NULL;
		const gchar* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFileIcon* _tmp12_;
		GFileIcon* _tmp13_;
		const gchar* _tmp14_;
		_tmp0_ = self->priv->manufacturer_icon_path;
		_tmp1_ = g_strdup (_tmp0_);
		path = _tmp1_;
		_tmp3_ = self->priv->granite_settings;
		_tmp4_ = granite_settings_get_prefers_color_scheme (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
			const gchar* _tmp6_;
			_tmp6_ = self->priv->manufacturer_icon_dark_path;
			_tmp2_ = _tmp6_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->manufacturer_icon_dark_path;
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (path);
			path = _tmp8_;
		}
		_tmp9_ = path;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = (GFileIcon*) g_file_icon_new (_tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		fileicon = _tmp13_;
		_tmp14_ = path;
		if (_tmp14_ != NULL) {
			GtkImage* _tmp15_;
			GFileIcon* _tmp16_;
			_tmp15_ = self->priv->manufacturer_logo;
			_tmp16_ = fileicon;
			g_object_set (_tmp15_, "gicon", (GIcon*) _tmp16_, NULL);
		}
		_g_object_unref0 (fileicon);
		_g_free0 (path);
	}
	_tmp17_ = self->priv->manufacturer_logo;
	g_object_get (_tmp17_, "gicon", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_ == NULL;
	_g_object_unref0 (_tmp20_);
	if (_tmp21_) {
		about_hardware_view_load_fallback_manufacturer_icon (self, NULL, NULL);
	}
}

static void
about_hardware_view_load_fallback_manufacturer_icon_data_free (gpointer _data)
{
	AboutHardwareViewLoadFallbackManufacturerIconData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewLoadFallbackManufacturerIconData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
about_hardware_view_load_fallback_manufacturer_icon (AboutHardwareView* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	AboutHardwareViewLoadFallbackManufacturerIconData* _data_;
	AboutHardwareView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewLoadFallbackManufacturerIconData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_load_fallback_manufacturer_icon_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_hardware_view_load_fallback_manufacturer_icon_co (_data_);
}

static void
about_hardware_view_load_fallback_manufacturer_icon_finish (AboutHardwareView* self,
                                                            GAsyncResult* _res_)
{
	AboutHardwareViewLoadFallbackManufacturerIconData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
about_hardware_view_load_fallback_manufacturer_icon_co (AboutHardwareViewLoadFallbackManufacturerIconData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	about_hardware_view_get_system_interface_instance (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->system_interface;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = _data_->self->priv->manufacturer_logo;
		g_object_set (_data_->_tmp1_, "icon-name", "computer", NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->system_interface;
	_data_->_tmp3_ = system_interface_get_icon_name (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->icon_name = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->icon_name;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp5_ = TRUE;
	} else {
		_data_->_tmp7_ = _data_->icon_name;
		_data_->_tmp8_ = strlen (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp5_ = _data_->_tmp9_ == 0;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp10_ = _data_->self->priv->manufacturer_logo;
		g_object_set (_data_->_tmp10_, "icon-name", "computer", NULL);
		_g_free0 (_data_->icon_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->self->priv->manufacturer_logo;
	_data_->_tmp12_ = _data_->icon_name;
	g_object_set (_data_->_tmp11_, "icon-name", _data_->_tmp12_, NULL);
	_g_free0 (_data_->icon_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
about_hardware_view_try_get_arm_model (AboutHardwareView* self,
                                       GHashTable* values)
{
	gchar* cpu_implementer = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_;
	gchar* cpu_part = NULL;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (values != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (values, "CPU implementer");
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	cpu_implementer = _tmp1_;
	_tmp2_ = g_hash_table_lookup (values, "CPU part");
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	cpu_part = _tmp3_;
	_tmp5_ = cpu_implementer;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = cpu_part;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		result = NULL;
		_g_free0 (cpu_part);
		_g_free0 (cpu_implementer);
		return result;
	}
	_tmp7_ = cpu_implementer;
	_tmp8_ = cpu_part;
	_tmp9_ = about_arm_part_decoder_decode_arm_model (_tmp7_, _tmp8_);
	result = _tmp9_;
	_g_free0 (cpu_part);
	_g_free0 (cpu_implementer);
	return result;
}

static guint
uint_parse (const gchar* str,
            guint _base)
{
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	result = (guint) strtoul (str, NULL, (gint) _base);
	return result;
}

static gchar*
about_hardware_view_get_cpu_info (AboutHardwareView* self)
{
	glibtop_sysinfo* info = NULL;
	glibtop_sysinfo* _tmp0_;
	GeeHashMap* counts = NULL;
	GeeHashMap* _tmp1_;
	static const gchar* KEYS[3] = {"model name", "cpu", "Processor"};
	GeeHashMap* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gchar* _result_ = NULL;
	gchar* _tmp37_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	info = glibtop_get_sysinfo ();
	_tmp0_ = info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	counts = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				glibtop_sysinfo* _tmp4_;
				GHashTable* values = NULL;
				glibtop_sysinfo* _tmp5_;
				glibtop_entry* _tmp6_;
				gint _tmp6__length1;
				glibtop_entry _tmp7_;
				GHashTable* _tmp8_;
				gchar* model = NULL;
				const gchar* _tmp14_;
				gchar* core_count = NULL;
				GHashTable* _tmp18_;
				gconstpointer _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				GeeHashMap* _tmp25_;
				const gchar* _tmp26_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = info;
				if (!(((guint64) i) < (*_tmp4_).ncpu)) {
					break;
				}
				_tmp5_ = info;
				_tmp6_ = (*_tmp5_).cpuinfo;
				_tmp6__length1 = -1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = _tmp7_.values;
				values = _tmp8_;
				model = NULL;
				{
					const gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = KEYS;
					key_collection_length1 = G_N_ELEMENTS (KEYS);
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						const gchar* key = NULL;
						key = key_collection[key_it];
						{
							GHashTable* _tmp9_;
							const gchar* _tmp10_;
							gconstpointer _tmp11_;
							gchar* _tmp12_;
							const gchar* _tmp13_;
							_tmp9_ = values;
							_tmp10_ = key;
							_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
							_tmp12_ = g_strdup ((const gchar*) _tmp11_);
							_g_free0 (model);
							model = _tmp12_;
							_tmp13_ = model;
							if (_tmp13_ != NULL) {
								break;
							}
						}
					}
				}
				_tmp14_ = model;
				if (_tmp14_ == NULL) {
					GHashTable* _tmp15_;
					gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = values;
					_tmp16_ = about_hardware_view_try_get_arm_model (self, _tmp15_);
					_g_free0 (model);
					model = _tmp16_;
					_tmp17_ = model;
					if (_tmp17_ == NULL) {
						_g_free0 (model);
						continue;
					}
				}
				_tmp18_ = values;
				_tmp19_ = g_hash_table_lookup (_tmp18_, "cpu cores");
				_tmp20_ = g_strdup ((const gchar*) _tmp19_);
				core_count = _tmp20_;
				_tmp21_ = core_count;
				if (_tmp21_ != NULL) {
					GeeHashMap* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp22_ = counts;
					_tmp23_ = model;
					_tmp24_ = core_count;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, _tmp23_, (gpointer) ((guintptr) uint_parse (_tmp24_, (guint) 0)));
					_g_free0 (core_count);
					_g_free0 (model);
					continue;
				}
				_tmp25_ = counts;
				_tmp26_ = model;
				if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp25_, _tmp26_)) {
					GeeHashMap* _tmp27_;
					const gchar* _tmp28_;
					_tmp27_ = counts;
					_tmp28_ = model;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, (gpointer) ((guintptr) 1));
				} else {
					GeeHashMap* _tmp29_;
					const gchar* _tmp30_;
					GeeHashMap* _tmp31_;
					const gchar* _tmp32_;
					gpointer _tmp33_;
					_tmp29_ = counts;
					_tmp30_ = model;
					_tmp31_ = counts;
					_tmp32_ = model;
					_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp31_, _tmp32_);
					gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp30_, (gpointer) ((guintptr) (((guint) ((guintptr) _tmp33_)) + 1)));
				}
				_g_free0 (core_count);
				_g_free0 (model);
			}
		}
	}
	_tmp34_ = counts;
	_tmp35_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == 0) {
		result = NULL;
		_g_object_unref0 (counts);
		return result;
	}
	_tmp37_ = g_strdup ("");
	_result_ = _tmp37_;
	{
		GeeIterator* _cpu_it = NULL;
		GeeHashMap* _tmp38_;
		GeeSet* _tmp39_;
		GeeSet* _tmp40_;
		GeeSet* _tmp41_;
		GeeIterator* _tmp42_;
		GeeIterator* _tmp43_;
		_tmp38_ = counts;
		_tmp39_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_;
		_tmp42_ = gee_iterable_iterator ((GeeIterable*) _tmp41_);
		_tmp43_ = _tmp42_;
		_g_object_unref0 (_tmp41_);
		_cpu_it = _tmp43_;
		while (TRUE) {
			GeeIterator* _tmp44_;
			GeeMapEntry* cpu = NULL;
			GeeIterator* _tmp45_;
			gpointer _tmp46_;
			const gchar* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			GeeMapEntry* _tmp52_;
			gconstpointer _tmp53_;
			gconstpointer _tmp54_;
			_tmp44_ = _cpu_it;
			if (!gee_iterator_next (_tmp44_)) {
				break;
			}
			_tmp45_ = _cpu_it;
			_tmp46_ = gee_iterator_get (_tmp45_);
			cpu = (GeeMapEntry*) _tmp46_;
			_tmp47_ = _result_;
			_tmp48_ = strlen (_tmp47_);
			_tmp49_ = _tmp48_;
			if (_tmp49_ > 0) {
				const gchar* _tmp50_;
				gchar* _tmp51_;
				_tmp50_ = _result_;
				_tmp51_ = g_strconcat (_tmp50_, "\n", NULL);
				_g_free0 (_result_);
				_result_ = _tmp51_;
			}
			_tmp52_ = cpu;
			_tmp53_ = gee_map_entry_get_value (_tmp52_);
			_tmp54_ = _tmp53_;
			if (((guint) ((guintptr) _tmp54_)) == ((guint) 2)) {
				const gchar* _tmp55_;
				GeeMapEntry* _tmp56_;
				gconstpointer _tmp57_;
				gconstpointer _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp55_ = _result_;
				_tmp56_ = cpu;
				_tmp57_ = gee_map_entry_get_key (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = about_hardware_view_clean_name (self, (const gchar*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strdup_printf (_ ("Dual-Core %s"), _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strconcat (_tmp55_, _tmp62_, NULL);
				_g_free0 (_result_);
				_result_ = _tmp63_;
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
			} else {
				GeeMapEntry* _tmp64_;
				gconstpointer _tmp65_;
				gconstpointer _tmp66_;
				_tmp64_ = cpu;
				_tmp65_ = gee_map_entry_get_value (_tmp64_);
				_tmp66_ = _tmp65_;
				if (((guint) ((guintptr) _tmp66_)) == ((guint) 4)) {
					const gchar* _tmp67_;
					GeeMapEntry* _tmp68_;
					gconstpointer _tmp69_;
					gconstpointer _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					_tmp67_ = _result_;
					_tmp68_ = cpu;
					_tmp69_ = gee_map_entry_get_key (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = about_hardware_view_clean_name (self, (const gchar*) _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = g_strdup_printf (_ ("Quad-Core %s"), _tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = g_strconcat (_tmp67_, _tmp74_, NULL);
					_g_free0 (_result_);
					_result_ = _tmp75_;
					_g_free0 (_tmp74_);
					_g_free0 (_tmp72_);
				} else {
					GeeMapEntry* _tmp76_;
					gconstpointer _tmp77_;
					gconstpointer _tmp78_;
					_tmp76_ = cpu;
					_tmp77_ = gee_map_entry_get_value (_tmp76_);
					_tmp78_ = _tmp77_;
					if (((guint) ((guintptr) _tmp78_)) == ((guint) 6)) {
						const gchar* _tmp79_;
						GeeMapEntry* _tmp80_;
						gconstpointer _tmp81_;
						gconstpointer _tmp82_;
						gchar* _tmp83_;
						gchar* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						gchar* _tmp87_;
						_tmp79_ = _result_;
						_tmp80_ = cpu;
						_tmp81_ = gee_map_entry_get_key (_tmp80_);
						_tmp82_ = _tmp81_;
						_tmp83_ = about_hardware_view_clean_name (self, (const gchar*) _tmp82_);
						_tmp84_ = _tmp83_;
						_tmp85_ = g_strdup_printf (_ ("Hexa-Core %s"), _tmp84_);
						_tmp86_ = _tmp85_;
						_tmp87_ = g_strconcat (_tmp79_, _tmp86_, NULL);
						_g_free0 (_result_);
						_result_ = _tmp87_;
						_g_free0 (_tmp86_);
						_g_free0 (_tmp84_);
					} else {
						const gchar* _tmp88_;
						GeeMapEntry* _tmp89_;
						gconstpointer _tmp90_;
						gconstpointer _tmp91_;
						GeeMapEntry* _tmp92_;
						gconstpointer _tmp93_;
						gconstpointer _tmp94_;
						gchar* _tmp95_;
						gchar* _tmp96_;
						gchar* _tmp97_;
						gchar* _tmp98_;
						gchar* _tmp99_;
						_tmp88_ = _result_;
						_tmp89_ = cpu;
						_tmp90_ = gee_map_entry_get_value (_tmp89_);
						_tmp91_ = _tmp90_;
						_tmp92_ = cpu;
						_tmp93_ = gee_map_entry_get_key (_tmp92_);
						_tmp94_ = _tmp93_;
						_tmp95_ = about_hardware_view_clean_name (self, (const gchar*) _tmp94_);
						_tmp96_ = _tmp95_;
						_tmp97_ = g_strdup_printf ("%u \u00D7 %s ", (guint) ((guintptr) _tmp91_), _tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = g_strconcat (_tmp88_, _tmp98_, NULL);
						_g_free0 (_result_);
						_result_ = _tmp99_;
						_g_free0 (_tmp98_);
						_g_free0 (_tmp96_);
					}
				}
			}
			_g_object_unref0 (cpu);
		}
		_g_object_unref0 (_cpu_it);
	}
	result = _result_;
	_g_object_unref0 (counts);
	return result;
}

static void
about_hardware_view_get_gpu_info_data_free (gpointer _data)
{
	AboutHardwareViewGetGpuInfoData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewGetGpuInfoData, _data_);
}

static void
about_hardware_view_get_gpu_info (AboutHardwareView* self,
                                  gboolean primary,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	AboutHardwareViewGetGpuInfoData* _data_;
	AboutHardwareView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewGetGpuInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_get_gpu_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->primary = primary;
	about_hardware_view_get_gpu_info_co (_data_);
}

static gchar*
about_hardware_view_get_gpu_info_finish (AboutHardwareView* self,
                                         GAsyncResult* _res_)
{
	gchar* result;
	AboutHardwareViewGetGpuInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
about_hardware_view_get_gpu_info_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	AboutHardwareViewGetGpuInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_hardware_view_get_gpu_info_co (_data_);
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
about_hardware_view_get_gpu_info_co (AboutHardwareViewGetGpuInfoData* _data_)
{
	static const gchar* FALLBACKS[1] = {"Intel Corporation"};
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->session_manager;
	if (_data_->_tmp0_ == NULL) {
		{
			_data_->_state_ = 1;
			g_async_initable_new_async (TYPE_SESSION_MANAGER_PROXY, 0, NULL, about_hardware_view_get_gpu_info_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SessionManager", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", NULL);
			return FALSE;
			_state_1:
			_data_->_tmp2_ = (SessionManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp1_ = (SessionManager*) _data_->_tmp2_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp3_ = _data_->_tmp1_;
			_data_->_tmp1_ = NULL;
			_g_object_unref0 (_data_->self->priv->session_manager);
			_data_->self->priv->session_manager = _data_->_tmp3_;
			_g_object_unref0 (_data_->_tmp1_);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp4_ = _data_->e;
			_data_->_tmp5_ = _data_->_tmp4_->message;
			g_warning ("HardwareView.vala:306: Unable to connect to GNOME Session Manager for " \
"GPU details: %s", _data_->_tmp5_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp6_ = _data_->self->priv->switcheroo_interface;
	if (_data_->_tmp6_ == NULL) {
		{
			_data_->_state_ = 2;
			g_async_initable_new_async (TYPE_SWITCHEROO_CONTROL_PROXY, 0, NULL, about_hardware_view_get_gpu_info_ready, _data_, "g-flags", 0, "g-name", "net.hadess.SwitcherooControl", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/net/hadess/SwitcherooControl", "g-interface-name", "net.hadess.SwitcherooControl", NULL);
			return FALSE;
			_state_2:
			_data_->_tmp8_ = (SwitcherooControl*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp7_ = (SwitcherooControl*) _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp9_ = _data_->_tmp7_;
			_data_->_tmp7_ = NULL;
			_g_object_unref0 (_data_->self->priv->switcheroo_interface);
			_data_->self->priv->switcheroo_interface = _data_->_tmp9_;
			_g_object_unref0 (_data_->_tmp7_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp10_ = _data_->_vala1_e;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			g_warning ("HardwareView.vala:318: Unable to connect to switcheroo-control: %s", _data_->_tmp11_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->gpu_name = NULL;
	_data_->_tmp12_ = _data_->self->priv->switcheroo_interface;
	if (_data_->_tmp12_ != NULL) {
		if (!_data_->primary) {
			_data_->_tmp14_ = _data_->self->priv->switcheroo_interface;
			_data_->_tmp15_ = switcheroo_control_get_has_dual_gpu (_data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_tmp13_ = !_data_->_tmp16_;
		} else {
			_data_->_tmp13_ = FALSE;
		}
		if (_data_->_tmp13_) {
			_data_->result = NULL;
			_g_free0 (_data_->gpu_name);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp17_ = _data_->self->priv->switcheroo_interface;
		_data_->_tmp19_ = 0;
		_data_->_tmp18_ = switcheroo_control_get_gpus (_data_->_tmp17_, &_data_->_tmp19_);
		_data_->_tmp18__length1 = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->_tmp18_;
		_data_->_tmp20__length1 = _data_->_tmp18__length1;
		{
			_data_->gpu_collection_length1 = 0;
			_data_->_gpu_collection_size_ = 0;
			_data_->gpu_collection = _data_->_tmp20_;
			_data_->gpu_collection_length1 = _data_->_tmp20__length1;
			for (_data_->gpu_it = 0; _data_->gpu_it < _data_->gpu_collection_length1; _data_->gpu_it = _data_->gpu_it + 1) {
				_data_->gpu = _data_->gpu_collection[_data_->gpu_it];
				{
					_data_->_tmp21_ = _data_->gpu;
					_data_->_tmp22_ = g_hash_table_lookup (_data_->_tmp21_, "Default");
					_data_->is_default = g_variant_get_boolean ((GVariant*) _data_->_tmp22_);
					if (_data_->is_default == _data_->primary) {
						_data_->_tmp23_ = _data_->gpu;
						_data_->_tmp24_ = g_hash_table_lookup (_data_->_tmp23_, "Name");
						_data_->_tmp25_ = g_variant_get_string ((GVariant*) _data_->_tmp24_, NULL);
						_data_->candidate = _data_->_tmp25_;
						_data_->_tmp26_ = _data_->candidate;
						if (_vala_string_array_contains (FALLBACKS, G_N_ELEMENTS (FALLBACKS), _data_->_tmp26_)) {
							continue;
						}
						_data_->_tmp27_ = _data_->candidate;
						_data_->_tmp28_ = about_hardware_view_clean_name (_data_->self, _data_->_tmp27_);
						_g_free0 (_data_->gpu_name);
						_data_->gpu_name = _data_->_tmp28_;
					}
				}
			}
			_data_->gpu_collection = (_vala_array_free (_data_->gpu_collection, _data_->gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
		}
	}
	_data_->_tmp29_ = _data_->gpu_name;
	if (_data_->_tmp29_ != NULL) {
		_data_->result = _data_->gpu_name;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->primary) {
		_data_->result = NULL;
		_g_free0 (_data_->gpu_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = _data_->self->priv->session_manager;
	if (_data_->_tmp30_ != NULL) {
		_data_->_tmp31_ = _data_->self->priv->session_manager;
		_data_->_tmp32_ = session_manager_get_renderer (_data_->_tmp31_);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = about_hardware_view_clean_name (_data_->self, _data_->_tmp34_);
		_data_->_tmp36_ = _data_->_tmp35_;
		_g_free0 (_data_->_tmp34_);
		_data_->result = _data_->_tmp36_;
		_g_free0 (_data_->gpu_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp37_ = g_strdup (_ ("Unknown Graphics"));
	_data_->result = _data_->_tmp37_;
	_g_free0 (_data_->gpu_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_hardware_view_get_graphics_info_data_free (gpointer _data)
{
	AboutHardwareViewGetGraphicsInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewGetGraphicsInfoData, _data_);
}

static void
about_hardware_view_get_graphics_info (AboutHardwareView* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	AboutHardwareViewGetGraphicsInfoData* _data_;
	AboutHardwareView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewGetGraphicsInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_get_graphics_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_hardware_view_get_graphics_info_co (_data_);
}

static void
about_hardware_view_get_graphics_info_finish (AboutHardwareView* self,
                                              GAsyncResult* _res_)
{
	AboutHardwareViewGetGraphicsInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_hardware_view_get_graphics_info_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	AboutHardwareViewGetGraphicsInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_hardware_view_get_graphics_info_co (_data_);
}

static gboolean
about_hardware_view_get_graphics_info_co (AboutHardwareViewGetGraphicsInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	about_hardware_view_get_gpu_info (_data_->self, TRUE, about_hardware_view_get_graphics_info_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = about_hardware_view_get_gpu_info_finish (_data_->self, _data_->_res_);
	_data_->primary_gpu = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->primary_graphics_info;
	_data_->_tmp2_ = _data_->primary_gpu;
	gtk_label_set_label (_data_->_tmp1_, _data_->_tmp2_);
	_data_->_state_ = 2;
	about_hardware_view_get_gpu_info (_data_->self, FALSE, about_hardware_view_get_graphics_info_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp3_ = about_hardware_view_get_gpu_info_finish (_data_->self, _data_->_res_);
	_data_->secondary_gpu = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->secondary_gpu;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->secondary_graphics_info;
		_data_->_tmp6_ = _data_->secondary_gpu;
		gtk_label_set_label (_data_->_tmp5_, _data_->_tmp6_);
		_data_->_tmp7_ = _data_->self->priv->graphics_box;
		_data_->_tmp8_ = _data_->self->priv->secondary_graphics_info;
		gtk_box_append (_data_->_tmp7_, (GtkWidget*) _data_->_tmp8_);
	}
	_g_free0 (_data_->secondary_gpu);
	_g_free0 (_data_->primary_gpu);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
about_hardware_view_get_mem_info (AboutHardwareView* self)
{
	guint64 mem_total = 0ULL;
	GUdevClient* client = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GUdevClient* _tmp3_;
	GUdevClient* _tmp4_;
	GUdevDevice* device = NULL;
	GUdevClient* _tmp5_;
	GUdevDevice* _tmp6_;
	GUdevDevice* _tmp7_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	mem_total = (guint64) 0;
	_tmp0_ = g_strdup ("dmi");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = g_udev_client_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	client = _tmp4_;
	_tmp5_ = client;
	_tmp6_ = g_udev_client_query_by_sysfs_path (_tmp5_, "/sys/devices/virtual/dmi/id");
	device = _tmp6_;
	_tmp7_ = device;
	if (_tmp7_ != NULL) {
		guint64 devices = 0ULL;
		GUdevDevice* _tmp8_;
		_tmp8_ = device;
		devices = g_udev_device_get_property_as_uint64 (_tmp8_, "MEMORY_ARRAY_NUM_DEVICES");
		{
			gint item = 0;
			item = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					GUdevDevice* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = item;
						item = _tmp10_ + 1;
					}
					_tmp9_ = FALSE;
					if (!(((guint64) item) < devices)) {
						break;
					}
					_tmp11_ = device;
					_tmp12_ = g_strdup_printf ("MEMORY_DEVICE_%d_SIZE", item);
					_tmp13_ = _tmp12_;
					mem_total += g_udev_device_get_property_as_uint64 (_tmp11_, _tmp13_);
					_g_free0 (_tmp13_);
				}
			}
		}
	}
	if (mem_total == ((guint64) 0)) {
		glibtop_mem mem = {0};
		glibtop_mem _tmp14_ = {0};
		glibtop_mem _tmp15_;
		glibtop_get_mem (&_tmp14_);
		 (&mem);
		mem = _tmp14_;
		_tmp15_ = mem;
		mem_total = _tmp15_.total;
		 (&mem);
	}
	_tmp16_ = about_hardware_view_custom_format_size (self, mem_total, TRUE);
	result = _tmp16_;
	_g_object_unref0 (device);
	_g_object_unref0 (client);
	return result;
}

static void
about_hardware_view_fetch_hardware_info (AboutHardwareView* self)
{
	gchar* cpu = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = about_hardware_view_get_cpu_info (self);
	cpu = _tmp0_;
	_tmp1_ = cpu;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_ ("Unknown Processor"));
		_g_free0 (self->priv->processor);
		self->priv->processor = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = cpu;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->processor);
		self->priv->processor = _tmp4_;
	}
	_tmp5_ = about_hardware_view_get_mem_info (self);
	_g_free0 (self->priv->memory);
	self->priv->memory = _tmp5_;
	about_hardware_view_get_graphics_info (self, NULL, NULL);
	about_hardware_view_get_storage_info (self, NULL, NULL);
	{
		GKeyFile* oem_file = NULL;
		GKeyFile* _tmp6_;
		GKeyFile* _tmp7_;
		gchar* _tmp8_ = NULL;
		GKeyFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GKeyFile* _tmp13_;
		gboolean _tmp18_ = FALSE;
		GKeyFile* _tmp19_;
		gboolean _tmp24_ = FALSE;
		GKeyFile* _tmp25_;
		gboolean _tmp30_ = FALSE;
		GKeyFile* _tmp31_;
		gboolean _tmp36_ = FALSE;
		GKeyFile* _tmp37_;
		_tmp6_ = g_key_file_new ();
		oem_file = _tmp6_;
		_tmp7_ = oem_file;
		g_key_file_load_from_file (_tmp7_, "/etc/oem.conf", G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (oem_file);
			goto __catch0_g_error;
		}
		_tmp9_ = oem_file;
		_tmp10_ = g_key_file_get_string (_tmp9_, "OEM", "Manufacturer", &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (oem_file);
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (self->priv->manufacturer_name);
		self->priv->manufacturer_name = _tmp11_;
		_tmp13_ = oem_file;
		_tmp12_ = g_key_file_has_key (_tmp13_, "OEM", "Product", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_key_file_unref0 (oem_file);
			goto __catch0_g_error;
		}
		if (_tmp12_) {
			gchar* _tmp14_ = NULL;
			GKeyFile* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = oem_file;
			_tmp16_ = g_key_file_get_string (_tmp15_, "OEM", "Product", &_inner_error0_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_key_file_unref0 (oem_file);
				goto __catch0_g_error;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_g_free0 (self->priv->product_name);
			self->priv->product_name = _tmp17_;
			_g_free0 (_tmp14_);
		}
		_tmp19_ = oem_file;
		_tmp18_ = g_key_file_has_key (_tmp19_, "OEM", "Version", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_key_file_unref0 (oem_file);
			goto __catch0_g_error;
		}
		if (_tmp18_) {
			gchar* _tmp20_ = NULL;
			GKeyFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp21_ = oem_file;
			_tmp22_ = g_key_file_get_string (_tmp21_, "OEM", "Version", &_inner_error0_);
			_tmp20_ = _tmp22_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_key_file_unref0 (oem_file);
				goto __catch0_g_error;
			}
			_tmp23_ = _tmp20_;
			_tmp20_ = NULL;
			_g_free0 (self->priv->product_version);
			self->priv->product_version = _tmp23_;
			_g_free0 (_tmp20_);
		}
		_tmp25_ = oem_file;
		_tmp24_ = g_key_file_has_key (_tmp25_, "OEM", "Logo", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_key_file_unref0 (oem_file);
			goto __catch0_g_error;
		}
		if (_tmp24_) {
			gchar* _tmp26_ = NULL;
			GKeyFile* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp27_ = oem_file;
			_tmp28_ = g_key_file_get_string (_tmp27_, "OEM", "Logo", &_inner_error0_);
			_tmp26_ = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_key_file_unref0 (oem_file);
				goto __catch0_g_error;
			}
			_tmp29_ = _tmp26_;
			_tmp26_ = NULL;
			_g_free0 (self->priv->manufacturer_icon_path);
			self->priv->manufacturer_icon_path = _tmp29_;
			_g_free0 (_tmp26_);
		}
		_tmp31_ = oem_file;
		_tmp30_ = g_key_file_has_key (_tmp31_, "OEM", "LogoDark", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_key_file_unref0 (oem_file);
			goto __catch0_g_error;
		}
		if (_tmp30_) {
			gchar* _tmp32_ = NULL;
			GKeyFile* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp33_ = oem_file;
			_tmp34_ = g_key_file_get_string (_tmp33_, "OEM", "LogoDark", &_inner_error0_);
			_tmp32_ = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_key_file_unref0 (oem_file);
				goto __catch0_g_error;
			}
			_tmp35_ = _tmp32_;
			_tmp32_ = NULL;
			_g_free0 (self->priv->manufacturer_icon_dark_path);
			self->priv->manufacturer_icon_dark_path = _tmp35_;
			_g_free0 (_tmp32_);
		}
		_tmp37_ = oem_file;
		_tmp36_ = g_key_file_has_key (_tmp37_, "OEM", "URL", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_key_file_unref0 (oem_file);
			goto __catch0_g_error;
		}
		if (_tmp36_) {
			gchar* _tmp38_ = NULL;
			GKeyFile* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp39_ = oem_file;
			_tmp40_ = g_key_file_get_string (_tmp39_, "OEM", "URL", &_inner_error0_);
			_tmp38_ = _tmp40_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_key_file_unref0 (oem_file);
				goto __catch0_g_error;
			}
			_tmp41_ = _tmp38_;
			_tmp38_ = NULL;
			_g_free0 (self->priv->manufacturer_support_url);
			self->priv->manufacturer_support_url = _tmp41_;
			_g_free0 (_tmp38_);
		}
		self->priv->oem_enabled = TRUE;
		_g_free0 (_tmp8_);
		_g_key_file_unref0 (oem_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_debug ("HardwareView.vala:439: %s", _tmp43_);
		self->priv->oem_enabled = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (cpu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (cpu);
}

static void
about_hardware_view_get_storage_info_data_free (gpointer _data)
{
	AboutHardwareViewGetStorageInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewGetStorageInfoData, _data_);
}

static void
about_hardware_view_get_storage_info (AboutHardwareView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	AboutHardwareViewGetStorageInfoData* _data_;
	AboutHardwareView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewGetStorageInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_get_storage_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_hardware_view_get_storage_info_co (_data_);
}

static void
about_hardware_view_get_storage_info_finish (AboutHardwareView* self,
                                             GAsyncResult* _res_)
{
	AboutHardwareViewGetStorageInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_hardware_view_get_storage_info_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	AboutHardwareViewGetStorageInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_hardware_view_get_storage_info_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
about_hardware_view_get_storage_info_co (AboutHardwareViewGetStorageInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path ("/");
	_data_->file_root = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup ("");
	_data_->storage_capacity = _data_->_tmp1_;
	_data_->storage_total = (guint64) 0;
	{
		_data_->_state_ = 1;
		udisks_client_new (NULL, about_hardware_view_get_storage_info_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = udisks_client_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->client = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->client;
		_data_->_tmp4_ = udisks_client_get_object_manager (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_dbus_object_manager_get_objects (_data_->_tmp5_);
		{
			_data_->object_collection = _data_->_tmp6_;
			for (_data_->object_it = _data_->object_collection; _data_->object_it != NULL; _data_->object_it = _data_->object_it->next) {
				_data_->object = (GDBusObject*) _data_->object_it->data;
				{
					_data_->_tmp7_ = _data_->object;
					g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, udisks_object_get_type (), UDisksObject), "drive", &_data_->_tmp8_, NULL);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->drive = _data_->_tmp9_;
					_data_->_tmp12_ = _data_->drive;
					if (_data_->_tmp12_ == NULL) {
						_data_->_tmp11_ = TRUE;
					} else {
						_data_->_tmp13_ = _data_->drive;
						g_object_get (_data_->_tmp13_, "removable", &_data_->_tmp14_, NULL);
						_data_->_tmp15_ = _data_->_tmp14_;
						_data_->_tmp11_ = _data_->_tmp15_;
					}
					if (_data_->_tmp11_) {
						_data_->_tmp10_ = TRUE;
					} else {
						_data_->_tmp16_ = _data_->drive;
						g_object_get (_data_->_tmp16_, "ejectable", &_data_->_tmp17_, NULL);
						_data_->_tmp18_ = _data_->_tmp17_;
						_data_->_tmp10_ = _data_->_tmp18_;
					}
					if (_data_->_tmp10_) {
						_g_object_unref0 (_data_->drive);
						continue;
					}
					_data_->_tmp19_ = _data_->drive;
					g_object_get (_data_->_tmp19_, "size", &_data_->_tmp20_, NULL);
					_data_->_tmp21_ = _data_->_tmp20_;
					_data_->storage_total += _data_->_tmp21_;
					_g_object_unref0 (_data_->drive);
				}
			}
			(_data_->object_collection == NULL) ? NULL : (_data_->object_collection = (_g_list_free__g_object_unref0_ (_data_->object_collection), NULL));
		}
		if (_data_->storage_total != ((guint64) 0)) {
			_data_->_tmp22_ = about_hardware_view_custom_format_size (_data_->self, _data_->storage_total, FALSE);
			_g_free0 (_data_->storage_capacity);
			_data_->storage_capacity = _data_->_tmp22_;
			_data_->_tmp23_ = _data_->self->priv->storage_info;
			_data_->_tmp24_ = _data_->storage_capacity;
			_data_->_state_ = 2;
			about_hardware_view_get_storage_type (_data_->self, _data_->_tmp24_, about_hardware_view_get_storage_info_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp25_ = about_hardware_view_get_storage_type_finish (_data_->self, _data_->_res_);
			_data_->_tmp26_ = _data_->_tmp25_;
			gtk_label_set_label (_data_->_tmp23_, _data_->_tmp26_);
			_g_free0 (_data_->_tmp26_);
			_g_object_unref0 (_data_->client);
			_g_free0 (_data_->storage_capacity);
			_g_object_unref0 (_data_->file_root);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->client);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp27_ = _data_->e;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		g_warning ("HardwareView.vala:465: %s", _data_->_tmp28_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->storage_capacity);
		_g_object_unref0 (_data_->file_root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp29_ = _data_->file_root;
		_data_->_state_ = 3;
		g_file_query_filesystem_info_async (_data_->_tmp29_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE, G_PRIORITY_DEFAULT, NULL, about_hardware_view_get_storage_info_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp30_ = g_file_query_filesystem_info_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp31_ = _data_->info;
		_data_->_tmp32_ = about_hardware_view_custom_format_size (_data_->self, g_file_info_get_attribute_uint64 (_data_->_tmp31_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE), FALSE);
		_g_free0 (_data_->storage_capacity);
		_data_->storage_capacity = _data_->_tmp32_;
		_g_object_unref0 (_data_->info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp33_ = _data_->_vala1_e;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_critical ("HardwareView.vala:472: %s", _data_->_tmp34_);
		_data_->_tmp35_ = g_strdup (_ ("Unknown"));
		_g_free0 (_data_->storage_capacity);
		_data_->storage_capacity = _data_->_tmp35_;
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->storage_capacity);
		_g_object_unref0 (_data_->file_root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = _data_->self->priv->storage_info;
	_data_->_tmp37_ = _data_->storage_capacity;
	_data_->_state_ = 4;
	about_hardware_view_get_storage_type (_data_->self, _data_->_tmp37_, about_hardware_view_get_storage_info_ready, _data_);
	return FALSE;
	_state_4:
	_data_->_tmp38_ = about_hardware_view_get_storage_type_finish (_data_->self, _data_->_res_);
	_data_->_tmp39_ = _data_->_tmp38_;
	gtk_label_set_label (_data_->_tmp36_, _data_->_tmp39_);
	_g_free0 (_data_->_tmp39_);
	_g_free0 (_data_->storage_capacity);
	_g_object_unref0 (_data_->file_root);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
about_hardware_view_clean_name (AboutHardwareView* self,
                                const gchar* info)
{
	gchar* pretty = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	static const AboutHardwareViewReplaceStrings REPLACE_STRINGS[13] = {{"Mesa DRI ", ""}, {"Mesa (.*)", "\\1"}, {"[(]R[)]", "®"}, {"[(]TM[)]", "™"}, {"Gallium .* on (AMD .*)", "\\1"}, {"(AMD .*) [(].*", "\\1"}, {"(AMD Ryzen) (.*)", "\\1 \\2"}, {"(AMD [A-Z])(.*)", "\\1\\L\\2\\E"}, {"Advanced Micro Devices, Inc\\. \\[.*?\\] .*? \\[(.*?)\\] .*", "AMD® \\1"}, {"Advanced Micro Devices, Inc\\. \\[.*?\\] (.*)", "AMD® \\1"}, {"Graphics Controller", "Graphics"}, {"Intel Corporation", "Intel®"}, {"NVIDIA Corporation (.*) \\[(\\S*) (\\S*) (.*)\\]", "NVIDIA® \\2® \\3® \\4"}};
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = g_markup_escape_text (info, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	pretty = _tmp3_;
	{
		{
			AboutHardwareViewReplaceStrings* replace_string_collection = NULL;
			gint replace_string_collection_length1 = 0;
			gint _replace_string_collection_size_ = 0;
			gint replace_string_it = 0;
			replace_string_collection = REPLACE_STRINGS;
			replace_string_collection_length1 = G_N_ELEMENTS (REPLACE_STRINGS);
			for (replace_string_it = 0; replace_string_it < replace_string_collection_length1; replace_string_it = replace_string_it + 1) {
				AboutHardwareViewReplaceStrings _tmp4_;
				AboutHardwareViewReplaceStrings _tmp5_ = {0};
				AboutHardwareViewReplaceStrings replace_string = {0};
				_tmp4_ = replace_string_collection[replace_string_it];
				about_hardware_view_replace_strings_copy (&_tmp4_, &_tmp5_);
				replace_string = _tmp5_;
				{
					GRegex* re = NULL;
					AboutHardwareViewReplaceStrings _tmp6_;
					const gchar* _tmp7_;
					GRegex* _tmp8_;
					gboolean matched = FALSE;
					GRegex* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_ = NULL;
					GRegex* _tmp12_;
					const gchar* _tmp13_;
					AboutHardwareViewReplaceStrings _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp6_ = replace_string;
					_tmp7_ = _tmp6_.regex;
					_tmp8_ = g_regex_new (_tmp7_, 0, 0, &_inner_error0_);
					re = _tmp8_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						about_hardware_view_replace_strings_destroy (&replace_string);
						goto __catch0_g_error;
					}
					_tmp9_ = re;
					_tmp10_ = pretty;
					matched = g_regex_match (_tmp9_, _tmp10_, 0, NULL);
					_tmp12_ = re;
					_tmp13_ = pretty;
					_tmp14_ = replace_string;
					_tmp15_ = _tmp14_.replacement;
					_tmp16_ = g_regex_replace (_tmp12_, _tmp13_, (gssize) -1, 0, _tmp15_, 0, &_inner_error0_);
					_tmp11_ = _tmp16_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_regex_unref0 (re);
						about_hardware_view_replace_strings_destroy (&replace_string);
						goto __catch0_g_error;
					}
					_tmp17_ = _tmp11_;
					_tmp11_ = NULL;
					_g_free0 (pretty);
					pretty = _tmp17_;
					if (matched) {
						_g_free0 (_tmp11_);
						_g_regex_unref0 (re);
						about_hardware_view_replace_strings_destroy (&replace_string);
						break;
					}
					_g_free0 (_tmp11_);
					_g_regex_unref0 (re);
					about_hardware_view_replace_strings_destroy (&replace_string);
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("HardwareView.vala:509: Couldn't cleanup vendor string: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (pretty);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = pretty;
	return result;
}

static void
about_hardware_view_get_storage_type_data_free (gpointer _data)
{
	AboutHardwareViewGetStorageTypeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->storage_capacity);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewGetStorageTypeData, _data_);
}

static void
about_hardware_view_get_storage_type (AboutHardwareView* self,
                                      const gchar* storage_capacity,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	AboutHardwareViewGetStorageTypeData* _data_;
	AboutHardwareView* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (storage_capacity != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewGetStorageTypeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_get_storage_type_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (storage_capacity);
	_g_free0 (_data_->storage_capacity);
	_data_->storage_capacity = _tmp1_;
	about_hardware_view_get_storage_type_co (_data_);
}

static gchar*
about_hardware_view_get_storage_type_finish (AboutHardwareView* self,
                                             GAsyncResult* _res_)
{
	gchar* result;
	AboutHardwareViewGetStorageTypeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
about_hardware_view_get_storage_type_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	AboutHardwareViewGetStorageTypeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_hardware_view_get_storage_type_co (_data_);
}

static gboolean
about_hardware_view_get_storage_type_co (AboutHardwareViewGetStorageTypeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	about_hardware_view_get_partition_name (_data_->self, about_hardware_view_get_storage_type_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = about_hardware_view_get_partition_name_finish (_data_->self, _data_->_res_);
	_data_->partition_name = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->partition_name;
	_data_->_state_ = 2;
	about_hardware_view_get_disk_name (_data_->self, _data_->_tmp1_, about_hardware_view_get_storage_type_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = about_hardware_view_get_disk_name_finish (_data_->self, _data_->_res_);
	_data_->disk_name = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->disk_name;
	_data_->_tmp4_ = g_strdup_printf ("/sys/block/%s/queue/rotational", _data_->_tmp3_);
	_data_->path = _data_->_tmp4_;
	_data_->_tmp5_ = g_strdup ("");
	_data_->storage = _data_->_tmp5_;
	{
		_data_->_tmp6_ = _data_->path;
		_data_->_tmp7_ = g_file_new_for_path (_data_->_tmp6_);
		_data_->file = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->file;
		_data_->_state_ = 3;
		g_file_read_async (_data_->_tmp9_, G_PRIORITY_DEFAULT, NULL, about_hardware_view_get_storage_type_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp10_ = g_file_read_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp8_);
		_data_->dis = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->dis;
		_data_->_state_ = 4;
		g_data_input_stream_read_line_async (_data_->_tmp12_, G_PRIORITY_DEFAULT, NULL, about_hardware_view_get_storage_type_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp13_ = g_data_input_stream_read_line_finish (_data_->_tmp12_, _data_->_res_, NULL, &_data_->_inner_error0_);
		_data_->contents = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->dis);
			_g_object_unref0 (_data_->_tmp8_);
			_g_object_unref0 (_data_->file);
			goto __catch0_g_error;
		}
		_data_->_tmp14_ = _data_->contents;
		if (atoi (_data_->_tmp14_) == 0) {
			_data_->_tmp15_ = _data_->disk_name;
			if (g_str_has_prefix (_data_->_tmp15_, "nvme")) {
				_data_->_tmp16_ = g_strdup_printf (_ ("%s storage (NVMe SSD)"), _data_->storage_capacity);
				_g_free0 (_data_->storage);
				_data_->storage = _data_->_tmp16_;
			} else {
				_data_->_tmp17_ = _data_->disk_name;
				if (g_str_has_prefix (_data_->_tmp17_, "mmc")) {
					_data_->_tmp18_ = g_strdup_printf (_ ("%s storage (eMMC)"), _data_->storage_capacity);
					_g_free0 (_data_->storage);
					_data_->storage = _data_->_tmp18_;
				} else {
					_data_->_tmp19_ = g_strdup_printf (_ ("%s storage (SATA SSD)"), _data_->storage_capacity);
					_g_free0 (_data_->storage);
					_data_->storage = _data_->_tmp19_;
				}
			}
		} else {
			_data_->_tmp20_ = g_strdup_printf (_ ("%s storage (HDD)"), _data_->storage_capacity);
			_g_free0 (_data_->storage);
			_data_->storage = _data_->_tmp20_;
		}
		_g_free0 (_data_->contents);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->_tmp8_);
		_g_object_unref0 (_data_->file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning ("HardwareView.vala:538: %s", _data_->_tmp22_);
		_data_->_tmp23_ = g_strdup_printf (_ ("%s storage"), _data_->storage_capacity);
		_g_free0 (_data_->storage);
		_data_->storage = _data_->_tmp23_;
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->storage);
		_g_free0 (_data_->path);
		_g_free0 (_data_->disk_name);
		_g_free0 (_data_->partition_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->storage;
	_g_free0 (_data_->path);
	_g_free0 (_data_->disk_name);
	_g_free0 (_data_->partition_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_hardware_view_get_partition_name_data_free (gpointer _data)
{
	AboutHardwareViewGetPartitionNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewGetPartitionNameData, _data_);
}

static void
about_hardware_view_get_partition_name (AboutHardwareView* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	AboutHardwareViewGetPartitionNameData* _data_;
	AboutHardwareView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewGetPartitionNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_get_partition_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_hardware_view_get_partition_name_co (_data_);
}

static gchar*
about_hardware_view_get_partition_name_finish (AboutHardwareView* self,
                                               GAsyncResult* _res_)
{
	gchar* result;
	AboutHardwareViewGetPartitionNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
about_hardware_view_get_partition_name_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	AboutHardwareViewGetPartitionNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_hardware_view_get_partition_name_co (_data_);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
about_hardware_view_get_partition_name_co (AboutHardwareViewGetPartitionNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->partition = _data_->_tmp0_;
	{
		_data_->_tmp1_ = g_subprocess_new (G_SUBPROCESS_FLAGS_STDOUT_PIPE, &_data_->_inner_error0_, "df", "/", NULL);
		_data_->subprocess = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->subprocess;
		_data_->_tmp3_ = NULL;
		_data_->_state_ = 1;
		g_subprocess_communicate_utf8_async (_data_->_tmp2_, NULL, NULL, about_hardware_view_get_partition_name_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_communicate_utf8_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, NULL, &_data_->_inner_error0_);
		_g_free0 (_data_->df_stdout);
		_data_->df_stdout = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->subprocess);
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->df_stdout;
		_data_->_tmp6_ = _data_->_tmp5_ = g_strsplit (_data_->_tmp4_, "\n", 0);
		_data_->output = _data_->_tmp6_;
		_data_->output_length1 = _vala_array_length (_data_->_tmp5_);
		_data_->_output_size_ = _data_->output_length1;
		_data_->_tmp7_ = _data_->output;
		_data_->_tmp7__length1 = _data_->output_length1;
		{
			_data_->line_collection_length1 = 0;
			_data_->_line_collection_size_ = 0;
			_data_->line_collection = _data_->_tmp7_;
			_data_->line_collection_length1 = _data_->_tmp7__length1;
			for (_data_->line_it = 0; _data_->line_it < _data_->line_collection_length1; _data_->line_it = _data_->line_it + 1) {
				_data_->_tmp8_ = g_strdup (_data_->line_collection[_data_->line_it]);
				_data_->line = _data_->_tmp8_;
				{
					_data_->_tmp9_ = _data_->line;
					if (g_str_has_prefix (_data_->_tmp9_, "/dev/")) {
						_data_->_tmp10_ = _data_->line;
						_data_->idx = string_index_of (_data_->_tmp10_, " ", 0);
						if (_data_->idx != -1) {
							_data_->_tmp11_ = _data_->line;
							_data_->_tmp12_ = string_substring (_data_->_tmp11_, (glong) 0, (glong) _data_->idx);
							_g_free0 (_data_->partition);
							_data_->partition = _data_->_tmp12_;
							_data_->result = _data_->partition;
							_g_free0 (_data_->line);
							_data_->output = (_vala_array_free (_data_->output, _data_->output_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (_data_->subprocess);
							_g_free0 (_data_->df_stdout);
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
							if (_data_->_state_ != 0) {
								while (!g_task_get_completed (_data_->_async_result)) {
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
								}
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					}
					_g_free0 (_data_->line);
				}
			}
		}
		_data_->output = (_vala_array_free (_data_->output, _data_->output_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->subprocess);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("HardwareView.vala:562: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->partition);
		_g_free0 (_data_->df_stdout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->partition;
	_g_free0 (_data_->df_stdout);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_hardware_view_get_disk_name_data_free (gpointer _data)
{
	AboutHardwareViewGetDiskNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->partition);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewGetDiskNameData, _data_);
}

static void
about_hardware_view_get_disk_name (AboutHardwareView* self,
                                   const gchar* partition,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AboutHardwareViewGetDiskNameData* _data_;
	AboutHardwareView* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (partition != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewGetDiskNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_get_disk_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (partition);
	_g_free0 (_data_->partition);
	_data_->partition = _tmp1_;
	about_hardware_view_get_disk_name_co (_data_);
}

static gchar*
about_hardware_view_get_disk_name_finish (AboutHardwareView* self,
                                          GAsyncResult* _res_)
{
	gchar* result;
	AboutHardwareViewGetDiskNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
about_hardware_view_get_disk_name_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	AboutHardwareViewGetDiskNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_hardware_view_get_disk_name_co (_data_);
}

static gboolean
about_hardware_view_get_disk_name_co (AboutHardwareViewGetDiskNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->disk_name = _data_->_tmp0_;
	{
		_data_->_tmp1_ = g_subprocess_new (G_SUBPROCESS_FLAGS_STDOUT_PIPE, &_data_->_inner_error0_, "lsblk", "-no", "pkname", _data_->partition, NULL);
		_data_->subprocess = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->subprocess;
		_data_->_tmp3_ = NULL;
		_data_->_state_ = 1;
		g_subprocess_communicate_utf8_async (_data_->_tmp2_, NULL, NULL, about_hardware_view_get_disk_name_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_communicate_utf8_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, NULL, &_data_->_inner_error0_);
		_g_free0 (_data_->lsblk_stout);
		_data_->lsblk_stout = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->subprocess);
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->lsblk_stout;
		_data_->_tmp5_ = string_strip (_data_->_tmp4_);
		_g_free0 (_data_->disk_name);
		_data_->disk_name = _data_->_tmp5_;
		_g_object_unref0 (_data_->subprocess);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("HardwareView.vala:576: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->disk_name);
		_g_free0 (_data_->lsblk_stout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->disk_name;
	_g_free0 (_data_->lsblk_stout);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_hardware_view_get_system_interface_instance (AboutHardwareView* self)
{
	SystemInterface* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->system_interface;
	if (_tmp0_ == NULL) {
		{
			SystemInterface* _tmp1_ = NULL;
			SystemInterface* _tmp2_;
			SystemInterface* _tmp3_;
			_tmp2_ = (SystemInterface*) g_initable_new (TYPE_SYSTEM_INTERFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.hostname1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/hostname1", "g-interface-name", "org.freedesktop.hostname1", NULL);
			_tmp1_ = (SystemInterface*) _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->system_interface);
			self->priv->system_interface = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("HardwareView.vala:595: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
about_hardware_view_request_hostname_permission (AboutHardwareView* self)
{
	PolkitPermission* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hostname_permission;
	if (_tmp0_ != NULL) {
		return;
	}
	{
		PolkitPermission* _tmp1_ = NULL;
		PolkitUnixProcess* _tmp2_;
		PolkitUnixProcess* _tmp3_;
		PolkitPermission* _tmp4_;
		PolkitPermission* _tmp5_;
		PolkitPermission* _tmp6_;
		_tmp2_ = (PolkitUnixProcess*) polkit_unix_process_new ((gint) getpid ());
		_tmp3_ = _tmp2_;
		_tmp4_ = (PolkitPermission*) polkit_permission_new_sync ("org.freedesktop.hostname1.set-static-hostname", (PolkitSubject*) _tmp3_, NULL, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->hostname_permission);
		self->priv->hostname_permission = _tmp6_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("HardwareView.vala:612: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
about_hardware_view_has_hostname_permission (AboutHardwareView* self)
{
	gboolean _tmp0_ = FALSE;
	PolkitPermission* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	about_hardware_view_request_hostname_permission (self);
	_tmp1_ = self->priv->hostname_permission;
	if (_tmp1_ != NULL) {
		PolkitPermission* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->hostname_permission;
		_tmp3_ = g_permission_get_allowed ((GPermission*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static gchar*
about_hardware_view_generate_hostname (AboutHardwareView* self,
                                       const gchar* pretty_hostname)
{
	gchar* hostname = NULL;
	gchar* _tmp0_;
	gboolean met_alpha = FALSE;
	gboolean whitespace_before = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_ = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp5__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pretty_hostname != NULL, NULL);
	_tmp0_ = g_strdup ("");
	hostname = _tmp0_;
	met_alpha = FALSE;
	whitespace_before = FALSE;
	_tmp1_ = g_str_to_ascii (pretty_hostname, NULL);
	_tmp2_ = _tmp1_;
	_tmp4_ = string_to_utf8 (_tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_g_free0 (_tmp2_);
	{
		gchar* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp5_;
		c_collection_length1 = _tmp5__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			gchar c = '\0';
			c = c_collection[c_it];
			{
				if (g_ascii_isalpha (c)) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp6_ = hostname;
					_tmp7_ = g_strdup_printf ("%c", c);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
					_g_free0 (hostname);
					hostname = _tmp9_;
					_g_free0 (_tmp8_);
					met_alpha = TRUE;
					whitespace_before = FALSE;
				} else {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					if (g_ascii_isdigit (c)) {
						_tmp11_ = TRUE;
					} else {
						_tmp11_ = c == '-';
					}
					if (_tmp11_) {
						_tmp10_ = met_alpha;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						const gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						_tmp12_ = hostname;
						_tmp13_ = g_strdup_printf ("%c", c);
						_tmp14_ = _tmp13_;
						_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
						_g_free0 (hostname);
						hostname = _tmp15_;
						_g_free0 (_tmp14_);
						whitespace_before = FALSE;
					} else {
						gboolean _tmp16_ = FALSE;
						if (g_ascii_isspace (c)) {
							_tmp16_ = !whitespace_before;
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							const gchar* _tmp17_;
							gchar* _tmp18_;
							_tmp17_ = hostname;
							_tmp18_ = g_strconcat (_tmp17_, "-", NULL);
							_g_free0 (hostname);
							hostname = _tmp18_;
							whitespace_before = TRUE;
						}
					}
				}
			}
		}
		c_collection = (g_free (c_collection), NULL);
	}
	result = hostname;
	return result;
}

static gchar*
about_hardware_view_get_host_name (AboutHardwareView* self)
{
	SystemInterface* _tmp0_;
	gchar* hostname = NULL;
	SystemInterface* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	about_hardware_view_get_system_interface_instance (self);
	_tmp0_ = self->priv->system_interface;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_get_host_name ();
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->system_interface;
	_tmp4_ = system_interface_get_pretty_hostname (_tmp3_);
	_tmp5_ = _tmp4_;
	hostname = _tmp5_;
	_tmp7_ = hostname;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = hostname;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ == 0;
	}
	if (_tmp6_) {
		SystemInterface* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->priv->system_interface;
		_tmp12_ = system_interface_get_static_hostname (_tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (hostname);
		hostname = _tmp13_;
	}
	_tmp15_ = hostname;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp16_ = hostname;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_ == 0;
	}
	if (_tmp14_) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = g_get_host_name ();
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (hostname);
		hostname = _tmp20_;
	}
	result = hostname;
	return result;
}

static void
about_hardware_view_set_host_name_data_free (gpointer _data)
{
	AboutHardwareViewSetHostNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->hostname);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutHardwareViewSetHostNameData, _data_);
}

static void
about_hardware_view_set_host_name (AboutHardwareView* self,
                                   const gchar* hostname,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AboutHardwareViewSetHostNameData* _data_;
	AboutHardwareView* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hostname != NULL);
	_data_ = g_slice_new0 (AboutHardwareViewSetHostNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_hardware_view_set_host_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (hostname);
	_g_free0 (_data_->hostname);
	_data_->hostname = _tmp1_;
	about_hardware_view_set_host_name_co (_data_);
}

static void
about_hardware_view_set_host_name_finish (AboutHardwareView* self,
                                          GAsyncResult* _res_)
{
	AboutHardwareViewSetHostNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_hardware_view_set_host_name_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	AboutHardwareViewSetHostNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_hardware_view_set_host_name_co (_data_);
}

static gboolean
about_hardware_view_set_host_name_co (AboutHardwareViewSetHostNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	about_hardware_view_get_system_interface_instance (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->system_interface;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	about_hardware_view_request_hostname_permission (_data_->self);
	_data_->_tmp1_ = _data_->self->priv->hostname_permission;
	if (_data_->_tmp1_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = about_hardware_view_generate_hostname (_data_->self, _data_->hostname);
	_data_->static_hostname = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->self->priv->system_interface;
		_data_->_state_ = 1;
		system_interface_set_pretty_hostname (_data_->_tmp3_, _data_->hostname, FALSE, about_hardware_view_set_host_name_ready, _data_);
		return FALSE;
		_state_1:
		system_interface_set_pretty_hostname_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->self->priv->system_interface;
		_data_->_tmp5_ = _data_->static_hostname;
		_data_->_state_ = 2;
		system_interface_set_static_hostname (_data_->_tmp4_, _data_->_tmp5_, FALSE, about_hardware_view_set_host_name_ready, _data_);
		return FALSE;
		_state_2:
		system_interface_set_static_hostname_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("HardwareView.vala:685: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->static_hostname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->static_hostname);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
about_hardware_view_custom_format_size (AboutHardwareView* self,
                                        guint64 size,
                                        gboolean iec_unit)
{
	gint _tmp0_ = 0;
	guint divisor = 0U;
	static const gchar* UNITS[6] = {"kB", "MB", "GB", "TB", "PB", "EB"};
	gint unit_index = 0;
	const gchar* unit = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (iec_unit) {
		_tmp0_ = 1024;
	} else {
		_tmp0_ = 1000;
	}
	divisor = (guint) _tmp0_;
	unit_index = 0;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		if ((size / divisor) > ((guint64) 0)) {
			_tmp1_ = unit_index < G_N_ELEMENTS (UNITS);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = unit_index;
		unit_index = _tmp2_ + 1;
		size = size / divisor;
	}
	if (unit_index == 0) {
		unit = g_dngettext ("glib20", "byte", "bytes", (gulong) size);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = UNITS[unit_index - 1];
		unit = g_dgettext ("glib20", _tmp3_);
	}
	_tmp4_ = unit;
	_tmp5_ = g_strdup_printf (g_dpgettext2 ("glib20", "format-size", "%u %s"), (guint) size, _tmp4_);
	result = _tmp5_;
	return result;
}

AboutHardwareView*
about_hardware_view_construct (GType object_type)
{
	AboutHardwareView * self = NULL;
	self = (AboutHardwareView*) g_object_new (object_type, NULL);
	return self;
}

AboutHardwareView*
about_hardware_view_new (void)
{
	return about_hardware_view_construct (ABOUT_TYPE_HARDWARE_VIEW);
}

static void
about_hardware_view_replace_strings_copy (const AboutHardwareViewReplaceStrings* self,
                                          AboutHardwareViewReplaceStrings* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).regex;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).regex);
	(*dest).regex = _tmp1_;
	_tmp2_ = (*self).replacement;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).replacement);
	(*dest).replacement = _tmp3_;
}

static void
about_hardware_view_replace_strings_destroy (AboutHardwareViewReplaceStrings* self)
{
	_g_free0 ((*self).regex);
	_g_free0 ((*self).replacement);
}

static AboutHardwareViewReplaceStrings*
about_hardware_view_replace_strings_dup (const AboutHardwareViewReplaceStrings* self)
{
	AboutHardwareViewReplaceStrings* dup;
	dup = g_new0 (AboutHardwareViewReplaceStrings, 1);
	about_hardware_view_replace_strings_copy (self, dup);
	return dup;
}

static void
about_hardware_view_replace_strings_free (AboutHardwareViewReplaceStrings* self)
{
	about_hardware_view_replace_strings_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
about_hardware_view_replace_strings_get_type_once (void)
{
	GType about_hardware_view_replace_strings_type_id;
	about_hardware_view_replace_strings_type_id = g_boxed_type_register_static ("AboutHardwareViewReplaceStrings", (GBoxedCopyFunc) about_hardware_view_replace_strings_dup, (GBoxedFreeFunc) about_hardware_view_replace_strings_free);
	return about_hardware_view_replace_strings_type_id;
}

static GType
about_hardware_view_replace_strings_get_type (void)
{
	static volatile gsize about_hardware_view_replace_strings_type_id__once = 0;
	if (g_once_init_enter (&about_hardware_view_replace_strings_type_id__once)) {
		GType about_hardware_view_replace_strings_type_id;
		about_hardware_view_replace_strings_type_id = about_hardware_view_replace_strings_get_type_once ();
		g_once_init_leave (&about_hardware_view_replace_strings_type_id__once, about_hardware_view_replace_strings_type_id);
	}
	return about_hardware_view_replace_strings_type_id__once;
}

static void
_about_hardware_view___lambda18_ (AboutHardwareView* self)
{
	about_hardware_view_update_manufacturer_logo (self);
}

static void
__about_hardware_view___lambda18__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_about_hardware_view___lambda18_ ((AboutHardwareView*) self);
}

static void
_about_hardware_view___lambda19_ (AboutHardwareView* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = self->priv->hostname_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = about_hardware_view_get_host_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp2_, _tmp4_) != 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		GtkEntry* _tmp6_;
		GtkEntry* _tmp7_;
		_tmp6_ = self->priv->hostname_entry;
		g_object_set (_tmp6_, "secondary-icon-name", "document-save-symbolic", NULL);
		_tmp7_ = self->priv->hostname_entry;
		g_object_set (_tmp7_, "secondary-icon-tooltip-text", _ ("Update device name"), NULL);
	}
}

static void
__about_hardware_view___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                                        gpointer self)
{
	_about_hardware_view___lambda19_ ((AboutHardwareView*) self);
}

static void
_about_hardware_view_on_hostname_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                    gpointer self)
{
	about_hardware_view_on_hostname_entry_activate ((AboutHardwareView*) self);
}

static void
_about_hardware_view___lambda20_ (AboutHardwareView* self,
                                  GtkEntryIconPosition icon_pos)
{
	if (icon_pos == GTK_ENTRY_ICON_SECONDARY) {
		about_hardware_view_on_hostname_entry_activate (self);
	}
}

static void
__about_hardware_view___lambda20__gtk_entry_icon_release (GtkEntry* _sender,
                                                          GtkEntryIconPosition icon_pos,
                                                          gpointer self)
{
	_about_hardware_view___lambda20_ ((AboutHardwareView*) self, icon_pos);
}

static GObject *
about_hardware_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutHardwareView * self;
	GraniteSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	gchar* _tmp2_;
	GtkEntry* _tmp3_ = NULL;
	GtkEntry* _tmp4_;
	GtkLabel* processor_info = NULL;
	const gchar* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* memory_info = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_ = NULL;
	GtkBox* details_box = NULL;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkEntry* _tmp23_;
	GtkImage* _tmp24_ = NULL;
	GtkBox* _tmp51_;
	GtkLabel* _tmp52_;
	GtkBox* _tmp53_;
	GtkBox* _tmp54_;
	GtkBox* _tmp55_;
	GtkLabel* _tmp56_;
	GtkBox* _tmp57_;
	GtkLabel* _tmp58_;
	gboolean _tmp59_ = FALSE;
	GtkBox* box = NULL;
	GtkBox* _tmp65_ = NULL;
	GtkBox* _tmp66_;
	GtkImage* _tmp67_;
	GtkBox* _tmp68_;
	GtkBox* _tmp69_;
	AdwClamp* clamp = NULL;
	GtkBox* _tmp70_;
	GtkWidget* _tmp71_;
	AdwClamp* _tmp72_ = NULL;
	AdwClamp* _tmp73_;
	GraniteSettings* _tmp74_;
	GtkEntry* _tmp75_;
	GtkEntry* _tmp76_;
	GtkEntry* _tmp77_;
	parent_class = G_OBJECT_CLASS (about_hardware_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_HARDWARE_VIEW, AboutHardwareView);
	_tmp0_ = granite_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->granite_settings);
	self->priv->granite_settings = _tmp1_;
	about_hardware_view_fetch_hardware_info (self);
	_tmp2_ = about_hardware_view_get_host_name (self);
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_set ((GtkEditable*) _tmp3_, "xalign", (gfloat) 0, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	gtk_editable_set_text ((GtkEditable*) _tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->hostname_entry);
	self->priv->hostname_entry = _tmp3_;
	_tmp4_ = self->priv->hostname_entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_H2_LABEL);
	if (!about_hardware_view_has_hostname_permission (self)) {
		GtkEntry* _tmp5_;
		GtkEntry* _tmp6_;
		GtkEntry* _tmp7_;
		_tmp5_ = self->priv->hostname_entry;
		g_object_set (_tmp5_, "secondary-icon-name", "changes-prevent-symbolic", NULL);
		_tmp6_ = self->priv->hostname_entry;
		g_object_set (_tmp6_, "secondary-icon-tooltip-text", _ ("You do not have permission to change the device name"), NULL);
		_tmp7_ = self->priv->hostname_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
	}
	_tmp8_ = self->priv->processor;
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	gtk_label_set_ellipsize (_tmp9_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp9_, 12);
	gtk_label_set_selectable (_tmp9_, TRUE);
	gtk_label_set_xalign (_tmp9_, (gfloat) 0);
	g_object_ref_sink (_tmp9_);
	processor_info = _tmp9_;
	_tmp10_ = self->priv->memory;
	_tmp11_ = g_strdup_printf (_ ("%s memory"), _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	gtk_label_set_ellipsize (_tmp13_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_selectable (_tmp13_, TRUE);
	gtk_label_set_xalign (_tmp13_, (gfloat) 0);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	memory_info = _tmp14_;
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Unknown Graphics"));
	gtk_label_set_ellipsize (_tmp15_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_selectable (_tmp15_, TRUE);
	gtk_label_set_xalign (_tmp15_, (gfloat) 0);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->primary_graphics_info);
	self->priv->primary_graphics_info = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp16_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_selectable (_tmp16_, TRUE);
	gtk_label_set_xalign (_tmp16_, (gfloat) 0);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->secondary_graphics_info);
	self->priv->secondary_graphics_info = _tmp16_;
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->graphics_box);
	self->priv->graphics_box = _tmp17_;
	_tmp18_ = self->priv->graphics_box;
	_tmp19_ = self->priv->primary_graphics_info;
	gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = (GtkLabel*) gtk_label_new (_ ("Unknown storage"));
	gtk_label_set_ellipsize (_tmp20_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_selectable (_tmp20_, TRUE);
	gtk_label_set_xalign (_tmp20_, (gfloat) 0);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->storage_info);
	self->priv->storage_info = _tmp20_;
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp21_);
	details_box = _tmp21_;
	_tmp22_ = details_box;
	_tmp23_ = self->priv->hostname_entry;
	gtk_box_append (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = (GtkImage*) gtk_image_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_END);
	gtk_image_set_pixel_size (_tmp24_, 128);
	g_object_set (_tmp24_, "use-fallback", TRUE, NULL);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->manufacturer_logo);
	self->priv->manufacturer_logo = _tmp24_;
	if (self->priv->oem_enabled) {
		GtkLabel* manufacturer_info = NULL;
		const gchar* _tmp25_;
		GtkLabel* _tmp26_ = NULL;
		GtkLabel* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp39_;
		GtkBox* _tmp49_;
		GtkLabel* _tmp50_;
		_tmp25_ = self->priv->manufacturer_name;
		_tmp26_ = (GtkLabel*) gtk_label_new (_tmp25_);
		gtk_label_set_ellipsize (_tmp26_, PANGO_ELLIPSIZE_MIDDLE);
		gtk_label_set_selectable (_tmp26_, TRUE);
		gtk_label_set_xalign (_tmp26_, (gfloat) 0);
		g_object_ref_sink (_tmp26_);
		manufacturer_info = _tmp26_;
		_tmp27_ = manufacturer_info;
		gtk_widget_add_css_class ((GtkWidget*) _tmp27_, GRANITE_STYLE_CLASS_DIM_LABEL);
		_tmp28_ = self->priv->product_name;
		if (_tmp28_ != NULL) {
			GtkLabel* _tmp29_;
			GtkLabel* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			GtkLabel* _tmp38_;
			_tmp29_ = manufacturer_info;
			_tmp30_ = manufacturer_info;
			_tmp31_ = gtk_label_get_label (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = self->priv->product_name;
			_tmp34_ = g_strdup_printf (" <b>%s</b>", _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			gtk_label_set_label (_tmp30_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_tmp38_ = manufacturer_info;
			gtk_label_set_use_markup (_tmp38_, TRUE);
		}
		_tmp39_ = self->priv->product_version;
		if (_tmp39_ != NULL) {
			GtkLabel* _tmp40_;
			GtkLabel* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp40_ = manufacturer_info;
			_tmp41_ = manufacturer_info;
			_tmp42_ = gtk_label_get_label (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = self->priv->product_version;
			_tmp45_ = g_strdup_printf (" %s", _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat (_tmp43_, _tmp46_, NULL);
			_tmp48_ = _tmp47_;
			gtk_label_set_label (_tmp41_, _tmp48_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp46_);
		}
		_tmp49_ = details_box;
		_tmp50_ = manufacturer_info;
		gtk_box_append (_tmp49_, (GtkWidget*) _tmp50_);
		_g_object_unref0 (manufacturer_info);
	}
	about_hardware_view_update_manufacturer_logo (self);
	_tmp51_ = details_box;
	_tmp52_ = processor_info;
	gtk_box_append (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = details_box;
	_tmp54_ = self->priv->graphics_box;
	gtk_box_append (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = details_box;
	_tmp56_ = memory_info;
	gtk_box_append (_tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = details_box;
	_tmp58_ = self->priv->storage_info;
	gtk_box_append (_tmp57_, (GtkWidget*) _tmp58_);
	if (self->priv->oem_enabled) {
		const gchar* _tmp60_;
		_tmp60_ = self->priv->manufacturer_support_url;
		_tmp59_ = _tmp60_ != NULL;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		GtkLinkButton* manufacturer_website_info = NULL;
		const gchar* _tmp61_;
		GtkLinkButton* _tmp62_ = NULL;
		GtkBox* _tmp63_;
		GtkLinkButton* _tmp64_;
		_tmp61_ = self->priv->manufacturer_support_url;
		_tmp62_ = (GtkLinkButton*) gtk_link_button_new_with_label (_tmp61_, _ ("Manufacturer Website"));
		gtk_widget_set_halign ((GtkWidget*) _tmp62_, GTK_ALIGN_START);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp62_, 12);
		g_object_ref_sink (_tmp62_);
		manufacturer_website_info = _tmp62_;
		_tmp63_ = details_box;
		_tmp64_ = manufacturer_website_info;
		gtk_box_append (_tmp63_, (GtkWidget*) _tmp64_);
		_g_object_unref0 (manufacturer_website_info);
	}
	_tmp65_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 32);
	gtk_widget_set_valign ((GtkWidget*) _tmp65_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp65_);
	box = _tmp65_;
	_tmp66_ = box;
	_tmp67_ = self->priv->manufacturer_logo;
	gtk_box_append (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = box;
	_tmp69_ = details_box;
	gtk_box_append (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = box;
	_tmp71_ = _g_object_ref0 ((GtkWidget*) _tmp70_);
	_tmp72_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_child (_tmp72_, _tmp71_);
	_g_object_unref0 (_tmp71_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp72_, TRUE);
	g_object_ref_sink (_tmp72_);
	clamp = _tmp72_;
	gtk_widget_set_margin_top ((GtkWidget*) self, 12);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	_tmp73_ = clamp;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp73_);
	_tmp74_ = self->priv->granite_settings;
	g_signal_connect_object ((GObject*) _tmp74_, "notify::prefers-color-scheme", (GCallback) __about_hardware_view___lambda18__g_object_notify, self, 0);
	_tmp75_ = self->priv->hostname_entry;
	g_signal_connect_object ((GtkEditable*) _tmp75_, "changed", (GCallback) __about_hardware_view___lambda19__gtk_editable_changed, self, 0);
	_tmp76_ = self->priv->hostname_entry;
	g_signal_connect_object (_tmp76_, "activate", (GCallback) _about_hardware_view_on_hostname_entry_activate_gtk_entry_activate, self, 0);
	_tmp77_ = self->priv->hostname_entry;
	g_signal_connect_object (_tmp77_, "icon-release", (GCallback) __about_hardware_view___lambda20__gtk_entry_icon_release, self, 0);
	_g_object_unref0 (clamp);
	_g_object_unref0 (box);
	_g_object_unref0 (details_box);
	_g_object_unref0 (memory_info);
	_g_object_unref0 (processor_info);
	return obj;
}

static void
about_hardware_view_class_init (AboutHardwareViewClass * klass,
                                gpointer klass_data)
{
	about_hardware_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutHardwareView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_hardware_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_hardware_view_finalize;
}

static void
about_hardware_view_instance_init (AboutHardwareView * self,
                                   gpointer klass)
{
	self->priv = about_hardware_view_get_instance_private (self);
	self->priv->manufacturer_icon_dark_path = NULL;
	self->priv->hostname_permission = NULL;
}

static void
about_hardware_view_finalize (GObject * obj)
{
	AboutHardwareView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_HARDWARE_VIEW, AboutHardwareView);
	_g_free0 (self->priv->manufacturer_icon_path);
	_g_free0 (self->priv->manufacturer_icon_dark_path);
	_g_free0 (self->priv->manufacturer_name);
	_g_free0 (self->priv->manufacturer_support_url);
	_g_free0 (self->priv->memory);
	_g_free0 (self->priv->processor);
	_g_free0 (self->priv->product_name);
	_g_free0 (self->priv->product_version);
	_g_object_unref0 (self->priv->system_interface);
	_g_object_unref0 (self->priv->hostname_permission);
	_g_object_unref0 (self->priv->session_manager);
	_g_object_unref0 (self->priv->switcheroo_interface);
	_g_object_unref0 (self->priv->hostname_entry);
	_g_object_unref0 (self->priv->manufacturer_logo);
	_g_object_unref0 (self->priv->primary_graphics_info);
	_g_object_unref0 (self->priv->secondary_graphics_info);
	_g_object_unref0 (self->priv->graphics_box);
	_g_object_unref0 (self->priv->storage_info);
	_g_object_unref0 (self->priv->granite_settings);
	G_OBJECT_CLASS (about_hardware_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_hardware_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutHardwareViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_hardware_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutHardwareView), 0, (GInstanceInitFunc) about_hardware_view_instance_init, NULL };
	GType about_hardware_view_type_id;
	about_hardware_view_type_id = g_type_register_static (gtk_box_get_type (), "AboutHardwareView", &g_define_type_info, 0);
	AboutHardwareView_private_offset = g_type_add_instance_private (about_hardware_view_type_id, sizeof (AboutHardwareViewPrivate));
	return about_hardware_view_type_id;
}

GType
about_hardware_view_get_type (void)
{
	static volatile gsize about_hardware_view_type_id__once = 0;
	if (g_once_init_enter (&about_hardware_view_type_id__once)) {
		GType about_hardware_view_type_id;
		about_hardware_view_type_id = about_hardware_view_get_type_once ();
		g_once_init_leave (&about_hardware_view_type_id__once, about_hardware_view_type_id);
	}
	return about_hardware_view_type_id__once;
}

void
system_interface_set_pretty_hostname (SystemInterface* self,
                                      const gchar* hostname,
                                      gboolean interactive,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SystemInterfaceIface* _iface_;
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_pretty_hostname) {
		_iface_->set_pretty_hostname (self, hostname, interactive, _callback_, _user_data_);
	}
}

void
system_interface_set_pretty_hostname_finish (SystemInterface* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	SystemInterfaceIface* _iface_;
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_pretty_hostname_finish) {
		_iface_->set_pretty_hostname_finish (self, _res_, error);
	}
}

void
system_interface_set_static_hostname (SystemInterface* self,
                                      const gchar* hostname,
                                      gboolean interactive,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SystemInterfaceIface* _iface_;
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_static_hostname) {
		_iface_->set_static_hostname (self, hostname, interactive, _callback_, _user_data_);
	}
}

void
system_interface_set_static_hostname_finish (SystemInterface* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	SystemInterfaceIface* _iface_;
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_static_hostname_finish) {
		_iface_->set_static_hostname_finish (self, _res_, error);
	}
}

gchar*
system_interface_get_icon_name (SystemInterface* self)
{
	SystemInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_icon_name) {
		return _iface_->get_icon_name (self);
	}
	return NULL;
}

gchar*
system_interface_get_pretty_hostname (SystemInterface* self)
{
	SystemInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_pretty_hostname) {
		return _iface_->get_pretty_hostname (self);
	}
	return NULL;
}

gchar*
system_interface_get_static_hostname (SystemInterface* self)
{
	SystemInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_static_hostname) {
		return _iface_->get_static_hostname (self);
	}
	return NULL;
}

static void
system_interface_default_init (SystemInterfaceIface * iface,
                               gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
system_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SystemInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) system_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType system_interface_type_id;
	system_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SystemInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (system_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) system_interface_proxy_get_type);
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.hostname1");
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_system_interface_dbus_interface_info));
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) system_interface_register_object);
	return system_interface_type_id;
}

GType
system_interface_get_type (void)
{
	static volatile gsize system_interface_type_id__once = 0;
	if (g_once_init_enter (&system_interface_type_id__once)) {
		GType system_interface_type_id;
		system_interface_type_id = system_interface_get_type_once ();
		g_once_init_leave (&system_interface_type_id__once, system_interface_type_id);
	}
	return system_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SystemInterfaceProxy, system_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SYSTEM_INTERFACE, system_interface_proxy_system_interface_interface_init) )
static void
system_interface_proxy_class_init (SystemInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = system_interface_proxy_g_signal;
}

static void
system_interface_proxy_g_signal (GDBusProxy* proxy,
                                 const gchar* sender_name,
                                 const gchar* signal_name,
                                 GVariant* parameters)
{
}

static void
system_interface_proxy_init (SystemInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_system_interface_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
system_interface_proxy_set_pretty_hostname_async (SystemInterface* self,
                                                  const gchar* hostname,
                                                  gboolean interactive,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.hostname1", "SetPrettyHostname");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (hostname));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
system_interface_proxy_set_pretty_hostname_finish (SystemInterface* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
system_interface_proxy_set_static_hostname_async (SystemInterface* self,
                                                  const gchar* hostname,
                                                  gboolean interactive,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.hostname1", "SetStaticHostname");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (hostname));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
system_interface_proxy_set_static_hostname_finish (SystemInterface* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
system_interface_dbus_proxy_get_icon_name (SystemInterface* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "IconName");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("IconName"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
system_interface_dbus_proxy_get_pretty_hostname (SystemInterface* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrettyHostname");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrettyHostname"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
system_interface_dbus_proxy_get_static_hostname (SystemInterface* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "StaticHostname");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("StaticHostname"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
system_interface_proxy_system_interface_interface_init (SystemInterfaceIface* iface)
{
	iface->set_pretty_hostname = system_interface_proxy_set_pretty_hostname_async;
	iface->set_pretty_hostname_finish = system_interface_proxy_set_pretty_hostname_finish;
	iface->set_static_hostname = system_interface_proxy_set_static_hostname_async;
	iface->set_static_hostname_finish = system_interface_proxy_set_static_hostname_finish;
	iface->get_icon_name = system_interface_dbus_proxy_get_icon_name;
	iface->get_pretty_hostname = system_interface_dbus_proxy_get_pretty_hostname;
	iface->get_static_hostname = system_interface_dbus_proxy_get_static_hostname;
}

static void
_dbus_system_interface_set_pretty_hostname (SystemInterface* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SystemInterfaceSetPrettyHostnameReadyData* _ready_data;
	GVariant* _tmp61_;
	GVariant* _tmp62_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SystemInterfaceSetPrettyHostnameReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp61_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->hostname = g_variant_dup_string (_tmp61_, NULL);
	g_variant_unref (_tmp61_);
	_tmp62_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->interactive = g_variant_get_boolean (_tmp62_);
	g_variant_unref (_tmp62_);
	system_interface_set_pretty_hostname (self, _ready_data->hostname, _ready_data->interactive, (GAsyncReadyCallback) _dbus_system_interface_set_pretty_hostname_ready, _ready_data);
	_error:
	;
}

static void
_dbus_system_interface_set_pretty_hostname_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	SystemInterfaceSetPrettyHostnameReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	system_interface_set_pretty_hostname_finish ((SystemInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->hostname);
	g_slice_free (SystemInterfaceSetPrettyHostnameReadyData, _ready_data);
}

static void
_dbus_system_interface_set_static_hostname (SystemInterface* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SystemInterfaceSetStaticHostnameReadyData* _ready_data;
	GVariant* _tmp63_;
	GVariant* _tmp64_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SystemInterfaceSetStaticHostnameReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp63_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->hostname = g_variant_dup_string (_tmp63_, NULL);
	g_variant_unref (_tmp63_);
	_tmp64_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->interactive = g_variant_get_boolean (_tmp64_);
	g_variant_unref (_tmp64_);
	system_interface_set_static_hostname (self, _ready_data->hostname, _ready_data->interactive, (GAsyncReadyCallback) _dbus_system_interface_set_static_hostname_ready, _ready_data);
	_error:
	;
}

static void
_dbus_system_interface_set_static_hostname_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	SystemInterfaceSetStaticHostnameReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	system_interface_set_static_hostname_finish ((SystemInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->hostname);
	g_slice_free (SystemInterfaceSetStaticHostnameReadyData, _ready_data);
}

static void
system_interface_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetPrettyHostname") == 0) {
		_dbus_system_interface_set_pretty_hostname (object, parameters, invocation);
	} else if (strcmp (method_name, "SetStaticHostname") == 0) {
		_dbus_system_interface_set_static_hostname (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_system_interface_get_icon_name (SystemInterface* self)
{
	gchar* result;
	GVariant* _reply;
	result = system_interface_get_icon_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_system_interface_get_pretty_hostname (SystemInterface* self)
{
	gchar* result;
	GVariant* _reply;
	result = system_interface_get_pretty_hostname (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_system_interface_get_static_hostname (SystemInterface* self)
{
	gchar* result;
	GVariant* _reply;
	result = system_interface_get_static_hostname (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
system_interface_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "IconName") == 0) {
		return _dbus_system_interface_get_icon_name (object);
	} else if (strcmp (property_name, "PrettyHostname") == 0) {
		return _dbus_system_interface_get_pretty_hostname (object);
	} else if (strcmp (property_name, "StaticHostname") == 0) {
		return _dbus_system_interface_get_static_hostname (object);
	}
	return NULL;
}

static gboolean
system_interface_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
system_interface_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_system_interface_dbus_interface_info), &_system_interface_dbus_interface_vtable, data, _system_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_system_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gchar*
session_manager_get_renderer (SessionManager* self)
{
	SessionManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_renderer) {
		return _iface_->get_renderer (self);
	}
	return NULL;
}

static void
session_manager_default_init (SessionManagerIface * iface,
                              gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
session_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType session_manager_type_id;
	session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "SessionManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (session_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) session_manager_proxy_get_type);
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_session_manager_dbus_interface_info));
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) session_manager_register_object);
	return session_manager_type_id;
}

GType
session_manager_get_type (void)
{
	static volatile gsize session_manager_type_id__once = 0;
	if (g_once_init_enter (&session_manager_type_id__once)) {
		GType session_manager_type_id;
		session_manager_type_id = session_manager_get_type_once ();
		g_once_init_leave (&session_manager_type_id__once, session_manager_type_id);
	}
	return session_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SessionManagerProxy, session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SESSION_MANAGER, session_manager_proxy_session_manager_interface_init) )
static void
session_manager_proxy_class_init (SessionManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = session_manager_proxy_g_signal;
}

static void
session_manager_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters)
{
}

static void
session_manager_proxy_init (SessionManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_session_manager_dbus_interface_info));
}

static gchar*
session_manager_dbus_proxy_get_renderer (SessionManager* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Renderer");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SessionManager"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Renderer"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
session_manager_proxy_session_manager_interface_init (SessionManagerIface* iface)
{
	iface->get_renderer = session_manager_dbus_proxy_get_renderer;
}

static void
session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_session_manager_get_renderer (SessionManager* self)
{
	gchar* result;
	GVariant* _reply;
	result = session_manager_get_renderer (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Renderer") == 0) {
		return _dbus_session_manager_get_renderer (object);
	}
	return NULL;
}

static gboolean
session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
session_manager_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_session_manager_dbus_interface_info), &_session_manager_dbus_interface_vtable, data, _session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_session_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gboolean
switcheroo_control_get_has_dual_gpu (SwitcherooControl* self)
{
	SwitcherooControlIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SWITCHEROO_CONTROL_GET_INTERFACE (self);
	if (_iface_->get_has_dual_gpu) {
		return _iface_->get_has_dual_gpu (self);
	}
	return FALSE;
}

GHashTable**
switcheroo_control_get_gpus (SwitcherooControl* self,
                             gint* result_length1)
{
	SwitcherooControlIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SWITCHEROO_CONTROL_GET_INTERFACE (self);
	if (_iface_->get_gpus) {
		return _iface_->get_gpus (self, result_length1);
	}
	return NULL;
}

static void
switcheroo_control_default_init (SwitcherooControlIface * iface,
                                 gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
switcheroo_control_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitcherooControlIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcheroo_control_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType switcheroo_control_type_id;
	switcheroo_control_type_id = g_type_register_static (G_TYPE_INTERFACE, "SwitcherooControl", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (switcheroo_control_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (switcheroo_control_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) switcheroo_control_proxy_get_type);
	g_type_set_qdata (switcheroo_control_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "net.hadess.SwitcherooControl");
	g_type_set_qdata (switcheroo_control_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_switcheroo_control_dbus_interface_info));
	g_type_set_qdata (switcheroo_control_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) switcheroo_control_register_object);
	return switcheroo_control_type_id;
}

GType
switcheroo_control_get_type (void)
{
	static volatile gsize switcheroo_control_type_id__once = 0;
	if (g_once_init_enter (&switcheroo_control_type_id__once)) {
		GType switcheroo_control_type_id;
		switcheroo_control_type_id = switcheroo_control_get_type_once ();
		g_once_init_leave (&switcheroo_control_type_id__once, switcheroo_control_type_id);
	}
	return switcheroo_control_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SwitcherooControlProxy, switcheroo_control_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SWITCHEROO_CONTROL, switcheroo_control_proxy_switcheroo_control_interface_init) )
static void
switcheroo_control_proxy_class_init (SwitcherooControlProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = switcheroo_control_proxy_g_signal;
}

static void
switcheroo_control_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
switcheroo_control_proxy_init (SwitcherooControlProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_switcheroo_control_dbus_interface_info));
}

static gboolean
switcheroo_control_dbus_proxy_get_has_dual_gpu (SwitcherooControl* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "HasDualGpu");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.SwitcherooControl"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasDualGpu"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp65_ = FALSE;
			return _tmp65_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static GHashTable**
switcheroo_control_dbus_proxy_get_gpus (SwitcherooControl* self,
                                        gint* result_length1)
{
	GVariant *_inner_reply;
	GHashTable** _result;
	gint _result_length1;
	GHashTable** _tmp66_;
	gint _tmp66__length;
	gint _tmp66__size;
	gint _tmp66__length1;
	GVariantIter _tmp67_;
	GVariant* _tmp68_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "GPUs");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.SwitcherooControl"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("GPUs"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp66_ = g_new (GHashTable*, 5);
	_tmp66__length = 0;
	_tmp66__size = 4;
	_tmp66__length1 = 0;
	g_variant_iter_init (&_tmp67_, _inner_reply);
	for (; (_tmp68_ = g_variant_iter_next_value (&_tmp67_)) != NULL; _tmp66__length1++) {
		GHashTable* _tmp69_;
		GVariantIter _tmp70_;
		GVariant* _tmp71_;
		GVariant* _tmp72_;
		if (_tmp66__size == _tmp66__length) {
			_tmp66__size = 2 * _tmp66__size;
			_tmp66_ = g_renew (GHashTable*, _tmp66_, _tmp66__size + 1);
		}
		_tmp69_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp70_, _tmp68_);
		while (g_variant_iter_loop (&_tmp70_, "{?*}", &_tmp71_, &_tmp72_)) {
			g_hash_table_insert (_tmp69_, g_variant_dup_string (_tmp71_, NULL), g_variant_get_variant (_tmp72_));
		}
		_tmp66_[_tmp66__length++] = _tmp69_;
		g_variant_unref (_tmp68_);
	}
	_result_length1 = _tmp66__length1;
	_tmp66_[_tmp66__length] = NULL;
	_result = _tmp66_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static void
switcheroo_control_proxy_switcheroo_control_interface_init (SwitcherooControlIface* iface)
{
	iface->get_has_dual_gpu = switcheroo_control_dbus_proxy_get_has_dual_gpu;
	iface->get_gpus = switcheroo_control_dbus_proxy_get_gpus;
}

static void
switcheroo_control_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_switcheroo_control_get_has_dual_gpu (SwitcherooControl* self)
{
	gboolean result;
	GVariant* _reply;
	result = switcheroo_control_get_has_dual_gpu (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_switcheroo_control_get_gpus (SwitcherooControl* self)
{
	GHashTable** result;
	gint result_length1 = 0;
	GVariant* _reply;
	GHashTable** _tmp73_;
	GVariantBuilder _tmp74_;
	gint _tmp75_;
	result = switcheroo_control_get_gpus (self, &result_length1);
	_tmp73_ = result;
	g_variant_builder_init (&_tmp74_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp75_ = 0; _tmp75_ < result_length1; _tmp75_++) {
		GVariantBuilder _tmp76_;
		GHashTableIter _tmp77_;
		gpointer _tmp78_;
		gpointer _tmp79_;
		g_hash_table_iter_init (&_tmp77_, *_tmp73_);
		g_variant_builder_init (&_tmp76_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp77_, &_tmp78_, &_tmp79_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp78_;
			_value = (GVariant*) _tmp79_;
			g_variant_builder_add (&_tmp76_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp74_, g_variant_builder_end (&_tmp76_));
		_tmp73_++;
	}
	_reply = g_variant_builder_end (&_tmp74_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	return _reply;
}

static GVariant*
switcheroo_control_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "HasDualGpu") == 0) {
		return _dbus_switcheroo_control_get_has_dual_gpu (object);
	} else if (strcmp (property_name, "GPUs") == 0) {
		return _dbus_switcheroo_control_get_gpus (object);
	}
	return NULL;
}

static gboolean
switcheroo_control_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
switcheroo_control_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_switcheroo_control_dbus_interface_info), &_switcheroo_control_dbus_interface_vtable, data, _switcheroo_control_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_switcheroo_control_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

