/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkRegionOfInterestImageFilter.h"
#include "itkRegionOfInterestImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
RegionOfInterestImageFilter::RegionOfInterestImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
RegionOfInterestImageFilter::~RegionOfInterestImageFilter() = default;


//
// Custom Methods
//

void RegionOfInterestImageFilter::SetRegionOfInterest(const std::vector<unsigned int> & Region )
{
  size_t sz = Region.size(); this->SetIndex(std::vector<int>(Region.begin(), Region.begin()+sz/2)); this->SetSize(std::vector<unsigned int>(Region.begin()+sz/2, Region.end()));
}


//
// ToString
//
std::string RegionOfInterestImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::RegionOfInterestImageFilter\n";
  out << "  Size: ";
  this->ToStringHelper(out, this->m_Size);
  out << std::endl;
  out << "  Index: ";
  this->ToStringHelper(out, this->m_Index);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image RegionOfInterestImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image RegionOfInterestImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::RegionOfInterestImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  
   typename InputImageType::RegionType itkRegion(sitkSTLVectorToITK<typename InputImageType::IndexType>(m_Index), sitkSTLVectorToITK<typename InputImageType::SizeType>(m_Size));
  filter->SetRegionOfInterest( itkRegion );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image RegionOfInterest ( const Image& image1, std::vector<unsigned int> size, std::vector<int> index )
{
  RegionOfInterestImageFilter filter;
  filter.SetSize( size );  filter.SetIndex( index );
  return filter.Execute ( image1 );
}


}
