/* APIGlue.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from APIGlue.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include "shotwell-plugin-dev-1.0.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (publishing_glue_media_source_publishable_wrapper_get_type ())
#define PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper))
#define PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapperClass))
#define PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER))
#define PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER))
#define PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapperClass))

typedef struct _PublishingGlueMediaSourcePublishableWrapper PublishingGlueMediaSourcePublishableWrapper;
typedef struct _PublishingGlueMediaSourcePublishableWrapperClass PublishingGlueMediaSourcePublishableWrapperClass;
typedef struct _PublishingGlueMediaSourcePublishableWrapperPrivate PublishingGlueMediaSourcePublishableWrapperPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
enum  {
	PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_0_PROPERTY,
	PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_NUM_PROPERTIES
};
static GParamSpec* publishing_glue_media_source_publishable_wrapper_properties[PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())

struct _PublishingGlueMediaSourcePublishableWrapper {
	GObject parent_instance;
	PublishingGlueMediaSourcePublishableWrapperPrivate * priv;
};

struct _PublishingGlueMediaSourcePublishableWrapperClass {
	GObjectClass parent_class;
};

struct _PublishingGlueMediaSourcePublishableWrapperPrivate {
	MediaSource* wrapped;
	GFile* serialized_file;
	GeeMap* param_string;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

static gint PublishingGlueMediaSourcePublishableWrapper_private_offset;
static gpointer publishing_glue_media_source_publishable_wrapper_parent_class = NULL;
static gint publishing_glue_media_source_publishable_wrapper_name_ticker;
static gint publishing_glue_media_source_publishable_wrapper_name_ticker = 0;
VALA_EXTERN TagSourceCollection* tag_global;
static SpitPublishingPublishableIface * publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_parent_iface = NULL;

VALA_EXTERN GType publishing_glue_media_source_publishable_wrapper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PublishingGlueMediaSourcePublishableWrapper, g_object_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN PublishingGlueMediaSourcePublishableWrapper* publishing_glue_media_source_publishable_wrapper_new (MediaSource* to_wrap);
VALA_EXTERN PublishingGlueMediaSourcePublishableWrapper* publishing_glue_media_source_publishable_wrapper_construct (GType object_type,
                                                                                                         MediaSource* to_wrap);
static void publishing_glue_media_source_publishable_wrapper_setup_parameters (PublishingGlueMediaSourcePublishableWrapper* self);
VALA_EXTERN void publishing_glue_media_source_publishable_wrapper_clean_up (PublishingGlueMediaSourcePublishableWrapper* self);
VALA_EXTERN gchar* media_source_get_basename (MediaSource* self);
VALA_EXTERN gchar* media_source_get_title (MediaSource* self);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN GType event_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSource, g_object_unref)
VALA_EXTERN GType event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Event, g_object_unref)
VALA_EXTERN Event* media_source_get_event (MediaSource* self);
VALA_EXTERN gchar* event_source_get_comment (EventSource* self);
VALA_EXTERN GFile* publishing_glue_media_source_publishable_wrapper_serialize_for_publishing (PublishingGlueMediaSourcePublishableWrapper* self,
                                                                                  gint content_major_axis,
                                                                                  gboolean strip_metadata,
                                                                                  GError** error);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN GFile* app_dirs_get_temp_dir (void);
VALA_EXTERN gchar* data_source_get_source_id (DataSource* self);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN void scaling_for_best_fit (gint pixels,
                           gboolean scale_up,
                           Scaling* result);
VALA_EXTERN void scaling_for_original (Scaling* result);
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_export (Photo* self,
                   GFile* dest_file,
                   Scaling* scaling,
                   JpegQuality quality,
                   PhotoFileFormat export_format,
                   gboolean direct_copy_unmodified,
                   gboolean export_metadata,
                   GError** error);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN void disassemble_filename (const gchar* basename,
                           gchar** name,
                           gchar** ext);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
VALA_EXTERN void video_export (Video* self,
                   GFile* dest_file,
                   GError** error);
static gchar* publishing_glue_media_source_publishable_wrapper_real_get_publishing_name (SpitPublishingPublishable* base);
static gchar* publishing_glue_media_source_publishable_wrapper_real_get_param_string (SpitPublishingPublishable* base,
                                                                               const gchar* name);
static gchar** publishing_glue_media_source_publishable_wrapper_real_get_publishing_keywords (SpitPublishingPublishable* base,
                                                                                       gint* result_length1);
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType tag_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagSourceCollection, data_collection_unref)
VALA_EXTERN GeeSortedSet* tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self,
                                                             MediaSource* photo);
static void _vala_array_add60 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup31 (gchar** self,
                           gssize length);
static SpitPublishingPublisherMediaType publishing_glue_media_source_publishable_wrapper_real_get_media_type (SpitPublishingPublishable* base);
static GFile* publishing_glue_media_source_publishable_wrapper_real_get_serialized_file (SpitPublishingPublishable* base);
static GDateTime* publishing_glue_media_source_publishable_wrapper_real_get_exposure_date_time (SpitPublishingPublishable* base);
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
static guint publishing_glue_media_source_publishable_wrapper_real_get_rating (SpitPublishingPublishable* base);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
static void publishing_glue_media_source_publishable_wrapper_finalize (GObject * obj);
static GType publishing_glue_media_source_publishable_wrapper_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
publishing_glue_media_source_publishable_wrapper_get_instance_private (PublishingGlueMediaSourcePublishableWrapper* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingGlueMediaSourcePublishableWrapper_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PublishingGlueMediaSourcePublishableWrapper*
publishing_glue_media_source_publishable_wrapper_construct (GType object_type,
                                                            MediaSource* to_wrap)
{
	PublishingGlueMediaSourcePublishableWrapper * self = NULL;
	MediaSource* _tmp0_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (to_wrap), NULL);
	self = (PublishingGlueMediaSourcePublishableWrapper*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (to_wrap);
	_g_object_unref0 (self->priv->wrapped);
	self->priv->wrapped = _tmp0_;
	publishing_glue_media_source_publishable_wrapper_setup_parameters (self);
	return self;
}

PublishingGlueMediaSourcePublishableWrapper*
publishing_glue_media_source_publishable_wrapper_new (MediaSource* to_wrap)
{
	return publishing_glue_media_source_publishable_wrapper_construct (PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, to_wrap);
}

void
publishing_glue_media_source_publishable_wrapper_clean_up (PublishingGlueMediaSourcePublishableWrapper* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (self));
	_tmp0_ = self->priv->serialized_file;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->serialized_file;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("APIGlue.vala:24: cleaning up temporary publishing file '%s'.", _tmp3_);
	_g_free0 (_tmp3_);
	{
		GFile* _tmp4_;
		_tmp4_ = self->priv->serialized_file;
		g_file_delete (_tmp4_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = self->priv->serialized_file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		g_warning ("APIGlue.vala:29: couldn't delete temporary publishing file '%s'.", _tmp7_);
		_g_free0 (_tmp7_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (self->priv->serialized_file);
	self->priv->serialized_file = NULL;
}

static void
publishing_glue_media_source_publishable_wrapper_setup_parameters (PublishingGlueMediaSourcePublishableWrapper* self)
{
	GeeMap* _tmp0_;
	MediaSource* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeMap* _tmp4_;
	MediaSource* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeMap* _tmp8_;
	MediaSource* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	MediaSource* _tmp12_;
	Event* _tmp13_;
	Event* _tmp14_;
	gboolean _tmp15_;
	g_return_if_fail (PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (self));
	_tmp0_ = self->priv->param_string;
	_tmp1_ = self->priv->wrapped;
	_tmp2_ = media_source_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	gee_map_set (_tmp0_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_BASENAME, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->param_string;
	_tmp5_ = self->priv->wrapped;
	_tmp6_ = media_source_get_title (_tmp5_);
	_tmp7_ = _tmp6_;
	gee_map_set (_tmp4_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_TITLE, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->param_string;
	_tmp9_ = self->priv->wrapped;
	_tmp10_ = media_source_get_comment (_tmp9_);
	_tmp11_ = _tmp10_;
	gee_map_set (_tmp8_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_COMMENT, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->wrapped;
	_tmp13_ = media_source_get_event (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ != NULL;
	_g_object_unref0 (_tmp14_);
	if (_tmp15_) {
		GeeMap* _tmp16_;
		MediaSource* _tmp17_;
		Event* _tmp18_;
		Event* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp16_ = self->priv->param_string;
		_tmp17_ = self->priv->wrapped;
		_tmp18_ = media_source_get_event (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_EVENT_SOURCE, EventSource));
		_tmp21_ = _tmp20_;
		gee_map_set (_tmp16_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_EVENTCOMMENT, _tmp21_);
		_g_free0 (_tmp21_);
		_g_object_unref0 (_tmp19_);
	} else {
		GeeMap* _tmp22_;
		_tmp22_ = self->priv->param_string;
		gee_map_set (_tmp22_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_EVENTCOMMENT, "");
	}
}

GFile*
publishing_glue_media_source_publishable_wrapper_serialize_for_publishing (PublishingGlueMediaSourcePublishableWrapper* self,
                                                                           gint content_major_axis,
                                                                           gboolean strip_metadata,
                                                                           GError** error)
{
	MediaSource* _tmp0_;
	GFile* _tmp60_;
	GFile* _tmp61_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (self), NULL);
	_tmp0_ = self->priv->wrapped;
	if (IS_LIBRARY_PHOTO (_tmp0_)) {
		LibraryPhoto* photo = NULL;
		MediaSource* _tmp1_;
		LibraryPhoto* _tmp2_;
		GFile* to_file = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		LibraryPhoto* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		_tmp1_ = self->priv->wrapped;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
		photo = _tmp2_;
		_tmp3_ = app_dirs_get_temp_dir ();
		_tmp4_ = _tmp3_;
		_tmp5_ = publishing_glue_media_source_publishable_wrapper_name_ticker;
		publishing_glue_media_source_publishable_wrapper_name_ticker = _tmp5_ + 1;
		_tmp6_ = g_strdup_printf ("publishing-%d.jpg", _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_child (_tmp4_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
		to_file = _tmp9_;
		_tmp10_ = photo;
		_tmp11_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_SOURCE, DataSource));
		_tmp12_ = _tmp11_;
		_tmp13_ = to_file;
		_tmp14_ = g_file_get_path (_tmp13_);
		_tmp15_ = _tmp14_;
		g_debug ("APIGlue.vala:55: writing photo '%s' to temporary file '%s' for publish" \
"ing.", _tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		{
			Scaling _tmp16_ = {0};
			Scaling scaling = {0};
			LibraryPhoto* _tmp19_;
			GFile* _tmp20_;
			Scaling _tmp21_;
			if (content_major_axis > 0) {
				Scaling _tmp17_ = {0};
				scaling_for_best_fit (content_major_axis, FALSE, &_tmp17_);
				_tmp16_ = _tmp17_;
			} else {
				Scaling _tmp18_ = {0};
				scaling_for_original (&_tmp18_);
				_tmp16_ = _tmp18_;
			}
			scaling = _tmp16_;
			_tmp19_ = photo;
			_tmp20_ = to_file;
			_tmp21_ = scaling;
			photo_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO, Photo), _tmp20_, &_tmp21_, JPEG_QUALITY_HIGH, PHOTO_FILE_FORMAT_JFIF, FALSE, !strip_metadata, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			LibraryPhoto* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			GError* _tmp25_;
			GError* _tmp26_;
			g_clear_error (&_inner_error0_);
			_tmp22_ = photo;
			_tmp23_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_DATA_OBJECT, DataObject));
			_tmp24_ = _tmp23_;
			_tmp25_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR, "unable to serialize photo '%s' for publishing.", _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp24_);
			_inner_error0_ = _tmp26_;
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (to_file);
				_g_object_unref0 (photo);
				return NULL;
			} else {
				_g_object_unref0 (to_file);
				_g_object_unref0 (photo);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp27_ = to_file;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_g_object_unref0 (self->priv->serialized_file);
		self->priv->serialized_file = _tmp28_;
		_g_object_unref0 (to_file);
		_g_object_unref0 (photo);
	} else {
		MediaSource* _tmp29_;
		_tmp29_ = self->priv->wrapped;
		if (IS_VIDEO (_tmp29_)) {
			Video* video = NULL;
			MediaSource* _tmp30_;
			Video* _tmp31_;
			gchar* basename = NULL;
			gchar* extension = NULL;
			Video* _tmp32_;
			GFile* _tmp33_;
			GFile* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			GFile* to_file = NULL;
			gint _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			GFile* _tmp43_;
			GFile* _tmp44_;
			Video* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			GFile* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			GFile* _tmp58_;
			GFile* _tmp59_;
			_tmp30_ = self->priv->wrapped;
			_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_VIDEO, Video));
			video = _tmp31_;
			_tmp32_ = video;
			_tmp33_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp34_ = _tmp33_;
			_tmp35_ = g_file_get_basename (_tmp34_);
			_tmp36_ = _tmp35_;
			disassemble_filename (_tmp36_, &_tmp37_, &_tmp38_);
			_g_free0 (basename);
			basename = _tmp37_;
			_g_free0 (extension);
			extension = _tmp38_;
			_g_free0 (_tmp36_);
			_g_object_unref0 (_tmp34_);
			_tmp39_ = publishing_glue_media_source_publishable_wrapper_name_ticker;
			publishing_glue_media_source_publishable_wrapper_name_ticker = _tmp39_ + 1;
			_tmp40_ = extension;
			_tmp41_ = g_strdup_printf ("publishing-%d.%s", _tmp39_, _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_file_new_for_path (_tmp42_);
			_tmp44_ = _tmp43_;
			_g_free0 (_tmp42_);
			to_file = _tmp44_;
			_tmp45_ = video;
			_tmp46_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_DATA_SOURCE, DataSource));
			_tmp47_ = _tmp46_;
			_tmp48_ = to_file;
			_tmp49_ = g_file_get_path (_tmp48_);
			_tmp50_ = _tmp49_;
			g_debug ("APIGlue.vala:77: writing video '%s' to temporary file '%s' for publish" \
"ing.", _tmp47_, _tmp50_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp47_);
			{
				Video* _tmp51_;
				GFile* _tmp52_;
				_tmp51_ = video;
				_tmp52_ = to_file;
				video_export (_tmp51_, _tmp52_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				Video* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				GError* _tmp56_;
				GError* _tmp57_;
				g_clear_error (&_inner_error0_);
				_tmp53_ = video;
				_tmp54_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, TYPE_DATA_OBJECT, DataObject));
				_tmp55_ = _tmp54_;
				_tmp56_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR, "unable to serialize video '%s' for publishing.", _tmp55_);
				_tmp57_ = _tmp56_;
				_g_free0 (_tmp55_);
				_inner_error0_ = _tmp57_;
				goto __finally1;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (to_file);
					_g_free0 (extension);
					_g_free0 (basename);
					_g_object_unref0 (video);
					return NULL;
				} else {
					_g_object_unref0 (to_file);
					_g_free0 (extension);
					_g_free0 (basename);
					_g_object_unref0 (video);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp58_ = to_file;
			_tmp59_ = _g_object_ref0 (_tmp58_);
			_g_object_unref0 (self->priv->serialized_file);
			self->priv->serialized_file = _tmp59_;
			_g_object_unref0 (to_file);
			_g_free0 (extension);
			_g_free0 (basename);
			_g_object_unref0 (video);
		} else {
			g_error ("APIGlue.vala:88: MediaSourcePublishableWrapper.serialize_for_publishin" \
"g( ): unknown media type.");
		}
	}
	_tmp60_ = self->priv->serialized_file;
	_tmp61_ = _g_object_ref0 (_tmp60_);
	result = _tmp61_;
	return result;
}

static gchar*
publishing_glue_media_source_publishable_wrapper_real_get_publishing_name (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	gchar* _tmp0_ = NULL;
	MediaSource* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	_tmp1_ = self->priv->wrapped;
	_tmp2_ = media_source_get_title (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		MediaSource* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->wrapped;
		_tmp6_ = media_source_get_title (_tmp5_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
publishing_glue_media_source_publishable_wrapper_real_get_param_string (SpitPublishingPublishable* base,
                                                                        const gchar* name)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->param_string;
	_tmp1_ = gee_map_get (_tmp0_, name);
	result = (gchar*) _tmp1_;
	return result;
}

static void
_vala_array_add60 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup31 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
publishing_glue_media_source_publishable_wrapper_real_get_publishing_keywords (SpitPublishingPublishable* base,
                                                                               gint* result_length1)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	GeeCollection* tagset = NULL;
	TagSourceCollection* _tmp1_;
	MediaSource* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeCollection* _tmp4_;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint __tmp12__size_ = 0;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = tag_global;
	_tmp2_ = self->priv->wrapped;
	_tmp3_ = tag_source_collection_fetch_sorted_for_source (_tmp1_, _tmp2_);
	tagset = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp4_ = tagset;
	if (_tmp4_ != NULL) {
		{
			GeeIterator* _tag_it = NULL;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			_tmp5_ = tagset;
			_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
			_tag_it = _tmp6_;
			while (TRUE) {
				GeeIterator* _tmp7_;
				Tag* tag = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				Tag* _tmp10_;
				gchar* _tmp11_;
				_tmp7_ = _tag_it;
				if (!gee_iterator_next (_tmp7_)) {
					break;
				}
				_tmp8_ = _tag_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				tag = (Tag*) _tmp9_;
				_tmp10_ = tag;
				_tmp11_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
				_vala_array_add60 (&_result_, &_result__length1, &__result__size_, _tmp11_);
				_g_object_unref0 (tag);
			}
			_g_object_unref0 (_tag_it);
		}
	}
	_tmp13_ = _result_;
	_tmp13__length1 = _result__length1;
	if (_tmp13__length1 > 0) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = _result_;
		_tmp14__length1 = _result__length1;
		_tmp12_ = _tmp14_;
		_tmp12__length1 = _tmp14__length1;
		__tmp12__size_ = _tmp12__length1;
	} else {
		_tmp12_ = NULL;
		_tmp12__length1 = 0;
		__tmp12__size_ = _tmp12__length1;
	}
	_tmp15_ = (_tmp12_ != NULL) ? _vala_array_dup31 (_tmp12_, _tmp12__length1) : _tmp12_;
	_tmp15__length1 = _tmp12__length1;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp15__length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	_g_object_unref0 (tagset);
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static SpitPublishingPublisherMediaType
publishing_glue_media_source_publishable_wrapper_real_get_media_type (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	MediaSource* _tmp0_;
	SpitPublishingPublisherMediaType result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	_tmp0_ = self->priv->wrapped;
	if (IS_LIBRARY_PHOTO (_tmp0_)) {
		result = SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO;
		return result;
	} else {
		MediaSource* _tmp1_;
		_tmp1_ = self->priv->wrapped;
		if (IS_VIDEO (_tmp1_)) {
			result = SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO;
			return result;
		} else {
			result = SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE;
			return result;
		}
	}
}

static GFile*
publishing_glue_media_source_publishable_wrapper_real_get_serialized_file (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	_tmp0_ = self->priv->serialized_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static GDateTime*
publishing_glue_media_source_publishable_wrapper_real_get_exposure_date_time (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	MediaSource* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	_tmp0_ = self->priv->wrapped;
	_tmp1_ = media_source_get_exposure_time (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_date_time_to_local (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_date_time_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static guint
publishing_glue_media_source_publishable_wrapper_real_get_rating (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	MediaSource* _tmp0_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	_tmp0_ = self->priv->wrapped;
	result = (guint) media_source_get_rating (_tmp0_);
	return result;
}

static void
publishing_glue_media_source_publishable_wrapper_class_init (PublishingGlueMediaSourcePublishableWrapperClass * klass,
                                                             gpointer klass_data)
{
	publishing_glue_media_source_publishable_wrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PublishingGlueMediaSourcePublishableWrapper_private_offset);
	G_OBJECT_CLASS (klass)->finalize = publishing_glue_media_source_publishable_wrapper_finalize;
}

static void
publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_interface_init (SpitPublishingPublishableIface * iface,
                                                                                             gpointer iface_data)
{
	publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_publishing_name = (gchar* (*) (SpitPublishingPublishable*)) publishing_glue_media_source_publishable_wrapper_real_get_publishing_name;
	iface->get_param_string = (gchar* (*) (SpitPublishingPublishable*, const gchar*)) publishing_glue_media_source_publishable_wrapper_real_get_param_string;
	iface->get_publishing_keywords = (gchar** (*) (SpitPublishingPublishable*, gint*)) publishing_glue_media_source_publishable_wrapper_real_get_publishing_keywords;
	iface->get_media_type = (SpitPublishingPublisherMediaType (*) (SpitPublishingPublishable*)) publishing_glue_media_source_publishable_wrapper_real_get_media_type;
	iface->get_serialized_file = (GFile* (*) (SpitPublishingPublishable*)) publishing_glue_media_source_publishable_wrapper_real_get_serialized_file;
	iface->get_exposure_date_time = (GDateTime* (*) (SpitPublishingPublishable*)) publishing_glue_media_source_publishable_wrapper_real_get_exposure_date_time;
	iface->get_rating = (guint (*) (SpitPublishingPublishable*)) publishing_glue_media_source_publishable_wrapper_real_get_rating;
}

static void
publishing_glue_media_source_publishable_wrapper_instance_init (PublishingGlueMediaSourcePublishableWrapper * self,
                                                                gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = publishing_glue_media_source_publishable_wrapper_get_instance_private (self);
	self->priv->serialized_file = NULL;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->param_string = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
}

static void
publishing_glue_media_source_publishable_wrapper_finalize (GObject * obj)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
	_g_object_unref0 (self->priv->wrapped);
	_g_object_unref0 (self->priv->serialized_file);
	_g_object_unref0 (self->priv->param_string);
	G_OBJECT_CLASS (publishing_glue_media_source_publishable_wrapper_parent_class)->finalize (obj);
}

static GType
publishing_glue_media_source_publishable_wrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingGlueMediaSourcePublishableWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_glue_media_source_publishable_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingGlueMediaSourcePublishableWrapper), 0, (GInstanceInitFunc) publishing_glue_media_source_publishable_wrapper_instance_init, NULL };
	static const GInterfaceInfo spit_publishing_publishable_info = { (GInterfaceInitFunc) publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType publishing_glue_media_source_publishable_wrapper_type_id;
	publishing_glue_media_source_publishable_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "PublishingGlueMediaSourcePublishableWrapper", &g_define_type_info, 0);
	g_type_add_interface_static (publishing_glue_media_source_publishable_wrapper_type_id, SPIT_PUBLISHING_TYPE_PUBLISHABLE, &spit_publishing_publishable_info);
	PublishingGlueMediaSourcePublishableWrapper_private_offset = g_type_add_instance_private (publishing_glue_media_source_publishable_wrapper_type_id, sizeof (PublishingGlueMediaSourcePublishableWrapperPrivate));
	return publishing_glue_media_source_publishable_wrapper_type_id;
}

GType
publishing_glue_media_source_publishable_wrapper_get_type (void)
{
	static volatile gsize publishing_glue_media_source_publishable_wrapper_type_id__once = 0;
	if (g_once_init_enter (&publishing_glue_media_source_publishable_wrapper_type_id__once)) {
		GType publishing_glue_media_source_publishable_wrapper_type_id;
		publishing_glue_media_source_publishable_wrapper_type_id = publishing_glue_media_source_publishable_wrapper_get_type_once ();
		g_once_init_leave (&publishing_glue_media_source_publishable_wrapper_type_id__once, publishing_glue_media_source_publishable_wrapper_type_id);
	}
	return publishing_glue_media_source_publishable_wrapper_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

