/* EventDirectoryItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EventDirectoryItem.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define THUMBNAIL_CACHE_DEFAULT_INTERP GDK_INTERP_HYPER
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_EVENT_DIRECTORY_ITEM (event_directory_item_get_type ())
#define EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem))
#define EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))
#define IS_EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_DIRECTORY_ITEM))
#define IS_EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_DIRECTORY_ITEM))
#define EVENT_DIRECTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))

typedef struct _EventDirectoryItem EventDirectoryItem;
typedef struct _EventDirectoryItemClass EventDirectoryItemClass;
typedef struct _EventDirectoryItemPrivate EventDirectoryItemPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
enum  {
	EVENT_DIRECTORY_ITEM_0_PROPERTY,
	EVENT_DIRECTORY_ITEM_NUM_PROPERTIES
};
static GParamSpec* event_directory_item_properties[EVENT_DIRECTORY_ITEM_NUM_PROPERTIES];

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_EVENT_SOURCE_COLLECTION (event_source_collection_get_type ())
#define EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollection))
#define EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))
#define IS_EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE_COLLECTION))
#define IS_EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE_COLLECTION))
#define EVENT_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))

typedef struct _EventSourceCollection EventSourceCollection;
typedef struct _EventSourceCollectionClass EventSourceCollectionClass;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())
typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer user_data);
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 512,
	THUMBNAIL_CACHE_SIZE_LARGE = 512,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*handle_mouse_motion) (CheckerboardItem* self, gint x, gint y, gint height, gint width);
	void (*handle_mouse_leave) (CheckerboardItem* self);
	void (*handle_mouse_enter) (CheckerboardItem* self);
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _EventDirectoryItem {
	CheckerboardItem parent_instance;
	EventDirectoryItemPrivate * priv;
	Event* event;
};

struct _EventDirectoryItemClass {
	CheckerboardItemClass parent_class;
};

struct _EventDirectoryItemPrivate {
	GdkRectangle paul_lynde;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

static gint EventDirectoryItem_private_offset;
static gpointer event_directory_item_parent_class = NULL;
VALA_EXTERN EventSourceCollection* event_global;
VALA_EXTERN Scaling event_directory_item_squared_scaling;
Scaling event_directory_item_squared_scaling = {0};

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailView, g_object_unref)
VALA_EXTERN GType checkerboard_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardItem, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType event_directory_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventDirectoryItem, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType event_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSource, g_object_unref)
VALA_EXTERN GType event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Event, g_object_unref)
VALA_EXTERN void checkerboard_item_exposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_unexposed (CheckerboardItem* self);
VALA_EXTERN void thumbnail_view_thumbnail_altered (ThumbnailView* self);
VALA_EXTERN void checkerboard_item_handle_mouse_leave (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_handle_mouse_motion (CheckerboardItem* self,
                                            gint x,
                                            gint y,
                                            gint height,
                                            gint width);
VALA_EXTERN void checkerboard_item_paint_shadow (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* dimensions,
                                     GdkPoint* origin,
                                     gint radius,
                                     gfloat initial_alpha);
VALA_EXTERN void checkerboard_item_paint_border (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* object_dimensions,
                                     GdkPoint* object_origin,
                                     gint border_width);
VALA_EXTERN void checkerboard_item_paint_image (CheckerboardItem* self,
                                    cairo_t* ctx,
                                    GdkPixbuf* pixbuf,
                                    GdkPoint* origin);
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType event_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSourceCollection, data_collection_unref)
static void event_directory_item_on_events_altered (EventDirectoryItem* self,
                                             GeeMap* map);
static void _event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                            GeeMap* items,
                                                                            gpointer self);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN void scaling_to_fill_viewport (Dimensions* viewport,
                               Scaling* result);
static gint event_directory_item_get_CROPPED_SCALE (void);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN EventDirectoryItem* event_directory_item_new (Event* event);
VALA_EXTERN EventDirectoryItem* event_directory_item_construct (GType object_type,
                                                    Event* event);
static gchar* event_directory_item_get_formatted_title (Event* event);
VALA_EXTERN gchar* event_source_get_comment (EventSource* self);
VALA_EXTERN CheckerboardItem* checkerboard_item_construct (GType object_type,
                                               ThumbnailSource* source,
                                               Dimensions* initial_pixbuf_dim,
                                               const gchar* title,
                                               const gchar* comment,
                                               gboolean marked_up,
                                               PangoAlignment alignment);
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
static void event_directory_item_get_paul_lynde_rect (MediaSource* source,
                                               GdkRectangle* result);
VALA_EXTERN MediaSource* event_get_primary_source (Event* self);
VALA_EXTERN void checkerboard_item_clear_image (CheckerboardItem* self,
                                    Dimensions* dim);
VALA_EXTERN void dimensions_for_rectangle (GdkRectangle* rect,
                               Dimensions* result);
VALA_EXTERN void scaling_get_scaled_dimensions (Scaling *self,
                                    Dimensions* original,
                                    Dimensions* result);
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
static GdkPixbuf* event_directory_item_get_paul_lynde (MediaSource* media,
                                                GdkRectangle* paul_lynde,
                                                GError** error);
VALA_EXTERN GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self,
                                            Scaling* scaling,
                                            GError** error);
VALA_EXTERN void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                         gint scale,
                                         Dimensions* dim,
                                         GdkInterpType interp,
                                         ThumbnailCacheAsyncFetchCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable);
VALA_EXTERN GType thumbnail_cache_size_get_type (void) G_GNUC_CONST ;
static void ___lambda24_ (void);
static void ____lambda24__thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                         GdkPixbuf* unscaled,
                                                         Dimensions* dim,
                                                         GdkInterpType interp,
                                                         GError* err,
                                                         gpointer self);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
VALA_EXTERN void clamp_rectangle (GdkRectangle* original,
                      Dimensions* max,
                      GdkRectangle* result);
VALA_EXTERN gboolean media_source_collection_has_photo (GeeCollection* media);
VALA_EXTERN GeeCollection* event_source_get_media (EventSource* self);
VALA_EXTERN gboolean media_source_collection_has_video (GeeCollection* media);
VALA_EXTERN gint event_source_get_media_count (EventSource* self);
VALA_EXTERN gchar* event_get_formatted_daterange (Event* self);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gchar* guarded_markup_escape_text (const gchar* plain);
static void event_directory_item_real_exposed (CheckerboardItem* base);
VALA_EXTERN gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_image (CheckerboardItem* self,
                                  GdkPixbuf* pixbuf);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
static void event_directory_item_update_comment (EventDirectoryItem* self,
                                          gboolean init);
static void event_directory_item_real_unexposed (CheckerboardItem* base);
VALA_EXTERN void checkerboard_item_set_title (CheckerboardItem* self,
                                  const gchar* text,
                                  gboolean marked_up,
                                  PangoAlignment alignment);
static void event_directory_item_real_thumbnail_altered (ThumbnailView* base);
static void event_directory_item_set_paul_lynde (EventDirectoryItem* self,
                                          MediaSource* media);
static void event_directory_item_real_handle_mouse_leave (CheckerboardItem* base);
static void event_directory_item_real_handle_mouse_motion (CheckerboardItem* base,
                                                    gint x,
                                                    gint y,
                                                    gint height,
                                                    gint width);
static void event_directory_item_real_paint_shadow (CheckerboardItem* base,
                                             cairo_t* ctx,
                                             Dimensions* dimensions,
                                             GdkPoint* origin,
                                             gint radius,
                                             gfloat initial_alpha);
static void event_directory_item_real_paint_border (CheckerboardItem* base,
                                             cairo_t* ctx,
                                             Dimensions* object_dimensions,
                                             GdkPoint* object_origin,
                                             gint border_width);
VALA_EXTERN void checkerboard_item_get_border_dimensions (Dimensions* object_dim,
                                              gint border_width,
                                              Dimensions* result);
VALA_EXTERN void checkerboard_item_get_border_origin (GdkPoint* object_origin,
                                          gint border_width,
                                          GdkPoint* result);
VALA_EXTERN void draw_rounded_corners_filled (cairo_t* ctx,
                                  Dimensions* dim,
                                  GdkPoint* origin,
                                  gdouble radius_proportion);
static void event_directory_item_real_paint_image (CheckerboardItem* base,
                                            cairo_t* ctx,
                                            GdkPixbuf* pixbuf,
                                            GdkPoint* origin);
VALA_EXTERN void context_rounded_corners (cairo_t* cx,
                              Dimensions* dim,
                              GdkPoint* origin,
                              gdouble radius_proportion);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
VALA_EXTERN void checkerboard_item_clear_comment (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_comment (CheckerboardItem* self,
                                    const gchar* text,
                                    gboolean marked_up,
                                    PangoAlignment alignment);
VALA_EXTERN gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
static void event_directory_item_finalize (GObject * obj);
static GType event_directory_item_get_type_once (void);
static void _vala_event_directory_item_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
event_directory_item_get_instance_private (EventDirectoryItem* self)
{
	return G_STRUCT_MEMBER_P (self, EventDirectoryItem_private_offset);
}

static void
_event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                       GeeMap* items,
                                                                       gpointer self)
{
	event_directory_item_on_events_altered ((EventDirectoryItem*) self, items);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

EventDirectoryItem*
event_directory_item_construct (GType object_type,
                                Event* event)
{
	EventDirectoryItem * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	Event* _tmp9_;
	MediaSource* _tmp10_;
	MediaSource* _tmp11_;
	GdkRectangle _tmp12_ = {0};
	GdkRectangle _tmp13_;
	Dimensions _tmp14_ = {0};
	EventSourceCollection* _tmp15_;
	g_return_val_if_fail (IS_EVENT (event), NULL);
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp1_ = _tmp0_;
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp3_ = _tmp2_;
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
	_tmp5_ = event_directory_item_get_formatted_title (event);
	_tmp6_ = _tmp5_;
	_tmp7_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
	_tmp8_ = _tmp7_;
	self = (EventDirectoryItem*) checkerboard_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp4_, _tmp6_, _tmp8_, TRUE, PANGO_ALIGN_CENTER);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp9_ = _g_object_ref0 (event);
	_g_object_unref0 (self->event);
	self->event = _tmp9_;
	_tmp10_ = event_get_primary_source (event);
	_tmp11_ = _tmp10_;
	event_directory_item_get_paul_lynde_rect (_tmp11_, &_tmp12_);
	self->priv->paul_lynde = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_tmp13_ = self->priv->paul_lynde;
	dimensions_for_rectangle (&_tmp13_, &_tmp14_);
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp14_);
	_tmp15_ = event_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self, 0);
	return self;
}

EventDirectoryItem*
event_directory_item_new (Event* event)
{
	return event_directory_item_construct (TYPE_EVENT_DIRECTORY_ITEM, event);
}

static void
event_directory_item_get_paul_lynde_rect (MediaSource* source,
                                          GdkRectangle* result)
{
	Dimensions scaled = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	GdkRectangle paul_lynde = {0};
	Dimensions _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_;
	Dimensions _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	Dimensions _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (IS_MEDIA_SOURCE (source));
	media_source_get_dimensions (source, PHOTO_EXCEPTION_NONE, &_tmp0_);
	scaling_get_scaled_dimensions (&event_directory_item_squared_scaling, &_tmp0_, &_tmp1_);
	scaled = _tmp1_;
	memset (&paul_lynde, 0, sizeof (GdkRectangle));
	_tmp2_ = scaled;
	_tmp3_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp4_ = _tmp3_;
	_tmp5_ = scaled;
	paul_lynde.x = CLAMP (_tmp2_.width - _tmp4_, 0, _tmp5_.width) / 2;
	_tmp6_ = scaled;
	_tmp7_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp8_ = _tmp7_;
	_tmp9_ = scaled;
	paul_lynde.y = CLAMP (_tmp6_.height - _tmp8_, 0, _tmp9_.height) / 2;
	_tmp10_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp11_ = _tmp10_;
	paul_lynde.width = _tmp11_;
	_tmp12_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp13_ = _tmp12_;
	paul_lynde.height = _tmp13_;
	*result = paul_lynde;
	return;
}

static void
___lambda24_ (void)
{
}

static void
____lambda24__thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                    GdkPixbuf* unscaled,
                                                    Dimensions* dim,
                                                    GdkInterpType interp,
                                                    GError* err,
                                                    gpointer self)
{
	___lambda24_ ();
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static GdkPixbuf*
event_directory_item_get_paul_lynde (MediaSource* media,
                                     GdkRectangle* paul_lynde,
                                     GError** error)
{
	GdkPixbuf* pixbuf = NULL;
	Dimensions thumbnail_dimensions = {0};
	GdkPixbuf* _tmp13_;
	Dimensions _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	Dimensions _tmp16_;
	GdkRectangle _tmp17_;
	GdkRectangle _tmp28_;
	Dimensions _tmp29_;
	GdkRectangle _tmp30_ = {0};
	GdkPixbuf* _tmp31_;
	GdkRectangle _tmp32_;
	GdkRectangle _tmp33_;
	GdkRectangle _tmp34_;
	GdkRectangle _tmp35_;
	GdkPixbuf* _tmp36_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
	g_return_val_if_fail (paul_lynde != NULL, NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		Scaling _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp1_ = event_directory_item_squared_scaling;
		_tmp2_ = media_source_get_preview_pixbuf (media, &_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		Dimensions _tmp4_ = {0};
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		dimensions_init (&_tmp4_, (gint) THUMBNAIL_CACHE_SIZE_BIG, (gint) THUMBNAIL_CACHE_SIZE_BIG);
		thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_tmp4_, THUMBNAIL_CACHE_DEFAULT_INTERP, ____lambda24__thumbnail_cache_async_fetch_callback, NULL, NULL);
		if (IS_LIBRARY_PHOTO (media)) {
			LibraryPhoto* photo = NULL;
			LibraryPhoto* _tmp5_;
			GdkPixbuf* _tmp6_ = NULL;
			LibraryPhoto* _tmp7_;
			Scaling _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp5_;
			_tmp7_ = photo;
			_tmp8_ = event_directory_item_squared_scaling;
			_tmp9_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp8_, &_inner_error0_);
			_tmp6_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (photo);
				_g_error_free0 (_error_);
				goto __finally0;
			}
			_tmp10_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp10_;
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (photo);
		} else {
			GError* _tmp11_;
			GError* _tmp12_;
			_tmp11_ = _error_;
			_tmp12_ = _g_error_copy0 (_tmp11_);
			_inner_error0_ = _tmp12_;
			_g_error_free0 (_error_);
			goto __finally0;
		}
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pixbuf);
		return NULL;
	}
	_tmp13_ = pixbuf;
	dimensions_for_pixbuf (_tmp13_, &_tmp14_);
	thumbnail_dimensions = _tmp14_;
	_tmp16_ = thumbnail_dimensions;
	_tmp17_ = *paul_lynde;
	if (_tmp16_.width > (2 * _tmp17_.width)) {
		_tmp15_ = TRUE;
	} else {
		Dimensions _tmp18_;
		GdkRectangle _tmp19_;
		_tmp18_ = thumbnail_dimensions;
		_tmp19_ = *paul_lynde;
		_tmp15_ = _tmp18_.height > (_tmp19_.height * 2);
	}
	if (_tmp15_) {
		LibraryPhoto* photo = NULL;
		LibraryPhoto* _tmp20_;
		GdkPixbuf* _tmp21_ = NULL;
		LibraryPhoto* _tmp22_;
		Scaling _tmp23_;
		GdkPixbuf* _tmp24_;
		GdkPixbuf* _tmp25_;
		GdkPixbuf* _tmp26_;
		Dimensions _tmp27_ = {0};
		_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_LIBRARY_PHOTO, LibraryPhoto));
		photo = _tmp20_;
		_tmp22_ = photo;
		_tmp23_ = event_directory_item_squared_scaling;
		_tmp24_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp23_, &_inner_error0_);
		_tmp21_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (photo);
			_g_object_unref0 (pixbuf);
			return NULL;
		}
		_tmp25_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp25_;
		_tmp26_ = pixbuf;
		dimensions_for_pixbuf (_tmp26_, &_tmp27_);
		thumbnail_dimensions = _tmp27_;
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (photo);
	}
	_tmp28_ = *paul_lynde;
	_tmp29_ = thumbnail_dimensions;
	clamp_rectangle (&_tmp28_, &_tmp29_, &_tmp30_);
	*paul_lynde = _tmp30_;
	_tmp31_ = pixbuf;
	_tmp32_ = *paul_lynde;
	_tmp33_ = *paul_lynde;
	_tmp34_ = *paul_lynde;
	_tmp35_ = *paul_lynde;
	_tmp36_ = gdk_pixbuf_new_subpixbuf (_tmp31_, _tmp32_.x, _tmp33_.y, _tmp34_.width, _tmp35_.height);
	result = _tmp36_;
	_g_object_unref0 (pixbuf);
	return result;
}

static gchar*
event_directory_item_get_formatted_title (Event* event)
{
	gboolean has_photos = FALSE;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean has_videos = FALSE;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gint count = 0;
	gchar* count_text = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gchar* daterange = NULL;
	gchar* _tmp11_;
	gchar* name = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (IS_EVENT (event), NULL);
	_tmp0_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_collection_has_photo (_tmp1_);
	_g_object_unref0 (_tmp1_);
	has_photos = _tmp2_;
	_tmp3_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
	_tmp4_ = _tmp3_;
	_tmp5_ = media_source_collection_has_video (_tmp4_);
	_g_object_unref0 (_tmp4_);
	has_videos = _tmp5_;
	count = event_source_get_media_count (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
	_tmp6_ = g_strdup ("");
	count_text = _tmp6_;
	if (has_photos) {
		_tmp7_ = has_videos;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup_printf (ngettext ("%d Photo/Video", "%d Photos/Videos", (gulong) count), count);
		_g_free0 (count_text);
		count_text = _tmp8_;
	} else {
		if (has_videos) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup_printf (ngettext ("%d Video", "%d Videos", (gulong) count), count);
			_g_free0 (count_text);
			count_text = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup_printf (ngettext ("%d Photo", "%d Photos", (gulong) count), count);
			_g_free0 (count_text);
			count_text = _tmp10_;
		}
	}
	_tmp11_ = event_get_formatted_daterange (event);
	daterange = _tmp11_;
	_tmp12_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_DATA_OBJECT, DataObject));
	name = _tmp12_;
	_tmp14_ = daterange;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = daterange;
		_tmp16_ = name;
		_tmp13_ = g_strcmp0 (_tmp15_, _tmp16_) == 0;
	}
	if (_tmp13_) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp17_ = name;
		_tmp18_ = guarded_markup_escape_text (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = count_text;
		_tmp21_ = guarded_markup_escape_text (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp19_, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		result = _tmp24_;
		_g_free0 (name);
		_g_free0 (daterange);
		_g_free0 (count_text);
		return result;
	} else {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp25_ = name;
		_tmp26_ = guarded_markup_escape_text (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = count_text;
		_tmp29_ = guarded_markup_escape_text (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = daterange;
		_tmp32_ = guarded_markup_escape_text (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strdup_printf ("<b>%s</b>\n%s\n%s", _tmp27_, _tmp30_, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp27_);
		result = _tmp35_;
		_g_free0 (name);
		_g_free0 (daterange);
		_g_free0 (count_text);
		return result;
	}
}

static void
event_directory_item_real_exposed (CheckerboardItem* base)
{
	EventDirectoryItem * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	if (checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
		return;
	}
	{
		GdkPixbuf* _tmp0_ = NULL;
		Event* _tmp1_;
		MediaSource* _tmp2_;
		MediaSource* _tmp3_;
		GdkRectangle _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp1_ = self->event;
		_tmp2_ = event_get_primary_source (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->paul_lynde;
		_tmp5_ = event_directory_item_get_paul_lynde (_tmp3_, &_tmp4_, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_tmp0_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		Event* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = self->event;
		_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
		_tmp9_ = _tmp8_;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_critical ("EventDirectoryItem.vala:123: Unable to fetch preview for %s: %s", _tmp9_, _tmp11_);
		_g_free0 (_tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	event_directory_item_update_comment (self, FALSE);
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
event_directory_item_real_unexposed (CheckerboardItem* base)
{
	EventDirectoryItem * self;
	GdkRectangle _tmp0_;
	Dimensions _tmp1_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	if (!checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
		return;
	}
	_tmp0_ = self->priv->paul_lynde;
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp1_);
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
event_directory_item_on_events_altered (EventDirectoryItem* self,
                                        GeeMap* map)
{
	Event* _tmp0_;
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	event_directory_item_update_comment (self, FALSE);
	_tmp0_ = self->event;
	if (gee_map_has_key (map, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject))) {
		Event* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->event;
		_tmp2_ = event_directory_item_get_formatted_title (_tmp1_);
		_tmp3_ = _tmp2_;
		checkerboard_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp3_, TRUE, PANGO_ALIGN_CENTER);
		_g_free0 (_tmp3_);
	}
}

static void
event_directory_item_real_thumbnail_altered (ThumbnailView* base)
{
	EventDirectoryItem * self;
	MediaSource* media = NULL;
	Event* _tmp0_;
	MediaSource* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	_tmp0_ = self->event;
	_tmp1_ = event_get_primary_source (_tmp0_);
	media = _tmp1_;
	event_directory_item_set_paul_lynde (self, media);
	_g_object_unref0 (media);
}

static void
event_directory_item_set_paul_lynde (EventDirectoryItem* self,
                                     MediaSource* media)
{
	GdkRectangle _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
	g_return_if_fail (IS_MEDIA_SOURCE (media));
	event_directory_item_get_paul_lynde_rect (media, &_tmp0_);
	self->priv->paul_lynde = _tmp0_;
	if (checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
		{
			GdkPixbuf* _tmp1_ = NULL;
			GdkRectangle _tmp2_;
			GdkPixbuf* _tmp3_;
			_tmp2_ = self->priv->paul_lynde;
			_tmp3_ = event_directory_item_get_paul_lynde (media, &_tmp2_, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp1_);
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			Event* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = self->event;
			_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
			_tmp6_ = _tmp5_;
			_tmp7_ = err;
			_tmp8_ = _tmp7_->message;
			g_critical ("EventDirectoryItem.vala:160: Unable to fetch preview for %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GdkRectangle _tmp9_;
		Dimensions _tmp10_ = {0};
		_tmp9_ = self->priv->paul_lynde;
		dimensions_for_rectangle (&_tmp9_, &_tmp10_);
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp10_);
	}
	THUMBNAIL_VIEW_CLASS (event_directory_item_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
}

static void
event_directory_item_real_handle_mouse_leave (CheckerboardItem* base)
{
	EventDirectoryItem * self;
	Event* _tmp0_;
	MediaSource* _tmp1_;
	MediaSource* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->handle_mouse_leave (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
	_tmp0_ = self->event;
	_tmp1_ = event_get_primary_source (_tmp0_);
	_tmp2_ = _tmp1_;
	event_directory_item_set_paul_lynde (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
event_directory_item_real_handle_mouse_motion (CheckerboardItem* base,
                                               gint x,
                                               gint y,
                                               gint height,
                                               gint width)
{
	EventDirectoryItem * self;
	gint steppedX = 0;
	gint element_index = 0;
	Event* _tmp0_;
	MediaSource* media = NULL;
	Event* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_;
	MediaSource** _tmp6_;
	gint _tmp6__length1;
	MediaSource* _tmp7_;
	MediaSource* _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	steppedX = x - (x % 15);
	_tmp0_ = self->event;
	element_index = (gint) round ((((gdouble) steppedX) / width) * (event_source_get_media_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT_SOURCE, EventSource)) - 1));
	_tmp1_ = self->event;
	_tmp2_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_EVENT_SOURCE, EventSource));
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = _tmp6_[element_index];
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp3_);
	media = _tmp8_;
	event_directory_item_set_paul_lynde (self, media);
}

static void
event_directory_item_real_paint_shadow (CheckerboardItem* base,
                                        cairo_t* ctx,
                                        Dimensions* dimensions,
                                        GdkPoint* origin,
                                        gint radius,
                                        gfloat initial_alpha)
{
	EventDirectoryItem * self;
	Dimensions altered = {0};
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	Dimensions _tmp2_;
	GdkPoint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (dimensions != NULL);
	g_return_if_fail (origin != NULL);
	_tmp0_ = *dimensions;
	_tmp1_ = *dimensions;
	dimensions_init (&altered, _tmp0_.width - 25, _tmp1_.height - 25);
	_tmp2_ = altered;
	_tmp3_ = *origin;
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->paint_shadow (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), ctx, &_tmp2_, &_tmp3_, 36, initial_alpha);
}

static void
event_directory_item_real_paint_border (CheckerboardItem* base,
                                        cairo_t* ctx,
                                        Dimensions* object_dimensions,
                                        GdkPoint* object_origin,
                                        gint border_width)
{
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	Dimensions _tmp0_;
	Dimensions _tmp1_ = {0};
	GdkPoint origin = {0};
	GdkPoint _tmp2_;
	GdkPoint _tmp3_ = {0};
	Dimensions _tmp4_;
	GdkPoint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (object_dimensions != NULL);
	g_return_if_fail (object_origin != NULL);
	_tmp0_ = *object_dimensions;
	checkerboard_item_get_border_dimensions (&_tmp0_, border_width, &_tmp1_);
	dimensions = _tmp1_;
	_tmp2_ = *object_origin;
	checkerboard_item_get_border_origin (&_tmp2_, border_width, &_tmp3_);
	origin = _tmp3_;
	_tmp4_ = dimensions;
	_tmp5_ = origin;
	draw_rounded_corners_filled (ctx, &_tmp4_, &_tmp5_, 6.0);
}

static void
event_directory_item_real_paint_image (CheckerboardItem* base,
                                       cairo_t* ctx,
                                       GdkPixbuf* pixbuf,
                                       GdkPoint* origin)
{
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp3_;
	GdkPoint _tmp4_;
	GdkPoint _tmp5_;
	GdkPoint _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	g_return_if_fail (origin != NULL);
	dimensions_for_pixbuf (pixbuf, &_tmp0_);
	dimensions = _tmp0_;
	if (gdk_pixbuf_get_has_alpha (pixbuf)) {
		Dimensions _tmp1_;
		GdkPoint _tmp2_;
		_tmp1_ = dimensions;
		_tmp2_ = *origin;
		draw_rounded_corners_filled (ctx, &_tmp1_, &_tmp2_, 6.0);
	}
	_tmp3_ = dimensions;
	_tmp4_ = *origin;
	context_rounded_corners (ctx, &_tmp3_, &_tmp4_, 6.0);
	_tmp5_ = *origin;
	_tmp6_ = *origin;
	gdk_cairo_set_source_pixbuf (ctx, pixbuf, (gdouble) _tmp5_.x, (gdouble) _tmp6_.y);
	cairo_paint (ctx);
}

static void
event_directory_item_update_comment (EventDirectoryItem* self,
                                     gboolean init)
{
	gchar* comment = NULL;
	Event* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
	_tmp0_ = self->event;
	_tmp1_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT_SOURCE, EventSource));
	comment = _tmp1_;
	_tmp2_ = comment;
	if (is_string_empty (_tmp2_)) {
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
	} else {
		if (!init) {
			const gchar* _tmp3_;
			_tmp3_ = comment;
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp3_, FALSE, PANGO_ALIGN_LEFT);
		} else {
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), "", FALSE, PANGO_ALIGN_LEFT);
		}
	}
	_g_free0 (comment);
}

static gint
event_directory_item_get_CROPPED_SCALE (void)
{
	gint result;
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM) + ((thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_BIG) - thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM)) / 2);
	return result;
}

static void
event_directory_item_class_init (EventDirectoryItemClass * klass,
                                 gpointer klass_data)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	Scaling _tmp5_ = {0};
	event_directory_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EventDirectoryItem_private_offset);
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem*)) event_directory_item_real_exposed;
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem*)) event_directory_item_real_unexposed;
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView*)) event_directory_item_real_thumbnail_altered;
	((CheckerboardItemClass *) klass)->handle_mouse_leave = (void (*) (CheckerboardItem*)) event_directory_item_real_handle_mouse_leave;
	((CheckerboardItemClass *) klass)->handle_mouse_motion = (void (*) (CheckerboardItem*, gint, gint, gint, gint)) event_directory_item_real_handle_mouse_motion;
	((CheckerboardItemClass *) klass)->paint_shadow = (void (*) (CheckerboardItem*, cairo_t*, Dimensions*, GdkPoint*, gint, gfloat)) event_directory_item_real_paint_shadow;
	((CheckerboardItemClass *) klass)->paint_border = (void (*) (CheckerboardItem*, cairo_t*, Dimensions*, GdkPoint*, gint)) event_directory_item_real_paint_border;
	((CheckerboardItemClass *) klass)->paint_image = (void (*) (CheckerboardItem*, cairo_t*, GdkPixbuf*, GdkPoint*)) event_directory_item_real_paint_image;
	G_OBJECT_CLASS (klass)->get_property = _vala_event_directory_item_get_property;
	G_OBJECT_CLASS (klass)->finalize = event_directory_item_finalize;
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp1_ = _tmp0_;
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp3_ = _tmp2_;
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
	scaling_to_fill_viewport (&_tmp4_, &_tmp5_);
	event_directory_item_squared_scaling = _tmp5_;
}

static void
event_directory_item_instance_init (EventDirectoryItem * self,
                                    gpointer klass)
{
	self->priv = event_directory_item_get_instance_private (self);
	memset (&self->priv->paul_lynde, 0, sizeof (GdkRectangle));
}

static void
event_directory_item_finalize (GObject * obj)
{
	EventDirectoryItem * self;
	EventSourceCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	_tmp0_ = event_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self);
	_g_object_unref0 (self->event);
	G_OBJECT_CLASS (event_directory_item_parent_class)->finalize (obj);
}

static GType
event_directory_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventDirectoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_directory_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventDirectoryItem), 0, (GInstanceInitFunc) event_directory_item_instance_init, NULL };
	GType event_directory_item_type_id;
	event_directory_item_type_id = g_type_register_static (TYPE_CHECKERBOARD_ITEM, "EventDirectoryItem", &g_define_type_info, 0);
	EventDirectoryItem_private_offset = g_type_add_instance_private (event_directory_item_type_id, sizeof (EventDirectoryItemPrivate));
	return event_directory_item_type_id;
}

GType
event_directory_item_get_type (void)
{
	static volatile gsize event_directory_item_type_id__once = 0;
	if (g_once_init_enter (&event_directory_item_type_id__once)) {
		GType event_directory_item_type_id;
		event_directory_item_type_id = event_directory_item_get_type_once ();
		g_once_init_leave (&event_directory_item_type_id__once, event_directory_item_type_id);
	}
	return event_directory_item_type_id__once;
}

static void
_vala_event_directory_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	EventDirectoryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

