/* SourceCollection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define SOURCE_COLLECTION_TYPE_DESTROY_COUNTER (source_collection_destroy_counter_get_type ())
#define SOURCE_COLLECTION_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter))
#define SOURCE_COLLECTION_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_DESTROY_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))

typedef struct _SourceCollectionDestroyCounter SourceCollectionDestroyCounter;
typedef struct _SourceCollectionDestroyCounterClass SourceCollectionDestroyCounterClass;
typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, gpointer user_data);
typedef struct _SourceCollectionDestroyCounterPrivate SourceCollectionDestroyCounterPrivate;
enum  {
	SOURCE_COLLECTION_DESTROY_COUNTER_0_PROPERTY,
	SOURCE_COLLECTION_DESTROY_COUNTER_NUM_PROPERTIES
};
static GParamSpec* source_collection_destroy_counter_properties[SOURCE_COLLECTION_DESTROY_COUNTER_NUM_PROPERTIES];
enum  {
	SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL,
	SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL,
	SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL,
	SOURCE_COLLECTION_NUM_SIGNALS
};
static guint source_collection_signals[SOURCE_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _SourceCollectionPrivate {
	GeeMultiMap* backlinks;
};

struct _SourceCollectionDestroyCounter {
	GObject parent_instance;
	SourceCollectionDestroyCounterPrivate * priv;
	Marker* remove_marker;
	GeeArrayList* notify_list;
	GeeArrayList* not_removed;
};

struct _SourceCollectionDestroyCounterClass {
	GObjectClass parent_class;
};

static gint SourceCollection_private_offset;
static gpointer source_collection_parent_class = NULL;
static gpointer source_collection_destroy_counter_parent_class = NULL;

VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN gboolean source_collection_holds_type_of_source (SourceCollection* self,
                                                 DataSource* source);
VALA_EXTERN void source_collection_notify_items_unlinking (SourceCollection* self,
                                               GeeCollection* unlinking);
VALA_EXTERN void source_collection_notify_items_relinked (SourceCollection* self,
                                              GeeCollection* relinked);
VALA_EXTERN void source_collection_notify_item_destroyed (SourceCollection* self,
                                              DataSource* source);
VALA_EXTERN void source_collection_notify_items_destroyed (SourceCollection* self,
                                               GeeCollection* destroyed);
VALA_EXTERN void source_collection_notify_unlinked_destroyed (SourceCollection* self,
                                                  DataSource* unlinked);
VALA_EXTERN void source_collection_notify_backlink_removed (SourceCollection* self,
                                                SourceBacklink* backlink,
                                                GeeCollection* sources);
VALA_EXTERN gboolean data_collection_valid_type (DataCollection* self,
                                     DataObject* object);
VALA_EXTERN gboolean source_collection_has_backlink (SourceCollection* self,
                                         SourceBacklink* backlink);
VALA_EXTERN void source_collection_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink);
VALA_EXTERN SourceCollection* source_collection_construct (GType object_type,
                                               const gchar* name);
VALA_EXTERN DataCollection* data_collection_new (const gchar* name);
VALA_EXTERN DataCollection* data_collection_construct (GType object_type,
                                           const gchar* name);
static gboolean source_collection_real_holds_type_of_source (SourceCollection* self,
                                                      DataSource* source);
static void source_collection_real_notify_items_unlinking (SourceCollection* self,
                                                    GeeCollection* unlinking);
static void source_collection_real_notify_items_relinked (SourceCollection* self,
                                                   GeeCollection* relinked);
static void source_collection_real_notify_item_destroyed (SourceCollection* self,
                                                   DataSource* source);
static void source_collection_real_notify_items_destroyed (SourceCollection* self,
                                                    GeeCollection* destroyed);
static void source_collection_real_notify_unlinked_destroyed (SourceCollection* self,
                                                       DataSource* unlinked);
static void source_collection_real_notify_backlink_removed (SourceCollection* self,
                                                     SourceBacklink* backlink,
                                                     GeeCollection* sources);
static gboolean source_collection_real_valid_type (DataCollection* base,
                                            DataObject* object);
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN gint source_collection_destroy_marked (SourceCollection* self,
                                       Marker* marker,
                                       gboolean delete_backing,
                                       ProgressMonitor monitor,
                                       gpointer monitor_target,
                                       GeeList* not_removed);
static GType source_collection_destroy_counter_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollectionDestroyCounter, g_object_unref)
VALA_EXTERN Marker* data_collection_start_marking (DataCollection* self);
static SourceCollectionDestroyCounter* source_collection_destroy_counter_new (Marker* remove_marker);
static SourceCollectionDestroyCounter* source_collection_destroy_counter_construct (GType object_type,
                                                                             Marker* remove_marker);
VALA_EXTERN void data_collection_act_on_marked (DataCollection* self,
                                    Marker* m,
                                    MarkedAction action,
                                    gpointer action_target,
                                    ProgressMonitor monitor,
                                    gpointer monitor_target,
                                    GObject* user);
static gboolean source_collection_destroy_and_delete_source (SourceCollection* self,
                                                      DataObject* object,
                                                      GObject* user);
static gboolean _source_collection_destroy_and_delete_source_marked_action (DataObject* object,
                                                                     GObject* user,
                                                                     gpointer self);
static gboolean source_collection_destroy_source (SourceCollection* self,
                                           DataObject* object,
                                           GObject* user);
static gboolean _source_collection_destroy_source_marked_action (DataObject* object,
                                                          GObject* user,
                                                          gpointer self);
VALA_EXTERN void data_collection_remove_marked (DataCollection* self,
                                    Marker* m);
VALA_EXTERN gboolean data_source_internal_delete_backing (DataSource* self,
                                              GError** error);
VALA_EXTERN void data_source_internal_mark_for_destroy (DataSource* self);
VALA_EXTERN void data_source_destroy (DataSource* self);
VALA_EXTERN void marker_mark (Marker* self,
                  DataObject* object);
VALA_EXTERN void source_collection_internal_backlink_set (SourceCollection* self,
                                              DataSource* source,
                                              SourceBacklink* backlink);
VALA_EXTERN guint source_backlink_hash_func (SourceBacklink* backlink);
static guint _source_backlink_hash_func_gee_hash_data_func (gconstpointer v,
                                                     gpointer self);
VALA_EXTERN gboolean source_backlink_equal_func (SourceBacklink* alink,
                                     SourceBacklink* blink);
static gboolean _source_backlink_equal_func_gee_equal_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self);
VALA_EXTERN void source_collection_internal_backlink_removed (SourceCollection* self,
                                                  DataSource* source,
                                                  SourceBacklink* backlink);
static gboolean source_collection_real_has_backlink (SourceCollection* self,
                                              SourceBacklink* backlink);
VALA_EXTERN GeeCollection* source_collection_unlink_marked (SourceCollection* self,
                                                Marker* marker,
                                                ProgressMonitor monitor,
                                                gpointer monitor_target);
static gboolean source_collection_prepare_for_unlink (SourceCollection* self,
                                               DataObject* object,
                                               GObject* user);
static gboolean _source_collection_prepare_for_unlink_marked_action (DataObject* object,
                                                              GObject* user,
                                                              gpointer self);
VALA_EXTERN Marker* data_collection_mark_many (DataCollection* self,
                                   GeeCollection* objects);
VALA_EXTERN void data_source_notify_unlinking (DataSource* self,
                                   SourceCollection* collection);
VALA_EXTERN void source_collection_relink (SourceCollection* self,
                               DataSource* source);
VALA_EXTERN void data_source_notify_relinking (DataSource* self,
                                   SourceCollection* collection);
VALA_EXTERN gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
VALA_EXTERN GeeCollection* data_collection_get_singleton (DataObject* object);
VALA_EXTERN void data_source_notify_relinked (DataSource* self);
VALA_EXTERN void source_collection_relink_many (SourceCollection* self,
                                    GeeCollection* relink);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
static void source_collection_real_remove_backlink (SourceCollection* self,
                                             SourceBacklink* backlink);
VALA_EXTERN gboolean data_source_remove_backlink (DataSource* self,
                                      SourceBacklink* backlink);
static void source_collection_real_items_unlinking (SourceCollection* self,
                                             GeeCollection* unlinking);
static void source_collection_real_items_relinked (SourceCollection* self,
                                            GeeCollection* relinked);
static void source_collection_real_item_destroyed (SourceCollection* self,
                                            DataSource* source);
static void source_collection_real_items_destroyed (SourceCollection* self,
                                             GeeCollection* destroyed);
static void source_collection_real_unlinked_destroyed (SourceCollection* self,
                                                DataSource* source);
static void source_collection_real_backlink_removed (SourceCollection* self,
                                              SourceBacklink* backlink,
                                              GeeCollection* sources);
static void g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void source_collection_destroy_counter_finalize (GObject * obj);
static GType source_collection_destroy_counter_get_type_once (void);
static void source_collection_finalize (DataCollection * obj);
static GType source_collection_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
source_collection_get_instance_private (SourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, SourceCollection_private_offset);
}

SourceCollection*
source_collection_construct (GType object_type,
                             const gchar* name)
{
	SourceCollection* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SourceCollection*) data_collection_construct (object_type, name);
	return self;
}

static gboolean
source_collection_real_holds_type_of_source (SourceCollection* self,
                                             DataSource* source)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `source_collection_holds_type_of_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
source_collection_holds_type_of_source (SourceCollection* self,
                                        DataSource* source)
{
	SourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->holds_type_of_source) {
		return _klass_->holds_type_of_source (self, source);
	}
	return FALSE;
}

static void
source_collection_real_notify_items_unlinking (SourceCollection* self,
                                               GeeCollection* unlinking)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unlinking, GEE_TYPE_COLLECTION));
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL], 0, unlinking);
}

void
source_collection_notify_items_unlinking (SourceCollection* self,
                                          GeeCollection* unlinking)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_unlinking) {
		_klass_->notify_items_unlinking (self, unlinking);
	}
}

static void
source_collection_real_notify_items_relinked (SourceCollection* self,
                                              GeeCollection* relinked)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (relinked, GEE_TYPE_COLLECTION));
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL], 0, relinked);
}

void
source_collection_notify_items_relinked (SourceCollection* self,
                                         GeeCollection* relinked)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_relinked) {
		_klass_->notify_items_relinked (self, relinked);
	}
}

static void
source_collection_real_notify_item_destroyed (SourceCollection* self,
                                              DataSource* source)
{
	g_return_if_fail (IS_DATA_SOURCE (source));
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL], 0, source);
}

void
source_collection_notify_item_destroyed (SourceCollection* self,
                                         DataSource* source)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_item_destroyed) {
		_klass_->notify_item_destroyed (self, source);
	}
}

static void
source_collection_real_notify_items_destroyed (SourceCollection* self,
                                               GeeCollection* destroyed)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destroyed, GEE_TYPE_COLLECTION));
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL], 0, destroyed);
}

void
source_collection_notify_items_destroyed (SourceCollection* self,
                                          GeeCollection* destroyed)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_destroyed) {
		_klass_->notify_items_destroyed (self, destroyed);
	}
}

static void
source_collection_real_notify_unlinked_destroyed (SourceCollection* self,
                                                  DataSource* unlinked)
{
	g_return_if_fail (IS_DATA_SOURCE (unlinked));
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL], 0, unlinked);
}

void
source_collection_notify_unlinked_destroyed (SourceCollection* self,
                                             DataSource* unlinked)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_unlinked_destroyed) {
		_klass_->notify_unlinked_destroyed (self, unlinked);
	}
}

static void
source_collection_real_notify_backlink_removed (SourceCollection* self,
                                                SourceBacklink* backlink,
                                                GeeCollection* sources)
{
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL], 0, backlink, sources);
}

void
source_collection_notify_backlink_removed (SourceCollection* self,
                                           SourceBacklink* backlink,
                                           GeeCollection* sources)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_backlink_removed) {
		_klass_->notify_backlink_removed (self, backlink, sources);
	}
}

static gboolean
source_collection_real_valid_type (DataCollection* base,
                                   DataObject* object)
{
	SourceCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SOURCE_COLLECTION, SourceCollection);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	result = IS_DATA_SOURCE (object);
	return result;
}

static gboolean
_source_collection_destroy_and_delete_source_marked_action (DataObject* object,
                                                            GObject* user,
                                                            gpointer self)
{
	gboolean result;
	result = source_collection_destroy_and_delete_source ((SourceCollection*) self, object, user);
	return result;
}

static gboolean
_source_collection_destroy_source_marked_action (DataObject* object,
                                                 GObject* user,
                                                 gpointer self)
{
	gboolean result;
	result = source_collection_destroy_source ((SourceCollection*) self, object, user);
	return result;
}

gint
source_collection_destroy_marked (SourceCollection* self,
                                  Marker* marker,
                                  gboolean delete_backing,
                                  ProgressMonitor monitor,
                                  gpointer monitor_target,
                                  GeeList* not_removed)
{
	SourceCollectionDestroyCounter* counter = NULL;
	Marker* _tmp0_;
	Marker* _tmp1_;
	SourceCollectionDestroyCounter* _tmp2_;
	SourceCollectionDestroyCounter* _tmp3_;
	SourceCollectionDestroyCounter* _tmp16_;
	GeeArrayList* _tmp17_;
	SourceCollectionDestroyCounter* _tmp18_;
	Marker* _tmp19_;
	SourceCollectionDestroyCounter* _tmp22_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint result;
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), 0);
	g_return_val_if_fail (IS_MARKER (marker), 0);
	g_return_val_if_fail ((not_removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (not_removed, GEE_TYPE_LIST), 0);
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = source_collection_destroy_counter_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	counter = _tmp3_;
	if (delete_backing) {
		SourceCollectionDestroyCounter* _tmp4_;
		_tmp4_ = counter;
		data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _source_collection_destroy_and_delete_source_marked_action, self, monitor, monitor_target, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject));
	} else {
		SourceCollectionDestroyCounter* _tmp5_;
		_tmp5_ = counter;
		data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _source_collection_destroy_source_marked_action, self, monitor, monitor_target, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject));
	}
	{
		GeeArrayList* _source_list = NULL;
		SourceCollectionDestroyCounter* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _source_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _source_index = 0;
		_tmp6_ = counter;
		_tmp7_ = _tmp6_->notify_list;
		_source_list = _tmp7_;
		_tmp8_ = _source_list;
		_tmp9_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp10_ = _tmp9_;
		_source_size = _tmp10_;
		_source_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			DataSource* source = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			DataSource* _tmp15_;
			_source_index = _source_index + 1;
			_tmp11_ = _source_index;
			_tmp12_ = _source_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _source_list;
			_tmp14_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _source_index);
			source = (DataSource*) _tmp14_;
			_tmp15_ = source;
			source_collection_notify_item_destroyed (self, _tmp15_);
			_g_object_unref0 (source);
		}
	}
	_tmp16_ = counter;
	_tmp17_ = _tmp16_->notify_list;
	source_collection_notify_items_destroyed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp18_ = counter;
	_tmp19_ = _tmp18_->remove_marker;
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp19_);
	if (NULL != not_removed) {
		SourceCollectionDestroyCounter* _tmp20_;
		GeeArrayList* _tmp21_;
		_tmp20_ = counter;
		_tmp21_ = _tmp20_->not_removed;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (not_removed, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_tmp22_ = counter;
	_tmp23_ = _tmp22_->not_removed;
	_tmp24_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp25_ = _tmp24_;
	result = _tmp25_;
	_g_object_unref0 (counter);
	return result;
}

static gboolean
source_collection_destroy_and_delete_source (SourceCollection* self,
                                             DataObject* object,
                                             GObject* user)
{
	gboolean success = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, G_TYPE_OBJECT), FALSE);
	success = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = data_source_internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		success = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		success = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
	if (!success) {
		_tmp2_ = IS_MEDIA_SOURCE (object);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GeeArrayList* _tmp3_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->not_removed;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_SOURCE, MediaSource));
	}
	if (source_collection_destroy_source (self, object, user)) {
		_tmp4_ = success;
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
source_collection_destroy_source (SourceCollection* self,
                                  DataObject* object,
                                  GObject* user)
{
	DataSource* source = NULL;
	DataSource* _tmp0_;
	Marker* _tmp1_;
	GeeArrayList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, G_TYPE_OBJECT), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource));
	source = _tmp0_;
	data_source_internal_mark_for_destroy (source);
	data_source_destroy (source);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->remove_marker;
	marker_mark (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->notify_list;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), source);
	result = TRUE;
	_g_object_unref0 (source);
	return result;
}

static guint
_source_backlink_hash_func_gee_hash_data_func (gconstpointer v,
                                               gpointer self)
{
	guint result;
	result = source_backlink_hash_func ((SourceBacklink*) v);
	return result;
}

static gboolean
_source_backlink_equal_func_gee_equal_data_func (gconstpointer a,
                                                 gconstpointer b,
                                                 gpointer self)
{
	gboolean result;
	result = source_backlink_equal_func ((SourceBacklink*) a, (SourceBacklink*) b);
	return result;
}

void
source_collection_internal_backlink_set (SourceCollection* self,
                                         DataSource* source,
                                         SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp2_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_DATA_SOURCE (source));
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
	_tmp0_ = self->priv->backlinks;
	if (_tmp0_ == NULL) {
		GeeHashMultiMap* _tmp1_;
		_tmp1_ = gee_hash_multi_map_new (TYPE_SOURCE_BACKLINK, (GBoxedCopyFunc) source_backlink_ref, (GDestroyNotify) source_backlink_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _source_backlink_hash_func_gee_hash_data_func, NULL, NULL, _source_backlink_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->backlinks);
		self->priv->backlinks = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	}
	_tmp2_ = self->priv->backlinks;
	gee_multi_map_set (_tmp2_, backlink, source);
}

void
source_collection_internal_backlink_removed (SourceCollection* self,
                                             DataSource* source,
                                             SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	gboolean removed = FALSE;
	GeeMultiMap* _tmp1_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_DATA_SOURCE (source));
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
	_tmp0_ = self->priv->backlinks;
	_vala_assert (_tmp0_ != NULL, "backlinks != null");
	_tmp1_ = self->priv->backlinks;
	removed = gee_multi_map_remove (_tmp1_, backlink, source);
	_vala_assert (removed, "removed");
}

static gboolean
source_collection_real_has_backlink (SourceCollection* self,
                                     SourceBacklink* backlink)
{
	gboolean _tmp0_ = FALSE;
	GeeMultiMap* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
	_tmp1_ = self->priv->backlinks;
	if (_tmp1_ != NULL) {
		GeeMultiMap* _tmp2_;
		_tmp2_ = self->priv->backlinks;
		_tmp0_ = gee_multi_map_contains (_tmp2_, backlink);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
source_collection_has_backlink (SourceCollection* self,
                                SourceBacklink* backlink)
{
	SourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->has_backlink) {
		return _klass_->has_backlink (self, backlink);
	}
	return FALSE;
}

static gboolean
_source_collection_prepare_for_unlink_marked_action (DataObject* object,
                                                     GObject* user,
                                                     gpointer self)
{
	gboolean result;
	result = source_collection_prepare_for_unlink ((SourceCollection*) self, object, user);
	return result;
}

GeeCollection*
source_collection_unlink_marked (SourceCollection* self,
                                 Marker* marker,
                                 ProgressMonitor monitor,
                                 gpointer monitor_target)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	Marker* _tmp7_;
	Marker* _tmp8_;
	GeeCollection* result;
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (IS_MARKER (marker), NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = list;
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _source_collection_prepare_for_unlink_marked_action, self, monitor, monitor_target, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
	_tmp2_ = list;
	_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = NULL;
		_g_object_unref0 (list);
		return result;
	}
	_tmp5_ = list;
	source_collection_notify_items_unlinking (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp6_ = list;
	_tmp7_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp8_ = _tmp7_;
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp8_);
	_g_object_unref0 (_tmp8_);
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

static gboolean
source_collection_prepare_for_unlink (SourceCollection* self,
                                      DataObject* object,
                                      GObject* user)
{
	DataSource* source = NULL;
	DataSource* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, G_TYPE_OBJECT), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource));
	source = _tmp0_;
	data_source_notify_unlinking (source, self);
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (user, GEE_TYPE_LIST, GeeList), GEE_TYPE_COLLECTION, GeeCollection), source);
	result = TRUE;
	_g_object_unref0 (source);
	return result;
}

void
source_collection_relink (SourceCollection* self,
                          DataSource* source)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_DATA_SOURCE (source));
	data_source_notify_relinking (source, self);
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
	_tmp0_ = data_collection_get_singleton (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	source_collection_notify_items_relinked (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	data_source_notify_relinked (source);
}

void
source_collection_relink_many (SourceCollection* self,
                               GeeCollection* relink)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (relink, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_collection_get_size (relink);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (relink, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataSource* _tmp6_;
			_tmp3_ = _source_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _source_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			source = (DataSource*) _tmp5_;
			_tmp6_ = source;
			data_source_notify_relinking (_tmp6_, self);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp7_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), relink, NULL, NULL);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	source_collection_notify_items_relinked (self, relink);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp9_;
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (relink, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataSource* source = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataSource* _tmp13_;
			_tmp10_ = _source_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _source_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			source = (DataSource*) _tmp12_;
			_tmp13_ = source;
			data_source_notify_relinked (_tmp13_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
source_collection_real_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	GeeArrayList* sources = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeArrayList* _tmp15_;
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
	_tmp0_ = self->priv->backlinks;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	sources = _tmp1_;
	_tmp2_ = sources;
	_tmp3_ = self->priv->backlinks;
	_tmp4_ = gee_multi_map_get (_tmp3_, backlink);
	_tmp5_ = _tmp4_;
	gee_array_list_add_all (_tmp2_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		GeeArrayList* _source_list = NULL;
		GeeArrayList* _tmp6_;
		gint _source_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _source_index = 0;
		_tmp6_ = sources;
		_source_list = _tmp6_;
		_tmp7_ = _source_list;
		_tmp8_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp9_ = _tmp8_;
		_source_size = _tmp9_;
		_source_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			DataSource* source = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			DataSource* _tmp14_;
			_source_index = _source_index + 1;
			_tmp10_ = _source_index;
			_tmp11_ = _source_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _source_list;
			_tmp13_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _source_index);
			source = (DataSource*) _tmp13_;
			_tmp14_ = source;
			data_source_remove_backlink (_tmp14_, backlink);
			_g_object_unref0 (source);
		}
	}
	_tmp15_ = sources;
	source_collection_notify_backlink_removed (self, backlink, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (sources);
}

void
source_collection_remove_backlink (SourceCollection* self,
                                   SourceBacklink* backlink)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->remove_backlink) {
		_klass_->remove_backlink (self, backlink);
	}
}

static void
source_collection_real_items_unlinking (SourceCollection* self,
                                        GeeCollection* unlinking)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unlinking, GEE_TYPE_COLLECTION));
}

static void
source_collection_real_items_relinked (SourceCollection* self,
                                       GeeCollection* relinked)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (relinked, GEE_TYPE_COLLECTION));
}

static void
source_collection_real_item_destroyed (SourceCollection* self,
                                       DataSource* source)
{
	g_return_if_fail (IS_DATA_SOURCE (source));
}

static void
source_collection_real_items_destroyed (SourceCollection* self,
                                        GeeCollection* destroyed)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destroyed, GEE_TYPE_COLLECTION));
}

static void
source_collection_real_unlinked_destroyed (SourceCollection* self,
                                           DataSource* source)
{
	g_return_if_fail (IS_DATA_SOURCE (source));
}

static void
source_collection_real_backlink_removed (SourceCollection* self,
                                         SourceBacklink* backlink,
                                         GeeCollection* sources)
{
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
}

static void
g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_source_backlink (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static SourceCollectionDestroyCounter*
source_collection_destroy_counter_construct (GType object_type,
                                             Marker* remove_marker)
{
	SourceCollectionDestroyCounter * self = NULL;
	Marker* _tmp0_;
	g_return_val_if_fail (IS_MARKER (remove_marker), NULL);
	self = (SourceCollectionDestroyCounter*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (remove_marker);
	_g_object_unref0 (self->remove_marker);
	self->remove_marker = _tmp0_;
	return self;
}

static SourceCollectionDestroyCounter*
source_collection_destroy_counter_new (Marker* remove_marker)
{
	return source_collection_destroy_counter_construct (SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, remove_marker);
}

static void
source_collection_destroy_counter_class_init (SourceCollectionDestroyCounterClass * klass,
                                              gpointer klass_data)
{
	source_collection_destroy_counter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = source_collection_destroy_counter_finalize;
}

static void
source_collection_destroy_counter_instance_init (SourceCollectionDestroyCounter * self,
                                                 gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->notify_list = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->not_removed = _tmp1_;
}

static void
source_collection_destroy_counter_finalize (GObject * obj)
{
	SourceCollectionDestroyCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter);
	_g_object_unref0 (self->remove_marker);
	_g_object_unref0 (self->notify_list);
	_g_object_unref0 (self->not_removed);
	G_OBJECT_CLASS (source_collection_destroy_counter_parent_class)->finalize (obj);
}

static GType
source_collection_destroy_counter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionDestroyCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_destroy_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollectionDestroyCounter), 0, (GInstanceInitFunc) source_collection_destroy_counter_instance_init, NULL };
	GType source_collection_destroy_counter_type_id;
	source_collection_destroy_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "SourceCollectionDestroyCounter", &g_define_type_info, 0);
	return source_collection_destroy_counter_type_id;
}

static GType
source_collection_destroy_counter_get_type (void)
{
	static volatile gsize source_collection_destroy_counter_type_id__once = 0;
	if (g_once_init_enter (&source_collection_destroy_counter_type_id__once)) {
		GType source_collection_destroy_counter_type_id;
		source_collection_destroy_counter_type_id = source_collection_destroy_counter_get_type_once ();
		g_once_init_leave (&source_collection_destroy_counter_type_id__once, source_collection_destroy_counter_type_id);
	}
	return source_collection_destroy_counter_type_id__once;
}

static void
source_collection_class_init (SourceCollectionClass * klass,
                              gpointer klass_data)
{
	source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &SourceCollection_private_offset);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) source_collection_real_holds_type_of_source;
	((SourceCollectionClass *) klass)->notify_items_unlinking = (void (*) (SourceCollection*, GeeCollection*)) source_collection_real_notify_items_unlinking;
	((SourceCollectionClass *) klass)->notify_items_relinked = (void (*) (SourceCollection*, GeeCollection*)) source_collection_real_notify_items_relinked;
	((SourceCollectionClass *) klass)->notify_item_destroyed = (void (*) (SourceCollection*, DataSource*)) source_collection_real_notify_item_destroyed;
	((SourceCollectionClass *) klass)->notify_items_destroyed = (void (*) (SourceCollection*, GeeCollection*)) source_collection_real_notify_items_destroyed;
	((SourceCollectionClass *) klass)->notify_unlinked_destroyed = (void (*) (SourceCollection*, DataSource*)) source_collection_real_notify_unlinked_destroyed;
	((SourceCollectionClass *) klass)->notify_backlink_removed = (void (*) (SourceCollection*, SourceBacklink*, GeeCollection*)) source_collection_real_notify_backlink_removed;
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection*, DataObject*)) source_collection_real_valid_type;
	((SourceCollectionClass *) klass)->has_backlink = (gboolean (*) (SourceCollection*, SourceBacklink*)) source_collection_real_has_backlink;
	((SourceCollectionClass *) klass)->remove_backlink = (void (*) (SourceCollection*, SourceBacklink*)) source_collection_real_remove_backlink;
	((SourceCollectionClass *) klass)->items_unlinking = source_collection_real_items_unlinking;
	((SourceCollectionClass *) klass)->items_relinked = source_collection_real_items_relinked;
	((SourceCollectionClass *) klass)->item_destroyed = source_collection_real_item_destroyed;
	((SourceCollectionClass *) klass)->items_destroyed = source_collection_real_items_destroyed;
	((SourceCollectionClass *) klass)->unlinked_destroyed = source_collection_real_unlinked_destroyed;
	((SourceCollectionClass *) klass)->backlink_removed = source_collection_real_backlink_removed;
	source_collection_signals[SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL] = g_signal_new ("items-unlinking", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_unlinking), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	source_collection_signals[SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL] = g_signal_new ("items-relinked", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_relinked), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	source_collection_signals[SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL] = g_signal_new ("item-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, item_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
	source_collection_signals[SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL] = g_signal_new ("items-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	source_collection_signals[SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL] = g_signal_new ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, unlinked_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
	source_collection_signals[SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL] = g_signal_new ("backlink-removed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, backlink_removed), NULL, NULL, g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT, G_TYPE_NONE, 2, TYPE_SOURCE_BACKLINK, GEE_TYPE_COLLECTION);
}

static void
source_collection_instance_init (SourceCollection * self,
                                 gpointer klass)
{
	self->priv = source_collection_get_instance_private (self);
	self->priv->backlinks = NULL;
}

static void
source_collection_finalize (DataCollection * obj)
{
	SourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_COLLECTION, SourceCollection);
	_g_object_unref0 (self->priv->backlinks);
	DATA_COLLECTION_CLASS (source_collection_parent_class)->finalize (obj);
}

static GType
source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollection), 0, (GInstanceInitFunc) source_collection_instance_init, NULL };
	GType source_collection_type_id;
	source_collection_type_id = g_type_register_static (TYPE_DATA_COLLECTION, "SourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SourceCollection_private_offset = g_type_add_instance_private (source_collection_type_id, sizeof (SourceCollectionPrivate));
	return source_collection_type_id;
}

GType
source_collection_get_type (void)
{
	static volatile gsize source_collection_type_id__once = 0;
	if (g_once_init_enter (&source_collection_type_id__once)) {
		GType source_collection_type_id;
		source_collection_type_id = source_collection_get_type_once ();
		g_once_init_leave (&source_collection_type_id__once, source_collection_type_id);
	}
	return source_collection_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

