/* ColorTransformation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ColorTransformation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include "shotwell-graphics-processor.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdio.h>

#define RGB_ANALYTIC_PIXEL_INV_255 (1.0f / 255.0f)
#define HSV_ANALYTIC_PIXEL_INV_255 (1.0f / 255.0f)
#define TINT_TRANSFORMATION_INTENSITY_FACTOR 0.25f
#define TEMPERATURE_TRANSFORMATION_INTENSITY_FACTOR 0.33f
#define CONTRAST_TRANSFORMATION_MAX_CONTRAST_ADJUSTMENT 0.5f
#define RGB_HISTOGRAM_MARKED_BACKGROUND ((guchar) 30)
#define RGB_HISTOGRAM_MARKED_FOREGROUND ((guchar) 210)
#define RGB_HISTOGRAM_UNMARKED_BACKGROUND ((guchar) 120)
#define EXPANSION_TRANSFORMATION_LOW_DISCARD_MASS 0.02f
#define EXPANSION_TRANSFORMATION_HIGH_DISCARD_MASS 0.02f
#define SHADOW_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT 0.5f
#define SHADOW_DETAIL_TRANSFORMATION_MIN_TONAL_WIDTH 0.1f
#define SHADOW_DETAIL_TRANSFORMATION_MAX_TONAL_WIDTH 1.0f
#define SHADOW_DETAIL_TRANSFORMATION_TONAL_WIDTH 1.0f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT 0.5f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_TONAL_WIDTH 0.1f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_TONAL_WIDTH 1.0f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_TONAL_WIDTH 1.0f
#define AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY 8
#define AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY 100
#define AUTO_ENHANCE_SHADOW_DETECT_INTENSITY_RANGE (AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY - AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY)
#define AUTO_ENHANCE_SHADOW_MODE_HIGH_DISCARD_MASS 0.02f
#define AUTO_ENHANCE_SHADOW_AGGRESSIVENESS_MUL 0.4f
#define AUTO_ENHANCE_EMPIRICAL_DARK 30
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPixelTransformationBundle ParamSpecPixelTransformationBundle;
typedef struct _ParamSpecPixelTransformation ParamSpecPixelTransformation;
typedef struct _Block1Data Block1Data;
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _ParamSpecPixelTransformer ParamSpecPixelTransformer;
typedef struct _ParamSpecRGBHistogram ParamSpecRGBHistogram;
typedef struct _ParamSpecIntensityHistogram ParamSpecIntensityHistogram;
#define _hermite_gamma_approximation_function_unref0(var) ((var == NULL) ? NULL : (var = (hermite_gamma_approximation_function_unref (var), NULL)))
typedef struct _ParamSpecHermiteGammaApproximationFunction ParamSpecHermiteGammaApproximationFunction;
#define _intensity_histogram_unref0(var) ((var == NULL) ? NULL : (var = (intensity_histogram_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PixelTransformationBundlePrivate {
	GeeHashMap* map;
};

struct _ParamSpecPixelTransformationBundle {
	GParamSpec parent_instance;
};

struct _PixelTransformationPrivate {
	PixelTransformationType type;
	PixelFormat preferred_format;
};

struct _ParamSpecPixelTransformation {
	GParamSpec parent_instance;
};

struct _TintTransformationPrivate {
	gfloat parameter;
};

struct _TemperatureTransformationPrivate {
	gfloat parameter;
};

struct _SaturationTransformationPrivate {
	gfloat parameter;
};

struct _ExposureTransformationPrivate {
	gfloat parameter;
};

struct _ContrastTransformationPrivate {
	gfloat parameter;
};

struct _PixelTransformerPrivate {
	GeeArrayList* transformations;
};

struct _Block1Data {
	int _ref_count_;
	PixelTransformer* self;
	gint dest_width;
	gint dest_num_channels;
	gint dest_rowstride;
	guchar* dest_pixels;
	gint dest_pixels_length1;
	gint _dest_pixels_size_;
	gfloat* cache;
	gint cache_length1;
	gint _cache_size_;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	guint row;
	guint slice_height;
};

struct _Block3Data {
	int _ref_count_;
	PixelTransformer* self;
	gint n_channels;
	gint rowstride;
	gint rowbytes;
	guchar* source_pixels;
	gint source_pixels_length1;
	gint _source_pixels_size_;
	guchar* dest_pixels;
	gint dest_pixels_length1;
	gint _dest_pixels_size_;
	GCancellable* cancellable;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	guint row;
	guint slice_height;
};

struct _ParamSpecPixelTransformer {
	GParamSpec parent_instance;
};

struct _RGBHistogramPrivate {
	gint* red_counts;
	gint red_counts_length1;
	gint _red_counts_size_;
	gint* green_counts;
	gint green_counts_length1;
	gint _green_counts_size_;
	gint* blue_counts;
	gint blue_counts_length1;
	gint _blue_counts_size_;
	gint* qualitative_red_counts;
	gint qualitative_red_counts_length1;
	gint _qualitative_red_counts_size_;
	gint* qualitative_green_counts;
	gint qualitative_green_counts_length1;
	gint _qualitative_green_counts_size_;
	gint* qualitative_blue_counts;
	gint qualitative_blue_counts_length1;
	gint _qualitative_blue_counts_size_;
	GdkPixbuf* graphic;
};

struct _ParamSpecRGBHistogram {
	GParamSpec parent_instance;
};

struct _IntensityHistogramPrivate {
	gint* counts;
	gint counts_length1;
	gint _counts_size_;
	gfloat* probabilities;
	gint probabilities_length1;
	gint _probabilities_size_;
	gfloat* cumulative_probabilities;
	gint cumulative_probabilities_length1;
	gint _cumulative_probabilities_size_;
};

struct _ParamSpecIntensityHistogram {
	GParamSpec parent_instance;
};

struct _ExpansionTransformationPrivate {
	gint low_kink;
	gint high_kink;
};

struct _ShadowDetailTransformationPrivate {
	gfloat intensity;
};

struct _HermiteGammaApproximationFunctionPrivate {
	gfloat x_scale;
	gfloat nonzero_interval_upper;
};

struct _ParamSpecHermiteGammaApproximationFunction {
	GParamSpec parent_instance;
};

struct _HighlightDetailTransformationPrivate {
	gfloat intensity;
};

static gint PixelTransformationBundle_private_offset;
static gpointer pixel_transformation_bundle_parent_class = NULL;
static PixelTransformationBundle* pixel_transformation_bundle_copied_color_adjustments;
static PixelTransformationBundle* pixel_transformation_bundle_copied_color_adjustments = NULL;
static gint PixelTransformation_private_offset;
static gpointer pixel_transformation_parent_class = NULL;
static gpointer rgb_transformation_parent_class = NULL;
static gpointer hsv_transformation_parent_class = NULL;
static gint TintTransformation_private_offset;
static gpointer tint_transformation_parent_class = NULL;
static gint TemperatureTransformation_private_offset;
static gpointer temperature_transformation_parent_class = NULL;
static gint SaturationTransformation_private_offset;
static gpointer saturation_transformation_parent_class = NULL;
static gint ExposureTransformation_private_offset;
static gpointer exposure_transformation_parent_class = NULL;
static gint ContrastTransformation_private_offset;
static gpointer contrast_transformation_parent_class = NULL;
static gint PixelTransformer_private_offset;
static gpointer pixel_transformer_parent_class = NULL;
static gint RGBHistogram_private_offset;
static gpointer rgb_histogram_parent_class = NULL;
static gint IntensityHistogram_private_offset;
static gpointer intensity_histogram_parent_class = NULL;
static gint ExpansionTransformation_private_offset;
static gpointer expansion_transformation_parent_class = NULL;
static gint ShadowDetailTransformation_private_offset;
static gpointer shadow_detail_transformation_parent_class = NULL;
static gint HermiteGammaApproximationFunction_private_offset;
static gpointer hermite_gamma_approximation_function_parent_class = NULL;
static gint HighlightDetailTransformation_private_offset;
static gpointer highlight_detail_transformation_parent_class = NULL;

static void pixel_transformation_bundle_finalize (PixelTransformationBundle * obj);
static GType pixel_transformation_bundle_get_type_once (void);
static CompositionMode pixel_transformation_real_get_composition_mode (PixelTransformation* self);
static void pixel_transformation_real_compose_with (PixelTransformation* self,
                                             PixelTransformation* other);
static gboolean pixel_transformation_real_is_identity (PixelTransformation* self);
static void pixel_transformation_real_transform_pixel_hsv (PixelTransformation* self,
                                                    HSVAnalyticPixel* p,
                                                    HSVAnalyticPixel* result);
static void pixel_transformation_real_transform_pixel_rgb (PixelTransformation* self,
                                                    RGBAnalyticPixel* p,
                                                    RGBAnalyticPixel* result);
static gchar* pixel_transformation_real_to_string (PixelTransformation* self);
static PixelTransformation* pixel_transformation_real_copy (PixelTransformation* self);
static void pixel_transformation_finalize (PixelTransformation * obj);
static GType pixel_transformation_get_type_once (void);
static CompositionMode rgb_transformation_real_get_composition_mode (PixelTransformation* base);
static void rgb_transformation_real_compose_with (PixelTransformation* base,
                                           PixelTransformation* other);
static void rgb_transformation_real_transform_pixel_hsv (PixelTransformation* base,
                                                  HSVAnalyticPixel* p,
                                                  HSVAnalyticPixel* result);
static void rgb_transformation_real_transform_pixel_rgb (PixelTransformation* base,
                                                  RGBAnalyticPixel* p,
                                                  RGBAnalyticPixel* result);
static gboolean rgb_transformation_real_is_identity (PixelTransformation* base);
static PixelTransformation* rgb_transformation_real_copy (PixelTransformation* base);
static void rgb_transformation_finalize (PixelTransformation * obj);
static GType rgb_transformation_get_type_once (void);
static CompositionMode hsv_transformation_real_get_composition_mode (PixelTransformation* base);
static void hsv_transformation_real_transform_pixel_rgb (PixelTransformation* base,
                                                  RGBAnalyticPixel* p,
                                                  RGBAnalyticPixel* result);
static void hsv_transformation_real_compose_with (PixelTransformation* base,
                                           PixelTransformation* other);
static void hsv_transformation_real_transform_pixel_hsv (PixelTransformation* base,
                                                  HSVAnalyticPixel* pixel,
                                                  HSVAnalyticPixel* result);
static void hsv_transformation_finalize (PixelTransformation * obj);
static GType hsv_transformation_get_type_once (void);
static void tint_transformation_finalize (PixelTransformation * obj);
static GType tint_transformation_get_type_once (void);
static void temperature_transformation_finalize (PixelTransformation * obj);
static GType temperature_transformation_get_type_once (void);
static void saturation_transformation_finalize (PixelTransformation * obj);
static GType saturation_transformation_get_type_once (void);
static void exposure_transformation_finalize (PixelTransformation * obj);
static GType exposure_transformation_get_type_once (void);
static void contrast_transformation_finalize (PixelTransformation * obj);
static GType contrast_transformation_get_type_once (void);
static void pixel_transformer_build_optimized_transformations (PixelTransformer* self);
void pixel_transformer_apply_transformations (PixelTransformer* self,
                                              RGBAnalyticPixel* p,
                                              RGBAnalyticPixel* result);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void* _____lambda5_ (Block2Data* _data2_);
static gpointer ______lambda5__gthread_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void* _____lambda4_ (Block4Data* _data4_);
void pixel_transformer_apply_transformation (PixelTransformer* self,
                                             guint row,
                                             gint rowstride,
                                             gint rowbytes,
                                             gint n_channels,
                                             guchar* source_pixels,
                                             gint source_pixels_length1,
                                             guchar* dest_pixels,
                                             gint dest_pixels_length1);
static gpointer ______lambda4__gthread_func (gpointer self);
static void pixel_transformer_finalize (PixelTransformer * obj);
static GType pixel_transformer_get_type_once (void);
static gint rgb_histogram_correct_snap_to_quantization (RGBHistogram* self,
                                                 gint* buckets,
                                                 gint buckets_length1,
                                                 gint i);
static gint rgb_histogram_correct_snap_from_quantization (RGBHistogram* self,
                                                   gint* buckets,
                                                   gint buckets_length1,
                                                   gint i);
static void rgb_histogram_smooth_extrema (RGBHistogram* self,
                                   gint** count_data,
                                   gint* count_data_length1);
static void rgb_histogram_prepare_qualitative_counts (RGBHistogram* self);
static void rgb_histogram_finalize (RGBHistogram * obj);
static GType rgb_histogram_get_type_once (void);
static void intensity_histogram_finalize (IntensityHistogram * obj);
static GType intensity_histogram_get_type_once (void);
static void expansion_transformation_build_remap_table (ExpansionTransformation* self);
static gchar* expansion_transformation_real_to_string (PixelTransformation* base);
static gboolean expansion_transformation_real_is_identity (PixelTransformation* base);
static PixelTransformation* expansion_transformation_real_copy (PixelTransformation* base);
static void expansion_transformation_finalize (PixelTransformation * obj);
static GType expansion_transformation_get_type_once (void);
static PixelTransformation* shadow_detail_transformation_real_copy (PixelTransformation* base);
static gboolean shadow_detail_transformation_real_is_identity (PixelTransformation* base);
static void shadow_detail_transformation_finalize (PixelTransformation * obj);
static GType shadow_detail_transformation_get_type_once (void);
static void hermite_gamma_approximation_function_finalize (HermiteGammaApproximationFunction * obj);
static GType hermite_gamma_approximation_function_get_type_once (void);
static PixelTransformation* highlight_detail_transformation_real_copy (PixelTransformation* base);
static gboolean highlight_detail_transformation_real_is_identity (PixelTransformation* base);
static void highlight_detail_transformation_finalize (PixelTransformation * obj);
static GType highlight_detail_transformation_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

const gfloat rgb_lookup_table[256] = {0.0f / 255.0f, 1.0f / 255.0f, 2.0f / 255.0f, 3.0f / 255.0f, 4.0f / 255.0f, 5.0f / 255.0f, 6.0f / 255.0f, 7.0f / 255.0f, 8.0f / 255.0f, 9.0f / 255.0f, 10.0f / 255.0f, 11.0f / 255.0f, 12.0f / 255.0f, 13.0f / 255.0f, 14.0f / 255.0f, 15.0f / 255.0f, 16.0f / 255.0f, 17.0f / 255.0f, 18.0f / 255.0f, 19.0f / 255.0f, 20.0f / 255.0f, 21.0f / 255.0f, 22.0f / 255.0f, 23.0f / 255.0f, 24.0f / 255.0f, 25.0f / 255.0f, 26.0f / 255.0f, 27.0f / 255.0f, 28.0f / 255.0f, 29.0f / 255.0f, 30.0f / 255.0f, 31.0f / 255.0f, 32.0f / 255.0f, 33.0f / 255.0f, 34.0f / 255.0f, 35.0f / 255.0f, 36.0f / 255.0f, 37.0f / 255.0f, 38.0f / 255.0f, 39.0f / 255.0f, 40.0f / 255.0f, 41.0f / 255.0f, 42.0f / 255.0f, 43.0f / 255.0f, 44.0f / 255.0f, 45.0f / 255.0f, 46.0f / 255.0f, 47.0f / 255.0f, 48.0f / 255.0f, 49.0f / 255.0f, 50.0f / 255.0f, 51.0f / 255.0f, 52.0f / 255.0f, 53.0f / 255.0f, 54.0f / 255.0f, 55.0f / 255.0f, 56.0f / 255.0f, 57.0f / 255.0f, 58.0f / 255.0f, 59.0f / 255.0f, 60.0f / 255.0f, 61.0f / 255.0f, 62.0f / 255.0f, 63.0f / 255.0f, 64.0f / 255.0f, 65.0f / 255.0f, 66.0f / 255.0f, 67.0f / 255.0f, 68.0f / 255.0f, 69.0f / 255.0f, 70.0f / 255.0f, 71.0f / 255.0f, 72.0f / 255.0f, 73.0f / 255.0f, 74.0f / 255.0f, 75.0f / 255.0f, 76.0f / 255.0f, 77.0f / 255.0f, 78.0f / 255.0f, 79.0f / 255.0f, 80.0f / 255.0f, 81.0f / 255.0f, 82.0f / 255.0f, 83.0f / 255.0f, 84.0f / 255.0f, 85.0f / 255.0f, 86.0f / 255.0f, 87.0f / 255.0f, 88.0f / 255.0f, 89.0f / 255.0f, 90.0f / 255.0f, 91.0f / 255.0f, 92.0f / 255.0f, 93.0f / 255.0f, 94.0f / 255.0f, 95.0f / 255.0f, 96.0f / 255.0f, 97.0f / 255.0f, 98.0f / 255.0f, 99.0f / 255.0f, 100.0f / 255.0f, 101.0f / 255.0f, 102.0f / 255.0f, 103.0f / 255.0f, 104.0f / 255.0f, 105.0f / 255.0f, 106.0f / 255.0f, 107.0f / 255.0f, 108.0f / 255.0f, 109.0f / 255.0f, 110.0f / 255.0f, 111.0f / 255.0f, 112.0f / 255.0f, 113.0f / 255.0f, 114.0f / 255.0f, 115.0f / 255.0f, 116.0f / 255.0f, 117.0f / 255.0f, 118.0f / 255.0f, 119.0f / 255.0f, 120.0f / 255.0f, 121.0f / 255.0f, 122.0f / 255.0f, 123.0f / 255.0f, 124.0f / 255.0f, 125.0f / 255.0f, 126.0f / 255.0f, 127.0f / 255.0f, 128.0f / 255.0f, 129.0f / 255.0f, 130.0f / 255.0f, 131.0f / 255.0f, 132.0f / 255.0f, 133.0f / 255.0f, 134.0f / 255.0f, 135.0f / 255.0f, 136.0f / 255.0f, 137.0f / 255.0f, 138.0f / 255.0f, 139.0f / 255.0f, 140.0f / 255.0f, 141.0f / 255.0f, 142.0f / 255.0f, 143.0f / 255.0f, 144.0f / 255.0f, 145.0f / 255.0f, 146.0f / 255.0f, 147.0f / 255.0f, 148.0f / 255.0f, 149.0f / 255.0f, 150.0f / 255.0f, 151.0f / 255.0f, 152.0f / 255.0f, 153.0f / 255.0f, 154.0f / 255.0f, 155.0f / 255.0f, 156.0f / 255.0f, 157.0f / 255.0f, 158.0f / 255.0f, 159.0f / 255.0f, 160.0f / 255.0f, 161.0f / 255.0f, 162.0f / 255.0f, 163.0f / 255.0f, 164.0f / 255.0f, 165.0f / 255.0f, 166.0f / 255.0f, 167.0f / 255.0f, 168.0f / 255.0f, 169.0f / 255.0f, 170.0f / 255.0f, 171.0f / 255.0f, 172.0f / 255.0f, 173.0f / 255.0f, 174.0f / 255.0f, 175.0f / 255.0f, 176.0f / 255.0f, 177.0f / 255.0f, 178.0f / 255.0f, 179.0f / 255.0f, 180.0f / 255.0f, 181.0f / 255.0f, 182.0f / 255.0f, 183.0f / 255.0f, 184.0f / 255.0f, 185.0f / 255.0f, 186.0f / 255.0f, 187.0f / 255.0f, 188.0f / 255.0f, 189.0f / 255.0f, 190.0f / 255.0f, 191.0f / 255.0f, 192.0f / 255.0f, 193.0f / 255.0f, 194.0f / 255.0f, 195.0f / 255.0f, 196.0f / 255.0f, 197.0f / 255.0f, 198.0f / 255.0f, 199.0f / 255.0f, 200.0f / 255.0f, 201.0f / 255.0f, 202.0f / 255.0f, 203.0f / 255.0f, 204.0f / 255.0f, 205.0f / 255.0f, 206.0f / 255.0f, 207.0f / 255.0f, 208.0f / 255.0f, 209.0f / 255.0f, 210.0f / 255.0f, 211.0f / 255.0f, 212.0f / 255.0f, 213.0f / 255.0f, 214.0f / 255.0f, 215.0f / 255.0f, 216.0f / 255.0f, 217.0f / 255.0f, 218.0f / 255.0f, 219.0f / 255.0f, 220.0f / 255.0f, 221.0f / 255.0f, 222.0f / 255.0f, 223.0f / 255.0f, 224.0f / 255.0f, 225.0f / 255.0f, 226.0f / 255.0f, 227.0f / 255.0f, 228.0f / 255.0f, 229.0f / 255.0f, 230.0f / 255.0f, 231.0f / 255.0f, 232.0f / 255.0f, 233.0f / 255.0f, 234.0f / 255.0f, 235.0f / 255.0f, 236.0f / 255.0f, 237.0f / 255.0f, 238.0f / 255.0f, 239.0f / 255.0f, 240.0f / 255.0f, 241.0f / 255.0f, 242.0f / 255.0f, 243.0f / 255.0f, 244.0f / 255.0f, 245.0f / 255.0f, 246.0f / 255.0f, 247.0f / 255.0f, 248.0f / 255.0f, 249.0f / 255.0f, 250.0f / 255.0f, 251.0f / 255.0f, 252.0f / 255.0f, 253.0f / 255.0f, 254.0f / 255.0f, 255.0f / 255.0f};

void
rgb_analytic_pixel_init (RGBAnalyticPixel *self)
{
	memset (self, 0, sizeof (RGBAnalyticPixel));
	(*self).red = 0.0f;
	(*self).green = 0.0f;
	(*self).blue = 0.0f;
}

void
rgb_analytic_pixel_init_from_components (RGBAnalyticPixel *self,
                                         gfloat red,
                                         gfloat green,
                                         gfloat blue)
{
	memset (self, 0, sizeof (RGBAnalyticPixel));
	(*self).red = CLAMP (red, 0.0f, 1.0f);
	(*self).green = CLAMP (green, 0.0f, 1.0f);
	(*self).blue = CLAMP (blue, 0.0f, 1.0f);
}

void
rgb_analytic_pixel_init_from_quantized_components (RGBAnalyticPixel *self,
                                                   guchar red_quantized,
                                                   guchar green_quantized,
                                                   guchar blue_quantized)
{
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	memset (self, 0, sizeof (RGBAnalyticPixel));
	_tmp0_ = rgb_lookup_table[red_quantized];
	(*self).red = _tmp0_;
	_tmp1_ = rgb_lookup_table[green_quantized];
	(*self).green = _tmp1_;
	_tmp2_ = rgb_lookup_table[blue_quantized];
	(*self).blue = _tmp2_;
}

void
rgb_analytic_pixel_init_from_hsv (RGBAnalyticPixel *self,
                                  HSVAnalyticPixel* hsv_pixel)
{
	RGBAnalyticPixel from_hsv = {0};
	RGBAnalyticPixel _tmp0_ = {0};
	RGBAnalyticPixel _tmp1_;
	RGBAnalyticPixel _tmp2_;
	RGBAnalyticPixel _tmp3_;
	memset (self, 0, sizeof (RGBAnalyticPixel));
	hsv_analytic_pixel_to_rgb (hsv_pixel, &_tmp0_);
	from_hsv = _tmp0_;
	_tmp1_ = from_hsv;
	(*self).red = _tmp1_.red;
	_tmp2_ = from_hsv;
	(*self).green = _tmp2_.green;
	_tmp3_ = from_hsv;
	(*self).blue = _tmp3_.blue;
}

guchar
rgb_analytic_pixel_quantized_red (RGBAnalyticPixel *self)
{
	guchar result;
	result = (guchar) ((*self).red * 255.0f);
	return result;
}

guchar
rgb_analytic_pixel_quantized_green (RGBAnalyticPixel *self)
{
	guchar result;
	result = (guchar) ((*self).green * 255.0f);
	return result;
}

guchar
rgb_analytic_pixel_quantized_blue (RGBAnalyticPixel *self)
{
	guchar result;
	result = (guchar) ((*self).blue * 255.0f);
	return result;
}

gboolean
rgb_analytic_pixel_equals (RGBAnalyticPixel *self,
                           RGBAnalyticPixel* rhs)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if ((*self).red == (*rhs).red) {
		_tmp1_ = (*self).green == (*rhs).green;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (*self).blue == (*rhs).blue;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

guint
rgb_analytic_pixel_hash_code (RGBAnalyticPixel *self)
{
	guint result;
	result = ((((guint) ((*self).red * 255.0f)) << 16) + (((guint) ((*self).green * 255.0f)) << 8)) + ((guint) ((*self).blue * 255.0f));
	return result;
}

void
rgb_analytic_pixel_to_hsv (RGBAnalyticPixel *self,
                           HSVAnalyticPixel* result)
{
	HSVAnalyticPixel _tmp0_ = {0};
	hsv_analytic_pixel_init_from_rgb (&_tmp0_, &(*self));
	*result = _tmp0_;
	return;
}

RGBAnalyticPixel*
rgb_analytic_pixel_dup (const RGBAnalyticPixel* self)
{
	RGBAnalyticPixel* dup;
	dup = g_new0 (RGBAnalyticPixel, 1);
	memcpy (dup, self, sizeof (RGBAnalyticPixel));
	return dup;
}

void
rgb_analytic_pixel_free (RGBAnalyticPixel* self)
{
	g_free (self);
}

static GType
rgb_analytic_pixel_get_type_once (void)
{
	GType rgb_analytic_pixel_type_id;
	rgb_analytic_pixel_type_id = g_boxed_type_register_static ("RGBAnalyticPixel", (GBoxedCopyFunc) rgb_analytic_pixel_dup, (GBoxedFreeFunc) rgb_analytic_pixel_free);
	return rgb_analytic_pixel_type_id;
}

GType
rgb_analytic_pixel_get_type (void)
{
	static volatile gsize rgb_analytic_pixel_type_id__once = 0;
	if (g_once_init_enter (&rgb_analytic_pixel_type_id__once)) {
		GType rgb_analytic_pixel_type_id;
		rgb_analytic_pixel_type_id = rgb_analytic_pixel_get_type_once ();
		g_once_init_leave (&rgb_analytic_pixel_type_id__once, rgb_analytic_pixel_type_id);
	}
	return rgb_analytic_pixel_type_id__once;
}

void
hsv_analytic_pixel_init (HSVAnalyticPixel *self)
{
	memset (self, 0, sizeof (HSVAnalyticPixel));
	(*self).hue = 0.0f;
	(*self).saturation = 0.0f;
	(*self).light_value = 0.0f;
}

void
hsv_analytic_pixel_init_from_components (HSVAnalyticPixel *self,
                                         gfloat hue,
                                         gfloat saturation,
                                         gfloat light_value)
{
	memset (self, 0, sizeof (HSVAnalyticPixel));
	(*self).hue = CLAMP (hue, 0.0f, 1.0f);
	(*self).saturation = CLAMP (saturation, 0.0f, 1.0f);
	(*self).light_value = CLAMP (light_value, 0.0f, 1.0f);
}

void
hsv_analytic_pixel_init_from_quantized_components (HSVAnalyticPixel *self,
                                                   guchar hue_quantized,
                                                   guchar saturation_quantized,
                                                   guchar light_value_quantized)
{
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	memset (self, 0, sizeof (HSVAnalyticPixel));
	_tmp0_ = rgb_lookup_table[hue_quantized];
	(*self).hue = _tmp0_;
	_tmp1_ = rgb_lookup_table[saturation_quantized];
	(*self).saturation = _tmp1_;
	_tmp2_ = rgb_lookup_table[light_value_quantized];
	(*self).light_value = _tmp2_;
}

gboolean
hsv_analytic_pixel_equals (HSVAnalyticPixel *self,
                           HSVAnalyticPixel* rhs)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	HSVAnalyticPixel _tmp2_;
	gboolean result;
	_tmp2_ = *rhs;
	if ((*self).hue == _tmp2_.hue) {
		HSVAnalyticPixel _tmp3_;
		_tmp3_ = *rhs;
		_tmp1_ = (*self).saturation == _tmp3_.saturation;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		HSVAnalyticPixel _tmp4_;
		_tmp4_ = *rhs;
		_tmp0_ = (*self).light_value == _tmp4_.light_value;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

guint
hsv_analytic_pixel_hash_code (HSVAnalyticPixel *self)
{
	guint result;
	result = ((((guint) ((*self).hue * 255.0f)) << 16) + (((guint) ((*self).saturation * 255.0f)) << 8)) + ((guint) ((*self).light_value * 255.0f));
	return result;
}

HSVAnalyticPixel*
hsv_analytic_pixel_dup (const HSVAnalyticPixel* self)
{
	HSVAnalyticPixel* dup;
	dup = g_new0 (HSVAnalyticPixel, 1);
	memcpy (dup, self, sizeof (HSVAnalyticPixel));
	return dup;
}

void
hsv_analytic_pixel_free (HSVAnalyticPixel* self)
{
	g_free (self);
}

static GType
hsv_analytic_pixel_get_type_once (void)
{
	GType hsv_analytic_pixel_type_id;
	hsv_analytic_pixel_type_id = g_boxed_type_register_static ("HSVAnalyticPixel", (GBoxedCopyFunc) hsv_analytic_pixel_dup, (GBoxedFreeFunc) hsv_analytic_pixel_free);
	return hsv_analytic_pixel_type_id;
}

GType
hsv_analytic_pixel_get_type (void)
{
	static volatile gsize hsv_analytic_pixel_type_id__once = 0;
	if (g_once_init_enter (&hsv_analytic_pixel_type_id__once)) {
		GType hsv_analytic_pixel_type_id;
		hsv_analytic_pixel_type_id = hsv_analytic_pixel_get_type_once ();
		g_once_init_leave (&hsv_analytic_pixel_type_id__once, hsv_analytic_pixel_type_id);
	}
	return hsv_analytic_pixel_type_id__once;
}

static GType
composition_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPOSITION_MODE_NONE, "COMPOSITION_MODE_NONE", "none"}, {COMPOSITION_MODE_RGB_MATRIX, "COMPOSITION_MODE_RGB_MATRIX", "rgb-matrix"}, {COMPOSITION_MODE_HSV_LOOKUP, "COMPOSITION_MODE_HSV_LOOKUP", "hsv-lookup"}, {0, NULL, NULL}};
	GType composition_mode_type_id;
	composition_mode_type_id = g_enum_register_static ("CompositionMode", values);
	return composition_mode_type_id;
}

GType
composition_mode_get_type (void)
{
	static volatile gsize composition_mode_type_id__once = 0;
	if (g_once_init_enter (&composition_mode_type_id__once)) {
		GType composition_mode_type_id;
		composition_mode_type_id = composition_mode_get_type_once ();
		g_once_init_leave (&composition_mode_type_id__once, composition_mode_type_id);
	}
	return composition_mode_type_id__once;
}

static GType
pixel_format_get_type_once (void)
{
	static const GEnumValue values[] = {{PIXEL_FORMAT_RGB, "PIXEL_FORMAT_RGB", "rgb"}, {PIXEL_FORMAT_HSV, "PIXEL_FORMAT_HSV", "hsv"}, {0, NULL, NULL}};
	GType pixel_format_type_id;
	pixel_format_type_id = g_enum_register_static ("PixelFormat", values);
	return pixel_format_type_id;
}

GType
pixel_format_get_type (void)
{
	static volatile gsize pixel_format_type_id__once = 0;
	if (g_once_init_enter (&pixel_format_type_id__once)) {
		GType pixel_format_type_id;
		pixel_format_type_id = pixel_format_get_type_once ();
		g_once_init_leave (&pixel_format_type_id__once, pixel_format_type_id);
	}
	return pixel_format_type_id__once;
}

static GType
pixel_transformation_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION, "PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION", "tone-expansion"}, {PIXEL_TRANSFORMATION_TYPE_SHADOWS, "PIXEL_TRANSFORMATION_TYPE_SHADOWS", "shadows"}, {PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS, "PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS", "highlights"}, {PIXEL_TRANSFORMATION_TYPE_TEMPERATURE, "PIXEL_TRANSFORMATION_TYPE_TEMPERATURE", "temperature"}, {PIXEL_TRANSFORMATION_TYPE_TINT, "PIXEL_TRANSFORMATION_TYPE_TINT", "tint"}, {PIXEL_TRANSFORMATION_TYPE_SATURATION, "PIXEL_TRANSFORMATION_TYPE_SATURATION", "saturation"}, {PIXEL_TRANSFORMATION_TYPE_EXPOSURE, "PIXEL_TRANSFORMATION_TYPE_EXPOSURE", "exposure"}, {PIXEL_TRANSFORMATION_TYPE_CONTRAST, "PIXEL_TRANSFORMATION_TYPE_CONTRAST", "contrast"}, {0, NULL, NULL}};
	GType pixel_transformation_type_type_id;
	pixel_transformation_type_type_id = g_enum_register_static ("PixelTransformationType", values);
	return pixel_transformation_type_type_id;
}

GType
pixel_transformation_type_get_type (void)
{
	static volatile gsize pixel_transformation_type_type_id__once = 0;
	if (g_once_init_enter (&pixel_transformation_type_type_id__once)) {
		GType pixel_transformation_type_type_id;
		pixel_transformation_type_type_id = pixel_transformation_type_get_type_once ();
		g_once_init_leave (&pixel_transformation_type_type_id__once, pixel_transformation_type_type_id);
	}
	return pixel_transformation_type_type_id__once;
}

static inline gpointer
pixel_transformation_bundle_get_instance_private (PixelTransformationBundle* self)
{
	return G_STRUCT_MEMBER_P (self, PixelTransformationBundle_private_offset);
}

PixelTransformationBundle*
pixel_transformation_bundle_construct (GType object_type)
{
	PixelTransformationBundle* self = NULL;
	self = (PixelTransformationBundle*) g_type_create_instance (object_type);
	return self;
}

PixelTransformationBundle*
pixel_transformation_bundle_new (void)
{
	return pixel_transformation_bundle_construct (TYPE_PIXEL_TRANSFORMATION_BUNDLE);
}

static gpointer
_pixel_transformation_bundle_ref0 (gpointer self)
{
	return self ? pixel_transformation_bundle_ref (self) : NULL;
}

PixelTransformationBundle*
pixel_transformation_bundle_get_copied_color_adjustments (void)
{
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
	PixelTransformationBundle* result;
	_tmp0_ = pixel_transformation_bundle_copied_color_adjustments;
	_tmp1_ = _pixel_transformation_bundle_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
pixel_transformation_bundle_set_copied_color_adjustments (PixelTransformationBundle* adjustments)
{
	PixelTransformationBundle* _tmp0_;
	_tmp0_ = _pixel_transformation_bundle_ref0 (adjustments);
	_pixel_transformation_bundle_unref0 (pixel_transformation_bundle_copied_color_adjustments);
	pixel_transformation_bundle_copied_color_adjustments = _tmp0_;
}

gboolean
pixel_transformation_bundle_has_copied_color_adjustments (void)
{
	PixelTransformationBundle* _tmp0_;
	gboolean result;
	_tmp0_ = pixel_transformation_bundle_copied_color_adjustments;
	result = _tmp0_ != NULL;
	return result;
}

void
pixel_transformation_bundle_set (PixelTransformationBundle* self,
                                 PixelTransformation* transformation)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = self->priv->map;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) pixel_transformation_get_transformation_type (transformation)), transformation);
}

void
pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self)
{
	ExpansionTransformation* _tmp0_;
	ExpansionTransformation* _tmp1_;
	ShadowDetailTransformation* _tmp2_;
	ShadowDetailTransformation* _tmp3_;
	HighlightDetailTransformation* _tmp4_;
	HighlightDetailTransformation* _tmp5_;
	TemperatureTransformation* _tmp6_;
	TemperatureTransformation* _tmp7_;
	TintTransformation* _tmp8_;
	TintTransformation* _tmp9_;
	SaturationTransformation* _tmp10_;
	SaturationTransformation* _tmp11_;
	ExposureTransformation* _tmp12_;
	ExposureTransformation* _tmp13_;
	ContrastTransformation* _tmp14_;
	ContrastTransformation* _tmp15_;
	_tmp0_ = expansion_transformation_new_from_extrema (0, 255);
	_tmp1_ = _tmp0_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp1_);
	_tmp2_ = shadow_detail_transformation_new (0.0f);
	_tmp3_ = _tmp2_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp3_);
	_tmp4_ = highlight_detail_transformation_new (0.0f);
	_tmp5_ = _tmp4_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp5_);
	_tmp6_ = temperature_transformation_new (0.0f);
	_tmp7_ = _tmp6_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp7_);
	_tmp8_ = tint_transformation_new (0.0f);
	_tmp9_ = _tmp8_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp9_);
	_tmp10_ = saturation_transformation_new (0.0f);
	_tmp11_ = _tmp10_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp11_);
	_tmp12_ = exposure_transformation_new (0.0f);
	_tmp13_ = _tmp12_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp13_);
	_tmp14_ = contrast_transformation_new (0.0f);
	_tmp15_ = _tmp14_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp15_);
}

void
pixel_transformation_bundle_load (PixelTransformationBundle* self,
                                  KeyValueMap* store)
{
	gchar* expansion_params_encoded = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ShadowDetailTransformation* _tmp7_;
	ShadowDetailTransformation* _tmp8_;
	HighlightDetailTransformation* _tmp9_;
	HighlightDetailTransformation* _tmp10_;
	TemperatureTransformation* _tmp11_;
	TemperatureTransformation* _tmp12_;
	TintTransformation* _tmp13_;
	TintTransformation* _tmp14_;
	SaturationTransformation* _tmp15_;
	SaturationTransformation* _tmp16_;
	ExposureTransformation* _tmp17_;
	ExposureTransformation* _tmp18_;
	ContrastTransformation* _tmp19_;
	ContrastTransformation* _tmp20_;
	_tmp0_ = key_value_map_get_string (store, "expansion", "-");
	expansion_params_encoded = _tmp0_;
	_tmp1_ = expansion_params_encoded;
	if (g_strcmp0 (_tmp1_, "-") == 0) {
		ExpansionTransformation* _tmp2_;
		ExpansionTransformation* _tmp3_;
		_tmp2_ = expansion_transformation_new_from_extrema (0, 255);
		_tmp3_ = _tmp2_;
		pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
		_pixel_transformation_unref0 (_tmp3_);
	} else {
		const gchar* _tmp4_;
		ExpansionTransformation* _tmp5_;
		ExpansionTransformation* _tmp6_;
		_tmp4_ = expansion_params_encoded;
		_tmp5_ = expansion_transformation_new_from_string (_tmp4_);
		_tmp6_ = _tmp5_;
		pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
		_pixel_transformation_unref0 (_tmp6_);
	}
	_tmp7_ = shadow_detail_transformation_new (key_value_map_get_float (store, "shadows", 0.0f));
	_tmp8_ = _tmp7_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp8_);
	_tmp9_ = highlight_detail_transformation_new (key_value_map_get_float (store, "highlights", 0.0f));
	_tmp10_ = _tmp9_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp10_);
	_tmp11_ = temperature_transformation_new (key_value_map_get_float (store, "temperature", 0.0f));
	_tmp12_ = _tmp11_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp12_);
	_tmp13_ = tint_transformation_new (key_value_map_get_float (store, "tint", 0.0f));
	_tmp14_ = _tmp13_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp14_);
	_tmp15_ = saturation_transformation_new (key_value_map_get_float (store, "saturation", 0.0f));
	_tmp16_ = _tmp15_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp16_);
	_tmp17_ = exposure_transformation_new (key_value_map_get_float (store, "exposure", 0.0f));
	_tmp18_ = _tmp17_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp18_);
	_tmp19_ = contrast_transformation_new (key_value_map_get_float (store, "contrast", 0.0f));
	_tmp20_ = _tmp19_;
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp20_);
	_g_free0 (expansion_params_encoded);
}

KeyValueMap*
pixel_transformation_bundle_save (PixelTransformationBundle* self,
                                  const gchar* group)
{
	KeyValueMap* store = NULL;
	KeyValueMap* _tmp0_;
	ExpansionTransformation* new_expansion_trans = NULL;
	PixelTransformation* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ShadowDetailTransformation* new_shadows_trans = NULL;
	PixelTransformation* _tmp4_;
	HighlightDetailTransformation* new_highlight_trans = NULL;
	PixelTransformation* _tmp5_;
	TemperatureTransformation* new_temp_trans = NULL;
	PixelTransformation* _tmp6_;
	TintTransformation* new_tint_trans = NULL;
	PixelTransformation* _tmp7_;
	SaturationTransformation* new_sat_trans = NULL;
	PixelTransformation* _tmp8_;
	ExposureTransformation* new_exposure_trans = NULL;
	PixelTransformation* _tmp9_;
	ContrastTransformation* new_contrast_trans = NULL;
	PixelTransformation* _tmp10_;
	KeyValueMap* result;
	_tmp0_ = key_value_map_new (group);
	store = _tmp0_;
	_tmp1_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
	new_expansion_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
	_vala_assert (new_expansion_trans != NULL, "new_expansion_trans != null");
	_tmp2_ = pixel_transformation_to_string (G_TYPE_CHECK_INSTANCE_CAST (new_expansion_trans, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_tmp3_ = _tmp2_;
	key_value_map_set_string (store, "expansion", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_SHADOWS);
	new_shadows_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
	_vala_assert (new_shadows_trans != NULL, "new_shadows_trans != null");
	key_value_map_set_float (store, "shadows", shadow_detail_transformation_get_parameter (new_shadows_trans));
	_tmp5_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS);
	new_highlight_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
	_vala_assert (new_highlight_trans != NULL, "new_highlight_trans != null");
	key_value_map_set_float (store, "highlights", highlight_detail_transformation_get_parameter (new_highlight_trans));
	_tmp6_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TEMPERATURE);
	new_temp_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation);
	_vala_assert (new_temp_trans != NULL, "new_temp_trans != null");
	key_value_map_set_float (store, "temperature", temperature_transformation_get_parameter (new_temp_trans));
	_tmp7_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TINT);
	new_tint_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_TINT_TRANSFORMATION, TintTransformation);
	_vala_assert (new_tint_trans != NULL, "new_tint_trans != null");
	key_value_map_set_float (store, "tint", tint_transformation_get_parameter (new_tint_trans));
	_tmp8_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_SATURATION);
	new_sat_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_SATURATION_TRANSFORMATION, SaturationTransformation);
	_vala_assert (new_sat_trans != NULL, "new_sat_trans != null");
	key_value_map_set_float (store, "saturation", saturation_transformation_get_parameter (new_sat_trans));
	_tmp9_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_EXPOSURE);
	new_exposure_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation);
	_vala_assert (new_exposure_trans != NULL, "new_exposure_trans != null");
	key_value_map_set_float (store, "exposure", exposure_transformation_get_parameter (new_exposure_trans));
	_tmp10_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_CONTRAST);
	new_contrast_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation);
	_vala_assert (new_contrast_trans != NULL, "new_contrast_trans != null");
	key_value_map_set_float (store, "contrast", contrast_transformation_get_parameter (new_contrast_trans));
	result = store;
	_pixel_transformation_unref0 (new_contrast_trans);
	_pixel_transformation_unref0 (new_exposure_trans);
	_pixel_transformation_unref0 (new_sat_trans);
	_pixel_transformation_unref0 (new_tint_trans);
	_pixel_transformation_unref0 (new_temp_trans);
	_pixel_transformation_unref0 (new_highlight_trans);
	_pixel_transformation_unref0 (new_shadows_trans);
	_pixel_transformation_unref0 (new_expansion_trans);
	return result;
}

gint
pixel_transformation_bundle_get_count (PixelTransformationBundle* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

PixelTransformation*
pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self,
                                                PixelTransformationType type)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	PixelTransformation* result;
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) type));
	result = (PixelTransformation*) _tmp1_;
	return result;
}

GeeIterable*
pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterable* result;
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable);
	return result;
}

gboolean
pixel_transformation_bundle_is_identity (PixelTransformationBundle* self)
{
	gboolean result;
	{
		GeeIterator* _adjustment_it = NULL;
		GeeIterable* _tmp0_;
		GeeIterable* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = pixel_transformation_bundle_get_transformations (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_adjustment_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			PixelTransformation* adjustment = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			PixelTransformation* _tmp7_;
			_tmp4_ = _adjustment_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _adjustment_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			adjustment = (PixelTransformation*) _tmp6_;
			_tmp7_ = adjustment;
			if (!pixel_transformation_is_identity (_tmp7_)) {
				result = FALSE;
				_pixel_transformation_unref0 (adjustment);
				_g_object_unref0 (_adjustment_it);
				return result;
			}
			_pixel_transformation_unref0 (adjustment);
		}
		_g_object_unref0 (_adjustment_it);
	}
	result = TRUE;
	return result;
}

PixelTransformer*
pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self)
{
	PixelTransformer* transformer = NULL;
	PixelTransformer* _tmp0_;
	PixelTransformer* result;
	_tmp0_ = pixel_transformer_new ();
	transformer = _tmp0_;
	{
		GeeIterator* _transformation_it = NULL;
		GeeIterable* _tmp1_;
		GeeIterable* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = pixel_transformation_bundle_get_transformations (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_transformation_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			PixelTransformation* transformation = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			PixelTransformer* _tmp8_;
			PixelTransformation* _tmp9_;
			_tmp5_ = _transformation_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _transformation_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			transformation = (PixelTransformation*) _tmp7_;
			_tmp8_ = transformer;
			_tmp9_ = transformation;
			pixel_transformer_attach_transformation (_tmp8_, _tmp9_);
			_pixel_transformation_unref0 (transformation);
		}
		_g_object_unref0 (_transformation_it);
	}
	result = transformer;
	return result;
}

PixelTransformationBundle*
pixel_transformation_bundle_copy (PixelTransformationBundle* self)
{
	PixelTransformationBundle* bundle = NULL;
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* result;
	_tmp0_ = pixel_transformation_bundle_new ();
	bundle = _tmp0_;
	{
		GeeIterator* _transformation_it = NULL;
		GeeIterable* _tmp1_;
		GeeIterable* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = pixel_transformation_bundle_get_transformations (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_transformation_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			PixelTransformation* transformation = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			PixelTransformationBundle* _tmp8_;
			PixelTransformation* _tmp9_;
			_tmp5_ = _transformation_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _transformation_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			transformation = (PixelTransformation*) _tmp7_;
			_tmp8_ = bundle;
			_tmp9_ = transformation;
			pixel_transformation_bundle_set (_tmp8_, _tmp9_);
			_pixel_transformation_unref0 (transformation);
		}
		_g_object_unref0 (_transformation_it);
	}
	result = bundle;
	return result;
}

static void
value_pixel_transformation_bundle_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_pixel_transformation_bundle_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pixel_transformation_bundle_unref (value->data[0].v_pointer);
	}
}

static void
value_pixel_transformation_bundle_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pixel_transformation_bundle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_pixel_transformation_bundle_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_pixel_transformation_bundle_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PixelTransformationBundle * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pixel_transformation_bundle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_pixel_transformation_bundle_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	PixelTransformationBundle ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pixel_transformation_bundle_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_pixel_transformation_bundle (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	ParamSpecPixelTransformationBundle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMATION_BUNDLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_pixel_transformation_bundle (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_pixel_transformation_bundle (GValue* value,
                                       gpointer v_object)
{
	PixelTransformationBundle * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pixel_transformation_bundle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixel_transformation_bundle_unref (old);
	}
}

void
value_take_pixel_transformation_bundle (GValue* value,
                                        gpointer v_object)
{
	PixelTransformationBundle * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixel_transformation_bundle_unref (old);
	}
}

static void
pixel_transformation_bundle_class_init (PixelTransformationBundleClass * klass,
                                        gpointer klass_data)
{
	pixel_transformation_bundle_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationBundleClass *) klass)->finalize = pixel_transformation_bundle_finalize;
	g_type_class_adjust_private_offset (klass, &PixelTransformationBundle_private_offset);
}

static void
pixel_transformation_bundle_instance_init (PixelTransformationBundle * self,
                                           gpointer klass)
{
	gpointer _tmp0_ = NULL;
	GDestroyNotify _tmp1_ = NULL;
	GeeHashDataFunc _tmp2_;
	gpointer _tmp3_ = NULL;
	GDestroyNotify _tmp4_ = NULL;
	GeeEqualDataFunc _tmp5_;
	GeeHashMap* _tmp6_;
	self->priv = pixel_transformation_bundle_get_instance_private (self);
	_tmp2_ = gee_functions_get_hash_func_for (G_TYPE_INT, &_tmp0_, &_tmp1_);
	_tmp5_ = gee_functions_get_equal_func_for (G_TYPE_INT, &_tmp3_, &_tmp4_);
	_tmp6_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, TYPE_PIXEL_TRANSFORMATION, (GBoxedCopyFunc) pixel_transformation_ref, (GDestroyNotify) pixel_transformation_unref, _tmp2_, _tmp0_, _tmp1_, _tmp5_, _tmp3_, _tmp4_, NULL, NULL, NULL);
	self->priv->map = _tmp6_;
	self->ref_count = 1;
}

static void
pixel_transformation_bundle_finalize (PixelTransformationBundle * obj)
{
	PixelTransformationBundle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->map);
}

static GType
pixel_transformation_bundle_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_pixel_transformation_bundle_init, value_pixel_transformation_bundle_free_value, value_pixel_transformation_bundle_copy_value, value_pixel_transformation_bundle_peek_pointer, "p", value_pixel_transformation_bundle_collect_value, "p", value_pixel_transformation_bundle_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PixelTransformationBundleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformation_bundle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformationBundle), 0, (GInstanceInitFunc) pixel_transformation_bundle_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pixel_transformation_bundle_type_id;
	pixel_transformation_bundle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformationBundle", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PixelTransformationBundle_private_offset = g_type_add_instance_private (pixel_transformation_bundle_type_id, sizeof (PixelTransformationBundlePrivate));
	return pixel_transformation_bundle_type_id;
}

GType
pixel_transformation_bundle_get_type (void)
{
	static volatile gsize pixel_transformation_bundle_type_id__once = 0;
	if (g_once_init_enter (&pixel_transformation_bundle_type_id__once)) {
		GType pixel_transformation_bundle_type_id;
		pixel_transformation_bundle_type_id = pixel_transformation_bundle_get_type_once ();
		g_once_init_leave (&pixel_transformation_bundle_type_id__once, pixel_transformation_bundle_type_id);
	}
	return pixel_transformation_bundle_type_id__once;
}

gpointer
pixel_transformation_bundle_ref (gpointer instance)
{
	PixelTransformationBundle * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pixel_transformation_bundle_unref (gpointer instance)
{
	PixelTransformationBundle * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
pixel_transformation_get_instance_private (PixelTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, PixelTransformation_private_offset);
}

PixelTransformation*
pixel_transformation_construct (GType object_type,
                                PixelTransformationType type,
                                PixelFormat preferred_format)
{
	PixelTransformation* self = NULL;
	self = (PixelTransformation*) g_type_create_instance (object_type);
	self->priv->type = type;
	self->priv->preferred_format = preferred_format;
	return self;
}

PixelTransformationType
pixel_transformation_get_transformation_type (PixelTransformation* self)
{
	PixelTransformationType result;
	result = self->priv->type;
	return result;
}

PixelFormat
pixel_transformation_get_preferred_format (PixelTransformation* self)
{
	PixelFormat result;
	result = self->priv->preferred_format;
	return result;
}

static CompositionMode
pixel_transformation_real_get_composition_mode (PixelTransformation* self)
{
	CompositionMode result;
	result = COMPOSITION_MODE_NONE;
	return result;
}

CompositionMode
pixel_transformation_get_composition_mode (PixelTransformation* self)
{
	PixelTransformationClass* _klass_;
	_klass_ = PIXEL_TRANSFORMATION_GET_CLASS (self);
	if (_klass_->get_composition_mode) {
		return _klass_->get_composition_mode (self);
	}
	return 0;
}

static void
pixel_transformation_real_compose_with (PixelTransformation* self,
                                        PixelTransformation* other)
{
	g_error ("ColorTransformation.vala:290: %s", "PixelTransformation: compose_with( ): this type of pixel " "transformation doesn't support composition.");
}

void
pixel_transformation_compose_with (PixelTransformation* self,
                                   PixelTransformation* other)
{
	PixelTransformationClass* _klass_;
	_klass_ = PIXEL_TRANSFORMATION_GET_CLASS (self);
	if (_klass_->compose_with) {
		_klass_->compose_with (self, other);
	}
}

static gboolean
pixel_transformation_real_is_identity (PixelTransformation* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
pixel_transformation_is_identity (PixelTransformation* self)
{
	PixelTransformationClass* _klass_;
	_klass_ = PIXEL_TRANSFORMATION_GET_CLASS (self);
	if (_klass_->is_identity) {
		return _klass_->is_identity (self);
	}
	return FALSE;
}

static void
pixel_transformation_real_transform_pixel_hsv (PixelTransformation* self,
                                               HSVAnalyticPixel* p,
                                               HSVAnalyticPixel* result)
{
	HSVAnalyticPixel _tmp0_;
	_tmp0_ = *p;
	*result = _tmp0_;
	return;
}

void
pixel_transformation_transform_pixel_hsv (PixelTransformation* self,
                                          HSVAnalyticPixel* p,
                                          HSVAnalyticPixel* result)
{
	PixelTransformationClass* _klass_;
	_klass_ = PIXEL_TRANSFORMATION_GET_CLASS (self);
	if (_klass_->transform_pixel_hsv) {
		_klass_->transform_pixel_hsv (self, p, result);
	}
}

static void
pixel_transformation_real_transform_pixel_rgb (PixelTransformation* self,
                                               RGBAnalyticPixel* p,
                                               RGBAnalyticPixel* result)
{
	RGBAnalyticPixel _tmp0_;
	_tmp0_ = *p;
	*result = _tmp0_;
	return;
}

void
pixel_transformation_transform_pixel_rgb (PixelTransformation* self,
                                          RGBAnalyticPixel* p,
                                          RGBAnalyticPixel* result)
{
	PixelTransformationClass* _klass_;
	_klass_ = PIXEL_TRANSFORMATION_GET_CLASS (self);
	if (_klass_->transform_pixel_rgb) {
		_klass_->transform_pixel_rgb (self, p, result);
	}
}

static gchar*
pixel_transformation_real_to_string (PixelTransformation* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("PixelTransformation");
	result = _tmp0_;
	return result;
}

gchar*
pixel_transformation_to_string (PixelTransformation* self)
{
	PixelTransformationClass* _klass_;
	_klass_ = PIXEL_TRANSFORMATION_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static PixelTransformation*
pixel_transformation_real_copy (PixelTransformation* self)
{
	g_critical ("Type `%s' does not implement abstract method `pixel_transformation_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PixelTransformation*
pixel_transformation_copy (PixelTransformation* self)
{
	PixelTransformationClass* _klass_;
	_klass_ = PIXEL_TRANSFORMATION_GET_CLASS (self);
	if (_klass_->copy) {
		return _klass_->copy (self);
	}
	return NULL;
}

static void
value_pixel_transformation_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_pixel_transformation_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pixel_transformation_unref (value->data[0].v_pointer);
	}
}

static void
value_pixel_transformation_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pixel_transformation_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_pixel_transformation_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_pixel_transformation_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PixelTransformation * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pixel_transformation_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_pixel_transformation_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	PixelTransformation ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pixel_transformation_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_pixel_transformation (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ParamSpecPixelTransformation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_pixel_transformation (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_pixel_transformation (GValue* value,
                                gpointer v_object)
{
	PixelTransformation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pixel_transformation_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixel_transformation_unref (old);
	}
}

void
value_take_pixel_transformation (GValue* value,
                                 gpointer v_object)
{
	PixelTransformation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixel_transformation_unref (old);
	}
}

static void
pixel_transformation_class_init (PixelTransformationClass * klass,
                                 gpointer klass_data)
{
	pixel_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = pixel_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &PixelTransformation_private_offset);
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*) (PixelTransformation*)) pixel_transformation_real_get_composition_mode;
	((PixelTransformationClass *) klass)->compose_with = (void (*) (PixelTransformation*, PixelTransformation*)) pixel_transformation_real_compose_with;
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation*)) pixel_transformation_real_is_identity;
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*) (PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) pixel_transformation_real_transform_pixel_hsv;
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*) (PixelTransformation*, RGBAnalyticPixel*, RGBAnalyticPixel*)) pixel_transformation_real_transform_pixel_rgb;
	((PixelTransformationClass *) klass)->to_string = (gchar* (*) (PixelTransformation*)) pixel_transformation_real_to_string;
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation*)) pixel_transformation_real_copy;
}

static void
pixel_transformation_instance_init (PixelTransformation * self,
                                    gpointer klass)
{
	self->priv = pixel_transformation_get_instance_private (self);
	self->ref_count = 1;
}

static void
pixel_transformation_finalize (PixelTransformation * obj)
{
	PixelTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
	g_signal_handlers_destroy (self);
}

static GType
pixel_transformation_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_pixel_transformation_init, value_pixel_transformation_free_value, value_pixel_transformation_copy_value, value_pixel_transformation_peek_pointer, "p", value_pixel_transformation_collect_value, "p", value_pixel_transformation_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PixelTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformation), 0, (GInstanceInitFunc) pixel_transformation_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pixel_transformation_type_id;
	pixel_transformation_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformation", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	PixelTransformation_private_offset = g_type_add_instance_private (pixel_transformation_type_id, sizeof (PixelTransformationPrivate));
	return pixel_transformation_type_id;
}

GType
pixel_transformation_get_type (void)
{
	static volatile gsize pixel_transformation_type_id__once = 0;
	if (g_once_init_enter (&pixel_transformation_type_id__once)) {
		GType pixel_transformation_type_id;
		pixel_transformation_type_id = pixel_transformation_get_type_once ();
		g_once_init_leave (&pixel_transformation_type_id__once, pixel_transformation_type_id);
	}
	return pixel_transformation_type_id__once;
}

gpointer
pixel_transformation_ref (gpointer instance)
{
	PixelTransformation * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pixel_transformation_unref (gpointer instance)
{
	PixelTransformation * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PIXEL_TRANSFORMATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

RGBTransformation*
rgb_transformation_construct (GType object_type,
                              PixelTransformationType type)
{
	RGBTransformation* self = NULL;
	gfloat* _tmp0_;
	self = (RGBTransformation*) pixel_transformation_construct (object_type, type, PIXEL_FORMAT_RGB);
	_tmp0_ = g_new0 (gfloat, 16);
	_tmp0_[0] = 1.0f;
	_tmp0_[1] = 0.0f;
	_tmp0_[2] = 0.0f;
	_tmp0_[3] = 0.0f;
	_tmp0_[4] = 0.0f;
	_tmp0_[5] = 1.0f;
	_tmp0_[6] = 0.0f;
	_tmp0_[7] = 0.0f;
	_tmp0_[8] = 0.0f;
	_tmp0_[9] = 0.0f;
	_tmp0_[10] = 1.0f;
	_tmp0_[11] = 0.0f;
	_tmp0_[12] = 0.0f;
	_tmp0_[13] = 0.0f;
	_tmp0_[14] = 0.0f;
	_tmp0_[15] = 1.0f;
	self->matrix_entries = (g_free (self->matrix_entries), NULL);
	self->matrix_entries = _tmp0_;
	self->matrix_entries_length1 = 16;
	return self;
}

RGBTransformation*
rgb_transformation_new (PixelTransformationType type)
{
	return rgb_transformation_construct (TYPE_RGB_TRANSFORMATION, type);
}

static CompositionMode
rgb_transformation_real_get_composition_mode (PixelTransformation* base)
{
	RGBTransformation * self;
	CompositionMode result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
	result = COMPOSITION_MODE_RGB_MATRIX;
	return result;
}

static gpointer
_pixel_transformation_ref0 (gpointer self)
{
	return self ? pixel_transformation_ref (self) : NULL;
}

static void
rgb_transformation_real_compose_with (PixelTransformation* base,
                                      PixelTransformation* other)
{
	RGBTransformation * self;
	RGBTransformation* transform = NULL;
	RGBTransformation* _tmp0_;
	gfloat* result_matrix_entries = NULL;
	gfloat* _tmp1_;
	gint result_matrix_entries_length1;
	gint _result_matrix_entries_size_;
	gfloat* _tmp2_;
	gint _tmp2__length1;
	RGBTransformation* _tmp3_;
	gfloat* _tmp4_;
	gint _tmp4__length1;
	gfloat _tmp5_;
	gfloat* _tmp6_;
	gint _tmp6__length1;
	gfloat _tmp7_;
	RGBTransformation* _tmp8_;
	gfloat* _tmp9_;
	gint _tmp9__length1;
	gfloat _tmp10_;
	gfloat* _tmp11_;
	gint _tmp11__length1;
	gfloat _tmp12_;
	RGBTransformation* _tmp13_;
	gfloat* _tmp14_;
	gint _tmp14__length1;
	gfloat _tmp15_;
	gfloat* _tmp16_;
	gint _tmp16__length1;
	gfloat _tmp17_;
	RGBTransformation* _tmp18_;
	gfloat* _tmp19_;
	gint _tmp19__length1;
	gfloat _tmp20_;
	gfloat* _tmp21_;
	gint _tmp21__length1;
	gfloat _tmp22_;
	gfloat* _tmp23_;
	gint _tmp23__length1;
	RGBTransformation* _tmp24_;
	gfloat* _tmp25_;
	gint _tmp25__length1;
	gfloat _tmp26_;
	gfloat* _tmp27_;
	gint _tmp27__length1;
	gfloat _tmp28_;
	RGBTransformation* _tmp29_;
	gfloat* _tmp30_;
	gint _tmp30__length1;
	gfloat _tmp31_;
	gfloat* _tmp32_;
	gint _tmp32__length1;
	gfloat _tmp33_;
	RGBTransformation* _tmp34_;
	gfloat* _tmp35_;
	gint _tmp35__length1;
	gfloat _tmp36_;
	gfloat* _tmp37_;
	gint _tmp37__length1;
	gfloat _tmp38_;
	RGBTransformation* _tmp39_;
	gfloat* _tmp40_;
	gint _tmp40__length1;
	gfloat _tmp41_;
	gfloat* _tmp42_;
	gint _tmp42__length1;
	gfloat _tmp43_;
	gfloat* _tmp44_;
	gint _tmp44__length1;
	RGBTransformation* _tmp45_;
	gfloat* _tmp46_;
	gint _tmp46__length1;
	gfloat _tmp47_;
	gfloat* _tmp48_;
	gint _tmp48__length1;
	gfloat _tmp49_;
	RGBTransformation* _tmp50_;
	gfloat* _tmp51_;
	gint _tmp51__length1;
	gfloat _tmp52_;
	gfloat* _tmp53_;
	gint _tmp53__length1;
	gfloat _tmp54_;
	RGBTransformation* _tmp55_;
	gfloat* _tmp56_;
	gint _tmp56__length1;
	gfloat _tmp57_;
	gfloat* _tmp58_;
	gint _tmp58__length1;
	gfloat _tmp59_;
	RGBTransformation* _tmp60_;
	gfloat* _tmp61_;
	gint _tmp61__length1;
	gfloat _tmp62_;
	gfloat* _tmp63_;
	gint _tmp63__length1;
	gfloat _tmp64_;
	gfloat* _tmp65_;
	gint _tmp65__length1;
	RGBTransformation* _tmp66_;
	gfloat* _tmp67_;
	gint _tmp67__length1;
	gfloat _tmp68_;
	gfloat* _tmp69_;
	gint _tmp69__length1;
	gfloat _tmp70_;
	RGBTransformation* _tmp71_;
	gfloat* _tmp72_;
	gint _tmp72__length1;
	gfloat _tmp73_;
	gfloat* _tmp74_;
	gint _tmp74__length1;
	gfloat _tmp75_;
	RGBTransformation* _tmp76_;
	gfloat* _tmp77_;
	gint _tmp77__length1;
	gfloat _tmp78_;
	gfloat* _tmp79_;
	gint _tmp79__length1;
	gfloat _tmp80_;
	RGBTransformation* _tmp81_;
	gfloat* _tmp82_;
	gint _tmp82__length1;
	gfloat _tmp83_;
	gfloat* _tmp84_;
	gint _tmp84__length1;
	gfloat _tmp85_;
	gfloat* _tmp86_;
	gint _tmp86__length1;
	RGBTransformation* _tmp87_;
	gfloat* _tmp88_;
	gint _tmp88__length1;
	gfloat _tmp89_;
	gfloat* _tmp90_;
	gint _tmp90__length1;
	gfloat _tmp91_;
	RGBTransformation* _tmp92_;
	gfloat* _tmp93_;
	gint _tmp93__length1;
	gfloat _tmp94_;
	gfloat* _tmp95_;
	gint _tmp95__length1;
	gfloat _tmp96_;
	RGBTransformation* _tmp97_;
	gfloat* _tmp98_;
	gint _tmp98__length1;
	gfloat _tmp99_;
	gfloat* _tmp100_;
	gint _tmp100__length1;
	gfloat _tmp101_;
	RGBTransformation* _tmp102_;
	gfloat* _tmp103_;
	gint _tmp103__length1;
	gfloat _tmp104_;
	gfloat* _tmp105_;
	gint _tmp105__length1;
	gfloat _tmp106_;
	gfloat* _tmp107_;
	gint _tmp107__length1;
	RGBTransformation* _tmp108_;
	gfloat* _tmp109_;
	gint _tmp109__length1;
	gfloat _tmp110_;
	gfloat* _tmp111_;
	gint _tmp111__length1;
	gfloat _tmp112_;
	RGBTransformation* _tmp113_;
	gfloat* _tmp114_;
	gint _tmp114__length1;
	gfloat _tmp115_;
	gfloat* _tmp116_;
	gint _tmp116__length1;
	gfloat _tmp117_;
	RGBTransformation* _tmp118_;
	gfloat* _tmp119_;
	gint _tmp119__length1;
	gfloat _tmp120_;
	gfloat* _tmp121_;
	gint _tmp121__length1;
	gfloat _tmp122_;
	RGBTransformation* _tmp123_;
	gfloat* _tmp124_;
	gint _tmp124__length1;
	gfloat _tmp125_;
	gfloat* _tmp126_;
	gint _tmp126__length1;
	gfloat _tmp127_;
	gfloat* _tmp128_;
	gint _tmp128__length1;
	RGBTransformation* _tmp129_;
	gfloat* _tmp130_;
	gint _tmp130__length1;
	gfloat _tmp131_;
	gfloat* _tmp132_;
	gint _tmp132__length1;
	gfloat _tmp133_;
	RGBTransformation* _tmp134_;
	gfloat* _tmp135_;
	gint _tmp135__length1;
	gfloat _tmp136_;
	gfloat* _tmp137_;
	gint _tmp137__length1;
	gfloat _tmp138_;
	RGBTransformation* _tmp139_;
	gfloat* _tmp140_;
	gint _tmp140__length1;
	gfloat _tmp141_;
	gfloat* _tmp142_;
	gint _tmp142__length1;
	gfloat _tmp143_;
	RGBTransformation* _tmp144_;
	gfloat* _tmp145_;
	gint _tmp145__length1;
	gfloat _tmp146_;
	gfloat* _tmp147_;
	gint _tmp147__length1;
	gfloat _tmp148_;
	gfloat* _tmp149_;
	gint _tmp149__length1;
	RGBTransformation* _tmp150_;
	gfloat* _tmp151_;
	gint _tmp151__length1;
	gfloat _tmp152_;
	gfloat* _tmp153_;
	gint _tmp153__length1;
	gfloat _tmp154_;
	RGBTransformation* _tmp155_;
	gfloat* _tmp156_;
	gint _tmp156__length1;
	gfloat _tmp157_;
	gfloat* _tmp158_;
	gint _tmp158__length1;
	gfloat _tmp159_;
	RGBTransformation* _tmp160_;
	gfloat* _tmp161_;
	gint _tmp161__length1;
	gfloat _tmp162_;
	gfloat* _tmp163_;
	gint _tmp163__length1;
	gfloat _tmp164_;
	RGBTransformation* _tmp165_;
	gfloat* _tmp166_;
	gint _tmp166__length1;
	gfloat _tmp167_;
	gfloat* _tmp168_;
	gint _tmp168__length1;
	gfloat _tmp169_;
	gfloat* _tmp170_;
	gint _tmp170__length1;
	RGBTransformation* _tmp171_;
	gfloat* _tmp172_;
	gint _tmp172__length1;
	gfloat _tmp173_;
	gfloat* _tmp174_;
	gint _tmp174__length1;
	gfloat _tmp175_;
	RGBTransformation* _tmp176_;
	gfloat* _tmp177_;
	gint _tmp177__length1;
	gfloat _tmp178_;
	gfloat* _tmp179_;
	gint _tmp179__length1;
	gfloat _tmp180_;
	RGBTransformation* _tmp181_;
	gfloat* _tmp182_;
	gint _tmp182__length1;
	gfloat _tmp183_;
	gfloat* _tmp184_;
	gint _tmp184__length1;
	gfloat _tmp185_;
	RGBTransformation* _tmp186_;
	gfloat* _tmp187_;
	gint _tmp187__length1;
	gfloat _tmp188_;
	gfloat* _tmp189_;
	gint _tmp189__length1;
	gfloat _tmp190_;
	gfloat* _tmp191_;
	gint _tmp191__length1;
	RGBTransformation* _tmp192_;
	gfloat* _tmp193_;
	gint _tmp193__length1;
	gfloat _tmp194_;
	gfloat* _tmp195_;
	gint _tmp195__length1;
	gfloat _tmp196_;
	RGBTransformation* _tmp197_;
	gfloat* _tmp198_;
	gint _tmp198__length1;
	gfloat _tmp199_;
	gfloat* _tmp200_;
	gint _tmp200__length1;
	gfloat _tmp201_;
	RGBTransformation* _tmp202_;
	gfloat* _tmp203_;
	gint _tmp203__length1;
	gfloat _tmp204_;
	gfloat* _tmp205_;
	gint _tmp205__length1;
	gfloat _tmp206_;
	RGBTransformation* _tmp207_;
	gfloat* _tmp208_;
	gint _tmp208__length1;
	gfloat _tmp209_;
	gfloat* _tmp210_;
	gint _tmp210__length1;
	gfloat _tmp211_;
	gfloat* _tmp212_;
	gint _tmp212__length1;
	RGBTransformation* _tmp213_;
	gfloat* _tmp214_;
	gint _tmp214__length1;
	gfloat _tmp215_;
	gfloat* _tmp216_;
	gint _tmp216__length1;
	gfloat _tmp217_;
	RGBTransformation* _tmp218_;
	gfloat* _tmp219_;
	gint _tmp219__length1;
	gfloat _tmp220_;
	gfloat* _tmp221_;
	gint _tmp221__length1;
	gfloat _tmp222_;
	RGBTransformation* _tmp223_;
	gfloat* _tmp224_;
	gint _tmp224__length1;
	gfloat _tmp225_;
	gfloat* _tmp226_;
	gint _tmp226__length1;
	gfloat _tmp227_;
	RGBTransformation* _tmp228_;
	gfloat* _tmp229_;
	gint _tmp229__length1;
	gfloat _tmp230_;
	gfloat* _tmp231_;
	gint _tmp231__length1;
	gfloat _tmp232_;
	gfloat* _tmp233_;
	gint _tmp233__length1;
	RGBTransformation* _tmp234_;
	gfloat* _tmp235_;
	gint _tmp235__length1;
	gfloat _tmp236_;
	gfloat* _tmp237_;
	gint _tmp237__length1;
	gfloat _tmp238_;
	RGBTransformation* _tmp239_;
	gfloat* _tmp240_;
	gint _tmp240__length1;
	gfloat _tmp241_;
	gfloat* _tmp242_;
	gint _tmp242__length1;
	gfloat _tmp243_;
	RGBTransformation* _tmp244_;
	gfloat* _tmp245_;
	gint _tmp245__length1;
	gfloat _tmp246_;
	gfloat* _tmp247_;
	gint _tmp247__length1;
	gfloat _tmp248_;
	RGBTransformation* _tmp249_;
	gfloat* _tmp250_;
	gint _tmp250__length1;
	gfloat _tmp251_;
	gfloat* _tmp252_;
	gint _tmp252__length1;
	gfloat _tmp253_;
	gfloat* _tmp254_;
	gint _tmp254__length1;
	RGBTransformation* _tmp255_;
	gfloat* _tmp256_;
	gint _tmp256__length1;
	gfloat _tmp257_;
	gfloat* _tmp258_;
	gint _tmp258__length1;
	gfloat _tmp259_;
	RGBTransformation* _tmp260_;
	gfloat* _tmp261_;
	gint _tmp261__length1;
	gfloat _tmp262_;
	gfloat* _tmp263_;
	gint _tmp263__length1;
	gfloat _tmp264_;
	RGBTransformation* _tmp265_;
	gfloat* _tmp266_;
	gint _tmp266__length1;
	gfloat _tmp267_;
	gfloat* _tmp268_;
	gint _tmp268__length1;
	gfloat _tmp269_;
	RGBTransformation* _tmp270_;
	gfloat* _tmp271_;
	gint _tmp271__length1;
	gfloat _tmp272_;
	gfloat* _tmp273_;
	gint _tmp273__length1;
	gfloat _tmp274_;
	gfloat* _tmp275_;
	gint _tmp275__length1;
	RGBTransformation* _tmp276_;
	gfloat* _tmp277_;
	gint _tmp277__length1;
	gfloat _tmp278_;
	gfloat* _tmp279_;
	gint _tmp279__length1;
	gfloat _tmp280_;
	RGBTransformation* _tmp281_;
	gfloat* _tmp282_;
	gint _tmp282__length1;
	gfloat _tmp283_;
	gfloat* _tmp284_;
	gint _tmp284__length1;
	gfloat _tmp285_;
	RGBTransformation* _tmp286_;
	gfloat* _tmp287_;
	gint _tmp287__length1;
	gfloat _tmp288_;
	gfloat* _tmp289_;
	gint _tmp289__length1;
	gfloat _tmp290_;
	RGBTransformation* _tmp291_;
	gfloat* _tmp292_;
	gint _tmp292__length1;
	gfloat _tmp293_;
	gfloat* _tmp294_;
	gint _tmp294__length1;
	gfloat _tmp295_;
	gfloat* _tmp296_;
	gint _tmp296__length1;
	RGBTransformation* _tmp297_;
	gfloat* _tmp298_;
	gint _tmp298__length1;
	gfloat _tmp299_;
	gfloat* _tmp300_;
	gint _tmp300__length1;
	gfloat _tmp301_;
	RGBTransformation* _tmp302_;
	gfloat* _tmp303_;
	gint _tmp303__length1;
	gfloat _tmp304_;
	gfloat* _tmp305_;
	gint _tmp305__length1;
	gfloat _tmp306_;
	RGBTransformation* _tmp307_;
	gfloat* _tmp308_;
	gint _tmp308__length1;
	gfloat _tmp309_;
	gfloat* _tmp310_;
	gint _tmp310__length1;
	gfloat _tmp311_;
	RGBTransformation* _tmp312_;
	gfloat* _tmp313_;
	gint _tmp313__length1;
	gfloat _tmp314_;
	gfloat* _tmp315_;
	gint _tmp315__length1;
	gfloat _tmp316_;
	gfloat* _tmp317_;
	gint _tmp317__length1;
	RGBTransformation* _tmp318_;
	gfloat* _tmp319_;
	gint _tmp319__length1;
	gfloat _tmp320_;
	gfloat* _tmp321_;
	gint _tmp321__length1;
	gfloat _tmp322_;
	RGBTransformation* _tmp323_;
	gfloat* _tmp324_;
	gint _tmp324__length1;
	gfloat _tmp325_;
	gfloat* _tmp326_;
	gint _tmp326__length1;
	gfloat _tmp327_;
	RGBTransformation* _tmp328_;
	gfloat* _tmp329_;
	gint _tmp329__length1;
	gfloat _tmp330_;
	gfloat* _tmp331_;
	gint _tmp331__length1;
	gfloat _tmp332_;
	RGBTransformation* _tmp333_;
	gfloat* _tmp334_;
	gint _tmp334__length1;
	gfloat _tmp335_;
	gfloat* _tmp336_;
	gint _tmp336__length1;
	gfloat _tmp337_;
	gboolean _tmp343_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
	if (pixel_transformation_get_composition_mode (other) != COMPOSITION_MODE_RGB_MATRIX) {
		g_error ("ColorTransformation.vala:342: %s", "RGBTransformation: compose_with( ): 'other' transformation " "does not support RGB_MATRIX composition mode");
	}
	_tmp0_ = _pixel_transformation_ref0 (G_TYPE_CHECK_INSTANCE_CAST (other, TYPE_RGB_TRANSFORMATION, RGBTransformation));
	transform = _tmp0_;
	_tmp1_ = g_new0 (gfloat, 16);
	result_matrix_entries = _tmp1_;
	result_matrix_entries_length1 = 16;
	_result_matrix_entries_size_ = result_matrix_entries_length1;
	_tmp2_ = result_matrix_entries;
	_tmp2__length1 = result_matrix_entries_length1;
	_tmp3_ = transform;
	_tmp4_ = _tmp3_->matrix_entries;
	_tmp4__length1 = _tmp3_->matrix_entries_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = self->matrix_entries;
	_tmp6__length1 = self->matrix_entries_length1;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = transform;
	_tmp9_ = _tmp8_->matrix_entries;
	_tmp9__length1 = _tmp8_->matrix_entries_length1;
	_tmp10_ = _tmp9_[1];
	_tmp11_ = self->matrix_entries;
	_tmp11__length1 = self->matrix_entries_length1;
	_tmp12_ = _tmp11_[4];
	_tmp13_ = transform;
	_tmp14_ = _tmp13_->matrix_entries;
	_tmp14__length1 = _tmp13_->matrix_entries_length1;
	_tmp15_ = _tmp14_[2];
	_tmp16_ = self->matrix_entries;
	_tmp16__length1 = self->matrix_entries_length1;
	_tmp17_ = _tmp16_[8];
	_tmp18_ = transform;
	_tmp19_ = _tmp18_->matrix_entries;
	_tmp19__length1 = _tmp18_->matrix_entries_length1;
	_tmp20_ = _tmp19_[3];
	_tmp21_ = self->matrix_entries;
	_tmp21__length1 = self->matrix_entries_length1;
	_tmp22_ = _tmp21_[12];
	_tmp2_[0] = (((_tmp5_ * _tmp7_) + (_tmp10_ * _tmp12_)) + (_tmp15_ * _tmp17_)) + (_tmp20_ * _tmp22_);
	_tmp23_ = result_matrix_entries;
	_tmp23__length1 = result_matrix_entries_length1;
	_tmp24_ = transform;
	_tmp25_ = _tmp24_->matrix_entries;
	_tmp25__length1 = _tmp24_->matrix_entries_length1;
	_tmp26_ = _tmp25_[0];
	_tmp27_ = self->matrix_entries;
	_tmp27__length1 = self->matrix_entries_length1;
	_tmp28_ = _tmp27_[1];
	_tmp29_ = transform;
	_tmp30_ = _tmp29_->matrix_entries;
	_tmp30__length1 = _tmp29_->matrix_entries_length1;
	_tmp31_ = _tmp30_[1];
	_tmp32_ = self->matrix_entries;
	_tmp32__length1 = self->matrix_entries_length1;
	_tmp33_ = _tmp32_[5];
	_tmp34_ = transform;
	_tmp35_ = _tmp34_->matrix_entries;
	_tmp35__length1 = _tmp34_->matrix_entries_length1;
	_tmp36_ = _tmp35_[2];
	_tmp37_ = self->matrix_entries;
	_tmp37__length1 = self->matrix_entries_length1;
	_tmp38_ = _tmp37_[9];
	_tmp39_ = transform;
	_tmp40_ = _tmp39_->matrix_entries;
	_tmp40__length1 = _tmp39_->matrix_entries_length1;
	_tmp41_ = _tmp40_[3];
	_tmp42_ = self->matrix_entries;
	_tmp42__length1 = self->matrix_entries_length1;
	_tmp43_ = _tmp42_[13];
	_tmp23_[1] = (((_tmp26_ * _tmp28_) + (_tmp31_ * _tmp33_)) + (_tmp36_ * _tmp38_)) + (_tmp41_ * _tmp43_);
	_tmp44_ = result_matrix_entries;
	_tmp44__length1 = result_matrix_entries_length1;
	_tmp45_ = transform;
	_tmp46_ = _tmp45_->matrix_entries;
	_tmp46__length1 = _tmp45_->matrix_entries_length1;
	_tmp47_ = _tmp46_[0];
	_tmp48_ = self->matrix_entries;
	_tmp48__length1 = self->matrix_entries_length1;
	_tmp49_ = _tmp48_[2];
	_tmp50_ = transform;
	_tmp51_ = _tmp50_->matrix_entries;
	_tmp51__length1 = _tmp50_->matrix_entries_length1;
	_tmp52_ = _tmp51_[1];
	_tmp53_ = self->matrix_entries;
	_tmp53__length1 = self->matrix_entries_length1;
	_tmp54_ = _tmp53_[6];
	_tmp55_ = transform;
	_tmp56_ = _tmp55_->matrix_entries;
	_tmp56__length1 = _tmp55_->matrix_entries_length1;
	_tmp57_ = _tmp56_[2];
	_tmp58_ = self->matrix_entries;
	_tmp58__length1 = self->matrix_entries_length1;
	_tmp59_ = _tmp58_[10];
	_tmp60_ = transform;
	_tmp61_ = _tmp60_->matrix_entries;
	_tmp61__length1 = _tmp60_->matrix_entries_length1;
	_tmp62_ = _tmp61_[3];
	_tmp63_ = self->matrix_entries;
	_tmp63__length1 = self->matrix_entries_length1;
	_tmp64_ = _tmp63_[14];
	_tmp44_[2] = (((_tmp47_ * _tmp49_) + (_tmp52_ * _tmp54_)) + (_tmp57_ * _tmp59_)) + (_tmp62_ * _tmp64_);
	_tmp65_ = result_matrix_entries;
	_tmp65__length1 = result_matrix_entries_length1;
	_tmp66_ = transform;
	_tmp67_ = _tmp66_->matrix_entries;
	_tmp67__length1 = _tmp66_->matrix_entries_length1;
	_tmp68_ = _tmp67_[0];
	_tmp69_ = self->matrix_entries;
	_tmp69__length1 = self->matrix_entries_length1;
	_tmp70_ = _tmp69_[3];
	_tmp71_ = transform;
	_tmp72_ = _tmp71_->matrix_entries;
	_tmp72__length1 = _tmp71_->matrix_entries_length1;
	_tmp73_ = _tmp72_[1];
	_tmp74_ = self->matrix_entries;
	_tmp74__length1 = self->matrix_entries_length1;
	_tmp75_ = _tmp74_[7];
	_tmp76_ = transform;
	_tmp77_ = _tmp76_->matrix_entries;
	_tmp77__length1 = _tmp76_->matrix_entries_length1;
	_tmp78_ = _tmp77_[2];
	_tmp79_ = self->matrix_entries;
	_tmp79__length1 = self->matrix_entries_length1;
	_tmp80_ = _tmp79_[11];
	_tmp81_ = transform;
	_tmp82_ = _tmp81_->matrix_entries;
	_tmp82__length1 = _tmp81_->matrix_entries_length1;
	_tmp83_ = _tmp82_[3];
	_tmp84_ = self->matrix_entries;
	_tmp84__length1 = self->matrix_entries_length1;
	_tmp85_ = _tmp84_[15];
	_tmp65_[3] = (((_tmp68_ * _tmp70_) + (_tmp73_ * _tmp75_)) + (_tmp78_ * _tmp80_)) + (_tmp83_ * _tmp85_);
	_tmp86_ = result_matrix_entries;
	_tmp86__length1 = result_matrix_entries_length1;
	_tmp87_ = transform;
	_tmp88_ = _tmp87_->matrix_entries;
	_tmp88__length1 = _tmp87_->matrix_entries_length1;
	_tmp89_ = _tmp88_[4];
	_tmp90_ = self->matrix_entries;
	_tmp90__length1 = self->matrix_entries_length1;
	_tmp91_ = _tmp90_[0];
	_tmp92_ = transform;
	_tmp93_ = _tmp92_->matrix_entries;
	_tmp93__length1 = _tmp92_->matrix_entries_length1;
	_tmp94_ = _tmp93_[5];
	_tmp95_ = self->matrix_entries;
	_tmp95__length1 = self->matrix_entries_length1;
	_tmp96_ = _tmp95_[4];
	_tmp97_ = transform;
	_tmp98_ = _tmp97_->matrix_entries;
	_tmp98__length1 = _tmp97_->matrix_entries_length1;
	_tmp99_ = _tmp98_[6];
	_tmp100_ = self->matrix_entries;
	_tmp100__length1 = self->matrix_entries_length1;
	_tmp101_ = _tmp100_[8];
	_tmp102_ = transform;
	_tmp103_ = _tmp102_->matrix_entries;
	_tmp103__length1 = _tmp102_->matrix_entries_length1;
	_tmp104_ = _tmp103_[7];
	_tmp105_ = self->matrix_entries;
	_tmp105__length1 = self->matrix_entries_length1;
	_tmp106_ = _tmp105_[12];
	_tmp86_[4] = (((_tmp89_ * _tmp91_) + (_tmp94_ * _tmp96_)) + (_tmp99_ * _tmp101_)) + (_tmp104_ * _tmp106_);
	_tmp107_ = result_matrix_entries;
	_tmp107__length1 = result_matrix_entries_length1;
	_tmp108_ = transform;
	_tmp109_ = _tmp108_->matrix_entries;
	_tmp109__length1 = _tmp108_->matrix_entries_length1;
	_tmp110_ = _tmp109_[4];
	_tmp111_ = self->matrix_entries;
	_tmp111__length1 = self->matrix_entries_length1;
	_tmp112_ = _tmp111_[1];
	_tmp113_ = transform;
	_tmp114_ = _tmp113_->matrix_entries;
	_tmp114__length1 = _tmp113_->matrix_entries_length1;
	_tmp115_ = _tmp114_[5];
	_tmp116_ = self->matrix_entries;
	_tmp116__length1 = self->matrix_entries_length1;
	_tmp117_ = _tmp116_[5];
	_tmp118_ = transform;
	_tmp119_ = _tmp118_->matrix_entries;
	_tmp119__length1 = _tmp118_->matrix_entries_length1;
	_tmp120_ = _tmp119_[6];
	_tmp121_ = self->matrix_entries;
	_tmp121__length1 = self->matrix_entries_length1;
	_tmp122_ = _tmp121_[9];
	_tmp123_ = transform;
	_tmp124_ = _tmp123_->matrix_entries;
	_tmp124__length1 = _tmp123_->matrix_entries_length1;
	_tmp125_ = _tmp124_[7];
	_tmp126_ = self->matrix_entries;
	_tmp126__length1 = self->matrix_entries_length1;
	_tmp127_ = _tmp126_[13];
	_tmp107_[5] = (((_tmp110_ * _tmp112_) + (_tmp115_ * _tmp117_)) + (_tmp120_ * _tmp122_)) + (_tmp125_ * _tmp127_);
	_tmp128_ = result_matrix_entries;
	_tmp128__length1 = result_matrix_entries_length1;
	_tmp129_ = transform;
	_tmp130_ = _tmp129_->matrix_entries;
	_tmp130__length1 = _tmp129_->matrix_entries_length1;
	_tmp131_ = _tmp130_[4];
	_tmp132_ = self->matrix_entries;
	_tmp132__length1 = self->matrix_entries_length1;
	_tmp133_ = _tmp132_[2];
	_tmp134_ = transform;
	_tmp135_ = _tmp134_->matrix_entries;
	_tmp135__length1 = _tmp134_->matrix_entries_length1;
	_tmp136_ = _tmp135_[5];
	_tmp137_ = self->matrix_entries;
	_tmp137__length1 = self->matrix_entries_length1;
	_tmp138_ = _tmp137_[6];
	_tmp139_ = transform;
	_tmp140_ = _tmp139_->matrix_entries;
	_tmp140__length1 = _tmp139_->matrix_entries_length1;
	_tmp141_ = _tmp140_[6];
	_tmp142_ = self->matrix_entries;
	_tmp142__length1 = self->matrix_entries_length1;
	_tmp143_ = _tmp142_[10];
	_tmp144_ = transform;
	_tmp145_ = _tmp144_->matrix_entries;
	_tmp145__length1 = _tmp144_->matrix_entries_length1;
	_tmp146_ = _tmp145_[7];
	_tmp147_ = self->matrix_entries;
	_tmp147__length1 = self->matrix_entries_length1;
	_tmp148_ = _tmp147_[14];
	_tmp128_[6] = (((_tmp131_ * _tmp133_) + (_tmp136_ * _tmp138_)) + (_tmp141_ * _tmp143_)) + (_tmp146_ * _tmp148_);
	_tmp149_ = result_matrix_entries;
	_tmp149__length1 = result_matrix_entries_length1;
	_tmp150_ = transform;
	_tmp151_ = _tmp150_->matrix_entries;
	_tmp151__length1 = _tmp150_->matrix_entries_length1;
	_tmp152_ = _tmp151_[4];
	_tmp153_ = self->matrix_entries;
	_tmp153__length1 = self->matrix_entries_length1;
	_tmp154_ = _tmp153_[3];
	_tmp155_ = transform;
	_tmp156_ = _tmp155_->matrix_entries;
	_tmp156__length1 = _tmp155_->matrix_entries_length1;
	_tmp157_ = _tmp156_[5];
	_tmp158_ = self->matrix_entries;
	_tmp158__length1 = self->matrix_entries_length1;
	_tmp159_ = _tmp158_[7];
	_tmp160_ = transform;
	_tmp161_ = _tmp160_->matrix_entries;
	_tmp161__length1 = _tmp160_->matrix_entries_length1;
	_tmp162_ = _tmp161_[6];
	_tmp163_ = self->matrix_entries;
	_tmp163__length1 = self->matrix_entries_length1;
	_tmp164_ = _tmp163_[11];
	_tmp165_ = transform;
	_tmp166_ = _tmp165_->matrix_entries;
	_tmp166__length1 = _tmp165_->matrix_entries_length1;
	_tmp167_ = _tmp166_[7];
	_tmp168_ = self->matrix_entries;
	_tmp168__length1 = self->matrix_entries_length1;
	_tmp169_ = _tmp168_[15];
	_tmp149_[7] = (((_tmp152_ * _tmp154_) + (_tmp157_ * _tmp159_)) + (_tmp162_ * _tmp164_)) + (_tmp167_ * _tmp169_);
	_tmp170_ = result_matrix_entries;
	_tmp170__length1 = result_matrix_entries_length1;
	_tmp171_ = transform;
	_tmp172_ = _tmp171_->matrix_entries;
	_tmp172__length1 = _tmp171_->matrix_entries_length1;
	_tmp173_ = _tmp172_[8];
	_tmp174_ = self->matrix_entries;
	_tmp174__length1 = self->matrix_entries_length1;
	_tmp175_ = _tmp174_[0];
	_tmp176_ = transform;
	_tmp177_ = _tmp176_->matrix_entries;
	_tmp177__length1 = _tmp176_->matrix_entries_length1;
	_tmp178_ = _tmp177_[9];
	_tmp179_ = self->matrix_entries;
	_tmp179__length1 = self->matrix_entries_length1;
	_tmp180_ = _tmp179_[4];
	_tmp181_ = transform;
	_tmp182_ = _tmp181_->matrix_entries;
	_tmp182__length1 = _tmp181_->matrix_entries_length1;
	_tmp183_ = _tmp182_[10];
	_tmp184_ = self->matrix_entries;
	_tmp184__length1 = self->matrix_entries_length1;
	_tmp185_ = _tmp184_[8];
	_tmp186_ = transform;
	_tmp187_ = _tmp186_->matrix_entries;
	_tmp187__length1 = _tmp186_->matrix_entries_length1;
	_tmp188_ = _tmp187_[11];
	_tmp189_ = self->matrix_entries;
	_tmp189__length1 = self->matrix_entries_length1;
	_tmp190_ = _tmp189_[12];
	_tmp170_[8] = (((_tmp173_ * _tmp175_) + (_tmp178_ * _tmp180_)) + (_tmp183_ * _tmp185_)) + (_tmp188_ * _tmp190_);
	_tmp191_ = result_matrix_entries;
	_tmp191__length1 = result_matrix_entries_length1;
	_tmp192_ = transform;
	_tmp193_ = _tmp192_->matrix_entries;
	_tmp193__length1 = _tmp192_->matrix_entries_length1;
	_tmp194_ = _tmp193_[8];
	_tmp195_ = self->matrix_entries;
	_tmp195__length1 = self->matrix_entries_length1;
	_tmp196_ = _tmp195_[1];
	_tmp197_ = transform;
	_tmp198_ = _tmp197_->matrix_entries;
	_tmp198__length1 = _tmp197_->matrix_entries_length1;
	_tmp199_ = _tmp198_[9];
	_tmp200_ = self->matrix_entries;
	_tmp200__length1 = self->matrix_entries_length1;
	_tmp201_ = _tmp200_[5];
	_tmp202_ = transform;
	_tmp203_ = _tmp202_->matrix_entries;
	_tmp203__length1 = _tmp202_->matrix_entries_length1;
	_tmp204_ = _tmp203_[10];
	_tmp205_ = self->matrix_entries;
	_tmp205__length1 = self->matrix_entries_length1;
	_tmp206_ = _tmp205_[9];
	_tmp207_ = transform;
	_tmp208_ = _tmp207_->matrix_entries;
	_tmp208__length1 = _tmp207_->matrix_entries_length1;
	_tmp209_ = _tmp208_[11];
	_tmp210_ = self->matrix_entries;
	_tmp210__length1 = self->matrix_entries_length1;
	_tmp211_ = _tmp210_[13];
	_tmp191_[9] = (((_tmp194_ * _tmp196_) + (_tmp199_ * _tmp201_)) + (_tmp204_ * _tmp206_)) + (_tmp209_ * _tmp211_);
	_tmp212_ = result_matrix_entries;
	_tmp212__length1 = result_matrix_entries_length1;
	_tmp213_ = transform;
	_tmp214_ = _tmp213_->matrix_entries;
	_tmp214__length1 = _tmp213_->matrix_entries_length1;
	_tmp215_ = _tmp214_[8];
	_tmp216_ = self->matrix_entries;
	_tmp216__length1 = self->matrix_entries_length1;
	_tmp217_ = _tmp216_[2];
	_tmp218_ = transform;
	_tmp219_ = _tmp218_->matrix_entries;
	_tmp219__length1 = _tmp218_->matrix_entries_length1;
	_tmp220_ = _tmp219_[9];
	_tmp221_ = self->matrix_entries;
	_tmp221__length1 = self->matrix_entries_length1;
	_tmp222_ = _tmp221_[6];
	_tmp223_ = transform;
	_tmp224_ = _tmp223_->matrix_entries;
	_tmp224__length1 = _tmp223_->matrix_entries_length1;
	_tmp225_ = _tmp224_[10];
	_tmp226_ = self->matrix_entries;
	_tmp226__length1 = self->matrix_entries_length1;
	_tmp227_ = _tmp226_[10];
	_tmp228_ = transform;
	_tmp229_ = _tmp228_->matrix_entries;
	_tmp229__length1 = _tmp228_->matrix_entries_length1;
	_tmp230_ = _tmp229_[11];
	_tmp231_ = self->matrix_entries;
	_tmp231__length1 = self->matrix_entries_length1;
	_tmp232_ = _tmp231_[14];
	_tmp212_[10] = (((_tmp215_ * _tmp217_) + (_tmp220_ * _tmp222_)) + (_tmp225_ * _tmp227_)) + (_tmp230_ * _tmp232_);
	_tmp233_ = result_matrix_entries;
	_tmp233__length1 = result_matrix_entries_length1;
	_tmp234_ = transform;
	_tmp235_ = _tmp234_->matrix_entries;
	_tmp235__length1 = _tmp234_->matrix_entries_length1;
	_tmp236_ = _tmp235_[8];
	_tmp237_ = self->matrix_entries;
	_tmp237__length1 = self->matrix_entries_length1;
	_tmp238_ = _tmp237_[3];
	_tmp239_ = transform;
	_tmp240_ = _tmp239_->matrix_entries;
	_tmp240__length1 = _tmp239_->matrix_entries_length1;
	_tmp241_ = _tmp240_[9];
	_tmp242_ = self->matrix_entries;
	_tmp242__length1 = self->matrix_entries_length1;
	_tmp243_ = _tmp242_[7];
	_tmp244_ = transform;
	_tmp245_ = _tmp244_->matrix_entries;
	_tmp245__length1 = _tmp244_->matrix_entries_length1;
	_tmp246_ = _tmp245_[10];
	_tmp247_ = self->matrix_entries;
	_tmp247__length1 = self->matrix_entries_length1;
	_tmp248_ = _tmp247_[11];
	_tmp249_ = transform;
	_tmp250_ = _tmp249_->matrix_entries;
	_tmp250__length1 = _tmp249_->matrix_entries_length1;
	_tmp251_ = _tmp250_[11];
	_tmp252_ = self->matrix_entries;
	_tmp252__length1 = self->matrix_entries_length1;
	_tmp253_ = _tmp252_[15];
	_tmp233_[11] = (((_tmp236_ * _tmp238_) + (_tmp241_ * _tmp243_)) + (_tmp246_ * _tmp248_)) + (_tmp251_ * _tmp253_);
	_tmp254_ = result_matrix_entries;
	_tmp254__length1 = result_matrix_entries_length1;
	_tmp255_ = transform;
	_tmp256_ = _tmp255_->matrix_entries;
	_tmp256__length1 = _tmp255_->matrix_entries_length1;
	_tmp257_ = _tmp256_[12];
	_tmp258_ = self->matrix_entries;
	_tmp258__length1 = self->matrix_entries_length1;
	_tmp259_ = _tmp258_[0];
	_tmp260_ = transform;
	_tmp261_ = _tmp260_->matrix_entries;
	_tmp261__length1 = _tmp260_->matrix_entries_length1;
	_tmp262_ = _tmp261_[13];
	_tmp263_ = self->matrix_entries;
	_tmp263__length1 = self->matrix_entries_length1;
	_tmp264_ = _tmp263_[4];
	_tmp265_ = transform;
	_tmp266_ = _tmp265_->matrix_entries;
	_tmp266__length1 = _tmp265_->matrix_entries_length1;
	_tmp267_ = _tmp266_[14];
	_tmp268_ = self->matrix_entries;
	_tmp268__length1 = self->matrix_entries_length1;
	_tmp269_ = _tmp268_[8];
	_tmp270_ = transform;
	_tmp271_ = _tmp270_->matrix_entries;
	_tmp271__length1 = _tmp270_->matrix_entries_length1;
	_tmp272_ = _tmp271_[15];
	_tmp273_ = self->matrix_entries;
	_tmp273__length1 = self->matrix_entries_length1;
	_tmp274_ = _tmp273_[12];
	_tmp254_[12] = (((_tmp257_ * _tmp259_) + (_tmp262_ * _tmp264_)) + (_tmp267_ * _tmp269_)) + (_tmp272_ * _tmp274_);
	_tmp275_ = result_matrix_entries;
	_tmp275__length1 = result_matrix_entries_length1;
	_tmp276_ = transform;
	_tmp277_ = _tmp276_->matrix_entries;
	_tmp277__length1 = _tmp276_->matrix_entries_length1;
	_tmp278_ = _tmp277_[12];
	_tmp279_ = self->matrix_entries;
	_tmp279__length1 = self->matrix_entries_length1;
	_tmp280_ = _tmp279_[1];
	_tmp281_ = transform;
	_tmp282_ = _tmp281_->matrix_entries;
	_tmp282__length1 = _tmp281_->matrix_entries_length1;
	_tmp283_ = _tmp282_[13];
	_tmp284_ = self->matrix_entries;
	_tmp284__length1 = self->matrix_entries_length1;
	_tmp285_ = _tmp284_[5];
	_tmp286_ = transform;
	_tmp287_ = _tmp286_->matrix_entries;
	_tmp287__length1 = _tmp286_->matrix_entries_length1;
	_tmp288_ = _tmp287_[14];
	_tmp289_ = self->matrix_entries;
	_tmp289__length1 = self->matrix_entries_length1;
	_tmp290_ = _tmp289_[9];
	_tmp291_ = transform;
	_tmp292_ = _tmp291_->matrix_entries;
	_tmp292__length1 = _tmp291_->matrix_entries_length1;
	_tmp293_ = _tmp292_[15];
	_tmp294_ = self->matrix_entries;
	_tmp294__length1 = self->matrix_entries_length1;
	_tmp295_ = _tmp294_[13];
	_tmp275_[13] = (((_tmp278_ * _tmp280_) + (_tmp283_ * _tmp285_)) + (_tmp288_ * _tmp290_)) + (_tmp293_ * _tmp295_);
	_tmp296_ = result_matrix_entries;
	_tmp296__length1 = result_matrix_entries_length1;
	_tmp297_ = transform;
	_tmp298_ = _tmp297_->matrix_entries;
	_tmp298__length1 = _tmp297_->matrix_entries_length1;
	_tmp299_ = _tmp298_[12];
	_tmp300_ = self->matrix_entries;
	_tmp300__length1 = self->matrix_entries_length1;
	_tmp301_ = _tmp300_[2];
	_tmp302_ = transform;
	_tmp303_ = _tmp302_->matrix_entries;
	_tmp303__length1 = _tmp302_->matrix_entries_length1;
	_tmp304_ = _tmp303_[13];
	_tmp305_ = self->matrix_entries;
	_tmp305__length1 = self->matrix_entries_length1;
	_tmp306_ = _tmp305_[6];
	_tmp307_ = transform;
	_tmp308_ = _tmp307_->matrix_entries;
	_tmp308__length1 = _tmp307_->matrix_entries_length1;
	_tmp309_ = _tmp308_[14];
	_tmp310_ = self->matrix_entries;
	_tmp310__length1 = self->matrix_entries_length1;
	_tmp311_ = _tmp310_[10];
	_tmp312_ = transform;
	_tmp313_ = _tmp312_->matrix_entries;
	_tmp313__length1 = _tmp312_->matrix_entries_length1;
	_tmp314_ = _tmp313_[15];
	_tmp315_ = self->matrix_entries;
	_tmp315__length1 = self->matrix_entries_length1;
	_tmp316_ = _tmp315_[14];
	_tmp296_[14] = (((_tmp299_ * _tmp301_) + (_tmp304_ * _tmp306_)) + (_tmp309_ * _tmp311_)) + (_tmp314_ * _tmp316_);
	_tmp317_ = result_matrix_entries;
	_tmp317__length1 = result_matrix_entries_length1;
	_tmp318_ = transform;
	_tmp319_ = _tmp318_->matrix_entries;
	_tmp319__length1 = _tmp318_->matrix_entries_length1;
	_tmp320_ = _tmp319_[12];
	_tmp321_ = self->matrix_entries;
	_tmp321__length1 = self->matrix_entries_length1;
	_tmp322_ = _tmp321_[3];
	_tmp323_ = transform;
	_tmp324_ = _tmp323_->matrix_entries;
	_tmp324__length1 = _tmp323_->matrix_entries_length1;
	_tmp325_ = _tmp324_[13];
	_tmp326_ = self->matrix_entries;
	_tmp326__length1 = self->matrix_entries_length1;
	_tmp327_ = _tmp326_[7];
	_tmp328_ = transform;
	_tmp329_ = _tmp328_->matrix_entries;
	_tmp329__length1 = _tmp328_->matrix_entries_length1;
	_tmp330_ = _tmp329_[14];
	_tmp331_ = self->matrix_entries;
	_tmp331__length1 = self->matrix_entries_length1;
	_tmp332_ = _tmp331_[11];
	_tmp333_ = transform;
	_tmp334_ = _tmp333_->matrix_entries;
	_tmp334__length1 = _tmp333_->matrix_entries_length1;
	_tmp335_ = _tmp334_[15];
	_tmp336_ = self->matrix_entries;
	_tmp336__length1 = self->matrix_entries_length1;
	_tmp337_ = _tmp336_[15];
	_tmp317_[15] = (((_tmp320_ * _tmp322_) + (_tmp325_ * _tmp327_)) + (_tmp330_ * _tmp332_)) + (_tmp335_ * _tmp337_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp338_ = FALSE;
			_tmp338_ = TRUE;
			while (TRUE) {
				gfloat* _tmp340_;
				gint _tmp340__length1;
				gfloat* _tmp341_;
				gint _tmp341__length1;
				gfloat _tmp342_;
				if (!_tmp338_) {
					gint _tmp339_;
					_tmp339_ = i;
					i = _tmp339_ + 1;
				}
				_tmp338_ = FALSE;
				if (!(i < RGB_TRANSFORMATION_MATRIX_SIZE)) {
					break;
				}
				_tmp340_ = self->matrix_entries;
				_tmp340__length1 = self->matrix_entries_length1;
				_tmp341_ = result_matrix_entries;
				_tmp341__length1 = result_matrix_entries_length1;
				_tmp342_ = _tmp341_[i];
				_tmp340_[i] = _tmp342_;
			}
		}
	}
	if (self->identity) {
		RGBTransformation* _tmp344_;
		_tmp344_ = transform;
		_tmp343_ = _tmp344_->identity;
	} else {
		_tmp343_ = FALSE;
	}
	self->identity = _tmp343_;
	result_matrix_entries = (g_free (result_matrix_entries), NULL);
	_pixel_transformation_unref0 (transform);
}

static void
rgb_transformation_real_transform_pixel_hsv (PixelTransformation* base,
                                             HSVAnalyticPixel* p,
                                             HSVAnalyticPixel* result)
{
	RGBTransformation * self;
	RGBAnalyticPixel _tmp0_ = {0};
	RGBAnalyticPixel _tmp1_ = {0};
	HSVAnalyticPixel _tmp2_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
	hsv_analytic_pixel_to_rgb (p, &_tmp0_);
	pixel_transformation_transform_pixel_rgb (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation), &_tmp0_, &_tmp1_);
	rgb_analytic_pixel_to_hsv (&_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

static gboolean
rgb_transformation_real_is_identity (PixelTransformation* base)
{
	RGBTransformation * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
	result = self->identity;
	return result;
}

static PixelTransformation*
rgb_transformation_real_copy (PixelTransformation* base)
{
	RGBTransformation * self;
	RGBTransformation* _result_ = NULL;
	RGBTransformation* _tmp0_;
	PixelTransformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
	_tmp0_ = rgb_transformation_new (pixel_transformation_get_transformation_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation)));
	_result_ = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				RGBTransformation* _tmp3_;
				gfloat* _tmp4_;
				gint _tmp4__length1;
				gfloat* _tmp5_;
				gint _tmp5__length1;
				gfloat _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < RGB_TRANSFORMATION_MATRIX_SIZE)) {
					break;
				}
				_tmp3_ = _result_;
				_tmp4_ = _tmp3_->matrix_entries;
				_tmp4__length1 = _tmp3_->matrix_entries_length1;
				_tmp5_ = self->matrix_entries;
				_tmp5__length1 = self->matrix_entries_length1;
				_tmp6_ = _tmp5_[i];
				_tmp4_[i] = _tmp6_;
			}
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
	return result;
}

static void
rgb_transformation_class_init (RGBTransformationClass * klass,
                               gpointer klass_data)
{
	rgb_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = rgb_transformation_finalize;
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*) (PixelTransformation*)) rgb_transformation_real_get_composition_mode;
	((PixelTransformationClass *) klass)->compose_with = (void (*) (PixelTransformation*, PixelTransformation*)) rgb_transformation_real_compose_with;
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*) (PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) rgb_transformation_real_transform_pixel_hsv;
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*) (PixelTransformation*, RGBAnalyticPixel*, RGBAnalyticPixel*)) rgb_transformation_real_transform_pixel_rgb;
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation*)) rgb_transformation_real_is_identity;
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation*)) rgb_transformation_real_copy;
}

static void
rgb_transformation_instance_init (RGBTransformation * self,
                                  gpointer klass)
{
	self->identity = TRUE;
}

static void
rgb_transformation_finalize (PixelTransformation * obj)
{
	RGBTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_TRANSFORMATION, RGBTransformation);
	self->matrix_entries = (g_free (self->matrix_entries), NULL);
	PIXEL_TRANSFORMATION_CLASS (rgb_transformation_parent_class)->finalize (obj);
}

static GType
rgb_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RGBTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBTransformation), 0, (GInstanceInitFunc) rgb_transformation_instance_init, NULL };
	GType rgb_transformation_type_id;
	rgb_transformation_type_id = g_type_register_static (TYPE_PIXEL_TRANSFORMATION, "RGBTransformation", &g_define_type_info, 0);
	return rgb_transformation_type_id;
}

GType
rgb_transformation_get_type (void)
{
	static volatile gsize rgb_transformation_type_id__once = 0;
	if (g_once_init_enter (&rgb_transformation_type_id__once)) {
		GType rgb_transformation_type_id;
		rgb_transformation_type_id = rgb_transformation_get_type_once ();
		g_once_init_leave (&rgb_transformation_type_id__once, rgb_transformation_type_id);
	}
	return rgb_transformation_type_id__once;
}

HSVTransformation*
hsv_transformation_construct (GType object_type,
                              PixelTransformationType type)
{
	HSVTransformation* self = NULL;
	self = (HSVTransformation*) pixel_transformation_construct (object_type, type, PIXEL_FORMAT_HSV);
	return self;
}

static CompositionMode
hsv_transformation_real_get_composition_mode (PixelTransformation* base)
{
	HSVTransformation * self;
	CompositionMode result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
	result = COMPOSITION_MODE_HSV_LOOKUP;
	return result;
}

static void
hsv_transformation_real_transform_pixel_rgb (PixelTransformation* base,
                                             RGBAnalyticPixel* p,
                                             RGBAnalyticPixel* result)
{
	HSVTransformation * self;
	HSVAnalyticPixel _tmp0_ = {0};
	HSVAnalyticPixel _tmp1_ = {0};
	RGBAnalyticPixel _tmp2_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
	rgb_analytic_pixel_to_hsv (p, &_tmp0_);
	pixel_transformation_transform_pixel_hsv (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation), &_tmp0_, &_tmp1_);
	hsv_analytic_pixel_to_rgb (&_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

static void
hsv_transformation_real_compose_with (PixelTransformation* base,
                                      PixelTransformation* other)
{
	HSVTransformation * self;
	HSVTransformation* hsv_trans = NULL;
	HSVTransformation* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
	if (pixel_transformation_get_composition_mode (other) != COMPOSITION_MODE_HSV_LOOKUP) {
		g_error ("ColorTransformation.vala:493: HSVTransformation: compose_with(): wrong");
	}
	_tmp0_ = _pixel_transformation_ref0 (G_TYPE_CHECK_INSTANCE_CAST (other, TYPE_HSV_TRANSFORMATION, HSVTransformation));
	hsv_trans = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint idx = 0;
				gfloat _tmp3_;
				HSVTransformation* _tmp4_;
				gfloat _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				_tmp3_ = self->remap_table[i];
				idx = (gint) (_tmp3_ * 255.0f);
				_tmp4_ = hsv_trans;
				_tmp5_ = _tmp4_->remap_table[idx];
				self->remap_table[i] = CLAMP (_tmp5_, 0.0f, 1.0f);
			}
		}
	}
	_pixel_transformation_unref0 (hsv_trans);
}

static void
hsv_transformation_real_transform_pixel_hsv (PixelTransformation* base,
                                             HSVAnalyticPixel* pixel,
                                             HSVAnalyticPixel* result)
{
	HSVTransformation * self;
	gint remap_index = 0;
	HSVAnalyticPixel _tmp0_;
	HSVAnalyticPixel _result_ = {0};
	HSVAnalyticPixel _tmp1_;
	gfloat _tmp2_;
	HSVAnalyticPixel _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
	_tmp0_ = *pixel;
	remap_index = (gint) (_tmp0_.light_value * 255.0f);
	_tmp1_ = *pixel;
	_result_ = _tmp1_;
	_tmp2_ = self->remap_table[remap_index];
	_result_.light_value = _tmp2_;
	_tmp3_ = _result_;
	_result_.light_value = CLAMP (_tmp3_.light_value, 0.0f, 1.0f);
	*result = _result_;
	return;
}

static void
hsv_transformation_class_init (HSVTransformationClass * klass,
                               gpointer klass_data)
{
	hsv_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = hsv_transformation_finalize;
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*) (PixelTransformation*)) hsv_transformation_real_get_composition_mode;
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*) (PixelTransformation*, RGBAnalyticPixel*, RGBAnalyticPixel*)) hsv_transformation_real_transform_pixel_rgb;
	((PixelTransformationClass *) klass)->compose_with = (void (*) (PixelTransformation*, PixelTransformation*)) hsv_transformation_real_compose_with;
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*) (PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) hsv_transformation_real_transform_pixel_hsv;
}

static void
hsv_transformation_instance_init (HSVTransformation * self,
                                  gpointer klass)
{
}

static void
hsv_transformation_finalize (PixelTransformation * obj)
{
	HSVTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HSV_TRANSFORMATION, HSVTransformation);
	PIXEL_TRANSFORMATION_CLASS (hsv_transformation_parent_class)->finalize (obj);
}

static GType
hsv_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HSVTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hsv_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HSVTransformation), 0, (GInstanceInitFunc) hsv_transformation_instance_init, NULL };
	GType hsv_transformation_type_id;
	hsv_transformation_type_id = g_type_register_static (TYPE_PIXEL_TRANSFORMATION, "HSVTransformation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return hsv_transformation_type_id;
}

GType
hsv_transformation_get_type (void)
{
	static volatile gsize hsv_transformation_type_id__once = 0;
	if (g_once_init_enter (&hsv_transformation_type_id__once)) {
		GType hsv_transformation_type_id;
		hsv_transformation_type_id = hsv_transformation_get_type_once ();
		g_once_init_leave (&hsv_transformation_type_id__once, hsv_transformation_type_id);
	}
	return hsv_transformation_type_id__once;
}

static inline gpointer
tint_transformation_get_instance_private (TintTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, TintTransformation_private_offset);
}

TintTransformation*
tint_transformation_construct (GType object_type,
                               gfloat client_param)
{
	TintTransformation* self = NULL;
	self = (TintTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TINT);
	self->priv->parameter = CLAMP (client_param, TINT_TRANSFORMATION_MIN_PARAMETER, TINT_TRANSFORMATION_MAX_PARAMETER);
	if (self->priv->parameter != 0.0f) {
		gfloat adjusted_param = 0.0F;
		gfloat* _tmp0_;
		gint _tmp0__length1;
		gfloat* _tmp1_;
		gint _tmp1__length1;
		gfloat* _tmp2_;
		gint _tmp2__length1;
		adjusted_param = self->priv->parameter / TINT_TRANSFORMATION_MAX_PARAMETER;
		adjusted_param *= TINT_TRANSFORMATION_INTENSITY_FACTOR;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp0__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp0_[11] -= adjusted_param / 2;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp1__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp1_[7] += adjusted_param;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp2__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp2_[3] -= adjusted_param / 2;
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
	}
	return self;
}

TintTransformation*
tint_transformation_new (gfloat client_param)
{
	return tint_transformation_construct (TYPE_TINT_TRANSFORMATION, client_param);
}

gfloat
tint_transformation_get_parameter (TintTransformation* self)
{
	gfloat result;
	result = self->priv->parameter;
	return result;
}

static void
tint_transformation_class_init (TintTransformationClass * klass,
                                gpointer klass_data)
{
	tint_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = tint_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &TintTransformation_private_offset);
}

static void
tint_transformation_instance_init (TintTransformation * self,
                                   gpointer klass)
{
	self->priv = tint_transformation_get_instance_private (self);
}

static void
tint_transformation_finalize (PixelTransformation * obj)
{
	TintTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TINT_TRANSFORMATION, TintTransformation);
	PIXEL_TRANSFORMATION_CLASS (tint_transformation_parent_class)->finalize (obj);
}

static GType
tint_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TintTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tint_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TintTransformation), 0, (GInstanceInitFunc) tint_transformation_instance_init, NULL };
	GType tint_transformation_type_id;
	tint_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "TintTransformation", &g_define_type_info, 0);
	TintTransformation_private_offset = g_type_add_instance_private (tint_transformation_type_id, sizeof (TintTransformationPrivate));
	return tint_transformation_type_id;
}

GType
tint_transformation_get_type (void)
{
	static volatile gsize tint_transformation_type_id__once = 0;
	if (g_once_init_enter (&tint_transformation_type_id__once)) {
		GType tint_transformation_type_id;
		tint_transformation_type_id = tint_transformation_get_type_once ();
		g_once_init_leave (&tint_transformation_type_id__once, tint_transformation_type_id);
	}
	return tint_transformation_type_id__once;
}

static inline gpointer
temperature_transformation_get_instance_private (TemperatureTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, TemperatureTransformation_private_offset);
}

TemperatureTransformation*
temperature_transformation_construct (GType object_type,
                                      gfloat client_parameter)
{
	TemperatureTransformation* self = NULL;
	self = (TemperatureTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TEMPERATURE);
	self->priv->parameter = CLAMP (client_parameter, TEMPERATURE_TRANSFORMATION_MIN_PARAMETER, TEMPERATURE_TRANSFORMATION_MAX_PARAMETER);
	if (self->priv->parameter != 0.0f) {
		gfloat adjusted_param = 0.0F;
		gfloat* _tmp0_;
		gint _tmp0__length1;
		gfloat* _tmp1_;
		gint _tmp1__length1;
		gfloat* _tmp2_;
		gint _tmp2__length1;
		adjusted_param = self->priv->parameter / TEMPERATURE_TRANSFORMATION_MAX_PARAMETER;
		adjusted_param *= TEMPERATURE_TRANSFORMATION_INTENSITY_FACTOR;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp0__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp0_[11] -= adjusted_param;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp1__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp1_[7] += adjusted_param / 2;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp2__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp2_[3] += adjusted_param / 2;
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
	}
	return self;
}

TemperatureTransformation*
temperature_transformation_new (gfloat client_parameter)
{
	return temperature_transformation_construct (TYPE_TEMPERATURE_TRANSFORMATION, client_parameter);
}

gfloat
temperature_transformation_get_parameter (TemperatureTransformation* self)
{
	gfloat result;
	result = self->priv->parameter;
	return result;
}

static void
temperature_transformation_class_init (TemperatureTransformationClass * klass,
                                       gpointer klass_data)
{
	temperature_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = temperature_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &TemperatureTransformation_private_offset);
}

static void
temperature_transformation_instance_init (TemperatureTransformation * self,
                                          gpointer klass)
{
	self->priv = temperature_transformation_get_instance_private (self);
}

static void
temperature_transformation_finalize (PixelTransformation * obj)
{
	TemperatureTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation);
	PIXEL_TRANSFORMATION_CLASS (temperature_transformation_parent_class)->finalize (obj);
}

static GType
temperature_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TemperatureTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) temperature_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TemperatureTransformation), 0, (GInstanceInitFunc) temperature_transformation_instance_init, NULL };
	GType temperature_transformation_type_id;
	temperature_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "TemperatureTransformation", &g_define_type_info, 0);
	TemperatureTransformation_private_offset = g_type_add_instance_private (temperature_transformation_type_id, sizeof (TemperatureTransformationPrivate));
	return temperature_transformation_type_id;
}

GType
temperature_transformation_get_type (void)
{
	static volatile gsize temperature_transformation_type_id__once = 0;
	if (g_once_init_enter (&temperature_transformation_type_id__once)) {
		GType temperature_transformation_type_id;
		temperature_transformation_type_id = temperature_transformation_get_type_once ();
		g_once_init_leave (&temperature_transformation_type_id__once, temperature_transformation_type_id);
	}
	return temperature_transformation_type_id__once;
}

static inline gpointer
saturation_transformation_get_instance_private (SaturationTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, SaturationTransformation_private_offset);
}

SaturationTransformation*
saturation_transformation_construct (GType object_type,
                                     gfloat client_parameter)
{
	SaturationTransformation* self = NULL;
	self = (SaturationTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_SATURATION);
	self->priv->parameter = CLAMP (client_parameter, SATURATION_TRANSFORMATION_MIN_PARAMETER, SATURATION_TRANSFORMATION_MAX_PARAMETER);
	if (self->priv->parameter != 0.0f) {
		gfloat adjusted_param = 0.0F;
		gfloat one_third = 0.0F;
		gfloat* _tmp0_;
		gint _tmp0__length1;
		gfloat* _tmp1_;
		gint _tmp1__length1;
		gfloat* _tmp2_;
		gint _tmp2__length1;
		gfloat* _tmp3_;
		gint _tmp3__length1;
		gfloat* _tmp4_;
		gint _tmp4__length1;
		gfloat* _tmp5_;
		gint _tmp5__length1;
		gfloat* _tmp6_;
		gint _tmp6__length1;
		gfloat* _tmp7_;
		gint _tmp7__length1;
		gfloat* _tmp8_;
		gint _tmp8__length1;
		adjusted_param = self->priv->parameter / SATURATION_TRANSFORMATION_MAX_PARAMETER;
		adjusted_param += 1.0f;
		one_third = 0.3333333f;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp0__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp0_[0] = ((1.0f - adjusted_param) * one_third) + adjusted_param;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp1__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp1_[1] = (1.0f - adjusted_param) * one_third;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp2__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp2_[2] = (1.0f - adjusted_param) * one_third;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp3__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp3_[4] = (1.0f - adjusted_param) * one_third;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp4__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp4_[5] = ((1.0f - adjusted_param) * one_third) + adjusted_param;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp5_[6] = (1.0f - adjusted_param) * one_third;
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp6__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp6_[8] = (1.0f - adjusted_param) * one_third;
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp7__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp7_[9] = (1.0f - adjusted_param) * one_third;
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp8__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp8_[10] = ((1.0f - adjusted_param) * one_third) + adjusted_param;
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
	}
	return self;
}

SaturationTransformation*
saturation_transformation_new (gfloat client_parameter)
{
	return saturation_transformation_construct (TYPE_SATURATION_TRANSFORMATION, client_parameter);
}

gfloat
saturation_transformation_get_parameter (SaturationTransformation* self)
{
	gfloat result;
	result = self->priv->parameter;
	return result;
}

static void
saturation_transformation_class_init (SaturationTransformationClass * klass,
                                      gpointer klass_data)
{
	saturation_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = saturation_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &SaturationTransformation_private_offset);
}

static void
saturation_transformation_instance_init (SaturationTransformation * self,
                                         gpointer klass)
{
	self->priv = saturation_transformation_get_instance_private (self);
}

static void
saturation_transformation_finalize (PixelTransformation * obj)
{
	SaturationTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SATURATION_TRANSFORMATION, SaturationTransformation);
	PIXEL_TRANSFORMATION_CLASS (saturation_transformation_parent_class)->finalize (obj);
}

static GType
saturation_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SaturationTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saturation_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SaturationTransformation), 0, (GInstanceInitFunc) saturation_transformation_instance_init, NULL };
	GType saturation_transformation_type_id;
	saturation_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "SaturationTransformation", &g_define_type_info, 0);
	SaturationTransformation_private_offset = g_type_add_instance_private (saturation_transformation_type_id, sizeof (SaturationTransformationPrivate));
	return saturation_transformation_type_id;
}

GType
saturation_transformation_get_type (void)
{
	static volatile gsize saturation_transformation_type_id__once = 0;
	if (g_once_init_enter (&saturation_transformation_type_id__once)) {
		GType saturation_transformation_type_id;
		saturation_transformation_type_id = saturation_transformation_get_type_once ();
		g_once_init_leave (&saturation_transformation_type_id__once, saturation_transformation_type_id);
	}
	return saturation_transformation_type_id__once;
}

static inline gpointer
exposure_transformation_get_instance_private (ExposureTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, ExposureTransformation_private_offset);
}

ExposureTransformation*
exposure_transformation_construct (GType object_type,
                                   gfloat client_parameter)
{
	ExposureTransformation* self = NULL;
	self = (ExposureTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_EXPOSURE);
	self->priv->parameter = CLAMP (client_parameter, EXPOSURE_TRANSFORMATION_MIN_PARAMETER, EXPOSURE_TRANSFORMATION_MAX_PARAMETER);
	if (self->priv->parameter != 0.0f) {
		gfloat adjusted_param = 0.0F;
		gfloat* _tmp0_;
		gint _tmp0__length1;
		gfloat* _tmp1_;
		gint _tmp1__length1;
		gfloat* _tmp2_;
		gint _tmp2__length1;
		adjusted_param = ((self->priv->parameter + 16.0f) / 32.0f) + 0.5f;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp0__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp0_[0] = adjusted_param;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp1__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp1_[5] = adjusted_param;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp2__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp2_[10] = adjusted_param;
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
	}
	return self;
}

ExposureTransformation*
exposure_transformation_new (gfloat client_parameter)
{
	return exposure_transformation_construct (TYPE_EXPOSURE_TRANSFORMATION, client_parameter);
}

gfloat
exposure_transformation_get_parameter (ExposureTransformation* self)
{
	gfloat result;
	result = self->priv->parameter;
	return result;
}

static void
exposure_transformation_class_init (ExposureTransformationClass * klass,
                                    gpointer klass_data)
{
	exposure_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = exposure_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &ExposureTransformation_private_offset);
}

static void
exposure_transformation_instance_init (ExposureTransformation * self,
                                       gpointer klass)
{
	self->priv = exposure_transformation_get_instance_private (self);
}

static void
exposure_transformation_finalize (PixelTransformation * obj)
{
	ExposureTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation);
	PIXEL_TRANSFORMATION_CLASS (exposure_transformation_parent_class)->finalize (obj);
}

static GType
exposure_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExposureTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exposure_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExposureTransformation), 0, (GInstanceInitFunc) exposure_transformation_instance_init, NULL };
	GType exposure_transformation_type_id;
	exposure_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "ExposureTransformation", &g_define_type_info, 0);
	ExposureTransformation_private_offset = g_type_add_instance_private (exposure_transformation_type_id, sizeof (ExposureTransformationPrivate));
	return exposure_transformation_type_id;
}

GType
exposure_transformation_get_type (void)
{
	static volatile gsize exposure_transformation_type_id__once = 0;
	if (g_once_init_enter (&exposure_transformation_type_id__once)) {
		GType exposure_transformation_type_id;
		exposure_transformation_type_id = exposure_transformation_get_type_once ();
		g_once_init_leave (&exposure_transformation_type_id__once, exposure_transformation_type_id);
	}
	return exposure_transformation_type_id__once;
}

static inline gpointer
contrast_transformation_get_instance_private (ContrastTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, ContrastTransformation_private_offset);
}

ContrastTransformation*
contrast_transformation_construct (GType object_type,
                                   gfloat client_parameter)
{
	ContrastTransformation* self = NULL;
	self = (ContrastTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_CONTRAST);
	self->priv->parameter = CLAMP (client_parameter, CONTRAST_TRANSFORMATION_MIN_PARAMETER, CONTRAST_TRANSFORMATION_MAX_PARAMETER);
	if (self->priv->parameter != 0.0f) {
		gfloat contrast_adjustment = 0.0F;
		gfloat component_coefficient = 0.0F;
		gfloat component_offset = 0.0F;
		gfloat* _tmp0_;
		gint _tmp0__length1;
		gfloat* _tmp1_;
		gint _tmp1__length1;
		gfloat* _tmp2_;
		gint _tmp2__length1;
		gfloat* _tmp3_;
		gint _tmp3__length1;
		gfloat* _tmp4_;
		gint _tmp4__length1;
		gfloat* _tmp5_;
		gint _tmp5__length1;
		contrast_adjustment = (self->priv->parameter / 16.0f) * CONTRAST_TRANSFORMATION_MAX_CONTRAST_ADJUSTMENT;
		component_coefficient = 1.0f + contrast_adjustment;
		component_offset = contrast_adjustment / (-2.0f);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp0__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp0_[0] = component_coefficient;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp1__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp1_[5] = component_coefficient;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp2__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp2_[10] = component_coefficient;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp3__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp3_[3] = component_offset;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp4__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp4_[7] = component_offset;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
		_tmp5_[11] = component_offset;
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
	}
	return self;
}

ContrastTransformation*
contrast_transformation_new (gfloat client_parameter)
{
	return contrast_transformation_construct (TYPE_CONTRAST_TRANSFORMATION, client_parameter);
}

gfloat
contrast_transformation_get_parameter (ContrastTransformation* self)
{
	gfloat result;
	result = self->priv->parameter;
	return result;
}

static void
contrast_transformation_class_init (ContrastTransformationClass * klass,
                                    gpointer klass_data)
{
	contrast_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = contrast_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &ContrastTransformation_private_offset);
}

static void
contrast_transformation_instance_init (ContrastTransformation * self,
                                       gpointer klass)
{
	self->priv = contrast_transformation_get_instance_private (self);
}

static void
contrast_transformation_finalize (PixelTransformation * obj)
{
	ContrastTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation);
	PIXEL_TRANSFORMATION_CLASS (contrast_transformation_parent_class)->finalize (obj);
}

static GType
contrast_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContrastTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contrast_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContrastTransformation), 0, (GInstanceInitFunc) contrast_transformation_instance_init, NULL };
	GType contrast_transformation_type_id;
	contrast_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "ContrastTransformation", &g_define_type_info, 0);
	ContrastTransformation_private_offset = g_type_add_instance_private (contrast_transformation_type_id, sizeof (ContrastTransformationPrivate));
	return contrast_transformation_type_id;
}

GType
contrast_transformation_get_type (void)
{
	static volatile gsize contrast_transformation_type_id__once = 0;
	if (g_once_init_enter (&contrast_transformation_type_id__once)) {
		GType contrast_transformation_type_id;
		contrast_transformation_type_id = contrast_transformation_get_type_once ();
		g_once_init_leave (&contrast_transformation_type_id__once, contrast_transformation_type_id);
	}
	return contrast_transformation_type_id__once;
}

static inline gpointer
pixel_transformer_get_instance_private (PixelTransformer* self)
{
	return G_STRUCT_MEMBER_P (self, PixelTransformer_private_offset);
}

PixelTransformer*
pixel_transformer_construct (GType object_type)
{
	PixelTransformer* self = NULL;
	self = (PixelTransformer*) g_type_create_instance (object_type);
	return self;
}

PixelTransformer*
pixel_transformer_new (void)
{
	return pixel_transformer_construct (TYPE_PIXEL_TRANSFORMER);
}

PixelTransformer*
pixel_transformer_copy (PixelTransformer* self)
{
	PixelTransformer* clone = NULL;
	PixelTransformer* _tmp0_;
	PixelTransformer* result;
	_tmp0_ = pixel_transformer_new ();
	clone = _tmp0_;
	{
		GeeArrayList* _transformation_list = NULL;
		GeeArrayList* _tmp1_;
		gint _transformation_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _transformation_index = 0;
		_tmp1_ = self->priv->transformations;
		_transformation_list = _tmp1_;
		_tmp2_ = _transformation_list;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp4_ = _tmp3_;
		_transformation_size = _tmp4_;
		_transformation_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			PixelTransformation* transformation = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			PixelTransformer* _tmp9_;
			GeeArrayList* _tmp10_;
			PixelTransformation* _tmp11_;
			_transformation_index = _transformation_index + 1;
			_tmp5_ = _transformation_index;
			_tmp6_ = _transformation_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _transformation_list;
			_tmp8_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _transformation_index);
			transformation = (PixelTransformation*) _tmp8_;
			_tmp9_ = clone;
			_tmp10_ = _tmp9_->priv->transformations;
			_tmp11_ = transformation;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp11_);
			_pixel_transformation_unref0 (transformation);
		}
	}
	result = clone;
	return result;
}

static void
pixel_transformer_build_optimized_transformations (PixelTransformer* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	PixelTransformation** _tmp3_;
	PixelTransformation* pre_trans = NULL;
	_tmp0_ = self->priv->transformations;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (PixelTransformation*, _tmp2_ + 1);
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
	self->optimized_transformations = _tmp3_;
	self->optimized_transformations_length1 = _tmp2_;
	pre_trans = NULL;
	self->optimized_slots_used = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				PixelTransformation* trans = NULL;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				PixelTransformation* _tmp11_;
				PixelTransformation* this_trans = NULL;
				PixelTransformation* _tmp12_;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				PixelTransformation* _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->transformations;
				_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->transformations;
				_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), i);
				trans = (PixelTransformation*) _tmp10_;
				_tmp11_ = trans;
				if (pixel_transformation_is_identity (_tmp11_)) {
					_pixel_transformation_unref0 (trans);
					continue;
				}
				this_trans = NULL;
				_tmp12_ = trans;
				if (pixel_transformation_get_composition_mode (_tmp12_) == COMPOSITION_MODE_NONE) {
					PixelTransformation* _tmp13_;
					PixelTransformation* _tmp14_;
					_tmp13_ = trans;
					_tmp14_ = _pixel_transformation_ref0 (_tmp13_);
					_pixel_transformation_unref0 (this_trans);
					this_trans = _tmp14_;
				} else {
					PixelTransformation* _tmp15_;
					PixelTransformation* _tmp16_;
					_tmp15_ = trans;
					_tmp16_ = pixel_transformation_copy (_tmp15_);
					_pixel_transformation_unref0 (this_trans);
					this_trans = _tmp16_;
				}
				_tmp19_ = pre_trans;
				if (_tmp19_ != NULL) {
					PixelTransformation* _tmp20_;
					_tmp20_ = this_trans;
					_tmp18_ = pixel_transformation_get_composition_mode (_tmp20_) != COMPOSITION_MODE_NONE;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					PixelTransformation* _tmp21_;
					PixelTransformation* _tmp22_;
					_tmp21_ = this_trans;
					_tmp22_ = pre_trans;
					_tmp17_ = pixel_transformation_get_composition_mode (_tmp21_) == pixel_transformation_get_composition_mode (_tmp22_);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					PixelTransformation* _tmp23_;
					PixelTransformation* _tmp24_;
					_tmp23_ = pre_trans;
					_tmp24_ = this_trans;
					pixel_transformation_compose_with (_tmp23_, _tmp24_);
				} else {
					PixelTransformation** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					PixelTransformation* _tmp27_;
					PixelTransformation* _tmp28_;
					PixelTransformation* _tmp29_;
					PixelTransformation* _tmp30_;
					_tmp25_ = self->optimized_transformations;
					_tmp25__length1 = self->optimized_transformations_length1;
					_tmp26_ = self->optimized_slots_used;
					self->optimized_slots_used = _tmp26_ + 1;
					_tmp27_ = this_trans;
					_tmp28_ = _pixel_transformation_ref0 (_tmp27_);
					_pixel_transformation_unref0 (_tmp25_[_tmp26_]);
					_tmp25_[_tmp26_] = _tmp28_;
					_tmp29_ = this_trans;
					_tmp30_ = _pixel_transformation_ref0 (_tmp29_);
					_pixel_transformation_unref0 (pre_trans);
					pre_trans = _tmp30_;
				}
				_pixel_transformation_unref0 (this_trans);
				_pixel_transformation_unref0 (trans);
			}
		}
	}
	_pixel_transformation_unref0 (pre_trans);
}

void
pixel_transformer_attach_transformation (PixelTransformer* self,
                                         PixelTransformation* trans)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = self->priv->transformations;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), trans);
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
	self->optimized_transformations = NULL;
	self->optimized_transformations_length1 = 0;
}

void
pixel_transformer_detach_transformation (PixelTransformer* self,
                                         PixelTransformation* victim)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = self->priv->transformations;
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), victim);
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
	self->optimized_transformations = NULL;
	self->optimized_transformations_length1 = 0;
}

void
pixel_transformer_replace_transformation (PixelTransformer* self,
                                          PixelTransformation* old_trans,
                                          PixelTransformation* new_trans)
{
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				PixelTransformation* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->transformations;
				_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->transformations;
				_tmp6_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), i);
				_tmp7_ = (PixelTransformation*) _tmp6_;
				_tmp8_ = _tmp7_ == old_trans;
				_pixel_transformation_unref0 (_tmp7_);
				if (_tmp8_) {
					GeeArrayList* _tmp9_;
					_tmp9_ = self->priv->transformations;
					gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), i, new_trans);
					self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
					self->optimized_transformations = NULL;
					self->optimized_transformations_length1 = 0;
					return;
				}
			}
		}
	}
	g_error ("ColorTransformation.vala:756: %s", "PixelTransformer: replace_transformation( ): old_trans is not present " \
"in " "transformation collection");
}

void
pixel_transformer_transform_pixbuf (PixelTransformer* self,
                                    GdkPixbuf* pixbuf,
                                    GCancellable* cancellable)
{
	pixel_transformer_transform_to_other_pixbuf (self, pixbuf, pixbuf, cancellable, -1);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PixelTransformer* self;
		self = _data1_->self;
		_pixel_transformer_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PixelTransformer* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void*
_____lambda5_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	PixelTransformer* self;
	guint cache_pixel_ticker = 0U;
	void* result;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	cache_pixel_ticker = (_data2_->row * _data1_->dest_width) * 3;
	{
		guint j = 0U;
		j = _data2_->row;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint row_start_index = 0U;
				guint row_end_index = 0U;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = j;
					j = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(j < _data2_->slice_height)) {
					break;
				}
				row_start_index = j * _data1_->dest_rowstride;
				row_end_index = row_start_index + (_data1_->dest_width * _data1_->dest_num_channels);
				{
					guint i = 0U;
					i = row_start_index;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							RGBAnalyticPixel pixel = {0};
							gfloat* _tmp3_;
							gint _tmp3__length1;
							gfloat _tmp4_;
							gfloat* _tmp5_;
							gint _tmp5__length1;
							gfloat _tmp6_;
							gfloat* _tmp7_;
							gint _tmp7__length1;
							gfloat _tmp8_;
							RGBAnalyticPixel _tmp9_;
							RGBAnalyticPixel _tmp10_ = {0};
							guchar* _tmp11_;
							gint _tmp11__length1;
							RGBAnalyticPixel _tmp12_;
							guchar* _tmp13_;
							gint _tmp13__length1;
							RGBAnalyticPixel _tmp14_;
							guchar* _tmp15_;
							gint _tmp15__length1;
							RGBAnalyticPixel _tmp16_;
							if (!_tmp2_) {
								i += (guint) _data1_->dest_num_channels;
							}
							_tmp2_ = FALSE;
							if (!(i < row_end_index)) {
								break;
							}
							_tmp3_ = _data1_->cache;
							_tmp3__length1 = _data1_->cache_length1;
							_tmp4_ = _tmp3_[cache_pixel_ticker];
							_tmp5_ = _data1_->cache;
							_tmp5__length1 = _data1_->cache_length1;
							_tmp6_ = _tmp5_[cache_pixel_ticker + 1];
							_tmp7_ = _data1_->cache;
							_tmp7__length1 = _data1_->cache_length1;
							_tmp8_ = _tmp7_[cache_pixel_ticker + 2];
							rgb_analytic_pixel_init_from_components (&pixel, _tmp4_, _tmp6_, _tmp8_);
							cache_pixel_ticker += (guint) 3;
							_tmp9_ = pixel;
							pixel_transformer_apply_transformations (self, &_tmp9_, &_tmp10_);
							pixel = _tmp10_;
							_tmp11_ = _data1_->dest_pixels;
							_tmp11__length1 = _data1_->dest_pixels_length1;
							_tmp12_ = pixel;
							_tmp11_[i] = (guchar) (_tmp12_.red * 255.0f);
							_tmp13_ = _data1_->dest_pixels;
							_tmp13__length1 = _data1_->dest_pixels_length1;
							_tmp14_ = pixel;
							_tmp13_[i + 1] = (guchar) (_tmp14_.green * 255.0f);
							_tmp15_ = _data1_->dest_pixels;
							_tmp15__length1 = _data1_->dest_pixels_length1;
							_tmp16_ = pixel;
							_tmp15_[i + 2] = (guchar) (_tmp16_.blue * 255.0f);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gpointer
______lambda5__gthread_func (gpointer self)
{
	gpointer result;
	result = _____lambda5_ (self);
	block2_data_unref (self);
	return result;
}

static gpointer
_g_thread_ref0 (gpointer self)
{
	return self ? g_thread_ref (self) : NULL;
}

void
pixel_transformer_transform_from_fp (PixelTransformer* self,
                                     gfloat** fp_pixel_cache,
                                     gint* fp_pixel_cache_length1,
                                     GdkPixbuf* dest)
{
	Block1Data* _data1_;
	PixelTransformation** _tmp0_;
	gint _tmp0__length1;
	gint dest_height = 0;
	guint8* _tmp1_;
	gint jobs = 0;
	guint slice_length = 0U;
	GThread** threads = NULL;
	GThread** _tmp2_;
	gint threads_length1;
	gint _threads_size_;
	GThread** _tmp7_;
	gint _tmp7__length1;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = pixel_transformer_ref (self);
	_tmp0_ = self->optimized_transformations;
	_tmp0__length1 = self->optimized_transformations_length1;
	if (_tmp0_ == NULL) {
		pixel_transformer_build_optimized_transformations (self);
	}
	_data1_->dest_width = gdk_pixbuf_get_width (dest);
	dest_height = gdk_pixbuf_get_height (dest);
	_data1_->dest_num_channels = gdk_pixbuf_get_n_channels (dest);
	_data1_->dest_rowstride = gdk_pixbuf_get_rowstride (dest);
	_tmp1_ = gdk_pixbuf_get_pixels (dest);
	_data1_->dest_pixels = _tmp1_;
	_data1_->dest_pixels_length1 = -1;
	_data1_->_dest_pixels_size_ = _data1_->dest_pixels_length1;
	jobs = ((gint) g_get_num_processors ()) - 1;
	slice_length = (guint) dest_height;
	if (jobs > 0) {
		slice_length = (guint) ((dest_height + (jobs - 1)) / jobs);
	}
	_tmp2_ = g_new0 (GThread*, jobs + 1);
	threads = _tmp2_;
	threads_length1 = jobs;
	_threads_size_ = threads_length1;
	_data1_->cache = *fp_pixel_cache;
	_data1_->cache_length1 = *fp_pixel_cache_length1;
	_data1_->_cache_size_ = _data1_->cache_length1;
	{
		gint job = 0;
		job = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				Block2Data* _data2_;
				GThread** _tmp5_;
				gint _tmp5__length1;
				GThread* _tmp6_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->_data1_ = block1_data_ref (_data1_);
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = job;
					job = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(job < jobs)) {
					block2_data_unref (_data2_);
					_data2_ = NULL;
					break;
				}
				_data2_->row = job * slice_length;
				_data2_->slice_height = CLAMP (_data2_->row + slice_length, (guint) 0, (guint) dest_height);
				_tmp5_ = threads;
				_tmp5__length1 = threads_length1;
				_tmp6_ = g_thread_new ("shotwell-worker", ______lambda5__gthread_func, block2_data_ref (_data2_));
				_g_thread_unref0 (_tmp5_[job]);
				_tmp5_[job] = _tmp6_;
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
	_tmp7_ = threads;
	_tmp7__length1 = threads_length1;
	{
		GThread** thread_collection = NULL;
		gint thread_collection_length1 = 0;
		gint _thread_collection_size_ = 0;
		gint thread_it = 0;
		thread_collection = _tmp7_;
		thread_collection_length1 = _tmp7__length1;
		for (thread_it = 0; thread_it < thread_collection_length1; thread_it = thread_it + 1) {
			GThread* _tmp8_;
			GThread* thread = NULL;
			_tmp8_ = _g_thread_ref0 (thread_collection[thread_it]);
			thread = _tmp8_;
			{
				GThread* _tmp9_;
				_tmp9_ = thread;
				thread = NULL;
				g_thread_join (_tmp9_);
				_g_thread_unref0 (thread);
			}
		}
	}
	threads = (_vala_array_free (threads, threads_length1, (GDestroyNotify) g_thread_unref), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PixelTransformer* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->cancellable);
		_pixel_transformer_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PixelTransformer* self;
		self = _data4_->_data3_->self;
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static void*
_____lambda4_ (Block4Data* _data4_)
{
	Block3Data* _data3_;
	PixelTransformer* self;
	void* result;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	{
		guint j = 0U;
		j = _data4_->row;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guchar* _tmp2_;
				gint _tmp2__length1;
				guchar* _tmp3_;
				gint _tmp3__length1;
				gboolean _tmp4_ = FALSE;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = j;
					j = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(j < _data4_->slice_height)) {
					break;
				}
				_tmp2_ = _data3_->source_pixels;
				_tmp2__length1 = _data3_->source_pixels_length1;
				_tmp3_ = _data3_->dest_pixels;
				_tmp3__length1 = _data3_->dest_pixels_length1;
				pixel_transformer_apply_transformation (self, j, _data3_->rowstride, _data3_->rowbytes, _data3_->n_channels, _tmp2_, (gint) _tmp2__length1, _tmp3_, (gint) _tmp3__length1);
				if (_data3_->cancellable != NULL) {
					_tmp4_ = g_cancellable_is_cancelled (_data3_->cancellable);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					break;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gpointer
______lambda4__gthread_func (gpointer self)
{
	gpointer result;
	result = _____lambda4_ (self);
	block4_data_unref (self);
	return result;
}

void
pixel_transformer_transform_to_other_pixbuf (PixelTransformer* self,
                                             GdkPixbuf* source,
                                             GdkPixbuf* dest,
                                             GCancellable* cancellable,
                                             gint jobs)
{
	Block3Data* _data3_;
	GCancellable* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	PixelTransformation** _tmp13_;
	gint _tmp13__length1;
	gint width = 0;
	gint height = 0;
	guint8* _tmp14_;
	guint8* _tmp15_;
	guint slice_length = 0U;
	GThread** threads = NULL;
	GThread** _tmp16_;
	gint threads_length1;
	gint _threads_size_;
	GThread** _tmp21_;
	gint _tmp21__length1;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = pixel_transformer_ref (self);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data3_->cancellable);
	_data3_->cancellable = _tmp0_;
	_tmp1_ = gdk_pixbuf_get_width (source);
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_pixbuf_get_width (dest);
	_tmp4_ = _tmp3_;
	if (_tmp2_ != _tmp4_) {
		g_error ("ColorTransformation.vala:820: PixelTransformer: source and destination" \
" pixbufs must have the same width");
	}
	_tmp5_ = gdk_pixbuf_get_height (source);
	_tmp6_ = _tmp5_;
	_tmp7_ = gdk_pixbuf_get_height (dest);
	_tmp8_ = _tmp7_;
	if (_tmp6_ != _tmp8_) {
		g_error ("ColorTransformation.vala:823: PixelTransformer: source and destination" \
" pixbufs must have the same height");
	}
	_tmp9_ = gdk_pixbuf_get_n_channels (source);
	_tmp10_ = _tmp9_;
	_tmp11_ = gdk_pixbuf_get_n_channels (dest);
	_tmp12_ = _tmp11_;
	if (_tmp10_ != _tmp12_) {
		g_error ("ColorTransformation.vala:826: %s", "PixelTransformer: source and destination pixbufs must have the same nu" \
"mber " "of channels");
	}
	_tmp13_ = self->optimized_transformations;
	_tmp13__length1 = self->optimized_transformations_length1;
	if (_tmp13_ == NULL) {
		pixel_transformer_build_optimized_transformations (self);
	}
	_data3_->n_channels = gdk_pixbuf_get_n_channels (source);
	_data3_->rowstride = gdk_pixbuf_get_rowstride (source);
	width = gdk_pixbuf_get_width (source);
	height = gdk_pixbuf_get_height (source);
	_data3_->rowbytes = _data3_->n_channels * width;
	_tmp14_ = gdk_pixbuf_get_pixels (source);
	_data3_->source_pixels = _tmp14_;
	_data3_->source_pixels_length1 = -1;
	_data3_->_source_pixels_size_ = _data3_->source_pixels_length1;
	_tmp15_ = gdk_pixbuf_get_pixels (dest);
	_data3_->dest_pixels = _tmp15_;
	_data3_->dest_pixels_length1 = -1;
	_data3_->_dest_pixels_size_ = _data3_->dest_pixels_length1;
	if (jobs == -1) {
		jobs = ((gint) g_get_num_processors ()) - 1;
	}
	slice_length = (guint) height;
	if (jobs > 0) {
		slice_length = (guint) ((height + (jobs - 1)) / jobs);
	}
	_tmp16_ = g_new0 (GThread*, jobs + 1);
	threads = _tmp16_;
	threads_length1 = jobs;
	_threads_size_ = threads_length1;
	{
		gint job = 0;
		job = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				Block4Data* _data4_;
				GThread** _tmp19_;
				gint _tmp19__length1;
				GThread* _tmp20_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->_data3_ = block3_data_ref (_data3_);
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = job;
					job = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(job < jobs)) {
					block4_data_unref (_data4_);
					_data4_ = NULL;
					break;
				}
				_data4_->row = job * slice_length;
				_data4_->slice_height = CLAMP (_data4_->row + slice_length, (guint) 0, (guint) height);
				_tmp19_ = threads;
				_tmp19__length1 = threads_length1;
				_tmp20_ = g_thread_new ("shotwell-worker", ______lambda4__gthread_func, block4_data_ref (_data4_));
				_g_thread_unref0 (_tmp19_[job]);
				_tmp19_[job] = _tmp20_;
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_tmp21_ = threads;
	_tmp21__length1 = threads_length1;
	{
		GThread** thread_collection = NULL;
		gint thread_collection_length1 = 0;
		gint _thread_collection_size_ = 0;
		gint thread_it = 0;
		thread_collection = _tmp21_;
		thread_collection_length1 = _tmp21__length1;
		for (thread_it = 0; thread_it < thread_collection_length1; thread_it = thread_it + 1) {
			GThread* _tmp22_;
			GThread* thread = NULL;
			_tmp22_ = _g_thread_ref0 (thread_collection[thread_it]);
			thread = _tmp22_;
			{
				GThread* _tmp23_;
				_tmp23_ = thread;
				thread = NULL;
				g_thread_join (_tmp23_);
				_g_thread_unref0 (thread);
			}
		}
	}
	threads = (_vala_array_free (threads, threads_length1, (GDestroyNotify) g_thread_unref), NULL);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
value_pixel_transformer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_pixel_transformer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pixel_transformer_unref (value->data[0].v_pointer);
	}
}

static void
value_pixel_transformer_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pixel_transformer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_pixel_transformer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_pixel_transformer_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PixelTransformer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pixel_transformer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_pixel_transformer_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	PixelTransformer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pixel_transformer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_pixel_transformer (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecPixelTransformer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_pixel_transformer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_pixel_transformer (GValue* value,
                             gpointer v_object)
{
	PixelTransformer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pixel_transformer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixel_transformer_unref (old);
	}
}

void
value_take_pixel_transformer (GValue* value,
                              gpointer v_object)
{
	PixelTransformer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixel_transformer_unref (old);
	}
}

static void
pixel_transformer_class_init (PixelTransformerClass * klass,
                              gpointer klass_data)
{
	pixel_transformer_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformerClass *) klass)->finalize = pixel_transformer_finalize;
	g_type_class_adjust_private_offset (klass, &PixelTransformer_private_offset);
}

static void
pixel_transformer_instance_init (PixelTransformer * self,
                                 gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = pixel_transformer_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_PIXEL_TRANSFORMATION, (GBoxedCopyFunc) pixel_transformation_ref, (GDestroyNotify) pixel_transformation_unref, NULL, NULL, NULL);
	self->priv->transformations = _tmp0_;
	self->optimized_transformations = NULL;
	self->optimized_transformations_length1 = 0;
	self->optimized_slots_used = 0;
	self->ref_count = 1;
}

static void
pixel_transformer_finalize (PixelTransformer * obj)
{
	PixelTransformer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMER, PixelTransformer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->transformations);
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
}

static GType
pixel_transformer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_pixel_transformer_init, value_pixel_transformer_free_value, value_pixel_transformer_copy_value, value_pixel_transformer_peek_pointer, "p", value_pixel_transformer_collect_value, "p", value_pixel_transformer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PixelTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformer), 0, (GInstanceInitFunc) pixel_transformer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pixel_transformer_type_id;
	pixel_transformer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PixelTransformer_private_offset = g_type_add_instance_private (pixel_transformer_type_id, sizeof (PixelTransformerPrivate));
	return pixel_transformer_type_id;
}

GType
pixel_transformer_get_type (void)
{
	static volatile gsize pixel_transformer_type_id__once = 0;
	if (g_once_init_enter (&pixel_transformer_type_id__once)) {
		GType pixel_transformer_type_id;
		pixel_transformer_type_id = pixel_transformer_get_type_once ();
		g_once_init_leave (&pixel_transformer_type_id__once, pixel_transformer_type_id);
	}
	return pixel_transformer_type_id__once;
}

gpointer
pixel_transformer_ref (gpointer instance)
{
	PixelTransformer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pixel_transformer_unref (gpointer instance)
{
	PixelTransformer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PIXEL_TRANSFORMER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
rgb_histogram_get_instance_private (RGBHistogram* self)
{
	return G_STRUCT_MEMBER_P (self, RGBHistogram_private_offset);
}

RGBHistogram*
rgb_histogram_construct (GType object_type,
                         GdkPixbuf* pixbuf)
{
	RGBHistogram* self = NULL;
	gint sample_bytes = 0;
	gint pixel_bytes = 0;
	gint row_length_bytes = 0;
	gint _tmp0_;
	gint _tmp1_;
	guchar* pixel_data = NULL;
	guint8* _tmp2_;
	gint pixel_data_length1;
	gint _pixel_data_size_;
	self = (RGBHistogram*) g_type_create_instance (object_type);
	sample_bytes = gdk_pixbuf_get_bits_per_sample (pixbuf) / 8;
	pixel_bytes = sample_bytes * gdk_pixbuf_get_n_channels (pixbuf);
	_tmp0_ = gdk_pixbuf_get_width (pixbuf);
	_tmp1_ = _tmp0_;
	row_length_bytes = pixel_bytes * _tmp1_;
	_tmp2_ = gdk_pixbuf_get_pixels (pixbuf);
	pixel_data = _tmp2_;
	pixel_data_length1 = -1;
	_pixel_data_size_ = pixel_data_length1;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gint row_start_offset = 0;
				gint _tmp7_;
				gint _tmp8_;
				gint r_offset = 0;
				gint g_offset = 0;
				gint b_offset = 0;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = y;
					y = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = gdk_pixbuf_get_height (pixbuf);
				_tmp6_ = _tmp5_;
				if (!(y < _tmp6_)) {
					break;
				}
				_tmp7_ = gdk_pixbuf_get_rowstride (pixbuf);
				_tmp8_ = _tmp7_;
				row_start_offset = y * _tmp8_;
				r_offset = row_start_offset;
				g_offset = row_start_offset + sample_bytes;
				b_offset = (row_start_offset + sample_bytes) + sample_bytes;
				while (TRUE) {
					gint* _tmp9_;
					gint _tmp9__length1;
					guchar* _tmp10_;
					gint _tmp10__length1;
					guchar _tmp11_;
					gint* _tmp12_;
					gint _tmp12__length1;
					guchar* _tmp13_;
					gint _tmp13__length1;
					guchar _tmp14_;
					gint* _tmp15_;
					gint _tmp15__length1;
					guchar* _tmp16_;
					gint _tmp16__length1;
					guchar _tmp17_;
					if (!(b_offset < (row_start_offset + row_length_bytes))) {
						break;
					}
					_tmp9_ = self->priv->red_counts;
					_tmp9__length1 = self->priv->red_counts_length1;
					_tmp10_ = pixel_data;
					_tmp10__length1 = pixel_data_length1;
					_tmp11_ = _tmp10_[r_offset];
					_tmp9_[_tmp11_] += 1;
					_tmp12_ = self->priv->green_counts;
					_tmp12__length1 = self->priv->green_counts_length1;
					_tmp13_ = pixel_data;
					_tmp13__length1 = pixel_data_length1;
					_tmp14_ = _tmp13_[g_offset];
					_tmp12_[_tmp14_] += 1;
					_tmp15_ = self->priv->blue_counts;
					_tmp15__length1 = self->priv->blue_counts_length1;
					_tmp16_ = pixel_data;
					_tmp16__length1 = pixel_data_length1;
					_tmp17_ = _tmp16_[b_offset];
					_tmp15_[_tmp17_] += 1;
					r_offset += pixel_bytes;
					g_offset += pixel_bytes;
					b_offset += pixel_bytes;
				}
			}
		}
	}
	return self;
}

RGBHistogram*
rgb_histogram_new (GdkPixbuf* pixbuf)
{
	return rgb_histogram_construct (TYPE_RGB_HISTOGRAM, pixbuf);
}

static gint
rgb_histogram_correct_snap_to_quantization (RGBHistogram* self,
                                            gint* buckets,
                                            gint buckets_length1,
                                            gint i)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp17_;
	gint result;
	_vala_assert (buckets_length1 == 256, "buckets.length == 256");
	if (i >= 0) {
		_tmp0_ = i <= 255;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "(i >= 0) && (i <= 255)");
	if (i == 0) {
		gint _tmp1_;
		_tmp1_ = buckets[i];
		if (_tmp1_ > 0) {
			gint _tmp2_;
			_tmp2_ = buckets[i + 1];
			if (_tmp2_ > 0) {
				gint _tmp3_;
				gint _tmp4_;
				_tmp3_ = buckets[i];
				_tmp4_ = buckets[i + 1];
				if (_tmp3_ > (2 * _tmp4_)) {
					gint _tmp5_;
					_tmp5_ = buckets[i + 1];
					result = _tmp5_;
					return result;
				}
			}
		}
	} else {
		if (i == 255) {
			gint _tmp6_;
			_tmp6_ = buckets[i];
			if (_tmp6_ > 0) {
				gint _tmp7_;
				_tmp7_ = buckets[i - 1];
				if (_tmp7_ > 0) {
					gint _tmp8_;
					gint _tmp9_;
					_tmp8_ = buckets[i];
					_tmp9_ = buckets[i - 1];
					if (_tmp8_ > (2 * _tmp9_)) {
						gint _tmp10_;
						_tmp10_ = buckets[i - 1];
						result = _tmp10_;
						return result;
					}
				}
			}
		} else {
			gint _tmp11_;
			_tmp11_ = buckets[i];
			if (_tmp11_ > 0) {
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = buckets[i];
				_tmp13_ = buckets[i - 1];
				_tmp14_ = buckets[i + 1];
				if (_tmp12_ > ((_tmp13_ + _tmp14_) / 2)) {
					gint _tmp15_;
					gint _tmp16_;
					_tmp15_ = buckets[i - 1];
					_tmp16_ = buckets[i + 1];
					result = (_tmp15_ + _tmp16_) / 2;
					return result;
				}
			}
		}
	}
	_tmp17_ = buckets[i];
	result = _tmp17_;
	return result;
}

static gint
rgb_histogram_correct_snap_from_quantization (RGBHistogram* self,
                                              gint* buckets,
                                              gint buckets_length1,
                                              gint i)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp8_;
	gint result;
	_vala_assert (buckets_length1 == 256, "buckets.length == 256");
	if (i >= 0) {
		_tmp0_ = i <= 255;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "(i >= 0) && (i <= 255)");
	if (i == 0) {
		gint _tmp1_;
		_tmp1_ = buckets[i];
		result = _tmp1_;
		return result;
	} else {
		if (i == 255) {
			gint _tmp2_;
			_tmp2_ = buckets[i];
			result = _tmp2_;
			return result;
		} else {
			gint _tmp3_;
			_tmp3_ = buckets[i];
			if (_tmp3_ == 0) {
				gint _tmp4_;
				_tmp4_ = buckets[i - 1];
				if (_tmp4_ > 0) {
					gint _tmp5_;
					_tmp5_ = buckets[i + 1];
					if (_tmp5_ > 0) {
						gint _tmp6_;
						gint _tmp7_;
						_tmp6_ = buckets[i - 1];
						_tmp7_ = buckets[i + 1];
						result = (_tmp6_ + _tmp7_) / 2;
						return result;
					}
				}
			}
		}
	}
	_tmp8_ = buckets[i];
	result = _tmp8_;
	return result;
}

static void
rgb_histogram_smooth_extrema (RGBHistogram* self,
                              gint** count_data,
                              gint* count_data_length1)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	_vala_assert ((*count_data_length1) == 256, "count_data.length == 256");
	_tmp0_ = (*count_data)[0];
	_tmp1_ = (*count_data)[1];
	_tmp2_ = (*count_data)[2];
	(*count_data)[0] = (((5 * _tmp0_) + (3 * _tmp1_)) + (2 * _tmp2_)) / 10;
	_tmp3_ = (*count_data)[0];
	_tmp4_ = (*count_data)[1];
	_tmp5_ = (*count_data)[2];
	_tmp6_ = (*count_data)[3];
	(*count_data)[1] = ((((3 * _tmp3_) + (5 * _tmp4_)) + (3 * _tmp5_)) + (2 * _tmp6_)) / 13;
	_tmp7_ = (*count_data)[0];
	_tmp8_ = (*count_data)[1];
	_tmp9_ = (*count_data)[2];
	_tmp10_ = (*count_data)[3];
	_tmp11_ = (*count_data)[4];
	(*count_data)[2] = (((((2 * _tmp7_) + (3 * _tmp8_)) + (5 * _tmp9_)) + (3 * _tmp10_)) + (2 * _tmp11_)) / 15;
	_tmp12_ = (*count_data)[1];
	_tmp13_ = (*count_data)[2];
	_tmp14_ = (*count_data)[3];
	_tmp15_ = (*count_data)[4];
	_tmp16_ = (*count_data)[5];
	(*count_data)[3] = (((((2 * _tmp12_) + (3 * _tmp13_)) + (5 * _tmp14_)) + (3 * _tmp15_)) + (2 * _tmp16_)) / 15;
	_tmp17_ = (*count_data)[2];
	_tmp18_ = (*count_data)[3];
	_tmp19_ = (*count_data)[4];
	_tmp20_ = (*count_data)[5];
	_tmp21_ = (*count_data)[6];
	(*count_data)[4] = (((((2 * _tmp17_) + (3 * _tmp18_)) + (5 * _tmp19_)) + (3 * _tmp20_)) + (2 * _tmp21_)) / 15;
	_tmp22_ = (*count_data)[255];
	_tmp23_ = (*count_data)[254];
	_tmp24_ = (*count_data)[253];
	(*count_data)[255] = (((5 * _tmp22_) + (3 * _tmp23_)) + (2 * _tmp24_)) / 10;
	_tmp25_ = (*count_data)[255];
	_tmp26_ = (*count_data)[254];
	_tmp27_ = (*count_data)[253];
	_tmp28_ = (*count_data)[252];
	(*count_data)[254] = ((((3 * _tmp25_) + (5 * _tmp26_)) + (3 * _tmp27_)) + (2 * _tmp28_)) / 13;
	_tmp29_ = (*count_data)[255];
	_tmp30_ = (*count_data)[254];
	_tmp31_ = (*count_data)[253];
	_tmp32_ = (*count_data)[252];
	_tmp33_ = (*count_data)[251];
	(*count_data)[253] = (((((2 * _tmp29_) + (3 * _tmp30_)) + (5 * _tmp31_)) + (3 * _tmp32_)) + (2 * _tmp33_)) / 15;
	_tmp34_ = (*count_data)[254];
	_tmp35_ = (*count_data)[253];
	_tmp36_ = (*count_data)[252];
	_tmp37_ = (*count_data)[251];
	_tmp38_ = (*count_data)[250];
	(*count_data)[252] = (((((2 * _tmp34_) + (3 * _tmp35_)) + (5 * _tmp36_)) + (3 * _tmp37_)) + (2 * _tmp38_)) / 15;
	_tmp39_ = (*count_data)[253];
	_tmp40_ = (*count_data)[252];
	_tmp41_ = (*count_data)[251];
	_tmp42_ = (*count_data)[250];
	_tmp43_ = (*count_data)[249];
	(*count_data)[251] = (((((2 * _tmp39_) + (3 * _tmp40_)) + (5 * _tmp41_)) + (3 * _tmp42_)) + (2 * _tmp43_)) / 15;
}

static void
rgb_histogram_prepare_qualitative_counts (RGBHistogram* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint* _tmp5_;
	gint* _tmp6_;
	gint* _tmp7_;
	gint* temp_red_counts = NULL;
	gint* _tmp8_;
	gint temp_red_counts_length1;
	gint _temp_red_counts_size_;
	gint* temp_green_counts = NULL;
	gint* _tmp9_;
	gint temp_green_counts_length1;
	gint _temp_green_counts_size_;
	gint* temp_blue_counts = NULL;
	gint* _tmp10_;
	gint temp_blue_counts_length1;
	gint _temp_blue_counts_size_;
	gint mean_qual_count = 0;
	gint constrained_max_qual_count = 0;
	_tmp2_ = self->priv->qualitative_red_counts;
	_tmp2__length1 = self->priv->qualitative_red_counts_length1;
	if (_tmp2_ != NULL) {
		gint* _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = self->priv->qualitative_green_counts;
		_tmp3__length1 = self->priv->qualitative_green_counts_length1;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->priv->qualitative_blue_counts;
		_tmp4__length1 = self->priv->qualitative_blue_counts_length1;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = g_new0 (gint, 256);
	self->priv->qualitative_red_counts = (g_free (self->priv->qualitative_red_counts), NULL);
	self->priv->qualitative_red_counts = _tmp5_;
	self->priv->qualitative_red_counts_length1 = 256;
	self->priv->_qualitative_red_counts_size_ = self->priv->qualitative_red_counts_length1;
	_tmp6_ = g_new0 (gint, 256);
	self->priv->qualitative_green_counts = (g_free (self->priv->qualitative_green_counts), NULL);
	self->priv->qualitative_green_counts = _tmp6_;
	self->priv->qualitative_green_counts_length1 = 256;
	self->priv->_qualitative_green_counts_size_ = self->priv->qualitative_green_counts_length1;
	_tmp7_ = g_new0 (gint, 256);
	self->priv->qualitative_blue_counts = (g_free (self->priv->qualitative_blue_counts), NULL);
	self->priv->qualitative_blue_counts = _tmp7_;
	self->priv->qualitative_blue_counts_length1 = 256;
	self->priv->_qualitative_blue_counts_size_ = self->priv->qualitative_blue_counts_length1;
	_tmp8_ = g_new0 (gint, 256);
	temp_red_counts = _tmp8_;
	temp_red_counts_length1 = 256;
	_temp_red_counts_size_ = temp_red_counts_length1;
	_tmp9_ = g_new0 (gint, 256);
	temp_green_counts = _tmp9_;
	temp_green_counts_length1 = 256;
	_temp_green_counts_size_ = temp_green_counts_length1;
	_tmp10_ = g_new0 (gint, 256);
	temp_blue_counts = _tmp10_;
	temp_blue_counts_length1 = 256;
	_temp_blue_counts_size_ = temp_blue_counts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint* _tmp13_;
				gint _tmp13__length1;
				gint* _tmp14_;
				gint _tmp14__length1;
				gint* _tmp15_;
				gint _tmp15__length1;
				gint* _tmp16_;
				gint _tmp16__length1;
				gint* _tmp17_;
				gint _tmp17__length1;
				gint* _tmp18_;
				gint _tmp18__length1;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				_tmp13_ = self->priv->qualitative_red_counts;
				_tmp13__length1 = self->priv->qualitative_red_counts_length1;
				_tmp14_ = self->priv->red_counts;
				_tmp14__length1 = self->priv->red_counts_length1;
				_tmp13_[i] = rgb_histogram_correct_snap_from_quantization (self, _tmp14_, (gint) _tmp14__length1, i);
				_tmp15_ = self->priv->qualitative_green_counts;
				_tmp15__length1 = self->priv->qualitative_green_counts_length1;
				_tmp16_ = self->priv->green_counts;
				_tmp16__length1 = self->priv->green_counts_length1;
				_tmp15_[i] = rgb_histogram_correct_snap_from_quantization (self, _tmp16_, (gint) _tmp16__length1, i);
				_tmp17_ = self->priv->qualitative_blue_counts;
				_tmp17__length1 = self->priv->qualitative_blue_counts_length1;
				_tmp18_ = self->priv->blue_counts;
				_tmp18__length1 = self->priv->blue_counts_length1;
				_tmp17_[i] = rgb_histogram_correct_snap_from_quantization (self, _tmp18_, (gint) _tmp18__length1, i);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gint* _tmp21_;
				gint _tmp21__length1;
				gint* _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				gint* _tmp24_;
				gint _tmp24__length1;
				gint* _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				gint* _tmp27_;
				gint _tmp27__length1;
				gint* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				_tmp21_ = temp_red_counts;
				_tmp21__length1 = temp_red_counts_length1;
				_tmp22_ = self->priv->qualitative_red_counts;
				_tmp22__length1 = self->priv->qualitative_red_counts_length1;
				_tmp23_ = _tmp22_[i];
				_tmp21_[i] = _tmp23_;
				_tmp24_ = temp_green_counts;
				_tmp24__length1 = temp_green_counts_length1;
				_tmp25_ = self->priv->qualitative_green_counts;
				_tmp25__length1 = self->priv->qualitative_green_counts_length1;
				_tmp26_ = _tmp25_[i];
				_tmp24_[i] = _tmp26_;
				_tmp27_ = temp_blue_counts;
				_tmp27__length1 = temp_blue_counts_length1;
				_tmp28_ = self->priv->qualitative_blue_counts;
				_tmp28__length1 = self->priv->qualitative_blue_counts_length1;
				_tmp29_ = _tmp28_[i];
				_tmp27_[i] = _tmp29_;
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint* _tmp32_;
				gint _tmp32__length1;
				gint* _tmp33_;
				gint _tmp33__length1;
				gint* _tmp34_;
				gint _tmp34__length1;
				gint* _tmp35_;
				gint _tmp35__length1;
				gint* _tmp36_;
				gint _tmp36__length1;
				gint* _tmp37_;
				gint _tmp37__length1;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				_tmp32_ = self->priv->qualitative_red_counts;
				_tmp32__length1 = self->priv->qualitative_red_counts_length1;
				_tmp33_ = temp_red_counts;
				_tmp33__length1 = temp_red_counts_length1;
				_tmp32_[i] = rgb_histogram_correct_snap_to_quantization (self, _tmp33_, (gint) _tmp33__length1, i);
				_tmp34_ = self->priv->qualitative_green_counts;
				_tmp34__length1 = self->priv->qualitative_green_counts_length1;
				_tmp35_ = temp_green_counts;
				_tmp35__length1 = temp_green_counts_length1;
				_tmp34_[i] = rgb_histogram_correct_snap_to_quantization (self, _tmp35_, (gint) _tmp35__length1, i);
				_tmp36_ = self->priv->qualitative_blue_counts;
				_tmp36__length1 = self->priv->qualitative_blue_counts_length1;
				_tmp37_ = temp_blue_counts;
				_tmp37__length1 = temp_blue_counts_length1;
				_tmp36_[i] = rgb_histogram_correct_snap_to_quantization (self, _tmp37_, (gint) _tmp37__length1, i);
			}
		}
	}
	mean_qual_count = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = TRUE;
			while (TRUE) {
				gint* _tmp40_;
				gint _tmp40__length1;
				gint _tmp41_;
				gint* _tmp42_;
				gint _tmp42__length1;
				gint _tmp43_;
				gint* _tmp44_;
				gint _tmp44__length1;
				gint _tmp45_;
				if (!_tmp38_) {
					gint _tmp39_;
					_tmp39_ = i;
					i = _tmp39_ + 1;
				}
				_tmp38_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				_tmp40_ = self->priv->qualitative_red_counts;
				_tmp40__length1 = self->priv->qualitative_red_counts_length1;
				_tmp41_ = _tmp40_[i];
				_tmp42_ = self->priv->qualitative_green_counts;
				_tmp42__length1 = self->priv->qualitative_green_counts_length1;
				_tmp43_ = _tmp42_[i];
				_tmp44_ = self->priv->qualitative_blue_counts;
				_tmp44__length1 = self->priv->qualitative_blue_counts_length1;
				_tmp45_ = _tmp44_[i];
				mean_qual_count += (_tmp41_ + _tmp43_) + _tmp45_;
			}
		}
	}
	mean_qual_count /= 256 * 3;
	constrained_max_qual_count = 8 * mean_qual_count;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint* _tmp48_;
				gint _tmp48__length1;
				gint _tmp49_;
				gint* _tmp51_;
				gint _tmp51__length1;
				gint _tmp52_;
				gint* _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				_tmp48_ = self->priv->qualitative_red_counts;
				_tmp48__length1 = self->priv->qualitative_red_counts_length1;
				_tmp49_ = _tmp48_[i];
				if (_tmp49_ > constrained_max_qual_count) {
					gint* _tmp50_;
					gint _tmp50__length1;
					_tmp50_ = self->priv->qualitative_red_counts;
					_tmp50__length1 = self->priv->qualitative_red_counts_length1;
					_tmp50_[i] = constrained_max_qual_count;
				}
				_tmp51_ = self->priv->qualitative_green_counts;
				_tmp51__length1 = self->priv->qualitative_green_counts_length1;
				_tmp52_ = _tmp51_[i];
				if (_tmp52_ > constrained_max_qual_count) {
					gint* _tmp53_;
					gint _tmp53__length1;
					_tmp53_ = self->priv->qualitative_green_counts;
					_tmp53__length1 = self->priv->qualitative_green_counts_length1;
					_tmp53_[i] = constrained_max_qual_count;
				}
				_tmp54_ = self->priv->qualitative_blue_counts;
				_tmp54__length1 = self->priv->qualitative_blue_counts_length1;
				_tmp55_ = _tmp54_[i];
				if (_tmp55_ > constrained_max_qual_count) {
					gint* _tmp56_;
					gint _tmp56__length1;
					_tmp56_ = self->priv->qualitative_blue_counts;
					_tmp56__length1 = self->priv->qualitative_blue_counts_length1;
					_tmp56_[i] = constrained_max_qual_count;
				}
			}
		}
	}
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_red_counts, (gint*) (&self->priv->qualitative_red_counts_length1));
	self->priv->_qualitative_red_counts_size_ = self->priv->qualitative_red_counts_length1;
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_green_counts, (gint*) (&self->priv->qualitative_green_counts_length1));
	self->priv->_qualitative_green_counts_size_ = self->priv->qualitative_green_counts_length1;
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_blue_counts, (gint*) (&self->priv->qualitative_blue_counts_length1));
	self->priv->_qualitative_blue_counts_size_ = self->priv->qualitative_blue_counts_length1;
	temp_blue_counts = (g_free (temp_blue_counts), NULL);
	temp_green_counts = (g_free (temp_green_counts), NULL);
	temp_red_counts = (g_free (temp_red_counts), NULL);
}

GdkPixbuf*
rgb_histogram_get_graphic (RGBHistogram* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp55_;
	GdkPixbuf* _tmp56_;
	GdkPixbuf* result;
	_tmp0_ = self->priv->graphic;
	if (_tmp0_ == NULL) {
		gint max_count = 0;
		GdkPixbuf* _tmp15_;
		gint rowstride = 0;
		GdkPixbuf* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint sample_bytes = 0;
		GdkPixbuf* _tmp19_;
		gint pixel_bytes = 0;
		GdkPixbuf* _tmp20_;
		gdouble scale_bar = 0.0;
		guchar* pixel_data = NULL;
		GdkPixbuf* _tmp21_;
		guint8* _tmp22_;
		gint pixel_data_length1;
		gint _pixel_data_size_;
		rgb_histogram_prepare_qualitative_counts (self);
		max_count = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint* _tmp3_;
					gint _tmp3__length1;
					gint _tmp4_;
					gint* _tmp7_;
					gint _tmp7__length1;
					gint _tmp8_;
					gint* _tmp11_;
					gint _tmp11__length1;
					gint _tmp12_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i < 256)) {
						break;
					}
					_tmp3_ = self->priv->qualitative_red_counts;
					_tmp3__length1 = self->priv->qualitative_red_counts_length1;
					_tmp4_ = _tmp3_[i];
					if (_tmp4_ > max_count) {
						gint* _tmp5_;
						gint _tmp5__length1;
						gint _tmp6_;
						_tmp5_ = self->priv->qualitative_red_counts;
						_tmp5__length1 = self->priv->qualitative_red_counts_length1;
						_tmp6_ = _tmp5_[i];
						max_count = _tmp6_;
					}
					_tmp7_ = self->priv->qualitative_green_counts;
					_tmp7__length1 = self->priv->qualitative_green_counts_length1;
					_tmp8_ = _tmp7_[i];
					if (_tmp8_ > max_count) {
						gint* _tmp9_;
						gint _tmp9__length1;
						gint _tmp10_;
						_tmp9_ = self->priv->qualitative_green_counts;
						_tmp9__length1 = self->priv->qualitative_green_counts_length1;
						_tmp10_ = _tmp9_[i];
						max_count = _tmp10_;
					}
					_tmp11_ = self->priv->qualitative_blue_counts;
					_tmp11__length1 = self->priv->qualitative_blue_counts_length1;
					_tmp12_ = _tmp11_[i];
					if (_tmp12_ > max_count) {
						gint* _tmp13_;
						gint _tmp13__length1;
						gint _tmp14_;
						_tmp13_ = self->priv->qualitative_blue_counts;
						_tmp13__length1 = self->priv->qualitative_blue_counts_length1;
						_tmp14_ = _tmp13_[i];
						max_count = _tmp14_;
					}
				}
			}
		}
		_tmp15_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, RGB_HISTOGRAM_GRAPHIC_WIDTH, RGB_HISTOGRAM_GRAPHIC_HEIGHT);
		_g_object_unref0 (self->priv->graphic);
		self->priv->graphic = _tmp15_;
		_tmp16_ = self->priv->graphic;
		_tmp17_ = gdk_pixbuf_get_rowstride (_tmp16_);
		_tmp18_ = _tmp17_;
		rowstride = _tmp18_;
		_tmp19_ = self->priv->graphic;
		sample_bytes = gdk_pixbuf_get_bits_per_sample (_tmp19_) / 8;
		_tmp20_ = self->priv->graphic;
		pixel_bytes = sample_bytes * gdk_pixbuf_get_n_channels (_tmp20_);
		scale_bar = (0.98 * ((gdouble) RGB_HISTOGRAM_GRAPHIC_HEIGHT)) / ((gdouble) max_count);
		_tmp21_ = self->priv->graphic;
		_tmp22_ = gdk_pixbuf_get_pixels (_tmp21_);
		pixel_data = _tmp22_;
		pixel_data_length1 = -1;
		_pixel_data_size_ = pixel_data_length1;
		if (max_count == 0) {
			GdkPixbuf* _tmp32_;
			GdkPixbuf* _tmp33_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp23_ = FALSE;
					_tmp23_ = TRUE;
					while (TRUE) {
						GdkPixbuf* _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						GdkPixbuf* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						guchar* _tmp31_;
						gint _tmp31__length1;
						if (!_tmp23_) {
							gint _tmp24_;
							_tmp24_ = i;
							i = _tmp24_ + 1;
						}
						_tmp23_ = FALSE;
						_tmp25_ = self->priv->graphic;
						_tmp26_ = gdk_pixbuf_get_width (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = self->priv->graphic;
						_tmp29_ = gdk_pixbuf_get_height (_tmp28_);
						_tmp30_ = _tmp29_;
						if (!(i < ((pixel_bytes * _tmp27_) * _tmp30_))) {
							break;
						}
						_tmp31_ = pixel_data;
						_tmp31__length1 = pixel_data_length1;
						_tmp31_[i] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
					}
				}
			}
			_tmp32_ = self->priv->graphic;
			_tmp33_ = _g_object_ref0 (_tmp32_);
			result = _tmp33_;
			return result;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp34_ = FALSE;
				_tmp34_ = TRUE;
				while (TRUE) {
					gint red_bar_height = 0;
					gint* _tmp36_;
					gint _tmp36__length1;
					gint _tmp37_;
					gint green_bar_height = 0;
					gint* _tmp38_;
					gint _tmp38__length1;
					gint _tmp39_;
					gint blue_bar_height = 0;
					gint* _tmp40_;
					gint _tmp40__length1;
					gint _tmp41_;
					gint max_bar_height = 0;
					gint y = 0;
					gint pixel_index = 0;
					if (!_tmp34_) {
						gint _tmp35_;
						_tmp35_ = x;
						x = _tmp35_ + 1;
					}
					_tmp34_ = FALSE;
					if (!(x < 256)) {
						break;
					}
					_tmp36_ = self->priv->qualitative_red_counts;
					_tmp36__length1 = self->priv->qualitative_red_counts_length1;
					_tmp37_ = _tmp36_[x];
					red_bar_height = (gint) (((gdouble) _tmp37_) * scale_bar);
					_tmp38_ = self->priv->qualitative_green_counts;
					_tmp38__length1 = self->priv->qualitative_green_counts_length1;
					_tmp39_ = _tmp38_[x];
					green_bar_height = (gint) (((gdouble) _tmp39_) * scale_bar);
					_tmp40_ = self->priv->qualitative_blue_counts;
					_tmp40__length1 = self->priv->qualitative_blue_counts_length1;
					_tmp41_ = _tmp40_[x];
					blue_bar_height = (gint) (((gdouble) _tmp41_) * scale_bar);
					max_bar_height = MAX (MAX (red_bar_height, green_bar_height), blue_bar_height);
					y = RGB_HISTOGRAM_GRAPHIC_HEIGHT - 1;
					pixel_index = (x * pixel_bytes) + (y * rowstride);
					{
						gboolean _tmp42_ = FALSE;
						_tmp42_ = TRUE;
						while (TRUE) {
							guchar* _tmp44_;
							gint _tmp44__length1;
							guchar* _tmp45_;
							gint _tmp45__length1;
							guchar* _tmp46_;
							gint _tmp46__length1;
							if (!_tmp42_) {
								gint _tmp43_;
								_tmp43_ = y;
								y = _tmp43_ - 1;
							}
							_tmp42_ = FALSE;
							if (!(y >= (RGB_HISTOGRAM_GRAPHIC_HEIGHT - max_bar_height))) {
								break;
							}
							_tmp44_ = pixel_data;
							_tmp44__length1 = pixel_data_length1;
							_tmp44_[pixel_index] = RGB_HISTOGRAM_MARKED_BACKGROUND;
							_tmp45_ = pixel_data;
							_tmp45__length1 = pixel_data_length1;
							_tmp45_[pixel_index + 1] = RGB_HISTOGRAM_MARKED_BACKGROUND;
							_tmp46_ = pixel_data;
							_tmp46__length1 = pixel_data_length1;
							_tmp46_[pixel_index + 2] = RGB_HISTOGRAM_MARKED_BACKGROUND;
							if (y >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - red_bar_height) - 1)) {
								guchar* _tmp47_;
								gint _tmp47__length1;
								_tmp47_ = pixel_data;
								_tmp47__length1 = pixel_data_length1;
								_tmp47_[pixel_index] = RGB_HISTOGRAM_MARKED_FOREGROUND;
							}
							if (y >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - green_bar_height) - 1)) {
								guchar* _tmp48_;
								gint _tmp48__length1;
								_tmp48_ = pixel_data;
								_tmp48__length1 = pixel_data_length1;
								_tmp48_[pixel_index + 1] = RGB_HISTOGRAM_MARKED_FOREGROUND;
							}
							if (y >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - blue_bar_height) - 1)) {
								guchar* _tmp49_;
								gint _tmp49__length1;
								_tmp49_ = pixel_data;
								_tmp49__length1 = pixel_data_length1;
								_tmp49_[pixel_index + 2] = RGB_HISTOGRAM_MARKED_FOREGROUND;
							}
							pixel_index -= rowstride;
						}
					}
					{
						gboolean _tmp50_ = FALSE;
						_tmp50_ = TRUE;
						while (TRUE) {
							guchar* _tmp52_;
							gint _tmp52__length1;
							guchar* _tmp53_;
							gint _tmp53__length1;
							guchar* _tmp54_;
							gint _tmp54__length1;
							if (!_tmp50_) {
								gint _tmp51_;
								_tmp51_ = y;
								y = _tmp51_ - 1;
							}
							_tmp50_ = FALSE;
							if (!(y >= 0)) {
								break;
							}
							_tmp52_ = pixel_data;
							_tmp52__length1 = pixel_data_length1;
							_tmp52_[pixel_index] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
							_tmp53_ = pixel_data;
							_tmp53__length1 = pixel_data_length1;
							_tmp53_[pixel_index + 1] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
							_tmp54_ = pixel_data;
							_tmp54__length1 = pixel_data_length1;
							_tmp54_[pixel_index + 2] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
							pixel_index -= rowstride;
						}
					}
				}
			}
		}
	}
	_tmp55_ = self->priv->graphic;
	_tmp56_ = _g_object_ref0 (_tmp55_);
	result = _tmp56_;
	return result;
}

static void
value_rgb_histogram_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_rgb_histogram_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rgb_histogram_unref (value->data[0].v_pointer);
	}
}

static void
value_rgb_histogram_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rgb_histogram_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_rgb_histogram_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_rgb_histogram_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RGBHistogram * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rgb_histogram_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_rgb_histogram_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	RGBHistogram ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rgb_histogram_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_rgb_histogram (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecRGBHistogram* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_RGB_HISTOGRAM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_rgb_histogram (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM), NULL);
	return value->data[0].v_pointer;
}

void
value_set_rgb_histogram (GValue* value,
                         gpointer v_object)
{
	RGBHistogram * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RGB_HISTOGRAM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rgb_histogram_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rgb_histogram_unref (old);
	}
}

void
value_take_rgb_histogram (GValue* value,
                          gpointer v_object)
{
	RGBHistogram * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RGB_HISTOGRAM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rgb_histogram_unref (old);
	}
}

static void
rgb_histogram_class_init (RGBHistogramClass * klass,
                          gpointer klass_data)
{
	rgb_histogram_parent_class = g_type_class_peek_parent (klass);
	((RGBHistogramClass *) klass)->finalize = rgb_histogram_finalize;
	g_type_class_adjust_private_offset (klass, &RGBHistogram_private_offset);
}

static void
rgb_histogram_instance_init (RGBHistogram * self,
                             gpointer klass)
{
	gint* _tmp0_;
	gint* _tmp1_;
	gint* _tmp2_;
	self->priv = rgb_histogram_get_instance_private (self);
	_tmp0_ = g_new0 (gint, 256);
	self->priv->red_counts = _tmp0_;
	self->priv->red_counts_length1 = 256;
	self->priv->_red_counts_size_ = self->priv->red_counts_length1;
	_tmp1_ = g_new0 (gint, 256);
	self->priv->green_counts = _tmp1_;
	self->priv->green_counts_length1 = 256;
	self->priv->_green_counts_size_ = self->priv->green_counts_length1;
	_tmp2_ = g_new0 (gint, 256);
	self->priv->blue_counts = _tmp2_;
	self->priv->blue_counts_length1 = 256;
	self->priv->_blue_counts_size_ = self->priv->blue_counts_length1;
	self->priv->qualitative_red_counts = NULL;
	self->priv->qualitative_red_counts_length1 = 0;
	self->priv->_qualitative_red_counts_size_ = self->priv->qualitative_red_counts_length1;
	self->priv->qualitative_green_counts = NULL;
	self->priv->qualitative_green_counts_length1 = 0;
	self->priv->_qualitative_green_counts_size_ = self->priv->qualitative_green_counts_length1;
	self->priv->qualitative_blue_counts = NULL;
	self->priv->qualitative_blue_counts_length1 = 0;
	self->priv->_qualitative_blue_counts_size_ = self->priv->qualitative_blue_counts_length1;
	self->priv->graphic = NULL;
	self->ref_count = 1;
}

static void
rgb_histogram_finalize (RGBHistogram * obj)
{
	RGBHistogram * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_HISTOGRAM, RGBHistogram);
	g_signal_handlers_destroy (self);
	self->priv->red_counts = (g_free (self->priv->red_counts), NULL);
	self->priv->green_counts = (g_free (self->priv->green_counts), NULL);
	self->priv->blue_counts = (g_free (self->priv->blue_counts), NULL);
	self->priv->qualitative_red_counts = (g_free (self->priv->qualitative_red_counts), NULL);
	self->priv->qualitative_green_counts = (g_free (self->priv->qualitative_green_counts), NULL);
	self->priv->qualitative_blue_counts = (g_free (self->priv->qualitative_blue_counts), NULL);
	_g_object_unref0 (self->priv->graphic);
}

static GType
rgb_histogram_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_rgb_histogram_init, value_rgb_histogram_free_value, value_rgb_histogram_copy_value, value_rgb_histogram_peek_pointer, "p", value_rgb_histogram_collect_value, "p", value_rgb_histogram_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RGBHistogramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_histogram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBHistogram), 0, (GInstanceInitFunc) rgb_histogram_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rgb_histogram_type_id;
	rgb_histogram_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RGBHistogram", &g_define_type_info, &g_define_type_fundamental_info, 0);
	RGBHistogram_private_offset = g_type_add_instance_private (rgb_histogram_type_id, sizeof (RGBHistogramPrivate));
	return rgb_histogram_type_id;
}

GType
rgb_histogram_get_type (void)
{
	static volatile gsize rgb_histogram_type_id__once = 0;
	if (g_once_init_enter (&rgb_histogram_type_id__once)) {
		GType rgb_histogram_type_id;
		rgb_histogram_type_id = rgb_histogram_get_type_once ();
		g_once_init_leave (&rgb_histogram_type_id__once, rgb_histogram_type_id);
	}
	return rgb_histogram_type_id__once;
}

gpointer
rgb_histogram_ref (gpointer instance)
{
	RGBHistogram * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rgb_histogram_unref (gpointer instance)
{
	RGBHistogram * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RGB_HISTOGRAM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
intensity_histogram_get_instance_private (IntensityHistogram* self)
{
	return G_STRUCT_MEMBER_P (self, IntensityHistogram_private_offset);
}

IntensityHistogram*
intensity_histogram_construct (GType object_type,
                               GdkPixbuf* pixbuf)
{
	IntensityHistogram* self = NULL;
	gint n_channels = 0;
	gint rowstride = 0;
	gint width = 0;
	gint height = 0;
	gint rowbytes = 0;
	guchar* pixels = NULL;
	guint8* _tmp0_;
	gint pixels_length1;
	gint _pixels_size_;
	gfloat pixel_count = 0.0F;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gfloat accumulator = 0.0F;
	self = (IntensityHistogram*) g_type_create_instance (object_type);
	n_channels = gdk_pixbuf_get_n_channels (pixbuf);
	rowstride = gdk_pixbuf_get_rowstride (pixbuf);
	width = gdk_pixbuf_get_width (pixbuf);
	height = gdk_pixbuf_get_height (pixbuf);
	rowbytes = n_channels * width;
	_tmp0_ = gdk_pixbuf_get_pixels (pixbuf);
	pixels = _tmp0_;
	pixels_length1 = -1;
	_pixels_size_ = pixels_length1;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint row_start_index = 0;
				gint row_end_index = 0;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = j;
					j = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(j < height)) {
					break;
				}
				row_start_index = j * rowstride;
				row_end_index = row_start_index + rowbytes;
				{
					gint i = 0;
					i = row_start_index;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							RGBAnalyticPixel pix_rgb = {0};
							guchar* _tmp4_;
							gint _tmp4__length1;
							guchar _tmp5_;
							guchar* _tmp6_;
							gint _tmp6__length1;
							guchar _tmp7_;
							guchar* _tmp8_;
							gint _tmp8__length1;
							guchar _tmp9_;
							HSVAnalyticPixel pix_hsi = {0};
							RGBAnalyticPixel _tmp10_;
							gint quantized_light_value = 0;
							HSVAnalyticPixel _tmp11_;
							gint* _tmp12_;
							gint _tmp12__length1;
							if (!_tmp3_) {
								i += n_channels;
							}
							_tmp3_ = FALSE;
							if (!(i < row_end_index)) {
								break;
							}
							_tmp4_ = pixels;
							_tmp4__length1 = pixels_length1;
							_tmp5_ = _tmp4_[i];
							_tmp6_ = pixels;
							_tmp6__length1 = pixels_length1;
							_tmp7_ = _tmp6_[i + 1];
							_tmp8_ = pixels;
							_tmp8__length1 = pixels_length1;
							_tmp9_ = _tmp8_[i + 2];
							rgb_analytic_pixel_init_from_quantized_components (&pix_rgb, _tmp5_, _tmp7_, _tmp9_);
							_tmp10_ = pix_rgb;
							hsv_analytic_pixel_init_from_rgb (&pix_hsi, &_tmp10_);
							_tmp11_ = pix_hsi;
							quantized_light_value = (gint) (_tmp11_.light_value * 255.0f);
							_tmp12_ = self->priv->counts;
							_tmp12__length1 = self->priv->counts_length1;
							_tmp12_[quantized_light_value] += 1;
						}
					}
				}
			}
		}
	}
	_tmp13_ = gdk_pixbuf_get_width (pixbuf);
	_tmp14_ = _tmp13_;
	_tmp15_ = gdk_pixbuf_get_height (pixbuf);
	_tmp16_ = _tmp15_;
	pixel_count = (gfloat) (_tmp14_ * _tmp16_);
	accumulator = 0.0f;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gfloat* _tmp19_;
				gint _tmp19__length1;
				gint* _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				gfloat* _tmp22_;
				gint _tmp22__length1;
				gfloat _tmp23_;
				gfloat* _tmp24_;
				gint _tmp24__length1;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				_tmp19_ = self->priv->probabilities;
				_tmp19__length1 = self->priv->probabilities_length1;
				_tmp20_ = self->priv->counts;
				_tmp20__length1 = self->priv->counts_length1;
				_tmp21_ = _tmp20_[i];
				_tmp19_[i] = ((gfloat) _tmp21_) / pixel_count;
				_tmp22_ = self->priv->probabilities;
				_tmp22__length1 = self->priv->probabilities_length1;
				_tmp23_ = _tmp22_[i];
				accumulator += _tmp23_;
				_tmp24_ = self->priv->cumulative_probabilities;
				_tmp24__length1 = self->priv->cumulative_probabilities_length1;
				_tmp24_[i] = accumulator;
			}
		}
	}
	return self;
}

IntensityHistogram*
intensity_histogram_new (GdkPixbuf* pixbuf)
{
	return intensity_histogram_construct (TYPE_INTENSITY_HISTOGRAM, pixbuf);
}

gfloat
intensity_histogram_get_cumulative_probability (IntensityHistogram* self,
                                                gint level)
{
	gfloat* _tmp0_;
	gint _tmp0__length1;
	gfloat _tmp1_;
	gfloat result;
	level = CLAMP (level, 0, 255);
	_tmp0_ = self->priv->cumulative_probabilities;
	_tmp0__length1 = self->priv->cumulative_probabilities_length1;
	_tmp1_ = _tmp0_[level];
	result = _tmp1_;
	return result;
}

static void
value_intensity_histogram_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_intensity_histogram_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		intensity_histogram_unref (value->data[0].v_pointer);
	}
}

static void
value_intensity_histogram_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = intensity_histogram_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_intensity_histogram_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_intensity_histogram_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		IntensityHistogram * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = intensity_histogram_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_intensity_histogram_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	IntensityHistogram ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = intensity_histogram_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_intensity_histogram (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecIntensityHistogram* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_INTENSITY_HISTOGRAM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_intensity_histogram (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM), NULL);
	return value->data[0].v_pointer;
}

void
value_set_intensity_histogram (GValue* value,
                               gpointer v_object)
{
	IntensityHistogram * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INTENSITY_HISTOGRAM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		intensity_histogram_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		intensity_histogram_unref (old);
	}
}

void
value_take_intensity_histogram (GValue* value,
                                gpointer v_object)
{
	IntensityHistogram * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INTENSITY_HISTOGRAM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		intensity_histogram_unref (old);
	}
}

static void
intensity_histogram_class_init (IntensityHistogramClass * klass,
                                gpointer klass_data)
{
	intensity_histogram_parent_class = g_type_class_peek_parent (klass);
	((IntensityHistogramClass *) klass)->finalize = intensity_histogram_finalize;
	g_type_class_adjust_private_offset (klass, &IntensityHistogram_private_offset);
}

static void
intensity_histogram_instance_init (IntensityHistogram * self,
                                   gpointer klass)
{
	gint* _tmp0_;
	gfloat* _tmp1_;
	gfloat* _tmp2_;
	self->priv = intensity_histogram_get_instance_private (self);
	_tmp0_ = g_new0 (gint, 256);
	self->priv->counts = _tmp0_;
	self->priv->counts_length1 = 256;
	self->priv->_counts_size_ = self->priv->counts_length1;
	_tmp1_ = g_new0 (gfloat, 256);
	self->priv->probabilities = _tmp1_;
	self->priv->probabilities_length1 = 256;
	self->priv->_probabilities_size_ = self->priv->probabilities_length1;
	_tmp2_ = g_new0 (gfloat, 256);
	self->priv->cumulative_probabilities = _tmp2_;
	self->priv->cumulative_probabilities_length1 = 256;
	self->priv->_cumulative_probabilities_size_ = self->priv->cumulative_probabilities_length1;
	self->ref_count = 1;
}

static void
intensity_histogram_finalize (IntensityHistogram * obj)
{
	IntensityHistogram * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INTENSITY_HISTOGRAM, IntensityHistogram);
	g_signal_handlers_destroy (self);
	self->priv->counts = (g_free (self->priv->counts), NULL);
	self->priv->probabilities = (g_free (self->priv->probabilities), NULL);
	self->priv->cumulative_probabilities = (g_free (self->priv->cumulative_probabilities), NULL);
}

static GType
intensity_histogram_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_intensity_histogram_init, value_intensity_histogram_free_value, value_intensity_histogram_copy_value, value_intensity_histogram_peek_pointer, "p", value_intensity_histogram_collect_value, "p", value_intensity_histogram_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IntensityHistogramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) intensity_histogram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IntensityHistogram), 0, (GInstanceInitFunc) intensity_histogram_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType intensity_histogram_type_id;
	intensity_histogram_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IntensityHistogram", &g_define_type_info, &g_define_type_fundamental_info, 0);
	IntensityHistogram_private_offset = g_type_add_instance_private (intensity_histogram_type_id, sizeof (IntensityHistogramPrivate));
	return intensity_histogram_type_id;
}

GType
intensity_histogram_get_type (void)
{
	static volatile gsize intensity_histogram_type_id__once = 0;
	if (g_once_init_enter (&intensity_histogram_type_id__once)) {
		GType intensity_histogram_type_id;
		intensity_histogram_type_id = intensity_histogram_get_type_once ();
		g_once_init_leave (&intensity_histogram_type_id__once, intensity_histogram_type_id);
	}
	return intensity_histogram_type_id__once;
}

gpointer
intensity_histogram_ref (gpointer instance)
{
	IntensityHistogram * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
intensity_histogram_unref (gpointer instance)
{
	IntensityHistogram * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		INTENSITY_HISTOGRAM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
expansion_transformation_get_instance_private (ExpansionTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, ExpansionTransformation_private_offset);
}

ExpansionTransformation*
expansion_transformation_construct (GType object_type,
                                    IntensityHistogram* histogram)
{
	ExpansionTransformation* self = NULL;
	gfloat LOW_KINK_MASS = 0.0F;
	gfloat HIGH_KINK_MASS = 0.0F;
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
	LOW_KINK_MASS = EXPANSION_TRANSFORMATION_LOW_DISCARD_MASS;
	self->priv->low_kink = 0;
	while (TRUE) {
		gint _tmp0_;
		if (!(intensity_histogram_get_cumulative_probability (histogram, self->priv->low_kink) < LOW_KINK_MASS)) {
			break;
		}
		_tmp0_ = self->priv->low_kink;
		self->priv->low_kink = _tmp0_ + 1;
	}
	HIGH_KINK_MASS = 1.0f - EXPANSION_TRANSFORMATION_HIGH_DISCARD_MASS;
	self->priv->high_kink = 255;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		if (intensity_histogram_get_cumulative_probability (histogram, self->priv->high_kink) > HIGH_KINK_MASS) {
			_tmp1_ = self->priv->high_kink > 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = self->priv->high_kink;
		self->priv->high_kink = _tmp2_ - 1;
	}
	expansion_transformation_build_remap_table (self);
	return self;
}

ExpansionTransformation*
expansion_transformation_new (IntensityHistogram* histogram)
{
	return expansion_transformation_construct (TYPE_EXPANSION_TRANSFORMATION, histogram);
}

ExpansionTransformation*
expansion_transformation_construct_from_extrema (GType object_type,
                                                 gint black_point,
                                                 gint white_point)
{
	ExpansionTransformation* self = NULL;
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
	white_point = CLAMP (white_point, 0, 255);
	black_point = CLAMP (black_point, 0, 255);
	if (black_point == white_point) {
		if (black_point == 0) {
			white_point = 1;
		} else {
			if (white_point == 255) {
				black_point = 254;
			} else {
				black_point = white_point - 1;
			}
		}
	}
	self->priv->low_kink = black_point;
	self->priv->high_kink = white_point;
	expansion_transformation_build_remap_table (self);
	return self;
}

ExpansionTransformation*
expansion_transformation_new_from_extrema (gint black_point,
                                           gint white_point)
{
	return expansion_transformation_construct_from_extrema (TYPE_EXPANSION_TRANSFORMATION, black_point, white_point);
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

ExpansionTransformation*
expansion_transformation_construct_from_string (GType object_type,
                                                const gchar* encoded_transformation)
{
	ExpansionTransformation* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint num_captured = 0;
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
	g_strcanon (encoded_transformation, "0123456789. ", ' ');
	_tmp0_ = string_chug (encoded_transformation);
	_tmp1_ = _tmp0_;
	_g_free0 (_tmp1_);
	_tmp2_ = string_chomp (encoded_transformation);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp3_);
	num_captured = sscanf (encoded_transformation, "%d %d", &self->priv->low_kink, &self->priv->high_kink);
	_vala_assert (num_captured == 2, "num_captured == 2");
	expansion_transformation_build_remap_table (self);
	return self;
}

ExpansionTransformation*
expansion_transformation_new_from_string (const gchar* encoded_transformation)
{
	return expansion_transformation_construct_from_string (TYPE_EXPANSION_TRANSFORMATION, encoded_transformation);
}

static void
expansion_transformation_build_remap_table (ExpansionTransformation* self)
{
	gfloat low_kink_f = 0.0F;
	gfloat high_kink_f = 0.0F;
	gfloat slope = 0.0F;
	gfloat intercept = 0.0F;
	gint i = 0;
	low_kink_f = ((gfloat) self->priv->low_kink) / 255.0f;
	high_kink_f = ((gfloat) self->priv->high_kink) / 255.0f;
	slope = 1.0f / (high_kink_f - low_kink_f);
	intercept = -(low_kink_f / (high_kink_f - low_kink_f));
	i = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(i <= self->priv->low_kink)) {
				break;
			}
			G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[i] = 0.0f;
		}
	}
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			if (!_tmp2_) {
				gint _tmp3_;
				_tmp3_ = i;
				i = _tmp3_ + 1;
			}
			_tmp2_ = FALSE;
			if (!(i < self->priv->high_kink)) {
				break;
			}
			G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[i] = (slope * (((gfloat) i) / 255.0f)) + intercept;
		}
	}
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			if (!_tmp4_) {
				gint _tmp5_;
				_tmp5_ = i;
				i = _tmp5_ + 1;
			}
			_tmp4_ = FALSE;
			if (!(i < 256)) {
				break;
			}
			G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[i] = 1.0f;
		}
	}
}

static gchar*
expansion_transformation_real_to_string (PixelTransformation* base)
{
	ExpansionTransformation * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
	_tmp0_ = g_strdup_printf ("{ %d, %d }", self->priv->low_kink, self->priv->high_kink);
	result = _tmp0_;
	return result;
}

gint
expansion_transformation_get_white_point (ExpansionTransformation* self)
{
	gint result;
	result = self->priv->high_kink;
	return result;
}

gint
expansion_transformation_get_black_point (ExpansionTransformation* self)
{
	gint result;
	result = self->priv->low_kink;
	return result;
}

static gboolean
expansion_transformation_real_is_identity (PixelTransformation* base)
{
	ExpansionTransformation * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
	if (self->priv->low_kink == 0) {
		_tmp0_ = self->priv->high_kink == 255;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static PixelTransformation*
expansion_transformation_real_copy (PixelTransformation* base)
{
	ExpansionTransformation * self;
	ExpansionTransformation* _tmp0_;
	PixelTransformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
	_tmp0_ = expansion_transformation_new_from_extrema (self->priv->low_kink, self->priv->high_kink);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
	return result;
}

static void
expansion_transformation_class_init (ExpansionTransformationClass * klass,
                                     gpointer klass_data)
{
	expansion_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = expansion_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &ExpansionTransformation_private_offset);
	((PixelTransformationClass *) klass)->to_string = (gchar* (*) (PixelTransformation*)) expansion_transformation_real_to_string;
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation*)) expansion_transformation_real_is_identity;
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation*)) expansion_transformation_real_copy;
}

static void
expansion_transformation_instance_init (ExpansionTransformation * self,
                                        gpointer klass)
{
	self->priv = expansion_transformation_get_instance_private (self);
}

static void
expansion_transformation_finalize (PixelTransformation * obj)
{
	ExpansionTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
	PIXEL_TRANSFORMATION_CLASS (expansion_transformation_parent_class)->finalize (obj);
}

static GType
expansion_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExpansionTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expansion_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpansionTransformation), 0, (GInstanceInitFunc) expansion_transformation_instance_init, NULL };
	GType expansion_transformation_type_id;
	expansion_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "ExpansionTransformation", &g_define_type_info, 0);
	ExpansionTransformation_private_offset = g_type_add_instance_private (expansion_transformation_type_id, sizeof (ExpansionTransformationPrivate));
	return expansion_transformation_type_id;
}

GType
expansion_transformation_get_type (void)
{
	static volatile gsize expansion_transformation_type_id__once = 0;
	if (g_once_init_enter (&expansion_transformation_type_id__once)) {
		GType expansion_transformation_type_id;
		expansion_transformation_type_id = expansion_transformation_get_type_once ();
		g_once_init_leave (&expansion_transformation_type_id__once, expansion_transformation_type_id);
	}
	return expansion_transformation_type_id__once;
}

static inline gpointer
shadow_detail_transformation_get_instance_private (ShadowDetailTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, ShadowDetailTransformation_private_offset);
}

ShadowDetailTransformation*
shadow_detail_transformation_construct (GType object_type,
                                        gfloat user_intensity)
{
	ShadowDetailTransformation* self = NULL;
	gfloat intensity_adj = 0.0F;
	gfloat effect_shift = 0.0F;
	HermiteGammaApproximationFunction* func = NULL;
	HermiteGammaApproximationFunction* _tmp0_;
	self = (ShadowDetailTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_SHADOWS);
	self->priv->intensity = user_intensity;
	intensity_adj = CLAMP (self->priv->intensity / SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER, 0.0f, 1.0f);
	effect_shift = SHADOW_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT * intensity_adj;
	_tmp0_ = hermite_gamma_approximation_function_new (SHADOW_DETAIL_TRANSFORMATION_TONAL_WIDTH);
	func = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gfloat x = 0.0F;
				gfloat weight = 0.0F;
				HermiteGammaApproximationFunction* _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				x = ((gfloat) i) / 255.0f;
				_tmp3_ = func;
				weight = hermite_gamma_approximation_function_evaluate (_tmp3_, x);
				G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[i] = (weight * (x + effect_shift)) + ((1.0f - weight) * x);
			}
		}
	}
	_hermite_gamma_approximation_function_unref0 (func);
	return self;
}

ShadowDetailTransformation*
shadow_detail_transformation_new (gfloat user_intensity)
{
	return shadow_detail_transformation_construct (TYPE_SHADOW_DETAIL_TRANSFORMATION, user_intensity);
}

static PixelTransformation*
shadow_detail_transformation_real_copy (PixelTransformation* base)
{
	ShadowDetailTransformation * self;
	ShadowDetailTransformation* _tmp0_;
	PixelTransformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
	_tmp0_ = shadow_detail_transformation_new (self->priv->intensity);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
	return result;
}

static gboolean
shadow_detail_transformation_real_is_identity (PixelTransformation* base)
{
	ShadowDetailTransformation * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
	result = self->priv->intensity == 0.0f;
	return result;
}

gfloat
shadow_detail_transformation_get_parameter (ShadowDetailTransformation* self)
{
	gfloat result;
	result = self->priv->intensity;
	return result;
}

static void
shadow_detail_transformation_class_init (ShadowDetailTransformationClass * klass,
                                         gpointer klass_data)
{
	shadow_detail_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = shadow_detail_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &ShadowDetailTransformation_private_offset);
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation*)) shadow_detail_transformation_real_copy;
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation*)) shadow_detail_transformation_real_is_identity;
}

static void
shadow_detail_transformation_instance_init (ShadowDetailTransformation * self,
                                            gpointer klass)
{
	self->priv = shadow_detail_transformation_get_instance_private (self);
	self->priv->intensity = 0.0f;
}

static void
shadow_detail_transformation_finalize (PixelTransformation * obj)
{
	ShadowDetailTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
	PIXEL_TRANSFORMATION_CLASS (shadow_detail_transformation_parent_class)->finalize (obj);
}

static GType
shadow_detail_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShadowDetailTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shadow_detail_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShadowDetailTransformation), 0, (GInstanceInitFunc) shadow_detail_transformation_instance_init, NULL };
	GType shadow_detail_transformation_type_id;
	shadow_detail_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "ShadowDetailTransformation", &g_define_type_info, 0);
	ShadowDetailTransformation_private_offset = g_type_add_instance_private (shadow_detail_transformation_type_id, sizeof (ShadowDetailTransformationPrivate));
	return shadow_detail_transformation_type_id;
}

GType
shadow_detail_transformation_get_type (void)
{
	static volatile gsize shadow_detail_transformation_type_id__once = 0;
	if (g_once_init_enter (&shadow_detail_transformation_type_id__once)) {
		GType shadow_detail_transformation_type_id;
		shadow_detail_transformation_type_id = shadow_detail_transformation_get_type_once ();
		g_once_init_leave (&shadow_detail_transformation_type_id__once, shadow_detail_transformation_type_id);
	}
	return shadow_detail_transformation_type_id__once;
}

static inline gpointer
hermite_gamma_approximation_function_get_instance_private (HermiteGammaApproximationFunction* self)
{
	return G_STRUCT_MEMBER_P (self, HermiteGammaApproximationFunction_private_offset);
}

HermiteGammaApproximationFunction*
hermite_gamma_approximation_function_construct (GType object_type,
                                                gfloat user_interval_upper)
{
	HermiteGammaApproximationFunction* self = NULL;
	self = (HermiteGammaApproximationFunction*) g_type_create_instance (object_type);
	self->priv->nonzero_interval_upper = CLAMP (user_interval_upper, 0.1f, 1.0f);
	self->priv->x_scale = 1.0f / self->priv->nonzero_interval_upper;
	return self;
}

HermiteGammaApproximationFunction*
hermite_gamma_approximation_function_new (gfloat user_interval_upper)
{
	return hermite_gamma_approximation_function_construct (TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, user_interval_upper);
}

gfloat
hermite_gamma_approximation_function_evaluate (HermiteGammaApproximationFunction* self,
                                               gfloat x)
{
	gfloat result;
	if (x < 0.0f) {
		result = 0.0f;
		return result;
	} else {
		if (x > self->priv->nonzero_interval_upper) {
			result = 0.0f;
			return result;
		} else {
			gfloat indep_var = 0.0F;
			gfloat dep_var = 0.0F;
			indep_var = self->priv->x_scale * x;
			dep_var = 6.0f * ((((indep_var * indep_var) * indep_var) - (2.0f * (indep_var * indep_var))) + indep_var);
			result = CLAMP (dep_var, 0.0f, 1.0f);
			return result;
		}
	}
}

static void
value_hermite_gamma_approximation_function_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_hermite_gamma_approximation_function_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		hermite_gamma_approximation_function_unref (value->data[0].v_pointer);
	}
}

static void
value_hermite_gamma_approximation_function_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = hermite_gamma_approximation_function_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_hermite_gamma_approximation_function_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_hermite_gamma_approximation_function_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		HermiteGammaApproximationFunction * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = hermite_gamma_approximation_function_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_hermite_gamma_approximation_function_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	HermiteGammaApproximationFunction ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = hermite_gamma_approximation_function_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_hermite_gamma_approximation_function (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	ParamSpecHermiteGammaApproximationFunction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_hermite_gamma_approximation_function (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_hermite_gamma_approximation_function (GValue* value,
                                                gpointer v_object)
{
	HermiteGammaApproximationFunction * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		hermite_gamma_approximation_function_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hermite_gamma_approximation_function_unref (old);
	}
}

void
value_take_hermite_gamma_approximation_function (GValue* value,
                                                 gpointer v_object)
{
	HermiteGammaApproximationFunction * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hermite_gamma_approximation_function_unref (old);
	}
}

static void
hermite_gamma_approximation_function_class_init (HermiteGammaApproximationFunctionClass * klass,
                                                 gpointer klass_data)
{
	hermite_gamma_approximation_function_parent_class = g_type_class_peek_parent (klass);
	((HermiteGammaApproximationFunctionClass *) klass)->finalize = hermite_gamma_approximation_function_finalize;
	g_type_class_adjust_private_offset (klass, &HermiteGammaApproximationFunction_private_offset);
}

static void
hermite_gamma_approximation_function_instance_init (HermiteGammaApproximationFunction * self,
                                                    gpointer klass)
{
	self->priv = hermite_gamma_approximation_function_get_instance_private (self);
	self->priv->x_scale = 1.0f;
	self->priv->nonzero_interval_upper = 1.0f;
	self->ref_count = 1;
}

static void
hermite_gamma_approximation_function_finalize (HermiteGammaApproximationFunction * obj)
{
	HermiteGammaApproximationFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunction);
	g_signal_handlers_destroy (self);
}

static GType
hermite_gamma_approximation_function_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_hermite_gamma_approximation_function_init, value_hermite_gamma_approximation_function_free_value, value_hermite_gamma_approximation_function_copy_value, value_hermite_gamma_approximation_function_peek_pointer, "p", value_hermite_gamma_approximation_function_collect_value, "p", value_hermite_gamma_approximation_function_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HermiteGammaApproximationFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hermite_gamma_approximation_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HermiteGammaApproximationFunction), 0, (GInstanceInitFunc) hermite_gamma_approximation_function_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType hermite_gamma_approximation_function_type_id;
	hermite_gamma_approximation_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HermiteGammaApproximationFunction", &g_define_type_info, &g_define_type_fundamental_info, 0);
	HermiteGammaApproximationFunction_private_offset = g_type_add_instance_private (hermite_gamma_approximation_function_type_id, sizeof (HermiteGammaApproximationFunctionPrivate));
	return hermite_gamma_approximation_function_type_id;
}

GType
hermite_gamma_approximation_function_get_type (void)
{
	static volatile gsize hermite_gamma_approximation_function_type_id__once = 0;
	if (g_once_init_enter (&hermite_gamma_approximation_function_type_id__once)) {
		GType hermite_gamma_approximation_function_type_id;
		hermite_gamma_approximation_function_type_id = hermite_gamma_approximation_function_get_type_once ();
		g_once_init_leave (&hermite_gamma_approximation_function_type_id__once, hermite_gamma_approximation_function_type_id);
	}
	return hermite_gamma_approximation_function_type_id__once;
}

gpointer
hermite_gamma_approximation_function_ref (gpointer instance)
{
	HermiteGammaApproximationFunction * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
hermite_gamma_approximation_function_unref (gpointer instance)
{
	HermiteGammaApproximationFunction * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
highlight_detail_transformation_get_instance_private (HighlightDetailTransformation* self)
{
	return G_STRUCT_MEMBER_P (self, HighlightDetailTransformation_private_offset);
}

HighlightDetailTransformation*
highlight_detail_transformation_construct (GType object_type,
                                           gfloat user_intensity)
{
	HighlightDetailTransformation* self = NULL;
	gfloat intensity_adj = 0.0F;
	gfloat effect_shift = 0.0F;
	HermiteGammaApproximationFunction* func = NULL;
	HermiteGammaApproximationFunction* _tmp0_;
	self = (HighlightDetailTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS);
	self->priv->intensity = user_intensity;
	intensity_adj = CLAMP (self->priv->intensity / HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_PARAMETER, 0.0f, 1.0f);
	effect_shift = HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT * intensity_adj;
	_tmp0_ = hermite_gamma_approximation_function_new (HIGHLIGHT_DETAIL_TRANSFORMATION_TONAL_WIDTH);
	func = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gfloat x = 0.0F;
				gfloat weight = 0.0F;
				HermiteGammaApproximationFunction* _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 256)) {
					break;
				}
				x = ((gfloat) i) / 255.0f;
				_tmp3_ = func;
				weight = hermite_gamma_approximation_function_evaluate (_tmp3_, 1.0f - x);
				G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[i] = (weight * (x - effect_shift)) + ((1.0f - weight) * x);
			}
		}
	}
	_hermite_gamma_approximation_function_unref0 (func);
	return self;
}

HighlightDetailTransformation*
highlight_detail_transformation_new (gfloat user_intensity)
{
	return highlight_detail_transformation_construct (TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, user_intensity);
}

static PixelTransformation*
highlight_detail_transformation_real_copy (PixelTransformation* base)
{
	HighlightDetailTransformation * self;
	HighlightDetailTransformation* _tmp0_;
	PixelTransformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
	_tmp0_ = highlight_detail_transformation_new (self->priv->intensity);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
	return result;
}

static gboolean
highlight_detail_transformation_real_is_identity (PixelTransformation* base)
{
	HighlightDetailTransformation * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
	result = self->priv->intensity == 0.0f;
	return result;
}

gfloat
highlight_detail_transformation_get_parameter (HighlightDetailTransformation* self)
{
	gfloat result;
	result = self->priv->intensity;
	return result;
}

static void
highlight_detail_transformation_class_init (HighlightDetailTransformationClass * klass,
                                            gpointer klass_data)
{
	highlight_detail_transformation_parent_class = g_type_class_peek_parent (klass);
	((PixelTransformationClass *) klass)->finalize = highlight_detail_transformation_finalize;
	g_type_class_adjust_private_offset (klass, &HighlightDetailTransformation_private_offset);
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation*)) highlight_detail_transformation_real_copy;
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation*)) highlight_detail_transformation_real_is_identity;
}

static void
highlight_detail_transformation_instance_init (HighlightDetailTransformation * self,
                                               gpointer klass)
{
	self->priv = highlight_detail_transformation_get_instance_private (self);
	self->priv->intensity = 0.0f;
}

static void
highlight_detail_transformation_finalize (PixelTransformation * obj)
{
	HighlightDetailTransformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
	PIXEL_TRANSFORMATION_CLASS (highlight_detail_transformation_parent_class)->finalize (obj);
}

static GType
highlight_detail_transformation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HighlightDetailTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) highlight_detail_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HighlightDetailTransformation), 0, (GInstanceInitFunc) highlight_detail_transformation_instance_init, NULL };
	GType highlight_detail_transformation_type_id;
	highlight_detail_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "HighlightDetailTransformation", &g_define_type_info, 0);
	HighlightDetailTransformation_private_offset = g_type_add_instance_private (highlight_detail_transformation_type_id, sizeof (HighlightDetailTransformationPrivate));
	return highlight_detail_transformation_type_id;
}

GType
highlight_detail_transformation_get_type (void)
{
	static volatile gsize highlight_detail_transformation_type_id__once = 0;
	if (g_once_init_enter (&highlight_detail_transformation_type_id__once)) {
		GType highlight_detail_transformation_type_id;
		highlight_detail_transformation_type_id = highlight_detail_transformation_get_type_once ();
		g_once_init_leave (&highlight_detail_transformation_type_id__once, highlight_detail_transformation_type_id);
	}
	return highlight_detail_transformation_type_id__once;
}

PixelTransformationBundle*
auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf)
{
	PixelTransformationBundle* adjustments = NULL;
	PixelTransformationBundle* _tmp0_;
	IntensityHistogram* analysis_histogram = NULL;
	IntensityHistogram* _tmp1_;
	gfloat pct_in_range = 0.0F;
	IntensityHistogram* _tmp2_;
	IntensityHistogram* _tmp3_;
	gfloat shadow_range_mean_prob_val = 0.0F;
	IntensityHistogram* _tmp4_;
	IntensityHistogram* _tmp5_;
	gint shadow_mean_intensity = 0;
	gboolean _tmp9_ = FALSE;
	PixelTransformationBundle* _tmp27_;
	HighlightDetailTransformation* _tmp28_;
	HighlightDetailTransformation* _tmp29_;
	PixelTransformationBundle* _tmp30_;
	TemperatureTransformation* _tmp31_;
	TemperatureTransformation* _tmp32_;
	PixelTransformationBundle* _tmp33_;
	TintTransformation* _tmp34_;
	TintTransformation* _tmp35_;
	PixelTransformationBundle* _tmp36_;
	ExposureTransformation* _tmp37_;
	ExposureTransformation* _tmp38_;
	PixelTransformationBundle* _tmp39_;
	ContrastTransformation* _tmp40_;
	ContrastTransformation* _tmp41_;
	PixelTransformationBundle* _tmp42_;
	SaturationTransformation* _tmp43_;
	SaturationTransformation* _tmp44_;
	PixelTransformationBundle* result;
	_tmp0_ = pixel_transformation_bundle_new ();
	adjustments = _tmp0_;
	_tmp1_ = intensity_histogram_new (pixbuf);
	analysis_histogram = _tmp1_;
	_tmp2_ = analysis_histogram;
	_tmp3_ = analysis_histogram;
	pct_in_range = 100.0f * (intensity_histogram_get_cumulative_probability (_tmp2_, AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY) - intensity_histogram_get_cumulative_probability (_tmp3_, AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY));
	_tmp4_ = analysis_histogram;
	_tmp5_ = analysis_histogram;
	shadow_range_mean_prob_val = (intensity_histogram_get_cumulative_probability (_tmp4_, AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY) + intensity_histogram_get_cumulative_probability (_tmp5_, AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY)) * 0.5f;
	shadow_mean_intensity = AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			IntensityHistogram* _tmp8_;
			if (!_tmp6_) {
				gint _tmp7_;
				_tmp7_ = shadow_mean_intensity;
				shadow_mean_intensity = _tmp7_ + 1;
			}
			_tmp6_ = FALSE;
			if (!(shadow_mean_intensity <= AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY)) {
				break;
			}
			_tmp8_ = analysis_histogram;
			if (intensity_histogram_get_cumulative_probability (_tmp8_, shadow_mean_intensity) >= shadow_range_mean_prob_val) {
				break;
			}
		}
	}
	if (pct_in_range > 40.0f) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		if (pct_in_range > 20.0f) {
			_tmp10_ = shadow_mean_intensity < AUTO_ENHANCE_EMPIRICAL_DARK;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp9_ = _tmp10_;
	}
	if (_tmp9_) {
		gfloat shadow_trans_effect_size = 0.0F;
		PixelTransformationBundle* _tmp11_;
		ShadowDetailTransformation* _tmp12_;
		ShadowDetailTransformation* _tmp13_;
		gint discard_point = 0;
		PixelTransformationBundle* _tmp17_;
		ExpansionTransformation* _tmp18_;
		ExpansionTransformation* _tmp19_;
		shadow_trans_effect_size = ((((gfloat) AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY) - ((gfloat) shadow_mean_intensity)) / ((gfloat) AUTO_ENHANCE_SHADOW_DETECT_INTENSITY_RANGE)) * SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER;
		shadow_trans_effect_size *= AUTO_ENHANCE_SHADOW_AGGRESSIVENESS_MUL;
		_tmp11_ = adjustments;
		_tmp12_ = shadow_detail_transformation_new (shadow_trans_effect_size);
		_tmp13_ = _tmp12_;
		pixel_transformation_bundle_set (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
		_pixel_transformation_unref0 (_tmp13_);
		discard_point = 255;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				IntensityHistogram* _tmp16_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = discard_point;
					discard_point = _tmp15_ - 1;
				}
				_tmp14_ = FALSE;
				if (!(discard_point > -1)) {
					break;
				}
				_tmp16_ = analysis_histogram;
				if ((1.0f - intensity_histogram_get_cumulative_probability (_tmp16_, discard_point)) > AUTO_ENHANCE_SHADOW_MODE_HIGH_DISCARD_MASS) {
					break;
				}
			}
		}
		_tmp17_ = adjustments;
		_tmp18_ = expansion_transformation_new_from_extrema (0, discard_point);
		_tmp19_ = _tmp18_;
		pixel_transformation_bundle_set (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
		_pixel_transformation_unref0 (_tmp19_);
	} else {
		PixelTransformationBundle* _tmp20_;
		IntensityHistogram* _tmp21_;
		ExpansionTransformation* _tmp22_;
		ExpansionTransformation* _tmp23_;
		PixelTransformationBundle* _tmp24_;
		ShadowDetailTransformation* _tmp25_;
		ShadowDetailTransformation* _tmp26_;
		_tmp20_ = adjustments;
		_tmp21_ = analysis_histogram;
		_tmp22_ = expansion_transformation_new (_tmp21_);
		_tmp23_ = _tmp22_;
		pixel_transformation_bundle_set (_tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
		_pixel_transformation_unref0 (_tmp23_);
		_tmp24_ = adjustments;
		_tmp25_ = shadow_detail_transformation_new ((gfloat) 0);
		_tmp26_ = _tmp25_;
		pixel_transformation_bundle_set (_tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
		_pixel_transformation_unref0 (_tmp26_);
	}
	_tmp27_ = adjustments;
	_tmp28_ = highlight_detail_transformation_new (0.0f);
	_tmp29_ = _tmp28_;
	pixel_transformation_bundle_set (_tmp27_, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp29_);
	_tmp30_ = adjustments;
	_tmp31_ = temperature_transformation_new (0.0f);
	_tmp32_ = _tmp31_;
	pixel_transformation_bundle_set (_tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp32_);
	_tmp33_ = adjustments;
	_tmp34_ = tint_transformation_new (0.0f);
	_tmp35_ = _tmp34_;
	pixel_transformation_bundle_set (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp35_);
	_tmp36_ = adjustments;
	_tmp37_ = exposure_transformation_new (0.0f);
	_tmp38_ = _tmp37_;
	pixel_transformation_bundle_set (_tmp36_, G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp38_);
	_tmp39_ = adjustments;
	_tmp40_ = contrast_transformation_new (0.0f);
	_tmp41_ = _tmp40_;
	pixel_transformation_bundle_set (_tmp39_, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp41_);
	_tmp42_ = adjustments;
	_tmp43_ = saturation_transformation_new (0.0f);
	_tmp44_ = _tmp43_;
	pixel_transformation_bundle_set (_tmp42_, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
	_pixel_transformation_unref0 (_tmp44_);
	result = adjustments;
	_intensity_histogram_unref0 (analysis_histogram);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

