/* FaceLocationTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FaceLocationTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <gee.h>

#define FACE_LOCATION_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FACE_LOCATION_ID (face_location_id_get_type ())
typedef struct _FaceLocationID FaceLocationID;

#define TYPE_FACE_LOCATION_ROW (face_location_row_get_type ())
#define FACE_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION_ROW, FaceLocationRow))
#define FACE_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION_ROW, FaceLocationRowClass))
#define IS_FACE_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION_ROW))
#define IS_FACE_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION_ROW))
#define FACE_LOCATION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION_ROW, FaceLocationRowClass))

typedef struct _FaceLocationRow FaceLocationRow;
typedef struct _FaceLocationRowClass FaceLocationRowClass;
typedef struct _FaceLocationRowPrivate FaceLocationRowPrivate;

#define TYPE_FACE_ID (face_id_get_type ())
typedef struct _FaceID FaceID;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecFaceLocationRow ParamSpecFaceLocationRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_FACE_LOCATION_TABLE (face_location_table_get_type ())
#define FACE_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION_TABLE, FaceLocationTable))
#define FACE_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION_TABLE, FaceLocationTableClass))
#define IS_FACE_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION_TABLE))
#define IS_FACE_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION_TABLE))
#define FACE_LOCATION_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION_TABLE, FaceLocationTableClass))

typedef struct _FaceLocationTable FaceLocationTable;
typedef struct _FaceLocationTableClass FaceLocationTableClass;
typedef struct _FaceLocationTablePrivate FaceLocationTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _face_location_row_unref0(var) ((var == NULL) ? NULL : (var = (face_location_row_unref (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_FACE (face_get_type ())
#define FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE, Face))
#define FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE, FaceClass))
#define IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE))
#define IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE))
#define FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE, FaceClass))

typedef struct _Face Face;
typedef struct _FaceClass FaceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_FACE_LOCATION (face_location_get_type ())
#define FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION, FaceLocation))
#define FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION, FaceLocationClass))
#define IS_FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION))
#define IS_FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION))
#define FACE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION, FaceLocationClass))

typedef struct _FaceLocation FaceLocation;
typedef struct _FaceLocationClass FaceLocationClass;

#define TYPE_FACE_LOCATION_DATA (face_location_data_get_type ())
typedef struct _FaceLocationData FaceLocationData;

#define TYPE_FACE_ROW (face_row_get_type ())
#define FACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_ROW, FaceRow))
#define FACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_ROW, FaceRowClass))
#define IS_FACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_ROW))
#define IS_FACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_ROW))
#define FACE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_ROW, FaceRowClass))

typedef struct _FaceRow FaceRow;
typedef struct _FaceRowClass FaceRowClass;
#define _face_row_unref0(var) ((var == NULL) ? NULL : (var = (face_row_unref (var), NULL)))
typedef struct _FaceRowPrivate FaceRowPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FaceLocationID {
	gint64 id;
};

struct _FaceID {
	gint64 id;
};

struct _PhotoID {
	gint64 id;
};

struct _FaceLocationRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FaceLocationRowPrivate * priv;
	FaceLocationID face_location_id;
	FaceID face_id;
	PhotoID photo_id;
	gchar* geometry;
	gchar* vec;
};

struct _FaceLocationRowClass {
	GTypeClass parent_class;
	void (*finalize) (FaceLocationRow *self);
};

struct _ParamSpecFaceLocationRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _FaceLocationTable {
	DatabaseTable parent_instance;
	FaceLocationTablePrivate * priv;
};

struct _FaceLocationTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _FaceLocationData {
	gchar* geometry;
	gchar* vec;
};

struct _FaceRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FaceRowPrivate * priv;
	FaceID face_id;
	gchar* name;
	gint64 time_created;
	PhotoID ref;
	gchar* vec;
};

struct _FaceRowClass {
	GTypeClass parent_class;
	void (*finalize) (FaceRow *self);
};

static gpointer face_location_row_parent_class = NULL;
static gpointer face_location_table_parent_class = NULL;
static FaceLocationTable* face_location_table_instance;
static FaceLocationTable* face_location_table_instance = NULL;
VALA_EXTERN sqlite3* database_table_db;

VALA_EXTERN GType face_location_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceLocationID* face_location_id_dup (const FaceLocationID* self);
VALA_EXTERN void face_location_id_free (FaceLocationID* self);
VALA_EXTERN void face_location_id_init (FaceLocationID *self,
                            gint64 id);
VALA_EXTERN gboolean face_location_id_is_invalid (FaceLocationID *self);
VALA_EXTERN gboolean face_location_id_is_valid (FaceLocationID *self);
VALA_EXTERN gpointer face_location_row_ref (gpointer instance);
VALA_EXTERN void face_location_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_face_location_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_face_location_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_face_location_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_face_location_row (const GValue* value);
VALA_EXTERN GType face_location_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocationRow, face_location_row_unref)
VALA_EXTERN GType face_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceID* face_id_dup (const FaceID* self);
VALA_EXTERN void face_id_free (FaceID* self);
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN FaceLocationRow* face_location_row_new (void);
VALA_EXTERN FaceLocationRow* face_location_row_construct (GType object_type);
static void face_location_row_finalize (FaceLocationRow * obj);
static GType face_location_row_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType face_location_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocationTable, database_table_unref)
static FaceLocationTable* face_location_table_new (void);
static FaceLocationTable* face_location_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN FaceLocationTable* face_location_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceLocationRow* face_location_table_add (FaceLocationTable* self,
                                          FaceID* face_id,
                                          PhotoID* photo_id,
                                          const gchar* geometry,
                                          const gchar* vec,
                                          GError** error);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
VALA_EXTERN GeeList* face_location_table_get_all_rows (FaceLocationTable* self,
                                           GError** error);
VALA_EXTERN void face_id_init (FaceID *self,
                   gint64 id);
VALA_EXTERN void photo_id_init (PhotoID *self,
                    gint64 id);
VALA_EXTERN GeeArrayList* face_location_table_get_face_source_ids (FaceLocationTable* self,
                                                       FaceID* face_id);
VALA_EXTERN gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Face, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN gchar* face_location_table_get_face_source_serialized_geometry (FaceLocationTable* self,
                                                                Face* face,
                                                                MediaSource* source,
                                                                GError** error);
VALA_EXTERN gint64 data_source_get_instance_id (DataSource* self);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN void face_location_table_remove_face_from_source (FaceLocationTable* self,
                                                  FaceID* face_id,
                                                  PhotoID* photo_id,
                                                  GError** error);
VALA_EXTERN GType face_location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocation, g_object_unref)
VALA_EXTERN void face_location_table_update_face_location_serialized_geometry (FaceLocationTable* self,
                                                                   FaceLocation* face_location,
                                                                   GError** error);
VALA_EXTERN gchar* face_location_get_serialized_geometry (FaceLocation* self);
VALA_EXTERN void face_location_get_face_location_id (FaceLocation* self,
                                         FaceLocationID* result);
VALA_EXTERN void face_location_table_update_face_location_face_data (FaceLocationTable* self,
                                                         FaceLocation* face_location,
                                                         GError** error);
VALA_EXTERN GType face_location_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceLocationData* face_location_data_dup (const FaceLocationData* self);
VALA_EXTERN void face_location_data_free (FaceLocationData* self);
VALA_EXTERN void face_location_data_copy (const FaceLocationData* self,
                              FaceLocationData* dest);
VALA_EXTERN void face_location_data_destroy (FaceLocationData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FaceLocationData, face_location_data_destroy)
VALA_EXTERN void face_location_get_face_data (FaceLocation* self,
                                  FaceLocationData* result);
VALA_EXTERN gpointer face_row_ref (gpointer instance);
VALA_EXTERN void face_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_face_row (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_face_row (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_face_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_face_row (const GValue* value);
VALA_EXTERN GType face_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceRow, face_row_unref)
VALA_EXTERN GeeList* face_location_table_get_face_ref_vecs (FaceLocationTable* self,
                                                GeeList* face_rows,
                                                GError** error);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void face_location_table_finalize (DatabaseTable * obj);
static GType face_location_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
face_location_id_init (FaceLocationID *self,
                       gint64 id)
{
	memset (self, 0, sizeof (FaceLocationID));
	(*self).id = id;
}

gboolean
face_location_id_is_invalid (FaceLocationID *self)
{
	gboolean result;
	result = (*self).id == FACE_LOCATION_ID_INVALID;
	return result;
}

gboolean
face_location_id_is_valid (FaceLocationID *self)
{
	gboolean result;
	result = (*self).id != FACE_LOCATION_ID_INVALID;
	return result;
}

FaceLocationID*
face_location_id_dup (const FaceLocationID* self)
{
	FaceLocationID* dup;
	dup = g_new0 (FaceLocationID, 1);
	memcpy (dup, self, sizeof (FaceLocationID));
	return dup;
}

void
face_location_id_free (FaceLocationID* self)
{
	g_free (self);
}

static GType
face_location_id_get_type_once (void)
{
	GType face_location_id_type_id;
	face_location_id_type_id = g_boxed_type_register_static ("FaceLocationID", (GBoxedCopyFunc) face_location_id_dup, (GBoxedFreeFunc) face_location_id_free);
	return face_location_id_type_id;
}

GType
face_location_id_get_type (void)
{
	static volatile gsize face_location_id_type_id__once = 0;
	if (g_once_init_enter (&face_location_id_type_id__once)) {
		GType face_location_id_type_id;
		face_location_id_type_id = face_location_id_get_type_once ();
		g_once_init_leave (&face_location_id_type_id__once, face_location_id_type_id);
	}
	return face_location_id_type_id__once;
}

FaceLocationRow*
face_location_row_construct (GType object_type)
{
	FaceLocationRow* self = NULL;
	self = (FaceLocationRow*) g_type_create_instance (object_type);
	return self;
}

FaceLocationRow*
face_location_row_new (void)
{
	return face_location_row_construct (TYPE_FACE_LOCATION_ROW);
}

static void
value_face_location_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_face_location_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		face_location_row_unref (value->data[0].v_pointer);
	}
}

static void
value_face_location_row_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = face_location_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_face_location_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_face_location_row_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FaceLocationRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = face_location_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_face_location_row_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	FaceLocationRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = face_location_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_face_location_row (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecFaceLocationRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FACE_LOCATION_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_face_location_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_LOCATION_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_face_location_row (GValue* value,
                             gpointer v_object)
{
	FaceLocationRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_LOCATION_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FACE_LOCATION_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		face_location_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		face_location_row_unref (old);
	}
}

void
value_take_face_location_row (GValue* value,
                              gpointer v_object)
{
	FaceLocationRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_LOCATION_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FACE_LOCATION_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		face_location_row_unref (old);
	}
}

static void
face_location_row_class_init (FaceLocationRowClass * klass,
                              gpointer klass_data)
{
	face_location_row_parent_class = g_type_class_peek_parent (klass);
	((FaceLocationRowClass *) klass)->finalize = face_location_row_finalize;
}

static void
face_location_row_instance_init (FaceLocationRow * self,
                                 gpointer klass)
{
	self->ref_count = 1;
}

static void
face_location_row_finalize (FaceLocationRow * obj)
{
	FaceLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_LOCATION_ROW, FaceLocationRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->geometry);
	_g_free0 (self->vec);
}

static GType
face_location_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_face_location_row_init, value_face_location_row_free_value, value_face_location_row_copy_value, value_face_location_row_peek_pointer, "p", value_face_location_row_collect_value, "p", value_face_location_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FaceLocationRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_location_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceLocationRow), 0, (GInstanceInitFunc) face_location_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType face_location_row_type_id;
	face_location_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FaceLocationRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return face_location_row_type_id;
}

GType
face_location_row_get_type (void)
{
	static volatile gsize face_location_row_type_id__once = 0;
	if (g_once_init_enter (&face_location_row_type_id__once)) {
		GType face_location_row_type_id;
		face_location_row_type_id = face_location_row_get_type_once ();
		g_once_init_leave (&face_location_row_type_id__once, face_location_row_type_id);
	}
	return face_location_row_type_id__once;
}

gpointer
face_location_row_ref (gpointer instance)
{
	FaceLocationRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
face_location_row_unref (gpointer instance)
{
	FaceLocationRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FACE_LOCATION_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static FaceLocationTable*
face_location_table_construct (GType object_type)
{
	FaceLocationTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	self = (FaceLocationTable*) database_table_construct (object_type);
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "FaceLocationTable");
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "FaceLocationTable " "(" "id INTEGER NOT NULL PRIMARY KEY, " "face_id INTEGER NOT NULL, " "photo_id INTEGER NOT NULL, " "geometry TEXT, " "vec TEXT, " "guess INTEGER DEFAULT 0" ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create FaceLocationTable", res);
	}
	_sqlite3_finalize0 (stmt);
	return self;
}

static FaceLocationTable*
face_location_table_new (void)
{
	return face_location_table_construct (TYPE_FACE_LOCATION_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

FaceLocationTable*
face_location_table_get_instance (void)
{
	FaceLocationTable* _tmp0_;
	FaceLocationTable* _tmp2_;
	FaceLocationTable* _tmp3_;
	FaceLocationTable* result;
	_tmp0_ = face_location_table_instance;
	if (_tmp0_ == NULL) {
		FaceLocationTable* _tmp1_;
		_tmp1_ = face_location_table_new ();
		_database_table_unref0 (face_location_table_instance);
		face_location_table_instance = _tmp1_;
	}
	_tmp2_ = face_location_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

FaceLocationRow*
face_location_table_add (FaceLocationTable* self,
                         FaceID* face_id,
                         PhotoID* photo_id,
                         const gchar* geometry,
                         const gchar* vec,
                         GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	FaceID _tmp4_;
	sqlite3_stmt* _tmp5_;
	PhotoID _tmp6_;
	sqlite3_stmt* _tmp7_;
	gchar* _tmp8_;
	GDestroyNotify _tmp9_;
	sqlite3_stmt* _tmp10_;
	gchar* _tmp11_;
	GDestroyNotify _tmp12_;
	sqlite3_stmt* _tmp13_;
	FaceLocationRow* row = NULL;
	FaceLocationRow* _tmp14_;
	FaceLocationRow* _tmp15_;
	sqlite3* _tmp16_;
	FaceLocationRow* _tmp17_;
	FaceID _tmp18_;
	FaceLocationRow* _tmp19_;
	PhotoID _tmp20_;
	FaceLocationRow* _tmp21_;
	gchar* _tmp22_;
	FaceLocationRow* _tmp23_;
	gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	FaceLocationRow* result;
	g_return_val_if_fail (IS_FACE_LOCATION_TABLE (self), NULL);
	g_return_val_if_fail (face_id != NULL, NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	g_return_val_if_fail (geometry != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO FaceLocationTable (face_id, photo_id, geometry, vec) VALUE" \
"S (?, ?, ?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *face_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	_tmp6_ = *photo_id;
	res = sqlite3_bind_int64 (_tmp5_, 2, _tmp6_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	_tmp8_ = g_strdup (geometry);
	_tmp9_ = g_free;
	res = sqlite3_bind_text (_tmp7_, 3, _tmp8_, -1, _tmp9_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	if (vec == NULL) {
		vec = "";
	}
	_tmp10_ = stmt;
	_tmp11_ = g_strdup (vec);
	_tmp12_ = g_free;
	res = sqlite3_bind_text (_tmp10_, 4, _tmp11_, -1, _tmp12_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp13_ = stmt;
	res = sqlite3_step (_tmp13_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("FaceLocationTable.add", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return NULL;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp14_ = face_location_row_new ();
	row = _tmp14_;
	_tmp15_ = row;
	_tmp16_ = database_table_db;
	face_location_id_init (&_tmp15_->face_location_id, sqlite3_last_insert_rowid (_tmp16_));
	_tmp17_ = row;
	_tmp18_ = *face_id;
	_tmp17_->face_id = _tmp18_;
	_tmp19_ = row;
	_tmp20_ = *photo_id;
	_tmp19_->photo_id = _tmp20_;
	_tmp21_ = row;
	_tmp22_ = g_strdup (geometry);
	_g_free0 (_tmp21_->geometry);
	_tmp21_->geometry = _tmp22_;
	_tmp23_ = row;
	_tmp24_ = g_strdup (vec);
	_g_free0 (_tmp23_->vec);
	_tmp23_->vec = _tmp24_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeList*
face_location_table_get_all_rows (FaceLocationTable* self,
                                  GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeList* rows = NULL;
	GeeArrayList* _tmp3_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_FACE_LOCATION_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, face_id, photo_id, geometry, vec FROM FaceLocationTable", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_FACE_LOCATION_ROW, (GBoxedCopyFunc) face_location_row_ref, (GDestroyNotify) face_location_row_unref, NULL, NULL, NULL);
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_LIST, GeeList);
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp5_;
			FaceLocationRow* row = NULL;
			FaceLocationRow* _tmp6_;
			FaceLocationRow* _tmp7_;
			sqlite3_stmt* _tmp8_;
			FaceLocationRow* _tmp9_;
			sqlite3_stmt* _tmp10_;
			FaceLocationRow* _tmp11_;
			sqlite3_stmt* _tmp12_;
			FaceLocationRow* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			FaceLocationRow* _tmp17_;
			sqlite3_stmt* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			GeeList* _tmp21_;
			FaceLocationRow* _tmp22_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("FaceLocationTable.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp6_ = face_location_row_new ();
			row = _tmp6_;
			_tmp7_ = row;
			_tmp8_ = stmt;
			face_location_id_init (&_tmp7_->face_location_id, sqlite3_column_int64 (_tmp8_, 0));
			_tmp9_ = row;
			_tmp10_ = stmt;
			face_id_init (&_tmp9_->face_id, sqlite3_column_int64 (_tmp10_, 1));
			_tmp11_ = row;
			_tmp12_ = stmt;
			photo_id_init (&_tmp11_->photo_id, sqlite3_column_int64 (_tmp12_, 2));
			_tmp13_ = row;
			_tmp14_ = stmt;
			_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 3);
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (_tmp13_->geometry);
			_tmp13_->geometry = _tmp16_;
			_tmp17_ = row;
			_tmp18_ = stmt;
			_tmp19_ = (const gchar*) sqlite3_column_text (_tmp18_, 4);
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (_tmp17_->vec);
			_tmp17_->vec = _tmp20_;
			_tmp21_ = rows;
			_tmp22_ = row;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), _tmp22_);
			_face_location_row_unref0 (row);
		}
	}
	result = rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
face_location_table_get_face_source_ids (FaceLocationTable* self,
                                         FaceID* face_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	FaceID _tmp4_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* result;
	g_return_val_if_fail (IS_FACE_LOCATION_TABLE (self), NULL);
	g_return_val_if_fail (face_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT photo_id FROM FaceLocationTable WHERE face_id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *face_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp7_;
			GeeArrayList* _tmp8_;
			sqlite3_stmt* _tmp9_;
			PhotoID _tmp10_ = {0};
			gchar* _tmp11_;
			gchar* _tmp12_;
			if (!_tmp6_) {
			}
			_tmp6_ = FALSE;
			_tmp7_ = stmt;
			res = sqlite3_step (_tmp7_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_face_source_ids", res);
					break;
				}
			}
			_tmp8_ = _result_;
			_tmp9_ = stmt;
			photo_id_init (&_tmp10_, sqlite3_column_int64 (_tmp9_, 0));
			_tmp11_ = photo_id_upgrade_photo_id_to_source_id (&_tmp10_);
			_tmp12_ = _tmp11_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
			_g_free0 (_tmp12_);
		}
	}
	result = _result_;
	_sqlite3_finalize0 (stmt);
	return result;
}

gchar*
face_location_table_get_face_source_serialized_geometry (FaceLocationTable* self,
                                                         Face* face,
                                                         MediaSource* source,
                                                         GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_FACE_LOCATION_TABLE (self), NULL);
	g_return_val_if_fail (IS_FACE (face), NULL);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT geometry FROM FaceLocationTable WHERE face_id=? AND photo_id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_bind_int64 (_tmp3_, 1, data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (face, TYPE_DATA_SOURCE, DataSource)));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	res = sqlite3_bind_int64 (_tmp4_, 2, data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo), TYPE_DATA_SOURCE, DataSource)));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res == SQLITE_DONE) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_throw_error ("FaceLocationTable.get_face_source_serialized_geometry", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp6_ = stmt;
	_tmp7_ = (const gchar*) sqlite3_column_text (_tmp6_, 0);
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
face_location_table_remove_face_from_source (FaceLocationTable* self,
                                             FaceID* face_id,
                                             PhotoID* photo_id,
                                             GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	FaceID _tmp4_;
	sqlite3_stmt* _tmp5_;
	PhotoID _tmp6_;
	sqlite3_stmt* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_FACE_LOCATION_TABLE (self));
	g_return_if_fail (face_id != NULL);
	g_return_if_fail (photo_id != NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM FaceLocationTable WHERE face_id=? AND photo_id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *face_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	_tmp6_ = *photo_id;
	res = sqlite3_bind_int64 (_tmp5_, 2, _tmp6_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("FaceLocationTable.remove_face_from_source", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
face_location_table_update_face_location_serialized_geometry (FaceLocationTable* self,
                                                              FaceLocation* face_location,
                                                              GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	GDestroyNotify _tmp5_;
	sqlite3_stmt* _tmp6_;
	FaceLocationID _tmp7_ = {0};
	sqlite3_stmt* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_FACE_LOCATION_TABLE (self));
	g_return_if_fail (IS_FACE_LOCATION (face_location));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE FaceLocationTable SET geometry=? WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = face_location_get_serialized_geometry (face_location);
	_tmp5_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	face_location_get_face_location_id (face_location, &_tmp7_);
	res = sqlite3_bind_int64 (_tmp6_, 2, _tmp7_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	res = sqlite3_step (_tmp8_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("FaceLocationTable.update_face_location_serialized_geometry", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
face_location_table_update_face_location_face_data (FaceLocationTable* self,
                                                    FaceLocation* face_location,
                                                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	FaceLocationData face_data = {0};
	FaceLocationData _tmp3_ = {0};
	sqlite3_stmt* _tmp4_;
	FaceLocationData _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	sqlite3_stmt* _tmp9_;
	FaceLocationData _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GDestroyNotify _tmp13_;
	sqlite3_stmt* _tmp14_;
	FaceLocationID _tmp15_ = {0};
	sqlite3_stmt* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_FACE_LOCATION_TABLE (self));
	g_return_if_fail (IS_FACE_LOCATION (face_location));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE FaceLocationTable SET geometry=?, vec=? WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	face_location_get_face_data (face_location, &_tmp3_);
	face_data = _tmp3_;
	_tmp4_ = stmt;
	_tmp5_ = face_data;
	_tmp6_ = _tmp5_.geometry;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_free;
	res = sqlite3_bind_text (_tmp4_, 1, _tmp7_, -1, _tmp8_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp9_ = stmt;
	_tmp10_ = face_data;
	_tmp11_ = _tmp10_.vec;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = g_free;
	res = sqlite3_bind_text (_tmp9_, 2, _tmp12_, -1, _tmp13_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp14_ = stmt;
	face_location_get_face_location_id (face_location, &_tmp15_);
	res = sqlite3_bind_int64 (_tmp14_, 3, _tmp15_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp16_ = stmt;
	res = sqlite3_step (_tmp16_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("FaceLocationTable.update_face_location_serialized_geometry", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				face_location_data_destroy (&face_data);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				face_location_data_destroy (&face_data);
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	face_location_data_destroy (&face_data);
	_sqlite3_finalize0 (stmt);
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

GeeList*
face_location_table_get_face_ref_vecs (FaceLocationTable* self,
                                       GeeList* face_rows,
                                       GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gchar** where_in = NULL;
	gchar** _tmp0_;
	gint where_in_length1;
	gint _where_in_size_;
	gint res = 0;
	sqlite3* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	sqlite3_stmt* _tmp16_ = NULL;
	gint _tmp17_;
	gint _tmp18_;
	gint c = 0;
	GeeList* rows = NULL;
	GeeArrayList* _tmp31_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_FACE_LOCATION_TABLE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (face_rows, GEE_TYPE_LIST), NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	where_in = _tmp0_;
	where_in_length1 = 0;
	_where_in_size_ = where_in_length1;
	{
		GeeList* _r_list = NULL;
		gint _r_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _r_index = 0;
		_r_list = face_rows;
		_tmp1_ = _r_list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_r_size = _tmp3_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FaceRow* r = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			FaceRow* _tmp8_;
			_r_index = _r_index + 1;
			_tmp4_ = _r_index;
			_tmp5_ = _r_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _r_list;
			_tmp7_ = gee_list_get (_tmp6_, _r_index);
			r = (FaceRow*) _tmp7_;
			_tmp8_ = r;
			if (_tmp8_ != NULL) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("?");
				_vala_array_add3 (&where_in, &where_in_length1, &_where_in_size_, _tmp9_);
			}
			_face_row_unref0 (r);
		}
	}
	_tmp10_ = database_table_db;
	_tmp11_ = where_in;
	_tmp11__length1 = where_in_length1;
	_tmp12_ = _vala_g_strjoinv (",", _tmp11_, (gint) _tmp11__length1);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("SELECT id, face_id, photo_id, geometry, vec FROM FaceLocationTable WHE" \
"RE photo_id IN (%s)", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp17_ = sqlite3_prepare_v2 (_tmp10_, _tmp15_, -1, &_tmp16_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp16_;
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	res = _tmp18_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	c = 1;
	{
		GeeList* _r_list = NULL;
		gint _r_size = 0;
		GeeList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _r_index = 0;
		_r_list = face_rows;
		_tmp19_ = _r_list;
		_tmp20_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp21_ = _tmp20_;
		_r_size = _tmp21_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			FaceRow* r = NULL;
			GeeList* _tmp24_;
			gpointer _tmp25_;
			FaceRow* _tmp26_;
			gint _tmp30_;
			_r_index = _r_index + 1;
			_tmp22_ = _r_index;
			_tmp23_ = _r_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _r_list;
			_tmp25_ = gee_list_get (_tmp24_, _r_index);
			r = (FaceRow*) _tmp25_;
			_tmp26_ = r;
			if (_tmp26_ != NULL) {
				sqlite3_stmt* _tmp27_;
				FaceRow* _tmp28_;
				PhotoID _tmp29_;
				_tmp27_ = stmt;
				_tmp28_ = r;
				_tmp29_ = _tmp28_->ref;
				res = sqlite3_bind_int64 (_tmp27_, c, _tmp29_.id);
				_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
			}
			_tmp30_ = c;
			c = _tmp30_ + 1;
			_face_row_unref0 (r);
		}
	}
	_tmp31_ = gee_array_list_new (TYPE_FACE_LOCATION_ROW, (GBoxedCopyFunc) face_location_row_ref, (GDestroyNotify) face_location_row_unref, NULL, NULL, NULL);
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_LIST, GeeList);
	{
		gboolean _tmp32_ = FALSE;
		_tmp32_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp33_;
			FaceLocationRow* row = NULL;
			FaceLocationRow* _tmp34_;
			FaceLocationRow* _tmp35_;
			sqlite3_stmt* _tmp36_;
			FaceLocationRow* _tmp37_;
			sqlite3_stmt* _tmp38_;
			FaceLocationRow* _tmp39_;
			sqlite3_stmt* _tmp40_;
			FaceLocationRow* _tmp41_;
			sqlite3_stmt* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			FaceLocationRow* _tmp45_;
			sqlite3_stmt* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			GeeList* _tmp49_;
			FaceLocationRow* _tmp50_;
			if (!_tmp32_) {
			}
			_tmp32_ = FALSE;
			_tmp33_ = stmt;
			res = sqlite3_step (_tmp33_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("FaceLocationTable.get_face_ref_vecs", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (rows);
							where_in = (_vala_array_free (where_in, where_in_length1, (GDestroyNotify) g_free), NULL);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (rows);
							where_in = (_vala_array_free (where_in, where_in_length1, (GDestroyNotify) g_free), NULL);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp34_ = face_location_row_new ();
			row = _tmp34_;
			_tmp35_ = row;
			_tmp36_ = stmt;
			face_location_id_init (&_tmp35_->face_location_id, sqlite3_column_int64 (_tmp36_, 0));
			_tmp37_ = row;
			_tmp38_ = stmt;
			face_id_init (&_tmp37_->face_id, sqlite3_column_int64 (_tmp38_, 1));
			_tmp39_ = row;
			_tmp40_ = stmt;
			photo_id_init (&_tmp39_->photo_id, sqlite3_column_int64 (_tmp40_, 2));
			_tmp41_ = row;
			_tmp42_ = stmt;
			_tmp43_ = (const gchar*) sqlite3_column_text (_tmp42_, 3);
			_tmp44_ = g_strdup (_tmp43_);
			_g_free0 (_tmp41_->geometry);
			_tmp41_->geometry = _tmp44_;
			_tmp45_ = row;
			_tmp46_ = stmt;
			_tmp47_ = (const gchar*) sqlite3_column_text (_tmp46_, 4);
			_tmp48_ = g_strdup (_tmp47_);
			_g_free0 (_tmp45_->vec);
			_tmp45_->vec = _tmp48_;
			_tmp49_ = rows;
			_tmp50_ = row;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), _tmp50_);
			_face_location_row_unref0 (row);
		}
	}
	result = rows;
	where_in = (_vala_array_free (where_in, where_in_length1, (GDestroyNotify) g_free), NULL);
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
face_location_table_class_init (FaceLocationTableClass * klass,
                                gpointer klass_data)
{
	face_location_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = face_location_table_finalize;
}

static void
face_location_table_instance_init (FaceLocationTable * self,
                                   gpointer klass)
{
}

static void
face_location_table_finalize (DatabaseTable * obj)
{
	FaceLocationTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_LOCATION_TABLE, FaceLocationTable);
	DATABASE_TABLE_CLASS (face_location_table_parent_class)->finalize (obj);
}

static GType
face_location_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceLocationTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_location_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceLocationTable), 0, (GInstanceInitFunc) face_location_table_instance_init, NULL };
	GType face_location_table_type_id;
	face_location_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "FaceLocationTable", &g_define_type_info, 0);
	return face_location_table_type_id;
}

GType
face_location_table_get_type (void)
{
	static volatile gsize face_location_table_type_id__once = 0;
	if (g_once_init_enter (&face_location_table_type_id__once)) {
		GType face_location_table_type_id;
		face_location_table_type_id = face_location_table_get_type_once ();
		g_once_init_leave (&face_location_table_type_id__once, face_location_table_type_id);
	}
	return face_location_table_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

