/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
    Copyright 2000-2025 the Rosegarden development team.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef RG_MIXERWINDOW_H
#define RG_MIXERWINDOW_H

#include "base/Instrument.h"

#include <QMainWindow>

class QWidget;
class QCloseEvent;


namespace Rosegarden
{


class Studio;
class RosegardenDocument;


/// Base class for MidiMixerWindow only.
/**
 * ??? Either move this into MidiMixerWindow or have AudioMixerWindow derive
 *     from this as well.  There is little point in having a base class that is
 *     only inherited by one class.
 */
class MixerWindow: public QMainWindow
{
    Q_OBJECT

public:

    MixerWindow(QWidget *parent, RosegardenDocument *document);

signals:

    void closing();

protected:

    void closeEvent(QCloseEvent *) override;

    RosegardenDocument *m_document;
    Studio *m_studio;
    InstrumentId m_currentId;

};


}

#endif
