/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2020 Philippe Proulx <pproulx@efficios.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * The following code was generated by barectf v3.1.2
 * on 2025-12-16T15:17:51.509889.
 *
 * For more details, see <https://barectf.org/>.
 */

#include <stdint.h>
#include <string.h>
#include <assert.h>

#include "barectf.h"
#include "barectf-bitfield.h"

#define _ALIGN(_at_var, _align)						\
	do {								\
		(_at_var) = ((_at_var) + ((_align) - 1)) & -(_align);	\
	} while (0)

#ifdef __cplusplus
# define _TO_VOID_PTR(_value)		static_cast<void *>(_value)
# define _FROM_VOID_PTR(_type, _value)	static_cast<_type *>(_value)
#else
# define _TO_VOID_PTR(_value)		((void *) (_value))
# define _FROM_VOID_PTR(_type, _value)	((_type *) (_value))
#endif

#define _BITS_TO_BYTES(_x)	((_x) >> 3)
#define _BYTES_TO_BITS(_x)	((_x) << 3)

union _f2u {
	float f;
	uint32_t u;
};

union _d2u {
	double f;
	uint64_t u;
};

uint32_t barectf_packet_size(const void * const vctx)
{
	return _FROM_VOID_PTR(const struct barectf_ctx, vctx)->packet_size;
}

int barectf_packet_is_full(const void * const vctx)
{
	const struct barectf_ctx * const ctx = _FROM_VOID_PTR(const struct barectf_ctx, vctx);

	return ctx->at == ctx->packet_size;
}

int barectf_packet_is_empty(const void * const vctx)
{
	const struct barectf_ctx * const ctx = _FROM_VOID_PTR(const struct barectf_ctx, vctx);

	return ctx->at <= ctx->off_content;
}

uint32_t barectf_packet_events_discarded(const void * const vctx)
{
	return _FROM_VOID_PTR(const struct barectf_ctx, vctx)->events_discarded;
}

uint32_t barectf_discarded_event_records_count(const void * const vctx)
{
	return barectf_packet_events_discarded(vctx);
}

uint32_t barectf_packet_sequence_number(const void * const vctx)
{
	return _FROM_VOID_PTR(const struct barectf_ctx, vctx)->sequence_number;
}

uint8_t *barectf_packet_buf(const void * const vctx)
{
	return _FROM_VOID_PTR(const struct barectf_ctx, vctx)->buf;
}

uint8_t *barectf_packet_buf_addr(const void * const vctx)
{
	return barectf_packet_buf(vctx);
}

uint32_t barectf_packet_buf_size(const void * const vctx)
{
	const struct barectf_ctx * const ctx = _FROM_VOID_PTR(const struct barectf_ctx, vctx);

	return _BITS_TO_BYTES(ctx->packet_size);
}

void barectf_packet_set_buf(void * const vctx, uint8_t * const buf,
		const uint32_t buf_size)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	ctx->buf = buf;

	if (ctx->at == ctx->packet_size) {
		/* Keep full packet state */
		ctx->at = _BYTES_TO_BITS(buf_size);
	}

	ctx->packet_size = _BYTES_TO_BITS(buf_size);
}

int barectf_packet_is_open(const void * const vctx)
{
	return _FROM_VOID_PTR(const struct barectf_ctx, vctx)->packet_is_open;
}

int barectf_is_in_tracing_section(const void * const vctx)
{
	return _FROM_VOID_PTR(const struct barectf_ctx, vctx)->in_tracing_section;
}

volatile const int *barectf_is_in_tracing_section_ptr(const void * const vctx)
{
	return &_FROM_VOID_PTR(const struct barectf_ctx, vctx)->in_tracing_section;
}

int barectf_is_tracing_enabled(const void * const vctx)
{
	return _FROM_VOID_PTR(const struct barectf_ctx, vctx)->is_tracing_enabled;
}

void barectf_enable_tracing(void * const vctx, const int enable)
{
	_FROM_VOID_PTR(struct barectf_ctx, vctx)->is_tracing_enabled = enable;
}

static
void _write_c_str(struct barectf_ctx * const ctx, const char * const src)
{
	const uint32_t sz = strlen(src) + 1;

	memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], src, sz);
	ctx->at += _BYTES_TO_BITS(sz);
}

static
int _reserve_er_space(void * const vctx, const uint32_t er_size)
{
	int ret;
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Event _cannot_ fit? */
	if (er_size > (ctx->packet_size - ctx->off_content)) {
		goto no_space;
	}

	/* Packet is full? */
	if (barectf_packet_is_full(ctx)) {
		/* Yes: is the back end full? */
		if (ctx->cbs.is_backend_full(ctx->data)) {
			/* Yes: discard event record */
			goto no_space;
		}

		/* Back-end is _not_ full: open new packet */
		ctx->use_cur_last_event_ts = 1;
		ctx->cbs.open_packet(ctx->data);
		ctx->use_cur_last_event_ts = 0;
	}

	/* Event fits the current packet? */
	if (er_size > (ctx->packet_size - ctx->at)) {
		/* No: close packet now */
		ctx->use_cur_last_event_ts = 1;
		ctx->cbs.close_packet(ctx->data);
		ctx->use_cur_last_event_ts = 0;

		/* Is the back end full? */
		if (ctx->cbs.is_backend_full(ctx->data)) {
			/* Yes: discard event record */
			goto no_space;
		}

		/* Back-end is _not_ full: open new packet */
		ctx->use_cur_last_event_ts = 1;
		ctx->cbs.open_packet(ctx->data);
		ctx->use_cur_last_event_ts = 0;
		assert(er_size <= (ctx->packet_size - ctx->at));
	}

	ret = 1;
	goto end;

no_space:
	ctx->events_discarded++;
	ret = 0;

end:
	return ret;
}

static
void _commit_er(void * const vctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Is the packet full? */
	if (barectf_packet_is_full(ctx)) {
		/* Yes: close it now */
		ctx->cbs.close_packet(ctx->data);
	}
}

/* Initialize context */
void barectf_init(void *vctx,
	uint8_t * const buf, const uint32_t buf_size,
	const struct barectf_platform_callbacks cbs, void * const data)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);
	ctx->cbs = cbs;
	ctx->data = data;
	ctx->buf = buf;
	ctx->packet_size = _BYTES_TO_BITS(buf_size);
	ctx->at = 0;
	ctx->events_discarded = 0;
	ctx->sequence_number = 0;
	ctx->packet_is_open = 0;
	ctx->in_tracing_section = 0;
	ctx->is_tracing_enabled = 1;
	ctx->use_cur_last_event_ts = 0;
}

/* Open packet for data stream type `api_ops` */
void barectf_api_ops_open_packet(
	struct barectf_api_ops_ctx * const sctx)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	const int saved_in_tracing_section = ctx->in_tracing_section;

	/*
	 * This function is either called by a tracing function, or
	 * directly by the platform.
	 *
	 * If it's called by a tracing function, then
	 * `ctx->in_tracing_section` is 1, so it's safe to open
	 * the packet here (alter the packet), even if tracing was
	 * disabled in the meantime because we're already in a tracing
	 * section (which finishes at the end of the tracing function
	 * call).
	 *
	 * If it's called directly by the platform, then if tracing is
	 * disabled, we don't want to alter the packet, and return
	 * immediately.
	 */
	if (!ctx->is_tracing_enabled && !saved_in_tracing_section) {
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Do not open a packet that is already open */
	if (ctx->packet_is_open) {
		ctx->in_tracing_section = saved_in_tracing_section;
		goto end;
	}

	ctx->at = 0;

	/* Write packet header structure */
	{
		/* Align for packet header structure */
		_ALIGN(ctx->at, 8);

		/* Align for `magic` field */
		_ALIGN(ctx->at, 8);

		/* Write magic number field */
		{
			const uint32_t tmp_val = (uint32_t) 0xc1fc1fc1UL;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `stream_id` field */
		_ALIGN(ctx->at, 8);

		/* Write data stream type ID field */
		{
			const uint64_t tmp_val = (uint64_t) 0;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}

	/* Write packet context structure */
	{
		/* Align for packet context structure */
		_ALIGN(ctx->at, 8);

		/* Align for `packet_size` field */
		_ALIGN(ctx->at, 8);

		/* Write packet total size field */
		{
			const uint64_t tmp_val = (uint64_t) ctx->packet_size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `content_size` field */
		_ALIGN(ctx->at, 8);

		/* Do not write `content_size` field; save its offset */
		sctx->off_pc_content_size = ctx->at;
		ctx->at += 64;
	}

	/* Save content beginning's offset */
	ctx->off_content = ctx->at;

	/* Mark current packet as open */
	ctx->packet_is_open = 1;

	/* Not tracing anymore */
	ctx->in_tracing_section = saved_in_tracing_section;

end:
	return;
}

/* Close packet for data stream type `api_ops` */
void barectf_api_ops_close_packet(struct barectf_api_ops_ctx * const sctx)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	const int saved_in_tracing_section = ctx->in_tracing_section;

	/*
	 * This function is either called by a tracing function, or
	 * directly by the platform.
	 *
	 * If it's called by a tracing function, then
	 * `ctx->in_tracing_section` is 1, so it's safe to close
	 * the packet here (alter the packet), even if tracing was
	 * disabled in the meantime, because we're already in a tracing
	 * section (which finishes at the end of the tracing function
	 * call).
	 *
	 * If it's called directly by the platform, then if tracing is
	 * disabled, we don't want to alter the packet, and return
	 * immediately.
	 */
	if (!ctx->is_tracing_enabled && !saved_in_tracing_section) {
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Do not close a packet that is not open */
	if (!ctx->packet_is_open) {
		ctx->in_tracing_section = saved_in_tracing_section;
		goto end;
	}

	/* Save content size */
	ctx->content_size = ctx->at;

	/* Go back to `content_size` field offset */
	ctx->at = sctx->off_pc_content_size;

	/* Write `content_size` field */
	{
		const uint64_t tmp_val = (uint64_t) ctx->content_size;

		memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
		ctx->at += 64;
	}

	/* Go back to end of packet */
	ctx->at = ctx->packet_size;

	/* Mark packet as closed */
	ctx->packet_is_open = 0;

	/* Not tracing anymore */
	ctx->in_tracing_section = saved_in_tracing_section;

end:
	return;
}

static void _serialize_er_header_api_ops(void * const vctx,
	const uint32_t ert_id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);
	struct barectf_api_ops_ctx * const sctx = _FROM_VOID_PTR(struct barectf_api_ops_ctx, vctx);
	const uint64_t ts = sctx->cur_last_event_ts;

	/* Write header structure */
	{
		/* Align for header structure */
		_ALIGN(ctx->at, 8);

		/* Align for `id` field */
		_ALIGN(ctx->at, 8);

		/* Write event record type ID field */
		{
			const uint64_t tmp_val = (uint64_t) ert_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `timestamp` field */
		_ALIGN(ctx->at, 8);

		/* Write timestamp field */
		{
			const uint64_t tmp_val = (uint64_t) ts;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_common_ctx_api_ops(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Write common context structure */
	{
		/* Align for common context structure */
		_ALIGN(ctx->at, 64);

		/* Align for `_thread_id` field */
		_ALIGN(ctx->at, 32);

		/* Write `_thread_id` field */
		{
			const uint32_t tmp_val = (uint32_t) cc__thread_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_queue_id` field */
		_ALIGN(ctx->at, 32);

		/* Write `_queue_id` field */
		{
			const uint32_t tmp_val = (uint32_t) cc__queue_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_agent_id` field */
		_ALIGN(ctx->at, 32);

		/* Write `_agent_id` field */
		{
			const uint32_t tmp_val = (uint32_t) cc__agent_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_correlation_id` field */
		_ALIGN(ctx->at, 64);

		/* Write `_correlation_id` field */
		{
			const uint64_t tmp_val = (uint64_t) cc__correlation_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_api_ops_hip_op_begin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const p__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_api_ops(ctx, 0);

	/* Serialize common context */
	_serialize_er_common_ctx_api_ops(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_kernel_name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernel_name` field */
		_write_c_str(ctx, p__kernel_name);
	}
}

static void _serialize_er_api_ops_hip_op_end(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_api_ops(ctx, 1);

	/* Serialize common context */
	_serialize_er_common_ctx_api_ops(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_api_ops_hsa_op_begin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_api_ops(ctx, 2);

	/* Serialize common context */
	_serialize_er_common_ctx_api_ops(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_api_ops_hsa_op_end(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_api_ops(ctx, 3);

	/* Serialize common context */
	_serialize_er_common_ctx_api_ops(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id);

	/* Write payload structure */
	{
	}
}

static uint32_t _er_size_api_ops_hip_op_begin(void * const vctx,
	const char * const p__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);
	uint32_t at = ctx->at;

	/* Add header structure size */
	{
		/* Align for header structure */
		_ALIGN(at, 8);

		/* Align for `id` field */
		_ALIGN(at, 8);

		/* Add `id` bit array field's size */
		at += 64;

		/* Align for `timestamp` field */
		_ALIGN(at, 8);

		/* Add `timestamp` bit array field's size */
		at += 64;
	}

	/* Add common context structure size */
	{
		/* Align for common context structure */
		_ALIGN(at, 64);

		/* Align for `_thread_id` field */
		_ALIGN(at, 32);

		/* Add `_thread_id` bit array field's size */
		at += 32;

		/* Align for `_queue_id` field */
		_ALIGN(at, 32);

		/* Add `_queue_id` bit array field's size */
		at += 32;

		/* Align for `_agent_id` field */
		_ALIGN(at, 32);

		/* Add `_agent_id` bit array field's size */
		at += 32;

		/* Align for `_correlation_id` field */
		_ALIGN(at, 64);

		/* Add `_correlation_id` bit array field's size */
		at += 64;
	}

	/* Add payload structure size */
	{
		/* Align for payload structure */
		_ALIGN(at, 8);

		/* Align for `_kernel_name` field */
		_ALIGN(at, 8);

		/* Add `_kernel_name` string field's size */
		at += _BYTES_TO_BITS(strlen(p__kernel_name) + 1);
	}

	return at - ctx->at;
}

static uint32_t _er_size_api_ops_hip_op_end(void * const vctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);
	uint32_t at = ctx->at;

	/* Add header structure size */
	{
		/* Align for header structure */
		_ALIGN(at, 8);

		/* Align for `id` field */
		_ALIGN(at, 8);

		/* Add `id` bit array field's size */
		at += 64;

		/* Align for `timestamp` field */
		_ALIGN(at, 8);

		/* Add `timestamp` bit array field's size */
		at += 64;
	}

	/* Add common context structure size */
	{
		/* Align for common context structure */
		_ALIGN(at, 64);

		/* Align for `_thread_id` field */
		_ALIGN(at, 32);

		/* Add `_thread_id` bit array field's size */
		at += 32;

		/* Align for `_queue_id` field */
		_ALIGN(at, 32);

		/* Add `_queue_id` bit array field's size */
		at += 32;

		/* Align for `_agent_id` field */
		_ALIGN(at, 32);

		/* Add `_agent_id` bit array field's size */
		at += 32;

		/* Align for `_correlation_id` field */
		_ALIGN(at, 64);

		/* Add `_correlation_id` bit array field's size */
		at += 64;
	}

	/* Add payload structure size */
	{
	}

	return at - ctx->at;
}

static uint32_t _er_size_api_ops_hsa_op_begin(void * const vctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);
	uint32_t at = ctx->at;

	/* Add header structure size */
	{
		/* Align for header structure */
		_ALIGN(at, 8);

		/* Align for `id` field */
		_ALIGN(at, 8);

		/* Add `id` bit array field's size */
		at += 64;

		/* Align for `timestamp` field */
		_ALIGN(at, 8);

		/* Add `timestamp` bit array field's size */
		at += 64;
	}

	/* Add common context structure size */
	{
		/* Align for common context structure */
		_ALIGN(at, 64);

		/* Align for `_thread_id` field */
		_ALIGN(at, 32);

		/* Add `_thread_id` bit array field's size */
		at += 32;

		/* Align for `_queue_id` field */
		_ALIGN(at, 32);

		/* Add `_queue_id` bit array field's size */
		at += 32;

		/* Align for `_agent_id` field */
		_ALIGN(at, 32);

		/* Add `_agent_id` bit array field's size */
		at += 32;

		/* Align for `_correlation_id` field */
		_ALIGN(at, 64);

		/* Add `_correlation_id` bit array field's size */
		at += 64;
	}

	/* Add payload structure size */
	{
	}

	return at - ctx->at;
}

static uint32_t _er_size_api_ops_hsa_op_end(void * const vctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);
	uint32_t at = ctx->at;

	/* Add header structure size */
	{
		/* Align for header structure */
		_ALIGN(at, 8);

		/* Align for `id` field */
		_ALIGN(at, 8);

		/* Add `id` bit array field's size */
		at += 64;

		/* Align for `timestamp` field */
		_ALIGN(at, 8);

		/* Add `timestamp` bit array field's size */
		at += 64;
	}

	/* Add common context structure size */
	{
		/* Align for common context structure */
		_ALIGN(at, 64);

		/* Align for `_thread_id` field */
		_ALIGN(at, 32);

		/* Add `_thread_id` bit array field's size */
		at += 32;

		/* Align for `_queue_id` field */
		_ALIGN(at, 32);

		/* Add `_queue_id` bit array field's size */
		at += 32;

		/* Align for `_agent_id` field */
		_ALIGN(at, 32);

		/* Add `_agent_id` bit array field's size */
		at += 32;

		/* Align for `_correlation_id` field */
		_ALIGN(at, 64);

		/* Add `_correlation_id` bit array field's size */
		at += 64;
	}

	/* Add payload structure size */
	{
	}

	return at - ctx->at;
}

/* Trace (data stream type `api_ops`, event record type `hip_op_begin`) */
void barectf_api_ops_trace_hip_op_begin(struct barectf_api_ops_ctx * const sctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const p__kernel_name)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	uint32_t er_size;

	/* Save timestamp */
	sctx->cur_last_event_ts = ctx->cbs.default_clock_get_value(ctx->data);

	if (!ctx->is_tracing_enabled) {
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Compute event record size */
	er_size = _er_size_api_ops_hip_op_begin(_TO_VOID_PTR(ctx), p__kernel_name);

	/* Is there enough space to serialize? */
	if (!_reserve_er_space(_TO_VOID_PTR(ctx), er_size)) {
		/* no: forget this */
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* Serialize event record */
	_serialize_er_api_ops_hip_op_begin(_TO_VOID_PTR(ctx), cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, p__kernel_name);

	/* Commit event record */
	_commit_er(_TO_VOID_PTR(ctx));

	/* Not tracing anymore */
	ctx->in_tracing_section = 0;

end:
	return;
}

/* Trace (data stream type `api_ops`, event record type `hip_op_end`) */
void barectf_api_ops_trace_hip_op_end(struct barectf_api_ops_ctx * const sctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	uint32_t er_size;

	/* Save timestamp */
	sctx->cur_last_event_ts = ctx->cbs.default_clock_get_value(ctx->data);

	if (!ctx->is_tracing_enabled) {
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Compute event record size */
	er_size = _er_size_api_ops_hip_op_end(_TO_VOID_PTR(ctx));

	/* Is there enough space to serialize? */
	if (!_reserve_er_space(_TO_VOID_PTR(ctx), er_size)) {
		/* no: forget this */
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* Serialize event record */
	_serialize_er_api_ops_hip_op_end(_TO_VOID_PTR(ctx), cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id);

	/* Commit event record */
	_commit_er(_TO_VOID_PTR(ctx));

	/* Not tracing anymore */
	ctx->in_tracing_section = 0;

end:
	return;
}

/* Trace (data stream type `api_ops`, event record type `hsa_op_begin`) */
void barectf_api_ops_trace_hsa_op_begin(struct barectf_api_ops_ctx * const sctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	uint32_t er_size;

	/* Save timestamp */
	sctx->cur_last_event_ts = ctx->cbs.default_clock_get_value(ctx->data);

	if (!ctx->is_tracing_enabled) {
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Compute event record size */
	er_size = _er_size_api_ops_hsa_op_begin(_TO_VOID_PTR(ctx));

	/* Is there enough space to serialize? */
	if (!_reserve_er_space(_TO_VOID_PTR(ctx), er_size)) {
		/* no: forget this */
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* Serialize event record */
	_serialize_er_api_ops_hsa_op_begin(_TO_VOID_PTR(ctx), cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id);

	/* Commit event record */
	_commit_er(_TO_VOID_PTR(ctx));

	/* Not tracing anymore */
	ctx->in_tracing_section = 0;

end:
	return;
}

/* Trace (data stream type `api_ops`, event record type `hsa_op_end`) */
void barectf_api_ops_trace_hsa_op_end(struct barectf_api_ops_ctx * const sctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	uint32_t er_size;

	/* Save timestamp */
	sctx->cur_last_event_ts = ctx->cbs.default_clock_get_value(ctx->data);

	if (!ctx->is_tracing_enabled) {
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Compute event record size */
	er_size = _er_size_api_ops_hsa_op_end(_TO_VOID_PTR(ctx));

	/* Is there enough space to serialize? */
	if (!_reserve_er_space(_TO_VOID_PTR(ctx), er_size)) {
		/* no: forget this */
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* Serialize event record */
	_serialize_er_api_ops_hsa_op_end(_TO_VOID_PTR(ctx), cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id);

	/* Commit event record */
	_commit_er(_TO_VOID_PTR(ctx));

	/* Not tracing anymore */
	ctx->in_tracing_section = 0;

end:
	return;
}
/* Open packet for data stream type `hip_api` */
void barectf_hip_api_open_packet(
	struct barectf_hip_api_ctx * const sctx)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	const int saved_in_tracing_section = ctx->in_tracing_section;

	/*
	 * This function is either called by a tracing function, or
	 * directly by the platform.
	 *
	 * If it's called by a tracing function, then
	 * `ctx->in_tracing_section` is 1, so it's safe to open
	 * the packet here (alter the packet), even if tracing was
	 * disabled in the meantime because we're already in a tracing
	 * section (which finishes at the end of the tracing function
	 * call).
	 *
	 * If it's called directly by the platform, then if tracing is
	 * disabled, we don't want to alter the packet, and return
	 * immediately.
	 */
	if (!ctx->is_tracing_enabled && !saved_in_tracing_section) {
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Do not open a packet that is already open */
	if (ctx->packet_is_open) {
		ctx->in_tracing_section = saved_in_tracing_section;
		goto end;
	}

	ctx->at = 0;

	/* Write packet header structure */
	{
		/* Align for packet header structure */
		_ALIGN(ctx->at, 8);

		/* Align for `magic` field */
		_ALIGN(ctx->at, 8);

		/* Write magic number field */
		{
			const uint32_t tmp_val = (uint32_t) 0xc1fc1fc1UL;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `stream_id` field */
		_ALIGN(ctx->at, 8);

		/* Write data stream type ID field */
		{
			const uint64_t tmp_val = (uint64_t) 1;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}

	/* Write packet context structure */
	{
		/* Align for packet context structure */
		_ALIGN(ctx->at, 8);

		/* Align for `packet_size` field */
		_ALIGN(ctx->at, 8);

		/* Write packet total size field */
		{
			const uint64_t tmp_val = (uint64_t) ctx->packet_size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `content_size` field */
		_ALIGN(ctx->at, 8);

		/* Do not write `content_size` field; save its offset */
		sctx->off_pc_content_size = ctx->at;
		ctx->at += 64;
	}

	/* Save content beginning's offset */
	ctx->off_content = ctx->at;

	/* Mark current packet as open */
	ctx->packet_is_open = 1;

	/* Not tracing anymore */
	ctx->in_tracing_section = saved_in_tracing_section;

end:
	return;
}

/* Close packet for data stream type `hip_api` */
void barectf_hip_api_close_packet(struct barectf_hip_api_ctx * const sctx)
{
	struct barectf_ctx * const ctx = &sctx->parent;
	const int saved_in_tracing_section = ctx->in_tracing_section;

	/*
	 * This function is either called by a tracing function, or
	 * directly by the platform.
	 *
	 * If it's called by a tracing function, then
	 * `ctx->in_tracing_section` is 1, so it's safe to close
	 * the packet here (alter the packet), even if tracing was
	 * disabled in the meantime, because we're already in a tracing
	 * section (which finishes at the end of the tracing function
	 * call).
	 *
	 * If it's called directly by the platform, then if tracing is
	 * disabled, we don't want to alter the packet, and return
	 * immediately.
	 */
	if (!ctx->is_tracing_enabled && !saved_in_tracing_section) {
		ctx->in_tracing_section = 0;
		goto end;
	}

	/* We can alter the packet */
	ctx->in_tracing_section = 1;

	/* Do not close a packet that is not open */
	if (!ctx->packet_is_open) {
		ctx->in_tracing_section = saved_in_tracing_section;
		goto end;
	}

	/* Save content size */
	ctx->content_size = ctx->at;

	/* Go back to `content_size` field offset */
	ctx->at = sctx->off_pc_content_size;

	/* Write `content_size` field */
	{
		const uint64_t tmp_val = (uint64_t) ctx->content_size;

		memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
		ctx->at += 64;
	}

	/* Go back to end of packet */
	ctx->at = ctx->packet_size;

	/* Mark packet as closed */
	ctx->packet_is_open = 0;

	/* Not tracing anymore */
	ctx->in_tracing_section = saved_in_tracing_section;

end:
	return;
}

static void _serialize_er_header_hip_api(void * const vctx,
	const uint32_t ert_id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);
	struct barectf_hip_api_ctx * const sctx = _FROM_VOID_PTR(struct barectf_hip_api_ctx, vctx);
	const uint64_t ts = sctx->cur_last_event_ts;

	/* Write header structure */
	{
		/* Align for header structure */
		_ALIGN(ctx->at, 8);

		/* Align for `id` field */
		_ALIGN(ctx->at, 8);

		/* Write event record type ID field */
		{
			const uint64_t tmp_val = (uint64_t) ert_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `timestamp` field */
		_ALIGN(ctx->at, 8);

		/* Write timestamp field */
		{
			const uint64_t tmp_val = (uint64_t) ts;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_common_ctx_hip_api(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Write common context structure */
	{
		/* Align for common context structure */
		_ALIGN(ctx->at, 64);

		/* Align for `_thread_id` field */
		_ALIGN(ctx->at, 32);

		/* Write `_thread_id` field */
		{
			const uint32_t tmp_val = (uint32_t) cc__thread_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_queue_id` field */
		_ALIGN(ctx->at, 32);

		/* Write `_queue_id` field */
		{
			const uint32_t tmp_val = (uint32_t) cc__queue_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_agent_id` field */
		_ALIGN(ctx->at, 32);

		/* Write `_agent_id` field */
		{
			const uint32_t tmp_val = (uint32_t) cc__agent_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_correlation_id` field */
		_ALIGN(ctx->at, 64);

		/* Write `_correlation_id` field */
		{
			const uint64_t tmp_val = (uint64_t) cc__correlation_id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kernel_name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernel_name` field */
		_write_c_str(ctx, cc__kernel_name);
	}
}

static void _serialize_er_hip_api___hipPopCallConfigurationBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__gridDim,
	const uint32_t p__gridDim__val__x,
	const uint32_t p__gridDim__val__y,
	const uint32_t p__gridDim__val__z,
	const uint64_t p__blockDim,
	const uint32_t p__blockDim__val__x,
	const uint32_t p__blockDim__val__y,
	const uint32_t p__blockDim__val__z,
	const uint64_t p__sharedMem,
	const uint64_t p__sharedMem__val,
	const uint64_t p__stream,
	const uint64_t p__stream__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 0);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_gridDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim` field */
		{
			const uint64_t tmp_val = (uint64_t) p__gridDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_gridDim__val__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__val__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__val__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__val__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__val__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__val__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__val__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__val__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__val__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim` field */
		{
			const uint64_t tmp_val = (uint64_t) p__blockDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_blockDim__val__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__val__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__val__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__val__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__val__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__val__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__val__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__val__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__val__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_sharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sharedMem__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMem__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMem__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api___hipPopCallConfigurationEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 1);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api___hipPushCallConfigurationBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint32_t p__gridDim__x,
	const uint32_t p__gridDim__y,
	const uint32_t p__gridDim__z,
	const uint32_t p__blockDim__x,
	const uint32_t p__blockDim__y,
	const uint32_t p__blockDim__z,
	const uint64_t p__sharedMem,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 2);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_sharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api___hipPushCallConfigurationEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 3);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipArray3DCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__array,
	const uint64_t p__array__val,
	const uint64_t p__pAllocateArray,
	const uint64_t p__pAllocateArray__val__Width,
	const uint64_t p__pAllocateArray__val__Height,
	const uint64_t p__pAllocateArray__val__Depth,
	const int32_t p__pAllocateArray__val__Format,
	const uint32_t p__pAllocateArray__val__NumChannels,
	const uint32_t p__pAllocateArray__val__Flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 4);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_array__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pAllocateArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray__val__Width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pAllocateArray__val__Width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pAllocateArray__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pAllocateArray__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray__val__Format` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Format` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pAllocateArray__val__Format;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pAllocateArray__val__NumChannels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__NumChannels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pAllocateArray__val__NumChannels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pAllocateArray__val__Flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pAllocateArray__val__Flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipArray3DCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 5);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipArray3DGetDescriptorBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pArrayDescriptor,
	const uint64_t p__pArrayDescriptor__val__Width,
	const uint64_t p__pArrayDescriptor__val__Height,
	const uint64_t p__pArrayDescriptor__val__Depth,
	const int32_t p__pArrayDescriptor__val__Format,
	const uint32_t p__pArrayDescriptor__val__NumChannels,
	const uint32_t p__pArrayDescriptor__val__Flags,
	const uint64_t p__array)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 6);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pArrayDescriptor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pArrayDescriptor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pArrayDescriptor__val__Width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pArrayDescriptor__val__Width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pArrayDescriptor__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pArrayDescriptor__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pArrayDescriptor__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pArrayDescriptor__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pArrayDescriptor__val__Format` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Format` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pArrayDescriptor__val__Format;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pArrayDescriptor__val__NumChannels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__NumChannels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pArrayDescriptor__val__NumChannels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pArrayDescriptor__val__Flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pArrayDescriptor__val__Flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipArray3DGetDescriptorEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 7);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipArrayCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pHandle,
	const uint64_t p__pHandle__val,
	const uint64_t p__pAllocateArray,
	const uint64_t p__pAllocateArray__val__Width,
	const uint64_t p__pAllocateArray__val__Height,
	const int32_t p__pAllocateArray__val__Format,
	const uint32_t p__pAllocateArray__val__NumChannels)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 8);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pHandle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pHandle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pHandle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pHandle__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pHandle__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pHandle__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pAllocateArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray__val__Width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pAllocateArray__val__Width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pAllocateArray__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pAllocateArray__val__Format` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__Format` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pAllocateArray__val__Format;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pAllocateArray__val__NumChannels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pAllocateArray__val__NumChannels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pAllocateArray__val__NumChannels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipArrayCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 9);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipArrayDestroyBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__array)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 10);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipArrayDestroyEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 11);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipArrayGetDescriptorBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pArrayDescriptor,
	const uint64_t p__pArrayDescriptor__val__Width,
	const uint64_t p__pArrayDescriptor__val__Height,
	const int32_t p__pArrayDescriptor__val__Format,
	const uint32_t p__pArrayDescriptor__val__NumChannels,
	const uint64_t p__array)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 12);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pArrayDescriptor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pArrayDescriptor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pArrayDescriptor__val__Width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pArrayDescriptor__val__Width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pArrayDescriptor__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pArrayDescriptor__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pArrayDescriptor__val__Format` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__Format` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pArrayDescriptor__val__Format;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pArrayDescriptor__val__NumChannels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pArrayDescriptor__val__NumChannels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pArrayDescriptor__val__NumChannels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipArrayGetDescriptorEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 13);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipArrayGetInfoBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__desc,
	const int32_t p__desc__val__x,
	const int32_t p__desc__val__y,
	const int32_t p__desc__val__z,
	const int32_t p__desc__val__w,
	const int32_t p__desc__val__f,
	const uint64_t p__extent,
	const uint64_t p__extent__val__width,
	const uint64_t p__extent__val__height,
	const uint64_t p__extent__val__depth,
	const uint64_t p__flags,
	const uint32_t p__flags__val,
	const uint64_t p__array)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 14);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_desc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__desc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc__val__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__w` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__w` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__w;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__f` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_extent` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__val__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__val__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__val__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__val__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__val__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__val__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__val__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__val__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__val__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipArrayGetInfoEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 15);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipChooseDeviceBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 16);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipChooseDeviceEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 17);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipChooseDeviceR0000Begin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__device,
	const int32_t p__device__val,
	const uint64_t p__prop,
	const uint64_t p__prop__val__name,
	const uint64_t p__prop__val__totalGlobalMem,
	const uint64_t p__prop__val__sharedMemPerBlock,
	const int32_t p__prop__val__regsPerBlock,
	const int32_t p__prop__val__warpSize,
	const int32_t p__prop__val__maxThreadsPerBlock,
	const uint64_t p__prop__val__maxThreadsDim,
	const uint64_t p__prop__val__maxGridSize,
	const int32_t p__prop__val__clockRate,
	const int32_t p__prop__val__memoryClockRate,
	const int32_t p__prop__val__memoryBusWidth,
	const uint64_t p__prop__val__totalConstMem,
	const int32_t p__prop__val__major,
	const int32_t p__prop__val__minor,
	const int32_t p__prop__val__multiProcessorCount,
	const int32_t p__prop__val__l2CacheSize,
	const int32_t p__prop__val__maxThreadsPerMultiProcessor,
	const int32_t p__prop__val__computeMode,
	const int32_t p__prop__val__clockInstructionRate,
	const uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	const uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	const uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	const uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	const uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	const uint32_t p__prop__val__arch__hasDoubles,
	const uint32_t p__prop__val__arch__hasWarpVote,
	const uint32_t p__prop__val__arch__hasWarpBallot,
	const uint32_t p__prop__val__arch__hasWarpShuffle,
	const uint32_t p__prop__val__arch__hasFunnelShift,
	const uint32_t p__prop__val__arch__hasThreadFenceSystem,
	const uint32_t p__prop__val__arch__hasSyncThreadsExt,
	const uint32_t p__prop__val__arch__hasSurfaceFuncs,
	const uint32_t p__prop__val__arch__has3dGrid,
	const uint32_t p__prop__val__arch__hasDynamicParallelism,
	const int32_t p__prop__val__concurrentKernels,
	const int32_t p__prop__val__pciDomainID,
	const int32_t p__prop__val__pciBusID,
	const int32_t p__prop__val__pciDeviceID,
	const uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	const int32_t p__prop__val__isMultiGpuBoard,
	const int32_t p__prop__val__canMapHostMemory,
	const int32_t p__prop__val__gcnArch,
	const uint64_t p__prop__val__gcnArchName,
	const int32_t p__prop__val__integrated,
	const int32_t p__prop__val__cooperativeLaunch,
	const int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	const int32_t p__prop__val__maxTexture1DLinear,
	const int32_t p__prop__val__maxTexture1D,
	const uint64_t p__prop__val__maxTexture2D,
	const uint64_t p__prop__val__maxTexture3D,
	const uint64_t p__prop__val__hdpMemFlushCntl,
	const uint64_t p__prop__val__hdpRegFlushCntl,
	const uint64_t p__prop__val__memPitch,
	const uint64_t p__prop__val__textureAlignment,
	const uint64_t p__prop__val__texturePitchAlignment,
	const int32_t p__prop__val__kernelExecTimeoutEnabled,
	const int32_t p__prop__val__ECCEnabled,
	const int32_t p__prop__val__tccDriver,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	const int32_t p__prop__val__isLargeBar,
	const int32_t p__prop__val__asicRevision,
	const int32_t p__prop__val__managedMemory,
	const int32_t p__prop__val__directManagedMemAccessFromHost,
	const int32_t p__prop__val__concurrentManagedAccess,
	const int32_t p__prop__val__pageableMemoryAccess,
	const int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 18);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint64_t tmp_val = (uint64_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__name` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__name;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__totalGlobalMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalGlobalMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalGlobalMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__sharedMemPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerBlock` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__regsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__regsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__regsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__warpSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__warpSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__warpSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsDim` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxThreadsDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxGridSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxGridSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxGridSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__clockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryClockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryClockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryClockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryBusWidth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryBusWidth` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryBusWidth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__totalConstMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalConstMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalConstMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__major` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__major` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__major;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__minor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__minor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__minor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__multiProcessorCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__multiProcessorCount` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__multiProcessorCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__l2CacheSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__l2CacheSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__l2CacheSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerMultiProcessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__computeMode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__computeMode` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__computeMode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__clockInstructionRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockInstructionRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockInstructionRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFloatAtomicAdd` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFloatAtomicAdd` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFloatAtomicAdd;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDoubles` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDoubles` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDoubles;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpVote` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpVote` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpVote;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpBallot` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpBallot` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpBallot;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpShuffle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpShuffle` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpShuffle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFunnelShift` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFunnelShift` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFunnelShift;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasThreadFenceSystem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasThreadFenceSystem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasThreadFenceSystem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSyncThreadsExt` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSyncThreadsExt` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSyncThreadsExt;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSurfaceFuncs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSurfaceFuncs` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSurfaceFuncs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__has3dGrid` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__has3dGrid` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__has3dGrid;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDynamicParallelism` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDynamicParallelism` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDynamicParallelism;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__concurrentKernels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentKernels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentKernels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDomainID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDomainID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDomainID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciBusID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciBusID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciBusID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDeviceID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDeviceID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDeviceID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSharedMemoryPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__isMultiGpuBoard` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isMultiGpuBoard` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isMultiGpuBoard;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__canMapHostMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__canMapHostMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__canMapHostMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gcnArch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gcnArch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gcnArch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gcnArchName` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gcnArchName` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__gcnArchName;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__integrated` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__integrated` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__integrated;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DLinear` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DLinear` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1DLinear;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1D` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture2D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture3D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture3D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture3D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hdpMemFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpMemFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpMemFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hdpRegFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpRegFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpRegFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__memPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__memPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__textureAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__textureAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__textureAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__texturePitchAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__texturePitchAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__texturePitchAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__kernelExecTimeoutEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__kernelExecTimeoutEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__kernelExecTimeoutEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__ECCEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__ECCEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__ECCEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__tccDriver` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__tccDriver` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__tccDriver;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedFunc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedGridDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__isLargeBar` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isLargeBar` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isLargeBar;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__asicRevision` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__asicRevision` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__asicRevision;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__managedMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__managedMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__managedMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__directManagedMemAccessFromHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__directManagedMemAccessFromHost` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__directManagedMemAccessFromHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__concurrentManagedAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentManagedAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentManagedAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pageableMemoryAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccessUsesHostPageTables;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipChooseDeviceR0000End(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 19);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipChooseDeviceR0600Begin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__device,
	const int32_t p__device__val,
	const uint64_t p__prop,
	const uint64_t p__prop__val__name,
	const uint64_t p__prop__val__uuid__bytes,
	const uint64_t p__prop__val__luid,
	const uint32_t p__prop__val__luidDeviceNodeMask,
	const uint64_t p__prop__val__totalGlobalMem,
	const uint64_t p__prop__val__sharedMemPerBlock,
	const int32_t p__prop__val__regsPerBlock,
	const int32_t p__prop__val__warpSize,
	const uint64_t p__prop__val__memPitch,
	const int32_t p__prop__val__maxThreadsPerBlock,
	const uint64_t p__prop__val__maxThreadsDim,
	const uint64_t p__prop__val__maxGridSize,
	const int32_t p__prop__val__clockRate,
	const uint64_t p__prop__val__totalConstMem,
	const int32_t p__prop__val__major,
	const int32_t p__prop__val__minor,
	const uint64_t p__prop__val__textureAlignment,
	const uint64_t p__prop__val__texturePitchAlignment,
	const int32_t p__prop__val__deviceOverlap,
	const int32_t p__prop__val__multiProcessorCount,
	const int32_t p__prop__val__kernelExecTimeoutEnabled,
	const int32_t p__prop__val__integrated,
	const int32_t p__prop__val__canMapHostMemory,
	const int32_t p__prop__val__computeMode,
	const int32_t p__prop__val__maxTexture1D,
	const int32_t p__prop__val__maxTexture1DMipmap,
	const int32_t p__prop__val__maxTexture1DLinear,
	const uint64_t p__prop__val__maxTexture2D,
	const uint64_t p__prop__val__maxTexture2DMipmap,
	const uint64_t p__prop__val__maxTexture2DLinear,
	const uint64_t p__prop__val__maxTexture2DGather,
	const uint64_t p__prop__val__maxTexture3D,
	const uint64_t p__prop__val__maxTexture3DAlt,
	const int32_t p__prop__val__maxTextureCubemap,
	const uint64_t p__prop__val__maxTexture1DLayered,
	const uint64_t p__prop__val__maxTexture2DLayered,
	const uint64_t p__prop__val__maxTextureCubemapLayered,
	const int32_t p__prop__val__maxSurface1D,
	const uint64_t p__prop__val__maxSurface2D,
	const uint64_t p__prop__val__maxSurface3D,
	const uint64_t p__prop__val__maxSurface1DLayered,
	const uint64_t p__prop__val__maxSurface2DLayered,
	const int32_t p__prop__val__maxSurfaceCubemap,
	const uint64_t p__prop__val__maxSurfaceCubemapLayered,
	const uint64_t p__prop__val__surfaceAlignment,
	const int32_t p__prop__val__concurrentKernels,
	const int32_t p__prop__val__ECCEnabled,
	const int32_t p__prop__val__pciBusID,
	const int32_t p__prop__val__pciDeviceID,
	const int32_t p__prop__val__pciDomainID,
	const int32_t p__prop__val__tccDriver,
	const int32_t p__prop__val__asyncEngineCount,
	const int32_t p__prop__val__unifiedAddressing,
	const int32_t p__prop__val__memoryClockRate,
	const int32_t p__prop__val__memoryBusWidth,
	const int32_t p__prop__val__l2CacheSize,
	const int32_t p__prop__val__persistingL2CacheMaxSize,
	const int32_t p__prop__val__maxThreadsPerMultiProcessor,
	const int32_t p__prop__val__streamPrioritiesSupported,
	const int32_t p__prop__val__globalL1CacheSupported,
	const int32_t p__prop__val__localL1CacheSupported,
	const uint64_t p__prop__val__sharedMemPerMultiprocessor,
	const int32_t p__prop__val__regsPerMultiprocessor,
	const int32_t p__prop__val__managedMemory,
	const int32_t p__prop__val__isMultiGpuBoard,
	const int32_t p__prop__val__multiGpuBoardGroupID,
	const int32_t p__prop__val__hostNativeAtomicSupported,
	const int32_t p__prop__val__singleToDoublePrecisionPerfRatio,
	const int32_t p__prop__val__pageableMemoryAccess,
	const int32_t p__prop__val__concurrentManagedAccess,
	const int32_t p__prop__val__computePreemptionSupported,
	const int32_t p__prop__val__canUseHostPointerForRegisteredMem,
	const int32_t p__prop__val__cooperativeLaunch,
	const int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	const uint64_t p__prop__val__sharedMemPerBlockOptin,
	const int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables,
	const int32_t p__prop__val__directManagedMemAccessFromHost,
	const int32_t p__prop__val__maxBlocksPerMultiProcessor,
	const int32_t p__prop__val__accessPolicyMaxWindowSize,
	const uint64_t p__prop__val__reservedSharedMemPerBlock,
	const int32_t p__prop__val__hostRegisterSupported,
	const int32_t p__prop__val__sparseHipArraySupported,
	const int32_t p__prop__val__hostRegisterReadOnlySupported,
	const int32_t p__prop__val__timelineSemaphoreInteropSupported,
	const int32_t p__prop__val__memoryPoolsSupported,
	const int32_t p__prop__val__gpuDirectRDMASupported,
	const uint32_t p__prop__val__gpuDirectRDMAFlushWritesOptions,
	const int32_t p__prop__val__gpuDirectRDMAWritesOrdering,
	const uint32_t p__prop__val__memoryPoolSupportedHandleTypes,
	const int32_t p__prop__val__deferredMappingHipArraySupported,
	const int32_t p__prop__val__ipcEventSupported,
	const int32_t p__prop__val__clusterLaunch,
	const int32_t p__prop__val__unifiedFunctionPointers,
	const uint64_t p__prop__val__reserved,
	const uint64_t p__prop__val__hipReserved,
	const uint64_t p__prop__val__gcnArchName,
	const uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	const int32_t p__prop__val__clockInstructionRate,
	const uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	const uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	const uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	const uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	const uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	const uint32_t p__prop__val__arch__hasDoubles,
	const uint32_t p__prop__val__arch__hasWarpVote,
	const uint32_t p__prop__val__arch__hasWarpBallot,
	const uint32_t p__prop__val__arch__hasWarpShuffle,
	const uint32_t p__prop__val__arch__hasFunnelShift,
	const uint32_t p__prop__val__arch__hasThreadFenceSystem,
	const uint32_t p__prop__val__arch__hasSyncThreadsExt,
	const uint32_t p__prop__val__arch__hasSurfaceFuncs,
	const uint32_t p__prop__val__arch__has3dGrid,
	const uint32_t p__prop__val__arch__hasDynamicParallelism,
	const uint64_t p__prop__val__hdpMemFlushCntl,
	const uint64_t p__prop__val__hdpRegFlushCntl,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	const int32_t p__prop__val__isLargeBar,
	const int32_t p__prop__val__asicRevision)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 20);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint64_t tmp_val = (uint64_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__name` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__name;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__uuid__bytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__uuid__bytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__uuid__bytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__luid` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__luid` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__luid;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__luidDeviceNodeMask` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__luidDeviceNodeMask` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__luidDeviceNodeMask;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__totalGlobalMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalGlobalMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalGlobalMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__sharedMemPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerBlock` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__regsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__regsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__regsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__warpSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__warpSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__warpSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__memPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxThreadsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsDim` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxThreadsDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxGridSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxGridSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxGridSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__clockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__totalConstMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalConstMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalConstMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__major` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__major` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__major;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__minor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__minor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__minor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__textureAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__textureAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__textureAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__texturePitchAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__texturePitchAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__texturePitchAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__deviceOverlap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__deviceOverlap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__deviceOverlap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__multiProcessorCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__multiProcessorCount` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__multiProcessorCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__kernelExecTimeoutEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__kernelExecTimeoutEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__kernelExecTimeoutEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__integrated` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__integrated` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__integrated;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__canMapHostMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__canMapHostMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__canMapHostMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__computeMode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__computeMode` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__computeMode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1D` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DMipmap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DMipmap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1DMipmap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DLinear` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DLinear` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1DLinear;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture2D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DMipmap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DMipmap` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DMipmap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DLinear` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DLinear` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DLinear;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DGather` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DGather` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DGather;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture3D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture3D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture3D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture3DAlt` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture3DAlt` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture3DAlt;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTextureCubemap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTextureCubemap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTextureCubemap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture1DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTextureCubemapLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTextureCubemapLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTextureCubemapLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface1D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface1D` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxSurface1D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxSurface2D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface2D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface2D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface3D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface3D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface3D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface1DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface1DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface1DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface2DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface2DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface2DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurfaceCubemap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurfaceCubemap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxSurfaceCubemap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxSurfaceCubemapLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurfaceCubemapLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurfaceCubemapLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__surfaceAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__surfaceAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__surfaceAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__concurrentKernels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentKernels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentKernels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__ECCEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__ECCEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__ECCEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciBusID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciBusID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciBusID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDeviceID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDeviceID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDeviceID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDomainID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDomainID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDomainID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__tccDriver` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__tccDriver` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__tccDriver;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__asyncEngineCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__asyncEngineCount` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__asyncEngineCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__unifiedAddressing` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__unifiedAddressing` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__unifiedAddressing;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryClockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryClockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryClockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryBusWidth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryBusWidth` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryBusWidth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__l2CacheSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__l2CacheSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__l2CacheSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__persistingL2CacheMaxSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__persistingL2CacheMaxSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__persistingL2CacheMaxSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerMultiProcessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__streamPrioritiesSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__streamPrioritiesSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__streamPrioritiesSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__globalL1CacheSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__globalL1CacheSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__globalL1CacheSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__localL1CacheSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__localL1CacheSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__localL1CacheSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__sharedMemPerMultiprocessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerMultiprocessor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerMultiprocessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__regsPerMultiprocessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__regsPerMultiprocessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__regsPerMultiprocessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__managedMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__managedMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__managedMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__isMultiGpuBoard` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isMultiGpuBoard` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isMultiGpuBoard;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__multiGpuBoardGroupID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__multiGpuBoardGroupID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__multiGpuBoardGroupID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__hostNativeAtomicSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hostNativeAtomicSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__hostNativeAtomicSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__singleToDoublePrecisionPerfRatio` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__singleToDoublePrecisionPerfRatio` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__singleToDoublePrecisionPerfRatio;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pageableMemoryAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__concurrentManagedAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentManagedAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentManagedAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__computePreemptionSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__computePreemptionSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__computePreemptionSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__canUseHostPointerForRegisteredMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__canUseHostPointerForRegisteredMem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__canUseHostPointerForRegisteredMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__sharedMemPerBlockOptin` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerBlockOptin` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerBlockOptin;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccessUsesHostPageTables;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__directManagedMemAccessFromHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__directManagedMemAccessFromHost` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__directManagedMemAccessFromHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxBlocksPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxBlocksPerMultiProcessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxBlocksPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__accessPolicyMaxWindowSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__accessPolicyMaxWindowSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__accessPolicyMaxWindowSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__reservedSharedMemPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__reservedSharedMemPerBlock` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__reservedSharedMemPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hostRegisterSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hostRegisterSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__hostRegisterSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__sparseHipArraySupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sparseHipArraySupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__sparseHipArraySupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__hostRegisterReadOnlySupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hostRegisterReadOnlySupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__hostRegisterReadOnlySupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__timelineSemaphoreInteropSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__timelineSemaphoreInteropSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__timelineSemaphoreInteropSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryPoolsSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryPoolsSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryPoolsSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gpuDirectRDMASupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gpuDirectRDMASupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gpuDirectRDMASupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gpuDirectRDMAFlushWritesOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gpuDirectRDMAFlushWritesOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gpuDirectRDMAFlushWritesOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gpuDirectRDMAWritesOrdering` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gpuDirectRDMAWritesOrdering` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gpuDirectRDMAWritesOrdering;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryPoolSupportedHandleTypes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryPoolSupportedHandleTypes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryPoolSupportedHandleTypes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__deferredMappingHipArraySupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__deferredMappingHipArraySupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__deferredMappingHipArraySupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__ipcEventSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__ipcEventSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__ipcEventSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__clusterLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clusterLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clusterLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__unifiedFunctionPointers` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__unifiedFunctionPointers` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__unifiedFunctionPointers;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hipReserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hipReserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hipReserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__gcnArchName` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gcnArchName` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__gcnArchName;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSharedMemoryPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__clockInstructionRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockInstructionRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockInstructionRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFloatAtomicAdd` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFloatAtomicAdd` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFloatAtomicAdd;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDoubles` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDoubles` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDoubles;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpVote` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpVote` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpVote;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpBallot` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpBallot` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpBallot;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpShuffle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpShuffle` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpShuffle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFunnelShift` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFunnelShift` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFunnelShift;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasThreadFenceSystem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasThreadFenceSystem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasThreadFenceSystem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSyncThreadsExt` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSyncThreadsExt` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSyncThreadsExt;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSurfaceFuncs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSurfaceFuncs` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSurfaceFuncs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__has3dGrid` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__has3dGrid` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__has3dGrid;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDynamicParallelism` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDynamicParallelism` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDynamicParallelism;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__hdpMemFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpMemFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpMemFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hdpRegFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpRegFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpRegFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedFunc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedGridDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__isLargeBar` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isLargeBar` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isLargeBar;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__asicRevision` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__asicRevision` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__asicRevision;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipChooseDeviceR0600End(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 21);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipConfigureCallBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint32_t p__gridDim__x,
	const uint32_t p__gridDim__y,
	const uint32_t p__gridDim__z,
	const uint32_t p__blockDim__x,
	const uint32_t p__blockDim__y,
	const uint32_t p__blockDim__z,
	const uint64_t p__sharedMem,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 22);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_sharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipConfigureCallEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 23);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCreateSurfaceObjectBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pSurfObject,
	const uint64_t p__pSurfObject__val,
	const uint64_t p__pResDesc,
	const int32_t p__pResDesc__val__resType)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 24);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pSurfObject` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pSurfObject` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pSurfObject;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pSurfObject__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pSurfObject__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pSurfObject__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pResDesc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pResDesc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pResDesc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pResDesc__val__resType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pResDesc__val__resType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pResDesc__val__resType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCreateSurfaceObjectEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 25);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ctx,
	const uint64_t p__ctx__val,
	const uint32_t p__flags,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 26);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ctx__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 27);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxDestroyBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 28);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipCtxDestroyEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 29);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxDisablePeerAccessBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__peerCtx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 30);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_peerCtx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_peerCtx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__peerCtx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipCtxDisablePeerAccessEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 31);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxEnablePeerAccessBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__peerCtx,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 32);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_peerCtx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_peerCtx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__peerCtx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxEnablePeerAccessEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 33);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxGetApiVersionBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ctx,
	const uint64_t p__apiVersion,
	const uint32_t p__apiVersion__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 34);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_apiVersion` field */
		_ALIGN(ctx->at, 8);

		/* Write `_apiVersion` field */
		{
			const uint64_t tmp_val = (uint64_t) p__apiVersion;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_apiVersion__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_apiVersion__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__apiVersion__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxGetApiVersionEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 35);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxGetCacheConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__cacheConfig,
	const int32_t p__cacheConfig__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 36);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_cacheConfig` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cacheConfig` field */
		{
			const uint64_t tmp_val = (uint64_t) p__cacheConfig;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_cacheConfig__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cacheConfig__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cacheConfig__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxGetCacheConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 37);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxGetCurrentBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ctx,
	const uint64_t p__ctx__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 38);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ctx__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipCtxGetCurrentEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 39);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxGetDeviceBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__device,
	const int32_t p__device__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 40);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint64_t tmp_val = (uint64_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxGetDeviceEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 41);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxGetFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__flags,
	const uint32_t p__flags__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 42);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxGetFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 43);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxGetSharedMemConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pConfig,
	const int32_t p__pConfig__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 44);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pConfig` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pConfig` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pConfig;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pConfig__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pConfig__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pConfig__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxGetSharedMemConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 45);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxPopCurrentBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ctx,
	const uint64_t p__ctx__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 46);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ctx__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipCtxPopCurrentEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 47);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxPushCurrentBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 48);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipCtxPushCurrentEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 49);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxSetCacheConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__cacheConfig)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 50);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_cacheConfig` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cacheConfig` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cacheConfig;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxSetCacheConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 51);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxSetCurrentBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 52);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipCtxSetCurrentEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 53);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxSetSharedMemConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__config)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 54);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_config` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipCtxSetSharedMemConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 55);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxSynchronizeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 56);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipCtxSynchronizeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 57);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDestroyExternalMemoryBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__extMem)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 58);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_extMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDestroyExternalMemoryEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 59);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDestroyExternalSemaphoreBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__extSem)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 60);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_extSem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extSem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extSem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDestroyExternalSemaphoreEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 61);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDestroySurfaceObjectBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__surfaceObject)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 62);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_surfaceObject` field */
		_ALIGN(ctx->at, 8);

		/* Write `_surfaceObject` field */
		{
			const uint64_t tmp_val = (uint64_t) p__surfaceObject;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDestroySurfaceObjectEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 63);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceCanAccessPeerBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__canAccessPeer,
	const int32_t p__canAccessPeer__val,
	const int32_t p__deviceId,
	const int32_t p__peerDeviceId)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 64);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_canAccessPeer` field */
		_ALIGN(ctx->at, 8);

		/* Write `_canAccessPeer` field */
		{
			const uint64_t tmp_val = (uint64_t) p__canAccessPeer;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_canAccessPeer__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_canAccessPeer__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__canAccessPeer__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_deviceId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_deviceId` field */
		{
			const uint32_t tmp_val = (uint32_t) p__deviceId;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_peerDeviceId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_peerDeviceId` field */
		{
			const uint32_t tmp_val = (uint32_t) p__peerDeviceId;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceCanAccessPeerEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 65);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceComputeCapabilityBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__major,
	const int32_t p__major__val,
	const uint64_t p__minor,
	const int32_t p__minor__val,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 66);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_major` field */
		_ALIGN(ctx->at, 8);

		/* Write `_major` field */
		{
			const uint64_t tmp_val = (uint64_t) p__major;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_major__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_major__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__major__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_minor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_minor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__minor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_minor__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_minor__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__minor__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceComputeCapabilityEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 67);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceDisablePeerAccessBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__peerDeviceId)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 68);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_peerDeviceId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_peerDeviceId` field */
		{
			const uint32_t tmp_val = (uint32_t) p__peerDeviceId;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceDisablePeerAccessEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 69);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceEnablePeerAccessBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__peerDeviceId,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 70);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_peerDeviceId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_peerDeviceId` field */
		{
			const uint32_t tmp_val = (uint32_t) p__peerDeviceId;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceEnablePeerAccessEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 71);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pi,
	const int32_t p__pi__val,
	const int32_t p__attr,
	const int32_t p__deviceId)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 72);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pi` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pi` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pi;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pi__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pi__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pi__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_deviceId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_deviceId` field */
		{
			const uint32_t tmp_val = (uint32_t) p__deviceId;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 73);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__device,
	const int32_t p__device__val,
	const int32_t p__ordinal)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 74);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint64_t tmp_val = (uint64_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_ordinal` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ordinal` field */
		{
			const uint32_t tmp_val = (uint32_t) p__ordinal;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetByPCIBusIdBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__device,
	const int32_t p__device__val,
	const char * const p__pciBusId,
	const int8_t p__pciBusId__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 75);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint64_t tmp_val = (uint64_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pciBusId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pciBusId` field */
		_write_c_str(ctx, p__pciBusId);

		/* Align for `_pciBusId__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pciBusId__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__pciBusId__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetByPCIBusIdEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 76);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetCacheConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__cacheConfig,
	const int32_t p__cacheConfig__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 77);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_cacheConfig` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cacheConfig` field */
		{
			const uint64_t tmp_val = (uint64_t) p__cacheConfig;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_cacheConfig__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cacheConfig__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cacheConfig__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetCacheConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 78);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetDefaultMemPoolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mem_pool,
	const uint64_t p__mem_pool__val,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 79);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mem_pool__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetDefaultMemPoolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 80);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 81);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetGraphMemAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__device,
	const int32_t p__attr,
	const uint64_t p__value)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 82);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetGraphMemAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 83);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetLimitBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pValue,
	const uint64_t p__pValue__val,
	const int32_t p__limit)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 84);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pValue` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pValue` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pValue;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pValue__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pValue__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pValue__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_limit` field */
		_ALIGN(ctx->at, 8);

		/* Write `_limit` field */
		{
			const uint32_t tmp_val = (uint32_t) p__limit;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetLimitEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 85);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetMemPoolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mem_pool,
	const uint64_t p__mem_pool__val,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 86);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mem_pool__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetMemPoolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 87);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetNameBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const char * const p__name,
	const int8_t p__name__val,
	const int32_t p__len,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 88);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_name` field */
		_write_c_str(ctx, p__name);

		/* Align for `_name__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_name__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__name__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_len` field */
		_ALIGN(ctx->at, 8);

		/* Write `_len` field */
		{
			const uint32_t tmp_val = (uint32_t) p__len;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetNameEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 89);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetP2PAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__value,
	const int32_t p__value__val,
	const int32_t p__attr,
	const int32_t p__srcDevice,
	const int32_t p__dstDevice)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 90);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_srcDevice` field */
		{
			const uint32_t tmp_val = (uint32_t) p__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dstDevice` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetP2PAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 91);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetPCIBusIdBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const char * const p__pciBusId,
	const int8_t p__pciBusId__val,
	const int32_t p__len,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 92);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pciBusId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pciBusId` field */
		_write_c_str(ctx, p__pciBusId);

		/* Align for `_pciBusId__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pciBusId__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__pciBusId__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_len` field */
		_ALIGN(ctx->at, 8);

		/* Write `_len` field */
		{
			const uint32_t tmp_val = (uint32_t) p__len;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetPCIBusIdEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 93);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetSharedMemConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pConfig,
	const int32_t p__pConfig__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 94);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pConfig` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pConfig` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pConfig;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pConfig__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pConfig__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pConfig__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetSharedMemConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 95);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetStreamPriorityRangeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__leastPriority,
	const int32_t p__leastPriority__val,
	const uint64_t p__greatestPriority,
	const int32_t p__greatestPriority__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 96);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_leastPriority` field */
		_ALIGN(ctx->at, 8);

		/* Write `_leastPriority` field */
		{
			const uint64_t tmp_val = (uint64_t) p__leastPriority;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_leastPriority__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_leastPriority__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__leastPriority__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_greatestPriority` field */
		_ALIGN(ctx->at, 8);

		/* Write `_greatestPriority` field */
		{
			const uint64_t tmp_val = (uint64_t) p__greatestPriority;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_greatestPriority__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_greatestPriority__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__greatestPriority__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetStreamPriorityRangeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 97);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGetUuidBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__uuid,
	const uint64_t p__uuid__val__bytes,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 98);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_uuid` field */
		_ALIGN(ctx->at, 8);

		/* Write `_uuid` field */
		{
			const uint64_t tmp_val = (uint64_t) p__uuid;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_uuid__val__bytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_uuid__val__bytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__uuid__val__bytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGetUuidEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 99);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceGraphMemTrimBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 100);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceGraphMemTrimEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 101);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxGetStateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__dev,
	const uint64_t p__flags,
	const uint32_t p__flags__val,
	const uint64_t p__active,
	const int32_t p__active__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 102);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dev;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_active` field */
		_ALIGN(ctx->at, 8);

		/* Write `_active` field */
		{
			const uint64_t tmp_val = (uint64_t) p__active;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_active__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_active__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__active__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxGetStateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 103);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxReleaseBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__dev)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 104);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dev;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxReleaseEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 105);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxResetBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__dev)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 106);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dev;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxResetEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 107);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxRetainBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pctx,
	const uint64_t p__pctx__val,
	const int32_t p__dev)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 108);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pctx__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pctx__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pctx__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dev;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxRetainEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 109);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxSetFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__dev,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 110);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dev;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDevicePrimaryCtxSetFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 111);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceResetBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 112);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceResetEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 113);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceSetCacheConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__cacheConfig)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 114);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_cacheConfig` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cacheConfig` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cacheConfig;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceSetCacheConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 115);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceSetGraphMemAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__device,
	const int32_t p__attr,
	const uint64_t p__value)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 116);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceSetGraphMemAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 117);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceSetLimitBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__limit,
	const uint64_t p__value)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 118);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_limit` field */
		_ALIGN(ctx->at, 8);

		/* Write `_limit` field */
		{
			const uint32_t tmp_val = (uint32_t) p__limit;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceSetLimitEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 119);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceSetMemPoolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__device,
	const uint64_t p__mem_pool)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 120);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceSetMemPoolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 121);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceSetSharedMemConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__config)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 122);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_config` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceSetSharedMemConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 123);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceSynchronizeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 124);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceSynchronizeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 125);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDeviceTotalMemBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__bytes,
	const uint64_t p__bytes__val,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 126);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_bytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__bytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_bytes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bytes__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__bytes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDeviceTotalMemEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 127);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDriverGetVersionBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__driverVersion,
	const int32_t p__driverVersion__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 128);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_driverVersion` field */
		_ALIGN(ctx->at, 8);

		/* Write `_driverVersion` field */
		{
			const uint64_t tmp_val = (uint64_t) p__driverVersion;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_driverVersion__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_driverVersion__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__driverVersion__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipDriverGetVersionEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 129);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvGraphAddMemFreeNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__phGraphNode,
	const uint64_t p__phGraphNode__val,
	const uint64_t p__hGraph,
	const uint64_t p__dependencies,
	const uint64_t p__dependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__dptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 130);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_phGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_phGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvGraphAddMemFreeNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 131);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvGraphAddMemcpyNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__phGraphNode,
	const uint64_t p__phGraphNode__val,
	const uint64_t p__hGraph,
	const uint64_t p__dependencies,
	const uint64_t p__dependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__copyParams,
	const uint64_t p__copyParams__val__srcXInBytes,
	const uint64_t p__copyParams__val__srcY,
	const uint64_t p__copyParams__val__srcZ,
	const uint64_t p__copyParams__val__srcLOD,
	const int32_t p__copyParams__val__srcMemoryType,
	const uint64_t p__copyParams__val__srcHost,
	const uint64_t p__copyParams__val__srcDevice,
	const uint64_t p__copyParams__val__srcArray,
	const uint64_t p__copyParams__val__srcPitch,
	const uint64_t p__copyParams__val__srcHeight,
	const uint64_t p__copyParams__val__dstXInBytes,
	const uint64_t p__copyParams__val__dstY,
	const uint64_t p__copyParams__val__dstZ,
	const uint64_t p__copyParams__val__dstLOD,
	const int32_t p__copyParams__val__dstMemoryType,
	const uint64_t p__copyParams__val__dstHost,
	const uint64_t p__copyParams__val__dstDevice,
	const uint64_t p__copyParams__val__dstArray,
	const uint64_t p__copyParams__val__dstPitch,
	const uint64_t p__copyParams__val__dstHeight,
	const uint64_t p__copyParams__val__WidthInBytes,
	const uint64_t p__copyParams__val__Height,
	const uint64_t p__copyParams__val__Depth,
	const uint64_t p__ctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 132);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_phGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_phGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__copyParams__val__srcMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_copyParams__val__srcHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__copyParams__val__dstMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_copyParams__val__dstHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__WidthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__WidthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__WidthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvGraphAddMemcpyNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 133);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvGraphAddMemsetNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__phGraphNode,
	const uint64_t p__phGraphNode__val,
	const uint64_t p__hGraph,
	const uint64_t p__dependencies,
	const uint64_t p__dependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__memsetParams,
	const uint64_t p__memsetParams__val__dst,
	const uint32_t p__memsetParams__val__elementSize,
	const uint64_t p__memsetParams__val__height,
	const uint64_t p__memsetParams__val__pitch,
	const uint32_t p__memsetParams__val__value,
	const uint64_t p__memsetParams__val__width,
	const uint64_t p__ctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 134);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_phGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_phGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__elementSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__elementSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__memsetParams__val__elementSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_memsetParams__val__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__value` field */
		{
			const uint32_t tmp_val = (uint32_t) p__memsetParams__val__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_memsetParams__val__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvGraphAddMemsetNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 135);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvGraphExecMemcpyNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__copyParams,
	const uint64_t p__copyParams__val__srcXInBytes,
	const uint64_t p__copyParams__val__srcY,
	const uint64_t p__copyParams__val__srcZ,
	const uint64_t p__copyParams__val__srcLOD,
	const int32_t p__copyParams__val__srcMemoryType,
	const uint64_t p__copyParams__val__srcHost,
	const uint64_t p__copyParams__val__srcDevice,
	const uint64_t p__copyParams__val__srcArray,
	const uint64_t p__copyParams__val__srcPitch,
	const uint64_t p__copyParams__val__srcHeight,
	const uint64_t p__copyParams__val__dstXInBytes,
	const uint64_t p__copyParams__val__dstY,
	const uint64_t p__copyParams__val__dstZ,
	const uint64_t p__copyParams__val__dstLOD,
	const int32_t p__copyParams__val__dstMemoryType,
	const uint64_t p__copyParams__val__dstHost,
	const uint64_t p__copyParams__val__dstDevice,
	const uint64_t p__copyParams__val__dstArray,
	const uint64_t p__copyParams__val__dstPitch,
	const uint64_t p__copyParams__val__dstHeight,
	const uint64_t p__copyParams__val__WidthInBytes,
	const uint64_t p__copyParams__val__Height,
	const uint64_t p__copyParams__val__Depth,
	const uint64_t p__ctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 136);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__copyParams__val__srcMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_copyParams__val__srcHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__srcHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__srcHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__srcHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__copyParams__val__dstMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_copyParams__val__dstHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__dstHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__dstHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__dstHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__WidthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__WidthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__WidthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_copyParams__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_copyParams__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__copyParams__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvGraphExecMemcpyNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 137);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvGraphExecMemsetNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__memsetParams,
	const uint64_t p__memsetParams__val__dst,
	const uint32_t p__memsetParams__val__elementSize,
	const uint64_t p__memsetParams__val__height,
	const uint64_t p__memsetParams__val__pitch,
	const uint32_t p__memsetParams__val__value,
	const uint64_t p__memsetParams__val__width,
	const uint64_t p__ctx)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 138);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__elementSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__elementSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__memsetParams__val__elementSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_memsetParams__val__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memsetParams__val__value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__value` field */
		{
			const uint32_t tmp_val = (uint32_t) p__memsetParams__val__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_memsetParams__val__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memsetParams__val__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memsetParams__val__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvGraphExecMemsetNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 139);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvGraphMemcpyNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__srcXInBytes,
	const uint64_t p__nodeParams__val__srcY,
	const uint64_t p__nodeParams__val__srcZ,
	const uint64_t p__nodeParams__val__srcLOD,
	const int32_t p__nodeParams__val__srcMemoryType,
	const uint64_t p__nodeParams__val__srcHost,
	const uint64_t p__nodeParams__val__srcDevice,
	const uint64_t p__nodeParams__val__srcArray,
	const uint64_t p__nodeParams__val__srcPitch,
	const uint64_t p__nodeParams__val__srcHeight,
	const uint64_t p__nodeParams__val__dstXInBytes,
	const uint64_t p__nodeParams__val__dstY,
	const uint64_t p__nodeParams__val__dstZ,
	const uint64_t p__nodeParams__val__dstLOD,
	const int32_t p__nodeParams__val__dstMemoryType,
	const uint64_t p__nodeParams__val__dstHost,
	const uint64_t p__nodeParams__val__dstDevice,
	const uint64_t p__nodeParams__val__dstArray,
	const uint64_t p__nodeParams__val__dstPitch,
	const uint64_t p__nodeParams__val__dstHeight,
	const uint64_t p__nodeParams__val__WidthInBytes,
	const uint64_t p__nodeParams__val__Height,
	const uint64_t p__nodeParams__val__Depth)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 140);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__srcMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__srcHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__dstMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__dstHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__WidthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__WidthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__WidthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvGraphMemcpyNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 141);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvGraphMemcpyNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__srcXInBytes,
	const uint64_t p__nodeParams__val__srcY,
	const uint64_t p__nodeParams__val__srcZ,
	const uint64_t p__nodeParams__val__srcLOD,
	const int32_t p__nodeParams__val__srcMemoryType,
	const uint64_t p__nodeParams__val__srcHost,
	const uint64_t p__nodeParams__val__srcDevice,
	const uint64_t p__nodeParams__val__srcArray,
	const uint64_t p__nodeParams__val__srcPitch,
	const uint64_t p__nodeParams__val__srcHeight,
	const uint64_t p__nodeParams__val__dstXInBytes,
	const uint64_t p__nodeParams__val__dstY,
	const uint64_t p__nodeParams__val__dstZ,
	const uint64_t p__nodeParams__val__dstLOD,
	const int32_t p__nodeParams__val__dstMemoryType,
	const uint64_t p__nodeParams__val__dstHost,
	const uint64_t p__nodeParams__val__dstDevice,
	const uint64_t p__nodeParams__val__dstArray,
	const uint64_t p__nodeParams__val__dstPitch,
	const uint64_t p__nodeParams__val__dstHeight,
	const uint64_t p__nodeParams__val__WidthInBytes,
	const uint64_t p__nodeParams__val__Height,
	const uint64_t p__nodeParams__val__Depth)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 142);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__srcMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__srcHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__srcHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__srcHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__srcHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__dstMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__dstHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__dstHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__dstHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__dstHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__WidthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__WidthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__WidthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvGraphMemcpyNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 143);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvLaunchKernelExBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__config,
	const uint32_t p__config__val__gridDimX,
	const uint32_t p__config__val__gridDimY,
	const uint32_t p__config__val__gridDimZ,
	const uint32_t p__config__val__blockDimX,
	const uint32_t p__config__val__blockDimY,
	const uint32_t p__config__val__blockDimZ,
	const uint32_t p__config__val__sharedMemBytes,
	const uint64_t p__config__val__hStream,
	const uint64_t p__config__val__attrs,
	const uint32_t p__config__val__numAttrs,
	const uint64_t p__f,
	const uint64_t p__params,
	const uint64_t p__params__val,
	const uint64_t p__extra,
	const uint64_t p__extra__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 144);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_config` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config` field */
		{
			const uint64_t tmp_val = (uint64_t) p__config;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config__val__gridDimX` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__gridDimX` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__gridDimX;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__gridDimY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__gridDimY` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__gridDimY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__gridDimZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__gridDimZ` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__gridDimZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__blockDimX` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__blockDimX` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__blockDimX;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__blockDimY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__blockDimY` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__blockDimY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__blockDimZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__blockDimZ` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__blockDimZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__sharedMemBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__hStream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__hStream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__config__val__hStream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config__val__attrs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__attrs` field */
		{
			const uint64_t tmp_val = (uint64_t) p__config__val__attrs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config__val__numAttrs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__numAttrs` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__numAttrs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_f` field */
		{
			const uint64_t tmp_val = (uint64_t) p__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extra` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extra` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extra;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extra__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extra__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extra__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvLaunchKernelExEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 145);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvMemcpy2DUnalignedBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pCopy,
	const uint64_t p__pCopy__val__srcXInBytes,
	const uint64_t p__pCopy__val__srcY,
	const int32_t p__pCopy__val__srcMemoryType,
	const uint64_t p__pCopy__val__srcHost,
	const uint64_t p__pCopy__val__srcDevice,
	const uint64_t p__pCopy__val__srcArray,
	const uint64_t p__pCopy__val__srcPitch,
	const uint64_t p__pCopy__val__dstXInBytes,
	const uint64_t p__pCopy__val__dstY,
	const int32_t p__pCopy__val__dstMemoryType,
	const uint64_t p__pCopy__val__dstHost,
	const uint64_t p__pCopy__val__dstDevice,
	const uint64_t p__pCopy__val__dstArray,
	const uint64_t p__pCopy__val__dstPitch,
	const uint64_t p__pCopy__val__WidthInBytes,
	const uint64_t p__pCopy__val__Height)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 146);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pCopy` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pCopy__val__srcMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pCopy__val__srcHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pCopy__val__dstMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pCopy__val__dstHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__WidthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__WidthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__WidthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvMemcpy2DUnalignedEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 147);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvMemcpy3DAsyncBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pCopy,
	const uint64_t p__pCopy__val__srcXInBytes,
	const uint64_t p__pCopy__val__srcY,
	const uint64_t p__pCopy__val__srcZ,
	const uint64_t p__pCopy__val__srcLOD,
	const int32_t p__pCopy__val__srcMemoryType,
	const uint64_t p__pCopy__val__srcHost,
	const uint64_t p__pCopy__val__srcDevice,
	const uint64_t p__pCopy__val__srcArray,
	const uint64_t p__pCopy__val__srcPitch,
	const uint64_t p__pCopy__val__srcHeight,
	const uint64_t p__pCopy__val__dstXInBytes,
	const uint64_t p__pCopy__val__dstY,
	const uint64_t p__pCopy__val__dstZ,
	const uint64_t p__pCopy__val__dstLOD,
	const int32_t p__pCopy__val__dstMemoryType,
	const uint64_t p__pCopy__val__dstHost,
	const uint64_t p__pCopy__val__dstDevice,
	const uint64_t p__pCopy__val__dstArray,
	const uint64_t p__pCopy__val__dstPitch,
	const uint64_t p__pCopy__val__dstHeight,
	const uint64_t p__pCopy__val__WidthInBytes,
	const uint64_t p__pCopy__val__Height,
	const uint64_t p__pCopy__val__Depth,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 148);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pCopy` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pCopy__val__srcMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pCopy__val__srcHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pCopy__val__dstMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pCopy__val__dstHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__WidthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__WidthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__WidthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvMemcpy3DAsyncEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 149);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvMemcpy3DBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pCopy,
	const uint64_t p__pCopy__val__srcXInBytes,
	const uint64_t p__pCopy__val__srcY,
	const uint64_t p__pCopy__val__srcZ,
	const uint64_t p__pCopy__val__srcLOD,
	const int32_t p__pCopy__val__srcMemoryType,
	const uint64_t p__pCopy__val__srcHost,
	const uint64_t p__pCopy__val__srcDevice,
	const uint64_t p__pCopy__val__srcArray,
	const uint64_t p__pCopy__val__srcPitch,
	const uint64_t p__pCopy__val__srcHeight,
	const uint64_t p__pCopy__val__dstXInBytes,
	const uint64_t p__pCopy__val__dstY,
	const uint64_t p__pCopy__val__dstZ,
	const uint64_t p__pCopy__val__dstLOD,
	const int32_t p__pCopy__val__dstMemoryType,
	const uint64_t p__pCopy__val__dstHost,
	const uint64_t p__pCopy__val__dstDevice,
	const uint64_t p__pCopy__val__dstArray,
	const uint64_t p__pCopy__val__dstPitch,
	const uint64_t p__pCopy__val__dstHeight,
	const uint64_t p__pCopy__val__WidthInBytes,
	const uint64_t p__pCopy__val__Height,
	const uint64_t p__pCopy__val__Depth)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 150);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pCopy` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pCopy__val__srcMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pCopy__val__srcHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__srcHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__srcHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__srcHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstXInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstXInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstXInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstY` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstZ` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstLOD` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstLOD` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstLOD;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstMemoryType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstMemoryType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pCopy__val__dstMemoryType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pCopy__val__dstHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstHost` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstDevice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstDevice` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstDevice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__dstHeight` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__dstHeight` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__dstHeight;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__WidthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__WidthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__WidthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__Height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__Height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__Height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopy__val__Depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopy__val__Depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopy__val__Depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvMemcpy3DEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 151);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipDrvPointerGetAttributesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint32_t p__numAttributes,
	const uint64_t p__attributes,
	const int32_t p__attributes__val,
	const uint64_t p__data,
	const uint64_t p__data__val,
	const uint64_t p__ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 152);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_numAttributes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numAttributes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numAttributes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attributes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attributes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__attributes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attributes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attributes__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attributes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_data` field */
		_ALIGN(ctx->at, 8);

		/* Write `_data` field */
		{
			const uint64_t tmp_val = (uint64_t) p__data;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_data__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_data__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__data__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipDrvPointerGetAttributesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 153);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event,
	const uint64_t p__event__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 154);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipEventCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 155);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventCreateWithFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event,
	const uint64_t p__event__val,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 156);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipEventCreateWithFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 157);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventDestroyBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 158);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipEventDestroyEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 159);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventElapsedTimeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ms,
	const uint64_t p__ms__val,
	const uint64_t p__start,
	const uint64_t p__stop)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 160);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ms` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ms` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ms;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ms__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ms__val` field */
		{
			union _f2u f2u;

			f2u.f = p__ms__val;
			{
				const uint32_t tmp_val = (uint32_t) f2u.u;

				memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
				ctx->at += 32;
			}
		}

		/* Align for `_start` field */
		_ALIGN(ctx->at, 8);

		/* Write `_start` field */
		{
			const uint64_t tmp_val = (uint64_t) p__start;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipEventElapsedTimeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 161);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventQueryBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 162);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipEventQueryEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 163);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventRecordBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 164);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipEventRecordEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 165);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventRecordWithFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event,
	const uint64_t p__stream,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 166);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipEventRecordWithFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 167);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipEventSynchronizeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 168);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipEventSynchronizeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 169);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtGetLastErrorBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 170);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtGetLastErrorEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 171);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtGetLinkTypeAndHopCountBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__device1,
	const int32_t p__device2,
	const uint64_t p__linktype,
	const uint32_t p__linktype__val,
	const uint64_t p__hopcount,
	const uint32_t p__hopcount__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 172);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_device1` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device1` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device1;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_device2` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device2` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device2;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_linktype` field */
		_ALIGN(ctx->at, 8);

		/* Write `_linktype` field */
		{
			const uint64_t tmp_val = (uint64_t) p__linktype;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_linktype__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_linktype__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__linktype__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_hopcount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hopcount` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hopcount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hopcount__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hopcount__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__hopcount__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExtGetLinkTypeAndHopCountEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 173);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtLaunchKernelBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__function_address,
	const uint32_t p__numBlocks__x,
	const uint32_t p__numBlocks__y,
	const uint32_t p__numBlocks__z,
	const uint32_t p__dimBlocks__x,
	const uint32_t p__dimBlocks__y,
	const uint32_t p__dimBlocks__z,
	const uint64_t p__args,
	const uint64_t p__args__val,
	const uint64_t p__sharedMemBytes,
	const uint64_t p__stream,
	const uint64_t p__startEvent,
	const uint64_t p__stopEvent,
	const int32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 174);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_function_address` field */
		_ALIGN(ctx->at, 8);

		/* Write `_function_address` field */
		{
			const uint64_t tmp_val = (uint64_t) p__function_address;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numBlocks__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numBlocks__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numBlocks__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_numBlocks__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numBlocks__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numBlocks__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_numBlocks__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numBlocks__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numBlocks__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_dimBlocks__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dimBlocks__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dimBlocks__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_dimBlocks__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dimBlocks__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dimBlocks__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_dimBlocks__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dimBlocks__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dimBlocks__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_args` field */
		_ALIGN(ctx->at, 8);

		/* Write `_args` field */
		{
			const uint64_t tmp_val = (uint64_t) p__args;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_args__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_args__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__args__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMemBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_startEvent` field */
		_ALIGN(ctx->at, 8);

		/* Write `_startEvent` field */
		{
			const uint64_t tmp_val = (uint64_t) p__startEvent;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stopEvent` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stopEvent` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stopEvent;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExtLaunchKernelEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 175);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtLaunchMultiKernelMultiDeviceBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__launchParamsList,
	const uint64_t p__launchParamsList__val__func,
	const uint32_t p__launchParamsList__val__gridDim__x,
	const uint32_t p__launchParamsList__val__gridDim__y,
	const uint32_t p__launchParamsList__val__gridDim__z,
	const uint32_t p__launchParamsList__val__blockDim__x,
	const uint32_t p__launchParamsList__val__blockDim__y,
	const uint32_t p__launchParamsList__val__blockDim__z,
	const uint64_t p__launchParamsList__val__args,
	const uint64_t p__launchParamsList__val__sharedMem,
	const uint64_t p__launchParamsList__val__stream,
	const int32_t p__numDevices,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 176);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_launchParamsList` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__args` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__args` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__args;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__sharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__sharedMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__sharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDevices` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDevices` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numDevices;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExtLaunchMultiKernelMultiDeviceEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 177);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtMallocWithFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__sizeBytes,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 178);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sizeBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sizeBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sizeBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExtMallocWithFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 179);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtModuleLaunchKernelBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__f,
	const uint32_t p__globalWorkSizeX,
	const uint32_t p__globalWorkSizeY,
	const uint32_t p__globalWorkSizeZ,
	const uint32_t p__localWorkSizeX,
	const uint32_t p__localWorkSizeY,
	const uint32_t p__localWorkSizeZ,
	const uint64_t p__sharedMemBytes,
	const uint64_t p__hStream,
	const uint64_t p__kernelParams,
	const uint64_t p__kernelParams__val,
	const uint64_t p__extra,
	const uint64_t p__extra__val,
	const uint64_t p__startEvent,
	const uint64_t p__stopEvent,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 180);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_f` field */
		{
			const uint64_t tmp_val = (uint64_t) p__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_globalWorkSizeX` field */
		_ALIGN(ctx->at, 8);

		/* Write `_globalWorkSizeX` field */
		{
			const uint32_t tmp_val = (uint32_t) p__globalWorkSizeX;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_globalWorkSizeY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_globalWorkSizeY` field */
		{
			const uint32_t tmp_val = (uint32_t) p__globalWorkSizeY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_globalWorkSizeZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_globalWorkSizeZ` field */
		{
			const uint32_t tmp_val = (uint32_t) p__globalWorkSizeZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_localWorkSizeX` field */
		_ALIGN(ctx->at, 8);

		/* Write `_localWorkSizeX` field */
		{
			const uint32_t tmp_val = (uint32_t) p__localWorkSizeX;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_localWorkSizeY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_localWorkSizeY` field */
		{
			const uint32_t tmp_val = (uint32_t) p__localWorkSizeY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_localWorkSizeZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_localWorkSizeZ` field */
		{
			const uint32_t tmp_val = (uint32_t) p__localWorkSizeZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMemBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hStream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hStream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hStream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kernelParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernelParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__kernelParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kernelParams__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernelParams__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__kernelParams__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extra` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extra` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extra;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extra__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extra__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extra__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_startEvent` field */
		_ALIGN(ctx->at, 8);

		/* Write `_startEvent` field */
		{
			const uint64_t tmp_val = (uint64_t) p__startEvent;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stopEvent` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stopEvent` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stopEvent;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExtModuleLaunchKernelEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 181);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtStreamCreateWithCUMaskBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__stream,
	const uint64_t p__stream__val,
	const uint32_t p__cuMaskSize,
	const uint64_t p__cuMask,
	const uint32_t p__cuMask__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 182);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_cuMaskSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cuMaskSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cuMaskSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_cuMask` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cuMask` field */
		{
			const uint64_t tmp_val = (uint64_t) p__cuMask;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_cuMask__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cuMask__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cuMask__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExtStreamCreateWithCUMaskEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 183);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExtStreamGetCUMaskBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__stream,
	const uint32_t p__cuMaskSize,
	const uint64_t p__cuMask,
	const uint32_t p__cuMask__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 184);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_cuMaskSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cuMaskSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cuMaskSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_cuMask` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cuMask` field */
		{
			const uint64_t tmp_val = (uint64_t) p__cuMask;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_cuMask__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_cuMask__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__cuMask__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExtStreamGetCUMaskEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 185);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExternalMemoryGetMappedBufferBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__devPtr,
	const uint64_t p__devPtr__val,
	const uint64_t p__extMem,
	const uint64_t p__bufferDesc,
	const uint64_t p__bufferDesc__val__offset,
	const uint64_t p__bufferDesc__val__size,
	const uint32_t p__bufferDesc__val__flags,
	const uint64_t p__bufferDesc__val__reserved)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 186);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_devPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_bufferDesc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bufferDesc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__bufferDesc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_bufferDesc__val__offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bufferDesc__val__offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__bufferDesc__val__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_bufferDesc__val__size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bufferDesc__val__size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__bufferDesc__val__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_bufferDesc__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bufferDesc__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__bufferDesc__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_bufferDesc__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bufferDesc__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__bufferDesc__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipExternalMemoryGetMappedBufferEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 187);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipExternalMemoryGetMappedMipmappedArrayBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mipmap,
	const uint64_t p__mipmap__val,
	const uint64_t p__extMem,
	const uint64_t p__mipmapDesc,
	const uint64_t p__mipmapDesc__val__offset,
	const int32_t p__mipmapDesc__val__formatDesc__x,
	const int32_t p__mipmapDesc__val__formatDesc__y,
	const int32_t p__mipmapDesc__val__formatDesc__z,
	const int32_t p__mipmapDesc__val__formatDesc__w,
	const int32_t p__mipmapDesc__val__formatDesc__f,
	const uint64_t p__mipmapDesc__val__extent__width,
	const uint64_t p__mipmapDesc__val__extent__height,
	const uint64_t p__mipmapDesc__val__extent__depth,
	const uint32_t p__mipmapDesc__val__flags,
	const uint32_t p__mipmapDesc__val__numLevels)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 188);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mipmap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmap` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmap__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmap__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmap__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmapDesc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmapDesc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmapDesc__val__offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmapDesc__val__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmapDesc__val__formatDesc__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__formatDesc__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipmapDesc__val__formatDesc__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mipmapDesc__val__formatDesc__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__formatDesc__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipmapDesc__val__formatDesc__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mipmapDesc__val__formatDesc__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__formatDesc__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipmapDesc__val__formatDesc__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mipmapDesc__val__formatDesc__w` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__formatDesc__w` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipmapDesc__val__formatDesc__w;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mipmapDesc__val__formatDesc__f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__formatDesc__f` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipmapDesc__val__formatDesc__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mipmapDesc__val__extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmapDesc__val__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmapDesc__val__extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmapDesc__val__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmapDesc__val__extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmapDesc__val__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmapDesc__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipmapDesc__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mipmapDesc__val__numLevels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmapDesc__val__numLevels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipmapDesc__val__numLevels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipExternalMemoryGetMappedMipmappedArrayEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 189);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFreeArrayBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__array)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 190);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipFreeArrayEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 191);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFreeAsyncBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dev_ptr,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 192);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipFreeAsyncEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 193);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFreeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 194);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipFreeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 195);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFreeHostBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 196);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipFreeHostEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 197);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFreeMipmappedArrayBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mipmappedArray)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 198);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mipmappedArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmappedArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmappedArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipFreeMipmappedArrayEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 199);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFuncGetAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__value,
	const int32_t p__value__val,
	const int32_t p__attrib,
	const uint64_t p__hfunc)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 200);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attrib` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attrib` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attrib;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_hfunc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hfunc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hfunc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipFuncGetAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 201);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFuncGetAttributesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__attr,
	const int32_t p__attr__val__binaryVersion,
	const int32_t p__attr__val__cacheModeCA,
	const uint64_t p__attr__val__constSizeBytes,
	const uint64_t p__attr__val__localSizeBytes,
	const int32_t p__attr__val__maxDynamicSharedSizeBytes,
	const int32_t p__attr__val__maxThreadsPerBlock,
	const int32_t p__attr__val__numRegs,
	const int32_t p__attr__val__preferredShmemCarveout,
	const int32_t p__attr__val__ptxVersion,
	const uint64_t p__attr__val__sharedSizeBytes,
	const uint64_t p__func)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 202);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attr__val__binaryVersion` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__binaryVersion` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr__val__binaryVersion;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr__val__cacheModeCA` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__cacheModeCA` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr__val__cacheModeCA;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr__val__constSizeBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__constSizeBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__attr__val__constSizeBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attr__val__localSizeBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__localSizeBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__attr__val__localSizeBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attr__val__maxDynamicSharedSizeBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__maxDynamicSharedSizeBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr__val__maxDynamicSharedSizeBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr__val__maxThreadsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__maxThreadsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr__val__maxThreadsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr__val__numRegs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__numRegs` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr__val__numRegs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr__val__preferredShmemCarveout` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__preferredShmemCarveout` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr__val__preferredShmemCarveout;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr__val__ptxVersion` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__ptxVersion` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr__val__ptxVersion;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_attr__val__sharedSizeBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr__val__sharedSizeBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__attr__val__sharedSizeBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipFuncGetAttributesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 203);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFuncSetAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__func,
	const int32_t p__attr,
	const int32_t p__value)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 204);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipFuncSetAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 205);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFuncSetCacheConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__func,
	const int32_t p__config)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 206);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipFuncSetCacheConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 207);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipFuncSetSharedMemConfigBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__func,
	const int32_t p__config)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 208);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipFuncSetSharedMemConfigEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 209);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGLGetDevicesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pHipDeviceCount,
	const uint32_t p__pHipDeviceCount__val,
	const uint64_t p__pHipDevices,
	const int32_t p__pHipDevices__val,
	const uint32_t p__hipDeviceCount,
	const int32_t p__deviceList)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 210);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pHipDeviceCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pHipDeviceCount` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pHipDeviceCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pHipDeviceCount__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pHipDeviceCount__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pHipDeviceCount__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pHipDevices` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pHipDevices` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pHipDevices;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pHipDevices__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pHipDevices__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pHipDevices__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_hipDeviceCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hipDeviceCount` field */
		{
			const uint32_t tmp_val = (uint32_t) p__hipDeviceCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_deviceList` field */
		_ALIGN(ctx->at, 8);

		/* Write `_deviceList` field */
		{
			const uint32_t tmp_val = (uint32_t) p__deviceList;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGLGetDevicesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 211);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetChannelDescBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__desc,
	const int32_t p__desc__val__x,
	const int32_t p__desc__val__y,
	const int32_t p__desc__val__z,
	const int32_t p__desc__val__w,
	const int32_t p__desc__val__f,
	const uint64_t p__array)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 212);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_desc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__desc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc__val__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__w` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__w` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__w;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__f` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGetChannelDescEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 213);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDeviceBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__deviceId,
	const int32_t p__deviceId__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 214);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_deviceId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_deviceId` field */
		{
			const uint64_t tmp_val = (uint64_t) p__deviceId;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_deviceId__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_deviceId__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__deviceId__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetDeviceCountBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__count,
	const int32_t p__count__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 215);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__count__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetDeviceCountEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 216);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDeviceEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 217);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDeviceFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__flags,
	const uint32_t p__flags__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 218);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetDeviceFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 219);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDevicePropertiesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 220);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDevicePropertiesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 221);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDevicePropertiesR0000Begin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__prop,
	const uint64_t p__prop__val__name,
	const uint64_t p__prop__val__totalGlobalMem,
	const uint64_t p__prop__val__sharedMemPerBlock,
	const int32_t p__prop__val__regsPerBlock,
	const int32_t p__prop__val__warpSize,
	const int32_t p__prop__val__maxThreadsPerBlock,
	const uint64_t p__prop__val__maxThreadsDim,
	const uint64_t p__prop__val__maxGridSize,
	const int32_t p__prop__val__clockRate,
	const int32_t p__prop__val__memoryClockRate,
	const int32_t p__prop__val__memoryBusWidth,
	const uint64_t p__prop__val__totalConstMem,
	const int32_t p__prop__val__major,
	const int32_t p__prop__val__minor,
	const int32_t p__prop__val__multiProcessorCount,
	const int32_t p__prop__val__l2CacheSize,
	const int32_t p__prop__val__maxThreadsPerMultiProcessor,
	const int32_t p__prop__val__computeMode,
	const int32_t p__prop__val__clockInstructionRate,
	const uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	const uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	const uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	const uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	const uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	const uint32_t p__prop__val__arch__hasDoubles,
	const uint32_t p__prop__val__arch__hasWarpVote,
	const uint32_t p__prop__val__arch__hasWarpBallot,
	const uint32_t p__prop__val__arch__hasWarpShuffle,
	const uint32_t p__prop__val__arch__hasFunnelShift,
	const uint32_t p__prop__val__arch__hasThreadFenceSystem,
	const uint32_t p__prop__val__arch__hasSyncThreadsExt,
	const uint32_t p__prop__val__arch__hasSurfaceFuncs,
	const uint32_t p__prop__val__arch__has3dGrid,
	const uint32_t p__prop__val__arch__hasDynamicParallelism,
	const int32_t p__prop__val__concurrentKernels,
	const int32_t p__prop__val__pciDomainID,
	const int32_t p__prop__val__pciBusID,
	const int32_t p__prop__val__pciDeviceID,
	const uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	const int32_t p__prop__val__isMultiGpuBoard,
	const int32_t p__prop__val__canMapHostMemory,
	const int32_t p__prop__val__gcnArch,
	const uint64_t p__prop__val__gcnArchName,
	const int32_t p__prop__val__integrated,
	const int32_t p__prop__val__cooperativeLaunch,
	const int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	const int32_t p__prop__val__maxTexture1DLinear,
	const int32_t p__prop__val__maxTexture1D,
	const uint64_t p__prop__val__maxTexture2D,
	const uint64_t p__prop__val__maxTexture3D,
	const uint64_t p__prop__val__hdpMemFlushCntl,
	const uint64_t p__prop__val__hdpRegFlushCntl,
	const uint64_t p__prop__val__memPitch,
	const uint64_t p__prop__val__textureAlignment,
	const uint64_t p__prop__val__texturePitchAlignment,
	const int32_t p__prop__val__kernelExecTimeoutEnabled,
	const int32_t p__prop__val__ECCEnabled,
	const int32_t p__prop__val__tccDriver,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	const int32_t p__prop__val__isLargeBar,
	const int32_t p__prop__val__asicRevision,
	const int32_t p__prop__val__managedMemory,
	const int32_t p__prop__val__directManagedMemAccessFromHost,
	const int32_t p__prop__val__concurrentManagedAccess,
	const int32_t p__prop__val__pageableMemoryAccess,
	const int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 222);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_prop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__name` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__name;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__totalGlobalMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalGlobalMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalGlobalMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__sharedMemPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerBlock` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__regsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__regsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__regsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__warpSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__warpSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__warpSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsDim` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxThreadsDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxGridSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxGridSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxGridSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__clockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryClockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryClockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryClockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryBusWidth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryBusWidth` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryBusWidth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__totalConstMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalConstMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalConstMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__major` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__major` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__major;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__minor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__minor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__minor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__multiProcessorCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__multiProcessorCount` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__multiProcessorCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__l2CacheSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__l2CacheSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__l2CacheSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerMultiProcessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__computeMode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__computeMode` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__computeMode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__clockInstructionRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockInstructionRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockInstructionRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFloatAtomicAdd` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFloatAtomicAdd` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFloatAtomicAdd;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDoubles` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDoubles` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDoubles;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpVote` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpVote` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpVote;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpBallot` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpBallot` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpBallot;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpShuffle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpShuffle` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpShuffle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFunnelShift` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFunnelShift` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFunnelShift;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasThreadFenceSystem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasThreadFenceSystem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasThreadFenceSystem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSyncThreadsExt` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSyncThreadsExt` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSyncThreadsExt;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSurfaceFuncs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSurfaceFuncs` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSurfaceFuncs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__has3dGrid` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__has3dGrid` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__has3dGrid;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDynamicParallelism` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDynamicParallelism` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDynamicParallelism;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__concurrentKernels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentKernels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentKernels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDomainID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDomainID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDomainID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciBusID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciBusID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciBusID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDeviceID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDeviceID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDeviceID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSharedMemoryPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__isMultiGpuBoard` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isMultiGpuBoard` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isMultiGpuBoard;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__canMapHostMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__canMapHostMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__canMapHostMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gcnArch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gcnArch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gcnArch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gcnArchName` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gcnArchName` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__gcnArchName;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__integrated` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__integrated` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__integrated;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DLinear` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DLinear` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1DLinear;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1D` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture2D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture3D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture3D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture3D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hdpMemFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpMemFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpMemFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hdpRegFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpRegFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpRegFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__memPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__memPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__textureAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__textureAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__textureAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__texturePitchAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__texturePitchAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__texturePitchAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__kernelExecTimeoutEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__kernelExecTimeoutEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__kernelExecTimeoutEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__ECCEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__ECCEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__ECCEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__tccDriver` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__tccDriver` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__tccDriver;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedFunc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedGridDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__isLargeBar` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isLargeBar` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isLargeBar;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__asicRevision` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__asicRevision` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__asicRevision;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__managedMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__managedMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__managedMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__directManagedMemAccessFromHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__directManagedMemAccessFromHost` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__directManagedMemAccessFromHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__concurrentManagedAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentManagedAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentManagedAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pageableMemoryAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccessUsesHostPageTables;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetDevicePropertiesR0000End(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 223);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDevicePropertiesR0600Begin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__prop,
	const uint64_t p__prop__val__name,
	const uint64_t p__prop__val__uuid__bytes,
	const uint64_t p__prop__val__luid,
	const uint32_t p__prop__val__luidDeviceNodeMask,
	const uint64_t p__prop__val__totalGlobalMem,
	const uint64_t p__prop__val__sharedMemPerBlock,
	const int32_t p__prop__val__regsPerBlock,
	const int32_t p__prop__val__warpSize,
	const uint64_t p__prop__val__memPitch,
	const int32_t p__prop__val__maxThreadsPerBlock,
	const uint64_t p__prop__val__maxThreadsDim,
	const uint64_t p__prop__val__maxGridSize,
	const int32_t p__prop__val__clockRate,
	const uint64_t p__prop__val__totalConstMem,
	const int32_t p__prop__val__major,
	const int32_t p__prop__val__minor,
	const uint64_t p__prop__val__textureAlignment,
	const uint64_t p__prop__val__texturePitchAlignment,
	const int32_t p__prop__val__deviceOverlap,
	const int32_t p__prop__val__multiProcessorCount,
	const int32_t p__prop__val__kernelExecTimeoutEnabled,
	const int32_t p__prop__val__integrated,
	const int32_t p__prop__val__canMapHostMemory,
	const int32_t p__prop__val__computeMode,
	const int32_t p__prop__val__maxTexture1D,
	const int32_t p__prop__val__maxTexture1DMipmap,
	const int32_t p__prop__val__maxTexture1DLinear,
	const uint64_t p__prop__val__maxTexture2D,
	const uint64_t p__prop__val__maxTexture2DMipmap,
	const uint64_t p__prop__val__maxTexture2DLinear,
	const uint64_t p__prop__val__maxTexture2DGather,
	const uint64_t p__prop__val__maxTexture3D,
	const uint64_t p__prop__val__maxTexture3DAlt,
	const int32_t p__prop__val__maxTextureCubemap,
	const uint64_t p__prop__val__maxTexture1DLayered,
	const uint64_t p__prop__val__maxTexture2DLayered,
	const uint64_t p__prop__val__maxTextureCubemapLayered,
	const int32_t p__prop__val__maxSurface1D,
	const uint64_t p__prop__val__maxSurface2D,
	const uint64_t p__prop__val__maxSurface3D,
	const uint64_t p__prop__val__maxSurface1DLayered,
	const uint64_t p__prop__val__maxSurface2DLayered,
	const int32_t p__prop__val__maxSurfaceCubemap,
	const uint64_t p__prop__val__maxSurfaceCubemapLayered,
	const uint64_t p__prop__val__surfaceAlignment,
	const int32_t p__prop__val__concurrentKernels,
	const int32_t p__prop__val__ECCEnabled,
	const int32_t p__prop__val__pciBusID,
	const int32_t p__prop__val__pciDeviceID,
	const int32_t p__prop__val__pciDomainID,
	const int32_t p__prop__val__tccDriver,
	const int32_t p__prop__val__asyncEngineCount,
	const int32_t p__prop__val__unifiedAddressing,
	const int32_t p__prop__val__memoryClockRate,
	const int32_t p__prop__val__memoryBusWidth,
	const int32_t p__prop__val__l2CacheSize,
	const int32_t p__prop__val__persistingL2CacheMaxSize,
	const int32_t p__prop__val__maxThreadsPerMultiProcessor,
	const int32_t p__prop__val__streamPrioritiesSupported,
	const int32_t p__prop__val__globalL1CacheSupported,
	const int32_t p__prop__val__localL1CacheSupported,
	const uint64_t p__prop__val__sharedMemPerMultiprocessor,
	const int32_t p__prop__val__regsPerMultiprocessor,
	const int32_t p__prop__val__managedMemory,
	const int32_t p__prop__val__isMultiGpuBoard,
	const int32_t p__prop__val__multiGpuBoardGroupID,
	const int32_t p__prop__val__hostNativeAtomicSupported,
	const int32_t p__prop__val__singleToDoublePrecisionPerfRatio,
	const int32_t p__prop__val__pageableMemoryAccess,
	const int32_t p__prop__val__concurrentManagedAccess,
	const int32_t p__prop__val__computePreemptionSupported,
	const int32_t p__prop__val__canUseHostPointerForRegisteredMem,
	const int32_t p__prop__val__cooperativeLaunch,
	const int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	const uint64_t p__prop__val__sharedMemPerBlockOptin,
	const int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables,
	const int32_t p__prop__val__directManagedMemAccessFromHost,
	const int32_t p__prop__val__maxBlocksPerMultiProcessor,
	const int32_t p__prop__val__accessPolicyMaxWindowSize,
	const uint64_t p__prop__val__reservedSharedMemPerBlock,
	const int32_t p__prop__val__hostRegisterSupported,
	const int32_t p__prop__val__sparseHipArraySupported,
	const int32_t p__prop__val__hostRegisterReadOnlySupported,
	const int32_t p__prop__val__timelineSemaphoreInteropSupported,
	const int32_t p__prop__val__memoryPoolsSupported,
	const int32_t p__prop__val__gpuDirectRDMASupported,
	const uint32_t p__prop__val__gpuDirectRDMAFlushWritesOptions,
	const int32_t p__prop__val__gpuDirectRDMAWritesOrdering,
	const uint32_t p__prop__val__memoryPoolSupportedHandleTypes,
	const int32_t p__prop__val__deferredMappingHipArraySupported,
	const int32_t p__prop__val__ipcEventSupported,
	const int32_t p__prop__val__clusterLaunch,
	const int32_t p__prop__val__unifiedFunctionPointers,
	const uint64_t p__prop__val__reserved,
	const uint64_t p__prop__val__hipReserved,
	const uint64_t p__prop__val__gcnArchName,
	const uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	const int32_t p__prop__val__clockInstructionRate,
	const uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	const uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	const uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	const uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	const uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	const uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	const uint32_t p__prop__val__arch__hasDoubles,
	const uint32_t p__prop__val__arch__hasWarpVote,
	const uint32_t p__prop__val__arch__hasWarpBallot,
	const uint32_t p__prop__val__arch__hasWarpShuffle,
	const uint32_t p__prop__val__arch__hasFunnelShift,
	const uint32_t p__prop__val__arch__hasThreadFenceSystem,
	const uint32_t p__prop__val__arch__hasSyncThreadsExt,
	const uint32_t p__prop__val__arch__hasSurfaceFuncs,
	const uint32_t p__prop__val__arch__has3dGrid,
	const uint32_t p__prop__val__arch__hasDynamicParallelism,
	const uint64_t p__prop__val__hdpMemFlushCntl,
	const uint64_t p__prop__val__hdpRegFlushCntl,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	const int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	const int32_t p__prop__val__isLargeBar,
	const int32_t p__prop__val__asicRevision,
	const int32_t p__deviceId)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 224);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_prop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__name` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__name;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__uuid__bytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__uuid__bytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__uuid__bytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__luid` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__luid` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__luid;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__luidDeviceNodeMask` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__luidDeviceNodeMask` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__luidDeviceNodeMask;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__totalGlobalMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalGlobalMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalGlobalMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__sharedMemPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerBlock` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__regsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__regsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__regsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__warpSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__warpSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__warpSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memPitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memPitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__memPitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxThreadsPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerBlock` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsDim` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxThreadsDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxGridSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxGridSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxGridSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__clockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__totalConstMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__totalConstMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__totalConstMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__major` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__major` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__major;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__minor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__minor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__minor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__textureAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__textureAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__textureAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__texturePitchAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__texturePitchAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__texturePitchAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__deviceOverlap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__deviceOverlap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__deviceOverlap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__multiProcessorCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__multiProcessorCount` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__multiProcessorCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__kernelExecTimeoutEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__kernelExecTimeoutEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__kernelExecTimeoutEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__integrated` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__integrated` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__integrated;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__canMapHostMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__canMapHostMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__canMapHostMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__computeMode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__computeMode` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__computeMode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1D` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DMipmap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DMipmap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1DMipmap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DLinear` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DLinear` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTexture1DLinear;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture2D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DMipmap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DMipmap` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DMipmap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DLinear` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DLinear` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DLinear;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DGather` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DGather` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DGather;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture3D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture3D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture3D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture3DAlt` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture3DAlt` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture3DAlt;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTextureCubemap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTextureCubemap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxTextureCubemap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxTexture1DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture1DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture1DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTexture2DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTexture2DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTexture2DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxTextureCubemapLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxTextureCubemapLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxTextureCubemapLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface1D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface1D` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxSurface1D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxSurface2D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface2D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface2D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface3D` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface3D` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface3D;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface1DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface1DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface1DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurface2DLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurface2DLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurface2DLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSurfaceCubemap` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurfaceCubemap` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxSurfaceCubemap;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxSurfaceCubemapLayered` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSurfaceCubemapLayered` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSurfaceCubemapLayered;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__surfaceAlignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__surfaceAlignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__surfaceAlignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__concurrentKernels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentKernels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentKernels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__ECCEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__ECCEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__ECCEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciBusID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciBusID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciBusID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDeviceID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDeviceID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDeviceID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pciDomainID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pciDomainID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pciDomainID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__tccDriver` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__tccDriver` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__tccDriver;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__asyncEngineCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__asyncEngineCount` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__asyncEngineCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__unifiedAddressing` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__unifiedAddressing` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__unifiedAddressing;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryClockRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryClockRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryClockRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryBusWidth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryBusWidth` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryBusWidth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__l2CacheSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__l2CacheSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__l2CacheSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__persistingL2CacheMaxSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__persistingL2CacheMaxSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__persistingL2CacheMaxSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxThreadsPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxThreadsPerMultiProcessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxThreadsPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__streamPrioritiesSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__streamPrioritiesSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__streamPrioritiesSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__globalL1CacheSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__globalL1CacheSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__globalL1CacheSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__localL1CacheSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__localL1CacheSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__localL1CacheSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__sharedMemPerMultiprocessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerMultiprocessor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerMultiprocessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__regsPerMultiprocessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__regsPerMultiprocessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__regsPerMultiprocessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__managedMemory` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__managedMemory` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__managedMemory;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__isMultiGpuBoard` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isMultiGpuBoard` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isMultiGpuBoard;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__multiGpuBoardGroupID` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__multiGpuBoardGroupID` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__multiGpuBoardGroupID;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__hostNativeAtomicSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hostNativeAtomicSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__hostNativeAtomicSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__singleToDoublePrecisionPerfRatio` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__singleToDoublePrecisionPerfRatio` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__singleToDoublePrecisionPerfRatio;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__pageableMemoryAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__concurrentManagedAccess` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__concurrentManagedAccess` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__concurrentManagedAccess;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__computePreemptionSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__computePreemptionSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__computePreemptionSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__canUseHostPointerForRegisteredMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__canUseHostPointerForRegisteredMem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__canUseHostPointerForRegisteredMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__sharedMemPerBlockOptin` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sharedMemPerBlockOptin` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__sharedMemPerBlockOptin;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__pageableMemoryAccessUsesHostPageTables` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__pageableMemoryAccessUsesHostPageTables;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__directManagedMemAccessFromHost` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__directManagedMemAccessFromHost` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__directManagedMemAccessFromHost;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__maxBlocksPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxBlocksPerMultiProcessor` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__maxBlocksPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__accessPolicyMaxWindowSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__accessPolicyMaxWindowSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__accessPolicyMaxWindowSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__reservedSharedMemPerBlock` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__reservedSharedMemPerBlock` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__reservedSharedMemPerBlock;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hostRegisterSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hostRegisterSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__hostRegisterSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__sparseHipArraySupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__sparseHipArraySupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__sparseHipArraySupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__hostRegisterReadOnlySupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hostRegisterReadOnlySupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__hostRegisterReadOnlySupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__timelineSemaphoreInteropSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__timelineSemaphoreInteropSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__timelineSemaphoreInteropSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryPoolsSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryPoolsSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryPoolsSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gpuDirectRDMASupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gpuDirectRDMASupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gpuDirectRDMASupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gpuDirectRDMAFlushWritesOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gpuDirectRDMAFlushWritesOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gpuDirectRDMAFlushWritesOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__gpuDirectRDMAWritesOrdering` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gpuDirectRDMAWritesOrdering` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__gpuDirectRDMAWritesOrdering;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__memoryPoolSupportedHandleTypes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__memoryPoolSupportedHandleTypes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__memoryPoolSupportedHandleTypes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__deferredMappingHipArraySupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__deferredMappingHipArraySupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__deferredMappingHipArraySupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__ipcEventSupported` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__ipcEventSupported` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__ipcEventSupported;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__clusterLaunch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clusterLaunch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clusterLaunch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__unifiedFunctionPointers` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__unifiedFunctionPointers` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__unifiedFunctionPointers;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hipReserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hipReserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hipReserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__gcnArchName` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__gcnArchName` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__gcnArchName;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__maxSharedMemoryPerMultiProcessor` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__maxSharedMemoryPerMultiProcessor;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__clockInstructionRate` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__clockInstructionRate` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__clockInstructionRate;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt32Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt32Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt32Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedFloatAtomicExch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedFloatAtomicExch` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedFloatAtomicExch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFloatAtomicAdd` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFloatAtomicAdd` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFloatAtomicAdd;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasGlobalInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasGlobalInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasGlobalInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSharedInt64Atomics` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSharedInt64Atomics` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSharedInt64Atomics;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDoubles` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDoubles` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDoubles;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpVote` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpVote` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpVote;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpBallot` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpBallot` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpBallot;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasWarpShuffle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasWarpShuffle` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasWarpShuffle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasFunnelShift` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasFunnelShift` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasFunnelShift;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasThreadFenceSystem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasThreadFenceSystem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasThreadFenceSystem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSyncThreadsExt` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSyncThreadsExt` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSyncThreadsExt;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasSurfaceFuncs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasSurfaceFuncs` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasSurfaceFuncs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__has3dGrid` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__has3dGrid` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__has3dGrid;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__arch__hasDynamicParallelism` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__arch__hasDynamicParallelism` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__arch__hasDynamicParallelism;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__hdpMemFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpMemFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpMemFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__hdpRegFlushCntl` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__hdpRegFlushCntl` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__hdpRegFlushCntl;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedFunc` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedFunc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedGridDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedGridDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedBlockDim` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__cooperativeMultiDeviceUnmatchedSharedMem` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__isLargeBar` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__isLargeBar` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__isLargeBar;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__asicRevision` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__asicRevision` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__asicRevision;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_deviceId` field */
		_ALIGN(ctx->at, 8);

		/* Write `_deviceId` field */
		{
			const uint32_t tmp_val = (uint32_t) p__deviceId;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetDevicePropertiesR0600End(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 225);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetDriverEntryPointBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const char * const p__symbol,
	const int8_t p__symbol__val,
	const uint64_t p__funcPtr,
	const uint64_t p__funcPtr__val,
	const uint64_t p__flags,
	const uint64_t p__driverStatus,
	const int32_t p__driverStatus__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 226);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		_write_c_str(ctx, p__symbol);

		/* Align for `_symbol__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__symbol__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_funcPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_funcPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__funcPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_funcPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_funcPtr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__funcPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_driverStatus` field */
		_ALIGN(ctx->at, 8);

		/* Write `_driverStatus` field */
		{
			const uint64_t tmp_val = (uint64_t) p__driverStatus;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_driverStatus__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_driverStatus__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__driverStatus__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetDriverEntryPointEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 227);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetFuncBySymbolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__functionPtr,
	const uint64_t p__functionPtr__val,
	const uint64_t p__symbolPtr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 228);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_functionPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_functionPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__functionPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_functionPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_functionPtr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__functionPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbolPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbolPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbolPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGetFuncBySymbolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 229);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetLastErrorBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 230);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetLastErrorEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 231);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetMipmappedArrayLevelBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__levelArray,
	const uint64_t p__levelArray__val,
	const uint64_t p__mipmappedArray,
	const uint32_t p__level)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 232);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_levelArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_levelArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__levelArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_levelArray__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_levelArray__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__levelArray__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmappedArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmappedArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmappedArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_level` field */
		_ALIGN(ctx->at, 8);

		/* Write `_level` field */
		{
			const uint32_t tmp_val = (uint32_t) p__level;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetMipmappedArrayLevelEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 233);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetProcAddressBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const char * const p__symbol,
	const int8_t p__symbol__val,
	const uint64_t p__pfn,
	const uint64_t p__pfn__val,
	const int32_t p__hipVersion,
	const uint64_t p__flags,
	const uint64_t p__symbolStatus,
	const int32_t p__symbolStatus__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 234);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		_write_c_str(ctx, p__symbol);

		/* Align for `_symbol__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__symbol__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_pfn` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pfn` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pfn;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pfn__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pfn__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pfn__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hipVersion` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hipVersion` field */
		{
			const uint32_t tmp_val = (uint32_t) p__hipVersion;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbolStatus` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbolStatus` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbolStatus;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbolStatus__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbolStatus__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__symbolStatus__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGetProcAddressEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 235);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetSymbolAddressBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__devPtr,
	const uint64_t p__devPtr__val,
	const uint64_t p__symbol)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 236);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_devPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGetSymbolAddressEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 237);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGetSymbolSizeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__size,
	const uint64_t p__size__val,
	const uint64_t p__symbol)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 238);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGetSymbolSizeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 239);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddBatchMemOpNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__phGraphNode,
	const uint64_t p__phGraphNode__val,
	const uint64_t p__hGraph,
	const uint64_t p__dependencies,
	const uint64_t p__dependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__ctx,
	const uint32_t p__nodeParams__val__count,
	const uint64_t p__nodeParams__val__paramArray,
	const uint32_t p__nodeParams__val__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 240);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_phGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_phGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_phGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__phGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__paramArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddBatchMemOpNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 241);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddChildGraphNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__childGraph)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 242);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_childGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_childGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__childGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddChildGraphNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 243);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddDependenciesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const uint64_t p__from,
	const uint64_t p__from__val,
	const uint64_t p__to,
	const uint64_t p__to__val,
	const uint64_t p__numDependencies)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 244);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_from` field */
		_ALIGN(ctx->at, 8);

		/* Write `_from` field */
		{
			const uint64_t tmp_val = (uint64_t) p__from;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_from__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_from__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__from__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_to` field */
		_ALIGN(ctx->at, 8);

		/* Write `_to` field */
		{
			const uint64_t tmp_val = (uint64_t) p__to;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_to__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_to__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__to__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddDependenciesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 245);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddEmptyNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 246);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddEmptyNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 247);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddEventRecordNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 248);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddEventRecordNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 249);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddEventWaitNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 250);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddEventWaitNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 251);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddExternalSemaphoresSignalNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__extSemArray,
	const uint64_t p__nodeParams__val__paramsArray,
	const uint32_t p__nodeParams__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 252);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddExternalSemaphoresSignalNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 253);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddExternalSemaphoresWaitNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__extSemArray,
	const uint64_t p__nodeParams__val__paramsArray,
	const uint32_t p__nodeParams__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 254);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddExternalSemaphoresWaitNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 255);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddHostNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__fn,
	const uint64_t p__pNodeParams__val__userData)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 256);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__fn` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__fn` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__fn;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__userData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__userData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__userData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddHostNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 257);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddKernelNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__pNodeParams,
	const uint32_t p__pNodeParams__val__blockDim__x,
	const uint32_t p__pNodeParams__val__blockDim__y,
	const uint32_t p__pNodeParams__val__blockDim__z,
	const uint64_t p__pNodeParams__val__extra,
	const uint64_t p__pNodeParams__val__func,
	const uint32_t p__pNodeParams__val__gridDim__x,
	const uint32_t p__pNodeParams__val__gridDim__y,
	const uint32_t p__pNodeParams__val__gridDim__z,
	const uint64_t p__pNodeParams__val__kernelParams,
	const uint32_t p__pNodeParams__val__sharedMemBytes)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 258);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__extra` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extra` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extra;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__kernelParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__kernelParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__kernelParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__sharedMemBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddKernelNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 259);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddMemAllocNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__pNodeParams,
	const int32_t p__pNodeParams__val__poolProps__allocType,
	const int32_t p__pNodeParams__val__poolProps__handleTypes,
	const int32_t p__pNodeParams__val__poolProps__location__type,
	const int32_t p__pNodeParams__val__poolProps__location__id,
	const uint64_t p__pNodeParams__val__poolProps__win32SecurityAttributes,
	const uint64_t p__pNodeParams__val__poolProps__maxSize,
	const uint64_t p__pNodeParams__val__poolProps__reserved,
	const uint64_t p__pNodeParams__val__accessDescs,
	const uint64_t p__pNodeParams__val__accessDescCount,
	const uint64_t p__pNodeParams__val__bytesize,
	const uint64_t p__pNodeParams__val__dptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 260);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__poolProps__allocType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__allocType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__allocType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__handleTypes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__handleTypes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__handleTypes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__location__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__location__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__location__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__location__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__location__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__location__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__win32SecurityAttributes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__win32SecurityAttributes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__poolProps__win32SecurityAttributes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__poolProps__maxSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__maxSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__poolProps__maxSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__poolProps__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__poolProps__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__accessDescs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__accessDescs` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__accessDescs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__accessDescCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__accessDescCount` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__accessDescCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__bytesize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__bytesize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__bytesize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddMemAllocNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 261);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddMemFreeNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__dev_ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 262);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddMemFreeNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 263);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNode1DBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__dst,
	const uint64_t p__src,
	const uint64_t p__count,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 264);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_src` field */
		_ALIGN(ctx->at, 8);

		/* Write `_src` field */
		{
			const uint64_t tmp_val = (uint64_t) p__src;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNode1DEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 265);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__pCopyParams,
	const uint64_t p__pCopyParams__val__srcArray,
	const uint64_t p__pCopyParams__val__srcPos__x,
	const uint64_t p__pCopyParams__val__srcPos__y,
	const uint64_t p__pCopyParams__val__srcPos__z,
	const uint64_t p__pCopyParams__val__srcPtr__ptr,
	const uint64_t p__pCopyParams__val__srcPtr__pitch,
	const uint64_t p__pCopyParams__val__srcPtr__xsize,
	const uint64_t p__pCopyParams__val__srcPtr__ysize,
	const uint64_t p__pCopyParams__val__dstArray,
	const uint64_t p__pCopyParams__val__dstPos__x,
	const uint64_t p__pCopyParams__val__dstPos__y,
	const uint64_t p__pCopyParams__val__dstPos__z,
	const uint64_t p__pCopyParams__val__dstPtr__ptr,
	const uint64_t p__pCopyParams__val__dstPtr__pitch,
	const uint64_t p__pCopyParams__val__dstPtr__xsize,
	const uint64_t p__pCopyParams__val__dstPtr__ysize,
	const uint64_t p__pCopyParams__val__extent__width,
	const uint64_t p__pCopyParams__val__extent__height,
	const uint64_t p__pCopyParams__val__extent__depth,
	const int32_t p__pCopyParams__val__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 266);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__srcPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__srcPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__srcPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__dstPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__dstPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__dstPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pCopyParams__val__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pCopyParams__val__kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pCopyParams__val__kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pCopyParams__val__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 267);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNodeFromSymbolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__dst,
	const uint64_t p__symbol,
	const uint64_t p__count,
	const uint64_t p__offset,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 268);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNodeFromSymbolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 269);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNodeToSymbolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__symbol,
	const uint64_t p__src,
	const uint64_t p__count,
	const uint64_t p__offset,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 270);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_src` field */
		_ALIGN(ctx->at, 8);

		/* Write `_src` field */
		{
			const uint64_t tmp_val = (uint64_t) p__src;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddMemcpyNodeToSymbolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 271);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddMemsetNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__pMemsetParams,
	const uint64_t p__pMemsetParams__val__dst,
	const uint32_t p__pMemsetParams__val__elementSize,
	const uint64_t p__pMemsetParams__val__height,
	const uint64_t p__pMemsetParams__val__pitch,
	const uint32_t p__pMemsetParams__val__value,
	const uint64_t p__pMemsetParams__val__width)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 272);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pMemsetParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pMemsetParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pMemsetParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pMemsetParams__val__dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pMemsetParams__val__dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pMemsetParams__val__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pMemsetParams__val__elementSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pMemsetParams__val__elementSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pMemsetParams__val__elementSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pMemsetParams__val__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pMemsetParams__val__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pMemsetParams__val__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pMemsetParams__val__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pMemsetParams__val__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pMemsetParams__val__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pMemsetParams__val__value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pMemsetParams__val__value` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pMemsetParams__val__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pMemsetParams__val__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pMemsetParams__val__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pMemsetParams__val__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddMemsetNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 273);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphAddNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphNode,
	const uint64_t p__pGraphNode__val,
	const uint64_t p__graph,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__numDependencies,
	const uint64_t p__nodeParams,
	const int32_t p__nodeParams__val__type,
	const uint64_t p__nodeParams__val__reserved0,
	const int64_t p__nodeParams__val__reserved2)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 274);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__reserved0` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__reserved0` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__reserved0;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__reserved2` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__reserved2` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__reserved2;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphAddNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 275);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphBatchMemOpNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams_out,
	const uint64_t p__nodeParams_out__val__ctx,
	const uint32_t p__nodeParams_out__val__count,
	const uint64_t p__nodeParams_out__val__paramArray,
	const uint32_t p__nodeParams_out__val__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 276);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams_out__val__ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams_out__val__ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams_out__val__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams_out__val__count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams_out__val__count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams_out__val__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams_out__val__paramArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams_out__val__paramArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams_out__val__paramArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams_out__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams_out__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams_out__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphBatchMemOpNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 277);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphBatchMemOpNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__ctx,
	const uint32_t p__nodeParams__val__count,
	const uint64_t p__nodeParams__val__paramArray,
	const uint32_t p__nodeParams__val__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 278);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__paramArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphBatchMemOpNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 279);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphChildGraphNodeGetGraphBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pGraph,
	const uint64_t p__pGraph__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 280);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraph__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraph__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraph__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphChildGraphNodeGetGraphEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 281);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphCloneBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphClone,
	const uint64_t p__pGraphClone__val,
	const uint64_t p__originalGraph)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 282);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphClone` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphClone` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphClone;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphClone__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphClone__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphClone__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_originalGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_originalGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__originalGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphCloneEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 283);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraph,
	const uint64_t p__pGraph__val,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 284);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraph__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraph__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraph__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 285);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphDebugDotPrintBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const char * const p__path,
	const int8_t p__path__val,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 286);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_path` field */
		_ALIGN(ctx->at, 8);

		/* Write `_path` field */
		_write_c_str(ctx, p__path);

		/* Align for `_path__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_path__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__path__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphDebugDotPrintEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 287);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphDestroyBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 288);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphDestroyEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 289);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphDestroyNodeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 290);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphDestroyNodeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 291);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphEventRecordNodeGetEventBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__event_out,
	const uint64_t p__event_out__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 292);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event_out__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event_out__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event_out__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphEventRecordNodeGetEventEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 293);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphEventRecordNodeSetEventBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 294);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphEventRecordNodeSetEventEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 295);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphEventWaitNodeGetEventBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__event_out,
	const uint64_t p__event_out__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 296);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event_out__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event_out__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event_out__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphEventWaitNodeGetEventEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 297);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphEventWaitNodeSetEventBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 298);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphEventWaitNodeSetEventEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 299);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecBatchMemOpNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__ctx,
	const uint32_t p__nodeParams__val__count,
	const uint64_t p__nodeParams__val__paramArray,
	const uint32_t p__nodeParams__val__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 300);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__ctx` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__ctx` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__ctx;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__paramArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecBatchMemOpNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 301);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecChildGraphNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__childGraph)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 302);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_childGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_childGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__childGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecChildGraphNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 303);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecDestroyBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graphExec)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 304);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecDestroyEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 305);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecEventRecordNodeSetEventBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 306);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecEventRecordNodeSetEventEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 307);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecEventWaitNodeSetEventBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 308);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecEventWaitNodeSetEventEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 309);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecExternalSemaphoresSignalNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__extSemArray,
	const uint64_t p__nodeParams__val__paramsArray,
	const uint32_t p__nodeParams__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 310);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecExternalSemaphoresSignalNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 311);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecExternalSemaphoresWaitNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__extSemArray,
	const uint64_t p__nodeParams__val__paramsArray,
	const uint32_t p__nodeParams__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 312);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecExternalSemaphoresWaitNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 313);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecGetFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graphExec,
	const uint64_t p__flags,
	const uint64_t p__flags__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 314);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecGetFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 315);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecHostNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__fn,
	const uint64_t p__pNodeParams__val__userData)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 316);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__fn` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__fn` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__fn;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__userData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__userData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__userData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecHostNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 317);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecKernelNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint32_t p__pNodeParams__val__blockDim__x,
	const uint32_t p__pNodeParams__val__blockDim__y,
	const uint32_t p__pNodeParams__val__blockDim__z,
	const uint64_t p__pNodeParams__val__extra,
	const uint64_t p__pNodeParams__val__func,
	const uint32_t p__pNodeParams__val__gridDim__x,
	const uint32_t p__pNodeParams__val__gridDim__y,
	const uint32_t p__pNodeParams__val__gridDim__z,
	const uint64_t p__pNodeParams__val__kernelParams,
	const uint32_t p__pNodeParams__val__sharedMemBytes)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 318);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__extra` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extra` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extra;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__kernelParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__kernelParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__kernelParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__sharedMemBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecKernelNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 319);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParams1DBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__dst,
	const uint64_t p__src,
	const uint64_t p__count,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 320);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_src` field */
		_ALIGN(ctx->at, 8);

		/* Write `_src` field */
		{
			const uint64_t tmp_val = (uint64_t) p__src;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParams1DEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 321);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__srcArray,
	const uint64_t p__pNodeParams__val__srcPos__x,
	const uint64_t p__pNodeParams__val__srcPos__y,
	const uint64_t p__pNodeParams__val__srcPos__z,
	const uint64_t p__pNodeParams__val__srcPtr__ptr,
	const uint64_t p__pNodeParams__val__srcPtr__pitch,
	const uint64_t p__pNodeParams__val__srcPtr__xsize,
	const uint64_t p__pNodeParams__val__srcPtr__ysize,
	const uint64_t p__pNodeParams__val__dstArray,
	const uint64_t p__pNodeParams__val__dstPos__x,
	const uint64_t p__pNodeParams__val__dstPos__y,
	const uint64_t p__pNodeParams__val__dstPos__z,
	const uint64_t p__pNodeParams__val__dstPtr__ptr,
	const uint64_t p__pNodeParams__val__dstPtr__pitch,
	const uint64_t p__pNodeParams__val__dstPtr__xsize,
	const uint64_t p__pNodeParams__val__dstPtr__ysize,
	const uint64_t p__pNodeParams__val__extent__width,
	const uint64_t p__pNodeParams__val__extent__height,
	const uint64_t p__pNodeParams__val__extent__depth,
	const int32_t p__pNodeParams__val__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 322);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 323);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParamsFromSymbolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__dst,
	const uint64_t p__symbol,
	const uint64_t p__count,
	const uint64_t p__offset,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 324);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParamsFromSymbolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 325);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParamsToSymbolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__symbol,
	const uint64_t p__src,
	const uint64_t p__count,
	const uint64_t p__offset,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 326);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_src` field */
		_ALIGN(ctx->at, 8);

		/* Write `_src` field */
		{
			const uint64_t tmp_val = (uint64_t) p__src;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecMemcpyNodeSetParamsToSymbolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 327);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecMemsetNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__dst,
	const uint32_t p__pNodeParams__val__elementSize,
	const uint64_t p__pNodeParams__val__height,
	const uint64_t p__pNodeParams__val__pitch,
	const uint32_t p__pNodeParams__val__value,
	const uint64_t p__pNodeParams__val__width)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 328);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__elementSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__elementSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__elementSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__value` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecMemsetNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 329);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graphExec,
	const uint64_t p__node,
	const uint64_t p__nodeParams,
	const int32_t p__nodeParams__val__type,
	const uint64_t p__nodeParams__val__reserved0,
	const int64_t p__nodeParams__val__reserved2)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 330);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__reserved0` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__reserved0` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__reserved0;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__reserved2` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__reserved2` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__reserved2;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 331);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExecUpdateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hGraph,
	const uint64_t p__hErrorNode_out,
	const uint64_t p__hErrorNode_out__val,
	const uint64_t p__updateResult_out,
	const int32_t p__updateResult_out__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 332);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hErrorNode_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hErrorNode_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hErrorNode_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hErrorNode_out__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hErrorNode_out__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hErrorNode_out__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_updateResult_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_updateResult_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__updateResult_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_updateResult_out__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_updateResult_out__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__updateResult_out__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExecUpdateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 333);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresSignalNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__params_out,
	const uint64_t p__params_out__val__extSemArray,
	const uint64_t p__params_out__val__paramsArray,
	const uint32_t p__params_out__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 334);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params_out__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params_out__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__params_out__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresSignalNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 335);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresSignalNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__extSemArray,
	const uint64_t p__nodeParams__val__paramsArray,
	const uint32_t p__nodeParams__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 336);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresSignalNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 337);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresWaitNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__params_out,
	const uint64_t p__params_out__val__extSemArray,
	const uint64_t p__params_out__val__paramsArray,
	const uint32_t p__params_out__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 338);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params_out__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__params_out__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_params_out__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_params_out__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__params_out__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresWaitNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 339);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresWaitNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const uint64_t p__nodeParams,
	const uint64_t p__nodeParams__val__extSemArray,
	const uint64_t p__nodeParams__val__paramsArray,
	const uint32_t p__nodeParams__val__numExtSems)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 340);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__extSemArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__extSemArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__extSemArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__paramsArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__paramsArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__paramsArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__numExtSems` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__numExtSems` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__numExtSems;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphExternalSemaphoresWaitNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 341);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphGetEdgesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const uint64_t p__from,
	const uint64_t p__from__val,
	const uint64_t p__to,
	const uint64_t p__to__val,
	const uint64_t p__numEdges,
	const uint64_t p__numEdges__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 342);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_from` field */
		_ALIGN(ctx->at, 8);

		/* Write `_from` field */
		{
			const uint64_t tmp_val = (uint64_t) p__from;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_from__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_from__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__from__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_to` field */
		_ALIGN(ctx->at, 8);

		/* Write `_to` field */
		{
			const uint64_t tmp_val = (uint64_t) p__to;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_to__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_to__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__to__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numEdges` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numEdges` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numEdges;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numEdges__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numEdges__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numEdges__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphGetEdgesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 343);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphGetNodesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const uint64_t p__nodes,
	const uint64_t p__nodes__val,
	const uint64_t p__numNodes,
	const uint64_t p__numNodes__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 344);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodes__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numNodes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numNodes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numNodes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numNodes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numNodes__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numNodes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphGetNodesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 345);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphGetRootNodesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const uint64_t p__pRootNodes,
	const uint64_t p__pRootNodes__val,
	const uint64_t p__pNumRootNodes,
	const uint64_t p__pNumRootNodes__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 346);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pRootNodes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pRootNodes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pRootNodes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pRootNodes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pRootNodes__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pRootNodes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNumRootNodes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNumRootNodes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNumRootNodes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNumRootNodes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNumRootNodes__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNumRootNodes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphGetRootNodesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 347);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphHostNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__fn,
	const uint64_t p__pNodeParams__val__userData)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 348);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__fn` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__fn` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__fn;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__userData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__userData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__userData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphHostNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 349);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphHostNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__fn,
	const uint64_t p__pNodeParams__val__userData)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 350);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__fn` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__fn` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__fn;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__userData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__userData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__userData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphHostNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 351);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphInstantiateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphExec,
	const uint64_t p__pGraphExec__val,
	const uint64_t p__graph,
	const uint64_t p__pErrorNode,
	const uint64_t p__pErrorNode__val,
	const char * const p__pLogBuffer,
	const int8_t p__pLogBuffer__val,
	const uint64_t p__bufferSize)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 352);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphExec__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphExec__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphExec__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pErrorNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pErrorNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pErrorNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pErrorNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pErrorNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pErrorNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pLogBuffer` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pLogBuffer` field */
		_write_c_str(ctx, p__pLogBuffer);

		/* Align for `_pLogBuffer__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pLogBuffer__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__pLogBuffer__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_bufferSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_bufferSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__bufferSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphInstantiateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 353);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphInstantiateWithFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphExec,
	const uint64_t p__pGraphExec__val,
	const uint64_t p__graph,
	const uint64_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 354);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphExec__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphExec__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphExec__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphInstantiateWithFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 355);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphInstantiateWithParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pGraphExec,
	const uint64_t p__pGraphExec__val,
	const uint64_t p__graph,
	const uint64_t p__instantiateParams,
	const uint64_t p__instantiateParams__val__errNode_out,
	const uint64_t p__instantiateParams__val__flags,
	const int32_t p__instantiateParams__val__result_out,
	const uint64_t p__instantiateParams__val__uploadStream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 356);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pGraphExec__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pGraphExec__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pGraphExec__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_instantiateParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_instantiateParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__instantiateParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_instantiateParams__val__errNode_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_instantiateParams__val__errNode_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__instantiateParams__val__errNode_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_instantiateParams__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_instantiateParams__val__flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__instantiateParams__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_instantiateParams__val__result_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_instantiateParams__val__result_out` field */
		{
			const uint32_t tmp_val = (uint32_t) p__instantiateParams__val__result_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_instantiateParams__val__uploadStream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_instantiateParams__val__uploadStream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__instantiateParams__val__uploadStream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphInstantiateWithParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 357);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeCopyAttributesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hSrc,
	const uint64_t p__hDst)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 358);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hSrc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hSrc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hSrc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hDst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hDst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hDst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeCopyAttributesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 359);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeGetAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const int32_t p__attr,
	const uint64_t p__value,
	const uint64_t p__value__val__pad,
	const uint64_t p__value__val__accessPolicyWindow__base_ptr,
	const int32_t p__value__val__accessPolicyWindow__hitProp,
	const uint64_t p__value__val__accessPolicyWindow__hitRatio,
	const int32_t p__value__val__accessPolicyWindow__missProp,
	const uint64_t p__value__val__accessPolicyWindow__num_bytes,
	const int32_t p__value__val__cooperative,
	const int32_t p__value__val__priority,
	const int32_t p__value__val__syncPolicy,
	const uint8_t p__value__val__memSyncDomainMap__default_,
	const uint8_t p__value__val__memSyncDomainMap__remote,
	const int32_t p__value__val__memSyncDomain)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 360);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__pad` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__pad` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value__val__pad;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__accessPolicyWindow__base_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__base_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value__val__accessPolicyWindow__base_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__accessPolicyWindow__hitProp` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__hitProp` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__accessPolicyWindow__hitProp;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__accessPolicyWindow__hitRatio` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__hitRatio` field */
		{
			union _f2u f2u;

			f2u.f = p__value__val__accessPolicyWindow__hitRatio;
			{
				const uint32_t tmp_val = (uint32_t) f2u.u;

				memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
				ctx->at += 32;
			}
		}

		/* Align for `_value__val__accessPolicyWindow__missProp` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__missProp` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__accessPolicyWindow__missProp;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__accessPolicyWindow__num_bytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__num_bytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value__val__accessPolicyWindow__num_bytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__cooperative` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__cooperative` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__cooperative;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__priority` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__priority` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__priority;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__syncPolicy` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__syncPolicy` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__syncPolicy;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__memSyncDomainMap__default_` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__memSyncDomainMap__default_` field */
		{
			const uint8_t tmp_val = (uint8_t) p__value__val__memSyncDomainMap__default_;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_value__val__memSyncDomainMap__remote` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__memSyncDomainMap__remote` field */
		{
			const uint8_t tmp_val = (uint8_t) p__value__val__memSyncDomainMap__remote;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_value__val__memSyncDomain` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__memSyncDomain` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__memSyncDomain;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeGetAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 361);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint32_t p__pNodeParams__val__blockDim__x,
	const uint32_t p__pNodeParams__val__blockDim__y,
	const uint32_t p__pNodeParams__val__blockDim__z,
	const uint64_t p__pNodeParams__val__extra,
	const uint64_t p__pNodeParams__val__func,
	const uint32_t p__pNodeParams__val__gridDim__x,
	const uint32_t p__pNodeParams__val__gridDim__y,
	const uint32_t p__pNodeParams__val__gridDim__z,
	const uint64_t p__pNodeParams__val__kernelParams,
	const uint32_t p__pNodeParams__val__sharedMemBytes)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 362);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__extra` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extra` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extra;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__kernelParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__kernelParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__kernelParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__sharedMemBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 363);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeSetAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hNode,
	const int32_t p__attr,
	const uint64_t p__value,
	const uint64_t p__value__val__pad,
	const uint64_t p__value__val__accessPolicyWindow__base_ptr,
	const int32_t p__value__val__accessPolicyWindow__hitProp,
	const uint64_t p__value__val__accessPolicyWindow__hitRatio,
	const int32_t p__value__val__accessPolicyWindow__missProp,
	const uint64_t p__value__val__accessPolicyWindow__num_bytes,
	const int32_t p__value__val__cooperative,
	const int32_t p__value__val__priority,
	const int32_t p__value__val__syncPolicy,
	const uint8_t p__value__val__memSyncDomainMap__default_,
	const uint8_t p__value__val__memSyncDomainMap__remote,
	const int32_t p__value__val__memSyncDomain)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 364);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__pad` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__pad` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value__val__pad;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__accessPolicyWindow__base_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__base_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value__val__accessPolicyWindow__base_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__accessPolicyWindow__hitProp` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__hitProp` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__accessPolicyWindow__hitProp;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__accessPolicyWindow__hitRatio` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__hitRatio` field */
		{
			union _f2u f2u;

			f2u.f = p__value__val__accessPolicyWindow__hitRatio;
			{
				const uint32_t tmp_val = (uint32_t) f2u.u;

				memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
				ctx->at += 32;
			}
		}

		/* Align for `_value__val__accessPolicyWindow__missProp` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__missProp` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__accessPolicyWindow__missProp;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__accessPolicyWindow__num_bytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__accessPolicyWindow__num_bytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value__val__accessPolicyWindow__num_bytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_value__val__cooperative` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__cooperative` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__cooperative;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__priority` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__priority` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__priority;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__syncPolicy` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__syncPolicy` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__syncPolicy;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value__val__memSyncDomainMap__default_` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__memSyncDomainMap__default_` field */
		{
			const uint8_t tmp_val = (uint8_t) p__value__val__memSyncDomainMap__default_;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_value__val__memSyncDomainMap__remote` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__memSyncDomainMap__remote` field */
		{
			const uint8_t tmp_val = (uint8_t) p__value__val__memSyncDomainMap__remote;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_value__val__memSyncDomain` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value__val__memSyncDomain` field */
		{
			const uint32_t tmp_val = (uint32_t) p__value__val__memSyncDomain;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeSetAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 365);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint32_t p__pNodeParams__val__blockDim__x,
	const uint32_t p__pNodeParams__val__blockDim__y,
	const uint32_t p__pNodeParams__val__blockDim__z,
	const uint64_t p__pNodeParams__val__extra,
	const uint64_t p__pNodeParams__val__func,
	const uint32_t p__pNodeParams__val__gridDim__x,
	const uint32_t p__pNodeParams__val__gridDim__y,
	const uint32_t p__pNodeParams__val__gridDim__z,
	const uint64_t p__pNodeParams__val__kernelParams,
	const uint32_t p__pNodeParams__val__sharedMemBytes)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 366);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__extra` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extra` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extra;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__kernelParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__kernelParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__kernelParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__sharedMemBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphKernelNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 367);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphLaunchBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graphExec,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 368);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphLaunchEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 369);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemAllocNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const int32_t p__pNodeParams__val__poolProps__allocType,
	const int32_t p__pNodeParams__val__poolProps__handleTypes,
	const int32_t p__pNodeParams__val__poolProps__location__type,
	const int32_t p__pNodeParams__val__poolProps__location__id,
	const uint64_t p__pNodeParams__val__poolProps__win32SecurityAttributes,
	const uint64_t p__pNodeParams__val__poolProps__maxSize,
	const uint64_t p__pNodeParams__val__poolProps__reserved,
	const uint64_t p__pNodeParams__val__accessDescs,
	const uint64_t p__pNodeParams__val__accessDescCount,
	const uint64_t p__pNodeParams__val__bytesize,
	const uint64_t p__pNodeParams__val__dptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 370);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__poolProps__allocType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__allocType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__allocType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__handleTypes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__handleTypes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__handleTypes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__location__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__location__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__location__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__location__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__location__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__poolProps__location__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__poolProps__win32SecurityAttributes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__win32SecurityAttributes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__poolProps__win32SecurityAttributes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__poolProps__maxSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__maxSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__poolProps__maxSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__poolProps__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__poolProps__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__poolProps__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__accessDescs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__accessDescs` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__accessDescs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__accessDescCount` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__accessDescCount` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__accessDescCount;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__bytesize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__bytesize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__bytesize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemAllocNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 371);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemFreeNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__dev_ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 372);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemFreeNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 373);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__srcArray,
	const uint64_t p__pNodeParams__val__srcPos__x,
	const uint64_t p__pNodeParams__val__srcPos__y,
	const uint64_t p__pNodeParams__val__srcPos__z,
	const uint64_t p__pNodeParams__val__srcPtr__ptr,
	const uint64_t p__pNodeParams__val__srcPtr__pitch,
	const uint64_t p__pNodeParams__val__srcPtr__xsize,
	const uint64_t p__pNodeParams__val__srcPtr__ysize,
	const uint64_t p__pNodeParams__val__dstArray,
	const uint64_t p__pNodeParams__val__dstPos__x,
	const uint64_t p__pNodeParams__val__dstPos__y,
	const uint64_t p__pNodeParams__val__dstPos__z,
	const uint64_t p__pNodeParams__val__dstPtr__ptr,
	const uint64_t p__pNodeParams__val__dstPtr__pitch,
	const uint64_t p__pNodeParams__val__dstPtr__xsize,
	const uint64_t p__pNodeParams__val__dstPtr__ysize,
	const uint64_t p__pNodeParams__val__extent__width,
	const uint64_t p__pNodeParams__val__extent__height,
	const uint64_t p__pNodeParams__val__extent__depth,
	const int32_t p__pNodeParams__val__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 374);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 375);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParams1DBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__dst,
	const uint64_t p__src,
	const uint64_t p__count,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 376);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_src` field */
		_ALIGN(ctx->at, 8);

		/* Write `_src` field */
		{
			const uint64_t tmp_val = (uint64_t) p__src;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParams1DEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 377);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__srcArray,
	const uint64_t p__pNodeParams__val__srcPos__x,
	const uint64_t p__pNodeParams__val__srcPos__y,
	const uint64_t p__pNodeParams__val__srcPos__z,
	const uint64_t p__pNodeParams__val__srcPtr__ptr,
	const uint64_t p__pNodeParams__val__srcPtr__pitch,
	const uint64_t p__pNodeParams__val__srcPtr__xsize,
	const uint64_t p__pNodeParams__val__srcPtr__ysize,
	const uint64_t p__pNodeParams__val__dstArray,
	const uint64_t p__pNodeParams__val__dstPos__x,
	const uint64_t p__pNodeParams__val__dstPos__y,
	const uint64_t p__pNodeParams__val__dstPos__z,
	const uint64_t p__pNodeParams__val__dstPtr__ptr,
	const uint64_t p__pNodeParams__val__dstPtr__pitch,
	const uint64_t p__pNodeParams__val__dstPtr__xsize,
	const uint64_t p__pNodeParams__val__dstPtr__ysize,
	const uint64_t p__pNodeParams__val__extent__width,
	const uint64_t p__pNodeParams__val__extent__height,
	const uint64_t p__pNodeParams__val__extent__depth,
	const int32_t p__pNodeParams__val__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 378);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__srcPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__srcPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__srcPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__x` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__y` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPos__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPos__z` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPos__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dstPtr__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dstPtr__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dstPtr__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 379);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParamsFromSymbolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__dst,
	const uint64_t p__symbol,
	const uint64_t p__count,
	const uint64_t p__offset,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 380);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParamsFromSymbolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 381);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParamsToSymbolBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__symbol,
	const uint64_t p__src,
	const uint64_t p__count,
	const uint64_t p__offset,
	const int32_t p__kind)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 382);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_symbol` field */
		_ALIGN(ctx->at, 8);

		/* Write `_symbol` field */
		{
			const uint64_t tmp_val = (uint64_t) p__symbol;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_src` field */
		_ALIGN(ctx->at, 8);

		/* Write `_src` field */
		{
			const uint64_t tmp_val = (uint64_t) p__src;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kind` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kind` field */
		{
			const uint32_t tmp_val = (uint32_t) p__kind;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemcpyNodeSetParamsToSymbolEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 383);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemsetNodeGetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__dst,
	const uint32_t p__pNodeParams__val__elementSize,
	const uint64_t p__pNodeParams__val__height,
	const uint64_t p__pNodeParams__val__pitch,
	const uint32_t p__pNodeParams__val__value,
	const uint64_t p__pNodeParams__val__width)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 384);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__elementSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__elementSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__elementSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__value` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemsetNodeGetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 385);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphMemsetNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pNodeParams,
	const uint64_t p__pNodeParams__val__dst,
	const uint32_t p__pNodeParams__val__elementSize,
	const uint64_t p__pNodeParams__val__height,
	const uint64_t p__pNodeParams__val__pitch,
	const uint32_t p__pNodeParams__val__value,
	const uint64_t p__pNodeParams__val__width)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 386);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__dst` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__dst` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__dst;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__elementSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__elementSize` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__elementSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNodeParams__val__value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__value` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pNodeParams__val__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pNodeParams__val__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNodeParams__val__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNodeParams__val__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphMemsetNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 387);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphNodeFindInCloneBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pNode,
	const uint64_t p__pNode__val,
	const uint64_t p__originalNode,
	const uint64_t p__clonedGraph)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 388);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNode__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNode__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNode__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_originalNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_originalNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__originalNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_clonedGraph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_clonedGraph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__clonedGraph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphNodeFindInCloneEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 389);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetDependenciesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pDependencies,
	const uint64_t p__pDependencies__val,
	const uint64_t p__pNumDependencies,
	const uint64_t p__pNumDependencies__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 390);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNumDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNumDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNumDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNumDependencies__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNumDependencies__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNumDependencies__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetDependenciesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 391);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetDependentNodesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pDependentNodes,
	const uint64_t p__pDependentNodes__val,
	const uint64_t p__pNumDependentNodes,
	const uint64_t p__pNumDependentNodes__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 392);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependentNodes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependentNodes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependentNodes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pDependentNodes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pDependentNodes__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pDependentNodes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNumDependentNodes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNumDependentNodes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNumDependentNodes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pNumDependentNodes__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pNumDependentNodes__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pNumDependentNodes__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetDependentNodesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 393);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetEnabledBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint64_t p__isEnabled,
	const uint32_t p__isEnabled__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 394);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_isEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_isEnabled` field */
		{
			const uint64_t tmp_val = (uint64_t) p__isEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_isEnabled__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_isEnabled__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__isEnabled__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetEnabledEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 395);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetTypeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__pType,
	const int32_t p__pType__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 396);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pType` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pType__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pType__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pType__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphNodeGetTypeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 397);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphNodeSetEnabledBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hGraphExec,
	const uint64_t p__hNode,
	const uint32_t p__isEnabled)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 398);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hGraphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hGraphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hGraphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hNode` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hNode` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hNode;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_isEnabled` field */
		_ALIGN(ctx->at, 8);

		/* Write `_isEnabled` field */
		{
			const uint32_t tmp_val = (uint32_t) p__isEnabled;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphNodeSetEnabledEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 399);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphNodeSetParamsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__node,
	const uint64_t p__nodeParams,
	const int32_t p__nodeParams__val__type,
	const uint64_t p__nodeParams__val__reserved0,
	const int64_t p__nodeParams__val__reserved2)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 400);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_node` field */
		_ALIGN(ctx->at, 8);

		/* Write `_node` field */
		{
			const uint64_t tmp_val = (uint64_t) p__node;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__nodeParams__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_nodeParams__val__reserved0` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__reserved0` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__reserved0;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_nodeParams__val__reserved2` field */
		_ALIGN(ctx->at, 8);

		/* Write `_nodeParams__val__reserved2` field */
		{
			const uint64_t tmp_val = (uint64_t) p__nodeParams__val__reserved2;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphNodeSetParamsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 401);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphReleaseUserObjectBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const uint64_t p__object,
	const uint32_t p__count)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 402);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_object` field */
		_ALIGN(ctx->at, 8);

		/* Write `_object` field */
		{
			const uint64_t tmp_val = (uint64_t) p__object;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphReleaseUserObjectEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 403);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphRemoveDependenciesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const uint64_t p__from,
	const uint64_t p__from__val,
	const uint64_t p__to,
	const uint64_t p__to__val,
	const uint64_t p__numDependencies)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 404);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_from` field */
		_ALIGN(ctx->at, 8);

		/* Write `_from` field */
		{
			const uint64_t tmp_val = (uint64_t) p__from;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_from__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_from__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__from__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_to` field */
		_ALIGN(ctx->at, 8);

		/* Write `_to` field */
		{
			const uint64_t tmp_val = (uint64_t) p__to;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_to__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_to__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__to__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDependencies` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDependencies` field */
		{
			const uint64_t tmp_val = (uint64_t) p__numDependencies;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphRemoveDependenciesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 405);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphRetainUserObjectBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graph,
	const uint64_t p__object,
	const uint32_t p__count,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 406);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graph` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graph` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graph;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_object` field */
		_ALIGN(ctx->at, 8);

		/* Write `_object` field */
		{
			const uint64_t tmp_val = (uint64_t) p__object;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphRetainUserObjectEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 407);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphUploadBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__graphExec,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 408);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_graphExec` field */
		_ALIGN(ctx->at, 8);

		/* Write `_graphExec` field */
		{
			const uint64_t tmp_val = (uint64_t) p__graphExec;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphUploadEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 409);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphicsGLRegisterBufferBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__resource,
	const uint64_t p__resource__val,
	const int32_t p__buffer,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 410);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_resource` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resource` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resource;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_resource__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resource__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resource__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_buffer` field */
		_ALIGN(ctx->at, 8);

		/* Write `_buffer` field */
		{
			const uint32_t tmp_val = (uint32_t) p__buffer;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphicsGLRegisterBufferEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 411);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphicsGLRegisterImageBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__resource,
	const uint64_t p__resource__val,
	const int32_t p__image,
	const int32_t p__target,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 412);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_resource` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resource` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resource;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_resource__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resource__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resource__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_image` field */
		_ALIGN(ctx->at, 8);

		/* Write `_image` field */
		{
			const uint32_t tmp_val = (uint32_t) p__image;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_target` field */
		_ALIGN(ctx->at, 8);

		/* Write `_target` field */
		{
			const uint32_t tmp_val = (uint32_t) p__target;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphicsGLRegisterImageEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 413);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphicsMapResourcesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__count,
	const uint64_t p__resources,
	const uint64_t p__resources__val,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 414);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_resources` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resources` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resources;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_resources__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resources__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resources__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphicsMapResourcesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 415);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphicsResourceGetMappedPointerBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__devPtr,
	const uint64_t p__devPtr__val,
	const uint64_t p__size,
	const uint64_t p__size__val,
	const uint64_t p__resource)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 416);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_devPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_resource` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resource` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resource;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphicsResourceGetMappedPointerEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 417);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphicsSubResourceGetMappedArrayBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__array,
	const uint64_t p__array__val,
	const uint64_t p__resource,
	const uint32_t p__arrayIndex,
	const uint32_t p__mipLevel)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 418);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_array__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_resource` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resource` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resource;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_arrayIndex` field */
		_ALIGN(ctx->at, 8);

		/* Write `_arrayIndex` field */
		{
			const uint32_t tmp_val = (uint32_t) p__arrayIndex;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mipLevel` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipLevel` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mipLevel;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipGraphicsSubResourceGetMappedArrayEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 419);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphicsUnmapResourcesBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const int32_t p__count,
	const uint64_t p__resources,
	const uint64_t p__resources__val,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 420);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_resources` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resources` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resources;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_resources__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resources__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resources__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphicsUnmapResourcesEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 421);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipGraphicsUnregisterResourceBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__resource)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 422);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_resource` field */
		_ALIGN(ctx->at, 8);

		/* Write `_resource` field */
		{
			const uint64_t tmp_val = (uint64_t) p__resource;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipGraphicsUnregisterResourceEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 423);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHccModuleLaunchKernelBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__f,
	const uint32_t p__globalWorkSizeX,
	const uint32_t p__globalWorkSizeY,
	const uint32_t p__globalWorkSizeZ,
	const uint32_t p__blockDimX,
	const uint32_t p__blockDimY,
	const uint32_t p__blockDimZ,
	const uint64_t p__sharedMemBytes,
	const uint64_t p__hStream,
	const uint64_t p__kernelParams,
	const uint64_t p__kernelParams__val,
	const uint64_t p__extra,
	const uint64_t p__extra__val,
	const uint64_t p__startEvent,
	const uint64_t p__stopEvent)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 424);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_f` field */
		{
			const uint64_t tmp_val = (uint64_t) p__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_globalWorkSizeX` field */
		_ALIGN(ctx->at, 8);

		/* Write `_globalWorkSizeX` field */
		{
			const uint32_t tmp_val = (uint32_t) p__globalWorkSizeX;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_globalWorkSizeY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_globalWorkSizeY` field */
		{
			const uint32_t tmp_val = (uint32_t) p__globalWorkSizeY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_globalWorkSizeZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_globalWorkSizeZ` field */
		{
			const uint32_t tmp_val = (uint32_t) p__globalWorkSizeZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDimX` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDimX` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDimX;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDimY` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDimY` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDimY;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDimZ` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDimZ` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDimZ;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMemBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hStream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hStream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hStream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kernelParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernelParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__kernelParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kernelParams__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernelParams__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__kernelParams__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extra` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extra` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extra;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extra__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extra__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extra__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_startEvent` field */
		_ALIGN(ctx->at, 8);

		/* Write `_startEvent` field */
		{
			const uint64_t tmp_val = (uint64_t) p__startEvent;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stopEvent` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stopEvent` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stopEvent;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipHccModuleLaunchKernelEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 425);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHostAllocBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__size,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 426);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipHostAllocEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 427);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHostFreeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 428);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipHostFreeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 429);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHostGetDevicePointerBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__devPtr,
	const uint64_t p__devPtr__val,
	const uint64_t p__hstPtr,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 430);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_devPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hstPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hstPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hstPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipHostGetDevicePointerEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 431);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHostGetFlagsBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__flagsPtr,
	const uint32_t p__flagsPtr__val,
	const uint64_t p__hostPtr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 432);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_flagsPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flagsPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flagsPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flagsPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flagsPtr__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flagsPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_hostPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hostPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hostPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipHostGetFlagsEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 433);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHostMallocBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__size,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 434);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipHostMallocEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 435);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHostRegisterBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hostPtr,
	const uint64_t p__sizeBytes,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 436);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hostPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hostPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hostPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sizeBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sizeBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sizeBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipHostRegisterEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 437);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipHostUnregisterBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hostPtr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 438);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hostPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hostPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hostPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipHostUnregisterEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 439);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipImportExternalMemoryBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__extMem_out,
	const uint64_t p__extMem_out__val,
	const uint64_t p__memHandleDesc,
	const int32_t p__memHandleDesc__val__type,
	const uint64_t p__memHandleDesc__val__size,
	const uint32_t p__memHandleDesc__val__flags,
	const uint64_t p__memHandleDesc__val__reserved)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 440);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_extMem_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extMem_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extMem_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extMem_out__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extMem_out__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extMem_out__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memHandleDesc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memHandleDesc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memHandleDesc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memHandleDesc__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memHandleDesc__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__memHandleDesc__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_memHandleDesc__val__size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memHandleDesc__val__size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memHandleDesc__val__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_memHandleDesc__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memHandleDesc__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__memHandleDesc__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_memHandleDesc__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_memHandleDesc__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__memHandleDesc__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipImportExternalMemoryEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 441);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipImportExternalSemaphoreBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__extSem_out,
	const uint64_t p__extSem_out__val,
	const uint64_t p__semHandleDesc,
	const int32_t p__semHandleDesc__val__type,
	const uint32_t p__semHandleDesc__val__flags,
	const uint64_t p__semHandleDesc__val__reserved)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 442);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_extSem_out` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extSem_out` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extSem_out;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extSem_out__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extSem_out__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extSem_out__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_semHandleDesc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_semHandleDesc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__semHandleDesc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_semHandleDesc__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_semHandleDesc__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__semHandleDesc__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_semHandleDesc__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_semHandleDesc__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__semHandleDesc__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_semHandleDesc__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_semHandleDesc__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__semHandleDesc__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipImportExternalSemaphoreEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 443);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipInitBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 444);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipInitEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 445);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipIpcCloseMemHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__devPtr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 446);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipIpcCloseMemHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 447);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipIpcGetEventHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__handle,
	const uint64_t p__handle__val__reserved,
	const uint64_t p__event)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 448);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipIpcGetEventHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 449);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipIpcGetMemHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__handle,
	const uint64_t p__handle__val__reserved,
	const uint64_t p__devPtr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 450);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipIpcGetMemHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 451);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipIpcOpenEventHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__event,
	const uint64_t p__event__val,
	const uint64_t p__handle__reserved)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 452);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_event` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_event__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_event__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__event__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipIpcOpenEventHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 453);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipIpcOpenMemHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__devPtr,
	const uint64_t p__devPtr__val,
	const uint64_t p__handle__reserved,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 454);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_devPtr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipIpcOpenMemHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 455);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLaunchByPtrBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__hostFunction)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 456);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_hostFunction` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hostFunction` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hostFunction;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLaunchByPtrEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 457);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLaunchCooperativeKernelBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__f,
	const uint32_t p__gridDim__x,
	const uint32_t p__gridDim__y,
	const uint32_t p__gridDim__z,
	const uint32_t p__blockDimX__x,
	const uint32_t p__blockDimX__y,
	const uint32_t p__blockDimX__z,
	const uint64_t p__kernelParams,
	const uint64_t p__kernelParams__val,
	const uint32_t p__sharedMemBytes,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 458);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_f` field */
		{
			const uint64_t tmp_val = (uint64_t) p__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDimX__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDimX__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDimX__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDimX__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDimX__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDimX__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_blockDimX__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_blockDimX__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__blockDimX__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_kernelParams` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernelParams` field */
		{
			const uint64_t tmp_val = (uint64_t) p__kernelParams;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_kernelParams__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_kernelParams__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__kernelParams__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMemBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLaunchCooperativeKernelEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 459);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLaunchCooperativeKernelMultiDeviceBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__launchParamsList,
	const uint64_t p__launchParamsList__val__func,
	const uint32_t p__launchParamsList__val__gridDim__x,
	const uint32_t p__launchParamsList__val__gridDim__y,
	const uint32_t p__launchParamsList__val__gridDim__z,
	const uint32_t p__launchParamsList__val__blockDim__x,
	const uint32_t p__launchParamsList__val__blockDim__y,
	const uint32_t p__launchParamsList__val__blockDim__z,
	const uint64_t p__launchParamsList__val__args,
	const uint64_t p__launchParamsList__val__sharedMem,
	const uint64_t p__launchParamsList__val__stream,
	const int32_t p__numDevices,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 460);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_launchParamsList` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__func` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__func` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__func;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__launchParamsList__val__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_launchParamsList__val__args` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__args` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__args;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__sharedMem` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__sharedMem` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__sharedMem;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_launchParamsList__val__stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_launchParamsList__val__stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__launchParamsList__val__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numDevices` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numDevices` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numDevices;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipLaunchCooperativeKernelMultiDeviceEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 461);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLaunchHostFuncBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__stream,
	const uint64_t p__fn,
	const uint64_t p__userData)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 462);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_fn` field */
		_ALIGN(ctx->at, 8);

		/* Write `_fn` field */
		{
			const uint64_t tmp_val = (uint64_t) p__fn;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_userData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_userData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__userData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLaunchHostFuncEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 463);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLaunchKernelBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__function_address,
	const uint32_t p__numBlocks__x,
	const uint32_t p__numBlocks__y,
	const uint32_t p__numBlocks__z,
	const uint32_t p__dimBlocks__x,
	const uint32_t p__dimBlocks__y,
	const uint32_t p__dimBlocks__z,
	const uint64_t p__args,
	const uint64_t p__args__val,
	const uint64_t p__sharedMemBytes,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 464);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_function_address` field */
		_ALIGN(ctx->at, 8);

		/* Write `_function_address` field */
		{
			const uint64_t tmp_val = (uint64_t) p__function_address;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numBlocks__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numBlocks__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numBlocks__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_numBlocks__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numBlocks__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numBlocks__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_numBlocks__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numBlocks__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numBlocks__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_dimBlocks__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dimBlocks__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dimBlocks__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_dimBlocks__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dimBlocks__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dimBlocks__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_dimBlocks__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dimBlocks__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__dimBlocks__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_args` field */
		_ALIGN(ctx->at, 8);

		/* Write `_args` field */
		{
			const uint64_t tmp_val = (uint64_t) p__args;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_args__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_args__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__args__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sharedMemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sharedMemBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sharedMemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLaunchKernelEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 465);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLaunchKernelExCBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__config,
	const uint32_t p__config__val__gridDim__x,
	const uint32_t p__config__val__gridDim__y,
	const uint32_t p__config__val__gridDim__z,
	const uint32_t p__config__val__blockDim__x,
	const uint32_t p__config__val__blockDim__y,
	const uint32_t p__config__val__blockDim__z,
	const uint64_t p__config__val__dynamicSmemBytes,
	const uint64_t p__config__val__stream,
	const uint64_t p__config__val__attrs,
	const uint32_t p__config__val__numAttrs,
	const uint64_t p__fPtr,
	const uint64_t p__args,
	const uint64_t p__args__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 466);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_config` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config` field */
		{
			const uint64_t tmp_val = (uint64_t) p__config;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config__val__gridDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__gridDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__gridDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__gridDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__gridDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__gridDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__gridDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__gridDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__gridDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__blockDim__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__blockDim__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__blockDim__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__blockDim__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__blockDim__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__blockDim__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__blockDim__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__blockDim__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__blockDim__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_config__val__dynamicSmemBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__dynamicSmemBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__config__val__dynamicSmemBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config__val__stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__config__val__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config__val__attrs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__attrs` field */
		{
			const uint64_t tmp_val = (uint64_t) p__config__val__attrs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_config__val__numAttrs` field */
		_ALIGN(ctx->at, 8);

		/* Write `_config__val__numAttrs` field */
		{
			const uint32_t tmp_val = (uint32_t) p__config__val__numAttrs;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_fPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_fPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__fPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_args` field */
		_ALIGN(ctx->at, 8);

		/* Write `_args` field */
		{
			const uint64_t tmp_val = (uint64_t) p__args;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_args__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_args__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__args__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLaunchKernelExCEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 467);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLibraryGetKernelBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pKernel,
	const uint64_t p__pKernel__val,
	const uint64_t p__library,
	const char * const p__name,
	const int8_t p__name__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 468);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pKernel` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pKernel` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pKernel;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pKernel__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pKernel__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pKernel__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_library` field */
		_ALIGN(ctx->at, 8);

		/* Write `_library` field */
		{
			const uint64_t tmp_val = (uint64_t) p__library;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_name` field */
		_write_c_str(ctx, p__name);

		/* Align for `_name__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_name__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__name__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}
	}
}

static void _serialize_er_hip_api_hipLibraryGetKernelCountBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__count,
	const uint32_t p__count__val,
	const uint64_t p__library)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 469);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__count__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_library` field */
		_ALIGN(ctx->at, 8);

		/* Write `_library` field */
		{
			const uint64_t tmp_val = (uint64_t) p__library;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLibraryGetKernelCountEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 470);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLibraryGetKernelEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 471);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLibraryLoadDataBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__library,
	const uint64_t p__library__val,
	const uint64_t p__code,
	const uint64_t p__jitOptions,
	const int32_t p__jitOptions__val,
	const uint64_t p__jitOptionsValues,
	const uint64_t p__jitOptionsValues__val,
	const uint32_t p__numJitOptions,
	const uint64_t p__libraryOptions,
	const int32_t p__libraryOptions__val,
	const uint64_t p__libraryOptionValues,
	const uint64_t p__libraryOptionValues__val,
	const uint32_t p__numLibraryOptions)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 472);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_library` field */
		_ALIGN(ctx->at, 8);

		/* Write `_library` field */
		{
			const uint64_t tmp_val = (uint64_t) p__library;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_library__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_library__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__library__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_code` field */
		_ALIGN(ctx->at, 8);

		/* Write `_code` field */
		{
			const uint64_t tmp_val = (uint64_t) p__code;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_jitOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptions` field */
		{
			const uint64_t tmp_val = (uint64_t) p__jitOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_jitOptions__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptions__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__jitOptions__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_jitOptionsValues` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptionsValues` field */
		{
			const uint64_t tmp_val = (uint64_t) p__jitOptionsValues;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_jitOptionsValues__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptionsValues__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__jitOptionsValues__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numJitOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numJitOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numJitOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_libraryOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptions` field */
		{
			const uint64_t tmp_val = (uint64_t) p__libraryOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_libraryOptions__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptions__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__libraryOptions__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_libraryOptionValues` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptionValues` field */
		{
			const uint64_t tmp_val = (uint64_t) p__libraryOptionValues;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_libraryOptionValues__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptionValues__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__libraryOptionValues__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numLibraryOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numLibraryOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numLibraryOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipLibraryLoadDataEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 473);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLibraryLoadFromFileBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__library,
	const uint64_t p__library__val,
	const char * const p__fileName,
	const int8_t p__fileName__val,
	const uint64_t p__jitOptions,
	const int32_t p__jitOptions__val,
	const uint64_t p__jitOptionsValues,
	const uint64_t p__jitOptionsValues__val,
	const uint32_t p__numJitOptions,
	const uint64_t p__libraryOptions,
	const int32_t p__libraryOptions__val,
	const uint64_t p__libraryOptionValues,
	const uint64_t p__libraryOptionValues__val,
	const uint32_t p__numLibraryOptions)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 474);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_library` field */
		_ALIGN(ctx->at, 8);

		/* Write `_library` field */
		{
			const uint64_t tmp_val = (uint64_t) p__library;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_library__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_library__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__library__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_fileName` field */
		_ALIGN(ctx->at, 8);

		/* Write `_fileName` field */
		_write_c_str(ctx, p__fileName);

		/* Align for `_fileName__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_fileName__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__fileName__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_jitOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptions` field */
		{
			const uint64_t tmp_val = (uint64_t) p__jitOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_jitOptions__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptions__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__jitOptions__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_jitOptionsValues` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptionsValues` field */
		{
			const uint64_t tmp_val = (uint64_t) p__jitOptionsValues;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_jitOptionsValues__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_jitOptionsValues__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__jitOptionsValues__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numJitOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numJitOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numJitOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_libraryOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptions` field */
		{
			const uint64_t tmp_val = (uint64_t) p__libraryOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_libraryOptions__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptions__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__libraryOptions__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_libraryOptionValues` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptionValues` field */
		{
			const uint64_t tmp_val = (uint64_t) p__libraryOptionValues;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_libraryOptionValues__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_libraryOptionValues__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__libraryOptionValues__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numLibraryOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numLibraryOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numLibraryOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipLibraryLoadFromFileEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 475);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLibraryUnloadBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__library)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 476);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_library` field */
		_ALIGN(ctx->at, 8);

		/* Write `_library` field */
		{
			const uint64_t tmp_val = (uint64_t) p__library;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLibraryUnloadEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 477);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLinkAddDataBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__state,
	const int32_t p__type,
	const uint64_t p__data,
	const uint64_t p__size,
	const char * const p__name,
	const int8_t p__name__val,
	const uint32_t p__numOptions,
	const uint64_t p__options,
	const int32_t p__options__val,
	const uint64_t p__optionValues,
	const uint64_t p__optionValues__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 478);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_state` field */
		_ALIGN(ctx->at, 8);

		/* Write `_state` field */
		{
			const uint64_t tmp_val = (uint64_t) p__state;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_data` field */
		_ALIGN(ctx->at, 8);

		/* Write `_data` field */
		{
			const uint64_t tmp_val = (uint64_t) p__data;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_name` field */
		_ALIGN(ctx->at, 8);

		/* Write `_name` field */
		_write_c_str(ctx, p__name);

		/* Align for `_name__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_name__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__name__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_numOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_options` field */
		_ALIGN(ctx->at, 8);

		/* Write `_options` field */
		{
			const uint64_t tmp_val = (uint64_t) p__options;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_options__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_options__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__options__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_optionValues` field */
		_ALIGN(ctx->at, 8);

		/* Write `_optionValues` field */
		{
			const uint64_t tmp_val = (uint64_t) p__optionValues;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_optionValues__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_optionValues__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__optionValues__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLinkAddDataEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 479);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLinkAddFileBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__state,
	const int32_t p__type,
	const char * const p__path,
	const int8_t p__path__val,
	const uint32_t p__numOptions,
	const uint64_t p__options,
	const int32_t p__options__val,
	const uint64_t p__optionValues,
	const uint64_t p__optionValues__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 480);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_state` field */
		_ALIGN(ctx->at, 8);

		/* Write `_state` field */
		{
			const uint64_t tmp_val = (uint64_t) p__state;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_path` field */
		_ALIGN(ctx->at, 8);

		/* Write `_path` field */
		_write_c_str(ctx, p__path);

		/* Align for `_path__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_path__val` field */
		{
			const uint8_t tmp_val = (uint8_t) p__path__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 8;
		}

		/* Align for `_numOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_options` field */
		_ALIGN(ctx->at, 8);

		/* Write `_options` field */
		{
			const uint64_t tmp_val = (uint64_t) p__options;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_options__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_options__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__options__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_optionValues` field */
		_ALIGN(ctx->at, 8);

		/* Write `_optionValues` field */
		{
			const uint64_t tmp_val = (uint64_t) p__optionValues;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_optionValues__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_optionValues__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__optionValues__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLinkAddFileEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 481);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLinkCompleteBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__state,
	const uint64_t p__hipBinOut,
	const uint64_t p__hipBinOut__val,
	const uint64_t p__sizeOut,
	const uint64_t p__sizeOut__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 482);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_state` field */
		_ALIGN(ctx->at, 8);

		/* Write `_state` field */
		{
			const uint64_t tmp_val = (uint64_t) p__state;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hipBinOut` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hipBinOut` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hipBinOut;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_hipBinOut__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_hipBinOut__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__hipBinOut__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sizeOut` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sizeOut` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sizeOut;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_sizeOut__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_sizeOut__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__sizeOut__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLinkCompleteEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 483);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLinkCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint32_t p__numOptions,
	const uint64_t p__options,
	const int32_t p__options__val,
	const uint64_t p__optionValues,
	const uint64_t p__optionValues__val,
	const uint64_t p__stateOut,
	const uint64_t p__stateOut__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 484);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_numOptions` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numOptions` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numOptions;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_options` field */
		_ALIGN(ctx->at, 8);

		/* Write `_options` field */
		{
			const uint64_t tmp_val = (uint64_t) p__options;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_options__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_options__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__options__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_optionValues` field */
		_ALIGN(ctx->at, 8);

		/* Write `_optionValues` field */
		{
			const uint64_t tmp_val = (uint64_t) p__optionValues;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_optionValues__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_optionValues__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__optionValues__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stateOut` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stateOut` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stateOut;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stateOut__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stateOut__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stateOut__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLinkCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 485);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipLinkDestroyBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__state)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 486);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_state` field */
		_ALIGN(ctx->at, 8);

		/* Write `_state` field */
		{
			const uint64_t tmp_val = (uint64_t) p__state;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipLinkDestroyEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 487);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMalloc3DArrayBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__array,
	const uint64_t p__array__val,
	const uint64_t p__desc,
	const int32_t p__desc__val__x,
	const int32_t p__desc__val__y,
	const int32_t p__desc__val__z,
	const int32_t p__desc__val__w,
	const int32_t p__desc__val__f,
	const uint64_t p__extent__width,
	const uint64_t p__extent__height,
	const uint64_t p__extent__depth,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 488);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_array__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__desc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc__val__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__w` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__w` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__w;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__f` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMalloc3DArrayEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 489);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMalloc3DBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pitchedDevPtr,
	const uint64_t p__pitchedDevPtr__val__ptr,
	const uint64_t p__pitchedDevPtr__val__pitch,
	const uint64_t p__pitchedDevPtr__val__xsize,
	const uint64_t p__pitchedDevPtr__val__ysize,
	const uint64_t p__extent__width,
	const uint64_t p__extent__height,
	const uint64_t p__extent__depth)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 490);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pitchedDevPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitchedDevPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitchedDevPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitchedDevPtr__val__ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitchedDevPtr__val__ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitchedDevPtr__val__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitchedDevPtr__val__pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitchedDevPtr__val__pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitchedDevPtr__val__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitchedDevPtr__val__xsize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitchedDevPtr__val__xsize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitchedDevPtr__val__xsize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitchedDevPtr__val__ysize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitchedDevPtr__val__ysize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitchedDevPtr__val__ysize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMalloc3DEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 491);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocArrayBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__array,
	const uint64_t p__array__val,
	const uint64_t p__desc,
	const int32_t p__desc__val__x,
	const int32_t p__desc__val__y,
	const int32_t p__desc__val__z,
	const int32_t p__desc__val__w,
	const int32_t p__desc__val__f,
	const uint64_t p__width,
	const uint64_t p__height,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 492);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_array` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_array__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_array__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__array__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__desc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc__val__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__w` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__w` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__w;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__f` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMallocArrayEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 493);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocAsyncBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dev_ptr,
	const uint64_t p__dev_ptr__val,
	const uint64_t p__size,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 494);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMallocAsyncEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 495);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__size)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 496);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMallocEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 497);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocFromPoolAsyncBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dev_ptr,
	const uint64_t p__dev_ptr__val,
	const uint64_t p__size,
	const uint64_t p__mem_pool,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 498);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMallocFromPoolAsyncEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 499);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocHostBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__size)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 500);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMallocHostEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 501);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocManagedBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dev_ptr,
	const uint64_t p__dev_ptr__val,
	const uint64_t p__size,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 502);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMallocManagedEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 503);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocMipmappedArrayBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mipmappedArray,
	const uint64_t p__mipmappedArray__val,
	const uint64_t p__desc,
	const int32_t p__desc__val__x,
	const int32_t p__desc__val__y,
	const int32_t p__desc__val__z,
	const int32_t p__desc__val__w,
	const int32_t p__desc__val__f,
	const uint64_t p__extent__width,
	const uint64_t p__extent__height,
	const uint64_t p__extent__depth,
	const uint32_t p__numLevels,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 504);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mipmappedArray` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmappedArray` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmappedArray;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mipmappedArray__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mipmappedArray__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mipmappedArray__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc` field */
		{
			const uint64_t tmp_val = (uint64_t) p__desc;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_desc__val__x` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__x` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__x;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__y` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__y` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__y;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__z` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__z` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__z;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__w` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__w` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__w;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_desc__val__f` field */
		_ALIGN(ctx->at, 8);

		/* Write `_desc__val__f` field */
		{
			const uint32_t tmp_val = (uint32_t) p__desc__val__f;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_extent__width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_extent__depth` field */
		_ALIGN(ctx->at, 8);

		/* Write `_extent__depth` field */
		{
			const uint64_t tmp_val = (uint64_t) p__extent__depth;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_numLevels` field */
		_ALIGN(ctx->at, 8);

		/* Write `_numLevels` field */
		{
			const uint32_t tmp_val = (uint32_t) p__numLevels;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMallocMipmappedArrayEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 505);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMallocPitchBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__pitch,
	const uint64_t p__pitch__val,
	const uint64_t p__width,
	const uint64_t p__height)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 506);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitch__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitch__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitch__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_width` field */
		_ALIGN(ctx->at, 8);

		/* Write `_width` field */
		{
			const uint64_t tmp_val = (uint64_t) p__width;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMallocPitchEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 507);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemAddressFreeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__devPtr,
	const uint64_t p__size)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 508);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_devPtr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_devPtr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__devPtr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemAddressFreeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 509);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemAddressReserveBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__size,
	const uint64_t p__alignment,
	const uint64_t p__addr,
	const uint64_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 510);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_alignment` field */
		_ALIGN(ctx->at, 8);

		/* Write `_alignment` field */
		{
			const uint64_t tmp_val = (uint64_t) p__alignment;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_addr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_addr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__addr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemAddressReserveEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 511);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemAdviseBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dev_ptr,
	const uint64_t p__count,
	const int32_t p__advice,
	const int32_t p__device)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 512);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_advice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_advice` field */
		{
			const uint32_t tmp_val = (uint32_t) p__advice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_device` field */
		_ALIGN(ctx->at, 8);

		/* Write `_device` field */
		{
			const uint32_t tmp_val = (uint32_t) p__device;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemAdviseEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 513);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemAdvise_v2Begin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dev_ptr,
	const uint64_t p__count,
	const int32_t p__advice,
	const int32_t p__location__type,
	const int32_t p__location__id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 514);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint64_t tmp_val = (uint64_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_advice` field */
		_ALIGN(ctx->at, 8);

		/* Write `_advice` field */
		{
			const uint32_t tmp_val = (uint32_t) p__advice;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_location__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__location__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_location__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__location__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemAdvise_v2End(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 515);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemAllocHostBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__ptr__val,
	const uint64_t p__size)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 516);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemAllocHostEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 517);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemAllocPitchBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dptr,
	const uint64_t p__dptr__val,
	const uint64_t p__pitch,
	const uint64_t p__pitch__val,
	const uint64_t p__widthInBytes,
	const uint64_t p__height,
	const uint32_t p__elementSizeBytes)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 518);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitch` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitch` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitch;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pitch__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pitch__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pitch__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_widthInBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_widthInBytes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__widthInBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_height` field */
		_ALIGN(ctx->at, 8);

		/* Write `_height` field */
		{
			const uint64_t tmp_val = (uint64_t) p__height;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_elementSizeBytes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_elementSizeBytes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__elementSizeBytes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemAllocPitchEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 519);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__handle,
	const uint64_t p__handle__val,
	const uint64_t p__size,
	const uint64_t p__prop,
	const int32_t p__prop__val__type,
	const int32_t p__prop__val__location__type,
	const int32_t p__prop__val__location__id,
	const uint64_t p__prop__val__win32HandleMetaData,
	const uint64_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 520);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__location__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__location__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__location__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__location__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__location__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__location__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__win32HandleMetaData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__win32HandleMetaData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__win32HandleMetaData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 521);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemExportToShareableHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__shareableHandle,
	const uint64_t p__handle,
	const int32_t p__handleType,
	const uint64_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 522);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_shareableHandle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_shareableHandle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__shareableHandle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handleType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handleType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__handleType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemExportToShareableHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 523);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemGetAccessBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__flags,
	const uint64_t p__flags__val,
	const uint64_t p__location,
	const int32_t p__location__val__type,
	const int32_t p__location__val__id,
	const uint64_t p__ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 524);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_location` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location` field */
		{
			const uint64_t tmp_val = (uint64_t) p__location;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_location__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__location__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_location__val__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location__val__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__location__val__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemGetAccessEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 525);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemGetAddressRangeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__pbase,
	const uint64_t p__pbase__val,
	const uint64_t p__psize,
	const uint64_t p__psize__val,
	const uint64_t p__dptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 526);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_pbase` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pbase` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pbase;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pbase__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pbase__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pbase__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_psize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_psize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__psize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_psize__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_psize__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__psize__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemGetAddressRangeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 527);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemGetAllocationGranularityBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__granularity,
	const uint64_t p__granularity__val,
	const uint64_t p__prop,
	const int32_t p__prop__val__type,
	const int32_t p__prop__val__location__type,
	const int32_t p__prop__val__location__id,
	const uint64_t p__prop__val__win32HandleMetaData,
	const int32_t p__option)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 528);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_granularity` field */
		_ALIGN(ctx->at, 8);

		/* Write `_granularity` field */
		{
			const uint64_t tmp_val = (uint64_t) p__granularity;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_granularity__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_granularity__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__granularity__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__location__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__location__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__location__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__location__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__location__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__location__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__win32HandleMetaData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__win32HandleMetaData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__win32HandleMetaData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_option` field */
		_ALIGN(ctx->at, 8);

		/* Write `_option` field */
		{
			const uint32_t tmp_val = (uint32_t) p__option;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemGetAllocationGranularityEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 529);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemGetAllocationPropertiesFromHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__prop,
	const int32_t p__prop__val__type,
	const int32_t p__prop__val__location__type,
	const int32_t p__prop__val__location__id,
	const uint64_t p__prop__val__win32HandleMetaData,
	const uint64_t p__handle)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 530);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_prop` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_prop__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__location__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__location__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__location__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__location__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__location__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__prop__val__location__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_prop__val__win32HandleMetaData` field */
		_ALIGN(ctx->at, 8);

		/* Write `_prop__val__win32HandleMetaData` field */
		{
			const uint64_t tmp_val = (uint64_t) p__prop__val__win32HandleMetaData;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemGetAllocationPropertiesFromHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 531);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemGetHandleForAddressRangeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__handle,
	const uint64_t p__dptr,
	const uint64_t p__size,
	const int32_t p__handleType,
	const uint64_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 532);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handleType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handleType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__handleType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemGetHandleForAddressRangeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 533);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemGetInfoBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__free,
	const uint64_t p__free__val,
	const uint64_t p__total,
	const uint64_t p__total__val)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 534);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_free` field */
		_ALIGN(ctx->at, 8);

		/* Write `_free` field */
		{
			const uint64_t tmp_val = (uint64_t) p__free;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_free__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_free__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__free__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_total` field */
		_ALIGN(ctx->at, 8);

		/* Write `_total` field */
		{
			const uint64_t tmp_val = (uint64_t) p__total;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_total__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_total__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__total__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemGetInfoEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 535);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemImportFromShareableHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__handle,
	const uint64_t p__handle__val,
	const uint64_t p__osHandle,
	const int32_t p__shHandleType)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 536);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_osHandle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_osHandle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__osHandle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_shHandleType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_shHandleType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__shHandleType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemImportFromShareableHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 537);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemMapArrayAsyncBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mapInfoList,
	const int32_t p__mapInfoList__val__resourceType,
	const int32_t p__mapInfoList__val__subresourceType,
	const int32_t p__mapInfoList__val__memOperationType,
	const int32_t p__mapInfoList__val__memHandleType,
	const uint64_t p__mapInfoList__val__offset,
	const uint32_t p__mapInfoList__val__deviceBitMask,
	const uint32_t p__mapInfoList__val__flags,
	const uint64_t p__mapInfoList__val__reserved,
	const uint32_t p__count,
	const uint64_t p__stream)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 538);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mapInfoList` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mapInfoList;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mapInfoList__val__resourceType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__resourceType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mapInfoList__val__resourceType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mapInfoList__val__subresourceType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__subresourceType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mapInfoList__val__subresourceType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mapInfoList__val__memOperationType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__memOperationType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mapInfoList__val__memOperationType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mapInfoList__val__memHandleType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__memHandleType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mapInfoList__val__memHandleType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mapInfoList__val__offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mapInfoList__val__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mapInfoList__val__deviceBitMask` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__deviceBitMask` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mapInfoList__val__deviceBitMask;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mapInfoList__val__flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__mapInfoList__val__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mapInfoList__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mapInfoList__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mapInfoList__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_count` field */
		_ALIGN(ctx->at, 8);

		/* Write `_count` field */
		{
			const uint32_t tmp_val = (uint32_t) p__count;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_stream` field */
		_ALIGN(ctx->at, 8);

		/* Write `_stream` field */
		{
			const uint64_t tmp_val = (uint64_t) p__stream;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemMapArrayAsyncEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 539);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemMapBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__ptr,
	const uint64_t p__size,
	const uint64_t p__offset,
	const uint64_t p__handle,
	const uint64_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 540);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_size` field */
		_ALIGN(ctx->at, 8);

		/* Write `_size` field */
		{
			const uint64_t tmp_val = (uint64_t) p__size;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_offset` field */
		_ALIGN(ctx->at, 8);

		/* Write `_offset` field */
		{
			const uint64_t tmp_val = (uint64_t) p__offset;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemMapEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 541);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolCreateBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mem_pool,
	const uint64_t p__mem_pool__val,
	const uint64_t p__pool_props,
	const int32_t p__pool_props__val__allocType,
	const int32_t p__pool_props__val__handleTypes,
	const int32_t p__pool_props__val__location__type,
	const int32_t p__pool_props__val__location__id,
	const uint64_t p__pool_props__val__win32SecurityAttributes,
	const uint64_t p__pool_props__val__maxSize,
	const uint64_t p__pool_props__val__reserved)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 542);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mem_pool__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pool_props` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pool_props;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pool_props__val__allocType` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props__val__allocType` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pool_props__val__allocType;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pool_props__val__handleTypes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props__val__handleTypes` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pool_props__val__handleTypes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pool_props__val__location__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props__val__location__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pool_props__val__location__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pool_props__val__location__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props__val__location__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__pool_props__val__location__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_pool_props__val__win32SecurityAttributes` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props__val__win32SecurityAttributes` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pool_props__val__win32SecurityAttributes;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pool_props__val__maxSize` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props__val__maxSize` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pool_props__val__maxSize;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_pool_props__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_pool_props__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__pool_props__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemPoolCreateEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 543);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolDestroyBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mem_pool)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 544);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemPoolDestroyEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 545);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolExportPointerBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__export_data,
	const uint64_t p__export_data__val__reserved,
	const uint64_t p__dev_ptr)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 546);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_export_data` field */
		_ALIGN(ctx->at, 8);

		/* Write `_export_data` field */
		{
			const uint64_t tmp_val = (uint64_t) p__export_data;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_export_data__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_export_data__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__export_data__val__reserved;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemPoolExportPointerEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 547);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolExportToShareableHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__shared_handle,
	const uint64_t p__mem_pool,
	const int32_t p__handle_type,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 548);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_shared_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_shared_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__shared_handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle_type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle_type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__handle_type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemPoolExportToShareableHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 549);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolGetAccessBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__flags,
	const int32_t p__flags__val,
	const uint64_t p__mem_pool,
	const uint64_t p__location,
	const int32_t p__location__val__type,
	const int32_t p__location__val__id)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 550);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint64_t tmp_val = (uint64_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_flags__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags__val` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_location` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location` field */
		{
			const uint64_t tmp_val = (uint64_t) p__location;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_location__val__type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location__val__type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__location__val__type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_location__val__id` field */
		_ALIGN(ctx->at, 8);

		/* Write `_location__val__id` field */
		{
			const uint32_t tmp_val = (uint32_t) p__location__val__id;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemPoolGetAccessEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 551);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolGetAttributeBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mem_pool,
	const int32_t p__attr,
	const uint64_t p__value)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 552);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_attr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_attr` field */
		{
			const uint32_t tmp_val = (uint32_t) p__attr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_value` field */
		_ALIGN(ctx->at, 8);

		/* Write `_value` field */
		{
			const uint64_t tmp_val = (uint64_t) p__value;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}
	}
}

static void _serialize_er_hip_api_hipMemPoolGetAttributeEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 553);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolImportFromShareableHandleBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__mem_pool,
	const uint64_t p__mem_pool__val,
	const uint64_t p__shared_handle,
	const int32_t p__handle_type,
	const uint32_t p__flags)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 554);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mem_pool__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_shared_handle` field */
		_ALIGN(ctx->at, 8);

		/* Write `_shared_handle` field */
		{
			const uint64_t tmp_val = (uint64_t) p__shared_handle;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_handle_type` field */
		_ALIGN(ctx->at, 8);

		/* Write `_handle_type` field */
		{
			const uint32_t tmp_val = (uint32_t) p__handle_type;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}

		/* Align for `_flags` field */
		_ALIGN(ctx->at, 8);

		/* Write `_flags` field */
		{
			const uint32_t tmp_val = (uint32_t) p__flags;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 32;
		}
	}
}

static void _serialize_er_hip_api_hipMemPoolImportFromShareableHandleEnd(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 555);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
	}
}

static void _serialize_er_hip_api_hipMemPoolImportPointerBegin(void * const vctx,
	const uint32_t cc__thread_id,
	const uint32_t cc__queue_id,
	const uint32_t cc__agent_id,
	const uint64_t cc__correlation_id,
	const char * const cc__kernel_name,
	const uint64_t p__dev_ptr,
	const uint64_t p__dev_ptr__val,
	const uint64_t p__mem_pool,
	const uint64_t p__export_data,
	const uint64_t p__export_data__val__reserved)
{
	struct barectf_ctx * const ctx = _FROM_VOID_PTR(struct barectf_ctx, vctx);

	/* Serialize header */
	_serialize_er_header_hip_api(ctx, 556);

	/* Serialize common context */
	_serialize_er_common_ctx_hip_api(ctx, cc__thread_id, cc__queue_id, cc__agent_id, cc__correlation_id, cc__kernel_name);

	/* Write payload structure */
	{
		/* Align for payload structure */
		_ALIGN(ctx->at, 8);

		/* Align for `_dev_ptr` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_dev_ptr__val` field */
		_ALIGN(ctx->at, 8);

		/* Write `_dev_ptr__val` field */
		{
			const uint64_t tmp_val = (uint64_t) p__dev_ptr__val;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_mem_pool` field */
		_ALIGN(ctx->at, 8);

		/* Write `_mem_pool` field */
		{
			const uint64_t tmp_val = (uint64_t) p__mem_pool;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_export_data` field */
		_ALIGN(ctx->at, 8);

		/* Write `_export_data` field */
		{
			const uint64_t tmp_val = (uint64_t) p__export_data;

			memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], &tmp_val, sizeof(tmp_val));
			ctx->at += 64;
		}

		/* Align for `_export_data__val__reserved` field */
		_ALIGN(ctx->at, 8);

		/* Write `_export_data__val__reserved` field */
		{
			const uint64_t tmp_val = (uint64_t) p__export_data__val__reserved