/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef THIRD_PARTY_PERFETTO_SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_ANDROID_TRACK_EVENT_DESCRIPTOR_H_
#define THIRD_PARTY_PERFETTO_SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_ANDROID_TRACK_EVENT_DESCRIPTOR_H_

#include <stddef.h>
#include <stdint.h>
#include <array>

namespace perfetto {

inline constexpr std::array<uint8_t, 373> kAndroidTrackEventDescriptor{
    {0x0a, 0xf2, 0x02, 0x0a, 0x37, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f,
     0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2f, 0x74, 0x72, 0x61,
     0x63, 0x65, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x61,
     0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b,
     0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
     0x12, 0x0f, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e, 0x70,
     0x72, 0x6f, 0x74, 0x6f, 0x73, 0x1a, 0x33, 0x70, 0x72, 0x6f, 0x74, 0x6f,
     0x73, 0x2f, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2f, 0x74,
     0x72, 0x61, 0x63, 0x65, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x65,
     0x76, 0x65, 0x6e, 0x74, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x65,
     0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee,
     0x01, 0x0a, 0x11, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x54, 0x72,
     0x61, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x32, 0x4c, 0x0a, 0x13,
     0x62, 0x69, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
     0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x2e, 0x70, 0x65,
     0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
     0x73, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74,
     0x18, 0xd1, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x62, 0x69, 0x6e,
     0x64, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
     0x6d, 0x65, 0x32, 0x50, 0x0a, 0x15, 0x62, 0x69, 0x6e, 0x64, 0x65, 0x72,
     0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x6e,
     0x61, 0x6d, 0x65, 0x12, 0x1b, 0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74,
     0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x54, 0x72,
     0x61, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0xd2, 0x0f, 0x20,
     0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x69, 0x6e, 0x64, 0x65, 0x72, 0x49,
     0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
     0x32, 0x39, 0x0a, 0x09, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x6e, 0x61, 0x6d,
     0x65, 0x12, 0x1b, 0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f,
     0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x63,
     0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0xd3, 0x0f, 0x20, 0x01, 0x28,
     0x09, 0x52, 0x08, 0x61, 0x70, 0x65, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x50,
     0x00}};

}  // namespace perfetto

#endif  // THIRD_PARTY_PERFETTO_SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_ANDROID_TRACK_EVENT_DESCRIPTOR_H_
