// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class LocalResourceSourceDataView;

class LocalResourceLoaderConfigDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::LocalResourceSourceDataView> {
  using Data = ::blink::mojom::internal::LocalResourceSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LocalResourceLoaderConfigDataView> {
  using Data = ::blink::mojom::internal::LocalResourceLoaderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class LocalResourceSourceDataView {
 public:
  LocalResourceSourceDataView() = default;

  LocalResourceSourceDataView(
      internal::LocalResourceSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool should_replace_i18n_in_js() const {
    return data_->should_replace_i18n_in_js;
  }
  inline void GetPathToResourceIdMapDataView(
      mojo::MapDataView<mojo::StringDataView, int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPathToResourceIdMap(UserType* output) {
    
    auto* pointer = data_->path_to_resource_id_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, int32_t>>(
        pointer, output, message_);
  }
  inline void GetReplacementStringsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacementStrings(UserType* output) {
    
    auto* pointer = data_->replacement_strings.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LocalResourceSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LocalResourceLoaderConfigDataView {
 public:
  LocalResourceLoaderConfigDataView() = default;

  LocalResourceLoaderConfigDataView(
      internal::LocalResourceLoaderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, LocalResourceSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::LocalResourceSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LocalResourceLoaderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LocalResourceSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LocalResourceSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LocalResourceSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_headers, headers_fragment);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in LocalResourceSource struct");
    fragment->should_replace_i18n_in_js = Traits::should_replace_i18n_in_js(input);
    decltype(Traits::path_to_resource_id_map(input)) in_path_to_resource_id_map = Traits::path_to_resource_id_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path_to_resource_id_map)::BaseType>
        path_to_resource_id_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& path_to_resource_id_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, int32_t>>(
        in_path_to_resource_id_map, path_to_resource_id_map_fragment, &path_to_resource_id_map_validate_params);
    fragment->path_to_resource_id_map.Set(
        path_to_resource_id_map_fragment.is_null() ? nullptr : path_to_resource_id_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path_to_resource_id_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path_to_resource_id_map in LocalResourceSource struct");
    decltype(Traits::replacement_strings(input)) in_replacement_strings = Traits::replacement_strings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replacement_strings)::BaseType>
        replacement_strings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& replacement_strings_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        in_replacement_strings, replacement_strings_fragment, &replacement_strings_validate_params);
    fragment->replacement_strings.Set(
        replacement_strings_fragment.is_null() ? nullptr : replacement_strings_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->replacement_strings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replacement_strings in LocalResourceSource struct");
  }

  static bool Deserialize(::blink::mojom::internal::LocalResourceSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LocalResourceSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LocalResourceLoaderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LocalResourceLoaderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LocalResourceLoaderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::LocalResourceSourceDataView>>(
        in_sources, sources_fragment, &sources_validate_params);
    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sources in LocalResourceLoaderConfig struct");
  }

  static bool Deserialize(::blink::mojom::internal::LocalResourceLoaderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LocalResourceLoaderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void LocalResourceSourceDataView::GetHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LocalResourceSourceDataView::GetPathToResourceIdMapDataView(
    mojo::MapDataView<mojo::StringDataView, int32_t>* output) {
  auto pointer = data_->path_to_resource_id_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, int32_t>(pointer, message_);
}
inline void LocalResourceSourceDataView::GetReplacementStringsDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->replacement_strings.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void LocalResourceLoaderConfigDataView::GetSourcesDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, LocalResourceSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, LocalResourceSourceDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_SHARED_H_