// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace blink::mojom {
class CacheStorageVerboseErrorDataView;

class CacheQueryOptionsDataView;

class MultiCacheQueryOptionsDataView;

class BatchOperationDataView;

class EagerResponseDataView;

class CacheEntryDataView;

class OpenResultDataView;
class MatchResultDataView;
class MatchAllResultDataView;
class GetAllMatchedEntriesResultDataView;
class CacheKeysResultDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorageVerboseErrorDataView> {
  using Data = ::blink::mojom::internal::CacheStorageVerboseError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheQueryOptionsDataView> {
  using Data = ::blink::mojom::internal::CacheQueryOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MultiCacheQueryOptionsDataView> {
  using Data = ::blink::mojom::internal::MultiCacheQueryOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BatchOperationDataView> {
  using Data = ::blink::mojom::internal::BatchOperation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EagerResponseDataView> {
  using Data = ::blink::mojom::internal::EagerResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheEntryDataView> {
  using Data = ::blink::mojom::internal::CacheEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::OpenResultDataView> {
  using Data = ::blink::mojom::internal::OpenResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::MatchResultDataView> {
  using Data = ::blink::mojom::internal::MatchResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::MatchAllResultDataView> {
  using Data = ::blink::mojom::internal::MatchAllResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetAllMatchedEntriesResultDataView> {
  using Data = ::blink::mojom::internal::GetAllMatchedEntriesResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheKeysResultDataView> {
  using Data = ::blink::mojom::internal::CacheKeysResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class CacheStorageError : int32_t {
  
  kSuccess = 0,
  
  kErrorExists = 1,
  
  kErrorStorage = 2,
  
  kErrorNotFound = 3,
  
  kErrorQuotaExceeded = 4,
  
  kErrorCacheNameNotFound = 5,
  
  kErrorQueryTooLarge = 6,
  
  kErrorNotImplemented = 7,
  
  kErrorDuplicateOperation = 8,
  
  kErrorCrossOriginResourcePolicy = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CacheStorageError value);
inline bool IsKnownEnumValue(CacheStorageError value) {
  return internal::CacheStorageError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OperationType : int32_t {
  
  kUndefined = 0,
  
  kPut = 1,
  
  kDelete = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, OperationType value);
inline bool IsKnownEnumValue(OperationType value) {
  return internal::OperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CacheStorageCacheInterfaceBase {};

using CacheStorageCachePtrDataView =
    mojo::InterfacePtrDataView<CacheStorageCacheInterfaceBase>;
using CacheStorageCacheRequestDataView =
    mojo::InterfaceRequestDataView<CacheStorageCacheInterfaceBase>;
using CacheStorageCacheAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CacheStorageCacheInterfaceBase>;
using CacheStorageCacheAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CacheStorageCacheInterfaceBase>;
class CacheStorageInterfaceBase {};

using CacheStoragePtrDataView =
    mojo::InterfacePtrDataView<CacheStorageInterfaceBase>;
using CacheStorageRequestDataView =
    mojo::InterfaceRequestDataView<CacheStorageInterfaceBase>;
using CacheStorageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CacheStorageInterfaceBase>;
using CacheStorageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CacheStorageInterfaceBase>;


class CacheStorageVerboseErrorDataView {
 public:
  CacheStorageVerboseErrorDataView() = default;

  CacheStorageVerboseErrorDataView(
      internal::CacheStorageVerboseError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    auto data_value = data_->value;
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_value, output);
  }
  CacheStorageError value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CacheStorageError>(data_->value));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `message` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMessage` instead "
    "of `ReadMessage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CacheStorageVerboseError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CacheQueryOptionsDataView {
 public:
  CacheQueryOptionsDataView() = default;

  CacheQueryOptionsDataView(
      internal::CacheQueryOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool ignore_search() const {
    return data_->ignore_search;
  }
  bool ignore_method() const {
    return data_->ignore_method;
  }
  bool ignore_vary() const {
    return data_->ignore_vary;
  }
 private:
  internal::CacheQueryOptions_Data* data_ = nullptr;
};


class MultiCacheQueryOptionsDataView {
 public:
  MultiCacheQueryOptionsDataView() = default;

  MultiCacheQueryOptionsDataView(
      internal::MultiCacheQueryOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryOptionsDataView(
      CacheQueryOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQueryOptions(UserType* output) {
    
    auto* pointer = data_->query_options.Get();
    return mojo::internal::Deserialize<::blink::mojom::CacheQueryOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetCacheNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `cache_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCacheName` instead "
    "of `ReadCacheName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cache_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::MultiCacheQueryOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BatchOperationDataView {
 public:
  BatchOperationDataView() = default;

  BatchOperationDataView(
      internal::BatchOperation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadOperationType(UserType* output) const {
    auto data_value = data_->operation_type;
    return mojo::internal::Deserialize<::blink::mojom::OperationType>(
        data_value, output);
  }
  OperationType operation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::OperationType>(data_->operation_type));
  }
  inline void GetRequestDataView(
      ::blink::mojom::FetchAPIRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FetchAPIResponseDataView, UserType>(),
    "Attempting to read the optional `response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponse` instead "
    "of `ReadResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
  inline void GetMatchOptionsDataView(
      CacheQueryOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::CacheQueryOptionsDataView, UserType>(),
    "Attempting to read the optional `match_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMatchOptions` instead "
    "of `ReadMatchOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->match_options.Get();
    return mojo::internal::Deserialize<::blink::mojom::CacheQueryOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::BatchOperation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EagerResponseDataView {
 public:
  EagerResponseDataView() = default;

  EagerResponseDataView(
      internal::EagerResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakePipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobReaderClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::EagerResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CacheEntryDataView {
 public:
  CacheEntryDataView() = default;

  CacheEntryDataView(
      internal::CacheEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      ::blink::mojom::FetchAPIRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::CacheEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OpenResultDataView {
 public:
  using Tag = internal::OpenResult_Data::OpenResult_Tag;

  OpenResultDataView() = default;

  OpenResultDataView(
      internal::OpenResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_status() const { return data_->tag == Tag::kStatus; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    CHECK(is_status());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_status, output);
  }
  CacheStorageError status() const {
    CHECK(is_status());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_status));
  }
  bool is_cache() const { return data_->tag == Tag::kCache; }
  template <typename UserType>
  UserType TakeCache() {
    CHECK(is_cache());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::CacheStorageCacheAssociatedPtrInfoDataView>(
            &data_->data.f_cache, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::OpenResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class MatchResultDataView {
 public:
  using Tag = internal::MatchResult_Data::MatchResult_Tag;

  MatchResultDataView() = default;

  MatchResultDataView(
      internal::MatchResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_status() const { return data_->tag == Tag::kStatus; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    CHECK(is_status());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_status, output);
  }
  CacheStorageError status() const {
    CHECK(is_status());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_status));
  }
  bool is_response() const { return data_->tag == Tag::kResponse; }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) const {
    
    CHECK(is_response());
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        data_->data.f_response.Get(), output, message_);
  }
  bool is_eager_response() const { return data_->tag == Tag::kEagerResponse; }
  inline void GetEagerResponseDataView(
      EagerResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEagerResponse(UserType* output) const {
    
    CHECK(is_eager_response());
    return mojo::internal::Deserialize<::blink::mojom::EagerResponseDataView>(
        data_->data.f_eager_response.Get(), output, message_);
  }

 private:
  internal::MatchResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class MatchAllResultDataView {
 public:
  using Tag = internal::MatchAllResult_Data::MatchAllResult_Tag;

  MatchAllResultDataView() = default;

  MatchAllResultDataView(
      internal::MatchAllResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_status() const { return data_->tag == Tag::kStatus; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    CHECK(is_status());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_status, output);
  }
  CacheStorageError status() const {
    CHECK(is_status());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_status));
  }
  bool is_responses() const { return data_->tag == Tag::kResponses; }
  inline void GetResponsesDataView(
      mojo::ArrayDataView<::blink::mojom::FetchAPIResponseDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadResponses(UserType* output) const {
    
    CHECK(is_responses());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FetchAPIResponseDataView>>(
        data_->data.f_responses.Get(), output, message_);
  }

 private:
  internal::MatchAllResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class GetAllMatchedEntriesResultDataView {
 public:
  using Tag = internal::GetAllMatchedEntriesResult_Data::GetAllMatchedEntriesResult_Tag;

  GetAllMatchedEntriesResultDataView() = default;

  GetAllMatchedEntriesResultDataView(
      internal::GetAllMatchedEntriesResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_status() const { return data_->tag == Tag::kStatus; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    CHECK(is_status());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_status, output);
  }
  CacheStorageError status() const {
    CHECK(is_status());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_status));
  }
  bool is_entries() const { return data_->tag == Tag::kEntries; }
  inline void GetEntriesDataView(
      mojo::ArrayDataView<CacheEntryDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) const {
    
    CHECK(is_entries());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CacheEntryDataView>>(
        data_->data.f_entries.Get(), output, message_);
  }

 private:
  internal::GetAllMatchedEntriesResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CacheKeysResultDataView {
 public:
  using Tag = internal::CacheKeysResult_Data::CacheKeysResult_Tag;

  CacheKeysResultDataView() = default;

  CacheKeysResultDataView(
      internal::CacheKeysResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_status() const { return data_->tag == Tag::kStatus; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    CHECK(is_status());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_status, output);
  }
  CacheStorageError status() const {
    CHECK(is_status());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_status));
  }
  bool is_keys() const { return data_->tag == Tag::kKeys; }
  inline void GetKeysDataView(
      mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadKeys(UserType* output) const {
    
    CHECK(is_keys());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>>(
        data_->data.f_keys.Get(), output, message_);
  }

 private:
  internal::CacheKeysResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::CacheStorageError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CacheStorageError> {};

template <>
struct hash<::blink::mojom::OperationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::OperationType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CacheStorageError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CacheStorageError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::OperationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::OperationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::OperationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CacheStorageVerboseErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CacheStorageVerboseErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CacheStorageVerboseError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
        Traits::value(input), &fragment->value);
    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, message_fragment);
    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::CacheStorageVerboseError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CacheStorageVerboseErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CacheQueryOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CacheQueryOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CacheQueryOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->ignore_search = Traits::ignore_search(input);
    fragment->ignore_method = Traits::ignore_method(input);
    fragment->ignore_vary = Traits::ignore_vary(input);
  }

  static bool Deserialize(::blink::mojom::internal::CacheQueryOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CacheQueryOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MultiCacheQueryOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MultiCacheQueryOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MultiCacheQueryOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::query_options(input)) in_query_options = Traits::query_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->query_options)::BaseType> query_options_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
        in_query_options, query_options_fragment);
    fragment->query_options.Set(
        query_options_fragment.is_null() ? nullptr : query_options_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->query_options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null query_options in MultiCacheQueryOptions struct");
    decltype(Traits::cache_name(input)) in_cache_name = Traits::cache_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cache_name)::BaseType> cache_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_cache_name, cache_name_fragment);
    fragment->cache_name.Set(
        cache_name_fragment.is_null() ? nullptr : cache_name_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::MultiCacheQueryOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MultiCacheQueryOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BatchOperationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BatchOperationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BatchOperation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::OperationType>(
        Traits::operation_type(input), &fragment->operation_type);
    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
        in_request, request_fragment);
    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->request.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request in BatchOperation struct");
    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
        in_response, response_fragment);
    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());
    decltype(Traits::match_options(input)) in_match_options = Traits::match_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->match_options)::BaseType> match_options_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
        in_match_options, match_options_fragment);
    fragment->match_options.Set(
        match_options_fragment.is_null() ? nullptr : match_options_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::BatchOperation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BatchOperationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EagerResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EagerResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::EagerResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
        in_response, response_fragment);
    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->response.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response in EagerResponse struct");
    decltype(Traits::pipe(input)) in_pipe = Traits::pipe(input);
    mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
        in_pipe, &fragment->pipe, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->pipe),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid pipe in EagerResponse struct");
    decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobReaderClientInterfaceBase>>(
        in_client_receiver, &fragment->client_receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->client_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_receiver in EagerResponse struct");
  }

  static bool Deserialize(::blink::mojom::internal::EagerResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EagerResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CacheEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CacheEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CacheEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
        in_request, request_fragment);
    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->request.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request in CacheEntry struct");
    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
        in_response, response_fragment);
    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->response.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response in CacheEntry struct");
  }

  static bool Deserialize(::blink::mojom::internal::CacheEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CacheEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::OpenResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::OpenResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::OpenResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::OpenResultDataView::Tag::kStatus: {
        decltype(Traits::status(input))
            in_status = Traits::status(input);
        mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
            in_status, &fragment->data.f_status);
        break;
      }
      case ::blink::mojom::OpenResultDataView::Tag::kCache: {
        decltype(Traits::cache(input))
            in_cache = Traits::cache(input);
        mojo::internal::Serialize<::blink::mojom::CacheStorageCacheAssociatedPtrInfoDataView>(
            in_cache, &fragment->data.f_cache, &fragment.message());
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            !mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_cache),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
            "invalid cache in OpenResult union");
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::OpenResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::OpenResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MatchResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::MatchResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::MatchResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::MatchResultDataView::Tag::kStatus: {
        decltype(Traits::status(input))
            in_status = Traits::status(input);
        mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
            in_status, &fragment->data.f_status);
        break;
      }
      case ::blink::mojom::MatchResultDataView::Tag::kResponse: {
        decltype(Traits::response(input))
            in_response = Traits::response(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_response)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
            in_response, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null response in MatchResult union");
        fragment->data.f_response.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::MatchResultDataView::Tag::kEagerResponse: {
        decltype(Traits::eager_response(input))
            in_eager_response = Traits::eager_response(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_eager_response)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::EagerResponseDataView>(
            in_eager_response, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null eager_response in MatchResult union");
        fragment->data.f_eager_response.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::MatchResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MatchResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MatchAllResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::MatchAllResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::MatchAllResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::MatchAllResultDataView::Tag::kStatus: {
        decltype(Traits::status(input))
            in_status = Traits::status(input);
        mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
            in_status, &fragment->data.f_status);
        break;
      }
      case ::blink::mojom::MatchAllResultDataView::Tag::kResponses: {
        decltype(Traits::responses(input))
            in_responses = Traits::responses(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_responses)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& responses_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FetchAPIResponseDataView>>(
            in_responses, value_fragment, &responses_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null responses in MatchAllResult union");
        fragment->data.f_responses.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::MatchAllResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MatchAllResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetAllMatchedEntriesResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::GetAllMatchedEntriesResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::GetAllMatchedEntriesResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::GetAllMatchedEntriesResultDataView::Tag::kStatus: {
        decltype(Traits::status(input))
            in_status = Traits::status(input);
        mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
            in_status, &fragment->data.f_status);
        break;
      }
      case ::blink::mojom::GetAllMatchedEntriesResultDataView::Tag::kEntries: {
        decltype(Traits::entries(input))
            in_entries = Traits::entries(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_entries)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CacheEntryDataView>>(
            in_entries, value_fragment, &entries_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null entries in GetAllMatchedEntriesResult union");
        fragment->data.f_entries.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::GetAllMatchedEntriesResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetAllMatchedEntriesResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CacheKeysResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::CacheKeysResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::CacheKeysResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::CacheKeysResultDataView::Tag::kStatus: {
        decltype(Traits::status(input))
            in_status = Traits::status(input);
        mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
            in_status, &fragment->data.f_status);
        break;
      }
      case ::blink::mojom::CacheKeysResultDataView::Tag::kKeys: {
        decltype(Traits::keys(input))
            in_keys = Traits::keys(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_keys)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>>(
            in_keys, value_fragment, &keys_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null keys in CacheKeysResult union");
        fragment->data.f_keys.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::CacheKeysResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CacheKeysResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void CacheStorageVerboseErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void MultiCacheQueryOptionsDataView::GetQueryOptionsDataView(
    CacheQueryOptionsDataView* output) {
  auto pointer = data_->query_options.Get();
  *output = CacheQueryOptionsDataView(pointer, message_);
}
inline void MultiCacheQueryOptionsDataView::GetCacheNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->cache_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void BatchOperationDataView::GetRequestDataView(
    ::blink::mojom::FetchAPIRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = ::blink::mojom::FetchAPIRequestDataView(pointer, message_);
}
inline void BatchOperationDataView::GetResponseDataView(
    ::blink::mojom::FetchAPIResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = ::blink::mojom::FetchAPIResponseDataView(pointer, message_);
}
inline void BatchOperationDataView::GetMatchOptionsDataView(
    CacheQueryOptionsDataView* output) {
  auto pointer = data_->match_options.Get();
  *output = CacheQueryOptionsDataView(pointer, message_);
}


inline void EagerResponseDataView::GetResponseDataView(
    ::blink::mojom::FetchAPIResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = ::blink::mojom::FetchAPIResponseDataView(pointer, message_);
}


inline void CacheEntryDataView::GetRequestDataView(
    ::blink::mojom::FetchAPIRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = ::blink::mojom::FetchAPIRequestDataView(pointer, message_);
}
inline void CacheEntryDataView::GetResponseDataView(
    ::blink::mojom::FetchAPIResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = ::blink::mojom::FetchAPIResponseDataView(pointer, message_);
}



inline void MatchResultDataView::GetResponseDataView(
    ::blink::mojom::FetchAPIResponseDataView* output) const {
  CHECK(is_response());
  *output = ::blink::mojom::FetchAPIResponseDataView(data_->data.f_response.Get(), message_);
}
inline void MatchResultDataView::GetEagerResponseDataView(
    EagerResponseDataView* output) const {
  CHECK(is_eager_response());
  *output = EagerResponseDataView(data_->data.f_eager_response.Get(), message_);
}

inline void MatchAllResultDataView::GetResponsesDataView(
    mojo::ArrayDataView<::blink::mojom::FetchAPIResponseDataView>* output) const {
  CHECK(is_responses());
  *output = mojo::ArrayDataView<::blink::mojom::FetchAPIResponseDataView>(data_->data.f_responses.Get(), message_);
}

inline void GetAllMatchedEntriesResultDataView::GetEntriesDataView(
    mojo::ArrayDataView<CacheEntryDataView>* output) const {
  CHECK(is_entries());
  *output = mojo::ArrayDataView<CacheEntryDataView>(data_->data.f_entries.Get(), message_);
}

inline void CacheKeysResultDataView::GetKeysDataView(
    mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>* output) const {
  CHECK(is_keys());
  *output = mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>(data_->data.f_keys.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CacheStorageError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CacheStorageError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::OperationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::OperationType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_SHARED_H_