// third_party/blink/public/mojom/blob/blob_registry.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/blob_registry.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/blob_registry.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/blob_registry.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/blob_registry.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/blob/blob_registry.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
const char ProgressClient::Name_[] = "blink.mojom.ProgressClient";

ProgressClient::IPCStableHashFunction ProgressClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProgressClient>(message.name())) {
    case messages::ProgressClient::kOnProgress: {
      return &ProgressClient::OnProgress_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProgressClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProgressClient>(message.name())) {
      case messages::ProgressClient::kOnProgress:
            return "Receive blink::mojom::ProgressClient::OnProgress";
    }
  } else {
    switch (static_cast<messages::ProgressClient>(message.name())) {
      case messages::ProgressClient::kOnProgress:
            return "Receive reply blink::mojom::ProgressClient::OnProgress";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProgressClient::OnProgress_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::ProgressClient::OnProgress");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProgressClientProxy::ProgressClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProgressClientProxy::OnProgress(
    uint64_t in_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ProgressClient::OnProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delta"), in_delta,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProgressClient::kOnProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ProgressClient_OnProgress_Params_Data> params(
          message);
  params.Allocate();
  params->delta = in_delta;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProgressClient::Name_);
  message.set_method_name("OnProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProgressClientStubDispatch::Accept(
    ProgressClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProgressClient>(message->header()->name)) {
    case messages::ProgressClient::kOnProgress: {
      DCHECK(message->is_serialized());
      internal::ProgressClient_OnProgress_Params_Data* params =
          reinterpret_cast<internal::ProgressClient_OnProgress_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProgressClient.0
      bool success = true;
      uint64_t p_delta{};
      ProgressClient_OnProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_delta = input_data_view.delta();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProgressClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProgress(        
        std::move(p_delta));
      return true;
    }
  }
  return false;
}

// static
bool ProgressClientStubDispatch::AcceptWithResponder(
    ProgressClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProgressClient>(message->header()->name)) {
    case messages::ProgressClient::kOnProgress: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProgressClientValidationInfo[] = {
    { &internal::ProgressClient_OnProgress_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProgressClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ProgressClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kProgressClientValidationInfo);
}

const char BlobRegistry::Name_[] = "blink.mojom.BlobRegistry";

BlobRegistry::IPCStableHashFunction BlobRegistry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BlobRegistry>(message.name())) {
    case messages::BlobRegistry::kRegister: {
      return &BlobRegistry::Register_Sym::IPCStableHash;
    }
    case messages::BlobRegistry::kRegisterFromStream: {
      return &BlobRegistry::RegisterFromStream_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BlobRegistry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BlobRegistry>(message.name())) {
      case messages::BlobRegistry::kRegister:
            return "Receive blink::mojom::BlobRegistry::Register";
      case messages::BlobRegistry::kRegisterFromStream:
            return "Receive blink::mojom::BlobRegistry::RegisterFromStream";
    }
  } else {
    switch (static_cast<messages::BlobRegistry>(message.name())) {
      case messages::BlobRegistry::kRegister:
            return "Receive reply blink::mojom::BlobRegistry::Register";
      case messages::BlobRegistry::kRegisterFromStream:
            return "Receive reply blink::mojom::BlobRegistry::RegisterFromStream";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BlobRegistry::Register_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobRegistry::Register");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobRegistry::RegisterFromStream_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobRegistry::RegisterFromStream");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool BlobRegistry::Register(::mojo::PendingReceiver<::blink::mojom::blink::Blob> blob, const WTF::String& uuid, const WTF::String& content_type, const WTF::String& content_disposition, WTF::Vector<::blink::mojom::blink::DataElementPtr> elements) {
  NOTREACHED();
}
class BlobRegistry_Register_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_Register_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  BlobRegistry_Register_HandleSyncResponse(const BlobRegistry_Register_HandleSyncResponse&) = delete;
  BlobRegistry_Register_HandleSyncResponse& operator=(const BlobRegistry_Register_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class BlobRegistry_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_Register_ForwardToCallback(
      BlobRegistry::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobRegistry_Register_ForwardToCallback(const BlobRegistry_Register_ForwardToCallback&) = delete;
  BlobRegistry_Register_ForwardToCallback& operator=(const BlobRegistry_Register_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobRegistry::RegisterCallback callback_;
};

class BlobRegistry_RegisterFromStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_RegisterFromStream_ForwardToCallback(
      BlobRegistry::RegisterFromStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobRegistry_RegisterFromStream_ForwardToCallback(const BlobRegistry_RegisterFromStream_ForwardToCallback&) = delete;
  BlobRegistry_RegisterFromStream_ForwardToCallback& operator=(const BlobRegistry_RegisterFromStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobRegistry::RegisterFromStreamCallback callback_;
};

BlobRegistryProxy::BlobRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool BlobRegistryProxy::Register(
    ::mojo::PendingReceiver<::blink::mojom::blink::Blob> param_blob, const WTF::String& param_uuid, const WTF::String& param_content_type, const WTF::String& param_content_disposition, WTF::Vector<::blink::mojom::blink::DataElementPtr> param_elements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::BlobRegistry::Register (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), param_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), param_uuid,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), param_content_type,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_disposition"), param_content_disposition,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), param_elements,
                        "<value of type WTF::Vector<::blink::mojom::blink::DataElementPtr>>");
   });
#else
  TRACE_EVENT0("mojom", "BlobRegistry::Register");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobRegistry::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      param_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_content_type, content_type_fragment);
  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_disposition)::BaseType> content_disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_content_disposition, content_disposition_fragment);
  params->content_disposition.Set(
      content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_disposition in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DataElementDataView>>(
      param_elements, elements_fragment, &elements_validate_params);
  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elements.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elements in BlobRegistry.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("Register");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_Register_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "BlobRegistry::Register");
#endif
  return result;
}

void BlobRegistryProxy::Register(
    ::mojo::PendingReceiver<::blink::mojom::blink::Blob> in_blob, const WTF::String& in_uuid, const WTF::String& in_content_type, const WTF::String& in_content_disposition, WTF::Vector<::blink::mojom::blink::DataElementPtr> in_elements, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobRegistry::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_disposition"), in_content_disposition,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), in_elements,
                        "<value of type WTF::Vector<::blink::mojom::blink::DataElementPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobRegistry::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_type, content_type_fragment);
  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_disposition)::BaseType> content_disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_disposition, content_disposition_fragment);
  params->content_disposition.Set(
      content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_disposition in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DataElementDataView>>(
      in_elements, elements_fragment, &elements_validate_params);
  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elements.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elements in BlobRegistry.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_Register_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BlobRegistryProxy::RegisterFromStream(
    const WTF::String& in_content_type, const WTF::String& in_content_disposition, uint64_t in_length_hint, ::mojo::ScopedDataPipeConsumerHandle in_data, ::mojo::PendingAssociatedRemote<ProgressClient> in_progress_client, RegisterFromStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobRegistry::RegisterFromStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_disposition"), in_content_disposition,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length_hint"), in_length_hint,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress_client"), in_progress_client,
                        "<value of type ::mojo::PendingAssociatedRemote<ProgressClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobRegistry::kRegisterFromStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_RegisterFromStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_type, content_type_fragment);
  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in BlobRegistry.RegisterFromStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_disposition)::BaseType> content_disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_disposition, content_disposition_fragment);
  params->content_disposition.Set(
      content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_disposition in BlobRegistry.RegisterFromStream request");
  params->length_hint = in_length_hint;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_data, &params->data, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data in BlobRegistry.RegisterFromStream request");
  mojo::internal::Serialize<::blink::mojom::ProgressClientAssociatedPtrInfoDataView>(
      in_progress_client, &params->progress_client, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("RegisterFromStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_RegisterFromStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BlobRegistry_Register_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobRegistry::RegisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobRegistry_Register_ProxyToResponder> proxy(
        new BlobRegistry_Register_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobRegistry_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobRegistry_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobRegistry_Register_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobRegistry::RegisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BlobRegistry_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobRegistry_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobRegistry_Register_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BlobRegistry.0
  bool success = true;
  BlobRegistry_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void BlobRegistry_Register_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::BlobRegistry::Register");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobRegistry::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_Register_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool BlobRegistry_Register_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobRegistry_Register_ResponseParams_Data* params =
      reinterpret_cast<internal::BlobRegistry_Register_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for BlobRegistry.0
  bool success = true;
  BlobRegistry_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}
class BlobRegistry_RegisterFromStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobRegistry::RegisterFromStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobRegistry_RegisterFromStream_ProxyToResponder> proxy(
        new BlobRegistry_RegisterFromStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobRegistry_RegisterFromStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobRegistry_RegisterFromStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobRegistry_RegisterFromStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobRegistry::RegisterFromStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::scoped_refptr<::blink::BlobDataHandle>& in_blob);
};

bool BlobRegistry_RegisterFromStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobRegistry_RegisterFromStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobRegistry_RegisterFromStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BlobRegistry.1
  bool success = true;
  ::scoped_refptr<::blink::BlobDataHandle> p_blob{};
  BlobRegistry_RegisterFromStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blob));
  return true;
}

void BlobRegistry_RegisterFromStream_ProxyToResponder::Run(
    const ::scoped_refptr<::blink::BlobDataHandle>& in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BlobRegistry::RegisterFromStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type const ::scoped_refptr<::blink::BlobDataHandle>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobRegistry::kRegisterFromStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_RegisterFromStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_blob, blob_fragment);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("RegisterFromStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobRegistryStubDispatch::Accept(
    BlobRegistry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BlobRegistry>(message->header()->name)) {
    case messages::BlobRegistry::kRegister: {
      break;
    }
    case messages::BlobRegistry::kRegisterFromStream: {
      break;
    }
  }
  return false;
}

// static
bool BlobRegistryStubDispatch::AcceptWithResponder(
    BlobRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BlobRegistry>(message->header()->name)) {
    case messages::BlobRegistry::kRegister: {
      internal::BlobRegistry_Register_Params_Data* params =
          reinterpret_cast<
              internal::BlobRegistry_Register_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BlobRegistry.0
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::Blob> p_blob{};
      WTF::String p_uuid{};
      WTF::String p_content_type{};
      WTF::String p_content_disposition{};
      WTF::Vector<::blink::mojom::blink::DataElementPtr> p_elements{};
      BlobRegistry_Register_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (success && !input_data_view.ReadContentDisposition(&p_content_disposition))
        success = false;
      if (success && !input_data_view.ReadElements(&p_elements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobRegistry::Name_, 0, false);
        return false;
      }
      BlobRegistry::RegisterCallback callback =
          BlobRegistry_Register_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(        
        std::move(p_blob), 
        std::move(p_uuid), 
        std::move(p_content_type), 
        std::move(p_content_disposition), 
        std::move(p_elements), std::move(callback));
      return true;
    }
    case messages::BlobRegistry::kRegisterFromStream: {
      internal::BlobRegistry_RegisterFromStream_Params_Data* params =
          reinterpret_cast<
              internal::BlobRegistry_RegisterFromStream_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BlobRegistry.1
      bool success = true;
      WTF::String p_content_type{};
      WTF::String p_content_disposition{};
      uint64_t p_length_hint{};
      ::mojo::ScopedDataPipeConsumerHandle p_data{};
      ::mojo::PendingAssociatedRemote<ProgressClient> p_progress_client{};
      BlobRegistry_RegisterFromStream_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (success && !input_data_view.ReadContentDisposition(&p_content_disposition))
        success = false;
      if (success)
        p_length_hint = input_data_view.length_hint();
      if (success)
        p_data = input_data_view.TakeData();
      if (success) {
        p_progress_client =
            input_data_view.TakeProgressClient<decltype(p_progress_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobRegistry::Name_, 1, false);
        return false;
      }
      BlobRegistry::RegisterFromStreamCallback callback =
          BlobRegistry_RegisterFromStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFromStream(        
        std::move(p_content_type), 
        std::move(p_content_disposition), 
        std::move(p_length_hint), 
        std::move(p_data), 
        std::move(p_progress_client), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBlobRegistryValidationInfo[] = {
    { &internal::BlobRegistry_Register_Params_Data::Validate,
     &internal::BlobRegistry_Register_ResponseParams_Data::Validate},
    { &internal::BlobRegistry_RegisterFromStream_Params_Data::Validate,
     &internal::BlobRegistry_RegisterFromStream_ResponseParams_Data::Validate},
};

bool BlobRegistryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BlobRegistry::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobRegistryValidationInfo);
}

bool BlobRegistryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BlobRegistry::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBlobRegistryValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ProgressClientInterceptorForTesting::OnProgress(uint64_t delta) {
  GetForwardingInterface()->OnProgress(
    std::move(delta)
    );
}
ProgressClientAsyncWaiter::ProgressClientAsyncWaiter(
    ProgressClient* proxy) : proxy_(proxy) {}

ProgressClientAsyncWaiter::~ProgressClientAsyncWaiter() = default;




void BlobRegistryInterceptorForTesting::Register(::mojo::PendingReceiver<::blink::mojom::blink::Blob> blob, const WTF::String& uuid, const WTF::String& content_type, const WTF::String& content_disposition, WTF::Vector<::blink::mojom::blink::DataElementPtr> elements, RegisterCallback callback) {
  GetForwardingInterface()->Register(
    std::move(blob)
    , 
    std::move(uuid)
    , 
    std::move(content_type)
    , 
    std::move(content_disposition)
    , 
    std::move(elements)
    , std::move(callback));
}
void BlobRegistryInterceptorForTesting::RegisterFromStream(const WTF::String& content_type, const WTF::String& content_disposition, uint64_t length_hint, ::mojo::ScopedDataPipeConsumerHandle data, ::mojo::PendingAssociatedRemote<ProgressClient> progress_client, RegisterFromStreamCallback callback) {
  GetForwardingInterface()->RegisterFromStream(
    std::move(content_type)
    , 
    std::move(content_disposition)
    , 
    std::move(length_hint)
    , 
    std::move(data)
    , 
    std::move(progress_client)
    , std::move(callback));
}
BlobRegistryAsyncWaiter::BlobRegistryAsyncWaiter(
    BlobRegistry* proxy) : proxy_(proxy) {}

BlobRegistryAsyncWaiter::~BlobRegistryAsyncWaiter() = default;

void BlobRegistryAsyncWaiter::Register(
    ::mojo::PendingReceiver<::blink::mojom::blink::Blob> blob, const WTF::String& uuid, const WTF::String& content_type, const WTF::String& content_disposition, WTF::Vector<::blink::mojom::blink::DataElementPtr> elements) {
  base::RunLoop loop;
  proxy_->Register(
      std::move(blob),
      std::move(uuid),
      std::move(content_type),
      std::move(content_disposition),
      std::move(elements),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void BlobRegistryAsyncWaiter::RegisterFromStream(
    const WTF::String& content_type, const WTF::String& content_disposition, uint64_t length_hint, ::mojo::ScopedDataPipeConsumerHandle data, ::mojo::PendingAssociatedRemote<ProgressClient> progress_client, ::scoped_refptr<::blink::BlobDataHandle>* out_blob) {
  base::RunLoop loop;
  proxy_->RegisterFromStream(
      std::move(content_type),
      std::move(content_disposition),
      std::move(length_hint),
      std::move(data),
      std::move(progress_client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::scoped_refptr<::blink::BlobDataHandle>* out_blob
,
             const ::scoped_refptr<::blink::BlobDataHandle>& blob) {*out_blob = std::move(blob);
            loop->Quit();
          },
          &loop,
          out_blob));
  loop.Run();
}

::scoped_refptr<::blink::BlobDataHandle> BlobRegistryAsyncWaiter::RegisterFromStream(
    const WTF::String& content_type, const WTF::String& content_disposition, uint64_t length_hint, ::mojo::ScopedDataPipeConsumerHandle data, ::mojo::PendingAssociatedRemote<ProgressClient> progress_client) {
  ::scoped_refptr<::blink::BlobDataHandle> async_wait_result;
  RegisterFromStream(std::move(content_type),std::move(content_disposition),std::move(length_hint),std::move(data),std::move(progress_client),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif