// services/device/public/mojom/sensor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/sensor.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace device::mojom {
class SensorReadingRawDataView;

class SensorConfigurationDataView;



}  // device::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::SensorReadingRawDataView> {
  using Data = ::device::mojom::internal::SensorReadingRaw_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SensorConfigurationDataView> {
  using Data = ::device::mojom::internal::SensorConfiguration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class SensorType : int32_t {
  
  AMBIENT_LIGHT = 0,
  
  ACCELEROMETER = 1,
  
  LINEAR_ACCELERATION = 2,
  
  GRAVITY = 3,
  
  GYROSCOPE = 4,
  
  MAGNETOMETER = 5,
  
  ABSOLUTE_ORIENTATION_EULER_ANGLES = 6,
  
  ABSOLUTE_ORIENTATION_QUATERNION = 7,
  
  RELATIVE_ORIENTATION_EULER_ANGLES = 8,
  
  RELATIVE_ORIENTATION_QUATERNION = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

 std::ostream& operator<<(std::ostream& os, SensorType value);
inline bool IsKnownEnumValue(SensorType value) {
  return internal::SensorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ReportingMode : int32_t {
  
  ON_CHANGE = 0,
  
  CONTINUOUS = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ReportingMode value);
inline bool IsKnownEnumValue(ReportingMode value) {
  return internal::ReportingMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SensorInterfaceBase {};

using SensorPtrDataView =
    mojo::InterfacePtrDataView<SensorInterfaceBase>;
using SensorRequestDataView =
    mojo::InterfaceRequestDataView<SensorInterfaceBase>;
using SensorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SensorInterfaceBase>;
using SensorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SensorInterfaceBase>;
class SensorClientInterfaceBase {};

using SensorClientPtrDataView =
    mojo::InterfacePtrDataView<SensorClientInterfaceBase>;
using SensorClientRequestDataView =
    mojo::InterfaceRequestDataView<SensorClientInterfaceBase>;
using SensorClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SensorClientInterfaceBase>;
using SensorClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SensorClientInterfaceBase>;


class SensorReadingRawDataView {
 public:
  SensorReadingRawDataView() = default;

  SensorReadingRawDataView(
      internal::SensorReadingRaw_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double timestamp() const {
    return data_->timestamp;
  }
  inline void GetValuesDataView(
      mojo::ArrayDataView<double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValues(UserType* output) {
    
    auto* pointer = data_->values.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        pointer, output, message_);
  }
 private:
  internal::SensorReadingRaw_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SensorConfigurationDataView {
 public:
  SensorConfigurationDataView() = default;

  SensorConfigurationDataView(
      internal::SensorConfiguration_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double frequency() const {
    return data_->frequency;
  }
 private:
  internal::SensorConfiguration_Data* data_ = nullptr;
};


}  // device::mojom

namespace std {

template <>
struct hash<::device::mojom::SensorType>
    : public mojo::internal::EnumHashImpl<::device::mojom::SensorType> {};

template <>
struct hash<::device::mojom::ReportingMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::ReportingMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SensorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SensorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SensorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::ReportingMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::ReportingMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::ReportingMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SensorReadingRawDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SensorReadingRawDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SensorReadingRaw_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->timestamp = Traits::timestamp(input);
    decltype(Traits::values(input)) in_values = Traits::values(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->values)::BaseType>
        values_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
        mojo::internal::GetArrayValidator<4, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<double>>(
        in_values, values_fragment, &values_validate_params);
    fragment->values.Set(
        values_fragment.is_null() ? nullptr : values_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->values.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null values in SensorReadingRaw struct");
  }

  static bool Deserialize(::device::mojom::internal::SensorReadingRaw_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SensorReadingRawDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SensorConfigurationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SensorConfigurationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SensorConfiguration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->frequency = Traits::frequency(input);
  }

  static bool Deserialize(::device::mojom::internal::SensorConfiguration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SensorConfigurationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void SensorReadingRawDataView::GetValuesDataView(
    mojo::ArrayDataView<double>* output) {
  auto pointer = data_->values.Get();
  *output = mojo::ArrayDataView<double>(pointer, message_);
}





}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SensorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SensorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::ReportingMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::ReportingMode value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_MOJOM_SHARED_H_