// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-test-utils.h"


namespace auction_worklet::mojom {
BrowserSignals::BrowserSignals()
    : top_frame_origin(),
      seller() {}

BrowserSignals::BrowserSignals(
    const ::url::Origin& top_frame_origin_in,
    const ::url::Origin& seller_in)
    : top_frame_origin(std::move(top_frame_origin_in)),
      seller(std::move(seller_in)) {}

BrowserSignals::~BrowserSignals() = default;

void BrowserSignals::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_frame_origin"), this->top_frame_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller"), this->seller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BrowserSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionWorkletPermissionsPolicyState::AuctionWorkletPermissionsPolicyState()
    : private_aggregation_allowed(),
      shared_storage_allowed() {}

AuctionWorkletPermissionsPolicyState::AuctionWorkletPermissionsPolicyState(
    bool private_aggregation_allowed_in,
    bool shared_storage_allowed_in)
    : private_aggregation_allowed(std::move(private_aggregation_allowed_in)),
      shared_storage_allowed(std::move(shared_storage_allowed_in)) {}

AuctionWorkletPermissionsPolicyState::~AuctionWorkletPermissionsPolicyState() = default;
size_t AuctionWorkletPermissionsPolicyState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->private_aggregation_allowed);
  seed = mojo::internal::Hash(seed, this->shared_storage_allowed);
  return seed;
}

void AuctionWorkletPermissionsPolicyState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_aggregation_allowed"), this->private_aggregation_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_storage_allowed"), this->shared_storage_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionWorkletPermissionsPolicyState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustedSignalsPublicKey::TrustedSignalsPublicKey()
    : key(),
      id() {}

TrustedSignalsPublicKey::TrustedSignalsPublicKey(
    const std::string& key_in,
    uint8_t id_in)
    : key(std::move(key_in)),
      id(std::move(id_in)) {}

TrustedSignalsPublicKey::~TrustedSignalsPublicKey() = default;
size_t TrustedSignalsPublicKey::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key);
  seed = mojo::internal::Hash(seed, this->id);
  return seed;
}

void TrustedSignalsPublicKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustedSignalsPublicKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char LoadSellerWorkletClient::Name_[] = "auction_worklet.mojom.LoadSellerWorkletClient";

LoadSellerWorkletClient::IPCStableHashFunction LoadSellerWorkletClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LoadSellerWorkletClient>(message.name())) {
    case messages::LoadSellerWorkletClient::kSellerWorkletLoaded: {
      return &LoadSellerWorkletClient::SellerWorkletLoaded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LoadSellerWorkletClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LoadSellerWorkletClient>(message.name())) {
      case messages::LoadSellerWorkletClient::kSellerWorkletLoaded:
            return "Receive auction_worklet::mojom::LoadSellerWorkletClient::SellerWorkletLoaded";
    }
  } else {
    switch (static_cast<messages::LoadSellerWorkletClient>(message.name())) {
      case messages::LoadSellerWorkletClient::kSellerWorkletLoaded:
            return "Receive reply auction_worklet::mojom::LoadSellerWorkletClient::SellerWorkletLoaded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LoadSellerWorkletClient::SellerWorkletLoaded_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)auction_worklet::mojom::LoadSellerWorkletClient::SellerWorkletLoaded");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LoadSellerWorkletClientProxy::LoadSellerWorkletClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LoadSellerWorkletClientProxy::SellerWorkletLoaded(
    bool in_trusted_signals_url_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::LoadSellerWorkletClient::SellerWorkletLoaded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trusted_signals_url_allowed"), in_trusted_signals_url_allowed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LoadSellerWorkletClient::kSellerWorkletLoaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data> params(
          message);
  params.Allocate();
  params->trusted_signals_url_allowed = in_trusted_signals_url_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LoadSellerWorkletClient::Name_);
  message.set_method_name("SellerWorkletLoaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LoadSellerWorkletClientStubDispatch::Accept(
    LoadSellerWorkletClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LoadSellerWorkletClient>(message->header()->name)) {
    case messages::LoadSellerWorkletClient::kSellerWorkletLoaded: {
      DCHECK(message->is_serialized());
      internal::LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data* params =
          reinterpret_cast<internal::LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for LoadSellerWorkletClient.0
      bool success = true;
      bool p_trusted_signals_url_allowed{};
      LoadSellerWorkletClient_SellerWorkletLoaded_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_trusted_signals_url_allowed = input_data_view.trusted_signals_url_allowed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LoadSellerWorkletClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SellerWorkletLoaded(        
        std::move(p_trusted_signals_url_allowed));
      return true;
    }
  }
  return false;
}

// static
bool LoadSellerWorkletClientStubDispatch::AcceptWithResponder(
    LoadSellerWorkletClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LoadSellerWorkletClient>(message->header()->name)) {
    case messages::LoadSellerWorkletClient::kSellerWorkletLoaded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLoadSellerWorkletClientValidationInfo[] = {
    {base::to_underlying(messages::LoadSellerWorkletClient::kSellerWorkletLoaded),
     { &internal::LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LoadSellerWorkletClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::LoadSellerWorkletClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLoadSellerWorkletClientValidationInfo);
}

const char AuctionWorkletService::Name_[] = "auction_worklet.mojom.AuctionWorkletService";

AuctionWorkletService::IPCStableHashFunction AuctionWorkletService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AuctionWorkletService>(message.name())) {
    case messages::AuctionWorkletService::kSetTrustedSignalsCache: {
      return &AuctionWorkletService::SetTrustedSignalsCache_Sym::IPCStableHash;
    }
    case messages::AuctionWorkletService::kLoadBidderWorklet: {
      return &AuctionWorkletService::LoadBidderWorklet_Sym::IPCStableHash;
    }
    case messages::AuctionWorkletService::kLoadSellerWorklet: {
      return &AuctionWorkletService::LoadSellerWorklet_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AuctionWorkletService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AuctionWorkletService>(message.name())) {
      case messages::AuctionWorkletService::kSetTrustedSignalsCache:
            return "Receive auction_worklet::mojom::AuctionWorkletService::SetTrustedSignalsCache";
      case messages::AuctionWorkletService::kLoadBidderWorklet:
            return "Receive auction_worklet::mojom::AuctionWorkletService::LoadBidderWorklet";
      case messages::AuctionWorkletService::kLoadSellerWorklet:
            return "Receive auction_worklet::mojom::AuctionWorkletService::LoadSellerWorklet";
    }
  } else {
    switch (static_cast<messages::AuctionWorkletService>(message.name())) {
      case messages::AuctionWorkletService::kSetTrustedSignalsCache:
            return "Receive reply auction_worklet::mojom::AuctionWorkletService::SetTrustedSignalsCache";
      case messages::AuctionWorkletService::kLoadBidderWorklet:
            return "Receive reply auction_worklet::mojom::AuctionWorkletService::LoadBidderWorklet";
      case messages::AuctionWorkletService::kLoadSellerWorklet:
            return "Receive reply auction_worklet::mojom::AuctionWorkletService::LoadSellerWorklet";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AuctionWorkletService::SetTrustedSignalsCache_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)auction_worklet::mojom::AuctionWorkletService::SetTrustedSignalsCache");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AuctionWorkletService::LoadBidderWorklet_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadBidderWorklet");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AuctionWorkletService::LoadSellerWorklet_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadSellerWorklet");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AuctionWorkletServiceProxy::AuctionWorkletServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuctionWorkletServiceProxy::SetTrustedSignalsCache(
    ::mojo::PendingRemote<::auction_worklet::mojom::TrustedSignalsCache> in_trusted_signals_cache) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionWorkletService::SetTrustedSignalsCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trusted_signals_cache"), in_trusted_signals_cache,
                        "<value of type ::mojo::PendingRemote<::auction_worklet::mojom::TrustedSignalsCache>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionWorkletService::kSetTrustedSignalsCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionWorkletService_SetTrustedSignalsCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::TrustedSignalsCacheInterfaceBase>>(
      in_trusted_signals_cache, &params->trusted_signals_cache, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->trusted_signals_cache),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid trusted_signals_cache in AuctionWorkletService.SetTrustedSignalsCache request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionWorkletService::Name_);
  message.set_method_name("SetTrustedSignalsCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AuctionWorkletServiceProxy::LoadBidderWorklet(
    ::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet> in_bidder_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> in_shared_storage_hosts, bool in_pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> in_auction_network_events_handler, const ::GURL& in_script_source_url, const std::optional<::GURL>& in_wasm_helper_url, const std::optional<::GURL>& in_trusted_bidding_signals_url, const std::string& in_trusted_bidding_signals_slot_size_param, const ::url::Origin& in_top_window_origin, AuctionWorkletPermissionsPolicyStatePtr in_permissions_policy_state, std::optional<uint16_t> in_experiment_group_id, TrustedSignalsPublicKeyPtr in_public_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionWorkletService::LoadBidderWorklet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidder_worklet"), in_bidder_worklet,
                        "<value of type ::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_storage_hosts"), in_shared_storage_hosts,
                        "<value of type std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pause_for_debugger_on_start"), in_pause_for_debugger_on_start,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_network_events_handler"), in_auction_network_events_handler,
                        "<value of type ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_source_url"), in_script_source_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wasm_helper_url"), in_wasm_helper_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trusted_bidding_signals_url"), in_trusted_bidding_signals_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trusted_bidding_signals_slot_size_param"), in_trusted_bidding_signals_slot_size_param,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_window_origin"), in_top_window_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions_policy_state"), in_permissions_policy_state,
                        "<value of type AuctionWorkletPermissionsPolicyStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("experiment_group_id"), in_experiment_group_id,
                        "<value of type std::optional<uint16_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("public_key"), in_public_key,
                        "<value of type TrustedSignalsPublicKeyPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionWorkletService::kLoadBidderWorklet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionWorkletService_LoadBidderWorklet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::auction_worklet::mojom::BidderWorkletInterfaceBase>>(
      in_bidder_worklet, &params->bidder_worklet, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->bidder_worklet),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid bidder_worklet in AuctionWorkletService.LoadBidderWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->shared_storage_hosts)::BaseType>
      shared_storage_hosts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& shared_storage_hosts_validate_params =
      mojo::internal::GetArrayValidator<0, true, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::auction_worklet::mojom::AuctionSharedStorageHostInterfaceBase>>>(
      in_shared_storage_hosts, shared_storage_hosts_fragment, &shared_storage_hosts_validate_params);
  params->shared_storage_hosts.Set(
      shared_storage_hosts_fragment.is_null() ? nullptr : shared_storage_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shared_storage_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_storage_hosts in AuctionWorkletService.LoadBidderWorklet request");
  params->pause_for_debugger_on_start = in_pause_for_debugger_on_start;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in AuctionWorkletService.LoadBidderWorklet request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::AuctionNetworkEventsHandlerInterfaceBase>>(
      in_auction_network_events_handler, &params->auction_network_events_handler, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->auction_network_events_handler),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid auction_network_events_handler in AuctionWorkletService.LoadBidderWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_source_url)::BaseType> script_source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_source_url, script_source_url_fragment);
  params->script_source_url.Set(
      script_source_url_fragment.is_null() ? nullptr : script_source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_source_url in AuctionWorkletService.LoadBidderWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->wasm_helper_url)::BaseType> wasm_helper_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_wasm_helper_url, wasm_helper_url_fragment);
  params->wasm_helper_url.Set(
      wasm_helper_url_fragment.is_null() ? nullptr : wasm_helper_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->trusted_bidding_signals_url)::BaseType> trusted_bidding_signals_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_trusted_bidding_signals_url, trusted_bidding_signals_url_fragment);
  params->trusted_bidding_signals_url.Set(
      trusted_bidding_signals_url_fragment.is_null() ? nullptr : trusted_bidding_signals_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->trusted_bidding_signals_slot_size_param)::BaseType> trusted_bidding_signals_slot_size_param_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_trusted_bidding_signals_slot_size_param, trusted_bidding_signals_slot_size_param_fragment);
  params->trusted_bidding_signals_slot_size_param.Set(
      trusted_bidding_signals_slot_size_param_fragment.is_null() ? nullptr : trusted_bidding_signals_slot_size_param_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->trusted_bidding_signals_slot_size_param.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trusted_bidding_signals_slot_size_param in AuctionWorkletService.LoadBidderWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_window_origin)::BaseType> top_window_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_window_origin, top_window_origin_fragment);
  params->top_window_origin.Set(
      top_window_origin_fragment.is_null() ? nullptr : top_window_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_window_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_window_origin in AuctionWorkletService.LoadBidderWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->permissions_policy_state)::BaseType> permissions_policy_state_fragment(
          params.message());
  mojo::internal::Serialize<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView>(
      in_permissions_policy_state, permissions_policy_state_fragment);
  params->permissions_policy_state.Set(
      permissions_policy_state_fragment.is_null() ? nullptr : permissions_policy_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->permissions_policy_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permissions_policy_state in AuctionWorkletService.LoadBidderWorklet request");
  params->experiment_group_id_$flag = in_experiment_group_id.has_value();
  if (in_experiment_group_id.has_value()) {
    params->experiment_group_id_$value = in_experiment_group_id.value();
  }
  mojo::internal::MessageFragment<
      typename decltype(params->public_key)::BaseType> public_key_fragment(
          params.message());
  mojo::internal::Serialize<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView>(
      in_public_key, public_key_fragment);
  params->public_key.Set(
      public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionWorkletService::Name_);
  message.set_method_name("LoadBidderWorklet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AuctionWorkletServiceProxy::LoadSellerWorklet(
    ::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet> in_seller_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> in_shared_storage_hosts, bool in_pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> in_auction_network_events_handler, const ::GURL& in_script_source_url, const std::optional<::GURL>& in_trusted_scoring_signals_url, const ::url::Origin& in_top_window_origin, AuctionWorkletPermissionsPolicyStatePtr in_permissions_policy_state, std::optional<uint16_t> in_experiment_group_id, std::optional<bool> in_send_creative_scanning_metadata, TrustedSignalsPublicKeyPtr in_public_key, ::mojo::PendingRemote<LoadSellerWorkletClient> in_load_seller_worklet_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionWorkletService::LoadSellerWorklet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seller_worklet"), in_seller_worklet,
                        "<value of type ::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_storage_hosts"), in_shared_storage_hosts,
                        "<value of type std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pause_for_debugger_on_start"), in_pause_for_debugger_on_start,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_network_events_handler"), in_auction_network_events_handler,
                        "<value of type ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_source_url"), in_script_source_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trusted_scoring_signals_url"), in_trusted_scoring_signals_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_window_origin"), in_top_window_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions_policy_state"), in_permissions_policy_state,
                        "<value of type AuctionWorkletPermissionsPolicyStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("experiment_group_id"), in_experiment_group_id,
                        "<value of type std::optional<uint16_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_creative_scanning_metadata"), in_send_creative_scanning_metadata,
                        "<value of type std::optional<bool>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("public_key"), in_public_key,
                        "<value of type TrustedSignalsPublicKeyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("load_seller_worklet_client"), in_load_seller_worklet_client,
                        "<value of type ::mojo::PendingRemote<LoadSellerWorkletClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionWorkletService::kLoadSellerWorklet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionWorkletService_LoadSellerWorklet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::auction_worklet::mojom::SellerWorkletInterfaceBase>>(
      in_seller_worklet, &params->seller_worklet, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->seller_worklet),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid seller_worklet in AuctionWorkletService.LoadSellerWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->shared_storage_hosts)::BaseType>
      shared_storage_hosts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& shared_storage_hosts_validate_params =
      mojo::internal::GetArrayValidator<0, true, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::auction_worklet::mojom::AuctionSharedStorageHostInterfaceBase>>>(
      in_shared_storage_hosts, shared_storage_hosts_fragment, &shared_storage_hosts_validate_params);
  params->shared_storage_hosts.Set(
      shared_storage_hosts_fragment.is_null() ? nullptr : shared_storage_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shared_storage_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_storage_hosts in AuctionWorkletService.LoadSellerWorklet request");
  params->pause_for_debugger_on_start = in_pause_for_debugger_on_start;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in AuctionWorkletService.LoadSellerWorklet request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::AuctionNetworkEventsHandlerInterfaceBase>>(
      in_auction_network_events_handler, &params->auction_network_events_handler, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->auction_network_events_handler),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid auction_network_events_handler in AuctionWorkletService.LoadSellerWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_source_url)::BaseType> script_source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_source_url, script_source_url_fragment);
  params->script_source_url.Set(
      script_source_url_fragment.is_null() ? nullptr : script_source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_source_url in AuctionWorkletService.LoadSellerWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->trusted_scoring_signals_url)::BaseType> trusted_scoring_signals_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_trusted_scoring_signals_url, trusted_scoring_signals_url_fragment);
  params->trusted_scoring_signals_url.Set(
      trusted_scoring_signals_url_fragment.is_null() ? nullptr : trusted_scoring_signals_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->top_window_origin)::BaseType> top_window_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_window_origin, top_window_origin_fragment);
  params->top_window_origin.Set(
      top_window_origin_fragment.is_null() ? nullptr : top_window_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_window_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_window_origin in AuctionWorkletService.LoadSellerWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->permissions_policy_state)::BaseType> permissions_policy_state_fragment(
          params.message());
  mojo::internal::Serialize<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView>(
      in_permissions_policy_state, permissions_policy_state_fragment);
  params->permissions_policy_state.Set(
      permissions_policy_state_fragment.is_null() ? nullptr : permissions_policy_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->permissions_policy_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permissions_policy_state in AuctionWorkletService.LoadSellerWorklet request");
  params->experiment_group_id_$flag = in_experiment_group_id.has_value();
  if (in_experiment_group_id.has_value()) {
    params->experiment_group_id_$value = in_experiment_group_id.value();
  }
  params->send_creative_scanning_metadata_$flag = in_send_creative_scanning_metadata.has_value();
  if (in_send_creative_scanning_metadata.has_value()) {
    params->send_creative_scanning_metadata_$value = in_send_creative_scanning_metadata.value();
  }
  mojo::internal::MessageFragment<
      typename decltype(params->public_key)::BaseType> public_key_fragment(
          params.message());
  mojo::internal::Serialize<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView>(
      in_public_key, public_key_fragment);
  params->public_key.Set(
      public_key_fragment.is_null() ? nullptr : public_key_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::LoadSellerWorkletClientInterfaceBase>>(
      in_load_seller_worklet_client, &params->load_seller_worklet_client, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionWorkletService::Name_);
  message.set_method_name("LoadSellerWorklet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AuctionWorkletServiceStubDispatch::Accept(
    AuctionWorkletService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AuctionWorkletService>(message->header()->name)) {
    case messages::AuctionWorkletService::kSetTrustedSignalsCache: {
      DCHECK(message->is_serialized());
      internal::AuctionWorkletService_SetTrustedSignalsCache_Params_Data* params =
          reinterpret_cast<internal::AuctionWorkletService_SetTrustedSignalsCache_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AuctionWorkletService.0
      bool success = true;
      ::mojo::PendingRemote<::auction_worklet::mojom::TrustedSignalsCache> p_trusted_signals_cache{};
      AuctionWorkletService_SetTrustedSignalsCache_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_trusted_signals_cache =
            input_data_view.TakeTrustedSignalsCache<decltype(p_trusted_signals_cache)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionWorkletService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTrustedSignalsCache(        
        std::move(p_trusted_signals_cache));
      return true;
    }
    case messages::AuctionWorkletService::kLoadBidderWorklet: {
      DCHECK(message->is_serialized());
      internal::AuctionWorkletService_LoadBidderWorklet_Params_Data* params =
          reinterpret_cast<internal::AuctionWorkletService_LoadBidderWorklet_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AuctionWorkletService.1
      bool success = true;
      ::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet> p_bidder_worklet{};
      std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> p_shared_storage_hosts{};
      bool p_pause_for_debugger_on_start{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> p_auction_network_events_handler{};
      ::GURL p_script_source_url{};
      std::optional<::GURL> p_wasm_helper_url{};
      std::optional<::GURL> p_trusted_bidding_signals_url{};
      std::string p_trusted_bidding_signals_slot_size_param{};
      ::url::Origin p_top_window_origin{};
      AuctionWorkletPermissionsPolicyStatePtr p_permissions_policy_state{};
      std::optional<uint16_t> p_experiment_group_id{};
      TrustedSignalsPublicKeyPtr p_public_key{};
      AuctionWorkletService_LoadBidderWorklet_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_bidder_worklet =
            input_data_view.TakeBidderWorklet<decltype(p_bidder_worklet)>();
      }
      if (success && !input_data_view.ReadSharedStorageHosts(&p_shared_storage_hosts))
        success = false;
      if (success)
        p_pause_for_debugger_on_start = input_data_view.pause_for_debugger_on_start();
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success) {
        p_auction_network_events_handler =
            input_data_view.TakeAuctionNetworkEventsHandler<decltype(p_auction_network_events_handler)>();
      }
      if (success && !input_data_view.ReadScriptSourceUrl(&p_script_source_url))
        success = false;
      if (success && !input_data_view.ReadWasmHelperUrl(&p_wasm_helper_url))
        success = false;
      if (success && !input_data_view.ReadTrustedBiddingSignalsUrl(&p_trusted_bidding_signals_url))
        success = false;
      if (success && !input_data_view.ReadTrustedBiddingSignalsSlotSizeParam(&p_trusted_bidding_signals_slot_size_param))
        success = false;
      if (success && !input_data_view.ReadTopWindowOrigin(&p_top_window_origin))
        success = false;
      if (success && !input_data_view.ReadPermissionsPolicyState(&p_permissions_policy_state))
        success = false;
      if (success) {
        p_experiment_group_id = input_data_view.experiment_group_id();
      }
      if (success && !input_data_view.ReadPublicKey(&p_public_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionWorkletService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadBidderWorklet(        
        std::move(p_bidder_worklet), 
        std::move(p_shared_storage_hosts), 
        std::move(p_pause_for_debugger_on_start), 
        std::move(p_url_loader_factory), 
        std::move(p_auction_network_events_handler), 
        std::move(p_script_source_url), 
        std::move(p_wasm_helper_url), 
        std::move(p_trusted_bidding_signals_url), 
        std::move(p_trusted_bidding_signals_slot_size_param), 
        std::move(p_top_window_origin), 
        std::move(p_permissions_policy_state), 
        std::move(p_experiment_group_id), 
        std::move(p_public_key));
      return true;
    }
    case messages::AuctionWorkletService::kLoadSellerWorklet: {
      DCHECK(message->is_serialized());
      internal::AuctionWorkletService_LoadSellerWorklet_Params_Data* params =
          reinterpret_cast<internal::AuctionWorkletService_LoadSellerWorklet_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AuctionWorkletService.2
      bool success = true;
      ::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet> p_seller_worklet{};
      std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> p_shared_storage_hosts{};
      bool p_pause_for_debugger_on_start{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> p_auction_network_events_handler{};
      ::GURL p_script_source_url{};
      std::optional<::GURL> p_trusted_scoring_signals_url{};
      ::url::Origin p_top_window_origin{};
      AuctionWorkletPermissionsPolicyStatePtr p_permissions_policy_state{};
      std::optional<uint16_t> p_experiment_group_id{};
      std::optional<bool> p_send_creative_scanning_metadata{};
      TrustedSignalsPublicKeyPtr p_public_key{};
      ::mojo::PendingRemote<LoadSellerWorkletClient> p_load_seller_worklet_client{};
      AuctionWorkletService_LoadSellerWorklet_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_seller_worklet =
            input_data_view.TakeSellerWorklet<decltype(p_seller_worklet)>();
      }
      if (success && !input_data_view.ReadSharedStorageHosts(&p_shared_storage_hosts))
        success = false;
      if (success)
        p_pause_for_debugger_on_start = input_data_view.pause_for_debugger_on_start();
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success) {
        p_auction_network_events_handler =
            input_data_view.TakeAuctionNetworkEventsHandler<decltype(p_auction_network_events_handler)>();
      }
      if (success && !input_data_view.ReadScriptSourceUrl(&p_script_source_url))
        success = false;
      if (success && !input_data_view.ReadTrustedScoringSignalsUrl(&p_trusted_scoring_signals_url))
        success = false;
      if (success && !input_data_view.ReadTopWindowOrigin(&p_top_window_origin))
        success = false;
      if (success && !input_data_view.ReadPermissionsPolicyState(&p_permissions_policy_state))
        success = false;
      if (success) {
        p_experiment_group_id = input_data_view.experiment_group_id();
      }
      if (success) {
        p_send_creative_scanning_metadata = input_data_view.send_creative_scanning_metadata();
      }
      if (success && !input_data_view.ReadPublicKey(&p_public_key))
        success = false;
      if (success) {
        p_load_seller_worklet_client =
            input_data_view.TakeLoadSellerWorkletClient<decltype(p_load_seller_worklet_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionWorkletService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadSellerWorklet(        
        std::move(p_seller_worklet), 
        std::move(p_shared_storage_hosts), 
        std::move(p_pause_for_debugger_on_start), 
        std::move(p_url_loader_factory), 
        std::move(p_auction_network_events_handler), 
        std::move(p_script_source_url), 
        std::move(p_trusted_scoring_signals_url), 
        std::move(p_top_window_origin), 
        std::move(p_permissions_policy_state), 
        std::move(p_experiment_group_id), 
        std::move(p_send_creative_scanning_metadata), 
        std::move(p_public_key), 
        std::move(p_load_seller_worklet_client));
      return true;
    }
  }
  return false;
}

// static
bool AuctionWorkletServiceStubDispatch::AcceptWithResponder(
    AuctionWorkletService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AuctionWorkletService>(message->header()->name)) {
    case messages::AuctionWorkletService::kSetTrustedSignalsCache: {
      break;
    }
    case messages::AuctionWorkletService::kLoadBidderWorklet: {
      break;
    }
    case messages::AuctionWorkletService::kLoadSellerWorklet: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAuctionWorkletServiceValidationInfo[] = {
    {base::to_underlying(messages::AuctionWorkletService::kSetTrustedSignalsCache),
     { &internal::AuctionWorkletService_SetTrustedSignalsCache_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AuctionWorkletService::kLoadBidderWorklet),
     { &internal::AuctionWorkletService_LoadBidderWorklet_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AuctionWorkletService::kLoadSellerWorklet),
     { &internal::AuctionWorkletService_LoadSellerWorklet_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AuctionWorkletServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::AuctionWorkletService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAuctionWorkletServiceValidationInfo);
}



}  // auction_worklet::mojom


namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::BrowserSignals::DataView, ::auction_worklet::mojom::BrowserSignalsPtr>::Read(
    ::auction_worklet::mojom::BrowserSignals::DataView input,
    ::auction_worklet::mojom::BrowserSignalsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BrowserSignalsPtr result(::auction_worklet::mojom::BrowserSignals::New());
  
      if (success && !input.ReadTopFrameOrigin(&result->top_frame_origin))
        success = false;
      if (success && !input.ReadSeller(&result->seller))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyState::DataView, ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr>::Read(
    ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyState::DataView input,
    ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr* output) {
  bool success = true;
  ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr result(::auction_worklet::mojom::AuctionWorkletPermissionsPolicyState::New());
  
      if (success)
        result->private_aggregation_allowed = input.private_aggregation_allowed();
      if (success)
        result->shared_storage_allowed = input.shared_storage_allowed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::TrustedSignalsPublicKey::DataView, ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr>::Read(
    ::auction_worklet::mojom::TrustedSignalsPublicKey::DataView input,
    ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr result(::auction_worklet::mojom::TrustedSignalsPublicKey::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {


void LoadSellerWorkletClientInterceptorForTesting::SellerWorkletLoaded(bool trusted_signals_url_allowed) {
  GetForwardingInterface()->SellerWorkletLoaded(
    std::move(trusted_signals_url_allowed)
    );
}
LoadSellerWorkletClientAsyncWaiter::LoadSellerWorkletClientAsyncWaiter(
    LoadSellerWorkletClient* proxy) : proxy_(proxy) {}

LoadSellerWorkletClientAsyncWaiter::~LoadSellerWorkletClientAsyncWaiter() = default;




void AuctionWorkletServiceInterceptorForTesting::SetTrustedSignalsCache(::mojo::PendingRemote<::auction_worklet::mojom::TrustedSignalsCache> trusted_signals_cache) {
  GetForwardingInterface()->SetTrustedSignalsCache(
    std::move(trusted_signals_cache)
    );
}
void AuctionWorkletServiceInterceptorForTesting::LoadBidderWorklet(::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet> bidder_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> shared_storage_hosts, bool pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> auction_network_events_handler, const ::GURL& script_source_url, const std::optional<::GURL>& wasm_helper_url, const std::optional<::GURL>& trusted_bidding_signals_url, const std::string& trusted_bidding_signals_slot_size_param, const ::url::Origin& top_window_origin, AuctionWorkletPermissionsPolicyStatePtr permissions_policy_state, std::optional<uint16_t> experiment_group_id, TrustedSignalsPublicKeyPtr public_key) {
  GetForwardingInterface()->LoadBidderWorklet(
    std::move(bidder_worklet)
    , 
    std::move(shared_storage_hosts)
    , 
    std::move(pause_for_debugger_on_start)
    , 
    std::move(url_loader_factory)
    , 
    std::move(auction_network_events_handler)
    , 
    std::move(script_source_url)
    , 
    std::move(wasm_helper_url)
    , 
    std::move(trusted_bidding_signals_url)
    , 
    std::move(trusted_bidding_signals_slot_size_param)
    , 
    std::move(top_window_origin)
    , 
    std::move(permissions_policy_state)
    , 
    std::move(experiment_group_id)
    , 
    std::move(public_key)
    );
}
void AuctionWorkletServiceInterceptorForTesting::LoadSellerWorklet(::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet> seller_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> shared_storage_hosts, bool pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> auction_network_events_handler, const ::GURL& script_source_url, const std::optional<::GURL>& trusted_scoring_signals_url, const ::url::Origin& top_window_origin, AuctionWorkletPermissionsPolicyStatePtr permissions_policy_state, std::optional<uint16_t> experiment_group_id, std::optional<bool> send_creative_scanning_metadata, TrustedSignalsPublicKeyPtr public_key, ::mojo::PendingRemote<LoadSellerWorkletClient> load_seller_worklet_client) {
  GetForwardingInterface()->LoadSellerWorklet(
    std::move(seller_worklet)
    , 
    std::move(shared_storage_hosts)
    , 
    std::move(pause_for_debugger_on_start)
    , 
    std::move(url_loader_factory)
    , 
    std::move(auction_network_events_handler)
    , 
    std::move(script_source_url)
    , 
    std::move(trusted_scoring_signals_url)
    , 
    std::move(top_window_origin)
    , 
    std::move(permissions_policy_state)
    , 
    std::move(experiment_group_id)
    , 
    std::move(send_creative_scanning_metadata)
    , 
    std::move(public_key)
    , 
    std::move(load_seller_worklet_client)
    );
}
AuctionWorkletServiceAsyncWaiter::AuctionWorkletServiceAsyncWaiter(
    AuctionWorkletService* proxy) : proxy_(proxy) {}

AuctionWorkletServiceAsyncWaiter::~AuctionWorkletServiceAsyncWaiter() = default;






}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif