// components/services/storage/public/mojom/buckets/bucket_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_INFO_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/buckets/bucket_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared.h"







namespace storage::mojom {
class BucketInfoDataView;



}  // storage::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::BucketInfoDataView> {
  using Data = ::storage::mojom::internal::BucketInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


class BucketInfoDataView {
 public:
  BucketInfoDataView() = default;

  BucketInfoDataView(
      internal::BucketInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetStorageKeyDataView(
      ::blink::mojom::StorageKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageKey(UserType* output) {
    
    auto* pointer = data_->storage_key.Get();
    return mojo::internal::Deserialize<::blink::mojom::StorageKeyDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::StorageType>(
        data_value, output);
  }
  ::blink::mojom::StorageType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::StorageType>(data_->type));
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  uint64_t quota() const {
    return data_->quota;
  }
  bool persistent() const {
    return data_->persistent;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDurability(UserType* output) const {
    auto data_value = data_->durability;
    return mojo::internal::Deserialize<::blink::mojom::BucketDurability>(
        data_value, output);
  }
  ::blink::mojom::BucketDurability durability() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::BucketDurability>(data_->durability));
  }
 private:
  internal::BucketInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BucketInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BucketInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::BucketInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    decltype(Traits::storage_key(input)) in_storage_key = Traits::storage_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage_key)::BaseType> storage_key_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
        in_storage_key, storage_key_fragment);
    fragment->storage_key.Set(
        storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->storage_key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null storage_key in BucketInfo struct");
    mojo::internal::Serialize<::blink::mojom::StorageType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in BucketInfo struct");
    decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration)::BaseType> expiration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expiration, expiration_fragment);
    fragment->expiration.Set(
        expiration_fragment.is_null() ? nullptr : expiration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->expiration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration in BucketInfo struct");
    fragment->quota = Traits::quota(input);
    fragment->persistent = Traits::persistent(input);
    mojo::internal::Serialize<::blink::mojom::BucketDurability>(
        Traits::durability(input), &fragment->durability);
  }

  static bool Deserialize(::storage::mojom::internal::BucketInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::BucketInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void BucketInfoDataView::GetStorageKeyDataView(
    ::blink::mojom::StorageKeyDataView* output) {
  auto pointer = data_->storage_key.Get();
  *output = ::blink::mojom::StorageKeyDataView(pointer, message_);
}
inline void BucketInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BucketInfoDataView::GetExpirationDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiration.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_INFO_MOJOM_SHARED_H_