// ui/gfx/mojom/display_color_spaces.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-blink-forward.h"
#include "ui/gfx/mojom/buffer_types.mojom-blink.h"
#include "ui/gfx/mojom/color_space.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"








namespace WTF {
struct gfx_mojom_internal_ContentColorUsage_DataHashFn {
  static unsigned GetHash(const ::gfx::mojom::ContentColorUsage& value) {
    using utype = std::underlying_type<::gfx::mojom::ContentColorUsage>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::gfx::mojom::ContentColorUsage& left, const ::gfx::mojom::ContentColorUsage& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::gfx::mojom::ContentColorUsage>
    : public GenericHashTraits<::gfx::mojom::ContentColorUsage> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::gfx::mojom::ContentColorUsage& value) {
    return value == static_cast<::gfx::mojom::ContentColorUsage>(-1000000);
  }
  static void ConstructDeletedValue(::gfx::mojom::ContentColorUsage& slot, bool) {
    slot = static_cast<::gfx::mojom::ContentColorUsage>(-1000001);
  }
  static bool IsDeletedValue(const ::gfx::mojom::ContentColorUsage& value) {
    return value == static_cast<::gfx::mojom::ContentColorUsage>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace gfx {
namespace mojom {
namespace blink {








class  DisplayColorSpaces {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisplayColorSpaces, T>::value>;
  using DataView = DisplayColorSpacesDataView;
  using Data_ = internal::DisplayColorSpaces_Data;

  template <typename... Args>
  static DisplayColorSpacesPtr New(Args&&... args) {
    return DisplayColorSpacesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplayColorSpacesPtr From(const U& u) {
    return mojo::TypeConverter<DisplayColorSpacesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisplayColorSpaces>::Convert(*this);
  }


  DisplayColorSpaces();

  DisplayColorSpaces(
      WTF::Vector<::gfx::ColorSpace> color_spaces,
      WTF::Vector<::gfx::BufferFormat> buffer_formats,
      float sdr_white_level);

  ~DisplayColorSpaces();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplayColorSpacesPtr>
  DisplayColorSpacesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayColorSpaces::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisplayColorSpaces::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisplayColorSpaces_UnserializedMessageContext<
            UserType, DisplayColorSpaces::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DisplayColorSpaces::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DisplayColorSpaces::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisplayColorSpaces_UnserializedMessageContext<
            UserType, DisplayColorSpaces::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisplayColorSpaces::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<::gfx::ColorSpace> color_spaces;
  
  WTF::Vector<::gfx::BufferFormat> buffer_formats;
  
  float sdr_white_level;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DisplayColorSpacesPtr DisplayColorSpaces::Clone() const {
  return New(
      mojo::Clone(color_spaces),
      mojo::Clone(buffer_formats),
      mojo::Clone(sdr_white_level)
  );
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>*>
bool DisplayColorSpaces::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color_spaces, other_struct.color_spaces))
    return false;
  if (!mojo::Equals(this->buffer_formats, other_struct.buffer_formats))
    return false;
  if (!mojo::Equals(this->sdr_white_level, other_struct.sdr_white_level))
    return false;
  return true;
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.color_spaces, rhs.color_spaces))
    return true;
  if (std::less<>{}(rhs.color_spaces, lhs.color_spaces))
    return false;
  if (std::less<>{}(lhs.buffer_formats, rhs.buffer_formats))
    return true;
  if (std::less<>{}(rhs.buffer_formats, lhs.buffer_formats))
    return false;
  if (std::less<>{}(lhs.sdr_white_level, rhs.sdr_white_level))
    return true;
  if (std::less<>{}(rhs.sdr_white_level, lhs.sdr_white_level))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace gfx

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::DisplayColorSpaces::DataView,
                                         ::gfx::mojom::blink::DisplayColorSpacesPtr> {
  static bool IsNull(const ::gfx::mojom::blink::DisplayColorSpacesPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::DisplayColorSpacesPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::blink::DisplayColorSpaces::color_spaces)& color_spaces(
      const ::gfx::mojom::blink::DisplayColorSpacesPtr& input) {
    return input->color_spaces;
  }

  static const decltype(::gfx::mojom::blink::DisplayColorSpaces::buffer_formats)& buffer_formats(
      const ::gfx::mojom::blink::DisplayColorSpacesPtr& input) {
    return input->buffer_formats;
  }

  static decltype(::gfx::mojom::blink::DisplayColorSpaces::sdr_white_level) sdr_white_level(
      const ::gfx::mojom::blink::DisplayColorSpacesPtr& input) {
    return input->sdr_white_level;
  }

  static bool Read(::gfx::mojom::blink::DisplayColorSpaces::DataView input, ::gfx::mojom::blink::DisplayColorSpacesPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_BLINK_H_