// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-params-data.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
PushSubscriptionOptions::PushSubscriptionOptions()
    : user_visible_only(),
      application_server_key() {}

PushSubscriptionOptions::PushSubscriptionOptions(
    bool user_visible_only_in,
    WTF::Vector<uint8_t> application_server_key_in)
    : user_visible_only(std::move(user_visible_only_in)),
      application_server_key(std::move(application_server_key_in)) {}

PushSubscriptionOptions::~PushSubscriptionOptions() = default;

void PushSubscriptionOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("user_visible_only", this->user_visible_only);
  value->BeginArray("application_server_key");
  for (const auto& item0 : this->application_server_key) {
    value->AppendInteger(item0);
  }
  value->EndArray();
}

bool PushSubscriptionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PushSubscription::PushSubscription()
    : endpoint(),
      expirationTime(),
      options(),
      p256dh(),
      auth() {}

PushSubscription::PushSubscription(
    const ::blink::KURL& endpoint_in,
    base::Optional<::base::Time> expirationTime_in,
    PushSubscriptionOptionsPtr options_in,
    WTF::Vector<uint8_t> p256dh_in,
    WTF::Vector<uint8_t> auth_in)
    : endpoint(std::move(endpoint_in)),
      expirationTime(std::move(expirationTime_in)),
      options(std::move(options_in)),
      p256dh(std::move(p256dh_in)),
      auth(std::move(auth_in)) {}

PushSubscription::~PushSubscription() = default;

void PushSubscription::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("endpoint", base::trace_event::ValueToString(this->endpoint, "<value of type const ::blink::KURL&>"));
  value->SetString("expirationTime", base::trace_event::ValueToString(this->expirationTime, "<value of type base::Optional<::base::Time>>"));
  if (this->options.is_null()) {
    value->SetString("options", "nullptr");
  } else {
    value->BeginDictionary("options");
    this->options->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("p256dh");
  for (const auto& item0 : this->p256dh) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("auth");
  for (const auto& item0 : this->auth) {
    value->AppendInteger(item0);
  }
  value->EndArray();
}

bool PushSubscription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PushMessaging::Name_[] = "blink.mojom.PushMessaging";

class PushMessaging_Subscribe_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushMessaging_Subscribe_ForwardToCallback(
      PushMessaging::SubscribeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushMessaging::SubscribeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushMessaging_Subscribe_ForwardToCallback);
};

class PushMessaging_Unsubscribe_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushMessaging_Unsubscribe_ForwardToCallback(
      PushMessaging::UnsubscribeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushMessaging::UnsubscribeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushMessaging_Unsubscribe_ForwardToCallback);
};

class PushMessaging_GetSubscription_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushMessaging_GetSubscription_ForwardToCallback(
      PushMessaging::GetSubscriptionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushMessaging::GetSubscriptionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushMessaging_GetSubscription_ForwardToCallback);
};

PushMessagingProxy::PushMessagingProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PushMessagingProxy::Subscribe(
    int64_t in_service_worker_registration_id, PushSubscriptionOptionsPtr in_options, bool in_user_gesture, SubscribeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PushMessaging::Subscribe", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("service_worker_registration_id", base::NumberToString(in_service_worker_registration_id));
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("user_gesture", in_user_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushMessaging_Subscribe_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PushMessaging_Subscribe_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->service_worker_registration_id = in_service_worker_registration_id;
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in PushMessaging.Subscribe request");
  params->user_gesture = in_user_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Subscribe");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushMessaging_Subscribe_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PushMessagingProxy::Unsubscribe(
    int64_t in_service_worker_registration_id, UnsubscribeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PushMessaging::Unsubscribe", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("service_worker_registration_id", base::NumberToString(in_service_worker_registration_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushMessaging_Unsubscribe_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PushMessaging_Unsubscribe_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->service_worker_registration_id = in_service_worker_registration_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Unsubscribe");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushMessaging_Unsubscribe_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PushMessagingProxy::GetSubscription(
    int64_t in_service_worker_registration_id, GetSubscriptionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PushMessaging::GetSubscription", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("service_worker_registration_id", base::NumberToString(in_service_worker_registration_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushMessaging_GetSubscription_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PushMessaging_GetSubscription_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->service_worker_registration_id = in_service_worker_registration_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("GetSubscription");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushMessaging_GetSubscription_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PushMessaging_Subscribe_ProxyToResponder {
 public:
  static PushMessaging::SubscribeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushMessaging_Subscribe_ProxyToResponder> proxy(
        new PushMessaging_Subscribe_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushMessaging_Subscribe_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushMessaging_Subscribe_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushMessaging_Subscribe_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushMessaging::SubscribeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PushRegistrationStatus in_status, PushSubscriptionPtr in_subscription);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushMessaging_Subscribe_ProxyToResponder);
};

bool PushMessaging_Subscribe_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PushMessaging::SubscribeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushMessaging_Subscribe_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushMessaging_Subscribe_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::PushRegistrationStatus p_status{};
  PushSubscriptionPtr p_subscription{};
  PushMessaging_Subscribe_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadSubscription(&p_subscription))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushMessaging::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_subscription));
  return true;
}

void PushMessaging_Subscribe_ProxyToResponder::Run(
    ::blink::mojom::blink::PushRegistrationStatus in_status, PushSubscriptionPtr in_subscription) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PushMessaging::SubscribeCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      if (in_subscription.is_null()) {
        raw_value->SetString("subscription", "nullptr");
      } else {
        raw_value->BeginDictionary("subscription");
        in_subscription->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushMessaging_Subscribe_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PushMessaging_Subscribe_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PushRegistrationStatus>(
      in_status, &params->status);
  typename decltype(params->subscription)::BaseType::BufferWriter
      subscription_writer;
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
      in_subscription, buffer, &subscription_writer, &serialization_context);
  params->subscription.Set(
      subscription_writer.is_null() ? nullptr : subscription_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PushMessaging::SubscribeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Subscribe");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushMessaging_Unsubscribe_ProxyToResponder {
 public:
  static PushMessaging::UnsubscribeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushMessaging_Unsubscribe_ProxyToResponder> proxy(
        new PushMessaging_Unsubscribe_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushMessaging_Unsubscribe_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushMessaging_Unsubscribe_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushMessaging_Unsubscribe_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushMessaging::UnsubscribeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PushErrorType in_error_type, bool in_did_unsubscribe, const WTF::String& in_error_message);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushMessaging_Unsubscribe_ProxyToResponder);
};

bool PushMessaging_Unsubscribe_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PushMessaging::UnsubscribeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushMessaging_Unsubscribe_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushMessaging_Unsubscribe_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PushErrorType p_error_type{};
  bool p_did_unsubscribe{};
  WTF::String p_error_message{};
  PushMessaging_Unsubscribe_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadErrorType(&p_error_type))
    success = false;
  if (success)
    p_did_unsubscribe = input_data_view.did_unsubscribe();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushMessaging::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error_type), 
std::move(p_did_unsubscribe), 
std::move(p_error_message));
  return true;
}

void PushMessaging_Unsubscribe_ProxyToResponder::Run(
    PushErrorType in_error_type, bool in_did_unsubscribe, const WTF::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PushMessaging::UnsubscribeCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error_type", base::trace_event::ValueToString(in_error_type));
      raw_value->SetBoolean("did_unsubscribe", in_did_unsubscribe);
      raw_value->SetString("error_message", in_error_message.Utf8());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushMessaging_Unsubscribe_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PushMessaging_Unsubscribe_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PushErrorType>(
      in_error_type, &params->error_type);
  params->did_unsubscribe = in_did_unsubscribe;
  typename decltype(params->error_message)::BaseType::BufferWriter
      error_message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, buffer, &error_message_writer, &serialization_context);
  params->error_message.Set(
      error_message_writer.is_null() ? nullptr : error_message_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PushMessaging::UnsubscribeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Unsubscribe");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushMessaging_GetSubscription_ProxyToResponder {
 public:
  static PushMessaging::GetSubscriptionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushMessaging_GetSubscription_ProxyToResponder> proxy(
        new PushMessaging_GetSubscription_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushMessaging_GetSubscription_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushMessaging_GetSubscription_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushMessaging_GetSubscription_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushMessaging::GetSubscriptionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PushGetRegistrationStatus in_status, PushSubscriptionPtr in_subscription);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushMessaging_GetSubscription_ProxyToResponder);
};

bool PushMessaging_GetSubscription_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PushMessaging::GetSubscriptionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushMessaging_GetSubscription_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushMessaging_GetSubscription_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::PushGetRegistrationStatus p_status{};
  PushSubscriptionPtr p_subscription{};
  PushMessaging_GetSubscription_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadSubscription(&p_subscription))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushMessaging::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_subscription));
  return true;
}

void PushMessaging_GetSubscription_ProxyToResponder::Run(
    ::blink::mojom::blink::PushGetRegistrationStatus in_status, PushSubscriptionPtr in_subscription) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PushMessaging::GetSubscriptionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      if (in_subscription.is_null()) {
        raw_value->SetString("subscription", "nullptr");
      } else {
        raw_value->BeginDictionary("subscription");
        in_subscription->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushMessaging_GetSubscription_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PushMessaging_GetSubscription_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PushGetRegistrationStatus>(
      in_status, &params->status);
  typename decltype(params->subscription)::BaseType::BufferWriter
      subscription_writer;
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
      in_subscription, buffer, &subscription_writer, &serialization_context);
  params->subscription.Set(
      subscription_writer.is_null() ? nullptr : subscription_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PushMessaging::GetSubscriptionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("GetSubscription");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PushMessagingStubDispatch::Accept(
    PushMessaging* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPushMessaging_Subscribe_Name: {
      break;
    }
    case internal::kPushMessaging_Unsubscribe_Name: {
      break;
    }
    case internal::kPushMessaging_GetSubscription_Name: {
      break;
    }
  }
  return false;
}

// static
bool PushMessagingStubDispatch::AcceptWithResponder(
    PushMessaging* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPushMessaging_Subscribe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PushMessaging::Subscribe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PushMessaging::Subscribe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushMessaging_Subscribe_Params_Data* params =
          reinterpret_cast<
              internal::PushMessaging_Subscribe_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PushSubscriptionOptionsPtr p_options{};
      bool p_user_gesture{};
      PushMessaging_Subscribe_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushMessaging::Name_, 0, false);
        return false;
      }
      PushMessaging::SubscribeCallback callback =
          PushMessaging_Subscribe_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Subscribe(
std::move(p_service_worker_registration_id), 
std::move(p_options), 
std::move(p_user_gesture), std::move(callback));
      return true;
    }
    case internal::kPushMessaging_Unsubscribe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PushMessaging::Unsubscribe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PushMessaging::Unsubscribe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushMessaging_Unsubscribe_Params_Data* params =
          reinterpret_cast<
              internal::PushMessaging_Unsubscribe_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PushMessaging_Unsubscribe_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushMessaging::Name_, 1, false);
        return false;
      }
      PushMessaging::UnsubscribeCallback callback =
          PushMessaging_Unsubscribe_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unsubscribe(
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
    case internal::kPushMessaging_GetSubscription_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PushMessaging::GetSubscription",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PushMessaging::GetSubscription");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushMessaging_GetSubscription_Params_Data* params =
          reinterpret_cast<
              internal::PushMessaging_GetSubscription_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PushMessaging_GetSubscription_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushMessaging::Name_, 2, false);
        return false;
      }
      PushMessaging::GetSubscriptionCallback callback =
          PushMessaging_GetSubscription_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSubscription(
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPushMessagingValidationInfo[] = {
    {&internal::PushMessaging_Subscribe_Params_Data::Validate,
     &internal::PushMessaging_Subscribe_ResponseParams_Data::Validate},
    {&internal::PushMessaging_Unsubscribe_Params_Data::Validate,
     &internal::PushMessaging_Unsubscribe_ResponseParams_Data::Validate},
    {&internal::PushMessaging_GetSubscription_Params_Data::Validate,
     &internal::PushMessaging_GetSubscription_ResponseParams_Data::Validate},
};

bool PushMessagingRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PushMessaging::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPushMessagingValidationInfo);
}

bool PushMessagingResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PushMessaging::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPushMessagingValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PushSubscriptionOptions::DataView, ::blink::mojom::blink::PushSubscriptionOptionsPtr>::Read(
    ::blink::mojom::blink::PushSubscriptionOptions::DataView input,
    ::blink::mojom::blink::PushSubscriptionOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PushSubscriptionOptionsPtr result(::blink::mojom::blink::PushSubscriptionOptions::New());
  
      if (success)
        result->user_visible_only = input.user_visible_only();
      if (success && !input.ReadApplicationServerKey(&result->application_server_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PushSubscription::DataView, ::blink::mojom::blink::PushSubscriptionPtr>::Read(
    ::blink::mojom::blink::PushSubscription::DataView input,
    ::blink::mojom::blink::PushSubscriptionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PushSubscriptionPtr result(::blink::mojom::blink::PushSubscription::New());
  
      if (success && !input.ReadEndpoint(&result->endpoint))
        success = false;
      if (success && !input.ReadExpirationTime(&result->expirationTime))
        success = false;
      if (success && !input.ReadOptions(&result->options))
        success = false;
      if (success && !input.ReadP256dh(&result->p256dh))
        success = false;
      if (success && !input.ReadAuth(&result->auth))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif