// third_party/blink/public/mojom/frame/frame_policy.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-forward.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/document_policy_feature.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy_feature.mojom-forward.h"
#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/common/frame/frame_policy_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {








class BLINK_COMMON_EXPORT FramePolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FramePolicy, T>::value>;
  using DataView = FramePolicyDataView;
  using Data_ = internal::FramePolicy_Data;

  template <typename... Args>
  static FramePolicyPtr New(Args&&... args) {
    return FramePolicyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FramePolicyPtr From(const U& u) {
    return mojo::TypeConverter<FramePolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FramePolicy>::Convert(*this);
  }


  FramePolicy();

  FramePolicy(
      ::network::mojom::WebSandboxFlags sandbox_flags,
      std::vector<::blink::ParsedFeaturePolicyDeclaration> container_policy,
      const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& required_document_policy,
      bool allowed_to_download,
      bool disallow_document_access);

  ~FramePolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FramePolicyPtr>
  FramePolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FramePolicy::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FramePolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FramePolicy_UnserializedMessageContext<
            UserType, FramePolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FramePolicy::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FramePolicy::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FramePolicy_UnserializedMessageContext<
            UserType, FramePolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FramePolicy::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::network::mojom::WebSandboxFlags sandbox_flags;
  
  std::vector<::blink::ParsedFeaturePolicyDeclaration> container_policy;
  
  base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue> required_document_policy;
  
  bool allowed_to_download;
  
  bool disallow_document_access;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FramePolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FramePolicyPtr FramePolicy::Clone() const {
  return New(
      mojo::Clone(sandbox_flags),
      mojo::Clone(container_policy),
      mojo::Clone(required_document_policy),
      mojo::Clone(allowed_to_download),
      mojo::Clone(disallow_document_access)
  );
}

template <typename T, FramePolicy::EnableIfSame<T>*>
bool FramePolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sandbox_flags, other_struct.sandbox_flags))
    return false;
  if (!mojo::Equals(this->container_policy, other_struct.container_policy))
    return false;
  if (!mojo::Equals(this->required_document_policy, other_struct.required_document_policy))
    return false;
  if (!mojo::Equals(this->allowed_to_download, other_struct.allowed_to_download))
    return false;
  if (!mojo::Equals(this->disallow_document_access, other_struct.disallow_document_access))
    return false;
  return true;
}

template <typename T, FramePolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.sandbox_flags, rhs.sandbox_flags))
    return true;
  if (std::less<>{}(rhs.sandbox_flags, lhs.sandbox_flags))
    return false;
  if (std::less<>{}(lhs.container_policy, rhs.container_policy))
    return true;
  if (std::less<>{}(rhs.container_policy, lhs.container_policy))
    return false;
  if (std::less<>{}(lhs.required_document_policy, rhs.required_document_policy))
    return true;
  if (std::less<>{}(rhs.required_document_policy, lhs.required_document_policy))
    return false;
  if (std::less<>{}(lhs.allowed_to_download, rhs.allowed_to_download))
    return true;
  if (std::less<>{}(rhs.allowed_to_download, lhs.allowed_to_download))
    return false;
  if (std::less<>{}(lhs.disallow_document_access, rhs.disallow_document_access))
    return true;
  if (std::less<>{}(rhs.disallow_document_access, lhs.disallow_document_access))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FramePolicy::DataView,
                                         ::blink::mojom::FramePolicyPtr> {
  static bool IsNull(const ::blink::mojom::FramePolicyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FramePolicyPtr* output) { output->reset(); }

  static decltype(::blink::mojom::FramePolicy::sandbox_flags) sandbox_flags(
      const ::blink::mojom::FramePolicyPtr& input) {
    return input->sandbox_flags;
  }

  static const decltype(::blink::mojom::FramePolicy::container_policy)& container_policy(
      const ::blink::mojom::FramePolicyPtr& input) {
    return input->container_policy;
  }

  static const decltype(::blink::mojom::FramePolicy::required_document_policy)& required_document_policy(
      const ::blink::mojom::FramePolicyPtr& input) {
    return input->required_document_policy;
  }

  static decltype(::blink::mojom::FramePolicy::allowed_to_download) allowed_to_download(
      const ::blink::mojom::FramePolicyPtr& input) {
    return input->allowed_to_download;
  }

  static decltype(::blink::mojom::FramePolicy::disallow_document_access) disallow_document_access(
      const ::blink::mojom::FramePolicyPtr& input) {
    return input->disallow_document_access;
  }

  static bool Read(::blink::mojom::FramePolicy::DataView input, ::blink::mojom::FramePolicyPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_H_