// services/network/public/mojom/http_raw_request_response_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_REQUEST_RESPONSE_INFO_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_REQUEST_RESPONSE_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/http_raw_request_response_info.mojom-shared.h"
#include "services/network/public/mojom/http_raw_request_response_info.mojom-blink-forward.h"
#include "services/network/public/mojom/http_raw_headers.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {
namespace blink {








class BLINK_PLATFORM_EXPORT HttpRawRequestResponseInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpRawRequestResponseInfo, T>::value>;
  using DataView = HttpRawRequestResponseInfoDataView;
  using Data_ = internal::HttpRawRequestResponseInfo_Data;

  template <typename... Args>
  static HttpRawRequestResponseInfoPtr New(Args&&... args) {
    return HttpRawRequestResponseInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpRawRequestResponseInfoPtr From(const U& u) {
    return mojo::TypeConverter<HttpRawRequestResponseInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpRawRequestResponseInfo>::Convert(*this);
  }


  HttpRawRequestResponseInfo();

  HttpRawRequestResponseInfo(
      int32_t http_status_code,
      const WTF::String& http_status_text,
      WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> request_headers,
      WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> response_headers,
      const WTF::String& request_headers_text,
      const WTF::String& response_headers_text);

  ~HttpRawRequestResponseInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpRawRequestResponseInfoPtr>
  HttpRawRequestResponseInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpRawRequestResponseInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpRawRequestResponseInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpRawRequestResponseInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpRawRequestResponseInfo_UnserializedMessageContext<
            UserType, HttpRawRequestResponseInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HttpRawRequestResponseInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return HttpRawRequestResponseInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpRawRequestResponseInfo_UnserializedMessageContext<
            UserType, HttpRawRequestResponseInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpRawRequestResponseInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t http_status_code;
  
  WTF::String http_status_text;
  
  WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> request_headers;
  
  WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> response_headers;
  
  WTF::String request_headers_text;
  
  WTF::String response_headers_text;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HttpRawRequestResponseInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpRawRequestResponseInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpRawRequestResponseInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpRawRequestResponseInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpRawRequestResponseInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HttpRawRequestResponseInfoPtr HttpRawRequestResponseInfo::Clone() const {
  return New(
      mojo::Clone(http_status_code),
      mojo::Clone(http_status_text),
      mojo::Clone(request_headers),
      mojo::Clone(response_headers),
      mojo::Clone(request_headers_text),
      mojo::Clone(response_headers_text)
  );
}

template <typename T, HttpRawRequestResponseInfo::EnableIfSame<T>*>
bool HttpRawRequestResponseInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->http_status_code, other_struct.http_status_code))
    return false;
  if (!mojo::Equals(this->http_status_text, other_struct.http_status_text))
    return false;
  if (!mojo::Equals(this->request_headers, other_struct.request_headers))
    return false;
  if (!mojo::Equals(this->response_headers, other_struct.response_headers))
    return false;
  if (!mojo::Equals(this->request_headers_text, other_struct.request_headers_text))
    return false;
  if (!mojo::Equals(this->response_headers_text, other_struct.response_headers_text))
    return false;
  return true;
}

template <typename T, HttpRawRequestResponseInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.http_status_code, rhs.http_status_code))
    return true;
  if (std::less<>{}(rhs.http_status_code, lhs.http_status_code))
    return false;
  if (std::less<>{}(lhs.http_status_text, rhs.http_status_text))
    return true;
  if (std::less<>{}(rhs.http_status_text, lhs.http_status_text))
    return false;
  if (std::less<>{}(lhs.request_headers, rhs.request_headers))
    return true;
  if (std::less<>{}(rhs.request_headers, lhs.request_headers))
    return false;
  if (std::less<>{}(lhs.response_headers, rhs.response_headers))
    return true;
  if (std::less<>{}(rhs.response_headers, lhs.response_headers))
    return false;
  if (std::less<>{}(lhs.request_headers_text, rhs.request_headers_text))
    return true;
  if (std::less<>{}(rhs.request_headers_text, lhs.request_headers_text))
    return false;
  if (std::less<>{}(lhs.response_headers_text, rhs.response_headers_text))
    return true;
  if (std::less<>{}(rhs.response_headers_text, lhs.response_headers_text))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::HttpRawRequestResponseInfo::DataView,
                                         ::network::mojom::blink::HttpRawRequestResponseInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::HttpRawRequestResponseInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::HttpRawRequestResponseInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::HttpRawRequestResponseInfo::http_status_code) http_status_code(
      const ::network::mojom::blink::HttpRawRequestResponseInfoPtr& input) {
    return input->http_status_code;
  }

  static const decltype(::network::mojom::blink::HttpRawRequestResponseInfo::http_status_text)& http_status_text(
      const ::network::mojom::blink::HttpRawRequestResponseInfoPtr& input) {
    return input->http_status_text;
  }

  static const decltype(::network::mojom::blink::HttpRawRequestResponseInfo::request_headers)& request_headers(
      const ::network::mojom::blink::HttpRawRequestResponseInfoPtr& input) {
    return input->request_headers;
  }

  static const decltype(::network::mojom::blink::HttpRawRequestResponseInfo::response_headers)& response_headers(
      const ::network::mojom::blink::HttpRawRequestResponseInfoPtr& input) {
    return input->response_headers;
  }

  static const decltype(::network::mojom::blink::HttpRawRequestResponseInfo::request_headers_text)& request_headers_text(
      const ::network::mojom::blink::HttpRawRequestResponseInfoPtr& input) {
    return input->request_headers_text;
  }

  static const decltype(::network::mojom::blink::HttpRawRequestResponseInfo::response_headers_text)& response_headers_text(
      const ::network::mojom::blink::HttpRawRequestResponseInfoPtr& input) {
    return input->response_headers_text;
  }

  static bool Read(::network::mojom::blink::HttpRawRequestResponseInfo::DataView input, ::network::mojom::blink::HttpRawRequestResponseInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_REQUEST_RESPONSE_INFO_MOJOM_BLINK_H_