// services/network/public/mojom/client_security_state.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-forward.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include <string>
#include <vector>







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {








class  ClientSecurityState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClientSecurityState, T>::value>;
  using DataView = ClientSecurityStateDataView;
  using Data_ = internal::ClientSecurityState_Data;

  template <typename... Args>
  static ClientSecurityStatePtr New(Args&&... args) {
    return ClientSecurityStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClientSecurityStatePtr From(const U& u) {
    return mojo::TypeConverter<ClientSecurityStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClientSecurityState>::Convert(*this);
  }


  ClientSecurityState();

  ClientSecurityState(
      const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy,
      bool is_web_secure_context,
      ::network::mojom::IPAddressSpace ip_address_space,
      PrivateNetworkRequestPolicy private_network_request_policy);

  ~ClientSecurityState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClientSecurityStatePtr>
  ClientSecurityStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientSecurityState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClientSecurityState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClientSecurityState_UnserializedMessageContext<
            UserType, ClientSecurityState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ClientSecurityState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ClientSecurityState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClientSecurityState_UnserializedMessageContext<
            UserType, ClientSecurityState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClientSecurityState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::network::CrossOriginEmbedderPolicy cross_origin_embedder_policy;
  
  bool is_web_secure_context;
  
  ::network::mojom::IPAddressSpace ip_address_space;
  
  PrivateNetworkRequestPolicy private_network_request_policy;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ClientSecurityStatePtr ClientSecurityState::Clone() const {
  return New(
      mojo::Clone(cross_origin_embedder_policy),
      mojo::Clone(is_web_secure_context),
      mojo::Clone(ip_address_space),
      mojo::Clone(private_network_request_policy)
  );
}

template <typename T, ClientSecurityState::EnableIfSame<T>*>
bool ClientSecurityState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cross_origin_embedder_policy, other_struct.cross_origin_embedder_policy))
    return false;
  if (!mojo::Equals(this->is_web_secure_context, other_struct.is_web_secure_context))
    return false;
  if (!mojo::Equals(this->ip_address_space, other_struct.ip_address_space))
    return false;
  if (!mojo::Equals(this->private_network_request_policy, other_struct.private_network_request_policy))
    return false;
  return true;
}

template <typename T, ClientSecurityState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cross_origin_embedder_policy, rhs.cross_origin_embedder_policy))
    return true;
  if (std::less<>{}(rhs.cross_origin_embedder_policy, lhs.cross_origin_embedder_policy))
    return false;
  if (std::less<>{}(lhs.is_web_secure_context, rhs.is_web_secure_context))
    return true;
  if (std::less<>{}(rhs.is_web_secure_context, lhs.is_web_secure_context))
    return false;
  if (std::less<>{}(lhs.ip_address_space, rhs.ip_address_space))
    return true;
  if (std::less<>{}(rhs.ip_address_space, lhs.ip_address_space))
    return false;
  if (std::less<>{}(lhs.private_network_request_policy, rhs.private_network_request_policy))
    return true;
  if (std::less<>{}(rhs.private_network_request_policy, lhs.private_network_request_policy))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ClientSecurityState::DataView,
                                         ::network::mojom::ClientSecurityStatePtr> {
  static bool IsNull(const ::network::mojom::ClientSecurityStatePtr& input) { return !input; }
  static void SetToNull(::network::mojom::ClientSecurityStatePtr* output) { output->reset(); }

  static const decltype(::network::mojom::ClientSecurityState::cross_origin_embedder_policy)& cross_origin_embedder_policy(
      const ::network::mojom::ClientSecurityStatePtr& input) {
    return input->cross_origin_embedder_policy;
  }

  static decltype(::network::mojom::ClientSecurityState::is_web_secure_context) is_web_secure_context(
      const ::network::mojom::ClientSecurityStatePtr& input) {
    return input->is_web_secure_context;
  }

  static decltype(::network::mojom::ClientSecurityState::ip_address_space) ip_address_space(
      const ::network::mojom::ClientSecurityStatePtr& input) {
    return input->ip_address_space;
  }

  static decltype(::network::mojom::ClientSecurityState::private_network_request_policy) private_network_request_policy(
      const ::network::mojom::ClientSecurityStatePtr& input) {
    return input->private_network_request_policy;
  }

  static bool Read(::network::mojom::ClientSecurityState::DataView input, ::network::mojom::ClientSecurityStatePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_H_