// components/services/storage/public/mojom/native_file_system_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/native_file_system_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/native_file_system_context.mojom-params-data.h"
#include "components/services/storage/public/mojom/native_file_system_context.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/native_file_system_context.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_NATIVE_FILE_SYSTEM_CONTEXT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_NATIVE_FILE_SYSTEM_CONTEXT_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char NativeFileSystemContext::Name_[] = "storage.mojom.NativeFileSystemContext";

class NativeFileSystemContext_SerializeHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemContext_SerializeHandle_ForwardToCallback(
      NativeFileSystemContext::SerializeHandleCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemContext::SerializeHandleCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemContext_SerializeHandle_ForwardToCallback);
};

NativeFileSystemContextProxy::NativeFileSystemContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeFileSystemContextProxy::SerializeHandle(
    ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> in_token, SerializeHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::NativeFileSystemContext::SerializeHandle", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("token", in_token.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemContext_SerializeHandle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::NativeFileSystemContext_SerializeHandle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_token, &params->token, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in NativeFileSystemContext.SerializeHandle request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemContext::Name_);
  message.set_method_name("SerializeHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemContext_SerializeHandle_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemContextProxy::DeserializeHandle(
    const ::url::Origin& in_origin, const std::vector<uint8_t>& in_bits, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::NativeFileSystemContext::DeserializeHandle", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->BeginArray("bits");
      for (const auto& item0 : in_bits) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      raw_value->SetBoolean("token", in_token.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemContext_DeserializeHandle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::NativeFileSystemContext_DeserializeHandle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in NativeFileSystemContext.DeserializeHandle request");
  typename decltype(params->bits)::BaseType::BufferWriter
      bits_writer;
  const mojo::internal::ContainerValidateParams bits_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bits, buffer, &bits_writer, &bits_validate_params,
      &serialization_context);
  params->bits.Set(
      bits_writer.is_null() ? nullptr : bits_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bits.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bits in NativeFileSystemContext.DeserializeHandle request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_token, &params->token, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in NativeFileSystemContext.DeserializeHandle request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemContext::Name_);
  message.set_method_name("DeserializeHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NativeFileSystemContext_SerializeHandle_ProxyToResponder {
 public:
  static NativeFileSystemContext::SerializeHandleCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemContext_SerializeHandle_ProxyToResponder> proxy(
        new NativeFileSystemContext_SerializeHandle_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemContext_SerializeHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemContext_SerializeHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemContext_SerializeHandle_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemContext::SerializeHandleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_bits);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemContext_SerializeHandle_ProxyToResponder);
};

bool NativeFileSystemContext_SerializeHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::NativeFileSystemContext::SerializeHandleCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemContext_SerializeHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemContext_SerializeHandle_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<uint8_t> p_bits{};
  NativeFileSystemContext_SerializeHandle_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadBits(&p_bits))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_bits));
  return true;
}

void NativeFileSystemContext_SerializeHandle_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_bits) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::NativeFileSystemContext::SerializeHandleCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("bits");
      for (const auto& item0 : in_bits) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemContext_SerializeHandle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::NativeFileSystemContext_SerializeHandle_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->bits)::BaseType::BufferWriter
      bits_writer;
  const mojo::internal::ContainerValidateParams bits_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bits, buffer, &bits_writer, &bits_validate_params,
      &serialization_context);
  params->bits.Set(
      bits_writer.is_null() ? nullptr : bits_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bits.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bits in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::NativeFileSystemContext::SerializeHandleCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemContext::Name_);
  message.set_method_name("SerializeHandle");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NativeFileSystemContextStubDispatch::Accept(
    NativeFileSystemContext* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeFileSystemContext_SerializeHandle_Name: {
      break;
    }
    case internal::kNativeFileSystemContext_DeserializeHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::NativeFileSystemContext::DeserializeHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::NativeFileSystemContext::DeserializeHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemContext_DeserializeHandle_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemContext_DeserializeHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      std::vector<uint8_t> p_bits{};
      ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> p_token{};
      NativeFileSystemContext_DeserializeHandle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadBits(&p_bits))
        success = false;
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeserializeHandle(
std::move(p_origin), 
std::move(p_bits), 
std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool NativeFileSystemContextStubDispatch::AcceptWithResponder(
    NativeFileSystemContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeFileSystemContext_SerializeHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::NativeFileSystemContext::SerializeHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::NativeFileSystemContext::SerializeHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemContext_SerializeHandle_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemContext_SerializeHandle_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> p_token{};
      NativeFileSystemContext_SerializeHandle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemContext::Name_, 0, false);
        return false;
      }
      NativeFileSystemContext::SerializeHandleCallback callback =
          NativeFileSystemContext_SerializeHandle_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SerializeHandle(
std::move(p_token), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemContext_DeserializeHandle_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNativeFileSystemContextValidationInfo[] = {
    {internal::kNativeFileSystemContext_SerializeHandle_Name,
     {&internal::NativeFileSystemContext_SerializeHandle_Params_Data::Validate,
      &internal::NativeFileSystemContext_SerializeHandle_ResponseParams_Data::Validate}},
    {internal::kNativeFileSystemContext_DeserializeHandle_Name,
     {&internal::NativeFileSystemContext_DeserializeHandle_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NativeFileSystemContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::NativeFileSystemContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNativeFileSystemContextValidationInfo);
}

bool NativeFileSystemContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::NativeFileSystemContext::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNativeFileSystemContextValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif