/*
 * Module code.
 *
 * Generated by SIP 6.15.0
 */

#include "sipAPI_analysis.h"

#line 24 "auto_generated/georeferencing/qgsgcptransformer.sip"
#include "qgsgcptransformer.h"
#line 12 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"

#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 16 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 19 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 50 "/build/qgis/src/build/python/core/auto_generated/qgspointxy.sip"
#include "qgspointxy.h"
#line 22 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 25 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_clone, "clone(self) -> QgsGcpTransformerInterface|None\n"
"Clones the transformer, returning a new copy of the transformer with the\n"
"same parameters as this one.\n"
"\n"
"Caller takes ownership of the returned object.");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_clone(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::QgsGcpTransformerInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpTransformerInterface, &sipCpp))
        {
            ::QgsGcpTransformerInterface*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsGcpTransformerInterface, sipName_clone);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->clone();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsGcpTransformerInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_clone, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_updateParametersFromGcps, "updateParametersFromGcps(self, sourceCoordinates: Iterable[QgsPointXY], destinationCoordinates: Iterable[QgsPointXY], invertYAxis: bool = False) -> bool\n"
"Fits transformation parameters using the specified Ground Control Points\n"
"(GCPs) lists of source and destination coordinates.\n"
"\n"
"If ``invertYAxis`` is set to ``True`` then the y-axis of source\n"
"coordinates will be inverted, e.g. to allow for transformation of raster\n"
"layers with ascending top-to-bottom vertical axis coordinates.\n"
"\n"
":return: ``True`` on success, ``False`` on failure");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_updateParametersFromGcps(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_updateParametersFromGcps(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const QVector< ::QgsPointXY>* a0;
        int a0State = 0;
        const QVector< ::QgsPointXY>* a1;
        int a1State = 0;
        bool a2 = 0;
        ::QgsGcpTransformerInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sourceCoordinates,
            sipName_destinationCoordinates,
            sipName_invertYAxis,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|b", &sipSelf, sipType_QgsGcpTransformerInterface, &sipCpp, sipType_QVector_0100QgsPointXY, &a0, &a0State, sipType_QVector_0100QgsPointXY, &a1, &a1State, &a2))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsGcpTransformerInterface, sipName_updateParametersFromGcps);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->updateParametersFromGcps(*a0, *a1, a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a0), sipType_QVector_0100QgsPointXY, a0State);
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a1), sipType_QVector_0100QgsPointXY, a1State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a0), sipType_QVector_0100QgsPointXY, a0State);
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a1), sipType_QVector_0100QgsPointXY, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_updateParametersFromGcps, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_minimumGcpCount, "minimumGcpCount(self) -> int\n"
"Returns the minimum number of Ground Control Points (GCPs) required for\n"
"parameter fitting.");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_minimumGcpCount(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_minimumGcpCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::QgsGcpTransformerInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpTransformerInterface, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsGcpTransformerInterface, sipName_minimumGcpCount);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->minimumGcpCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_minimumGcpCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_method, "method(self) -> QgsGcpTransformerInterface.TransformMethod\n"
"Returns the transformation method.");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_method(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_method(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::QgsGcpTransformerInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpTransformerInterface, &sipCpp))
        {
            ::QgsGcpTransformerInterface::TransformMethod sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsGcpTransformerInterface, sipName_method);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->method();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsGcpTransformerInterface_TransformMethod);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_method, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_transform, "transform(self, x: float, y: float, inverseTransform: bool = False) -> (bool, float, float)\n"
"Transforms the point (``x``, ``y``) from source to destination\n"
"coordinates.\n"
"\n"
"If ``inverseTransform`` is set to ``True``, the point will be\n"
"transformed from the destination to the source.\n"
"\n"
":return: ``True`` if transformation was successful.");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_transform(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_transform(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        double a1;
        bool a2 = 0;
        const ::QgsGcpTransformerInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_inverseTransform,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd|b", &sipSelf, sipType_QgsGcpTransformerInterface, &sipCpp, &a0, &a1, &a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->transform(a0, a1, a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipBuildResult(0, "(bdd)", sipRes, a0, a1);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_transform, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_methodToString, "methodToString(method: QgsGcpTransformerInterface.TransformMethod) -> str\n"
"Returns a translated string representing the specified transform\n"
"``method``.");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_methodToString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_methodToString(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsGcpTransformerInterface::TransformMethod a0;

        static const char *sipKwdList[] = {
            sipName_method,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "E", sipType_QgsGcpTransformerInterface_TransformMethod, &a0))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(::QgsGcpTransformerInterface::methodToString(a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_methodToString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_create, "create(method: QgsGcpTransformerInterface.TransformMethod) -> QgsGcpTransformerInterface|None\n"
"Creates a new QgsGcpTransformerInterface subclass representing the\n"
"specified transform ``method``.\n"
"\n"
"Caller takes ownership of the returned object.");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_create(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsGcpTransformerInterface::TransformMethod a0;

        static const char *sipKwdList[] = {
            sipName_method,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "E", sipType_QgsGcpTransformerInterface_TransformMethod, &a0))
        {
            ::QgsGcpTransformerInterface*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsGcpTransformerInterface::create(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsGcpTransformerInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpTransformerInterface_createFromParameters, "createFromParameters(method: QgsGcpTransformerInterface.TransformMethod, sourceCoordinates: Iterable[QgsPointXY], destinationCoordinates: Iterable[QgsPointXY]) -> QgsGcpTransformerInterface|None\n"
"Creates a new QgsGcpTransformerInterface subclass representing the\n"
"specified transform ``method``, initialized using the given lists of\n"
"source and destination coordinates.\n"
"\n"
"If the parameters cannot be fit to a transform ``None`` will be\n"
"returned.\n"
"\n"
"Caller takes ownership of the returned object.");

extern "C" {static PyObject *meth_QgsGcpTransformerInterface_createFromParameters(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpTransformerInterface_createFromParameters(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsGcpTransformerInterface::TransformMethod a0;
        const QVector< ::QgsPointXY>* a1;
        int a1State = 0;
        const QVector< ::QgsPointXY>* a2;
        int a2State = 0;

        static const char *sipKwdList[] = {
            sipName_method,
            sipName_sourceCoordinates,
            sipName_destinationCoordinates,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "EJ1J1", sipType_QgsGcpTransformerInterface_TransformMethod, &a0, sipType_QVector_0100QgsPointXY, &a1, &a1State, sipType_QVector_0100QgsPointXY, &a2, &a2State))
        {
            ::QgsGcpTransformerInterface*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsGcpTransformerInterface::createFromParameters(a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a1), sipType_QVector_0100QgsPointXY, a1State);
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a2), sipType_QVector_0100QgsPointXY, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a1), sipType_QVector_0100QgsPointXY, a1State);
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a2), sipType_QVector_0100QgsPointXY, a2State);

            return sipConvertFromNewType(sipRes, sipType_QgsGcpTransformerInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpTransformerInterface, sipName_createFromParameters, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsGcpTransformerInterface(void *, int);}
static void release_QgsGcpTransformerInterface(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsGcpTransformerInterface *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsGcpTransformerInterface(sipSimpleWrapper *);}
static void dealloc_QgsGcpTransformerInterface(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsGcpTransformerInterface(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_QgsGcpTransformerInterface[] = {
    {sipName_clone, meth_QgsGcpTransformerInterface_clone, METH_VARARGS, doc_QgsGcpTransformerInterface_clone},
    {sipName_create, SIP_MLMETH_CAST(meth_QgsGcpTransformerInterface_create), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpTransformerInterface_create},
    {sipName_createFromParameters, SIP_MLMETH_CAST(meth_QgsGcpTransformerInterface_createFromParameters), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpTransformerInterface_createFromParameters},
    {sipName_method, meth_QgsGcpTransformerInterface_method, METH_VARARGS, doc_QgsGcpTransformerInterface_method},
    {sipName_methodToString, SIP_MLMETH_CAST(meth_QgsGcpTransformerInterface_methodToString), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpTransformerInterface_methodToString},
    {sipName_minimumGcpCount, meth_QgsGcpTransformerInterface_minimumGcpCount, METH_VARARGS, doc_QgsGcpTransformerInterface_minimumGcpCount},
    {sipName_transform, SIP_MLMETH_CAST(meth_QgsGcpTransformerInterface_transform), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpTransformerInterface_transform},
    {sipName_updateParametersFromGcps, SIP_MLMETH_CAST(meth_QgsGcpTransformerInterface_updateParametersFromGcps), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpTransformerInterface_updateParametersFromGcps}
};

static sipEnumMemberDef enummembers_QgsGcpTransformerInterface[] = {
    {sipName_Helmert, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::Helmert), 23},
    {sipName_InvalidTransform, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::InvalidTransform), 23},
    {sipName_Linear, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::Linear), 23},
    {sipName_PolynomialOrder1, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::PolynomialOrder1), 23},
    {sipName_PolynomialOrder2, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::PolynomialOrder2), 23},
    {sipName_PolynomialOrder3, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::PolynomialOrder3), 23},
    {sipName_Projective, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::Projective), 23},
    {sipName_ThinPlateSpline, static_cast<int>(::QgsGcpTransformerInterface::TransformMethod::ThinPlateSpline), 23},
};


extern "C" {static PyObject *varget_QgsGcpTransformerInterface_staticMetaObject(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsGcpTransformerInterface_staticMetaObject(void *, PyObject *, PyObject *)
{
    const ::QMetaObject*sipVal;

    sipVal = new ::QMetaObject(::QgsGcpTransformerInterface::staticMetaObject);

    return sipConvertFromNewType(const_cast< ::QMetaObject *>(sipVal), sipType_QMetaObject, SIP_NULLPTR);
}

sipVariableDef variables_QgsGcpTransformerInterface[] = {
    {ClassVariable, sipName_staticMetaObject, (PyMethodDef *)varget_QgsGcpTransformerInterface_staticMetaObject, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_QgsGcpTransformerInterface, "An interface for Ground Control Points (GCP) based transformations.\n"
"\n"
":py:class:`QgsGcpTransformerInterface` implementations are able to\n"
"transform point locations based on a transformation method and a list of\n"
"GCPs.\n"
"\n"
".. versionadded:: 3.20\n"
"");


static pyqt5ClassPluginDef plugin_QgsGcpTransformerInterface = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsGcpTransformerInterface = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsGcpTransformerInterface,
        SIP_NULLPTR,
        &plugin_QgsGcpTransformerInterface,
    },
    {
        sipNameNr_QgsGcpTransformerInterface,
        {0, 0, 1},
        8, methods_QgsGcpTransformerInterface,
        8, enummembers_QgsGcpTransformerInterface,
        1, variables_QgsGcpTransformerInterface,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsGcpTransformerInterface,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsGcpTransformerInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsGcpTransformerInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};

#line 21 "auto_generated/georeferencing/qgsgcppoint.sip"
#include "qgsgcppoint.h"
#line 629 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"

#line 50 "/build/qgis/src/build/python/core/auto_generated/qgspointxy.sip"
#include "qgspointxy.h"
#line 633 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 205 "/build/qgis/src/build/python/core/auto_generated/proj/qgscoordinatereferencesystem.sip"
#include "qgscoordinatereferencesystem.h"
#line 636 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 39 "/build/qgis/src/build/python/core/auto_generated/proj/qgscoordinatetransformcontext.sip"
#include "qgscoordinatetransformcontext.h"
#line 639 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"


PyDoc_STRVAR(doc_QgsGcpPoint_sourcePoint, "sourcePoint(self) -> QgsPointXY\n"
"Returns the source coordinates.\n"
"\n"
"This may either be in pixels (for completely non-referenced images) OR\n"
"in the source layer CRS.\n"
"\n"
".. seealso:: :py:func:`setSourcePoint`");

extern "C" {static PyObject *meth_QgsGcpPoint_sourcePoint(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_sourcePoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGcpPoint *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpPoint, &sipCpp))
        {
            ::QgsPointXY*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointXY(sipCpp->sourcePoint());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointXY, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_sourcePoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_setSourcePoint, "setSourcePoint(self, point: QgsPointXY)\n"
"Sets the source coordinates.\n"
"\n"
"This may either be in pixels (for completely non-referenced images) OR\n"
"in the source layer CRS.\n"
"\n"
".. seealso:: :py:func:`sourcePoint`");

extern "C" {static PyObject *meth_QgsGcpPoint_setSourcePoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_setSourcePoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointXY* a0;
        ::QgsGcpPoint *sipCpp;

        static const char *sipKwdList[] = {
            sipName_point,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsGcpPoint, &sipCpp, sipType_QgsPointXY, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setSourcePoint(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_setSourcePoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_destinationPoint, "destinationPoint(self) -> QgsPointXY\n"
"Returns the destination coordinates.\n"
"\n"
".. seealso:: :py:func:`setDestinationPoint`");

extern "C" {static PyObject *meth_QgsGcpPoint_destinationPoint(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_destinationPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGcpPoint *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpPoint, &sipCpp))
        {
            ::QgsPointXY*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointXY(sipCpp->destinationPoint());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointXY, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_destinationPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_setDestinationPoint, "setDestinationPoint(self, point: QgsPointXY)\n"
"Sets the destination coordinates.\n"
"\n"
".. seealso:: :py:func:`destinationPoint`");

extern "C" {static PyObject *meth_QgsGcpPoint_setDestinationPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_setDestinationPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointXY* a0;
        ::QgsGcpPoint *sipCpp;

        static const char *sipKwdList[] = {
            sipName_point,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsGcpPoint, &sipCpp, sipType_QgsPointXY, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setDestinationPoint(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_setDestinationPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_destinationPointCrs, "destinationPointCrs(self) -> QgsCoordinateReferenceSystem\n"
"Returns the CRS of the destination point.\n"
"\n"
".. seealso:: :py:func:`setDestinationPointCrs`");

extern "C" {static PyObject *meth_QgsGcpPoint_destinationPointCrs(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_destinationPointCrs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGcpPoint *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpPoint, &sipCpp))
        {
            ::QgsCoordinateReferenceSystem*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsCoordinateReferenceSystem(sipCpp->destinationPointCrs());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsCoordinateReferenceSystem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_destinationPointCrs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_setDestinationPointCrs, "setDestinationPointCrs(self, crs: QgsCoordinateReferenceSystem)\n"
"Sets the ``crs`` of the destination point.\n"
"\n"
".. seealso:: :py:func:`destinationPointCrs`");

extern "C" {static PyObject *meth_QgsGcpPoint_setDestinationPointCrs(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_setDestinationPointCrs(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsCoordinateReferenceSystem* a0;
        ::QgsGcpPoint *sipCpp;

        static const char *sipKwdList[] = {
            sipName_crs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsGcpPoint, &sipCpp, sipType_QgsCoordinateReferenceSystem, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setDestinationPointCrs(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_setDestinationPointCrs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_transformedDestinationPoint, "transformedDestinationPoint(self, targetCrs: QgsCoordinateReferenceSystem, context: QgsCoordinateTransformContext) -> QgsPointXY\n"
"Returns the :py:func:`~QgsGcpPoint.destinationPoint` transformed to the\n"
"given target CRS.");

extern "C" {static PyObject *meth_QgsGcpPoint_transformedDestinationPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_transformedDestinationPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsCoordinateReferenceSystem* a0;
        const ::QgsCoordinateTransformContext* a1;
        const ::QgsGcpPoint *sipCpp;

        static const char *sipKwdList[] = {
            sipName_targetCrs,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsGcpPoint, &sipCpp, sipType_QgsCoordinateReferenceSystem, &a0, sipType_QgsCoordinateTransformContext, &a1))
        {
            ::QgsPointXY*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointXY(sipCpp->transformedDestinationPoint(*a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointXY, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_transformedDestinationPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_isEnabled, "isEnabled(self) -> bool\n"
"Returns ``True`` if the point is currently enabled.\n"
"\n"
".. seealso:: :py:func:`setEnabled`");

extern "C" {static PyObject *meth_QgsGcpPoint_isEnabled(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_isEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGcpPoint *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpPoint, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->isEnabled();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_isEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpPoint_setEnabled, "setEnabled(self, enabled: bool)\n"
"Sets whether the point is currently enabled.\n"
"\n"
".. seealso:: :py:func:`isEnabled`");

extern "C" {static PyObject *meth_QgsGcpPoint_setEnabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpPoint_setEnabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QgsGcpPoint *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enabled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_QgsGcpPoint, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setEnabled(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpPoint, sipName_setEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QgsGcpPoint___ne__(PyObject *, PyObject *);}
static PyObject *slot_QgsGcpPoint___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QgsGcpPoint *sipCpp = reinterpret_cast< ::QgsGcpPoint *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsGcpPoint));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGcpPoint* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QgsGcpPoint, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->::QgsGcpPoint::operator!=(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__analysis, ne_slot, sipType_QgsGcpPoint, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QgsGcpPoint___eq__(PyObject *, PyObject *);}
static PyObject *slot_QgsGcpPoint___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QgsGcpPoint *sipCpp = reinterpret_cast< ::QgsGcpPoint *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsGcpPoint));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGcpPoint* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QgsGcpPoint, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->::QgsGcpPoint::operator==(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__analysis, eq_slot, sipType_QgsGcpPoint, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsGcpPoint(void *, int);}
static void release_QgsGcpPoint(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsGcpPoint *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QgsGcpPoint(void *, Py_ssize_t, void *);}
static void assign_QgsGcpPoint(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsGcpPoint *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsGcpPoint *>(sipSrc);
}


extern "C" {static void *copy_QgsGcpPoint(const void *, Py_ssize_t);}
static void *copy_QgsGcpPoint(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsGcpPoint(reinterpret_cast<const ::QgsGcpPoint *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsGcpPoint(sipSimpleWrapper *);}
static void dealloc_QgsGcpPoint(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsGcpPoint(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsGcpPoint(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsGcpPoint(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsGcpPoint *sipCpp = SIP_NULLPTR;

    {
        const ::QgsPointXY* a0;
        const ::QgsPointXY* a1;
        const ::QgsCoordinateReferenceSystem* a2;
        bool a3 = 1;

        static const char *sipKwdList[] = {
            sipName_sourcePoint,
            sipName_destinationPoint,
            sipName_destinationPointCrs,
            sipName_enabled,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J9J9|b", sipType_QgsPointXY, &a0, sipType_QgsPointXY, &a1, sipType_QgsCoordinateReferenceSystem, &a2, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGcpPoint(*a0, *a1, *a2, a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsGcpPoint* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsGcpPoint, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGcpPoint(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QgsGcpPoint[] = {
    {(void *)slot_QgsGcpPoint___ne__, ne_slot},
    {(void *)slot_QgsGcpPoint___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QgsGcpPoint[] = {
    {sipName_destinationPoint, meth_QgsGcpPoint_destinationPoint, METH_VARARGS, doc_QgsGcpPoint_destinationPoint},
    {sipName_destinationPointCrs, meth_QgsGcpPoint_destinationPointCrs, METH_VARARGS, doc_QgsGcpPoint_destinationPointCrs},
    {sipName_isEnabled, meth_QgsGcpPoint_isEnabled, METH_VARARGS, doc_QgsGcpPoint_isEnabled},
    {sipName_setDestinationPoint, SIP_MLMETH_CAST(meth_QgsGcpPoint_setDestinationPoint), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpPoint_setDestinationPoint},
    {sipName_setDestinationPointCrs, SIP_MLMETH_CAST(meth_QgsGcpPoint_setDestinationPointCrs), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpPoint_setDestinationPointCrs},
    {sipName_setEnabled, SIP_MLMETH_CAST(meth_QgsGcpPoint_setEnabled), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpPoint_setEnabled},
    {sipName_setSourcePoint, SIP_MLMETH_CAST(meth_QgsGcpPoint_setSourcePoint), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpPoint_setSourcePoint},
    {sipName_sourcePoint, meth_QgsGcpPoint_sourcePoint, METH_VARARGS, doc_QgsGcpPoint_sourcePoint},
    {sipName_transformedDestinationPoint, SIP_MLMETH_CAST(meth_QgsGcpPoint_transformedDestinationPoint), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpPoint_transformedDestinationPoint}
};

static sipEnumMemberDef enummembers_QgsGcpPoint[] = {
    {sipName_Destination, static_cast<int>(::QgsGcpPoint::PointType::Destination), 21},
    {sipName_Source, static_cast<int>(::QgsGcpPoint::PointType::Source), 21},
};

PyDoc_STRVAR(doc_QgsGcpPoint, "Contains properties of a ground control point (GCP).\n"
"\n"
".. versionadded:: 3.26\n"
"\n"
"QgsGcpPoint(sourcePoint: QgsPointXY, destinationPoint: QgsPointXY, destinationPointCrs: QgsCoordinateReferenceSystem, enabled: bool = True)\n"
"Constructor for QgsGcpPoint.\n"
"\n"
":param sourcePoint: source coordinates. This may either be in pixels\n"
"                    (for completely non-referenced images) OR in the\n"
"                    source layer CRS.\n"
":param destinationPoint: destination coordinates\n"
":param destinationPointCrs: CRS of destination point\n"
":param enabled: whether the point is currently enabled\n"
"\n"
"QgsGcpPoint(a0: QgsGcpPoint)");


static pyqt5ClassPluginDef plugin_QgsGcpPoint = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsGcpPoint = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsGcpPoint,
        SIP_NULLPTR,
        &plugin_QgsGcpPoint,
    },
    {
        sipNameNr_QgsGcpPoint,
        {0, 0, 1},
        9, methods_QgsGcpPoint,
        2, enummembers_QgsGcpPoint,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsGcpPoint,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QgsGcpPoint,
    init_type_QgsGcpPoint,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsGcpPoint,
    assign_QgsGcpPoint,
    SIP_NULLPTR,
    copy_QgsGcpPoint,
    release_QgsGcpPoint,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsGcpPoint),
};

#line 23 "auto_generated/georeferencing/qgsgcpgeometrytransformer.sip"
#include "qgsgcpgeometrytransformer.h"
#line 1422 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"

#line 24 "auto_generated/georeferencing/qgsgcptransformer.sip"
#include "qgsgcptransformer.h"
#line 1426 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 1429 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 50 "/build/qgis/src/build/python/core/auto_generated/qgspointxy.sip"
#include "qgspointxy.h"
#line 1432 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 102 "/build/qgis/src/build/python/core/auto_generated/geometry/qgsgeometry.sip"
#include "qgsgeometry.h"
#line 1435 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"
#line 38 "/build/qgis/src/build/python/core/auto_generated/qgsfeedback.sip"
#include "qgsfeedback.h"
#line 1438 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"


class sipQgsGcpGeometryTransformer : public ::QgsGcpGeometryTransformer
{
public:
    sipQgsGcpGeometryTransformer(::QgsGcpTransformerInterface*);
    sipQgsGcpGeometryTransformer(::QgsGcpTransformerInterface::TransformMethod, const QVector< ::QgsPointXY>&, const QVector< ::QgsPointXY>&);
    virtual ~sipQgsGcpGeometryTransformer();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool transformPoint(double&, double&, double&, double&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsGcpGeometryTransformer(const sipQgsGcpGeometryTransformer &);
    sipQgsGcpGeometryTransformer &operator = (const sipQgsGcpGeometryTransformer &);

    char sipPyMethods[1];
};

sipQgsGcpGeometryTransformer::sipQgsGcpGeometryTransformer(::QgsGcpTransformerInterface*a0): ::QgsGcpGeometryTransformer(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsGcpGeometryTransformer::sipQgsGcpGeometryTransformer(::QgsGcpTransformerInterface::TransformMethod a0, const QVector< ::QgsPointXY>& a1, const QVector< ::QgsPointXY>& a2): ::QgsGcpGeometryTransformer(a0, a1, a2), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsGcpGeometryTransformer::~sipQgsGcpGeometryTransformer()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipQgsGcpGeometryTransformer::transformPoint(double& a0, double& a1, double& a2, double& a3)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_transformPoint);

    if (!sipMeth)
        return ::QgsGcpGeometryTransformer::transformPoint(a0, a1, a2, a3);

    extern bool sipVH__analysis_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, double&, double&, double&, double&);

    return sipVH__analysis_0(sipGILState, sipImportedVirtErrorHandlers__analysis_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3);
}


PyDoc_STRVAR(doc_QgsGcpGeometryTransformer_transformPoint, "transformPoint(self, x: float, y: float, z: float, m: float) -> (bool, float, float, float, float)");

extern "C" {static PyObject *meth_QgsGcpGeometryTransformer_transformPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpGeometryTransformer_transformPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        double a0;
        double a1;
        double a2;
        double a3;
        ::QgsGcpGeometryTransformer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_z,
            sipName_m,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdddd", &sipSelf, sipType_QgsGcpGeometryTransformer, &sipCpp, &a0, &a1, &a2, &a3))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsGcpGeometryTransformer::transformPoint(a0, a1, a2, a3) : sipCpp->transformPoint(a0, a1, a2, a3));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipBuildResult(0, "(bdddd)", sipRes, a0, a1, a2, a3);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpGeometryTransformer, sipName_transformPoint, doc_QgsGcpGeometryTransformer_transformPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpGeometryTransformer_transform, "transform(self, geometry: QgsGeometry, feedback: QgsFeedback|None = None) -> (QgsGeometry, bool)\n"
"Transforms the specified input ``geometry`` using the GCP based\n"
"transform.\n"
"\n"
":param geometry: Input geometry to transform\n"
":param feedback: This optional argument can be used to cancel the\n"
"                 transformation before it completes. If this is done,\n"
"                 the geometry will be left in a semi-transformed state.\n"
"\n"
":return: - transformed geometry\n"
"         - ok: ``True`` if geometry was successfully transformed, or\n"
"           ``False`` if an error occurred");

extern "C" {static PyObject *meth_QgsGcpGeometryTransformer_transform(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpGeometryTransformer_transform(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGeometry* a0;
        bool a1;
        ::QgsFeedback* a2 = 0;
        ::QgsGcpGeometryTransformer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_geometry,
            sipName_feedback,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J8", &sipSelf, sipType_QgsGcpGeometryTransformer, &sipCpp, sipType_QgsGeometry, &a0, sipType_QgsFeedback, &a2))
        {
            ::QgsGeometry*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsGeometry(sipCpp->transform(*a0, a1, a2));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            PyObject *sipResObj = sipConvertFromNewType(sipRes, sipType_QgsGeometry, SIP_NULLPTR);
            return sipBuildResult(0, "(Rb)", sipResObj, a1);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpGeometryTransformer, sipName_transform, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpGeometryTransformer_gcpTransformer, "gcpTransformer(self) -> QgsGcpTransformerInterface|None\n"
"Returns the underlying GCP transformer used to transform geometries.\n"
"\n"
".. seealso:: :py:func:`setGcpTransformer`");

extern "C" {static PyObject *meth_QgsGcpGeometryTransformer_gcpTransformer(PyObject *, PyObject *);}
static PyObject *meth_QgsGcpGeometryTransformer_gcpTransformer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGcpGeometryTransformer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGcpGeometryTransformer, &sipCpp))
        {
            ::QgsGcpTransformerInterface*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->gcpTransformer();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsGcpTransformerInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpGeometryTransformer, sipName_gcpTransformer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGcpGeometryTransformer_setGcpTransformer, "setGcpTransformer(self, transformer: QgsGcpTransformerInterface|None)\n"
"Sets the underlying GCP ``transformer`` used to transform geometries.\n"
"\n"
"Ownership is transferred to this object.\n"
"\n"
".. seealso:: :py:func:`gcpTransformer`");

extern "C" {static PyObject *meth_QgsGcpGeometryTransformer_setGcpTransformer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGcpGeometryTransformer_setGcpTransformer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsGcpTransformerInterface* a0;
        ::QgsGcpGeometryTransformer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_transformer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_QgsGcpGeometryTransformer, &sipCpp, sipType_QgsGcpTransformerInterface, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setGcpTransformer(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGcpGeometryTransformer, sipName_setGcpTransformer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsGcpGeometryTransformer(void *, const sipTypeDef *);}
static void *cast_QgsGcpGeometryTransformer(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsGcpGeometryTransformer *sipCpp = reinterpret_cast< ::QgsGcpGeometryTransformer *>(sipCppV);

    if (targetType == sipType_QgsGcpGeometryTransformer)
        return sipCppV;

    if (targetType == sipType_QgsAbstractGeometryTransformer)
        return static_cast< ::QgsAbstractGeometryTransformer *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsGcpGeometryTransformer(void *, int);}
static void release_QgsGcpGeometryTransformer(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQgsGcpGeometryTransformer *>(sipCppV);
    else
        delete reinterpret_cast< ::QgsGcpGeometryTransformer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsGcpGeometryTransformer(sipSimpleWrapper *);}
static void dealloc_QgsGcpGeometryTransformer(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsGcpGeometryTransformer *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsGcpGeometryTransformer(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsGcpGeometryTransformer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsGcpGeometryTransformer(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsGcpGeometryTransformer *sipCpp = SIP_NULLPTR;

    {
        ::QgsGcpTransformerInterface* a0;

        static const char *sipKwdList[] = {
            sipName_gcpTransformer,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "#J:", sipSelf, sipType_QgsGcpTransformerInterface, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsGcpGeometryTransformer(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        ::QgsGcpTransformerInterface::TransformMethod a0;
        const QVector< ::QgsPointXY>* a1;
        int a1State = 0;
        const QVector< ::QgsPointXY>* a2;
        int a2State = 0;

        static const char *sipKwdList[] = {
            sipName_method,
            sipName_sourceCoordinates,
            sipName_destinationCoordinates,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "EJ1J1", sipType_QgsGcpTransformerInterface_TransformMethod, &a0, sipType_QVector_0100QgsPointXY, &a1, &a1State, sipType_QVector_0100QgsPointXY, &a2, &a2State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsGcpGeometryTransformer(a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a1), sipType_QVector_0100QgsPointXY, a1State);
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a2), sipType_QVector_0100QgsPointXY, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a1), sipType_QVector_0100QgsPointXY, a1State);
            sipReleaseType(const_cast<QVector< ::QgsPointXY> *>(a2), sipType_QVector_0100QgsPointXY, a2State);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsGcpGeometryTransformer[] = {{21, 9, 1}};


static PyMethodDef methods_QgsGcpGeometryTransformer[] = {
    {sipName_gcpTransformer, meth_QgsGcpGeometryTransformer_gcpTransformer, METH_VARARGS, doc_QgsGcpGeometryTransformer_gcpTransformer},
    {sipName_setGcpTransformer, SIP_MLMETH_CAST(meth_QgsGcpGeometryTransformer_setGcpTransformer), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpGeometryTransformer_setGcpTransformer},
    {sipName_transform, SIP_MLMETH_CAST(meth_QgsGcpGeometryTransformer_transform), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpGeometryTransformer_transform},
    {sipName_transformPoint, SIP_MLMETH_CAST(meth_QgsGcpGeometryTransformer_transformPoint), METH_VARARGS|METH_KEYWORDS, doc_QgsGcpGeometryTransformer_transformPoint}
};

PyDoc_STRVAR(doc_QgsGcpGeometryTransformer, "A geometry transformer which uses an underlying Ground Control Points\n"
"(GCP) based transformation to modify geometries.\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsGcpGeometryTransformer(gcpTransformer: QgsGcpTransformerInterface|None)\n"
"Constructor for QgsGcpGeometryTransformer, which uses the specified\n"
"``gcpTransformer`` to modify geometries.\n"
"\n"
"Ownership of ``gcpTransformer`` is transferred to the geometry\n"
"transformer.\n"
"\n"
"QgsGcpGeometryTransformer(method: QgsGcpTransformerInterface.TransformMethod, sourceCoordinates: Iterable[QgsPointXY], destinationCoordinates: Iterable[QgsPointXY])\n"
"Constructor for QgsGcpGeometryTransformer, which uses the specified\n"
"transform ``method`` and list of source and destination coordinates to\n"
"transform geometries.");


static pyqt5ClassPluginDef plugin_QgsGcpGeometryTransformer = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsGcpGeometryTransformer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsGcpGeometryTransformer,
        SIP_NULLPTR,
        &plugin_QgsGcpGeometryTransformer,
    },
    {
        sipNameNr_QgsGcpGeometryTransformer,
        {0, 0, 1},
        4, methods_QgsGcpGeometryTransformer,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsGcpGeometryTransformer,
    -1,
    -1,
    supers_QgsGcpGeometryTransformer,
    SIP_NULLPTR,
    init_type_QgsGcpGeometryTransformer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsGcpGeometryTransformer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsGcpGeometryTransformer,
    cast_QgsGcpGeometryTransformer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsGcpGeometryTransformer),
};

#line 24 "auto_generated/qgsanalysis.sip"
#include "qgsanalysis.h"
#line 1944 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"

#line 31 "auto_generated/vector/geometry_checker/qgsgeometrycheckregistry.sip"
#include "qgsgeometrycheckregistry.h"
#line 1948 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart19.cpp"


PyDoc_STRVAR(doc_QgsAnalysis_instance, "instance() -> QgsAnalysis|None\n"
"Returns a pointer to the singleton instance.");

extern "C" {static PyObject *meth_QgsAnalysis_instance(PyObject *, PyObject *);}
static PyObject *meth_QgsAnalysis_instance(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QgsAnalysis*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsAnalysis::instance();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsAnalysis, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsAnalysis, sipName_instance, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsAnalysis_geometryCheckRegistry, "geometryCheckRegistry() -> QgsGeometryCheckRegistry|None\n"
"Returns the global geometry checker registry, used for managing all\n"
"geometry check factories.");

extern "C" {static PyObject *meth_QgsAnalysis_geometryCheckRegistry(PyObject *, PyObject *);}
static PyObject *meth_QgsAnalysis_geometryCheckRegistry(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QgsGeometryCheckRegistry*sipRes;
            PyObject *sipResObj;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsAnalysis::geometryCheckRegistry();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipResObj = sipConvertFromType(sipRes, sipType_QgsGeometryCheckRegistry, SIP_NULLPTR);

            sipKeepReference(SIP_NULLPTR, -1, sipResObj);

            return sipResObj;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsAnalysis, sipName_geometryCheckRegistry, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsAnalysis(void *, int);}
static void release_QgsAnalysis(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsAnalysis *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsAnalysis(sipSimpleWrapper *);}
static void dealloc_QgsAnalysis(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsAnalysis(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_QgsAnalysis[] = {
    {sipName_geometryCheckRegistry, meth_QgsAnalysis_geometryCheckRegistry, METH_VARARGS, doc_QgsAnalysis_geometryCheckRegistry},
    {sipName_instance, meth_QgsAnalysis_instance, METH_VARARGS, doc_QgsAnalysis_instance}
};

PyDoc_STRVAR(doc_QgsAnalysis, "A singleton class containing various registry and other global members\n"
"related to analysis classes.\n"
"\n"
".. versionadded:: 3.4");


static pyqt5ClassPluginDef plugin_QgsAnalysis = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsAnalysis = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsAnalysis,
        SIP_NULLPTR,
        &plugin_QgsAnalysis,
    },
    {
        sipNameNr_QgsAnalysis,
        {0, 0, 1},
        2, methods_QgsAnalysis,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsAnalysis,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsAnalysis,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsAnalysis,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
