#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <iwlib.h>

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 36), // double()(iwfreq const *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 58), // iwfreq const *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char *, int, struct iwreq *)
/*  4 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 51), // char *
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 67), // struct iwreq *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char *, int, wireless_scan_head *)
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 11 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 12 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 76), // wireless_scan_head *
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char const *, iwrange *)
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 17 */ _CFFI_OP(_CFFI_OP_POINTER, 51), // char const *
/* 18 */ _CFFI_OP(_CFFI_OP_POINTER, 60), // iwrange *
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char const *, iwstats *, iwrange *, int)
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 61), // iwstats *
/* 24 */ _CFFI_OP(_CFFI_OP_NOOP, 18),
/* 25 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, unsigned long, ...)
/* 28 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10), // unsigned long
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(void)
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION, 73), // void()(char *, int, double)
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 35 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 73), // void()(char *, int, int)
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 40 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 41 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION, 73), // void()(int)
/* 44 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION, 73), // void()(struct ether_addr const *, char *)
/* 47 */ _CFFI_OP(_CFFI_OP_POINTER, 64), // struct ether_addr const *
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_OPEN_ARRAY, 17), // char const *[]
/* 51 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 52 */ _CFFI_OP(_CFFI_OP_ARRAY, 51), // char[14]
/* 53 */ (_cffi_opcode_t)(14),
/* 54 */ _CFFI_OP(_CFFI_OP_ARRAY, 51), // char[16]
/* 55 */ (_cffi_opcode_t)(16),
/* 56 */ _CFFI_OP(_CFFI_OP_OPEN_ARRAY, 51), // char[]
/* 57 */ _CFFI_OP(_CFFI_OP_POINTER, 27), // int(*)(int, unsigned long, ...)
/* 58 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // iwfreq
/* 59 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // iwparam
/* 60 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // iwrange
/* 61 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // iwstats
/* 62 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5), // short
/* 63 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // sockaddr
/* 64 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // struct ether_addr
/* 65 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct iw_point
/* 66 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct iw_quality
/* 67 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct iwreq
/* 68 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct wireless_config
/* 69 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // union iwreq_data
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 71 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 6), // unsigned short
/* 72 */ _CFFI_OP(_CFFI_OP_POINTER, 73), // void *
/* 73 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
/* 74 */ _CFFI_OP(_CFFI_OP_POINTER, 75), // wireless_scan *
/* 75 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // wireless_scan
/* 76 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // wireless_scan_head
};

static void _cffi_const_ioctl(char *o)
{
  *(int(* *)(int, unsigned long, ...))o = ioctl;
}

static void _cffi_d_iw_ether_ntop(struct ether_addr const * x0, char * x1)
{
  iw_ether_ntop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_ether_ntop(PyObject *self, PyObject *args)
{
  struct ether_addr const * x0;
  char * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "iw_ether_ntop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ether_addr const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { iw_ether_ntop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_iw_ether_ntop _cffi_d_iw_ether_ntop
#endif

static double _cffi_d_iw_freq2float(iwfreq const * x0)
{
  return iw_freq2float(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_freq2float(PyObject *self, PyObject *arg0)
{
  iwfreq const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (iwfreq const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_freq2float(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_iw_freq2float _cffi_d_iw_freq2float
#endif

static int _cffi_d_iw_get_ext(int x0, char * x1, int x2, struct iwreq * x3)
{
  return iw_get_ext(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_get_ext(PyObject *self, PyObject *args)
{
  int x0;
  char * x1;
  int x2;
  struct iwreq * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "iw_get_ext", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct iwreq *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_get_ext(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_iw_get_ext _cffi_d_iw_get_ext
#endif

static int _cffi_d_iw_get_kernel_we_version(void)
{
  return iw_get_kernel_we_version();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_get_kernel_we_version(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_get_kernel_we_version(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_iw_get_kernel_we_version _cffi_d_iw_get_kernel_we_version
#endif

static int _cffi_d_iw_get_range_info(int x0, char const * x1, iwrange * x2)
{
  return iw_get_range_info(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_get_range_info(PyObject *self, PyObject *args)
{
  int x0;
  char const * x1;
  iwrange * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "iw_get_range_info", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (iwrange *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(18), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_get_range_info(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_iw_get_range_info _cffi_d_iw_get_range_info
#endif

static int _cffi_d_iw_get_stats(int x0, char const * x1, iwstats * x2, iwrange * x3, int x4)
{
  return iw_get_stats(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_get_stats(PyObject *self, PyObject *args)
{
  int x0;
  char const * x1;
  iwstats * x2;
  iwrange * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "iw_get_stats", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (iwstats *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (iwrange *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(18), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_get_stats(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_iw_get_stats _cffi_d_iw_get_stats
#endif

static void _cffi_d_iw_print_bitrate(char * x0, int x1, int x2)
{
  iw_print_bitrate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_print_bitrate(PyObject *self, PyObject *args)
{
  char * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "iw_print_bitrate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { iw_print_bitrate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_iw_print_bitrate _cffi_d_iw_print_bitrate
#endif

static void _cffi_d_iw_print_freq_value(char * x0, int x1, double x2)
{
  iw_print_freq_value(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_print_freq_value(PyObject *self, PyObject *args)
{
  char * x0;
  int x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "iw_print_freq_value", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { iw_print_freq_value(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_iw_print_freq_value _cffi_d_iw_print_freq_value
#endif

static int _cffi_d_iw_scan(int x0, char * x1, int x2, wireless_scan_head * x3)
{
  return iw_scan(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_scan(PyObject *self, PyObject *args)
{
  int x0;
  char * x1;
  int x2;
  wireless_scan_head * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "iw_scan", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (wireless_scan_head *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_scan(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_iw_scan _cffi_d_iw_scan
#endif

static int _cffi_d_iw_set_ext(int x0, char * x1, int x2, struct iwreq * x3)
{
  return iw_set_ext(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_set_ext(PyObject *self, PyObject *args)
{
  int x0;
  char * x1;
  int x2;
  struct iwreq * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "iw_set_ext", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct iwreq *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_set_ext(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_iw_set_ext _cffi_d_iw_set_ext
#endif

static void _cffi_d_iw_sockets_close(int x0)
{
  iw_sockets_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_sockets_close(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { iw_sockets_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_iw_sockets_close _cffi_d_iw_sockets_close
#endif

static int _cffi_d_iw_sockets_open(void)
{
  return iw_sockets_open();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_iw_sockets_open(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = iw_sockets_open(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_iw_sockets_open _cffi_d_iw_sockets_open
#endif

static int _cffi_const_IFNAMSIZ(unsigned long long *o)
{
  int n = (IFNAMSIZ) <= 0;
  *o = (unsigned long long)((IFNAMSIZ) | 0);  /* check that IFNAMSIZ is an integer */
  return n;
}

static int _cffi_const_IW_ENCODE_DISABLED(unsigned long long *o)
{
  int n = (IW_ENCODE_DISABLED) <= 0;
  *o = (unsigned long long)((IW_ENCODE_DISABLED) | 0);  /* check that IW_ENCODE_DISABLED is an integer */
  return n;
}

static int _cffi_const_IW_ENCODING_TOKEN_MAX(unsigned long long *o)
{
  int n = (IW_ENCODING_TOKEN_MAX) <= 0;
  *o = (unsigned long long)((IW_ENCODING_TOKEN_MAX) | 0);  /* check that IW_ENCODING_TOKEN_MAX is an integer */
  return n;
}

static int _cffi_const_IW_ESSID_MAX_SIZE(unsigned long long *o)
{
  int n = (IW_ESSID_MAX_SIZE) <= 0;
  *o = (unsigned long long)((IW_ESSID_MAX_SIZE) | 0);  /* check that IW_ESSID_MAX_SIZE is an integer */
  return n;
}

static int _cffi_const_IW_MODE_ADHOC(unsigned long long *o)
{
  int n = (IW_MODE_ADHOC) <= 0;
  *o = (unsigned long long)((IW_MODE_ADHOC) | 0);  /* check that IW_MODE_ADHOC is an integer */
  return n;
}

static int _cffi_const_IW_MODE_AUTO(unsigned long long *o)
{
  int n = (IW_MODE_AUTO) <= 0;
  *o = (unsigned long long)((IW_MODE_AUTO) | 0);  /* check that IW_MODE_AUTO is an integer */
  return n;
}

static int _cffi_const_IW_MODE_INFRA(unsigned long long *o)
{
  int n = (IW_MODE_INFRA) <= 0;
  *o = (unsigned long long)((IW_MODE_INFRA) | 0);  /* check that IW_MODE_INFRA is an integer */
  return n;
}

static int _cffi_const_IW_MODE_MASTER(unsigned long long *o)
{
  int n = (IW_MODE_MASTER) <= 0;
  *o = (unsigned long long)((IW_MODE_MASTER) | 0);  /* check that IW_MODE_MASTER is an integer */
  return n;
}

static int _cffi_const_IW_MODE_MONITOR(unsigned long long *o)
{
  int n = (IW_MODE_MONITOR) <= 0;
  *o = (unsigned long long)((IW_MODE_MONITOR) | 0);  /* check that IW_MODE_MONITOR is an integer */
  return n;
}

static int _cffi_const_IW_MODE_REPEAT(unsigned long long *o)
{
  int n = (IW_MODE_REPEAT) <= 0;
  *o = (unsigned long long)((IW_MODE_REPEAT) | 0);  /* check that IW_MODE_REPEAT is an integer */
  return n;
}

static int _cffi_const_IW_MODE_SECOND(unsigned long long *o)
{
  int n = (IW_MODE_SECOND) <= 0;
  *o = (unsigned long long)((IW_MODE_SECOND) | 0);  /* check that IW_MODE_SECOND is an integer */
  return n;
}

static int _cffi_const_IW_NUM_OPER_MODE(unsigned long long *o)
{
  int n = (IW_NUM_OPER_MODE) <= 0;
  *o = (unsigned long long)((IW_NUM_OPER_MODE) | 0);  /* check that IW_NUM_OPER_MODE is an integer */
  return n;
}

static int _cffi_const_SIOCGIFFLAGS(unsigned long long *o)
{
  int n = (SIOCGIFFLAGS) <= 0;
  *o = (unsigned long long)((SIOCGIFFLAGS) | 0);  /* check that SIOCGIFFLAGS is an integer */
  return n;
}

static int _cffi_const_SIOCGIWAP(unsigned long long *o)
{
  int n = (SIOCGIWAP) <= 0;
  *o = (unsigned long long)((SIOCGIWAP) | 0);  /* check that SIOCGIWAP is an integer */
  return n;
}

static int _cffi_const_SIOCGIWAPLIST(unsigned long long *o)
{
  int n = (SIOCGIWAPLIST) <= 0;
  *o = (unsigned long long)((SIOCGIWAPLIST) | 0);  /* check that SIOCGIWAPLIST is an integer */
  return n;
}

static int _cffi_const_SIOCGIWAUTH(unsigned long long *o)
{
  int n = (SIOCGIWAUTH) <= 0;
  *o = (unsigned long long)((SIOCGIWAUTH) | 0);  /* check that SIOCGIWAUTH is an integer */
  return n;
}

static int _cffi_const_SIOCGIWENCODE(unsigned long long *o)
{
  int n = (SIOCGIWENCODE) <= 0;
  *o = (unsigned long long)((SIOCGIWENCODE) | 0);  /* check that SIOCGIWENCODE is an integer */
  return n;
}

static int _cffi_const_SIOCGIWENCODEEXT(unsigned long long *o)
{
  int n = (SIOCGIWENCODEEXT) <= 0;
  *o = (unsigned long long)((SIOCGIWENCODEEXT) | 0);  /* check that SIOCGIWENCODEEXT is an integer */
  return n;
}

static int _cffi_const_SIOCGIWESSID(unsigned long long *o)
{
  int n = (SIOCGIWESSID) <= 0;
  *o = (unsigned long long)((SIOCGIWESSID) | 0);  /* check that SIOCGIWESSID is an integer */
  return n;
}

static int _cffi_const_SIOCGIWFRAG(unsigned long long *o)
{
  int n = (SIOCGIWFRAG) <= 0;
  *o = (unsigned long long)((SIOCGIWFRAG) | 0);  /* check that SIOCGIWFRAG is an integer */
  return n;
}

static int _cffi_const_SIOCGIWFREQ(unsigned long long *o)
{
  int n = (SIOCGIWFREQ) <= 0;
  *o = (unsigned long long)((SIOCGIWFREQ) | 0);  /* check that SIOCGIWFREQ is an integer */
  return n;
}

static int _cffi_const_SIOCGIWGENIE(unsigned long long *o)
{
  int n = (SIOCGIWGENIE) <= 0;
  *o = (unsigned long long)((SIOCGIWGENIE) | 0);  /* check that SIOCGIWGENIE is an integer */
  return n;
}

static int _cffi_const_SIOCGIWMODE(unsigned long long *o)
{
  int n = (SIOCGIWMODE) <= 0;
  *o = (unsigned long long)((SIOCGIWMODE) | 0);  /* check that SIOCGIWMODE is an integer */
  return n;
}

static int _cffi_const_SIOCGIWMODUL(unsigned long long *o)
{
  int n = (SIOCGIWMODUL) <= 0;
  *o = (unsigned long long)((SIOCGIWMODUL) | 0);  /* check that SIOCGIWMODUL is an integer */
  return n;
}

static int _cffi_const_SIOCGIWNAME(unsigned long long *o)
{
  int n = (SIOCGIWNAME) <= 0;
  *o = (unsigned long long)((SIOCGIWNAME) | 0);  /* check that SIOCGIWNAME is an integer */
  return n;
}

static int _cffi_const_SIOCGIWNICKN(unsigned long long *o)
{
  int n = (SIOCGIWNICKN) <= 0;
  *o = (unsigned long long)((SIOCGIWNICKN) | 0);  /* check that SIOCGIWNICKN is an integer */
  return n;
}

static int _cffi_const_SIOCGIWNWID(unsigned long long *o)
{
  int n = (SIOCGIWNWID) <= 0;
  *o = (unsigned long long)((SIOCGIWNWID) | 0);  /* check that SIOCGIWNWID is an integer */
  return n;
}

static int _cffi_const_SIOCGIWPOWER(unsigned long long *o)
{
  int n = (SIOCGIWPOWER) <= 0;
  *o = (unsigned long long)((SIOCGIWPOWER) | 0);  /* check that SIOCGIWPOWER is an integer */
  return n;
}

static int _cffi_const_SIOCGIWPRIV(unsigned long long *o)
{
  int n = (SIOCGIWPRIV) <= 0;
  *o = (unsigned long long)((SIOCGIWPRIV) | 0);  /* check that SIOCGIWPRIV is an integer */
  return n;
}

static int _cffi_const_SIOCGIWRANGE(unsigned long long *o)
{
  int n = (SIOCGIWRANGE) <= 0;
  *o = (unsigned long long)((SIOCGIWRANGE) | 0);  /* check that SIOCGIWRANGE is an integer */
  return n;
}

static int _cffi_const_SIOCGIWRATE(unsigned long long *o)
{
  int n = (SIOCGIWRATE) <= 0;
  *o = (unsigned long long)((SIOCGIWRATE) | 0);  /* check that SIOCGIWRATE is an integer */
  return n;
}

static int _cffi_const_SIOCGIWRETRY(unsigned long long *o)
{
  int n = (SIOCGIWRETRY) <= 0;
  *o = (unsigned long long)((SIOCGIWRETRY) | 0);  /* check that SIOCGIWRETRY is an integer */
  return n;
}

static int _cffi_const_SIOCGIWRTS(unsigned long long *o)
{
  int n = (SIOCGIWRTS) <= 0;
  *o = (unsigned long long)((SIOCGIWRTS) | 0);  /* check that SIOCGIWRTS is an integer */
  return n;
}

static int _cffi_const_SIOCGIWSCAN(unsigned long long *o)
{
  int n = (SIOCGIWSCAN) <= 0;
  *o = (unsigned long long)((SIOCGIWSCAN) | 0);  /* check that SIOCGIWSCAN is an integer */
  return n;
}

static int _cffi_const_SIOCGIWSENS(unsigned long long *o)
{
  int n = (SIOCGIWSENS) <= 0;
  *o = (unsigned long long)((SIOCGIWSENS) | 0);  /* check that SIOCGIWSENS is an integer */
  return n;
}

static int _cffi_const_SIOCGIWSPY(unsigned long long *o)
{
  int n = (SIOCGIWSPY) <= 0;
  *o = (unsigned long long)((SIOCGIWSPY) | 0);  /* check that SIOCGIWSPY is an integer */
  return n;
}

static int _cffi_const_SIOCGIWSTATS(unsigned long long *o)
{
  int n = (SIOCGIWSTATS) <= 0;
  *o = (unsigned long long)((SIOCGIWSTATS) | 0);  /* check that SIOCGIWSTATS is an integer */
  return n;
}

static int _cffi_const_SIOCGIWTHRSPY(unsigned long long *o)
{
  int n = (SIOCGIWTHRSPY) <= 0;
  *o = (unsigned long long)((SIOCGIWTHRSPY) | 0);  /* check that SIOCGIWTHRSPY is an integer */
  return n;
}

static int _cffi_const_SIOCGIWTXPOW(unsigned long long *o)
{
  int n = (SIOCGIWTXPOW) <= 0;
  *o = (unsigned long long)((SIOCGIWTXPOW) | 0);  /* check that SIOCGIWTXPOW is an integer */
  return n;
}

static int _cffi_const_SIOCIWFIRSTPRIV(unsigned long long *o)
{
  int n = (SIOCIWFIRSTPRIV) <= 0;
  *o = (unsigned long long)((SIOCIWFIRSTPRIV) | 0);  /* check that SIOCIWFIRSTPRIV is an integer */
  return n;
}

static int _cffi_const_SIOCIWLASTPRIV(unsigned long long *o)
{
  int n = (SIOCIWLASTPRIV) <= 0;
  *o = (unsigned long long)((SIOCIWLASTPRIV) | 0);  /* check that SIOCIWLASTPRIV is an integer */
  return n;
}

static int _cffi_const_SIOCSIWAP(unsigned long long *o)
{
  int n = (SIOCSIWAP) <= 0;
  *o = (unsigned long long)((SIOCSIWAP) | 0);  /* check that SIOCSIWAP is an integer */
  return n;
}

static int _cffi_const_SIOCSIWAUTH(unsigned long long *o)
{
  int n = (SIOCSIWAUTH) <= 0;
  *o = (unsigned long long)((SIOCSIWAUTH) | 0);  /* check that SIOCSIWAUTH is an integer */
  return n;
}

static int _cffi_const_SIOCSIWCOMMIT(unsigned long long *o)
{
  int n = (SIOCSIWCOMMIT) <= 0;
  *o = (unsigned long long)((SIOCSIWCOMMIT) | 0);  /* check that SIOCSIWCOMMIT is an integer */
  return n;
}

static int _cffi_const_SIOCSIWENCODE(unsigned long long *o)
{
  int n = (SIOCSIWENCODE) <= 0;
  *o = (unsigned long long)((SIOCSIWENCODE) | 0);  /* check that SIOCSIWENCODE is an integer */
  return n;
}

static int _cffi_const_SIOCSIWENCODEEXT(unsigned long long *o)
{
  int n = (SIOCSIWENCODEEXT) <= 0;
  *o = (unsigned long long)((SIOCSIWENCODEEXT) | 0);  /* check that SIOCSIWENCODEEXT is an integer */
  return n;
}

static int _cffi_const_SIOCSIWESSID(unsigned long long *o)
{
  int n = (SIOCSIWESSID) <= 0;
  *o = (unsigned long long)((SIOCSIWESSID) | 0);  /* check that SIOCSIWESSID is an integer */
  return n;
}

static int _cffi_const_SIOCSIWFRAG(unsigned long long *o)
{
  int n = (SIOCSIWFRAG) <= 0;
  *o = (unsigned long long)((SIOCSIWFRAG) | 0);  /* check that SIOCSIWFRAG is an integer */
  return n;
}

static int _cffi_const_SIOCSIWFREQ(unsigned long long *o)
{
  int n = (SIOCSIWFREQ) <= 0;
  *o = (unsigned long long)((SIOCSIWFREQ) | 0);  /* check that SIOCSIWFREQ is an integer */
  return n;
}

static int _cffi_const_SIOCSIWGENIE(unsigned long long *o)
{
  int n = (SIOCSIWGENIE) <= 0;
  *o = (unsigned long long)((SIOCSIWGENIE) | 0);  /* check that SIOCSIWGENIE is an integer */
  return n;
}

static int _cffi_const_SIOCSIWMLME(unsigned long long *o)
{
  int n = (SIOCSIWMLME) <= 0;
  *o = (unsigned long long)((SIOCSIWMLME) | 0);  /* check that SIOCSIWMLME is an integer */
  return n;
}

static int _cffi_const_SIOCSIWMODE(unsigned long long *o)
{
  int n = (SIOCSIWMODE) <= 0;
  *o = (unsigned long long)((SIOCSIWMODE) | 0);  /* check that SIOCSIWMODE is an integer */
  return n;
}

static int _cffi_const_SIOCSIWMODUL(unsigned long long *o)
{
  int n = (SIOCSIWMODUL) <= 0;
  *o = (unsigned long long)((SIOCSIWMODUL) | 0);  /* check that SIOCSIWMODUL is an integer */
  return n;
}

static int _cffi_const_SIOCSIWNICKN(unsigned long long *o)
{
  int n = (SIOCSIWNICKN) <= 0;
  *o = (unsigned long long)((SIOCSIWNICKN) | 0);  /* check that SIOCSIWNICKN is an integer */
  return n;
}

static int _cffi_const_SIOCSIWNWID(unsigned long long *o)
{
  int n = (SIOCSIWNWID) <= 0;
  *o = (unsigned long long)((SIOCSIWNWID) | 0);  /* check that SIOCSIWNWID is an integer */
  return n;
}

static int _cffi_const_SIOCSIWPMKSA(unsigned long long *o)
{
  int n = (SIOCSIWPMKSA) <= 0;
  *o = (unsigned long long)((SIOCSIWPMKSA) | 0);  /* check that SIOCSIWPMKSA is an integer */
  return n;
}

static int _cffi_const_SIOCSIWPOWER(unsigned long long *o)
{
  int n = (SIOCSIWPOWER) <= 0;
  *o = (unsigned long long)((SIOCSIWPOWER) | 0);  /* check that SIOCSIWPOWER is an integer */
  return n;
}

static int _cffi_const_SIOCSIWPRIV(unsigned long long *o)
{
  int n = (SIOCSIWPRIV) <= 0;
  *o = (unsigned long long)((SIOCSIWPRIV) | 0);  /* check that SIOCSIWPRIV is an integer */
  return n;
}

static int _cffi_const_SIOCSIWRANGE(unsigned long long *o)
{
  int n = (SIOCSIWRANGE) <= 0;
  *o = (unsigned long long)((SIOCSIWRANGE) | 0);  /* check that SIOCSIWRANGE is an integer */
  return n;
}

static int _cffi_const_SIOCSIWRATE(unsigned long long *o)
{
  int n = (SIOCSIWRATE) <= 0;
  *o = (unsigned long long)((SIOCSIWRATE) | 0);  /* check that SIOCSIWRATE is an integer */
  return n;
}

static int _cffi_const_SIOCSIWRETRY(unsigned long long *o)
{
  int n = (SIOCSIWRETRY) <= 0;
  *o = (unsigned long long)((SIOCSIWRETRY) | 0);  /* check that SIOCSIWRETRY is an integer */
  return n;
}

static int _cffi_const_SIOCSIWRTS(unsigned long long *o)
{
  int n = (SIOCSIWRTS) <= 0;
  *o = (unsigned long long)((SIOCSIWRTS) | 0);  /* check that SIOCSIWRTS is an integer */
  return n;
}

static int _cffi_const_SIOCSIWSCAN(unsigned long long *o)
{
  int n = (SIOCSIWSCAN) <= 0;
  *o = (unsigned long long)((SIOCSIWSCAN) | 0);  /* check that SIOCSIWSCAN is an integer */
  return n;
}

static int _cffi_const_SIOCSIWSENS(unsigned long long *o)
{
  int n = (SIOCSIWSENS) <= 0;
  *o = (unsigned long long)((SIOCSIWSENS) | 0);  /* check that SIOCSIWSENS is an integer */
  return n;
}

static int _cffi_const_SIOCSIWSPY(unsigned long long *o)
{
  int n = (SIOCSIWSPY) <= 0;
  *o = (unsigned long long)((SIOCSIWSPY) | 0);  /* check that SIOCSIWSPY is an integer */
  return n;
}

static int _cffi_const_SIOCSIWSTATS(unsigned long long *o)
{
  int n = (SIOCSIWSTATS) <= 0;
  *o = (unsigned long long)((SIOCSIWSTATS) | 0);  /* check that SIOCSIWSTATS is an integer */
  return n;
}

static int _cffi_const_SIOCSIWTHRSPY(unsigned long long *o)
{
  int n = (SIOCSIWTHRSPY) <= 0;
  *o = (unsigned long long)((SIOCSIWTHRSPY) | 0);  /* check that SIOCSIWTHRSPY is an integer */
  return n;
}

static int _cffi_const_SIOCSIWTXPOW(unsigned long long *o)
{
  int n = (SIOCSIWTXPOW) <= 0;
  *o = (unsigned long long)((SIOCSIWTXPOW) | 0);  /* check that SIOCSIWTXPOW is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__iwfreq(iwfreq *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->m) | 0);  /* check that 'iwfreq.m' is an integer */
  (void)((p->e) | 0);  /* check that 'iwfreq.e' is an integer */
  (void)((p->i) | 0);  /* check that 'iwfreq.i' is an integer */
  (void)((p->flags) | 0);  /* check that 'iwfreq.flags' is an integer */
}
struct _cffi_align__iwfreq { char x; iwfreq y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__iwparam(iwparam *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->value) | 0);  /* check that 'iwparam.value' is an integer */
  (void)((p->disabled) | 0);  /* check that 'iwparam.disabled' is an integer */
}
struct _cffi_align__iwparam { char x; iwparam y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_iw_point(struct iw_point *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->pointer; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'struct iw_point.length' is an integer */
  (void)((p->flags) | 0);  /* check that 'struct iw_point.flags' is an integer */
}
struct _cffi_align_struct_iw_point { char x; struct iw_point y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_iw_quality(struct iw_quality *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->qual) | 0);  /* check that 'struct iw_quality.qual' is an integer */
  (void)((p->level) | 0);  /* check that 'struct iw_quality.level' is an integer */
  (void)((p->noise) | 0);  /* check that 'struct iw_quality.noise' is an integer */
  (void)((p->updated) | 0);  /* check that 'struct iw_quality.updated' is an integer */
}
struct _cffi_align_struct_iw_quality { char x; struct iw_quality y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__iwrange(iwrange *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->we_version_compiled) | 0);  /* check that 'iwrange.we_version_compiled' is an integer */
  { struct iw_quality *tmp = &p->max_qual; (void)tmp; }
}
struct _cffi_align__iwrange { char x; iwrange y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__iwstats(iwstats *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct iw_quality *tmp = &p->qual; (void)tmp; }
}
struct _cffi_align__iwstats { char x; iwstats y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_iwreq(struct iwreq *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { union iwreq_data *tmp = &p->u; (void)tmp; }
  { char(*tmp)[16] = &p->ifr_name; (void)tmp; }
}
struct _cffi_align_struct_iwreq { char x; struct iwreq y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__sockaddr(sockaddr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char(*tmp)[14] = &p->sa_data; (void)tmp; }
}
struct _cffi_align__sockaddr { char x; sockaddr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wireless_config(struct wireless_config *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->has_mode) | 0);  /* check that 'struct wireless_config.has_mode' is an integer */
  (void)((p->mode) | 0);  /* check that 'struct wireless_config.mode' is an integer */
  (void)((p->essid_on) | 0);  /* check that 'struct wireless_config.essid_on' is an integer */
  { char *tmp = &p->essid[0]; (void)tmp; }
}
struct _cffi_align_struct_wireless_config { char x; struct wireless_config y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__wireless_scan(wireless_scan *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { wireless_scan * *tmp = &p->next; (void)tmp; }
  (void)((p->has_ap_addr) | 0);  /* check that 'wireless_scan.has_ap_addr' is an integer */
  (void)((p->has_stats) | 0);  /* check that 'wireless_scan.has_stats' is an integer */
  (void)((p->has_maxbitrate) | 0);  /* check that 'wireless_scan.has_maxbitrate' is an integer */
  { iwparam *tmp = &p->maxbitrate; (void)tmp; }
  { iwstats *tmp = &p->stats; (void)tmp; }
  { struct wireless_config *tmp = &p->b; (void)tmp; }
  { sockaddr *tmp = &p->ap_addr; (void)tmp; }
}
struct _cffi_align__wireless_scan { char x; wireless_scan y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__wireless_scan_head(wireless_scan_head *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { wireless_scan * *tmp = &p->result; (void)tmp; }
  (void)((p->retry) | 0);  /* check that 'wireless_scan_head.retry' is an integer */
}
struct _cffi_align__wireless_scan_head { char x; wireless_scan_head y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_union_iwreq_data(union iwreq_data *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct iw_point *tmp = &p->essid; (void)tmp; }
  { struct iw_point *tmp = &p->data; (void)tmp; }
  { iwfreq *tmp = &p->freq; (void)tmp; }
  { sockaddr *tmp = &p->ap_addr; (void)tmp; }
  (void)((p->mode) | 0);  /* check that 'union iwreq_data.mode' is an integer */
  { iwparam *tmp = &p->bitrate; (void)tmp; }
  { iwparam *tmp = &p->power; (void)tmp; }
  { iwparam *tmp = &p->nwid; (void)tmp; }
}
struct _cffi_align_union_iwreq_data { char x; union iwreq_data y; };

static char const * const *_cffi_var_iw_operation_mode(void)
{
  return (iw_operation_mode);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "IFNAMSIZ", (void *)_cffi_const_IFNAMSIZ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_ENCODE_DISABLED", (void *)_cffi_const_IW_ENCODE_DISABLED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_ENCODING_TOKEN_MAX", (void *)_cffi_const_IW_ENCODING_TOKEN_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_ESSID_MAX_SIZE", (void *)_cffi_const_IW_ESSID_MAX_SIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_MODE_ADHOC", (void *)_cffi_const_IW_MODE_ADHOC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_MODE_AUTO", (void *)_cffi_const_IW_MODE_AUTO, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_MODE_INFRA", (void *)_cffi_const_IW_MODE_INFRA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_MODE_MASTER", (void *)_cffi_const_IW_MODE_MASTER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_MODE_MONITOR", (void *)_cffi_const_IW_MODE_MONITOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_MODE_REPEAT", (void *)_cffi_const_IW_MODE_REPEAT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_MODE_SECOND", (void *)_cffi_const_IW_MODE_SECOND, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IW_NUM_OPER_MODE", (void *)_cffi_const_IW_NUM_OPER_MODE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIFFLAGS", (void *)_cffi_const_SIOCGIFFLAGS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWAP", (void *)_cffi_const_SIOCGIWAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWAPLIST", (void *)_cffi_const_SIOCGIWAPLIST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWAUTH", (void *)_cffi_const_SIOCGIWAUTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWENCODE", (void *)_cffi_const_SIOCGIWENCODE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWENCODEEXT", (void *)_cffi_const_SIOCGIWENCODEEXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWESSID", (void *)_cffi_const_SIOCGIWESSID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWFRAG", (void *)_cffi_const_SIOCGIWFRAG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWFREQ", (void *)_cffi_const_SIOCGIWFREQ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWGENIE", (void *)_cffi_const_SIOCGIWGENIE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWMODE", (void *)_cffi_const_SIOCGIWMODE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWMODUL", (void *)_cffi_const_SIOCGIWMODUL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWNAME", (void *)_cffi_const_SIOCGIWNAME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWNICKN", (void *)_cffi_const_SIOCGIWNICKN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWNWID", (void *)_cffi_const_SIOCGIWNWID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWPOWER", (void *)_cffi_const_SIOCGIWPOWER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWPRIV", (void *)_cffi_const_SIOCGIWPRIV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWRANGE", (void *)_cffi_const_SIOCGIWRANGE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWRATE", (void *)_cffi_const_SIOCGIWRATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWRETRY", (void *)_cffi_const_SIOCGIWRETRY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWRTS", (void *)_cffi_const_SIOCGIWRTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWSCAN", (void *)_cffi_const_SIOCGIWSCAN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWSENS", (void *)_cffi_const_SIOCGIWSENS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWSPY", (void *)_cffi_const_SIOCGIWSPY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWSTATS", (void *)_cffi_const_SIOCGIWSTATS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWTHRSPY", (void *)_cffi_const_SIOCGIWTHRSPY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCGIWTXPOW", (void *)_cffi_const_SIOCGIWTXPOW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCIWFIRSTPRIV", (void *)_cffi_const_SIOCIWFIRSTPRIV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCIWLASTPRIV", (void *)_cffi_const_SIOCIWLASTPRIV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWAP", (void *)_cffi_const_SIOCSIWAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWAUTH", (void *)_cffi_const_SIOCSIWAUTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWCOMMIT", (void *)_cffi_const_SIOCSIWCOMMIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWENCODE", (void *)_cffi_const_SIOCSIWENCODE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWENCODEEXT", (void *)_cffi_const_SIOCSIWENCODEEXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWESSID", (void *)_cffi_const_SIOCSIWESSID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWFRAG", (void *)_cffi_const_SIOCSIWFRAG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWFREQ", (void *)_cffi_const_SIOCSIWFREQ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWGENIE", (void *)_cffi_const_SIOCSIWGENIE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWMLME", (void *)_cffi_const_SIOCSIWMLME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWMODE", (void *)_cffi_const_SIOCSIWMODE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWMODUL", (void *)_cffi_const_SIOCSIWMODUL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWNICKN", (void *)_cffi_const_SIOCSIWNICKN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWNWID", (void *)_cffi_const_SIOCSIWNWID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWPMKSA", (void *)_cffi_const_SIOCSIWPMKSA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWPOWER", (void *)_cffi_const_SIOCSIWPOWER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWPRIV", (void *)_cffi_const_SIOCSIWPRIV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWRANGE", (void *)_cffi_const_SIOCSIWRANGE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWRATE", (void *)_cffi_const_SIOCSIWRATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWRETRY", (void *)_cffi_const_SIOCSIWRETRY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWRTS", (void *)_cffi_const_SIOCSIWRTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWSCAN", (void *)_cffi_const_SIOCSIWSCAN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWSENS", (void *)_cffi_const_SIOCSIWSENS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWSPY", (void *)_cffi_const_SIOCSIWSPY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWSTATS", (void *)_cffi_const_SIOCSIWSTATS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWTHRSPY", (void *)_cffi_const_SIOCSIWTHRSPY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SIOCSIWTXPOW", (void *)_cffi_const_SIOCSIWTXPOW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ioctl", (void *)_cffi_const_ioctl, _CFFI_OP(_CFFI_OP_CONSTANT, 57), (void *)0 },
  { "iw_ether_ntop", (void *)_cffi_f_iw_ether_ntop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 46), (void *)_cffi_d_iw_ether_ntop },
  { "iw_freq2float", (void *)_cffi_f_iw_freq2float, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_iw_freq2float },
  { "iw_get_ext", (void *)_cffi_f_iw_get_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_iw_get_ext },
  { "iw_get_kernel_we_version", (void *)_cffi_f_iw_get_kernel_we_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 31), (void *)_cffi_d_iw_get_kernel_we_version },
  { "iw_get_range_info", (void *)_cffi_f_iw_get_range_info, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 15), (void *)_cffi_d_iw_get_range_info },
  { "iw_get_stats", (void *)_cffi_f_iw_get_stats, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 20), (void *)_cffi_d_iw_get_stats },
  { "iw_operation_mode", (void *)_cffi_var_iw_operation_mode, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 50), (void *)0 },
  { "iw_print_bitrate", (void *)_cffi_f_iw_print_bitrate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 38), (void *)_cffi_d_iw_print_bitrate },
  { "iw_print_freq_value", (void *)_cffi_f_iw_print_freq_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 33), (void *)_cffi_d_iw_print_freq_value },
  { "iw_scan", (void *)_cffi_f_iw_scan, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 9), (void *)_cffi_d_iw_scan },
  { "iw_set_ext", (void *)_cffi_f_iw_set_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_iw_set_ext },
  { "iw_sockets_close", (void *)_cffi_f_iw_sockets_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 43), (void *)_cffi_d_iw_sockets_close },
  { "iw_sockets_open", (void *)_cffi_f_iw_sockets_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 31), (void *)_cffi_d_iw_sockets_open },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "m", offsetof(iwfreq, m),
         sizeof(((iwfreq *)0)->m),
         _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "e", offsetof(iwfreq, e),
         sizeof(((iwfreq *)0)->e),
         _CFFI_OP(_CFFI_OP_NOOP, 62) },
  { "i", offsetof(iwfreq, i),
         sizeof(((iwfreq *)0)->i),
         _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "flags", offsetof(iwfreq, flags),
             sizeof(((iwfreq *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "value", offsetof(iwparam, value),
             sizeof(((iwparam *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "disabled", offsetof(iwparam, disabled),
                sizeof(((iwparam *)0)->disabled),
                _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "pointer", offsetof(struct iw_point, pointer),
               sizeof(((struct iw_point *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 72) },
  { "length", offsetof(struct iw_point, length),
              sizeof(((struct iw_point *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "flags", offsetof(struct iw_point, flags),
             sizeof(((struct iw_point *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "qual", offsetof(struct iw_quality, qual),
            sizeof(((struct iw_quality *)0)->qual),
            _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "level", offsetof(struct iw_quality, level),
             sizeof(((struct iw_quality *)0)->level),
             _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "noise", offsetof(struct iw_quality, noise),
             sizeof(((struct iw_quality *)0)->noise),
             _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "updated", offsetof(struct iw_quality, updated),
               sizeof(((struct iw_quality *)0)->updated),
               _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "we_version_compiled", offsetof(iwrange, we_version_compiled),
                           sizeof(((iwrange *)0)->we_version_compiled),
                           _CFFI_OP(_CFFI_OP_NOOP, 70) },
  { "max_qual", offsetof(iwrange, max_qual),
                sizeof(((iwrange *)0)->max_qual),
                _CFFI_OP(_CFFI_OP_NOOP, 66) },
  { "qual", offsetof(iwstats, qual),
            sizeof(((iwstats *)0)->qual),
            _CFFI_OP(_CFFI_OP_NOOP, 66) },
  { "u", offsetof(struct iwreq, u),
         sizeof(((struct iwreq *)0)->u),
         _CFFI_OP(_CFFI_OP_NOOP, 69) },
  { "ifr_name", offsetof(struct iwreq, ifr_name),
                sizeof(((struct iwreq *)0)->ifr_name),
                _CFFI_OP(_CFFI_OP_NOOP, 54) },
  { "sa_data", offsetof(sockaddr, sa_data),
               sizeof(((sockaddr *)0)->sa_data),
               _CFFI_OP(_CFFI_OP_NOOP, 52) },
  { "has_mode", offsetof(struct wireless_config, has_mode),
                sizeof(((struct wireless_config *)0)->has_mode),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "mode", offsetof(struct wireless_config, mode),
            sizeof(((struct wireless_config *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "essid_on", offsetof(struct wireless_config, essid_on),
                sizeof(((struct wireless_config *)0)->essid_on),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "essid", offsetof(struct wireless_config, essid),
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "next", offsetof(wireless_scan, next),
            sizeof(((wireless_scan *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 74) },
  { "has_ap_addr", offsetof(wireless_scan, has_ap_addr),
                   sizeof(((wireless_scan *)0)->has_ap_addr),
                   _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "has_stats", offsetof(wireless_scan, has_stats),
                 sizeof(((wireless_scan *)0)->has_stats),
                 _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "has_maxbitrate", offsetof(wireless_scan, has_maxbitrate),
                      sizeof(((wireless_scan *)0)->has_maxbitrate),
                      _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "maxbitrate", offsetof(wireless_scan, maxbitrate),
                  sizeof(((wireless_scan *)0)->maxbitrate),
                  _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "stats", offsetof(wireless_scan, stats),
             sizeof(((wireless_scan *)0)->stats),
             _CFFI_OP(_CFFI_OP_NOOP, 61) },
  { "b", offsetof(wireless_scan, b),
         sizeof(((wireless_scan *)0)->b),
         _CFFI_OP(_CFFI_OP_NOOP, 68) },
  { "ap_addr", offsetof(wireless_scan, ap_addr),
               sizeof(((wireless_scan *)0)->ap_addr),
               _CFFI_OP(_CFFI_OP_NOOP, 63) },
  { "result", offsetof(wireless_scan_head, result),
              sizeof(((wireless_scan_head *)0)->result),
              _CFFI_OP(_CFFI_OP_NOOP, 74) },
  { "retry", offsetof(wireless_scan_head, retry),
             sizeof(((wireless_scan_head *)0)->retry),
             _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "essid", offsetof(union iwreq_data, essid),
             sizeof(((union iwreq_data *)0)->essid),
             _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "data", offsetof(union iwreq_data, data),
            sizeof(((union iwreq_data *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "freq", offsetof(union iwreq_data, freq),
            sizeof(((union iwreq_data *)0)->freq),
            _CFFI_OP(_CFFI_OP_NOOP, 58) },
  { "ap_addr", offsetof(union iwreq_data, ap_addr),
               sizeof(((union iwreq_data *)0)->ap_addr),
               _CFFI_OP(_CFFI_OP_NOOP, 63) },
  { "mode", offsetof(union iwreq_data, mode),
            sizeof(((union iwreq_data *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "bitrate", offsetof(union iwreq_data, bitrate),
               sizeof(((union iwreq_data *)0)->bitrate),
               _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "power", offsetof(union iwreq_data, power),
             sizeof(((union iwreq_data *)0)->power),
             _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "nwid", offsetof(union iwreq_data, nwid),
            sizeof(((union iwreq_data *)0)->nwid),
            _CFFI_OP(_CFFI_OP_NOOP, 59) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "ether_addr", 64, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "iw_freq", 58, _CFFI_F_CHECK_FIELDS,
    sizeof(iwfreq), offsetof(struct _cffi_align__iwfreq, y), 0, 4 },
  { "iw_param", 59, 0,
    sizeof(iwparam), offsetof(struct _cffi_align__iwparam, y), 4, 2 },
  { "iw_point", 65, _CFFI_F_CHECK_FIELDS,
    sizeof(struct iw_point), offsetof(struct _cffi_align_struct_iw_point, y), 6, 3 },
  { "iw_quality", 66, 0,
    sizeof(struct iw_quality), offsetof(struct _cffi_align_struct_iw_quality, y), 9, 4 },
  { "iw_range", 60, 0,
    sizeof(iwrange), offsetof(struct _cffi_align__iwrange, y), 13, 2 },
  { "iw_statistics", 61, 0,
    sizeof(iwstats), offsetof(struct _cffi_align__iwstats, y), 15, 1 },
  { "iwreq", 67, 0,
    sizeof(struct iwreq), offsetof(struct _cffi_align_struct_iwreq, y), 16, 2 },
  { "iwreq_data", 69, _CFFI_F_UNION,
    sizeof(union iwreq_data), offsetof(struct _cffi_align_union_iwreq_data, y), 33, 8 },
  { "sockaddr", 63, 0,
    sizeof(sockaddr), offsetof(struct _cffi_align__sockaddr, y), 18, 1 },
  { "wireless_config", 68, 0,
    sizeof(struct wireless_config), offsetof(struct _cffi_align_struct_wireless_config, y), 19, 4 },
  { "wireless_scan", 75, 0,
    sizeof(wireless_scan), offsetof(struct _cffi_align__wireless_scan, y), 23, 8 },
  { "wireless_scan_head", 76, _CFFI_F_CHECK_FIELDS,
    sizeof(wireless_scan_head), offsetof(struct _cffi_align__wireless_scan_head, y), 31, 2 },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "iwfreq", 58 },
  { "iwparam", 59 },
  { "iwrange", 60 },
  { "iwstats", 61 },
  { "sockaddr", 63 },
  { "wireless_scan", 75 },
  { "wireless_scan_head", 76 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  82,  /* num_globals */
  13,  /* num_struct_unions */
  0,  /* num_enums */
  7,  /* num_typenames */
  NULL,  /* no includes */
  77,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__iwlib(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__iwlib(void) { return NULL; }
#  else
     init_iwlib(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__iwlib(void)
{
  return _cffi_init("iwlib._iwlib", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_iwlib(void)
{
  _cffi_init("iwlib._iwlib", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
