// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A0__F221

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_32_T_T_0_1)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx950)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x65890b1eu, 0x8fc3a4b5u, 0, 65 }, // 65890b1e8fc3a4b5 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xa70c62afu, 0xe5d2c8b0u, 0, 82 }, // a70c62afe5d2c8b0 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x3b5e9a88u, 0xd6d21222u, 0, 16 }, // 3b5e9a88d6d21222 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x7e434f7bu, 0x31d3de9bu, 33, 65 }, // 7e434f7b31d3de9b = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x746f25dbu, 0x858780fdu, 33, 82 }, // 746f25db858780fd = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x8b52ee49u, 0xbba47a85u, 33, 16 }, // 8b52ee49bba47a85 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_32_16_True__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x360b73e0u, 0xa7021a5cu, 99, 146 }, // 360b73e0a7021a5c = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx950
    { 0x728b6aedu, 0xe12aa79cu, 115, 65 }, // 728b6aede12aa79c = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_32_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x5f733a54u, 0x664ef912u, 115, 82 }, // 5f733a54664ef912 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_32_True__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x25cdf3fbu, 0xa41c1a6du, 115, 16 }, // 25cdf3fba41c1a6d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_32_True__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x1118d959u, 0xdca0ab15u, 130, 48 }, // 1118d959dca0ab15 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_64_False__CO__wave1_warp2_stg1--Arch_gfx950
    { 0xade4dffau, 0x286eab8du, 130, 178 }, // ade4dffa286eab8d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x9002a68cu, 0x8c1f5280u, 130, 146 }, // 9002a68c8c1f5280 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_64_False__CO__wave3_warp4_stg1--Arch_gfx950
    { 0x3a7717f4u, 0x852a2fe2u, 163, 48 }, // 3a7717f4852a2fe2 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_64_True__CO__wave1_warp2_stg1--Arch_gfx950
    { 0xbecb00a2u, 0x55390d33u, 163, 178 }, // becb00a255390d33 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_64_64_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x6b952197u, 0x9493ad1fu, 212, 178 }, // 6b9521979493ad1f = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_128_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x91a1d875u, 0xc059431du, 212, 146 }, // 91a1d875c059431d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_0_1___gfx950__P__0_2_128_64_False__CO__wave3_warp4_stg1--Arch_gfx950
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx950_mod0
{{ 3, 5,11,11,11,11,11,11,11,11},
 { 3, 6,12,14,11,12,11,11,11,11},
 { 3, 5, 5, 7,13,13,13,13,13,13},
 { 5, 5, 5, 3,13,13,13,13,13,13},
 { 4, 5, 5, 4,15,15,15,15,15,15},
 { 3, 5, 3, 9, 9, 9, 9, 9, 9,15},
 { 2, 1, 3, 7, 7, 8, 9, 9, 9, 9},
 { 1, 5, 3, 7, 7, 9, 9, 9, 9,16},
 { 1, 0, 7, 7, 7, 9, 9, 9, 9,16},
 { 1, 3, 7, 7, 7, 9, 9, 9, 9,10}}
// End of GPU gfx950_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A0__F221 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 10;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 10;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = "*bf16:16"
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 32
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 1
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// vim: set fileencoding=utf-8

