/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 57 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstringconverter_base.sip"
#include <qstringconverter_base.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQStringConverter.cpp"

#line 25 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQStringConverter.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstringconverter_base.sip"
#include <qstringconverter_base.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQStringConverter.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qanystringview.sip"
#include <qanystringview.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQStringConverter.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQStringConverter.cpp"


PyDoc_STRVAR(doc_QStringConverter_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QStringConverter_isValid(PyObject *, PyObject *);}
static PyObject *meth_QStringConverter_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QStringConverter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringConverter, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QStringConverter, sipName_isValid, doc_QStringConverter_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QStringConverter_resetState, "resetState(self)");

extern "C" {static PyObject *meth_QStringConverter_resetState(PyObject *, PyObject *);}
static PyObject *meth_QStringConverter_resetState(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QStringConverter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringConverter, &sipCpp))
        {
            sipCpp->resetState();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QStringConverter, sipName_resetState, doc_QStringConverter_resetState);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QStringConverter_hasError, "hasError(self) -> bool");

extern "C" {static PyObject *meth_QStringConverter_hasError(PyObject *, PyObject *);}
static PyObject *meth_QStringConverter_hasError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QStringConverter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringConverter, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->hasError();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QStringConverter, sipName_hasError, doc_QStringConverter_hasError);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QStringConverter_name, "name(self) -> Optional[str]");

extern "C" {static PyObject *meth_QStringConverter_name(PyObject *, PyObject *);}
static PyObject *meth_QStringConverter_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QStringConverter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringConverter, &sipCpp))
        {
            const char*sipRes;

            sipRes = sipCpp->name();

            if (sipRes == SIP_NULLPTR)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_DecodeASCII(sipRes, strlen(sipRes), SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QStringConverter, sipName_name, doc_QStringConverter_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QStringConverter_nameForEncoding, "nameForEncoding(e: QStringConverter.Encoding) -> Optional[str]");

extern "C" {static PyObject *meth_QStringConverter_nameForEncoding(PyObject *, PyObject *);}
static PyObject *meth_QStringConverter_nameForEncoding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QStringConverter::Encoding a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QStringConverter_Encoding, &a0))
        {
            const char*sipRes;

            sipRes = ::QStringConverter::nameForEncoding(a0);

            if (sipRes == SIP_NULLPTR)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_DecodeASCII(sipRes, strlen(sipRes), SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QStringConverter, sipName_nameForEncoding, doc_QStringConverter_nameForEncoding);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QStringConverter_availableCodecs, "availableCodecs() -> list[str]");

extern "C" {static PyObject *meth_QStringConverter_availableCodecs(PyObject *, PyObject *);}
static PyObject *meth_QStringConverter_availableCodecs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QStringConverter::availableCodecs());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QStringConverter, sipName_availableCodecs, doc_QStringConverter_availableCodecs);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QStringConverter(void *, const sipTypeDef *);}
static void *cast_QStringConverter(void *sipCppV, const sipTypeDef *targetType)
{
    ::QStringConverter *sipCpp = reinterpret_cast< ::QStringConverter *>(sipCppV);

    if (targetType == sipType_QStringConverter)
        return sipCppV;

    if (targetType == sipType_QStringConverterBase)
        return static_cast< ::QStringConverterBase *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QStringConverter(void *, int);}
static void release_QStringConverter(void *, int)
{
}


extern "C" {static void *init_type_QStringConverter(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QStringConverter(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QStringConverter *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QStringConverter();

            return sipCpp;
        }
    }

    {
        ::QStringConverter::Encoding a0;
        ::QStringConverterBase::Flags* a1;
        int a1State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "EJ1", sipType_QStringConverter_Encoding, &a0, sipType_QFlags_0100QStringConverterBase_Flag, &a1, &a1State))
        {
            sipCpp = new ::QStringConverter(a0, *a1);
            sipReleaseType(a1, sipType_QFlags_0100QStringConverterBase_Flag, a1State);

            return sipCpp;
        }
    }

    {
        ::QAnyStringView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        ::QStringConverterBase::Flags* a1;
        int a1State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1J1", sipType_QAnyStringView, &a0, &a0State, &a0UserState, sipType_QFlags_0100QStringConverterBase_Flag, &a1, &a1State))
        {
            sipCpp = new ::QStringConverter(*a0, *a1);
            sipReleaseTypeUS(a0, sipType_QAnyStringView, a0State, a0UserState);
            sipReleaseType(a1, sipType_QFlags_0100QStringConverterBase_Flag, a1State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QStringConverter[] = {{326, 255, 1}};


static PyMethodDef methods_QStringConverter[] = {
    {sipName_availableCodecs, meth_QStringConverter_availableCodecs, METH_VARARGS, doc_QStringConverter_availableCodecs},
    {sipName_hasError, meth_QStringConverter_hasError, METH_VARARGS, doc_QStringConverter_hasError},
    {sipName_isValid, meth_QStringConverter_isValid, METH_VARARGS, doc_QStringConverter_isValid},
    {sipName_name, meth_QStringConverter_name, METH_VARARGS, doc_QStringConverter_name},
    {sipName_nameForEncoding, meth_QStringConverter_nameForEncoding, METH_VARARGS, doc_QStringConverter_nameForEncoding},
    {sipName_resetState, meth_QStringConverter_resetState, METH_VARARGS, doc_QStringConverter_resetState}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QStringConverter[] = {
    {sipName_Utf8, static_cast<int>(::QStringConverter::Utf8)},
    {sipName_Utf16, static_cast<int>(::QStringConverter::Utf16)},
    {sipName_Utf16LE, static_cast<int>(::QStringConverter::Utf16LE)},
    {sipName_Utf16BE, static_cast<int>(::QStringConverter::Utf16BE)},
    {sipName_Utf32, static_cast<int>(::QStringConverter::Utf32)},
    {sipName_Utf32LE, static_cast<int>(::QStringConverter::Utf32LE)},
    {sipName_Utf32BE, static_cast<int>(::QStringConverter::Utf32BE)},
    {sipName_Latin1, static_cast<int>(::QStringConverter::Latin1)},
    {sipName_System, static_cast<int>(::QStringConverter::System)},
    {0, 0}
};

PyDoc_STRVAR(doc_QStringConverter, "\1QStringConverter()\n"
"QStringConverter(encoding: QStringConverter.Encoding, f: QStringConverterBase.Flag)\n"
"QStringConverter(name: Union[Union[QByteArray, bytes, bytearray, memoryview], Optional[str]], f: QStringConverterBase.Flag)");


sipClassTypeDef sipTypeDef_QtCore_QStringConverter = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QStringConverter,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QStringConverter,
        {0, 0, 1},
        6, methods_QStringConverter,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QStringConverter, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QStringConverter,
    -1,
    -1,
    supers_QStringConverter,
    SIP_NULLPTR,
    init_type_QStringConverter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QStringConverter,
    cast_QStringConverter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QStringConverter),
};
