/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.6
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtBluetooth/qbluetoothuuid.sip"
#include <qbluetoothuuid.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"

#line 24 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtBluetooth/qpybluetooth_quint128.sip"
#include <qbluetoothuuid.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/quuid.sip"
#include <quuid.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"


PyDoc_STRVAR(doc_QBluetoothUuid_minimumSize, "minimumSize(self) -> int");

extern "C" {static PyObject *meth_QBluetoothUuid_minimumSize(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_minimumSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->minimumSize();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_minimumSize, doc_QBluetoothUuid_minimumSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_toUInt16, "toUInt16(self) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QBluetoothUuid_toUInt16(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_toUInt16(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const ::QBluetoothUuid *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            ::quint16 sipRes;

            sipRes = sipCpp->toUInt16(&a0);

            return sipBuildResult(0, "(tb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_toUInt16, doc_QBluetoothUuid_toUInt16);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_toUInt32, "toUInt32(self) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QBluetoothUuid_toUInt32(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_toUInt32(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const ::QBluetoothUuid *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            ::quint32 sipRes;

            sipRes = sipCpp->toUInt32(&a0);

            return sipBuildResult(0, "(ub)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_toUInt32, doc_QBluetoothUuid_toUInt32);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_toUInt128, "toUInt128(self) -> Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]");

extern "C" {static PyObject *meth_QBluetoothUuid_toUInt128(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_toUInt128(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            ::quint128*sipRes;

            sipRes = new ::quint128(sipCpp->toUInt128());

            return sipConvertFromNewType(sipRes, sipType_quint128, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_toUInt128, doc_QBluetoothUuid_toUInt128);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_serviceClassToString, "serviceClassToString(uuid: QBluetoothUuid.ServiceClassUuid) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_serviceClassToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_serviceClassToString(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::ServiceClassUuid a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QBluetoothUuid_ServiceClassUuid, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::serviceClassToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_serviceClassToString, doc_QBluetoothUuid_serviceClassToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_protocolToString, "protocolToString(uuid: QBluetoothUuid.ProtocolUuid) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_protocolToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_protocolToString(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::ProtocolUuid a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QBluetoothUuid_ProtocolUuid, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::protocolToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_protocolToString, doc_QBluetoothUuid_protocolToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_characteristicToString, "characteristicToString(uuid: QBluetoothUuid.CharacteristicType) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_characteristicToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_characteristicToString(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::CharacteristicType a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QBluetoothUuid_CharacteristicType, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::characteristicToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_characteristicToString, doc_QBluetoothUuid_characteristicToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_descriptorToString, "descriptorToString(uuid: QBluetoothUuid.DescriptorType) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_descriptorToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_descriptorToString(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::DescriptorType a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QBluetoothUuid_DescriptorType, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::descriptorToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_descriptorToString, doc_QBluetoothUuid_descriptorToString);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QBluetoothUuid___ne__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothUuid___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothUuid *sipCpp = reinterpret_cast<::QBluetoothUuid *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothUuid));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothUuid, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QBluetoothUuid::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, ne_slot, sipType_QBluetoothUuid, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QBluetoothUuid___eq__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothUuid___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothUuid *sipCpp = reinterpret_cast<::QBluetoothUuid *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothUuid));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothUuid, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QBluetoothUuid::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, eq_slot, sipType_QBluetoothUuid, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QBluetoothUuid(void *, const sipTypeDef *);}
static void *cast_QBluetoothUuid(void *sipCppV, const sipTypeDef *targetType)
{
    ::QBluetoothUuid *sipCpp = reinterpret_cast<::QBluetoothUuid *>(sipCppV);

    if (targetType == sipType_QBluetoothUuid)
        return sipCppV;

    if (targetType == sipType_QUuid)
        return static_cast<::QUuid *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QBluetoothUuid(void *, int);}
static void release_QBluetoothUuid(void *sipCppV, int)
{
    delete reinterpret_cast<::QBluetoothUuid *>(sipCppV);
}


extern "C" {static void *array_QBluetoothUuid(Py_ssize_t);}
static void *array_QBluetoothUuid(Py_ssize_t sipNrElem)
{
    return new ::QBluetoothUuid[sipNrElem];
}


extern "C" {static void array_delete_QBluetoothUuid(void *);}
static void array_delete_QBluetoothUuid(void *sipCpp)
{
    delete[] reinterpret_cast<::QBluetoothUuid *>(sipCpp);
}


extern "C" {static void assign_QBluetoothUuid(void *, Py_ssize_t, void *);}
static void assign_QBluetoothUuid(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::QBluetoothUuid *>(sipDst)[sipDstIdx] = *reinterpret_cast<::QBluetoothUuid *>(sipSrc);
}


extern "C" {static void *copy_QBluetoothUuid(const void *, Py_ssize_t);}
static void *copy_QBluetoothUuid(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QBluetoothUuid(reinterpret_cast<const ::QBluetoothUuid *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QBluetoothUuid(sipSimpleWrapper *);}
static void dealloc_QBluetoothUuid(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QBluetoothUuid(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QBluetoothUuid(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QBluetoothUuid(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QBluetoothUuid *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QBluetoothUuid();

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::ProtocolUuid a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "XE", sipType_QBluetoothUuid_ProtocolUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::ServiceClassUuid a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "XE", sipType_QBluetoothUuid_ServiceClassUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::CharacteristicType a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "XE", sipType_QBluetoothUuid_CharacteristicType, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::DescriptorType a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "XE", sipType_QBluetoothUuid_DescriptorType, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::quint32 a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "u", &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::quint128* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_quint128, &a0, &a0State))
        {
            sipCpp = new ::QBluetoothUuid(*a0);
            sipReleaseType(a0, sipType_quint128, a0State);

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            sipCpp = new ::QBluetoothUuid(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QBluetoothUuid* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QBluetoothUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(*a0);

            return sipCpp;
        }
    }

    {
        const ::QUuid* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QBluetoothUuid[] = {{10, 0, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_QBluetoothUuid[] = {
    {(void *)slot_QBluetoothUuid___ne__, ne_slot},
    {(void *)slot_QBluetoothUuid___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QBluetoothUuid[] = {
    {sipName_characteristicToString, meth_QBluetoothUuid_characteristicToString, METH_VARARGS, doc_QBluetoothUuid_characteristicToString},
    {sipName_descriptorToString, meth_QBluetoothUuid_descriptorToString, METH_VARARGS, doc_QBluetoothUuid_descriptorToString},
    {sipName_minimumSize, meth_QBluetoothUuid_minimumSize, METH_VARARGS, doc_QBluetoothUuid_minimumSize},
    {sipName_protocolToString, meth_QBluetoothUuid_protocolToString, METH_VARARGS, doc_QBluetoothUuid_protocolToString},
    {sipName_serviceClassToString, meth_QBluetoothUuid_serviceClassToString, METH_VARARGS, doc_QBluetoothUuid_serviceClassToString},
    {sipName_toUInt128, meth_QBluetoothUuid_toUInt128, METH_VARARGS, doc_QBluetoothUuid_toUInt128},
    {sipName_toUInt16, SIP_MLMETH_CAST(meth_QBluetoothUuid_toUInt16), METH_VARARGS|METH_KEYWORDS, doc_QBluetoothUuid_toUInt16},
    {sipName_toUInt32, SIP_MLMETH_CAST(meth_QBluetoothUuid_toUInt32), METH_VARARGS|METH_KEYWORDS, doc_QBluetoothUuid_toUInt32}
};

static sipEnumMemberDef enummembers_QBluetoothUuid[] = {
    {sipName_AV_RemoteControl, static_cast<int>(::QBluetoothUuid::AV_RemoteControl), 56},
    {sipName_AV_RemoteControlController, static_cast<int>(::QBluetoothUuid::AV_RemoteControlController), 56},
    {sipName_AV_RemoteControlTarget, static_cast<int>(::QBluetoothUuid::AV_RemoteControlTarget), 56},
    {sipName_AdvancedAudioDistribution, static_cast<int>(::QBluetoothUuid::AdvancedAudioDistribution), 56},
    {sipName_AerobicHeartRateLowerLimit, static_cast<int>(::QBluetoothUuid::AerobicHeartRateLowerLimit), 53},
    {sipName_AerobicHeartRateUpperLimit, static_cast<int>(::QBluetoothUuid::AerobicHeartRateUpperLimit), 53},
    {sipName_AerobicThreshold, static_cast<int>(::QBluetoothUuid::AerobicThreshold), 53},
    {sipName_Age, static_cast<int>(::QBluetoothUuid::Age), 53},
    {sipName_AlertCategoryID, static_cast<int>(::QBluetoothUuid::AlertCategoryID), 53},
    {sipName_AlertCategoryIDBitMask, static_cast<int>(::QBluetoothUuid::AlertCategoryIDBitMask), 53},
    {sipName_AlertLevel, static_cast<int>(::QBluetoothUuid::AlertLevel), 53},
    {sipName_AlertNotificationControlPoint, static_cast<int>(::QBluetoothUuid::AlertNotificationControlPoint), 53},
    {sipName_AlertNotificationService, static_cast<int>(::QBluetoothUuid::AlertNotificationService), 56},
    {sipName_AlertStatus, static_cast<int>(::QBluetoothUuid::AlertStatus), 53},
    {sipName_AnaerobicHeartRateLowerLimit, static_cast<int>(::QBluetoothUuid::AnaerobicHeartRateLowerLimit), 53},
    {sipName_AnaerobicHeartRateUpperLimit, static_cast<int>(::QBluetoothUuid::AnaerobicHeartRateUpperLimit), 53},
    {sipName_AnaerobicThreshold, static_cast<int>(::QBluetoothUuid::AnaerobicThreshold), 53},
    {sipName_ApparentWindDirection, static_cast<int>(::QBluetoothUuid::ApparentWindDirection), 53},
    {sipName_ApparentWindSpeed, static_cast<int>(::QBluetoothUuid::ApparentWindSpeed), 53},
    {sipName_Appearance, static_cast<int>(::QBluetoothUuid::Appearance), 53},
    {sipName_Att, static_cast<int>(::QBluetoothUuid::Att), 55},
    {sipName_AudioSink, static_cast<int>(::QBluetoothUuid::AudioSink), 56},
    {sipName_AudioSource, static_cast<int>(::QBluetoothUuid::AudioSource), 56},
    {sipName_Avctp, static_cast<int>(::QBluetoothUuid::Avctp), 55},
    {sipName_Avdtp, static_cast<int>(::QBluetoothUuid::Avdtp), 55},
    {sipName_BarometricPressureTrend, static_cast<int>(::QBluetoothUuid::BarometricPressureTrend), 53},
    {sipName_BasicImage, static_cast<int>(::QBluetoothUuid::BasicImage), 56},
    {sipName_BasicPrinting, static_cast<int>(::QBluetoothUuid::BasicPrinting), 56},
    {sipName_BatteryLevel, static_cast<int>(::QBluetoothUuid::BatteryLevel), 53},
    {sipName_BatteryService, static_cast<int>(::QBluetoothUuid::BatteryService), 56},
    {sipName_BloodPressure, static_cast<int>(::QBluetoothUuid::BloodPressure), 56},
    {sipName_BloodPressureFeature, static_cast<int>(::QBluetoothUuid::BloodPressureFeature), 53},
    {sipName_BloodPressureMeasurement, static_cast<int>(::QBluetoothUuid::BloodPressureMeasurement), 53},
    {sipName_Bnep, static_cast<int>(::QBluetoothUuid::Bnep), 55},
    {sipName_BodyComposition, static_cast<int>(::QBluetoothUuid::BodyComposition), 56},
    {sipName_BodyCompositionFeature, static_cast<int>(::QBluetoothUuid::BodyCompositionFeature), 53},
    {sipName_BodyCompositionMeasurement, static_cast<int>(::QBluetoothUuid::BodyCompositionMeasurement), 53},
    {sipName_BodySensorLocation, static_cast<int>(::QBluetoothUuid::BodySensorLocation), 53},
    {sipName_BondManagement, static_cast<int>(::QBluetoothUuid::BondManagement), 56},
    {sipName_BootKeyboardInputReport, static_cast<int>(::QBluetoothUuid::BootKeyboardInputReport), 53},
    {sipName_BootKeyboardOutputReport, static_cast<int>(::QBluetoothUuid::BootKeyboardOutputReport), 53},
    {sipName_BootMouseInputReport, static_cast<int>(::QBluetoothUuid::BootMouseInputReport), 53},
    {sipName_BrowseGroupDescriptor, static_cast<int>(::QBluetoothUuid::BrowseGroupDescriptor), 56},
    {sipName_CSCFeature, static_cast<int>(::QBluetoothUuid::CSCFeature), 53},
    {sipName_CSCMeasurement, static_cast<int>(::QBluetoothUuid::CSCMeasurement), 53},
    {sipName_CharacteristicAggregateFormat, static_cast<int>(::QBluetoothUuid::CharacteristicAggregateFormat), 54},
    {sipName_CharacteristicExtendedProperties, static_cast<int>(::QBluetoothUuid::CharacteristicExtendedProperties), 54},
    {sipName_CharacteristicPresentationFormat, static_cast<int>(::QBluetoothUuid::CharacteristicPresentationFormat), 54},
    {sipName_CharacteristicUserDescription, static_cast<int>(::QBluetoothUuid::CharacteristicUserDescription), 54},
    {sipName_ClientCharacteristicConfiguration, static_cast<int>(::QBluetoothUuid::ClientCharacteristicConfiguration), 54},
    {sipName_Cmtp, static_cast<int>(::QBluetoothUuid::Cmtp), 55},
    {sipName_ContinuousGlucoseMonitoring, static_cast<int>(::QBluetoothUuid::ContinuousGlucoseMonitoring), 56},
    {sipName_CurrentTime, static_cast<int>(::QBluetoothUuid::CurrentTime), 53},
    {sipName_CurrentTimeService, static_cast<int>(::QBluetoothUuid::CurrentTimeService), 56},
    {sipName_CyclingPower, static_cast<int>(::QBluetoothUuid::CyclingPower), 56},
    {sipName_CyclingPowerControlPoint, static_cast<int>(::QBluetoothUuid::CyclingPowerControlPoint), 53},
    {sipName_CyclingPowerFeature, static_cast<int>(::QBluetoothUuid::CyclingPowerFeature), 53},
    {sipName_CyclingPowerMeasurement, static_cast<int>(::QBluetoothUuid::CyclingPowerMeasurement), 53},
    {sipName_CyclingPowerVector, static_cast<int>(::QBluetoothUuid::CyclingPowerVector), 53},
    {sipName_CyclingSpeedAndCadence, static_cast<int>(::QBluetoothUuid::CyclingSpeedAndCadence), 56},
    {sipName_DSTOffset, static_cast<int>(::QBluetoothUuid::DSTOffset), 53},
    {sipName_DatabaseChangeIncrement, static_cast<int>(::QBluetoothUuid::DatabaseChangeIncrement), 53},
    {sipName_DateOfBirth, static_cast<int>(::QBluetoothUuid::DateOfBirth), 53},
    {sipName_DateOfThresholdAssessment, static_cast<int>(::QBluetoothUuid::DateOfThresholdAssessment), 53},
    {sipName_DateTime, static_cast<int>(::QBluetoothUuid::DateTime), 53},
    {sipName_DayDateTime, static_cast<int>(::QBluetoothUuid::DayDateTime), 53},
    {sipName_DayOfWeek, static_cast<int>(::QBluetoothUuid::DayOfWeek), 53},
    {sipName_DescriptorValueChanged, static_cast<int>(::QBluetoothUuid::DescriptorValueChanged), 53},
    {sipName_DeviceInformation, static_cast<int>(::QBluetoothUuid::DeviceInformation), 56},
    {sipName_DeviceName, static_cast<int>(::QBluetoothUuid::DeviceName), 53},
    {sipName_DewPoint, static_cast<int>(::QBluetoothUuid::DewPoint), 53},
    {sipName_DialupNetworking, static_cast<int>(::QBluetoothUuid::DialupNetworking), 56},
    {sipName_DirectPrinting, static_cast<int>(::QBluetoothUuid::DirectPrinting), 56},
    {sipName_DirectPrintingReferenceObjectsService, static_cast<int>(::QBluetoothUuid::DirectPrintingReferenceObjectsService), 56},
    {sipName_Display3D, static_cast<int>(::QBluetoothUuid::Display3D), 56},
    {sipName_Elevation, static_cast<int>(::QBluetoothUuid::Elevation), 53},
    {sipName_EmailAddress, static_cast<int>(::QBluetoothUuid::EmailAddress), 53},
    {sipName_EnvironmentalSensing, static_cast<int>(::QBluetoothUuid::EnvironmentalSensing), 56},
    {sipName_EnvironmentalSensingConfiguration, static_cast<int>(::QBluetoothUuid::EnvironmentalSensingConfiguration), 54},
    {sipName_EnvironmentalSensingMeasurement, static_cast<int>(::QBluetoothUuid::EnvironmentalSensingMeasurement), 54},
    {sipName_EnvironmentalSensingTriggerSetting, static_cast<int>(::QBluetoothUuid::EnvironmentalSensingTriggerSetting), 54},
    {sipName_ExactTime256, static_cast<int>(::QBluetoothUuid::ExactTime256), 53},
    {sipName_ExternalReportReference, static_cast<int>(::QBluetoothUuid::ExternalReportReference), 54},
    {sipName_FatBurnHeartRateLowerLimit, static_cast<int>(::QBluetoothUuid::FatBurnHeartRateLowerLimit), 53},
    {sipName_FatBurnHeartRateUpperLimit, static_cast<int>(::QBluetoothUuid::FatBurnHeartRateUpperLimit), 53},
    {sipName_FirmwareRevisionString, static_cast<int>(::QBluetoothUuid::FirmwareRevisionString), 53},
    {sipName_FirstName, static_cast<int>(::QBluetoothUuid::FirstName), 53},
    {sipName_FiveZoneHeartRateLimits, static_cast<int>(::QBluetoothUuid::FiveZoneHeartRateLimits), 53},
    {sipName_Ftp, static_cast<int>(::QBluetoothUuid::Ftp), 55},
    {sipName_GN, static_cast<int>(::QBluetoothUuid::GN), 56},
    {sipName_GNSS, static_cast<int>(::QBluetoothUuid::GNSS), 56},
    {sipName_GNSSServer, static_cast<int>(::QBluetoothUuid::GNSSServer), 56},
    {sipName_Gender, static_cast<int>(::QBluetoothUuid::Gender), 53},
    {sipName_GenericAccess, static_cast<int>(::QBluetoothUuid::GenericAccess), 56},
    {sipName_GenericAttribute, static_cast<int>(::QBluetoothUuid::GenericAttribute), 56},
    {sipName_GenericAudio, static_cast<int>(::QBluetoothUuid::GenericAudio), 56},
    {sipName_GenericFileTransfer, static_cast<int>(::QBluetoothUuid::GenericFileTransfer), 56},
    {sipName_GenericNetworking, static_cast<int>(::QBluetoothUuid::GenericNetworking), 56},
    {sipName_GenericTelephony, static_cast<int>(::QBluetoothUuid::GenericTelephony), 56},
    {sipName_Glasses3D, static_cast<int>(::QBluetoothUuid::Glasses3D), 56},
    {sipName_Glucose, static_cast<int>(::QBluetoothUuid::Glucose), 56},
    {sipName_GlucoseFeature, static_cast<int>(::QBluetoothUuid::GlucoseFeature), 53},
    {sipName_GlucoseMeasurement, static_cast<int>(::QBluetoothUuid::GlucoseMeasurement), 53},
    {sipName_GlucoseMeasurementContext, static_cast<int>(::QBluetoothUuid::GlucoseMeasurementContext), 53},
    {sipName_GustFactor, static_cast<int>(::QBluetoothUuid::GustFactor), 53},
    {sipName_HCRPrint, static_cast<int>(::QBluetoothUuid::HCRPrint), 56},
    {sipName_HCRScan, static_cast<int>(::QBluetoothUuid::HCRScan), 56},
    {sipName_HDP, static_cast<int>(::QBluetoothUuid::HDP), 56},
    {sipName_HDPSink, static_cast<int>(::QBluetoothUuid::HDPSink), 56},
    {sipName_HDPSource, static_cast<int>(::QBluetoothUuid::HDPSource), 56},
    {sipName_HIDControlPoint, static_cast<int>(::QBluetoothUuid::HIDControlPoint), 53},
    {sipName_HIDInformation, static_cast<int>(::QBluetoothUuid::HIDInformation), 53},
    {sipName_Handsfree, static_cast<int>(::QBluetoothUuid::Handsfree), 56},
    {sipName_HandsfreeAudioGateway, static_cast<int>(::QBluetoothUuid::HandsfreeAudioGateway), 56},
    {sipName_HardcopyCableReplacement, static_cast<int>(::QBluetoothUuid::HardcopyCableReplacement), 56},
    {sipName_HardcopyControlChannel, static_cast<int>(::QBluetoothUuid::HardcopyControlChannel), 55},
    {sipName_HardcopyDataChannel, static_cast<int>(::QBluetoothUuid::HardcopyDataChannel), 55},
    {sipName_HardcopyNotification, static_cast<int>(::QBluetoothUuid::HardcopyNotification), 55},
    {sipName_HardwareRevisionString, static_cast<int>(::QBluetoothUuid::HardwareRevisionString), 53},
    {sipName_Headset, static_cast<int>(::QBluetoothUuid::Headset), 56},
    {sipName_HeadsetAG, static_cast<int>(::QBluetoothUuid::HeadsetAG), 56},
    {sipName_HeadsetHS, static_cast<int>(::QBluetoothUuid::HeadsetHS), 56},
    {sipName_HealthThermometer, static_cast<int>(::QBluetoothUuid::HealthThermometer), 56},
    {sipName_HeartRate, static_cast<int>(::QBluetoothUuid::HeartRate), 56},
    {sipName_HeartRateControlPoint, static_cast<int>(::QBluetoothUuid::HeartRateControlPoint), 53},
    {sipName_HeartRateMax, static_cast<int>(::QBluetoothUuid::HeartRateMax), 53},
    {sipName_HeartRateMeasurement, static_cast<int>(::QBluetoothUuid::HeartRateMeasurement), 53},
    {sipName_HeatIndex, static_cast<int>(::QBluetoothUuid::HeatIndex), 53},
    {sipName_Height, static_cast<int>(::QBluetoothUuid::Height), 53},
    {sipName_Hidp, static_cast<int>(::QBluetoothUuid::Hidp), 55},
    {sipName_HipCircumference, static_cast<int>(::QBluetoothUuid::HipCircumference), 53},
    {sipName_Http, static_cast<int>(::QBluetoothUuid::Http), 55},
    {sipName_HumanInterfaceDevice, static_cast<int>(::QBluetoothUuid::HumanInterfaceDevice), 56},
    {sipName_HumanInterfaceDeviceService, static_cast<int>(::QBluetoothUuid::HumanInterfaceDeviceService), 56},
    {sipName_Humidity, static_cast<int>(::QBluetoothUuid::Humidity), 53},
    {sipName_IEEE1107320601RegulatoryCertificationDataList, static_cast<int>(::QBluetoothUuid::IEEE1107320601RegulatoryCertificationDataList), 53},
    {sipName_ImagingAutomaticArchive, static_cast<int>(::QBluetoothUuid::ImagingAutomaticArchive), 56},
    {sipName_ImagingReferenceObjects, static_cast<int>(::QBluetoothUuid::ImagingReferenceObjects), 56},
    {sipName_ImagingResponder, static_cast<int>(::QBluetoothUuid::ImagingResponder), 56},
    {sipName_ImmediateAlert, static_cast<int>(::QBluetoothUuid::ImmediateAlert), 56},
    {sipName_IntermediateCuffPressure, static_cast<int>(::QBluetoothUuid::IntermediateCuffPressure), 53},
    {sipName_IntermediateTemperature, static_cast<int>(::QBluetoothUuid::IntermediateTemperature), 53},
    {sipName_Ip, static_cast<int>(::QBluetoothUuid::Ip), 55},
    {sipName_IrMCSync, static_cast<int>(::QBluetoothUuid::IrMCSync), 56},
    {sipName_IrMCSyncCommand, static_cast<int>(::QBluetoothUuid::IrMCSyncCommand), 56},
    {sipName_Irradiance, static_cast<int>(::QBluetoothUuid::Irradiance), 53},
    {sipName_L2cap, static_cast<int>(::QBluetoothUuid::L2cap), 55},
    {sipName_LANAccessUsingPPP, static_cast<int>(::QBluetoothUuid::LANAccessUsingPPP), 56},
    {sipName_LNControlPoint, static_cast<int>(::QBluetoothUuid::LNControlPoint), 53},
    {sipName_LNFeature, static_cast<int>(::QBluetoothUuid::LNFeature), 53},
    {sipName_Language, static_cast<int>(::QBluetoothUuid::Language), 53},
    {sipName_LastName, static_cast<int>(::QBluetoothUuid::LastName), 53},
    {sipName_LinkLoss, static_cast<int>(::QBluetoothUuid::LinkLoss), 56},
    {sipName_LocalTimeInformation, static_cast<int>(::QBluetoothUuid::LocalTimeInformation), 53},
    {sipName_LocationAndNavigation, static_cast<int>(::QBluetoothUuid::LocationAndNavigation), 56},
    {sipName_LocationAndSpeed, static_cast<int>(::QBluetoothUuid::LocationAndSpeed), 53},
    {sipName_MPSProfile, static_cast<int>(::QBluetoothUuid::MPSProfile), 56},
    {sipName_MPSService, static_cast<int>(::QBluetoothUuid::MPSService), 56},
    {sipName_MagneticDeclination, static_cast<int>(::QBluetoothUuid::MagneticDeclination), 53},
    {sipName_MagneticFluxDensity2D, static_cast<int>(::QBluetoothUuid::MagneticFluxDensity2D), 53},
    {sipName_MagneticFluxDensity3D, static_cast<int>(::QBluetoothUuid::MagneticFluxDensity3D), 53},
    {sipName_ManufacturerNameString, static_cast<int>(::QBluetoothUuid::ManufacturerNameString), 53},
    {sipName_MaximumRecommendedHeartRate, static_cast<int>(::QBluetoothUuid::MaximumRecommendedHeartRate), 53},
    {sipName_McapControlChannel, static_cast<int>(::QBluetoothUuid::McapControlChannel), 55},
    {sipName_McapDataChannel, static_cast<int>(::QBluetoothUuid::McapDataChannel), 55},
    {sipName_MeasurementInterval, static_cast<int>(::QBluetoothUuid::MeasurementInterval), 53},
    {sipName_MessageAccessProfile, static_cast<int>(::QBluetoothUuid::MessageAccessProfile), 56},
    {sipName_MessageAccessServer, static_cast<int>(::QBluetoothUuid::MessageAccessServer), 56},
    {sipName_MessageNotificationServer, static_cast<int>(::QBluetoothUuid::MessageNotificationServer), 56},
    {sipName_ModelNumberString, static_cast<int>(::QBluetoothUuid::ModelNumberString), 53},
    {sipName_NAP, static_cast<int>(::QBluetoothUuid::NAP), 56},
    {sipName_Navigation, static_cast<int>(::QBluetoothUuid::Navigation), 53},
    {sipName_NewAlert, static_cast<int>(::QBluetoothUuid::NewAlert), 53},
    {sipName_NextDSTChangeService, static_cast<int>(::QBluetoothUuid::NextDSTChangeService), 56},
    {sipName_OBEXFileTransfer, static_cast<int>(::QBluetoothUuid::OBEXFileTransfer), 56},
    {sipName_Obex, static_cast<int>(::QBluetoothUuid::Obex), 55},
    {sipName_ObexObjectPush, static_cast<int>(::QBluetoothUuid::ObexObjectPush), 56},
    {sipName_PANU, static_cast<int>(::QBluetoothUuid::PANU), 56},
    {sipName_PeripheralPreferredConnectionParameters, static_cast<int>(::QBluetoothUuid::PeripheralPreferredConnectionParameters), 53},
    {sipName_PeripheralPrivacyFlag, static_cast<int>(::QBluetoothUuid::PeripheralPrivacyFlag), 53},
    {sipName_PhoneAlertStatusService, static_cast<int>(::QBluetoothUuid::PhoneAlertStatusService), 56},
    {sipName_PhonebookAccess, static_cast<int>(::QBluetoothUuid::PhonebookAccess), 56},
    {sipName_PhonebookAccessPCE, static_cast<int>(::QBluetoothUuid::PhonebookAccessPCE), 56},
    {sipName_PhonebookAccessPSE, static_cast<int>(::QBluetoothUuid::PhonebookAccessPSE), 56},
    {sipName_PnPID, static_cast<int>(::QBluetoothUuid::PnPID), 53},
    {sipName_PnPInformation, static_cast<int>(::QBluetoothUuid::PnPInformation), 56},
    {sipName_PollenConcentration, static_cast<int>(::QBluetoothUuid::PollenConcentration), 53},
    {sipName_PositionQuality, static_cast<int>(::QBluetoothUuid::PositionQuality), 53},
    {sipName_Pressure, static_cast<int>(::QBluetoothUuid::Pressure), 53},
    {sipName_PrintingStatus, static_cast<int>(::QBluetoothUuid::PrintingStatus), 56},
    {sipName_ProtocolMode, static_cast<int>(::QBluetoothUuid::ProtocolMode), 53},
    {sipName_PublicBrowseGroup, static_cast<int>(::QBluetoothUuid::PublicBrowseGroup), 56},
    {sipName_RSCFeature, static_cast<int>(::QBluetoothUuid::RSCFeature), 53},
    {sipName_RSCMeasurement, static_cast<int>(::QBluetoothUuid::RSCMeasurement), 53},
    {sipName_Rainfall, static_cast<int>(::QBluetoothUuid::Rainfall), 53},
    {sipName_ReconnectionAddress, static_cast<int>(::QBluetoothUuid::ReconnectionAddress), 53},
    {sipName_RecordAccessControlPoint, static_cast<int>(::QBluetoothUuid::RecordAccessControlPoint), 53},
    {sipName_ReferencePrinting, static_cast<int>(::QBluetoothUuid::ReferencePrinting), 56},
    {sipName_ReferenceTimeInformation, static_cast<int>(::QBluetoothUuid::ReferenceTimeInformation), 53},
    {sipName_ReferenceTimeUpdateService, static_cast<int>(::QBluetoothUuid::ReferenceTimeUpdateService), 56},
    {sipName_ReflectedUI, static_cast<int>(::QBluetoothUuid::ReflectedUI), 56},
    {sipName_Report, static_cast<int>(::QBluetoothUuid::Report), 53},
    {sipName_ReportMap, static_cast<int>(::QBluetoothUuid::ReportMap), 53},
    {sipName_ReportReference, static_cast<int>(::QBluetoothUuid::ReportReference), 54},
    {sipName_RestingHeartRate, static_cast<int>(::QBluetoothUuid::RestingHeartRate), 53},
    {sipName_Rfcomm, static_cast<int>(::QBluetoothUuid::Rfcomm), 55},
    {sipName_RingerControlPoint, static_cast<int>(::QBluetoothUuid::RingerControlPoint), 53},
    {sipName_RingerSetting, static_cast<int>(::QBluetoothUuid::RingerSetting), 53},
    {sipName_RunningSpeedAndCadence, static_cast<int>(::QBluetoothUuid::RunningSpeedAndCadence), 56},
    {sipName_SCControlPoint, static_cast<int>(::QBluetoothUuid::SCControlPoint), 53},
    {sipName_SIMAccess, static_cast<int>(::QBluetoothUuid::SIMAccess), 56},
    {sipName_ScanIntervalWindow, static_cast<int>(::QBluetoothUuid::ScanIntervalWindow), 53},
    {sipName_ScanParameters, static_cast<int>(::QBluetoothUuid::ScanParameters), 56},
    {sipName_ScanRefresh, static_cast<int>(::QBluetoothUuid::ScanRefresh), 53},
    {sipName_Sdp, static_cast<int>(::QBluetoothUuid::Sdp), 55},
    {sipName_SensorLocation, static_cast<int>(::QBluetoothUuid::SensorLocation), 53},
    {sipName_SerialNumberString, static_cast<int>(::QBluetoothUuid::SerialNumberString), 53},
    {sipName_SerialPort, static_cast<int>(::QBluetoothUuid::SerialPort), 56},
    {sipName_ServerCharacteristicConfiguration, static_cast<int>(::QBluetoothUuid::ServerCharacteristicConfiguration), 54},
    {sipName_ServiceChanged, static_cast<int>(::QBluetoothUuid::ServiceChanged), 53},
    {sipName_ServiceDiscoveryServer, static_cast<int>(::QBluetoothUuid::ServiceDiscoveryServer), 56},
    {sipName_SoftwareRevisionString, static_cast<int>(::QBluetoothUuid::SoftwareRevisionString), 53},
    {sipName_SportTypeForAerobicAnaerobicThresholds, static_cast<int>(::QBluetoothUuid::SportTypeForAerobicAnaerobicThresholds), 53},
    {sipName_SupportedNewAlertCategory, static_cast<int>(::QBluetoothUuid::SupportedNewAlertCategory), 53},
    {sipName_SupportedUnreadAlertCategory, static_cast<int>(::QBluetoothUuid::SupportedUnreadAlertCategory), 53},
    {sipName_Synchronization3D, static_cast<int>(::QBluetoothUuid::Synchronization3D), 56},
    {sipName_SystemID, static_cast<int>(::QBluetoothUuid::SystemID), 53},
    {sipName_Tcp, static_cast<int>(::QBluetoothUuid::Tcp), 55},
    {sipName_TcsAt, static_cast<int>(::QBluetoothUuid::TcsAt), 55},
    {sipName_TcsBin, static_cast<int>(::QBluetoothUuid::TcsBin), 55},
    {sipName_Temperature, static_cast<int>(::QBluetoothUuid::Temperature), 53},
    {sipName_TemperatureMeasurement, static_cast<int>(::QBluetoothUuid::TemperatureMeasurement), 53},
    {sipName_TemperatureType, static_cast<int>(::QBluetoothUuid::TemperatureType), 53},
    {sipName_ThreeZoneHeartRateLimits, static_cast<int>(::QBluetoothUuid::ThreeZoneHeartRateLimits), 53},
    {sipName_TimeAccuracy, static_cast<int>(::QBluetoothUuid::TimeAccuracy), 53},
    {sipName_TimeSource, static_cast<int>(::QBluetoothUuid::TimeSource), 53},
    {sipName_TimeUpdateControlPoint, static_cast<int>(::QBluetoothUuid::TimeUpdateControlPoint), 53},
    {sipName_TimeUpdateState, static_cast<int>(::QBluetoothUuid::TimeUpdateState), 53},
    {sipName_TimeWithDST, static_cast<int>(::QBluetoothUuid::TimeWithDST), 53},
    {sipName_TimeZone, static_cast<int>(::QBluetoothUuid::TimeZone), 53},
    {sipName_TrueWindDirection, static_cast<int>(::QBluetoothUuid::TrueWindDirection), 53},
    {sipName_TrueWindSpeed, static_cast<int>(::QBluetoothUuid::TrueWindSpeed), 53},
    {sipName_TwoZoneHeartRateLimits, static_cast<int>(::QBluetoothUuid::TwoZoneHeartRateLimits), 53},
    {sipName_TxPower, static_cast<int>(::QBluetoothUuid::TxPower), 56},
    {sipName_TxPowerLevel, static_cast<int>(::QBluetoothUuid::TxPowerLevel), 53},
    {sipName_UVIndex, static_cast<int>(::QBluetoothUuid::UVIndex), 53},
    {sipName_UdiCPlain, static_cast<int>(::QBluetoothUuid::UdiCPlain), 55},
    {sipName_Udp, static_cast<int>(::QBluetoothUuid::Udp), 55},
    {sipName_UnknownDescriptorType, static_cast<int>(::QBluetoothUuid::UnknownDescriptorType), 54},
    {sipName_UnreadAlertStatus, static_cast<int>(::QBluetoothUuid::UnreadAlertStatus), 53},
    {sipName_Upnp, static_cast<int>(::QBluetoothUuid::Upnp), 55},
    {sipName_UserControlPoint, static_cast<int>(::QBluetoothUuid::UserControlPoint), 53},
    {sipName_UserData, static_cast<int>(::QBluetoothUuid::UserData), 56},
    {sipName_UserIndex, static_cast<int>(::QBluetoothUuid::UserIndex), 53},
    {sipName_VO2Max, static_cast<int>(::QBluetoothUuid::VO2Max), 53},
    {sipName_ValidRange, static_cast<int>(::QBluetoothUuid::ValidRange), 54},
    {sipName_VideoDistribution, static_cast<int>(::QBluetoothUuid::VideoDistribution), 56},
    {sipName_VideoSink, static_cast<int>(::QBluetoothUuid::VideoSink), 56},
    {sipName_VideoSource, static_cast<int>(::QBluetoothUuid::VideoSource), 56},
    {sipName_WaistCircumference, static_cast<int>(::QBluetoothUuid::WaistCircumference), 53},
    {sipName_Weight, static_cast<int>(::QBluetoothUuid::Weight), 53},
    {sipName_WeightMeasurement, static_cast<int>(::QBluetoothUuid::WeightMeasurement), 53},
    {sipName_WeightScale, static_cast<int>(::QBluetoothUuid::WeightScale), 56},
    {sipName_WeightScaleFeature, static_cast<int>(::QBluetoothUuid::WeightScaleFeature), 53},
    {sipName_WindChill, static_cast<int>(::QBluetoothUuid::WindChill), 53},
    {sipName_Wsp, static_cast<int>(::QBluetoothUuid::Wsp), 55},
};

PyDoc_STRVAR(doc_QBluetoothUuid, "\1QBluetoothUuid()\n"
"QBluetoothUuid(uuid: QBluetoothUuid.ProtocolUuid)\n"
"QBluetoothUuid(uuid: QBluetoothUuid.ServiceClassUuid)\n"
"QBluetoothUuid(uuid: QBluetoothUuid.CharacteristicType)\n"
"QBluetoothUuid(uuid: QBluetoothUuid.DescriptorType)\n"
"QBluetoothUuid(uuid: int)\n"
"QBluetoothUuid(uuid: Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int])\n"
"QBluetoothUuid(uuid: Optional[str])\n"
"QBluetoothUuid(uuid: QBluetoothUuid)\n"
"QBluetoothUuid(uuid: QUuid)");


static pyqt5ClassPluginDef plugin_QBluetoothUuid = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtBluetooth_QBluetoothUuid = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QBluetoothUuid,
        SIP_NULLPTR,
        &plugin_QBluetoothUuid,
    },
    {
        sipNameNr_QBluetoothUuid,
        {0, 0, 1},
        8, methods_QBluetoothUuid,
        266, enummembers_QBluetoothUuid,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QBluetoothUuid,
    -1,
    -1,
    supers_QBluetoothUuid,
    slots_QBluetoothUuid,
    init_type_QBluetoothUuid,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QBluetoothUuid,
    assign_QBluetoothUuid,
    array_QBluetoothUuid,
    copy_QBluetoothUuid,
    release_QBluetoothUuid,
    cast_QBluetoothUuid,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QBluetoothUuid,
    sizeof (::QBluetoothUuid),
};
