/* This file is is generated by a shell script.  DO NOT EDIT! */

/* 32 bit ELF emulation code for elf32ppcsim
   Copyright (C) 1991-2024 Free Software Foundation, Inc.
   Written by Steve Chamberlain <sac@cygnus.com>
   ELF support by Ian Lance Taylor <ian@cygnus.com>

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_elf32ppcsim

#include "sysdep.h"
#include "bfd.h"
#include "libiberty.h"
#include "getopt.h"
#include "bfdlink.h"
#include "ctf-api.h"
#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"
#include <ldgram.h>
#include "elf-bfd.h"
#include "ldelf.h"
#include "ldelfgen.h"

/* Declare functions used by various EXTRA_EM_FILEs.  */
static void gldelf32ppcsim_before_parse (void);
static void gldelf32ppcsim_before_plugin_all_symbols_read
  (void);
static void gldelf32ppcsim_after_open (void);
static void gldelf32ppcsim_before_allocation (void);
static void gldelf32ppcsim_after_allocation (void);


#include "elf32-ppc.h"
#include "ldlex.h"
#include "ldlang.h"

#define is_ppc_elf(bfd)   (bfd_get_flavour (bfd) == bfd_target_elf_flavour    && elf_object_id (bfd) == PPC32_ELF_DATA)

/* Whether to run tls optimization.  */
static int notlsopt = 0;

/* Whether to convert inline PLT calls to direct.  */
static int no_inline_opt = 0;

/* Choose the correct place for .got.  */
static int old_got = 0;

static struct ppc_elf_params params = { PLT_UNSET, 0, -1,
					0, 0, 0, 0, 0, 0, 0 };

static void
ppc_after_open_output (void)
{
  if (params.emit_stub_syms < 0)
    params.emit_stub_syms = (link_info.emitrelocations
			     || bfd_link_pic (&link_info));
  if (params.pagesize == 0)
    params.pagesize = link_info.commonpagesize;
  ppc_elf_link_params (&link_info, &params);
}

static void
ppc_after_check_relocs (void)
{
  if (is_ppc_elf (link_info.output_bfd))
    {
      int new_plt;
      int keep_new;
      unsigned int num_plt;
      unsigned int num_got;
      lang_output_section_statement_type *os;
      lang_output_section_statement_type *plt_os[2];
      lang_output_section_statement_type *got_os[2];

      new_plt = ppc_elf_select_plt_layout (link_info.output_bfd, &link_info);
      if (new_plt < 0)
	einfo (_("%X%P: select_plt_layout problem %E\n"));

      num_got = 0;
      num_plt = 0;
      for (os = (void *) lang_os_list.head;
	   os != NULL;
	   os = os->next)
	{
	  if (os->constraint == SPECIAL && strcmp (os->name, ".plt") == 0)
	    {
	      if (num_plt < 2)
		plt_os[num_plt] = os;
	      ++num_plt;
	    }
	  if (os->constraint == SPECIAL && strcmp (os->name, ".got") == 0)
	    {
	      if (num_got < 2)
		got_os[num_got] = os;
	      ++num_got;
	    }
	}

      keep_new = new_plt == 1 ? 0 : -1;
      if (num_plt == 2)
	{
	  plt_os[0]->constraint = keep_new;
	  plt_os[1]->constraint = ~keep_new;
	}
      if (num_got == 2)
	{
	  if (old_got)
	    keep_new = -1;
	  got_os[0]->constraint = keep_new;
	  got_os[1]->constraint = ~keep_new;
	}
    }

  after_check_relocs_default ();
}

static void
prelim_size_sections (void)
{
  if (expld.phase != lang_mark_phase_enum)
    {
      expld.phase = lang_mark_phase_enum;
      expld.dataseg.phase = exp_seg_none;
      one_lang_size_sections_pass (NULL, false);
      /* We must not cache anything from the preliminary sizing.  */
      lang_reset_memory_regions ();
    }
}

static void
ppc_before_allocation (void)
{
  if (is_ppc_elf (link_info.output_bfd))
    {
      if (!no_inline_opt
	  && !bfd_link_relocatable (&link_info))
	{
	  prelim_size_sections ();

	  if (!ppc_elf_inline_plt (&link_info))
	    einfo (_("%X%P: inline PLT: %E\n"));
	}

      if (ppc_elf_tls_setup (link_info.output_bfd, &link_info)
	  && !notlsopt)
	{
	  if (!ppc_elf_tls_optimize (link_info.output_bfd, &link_info))
	    {
	      einfo (_("%X%P: TLS problem %E\n"));
	      return;
	    }
	}
    }

  gldelf32ppcsim_before_allocation ();

  ppc_elf_maybe_strip_sdata_syms (&link_info);

  if (RELAXATION_ENABLED)
    params.branch_trampolines = 1;

  /* Turn on relaxation if executable sections have addresses that
     might make branches overflow.  */
  else if (!RELAXATION_DISABLED_BY_USER)
    {
      bfd_vma low = (bfd_vma) -1;
      bfd_vma high = 0;
      asection *o;

      /* Run lang_size_sections even if already done, so as to pick
	 up gldelf32ppcsim_before_allocation sizing.  This
	 matters when we have an executable bss plt which will
	 typically be laid out near the end of the image, ie. worst
	 case for branches at the start of .text.  */
      expld.phase = lang_first_phase_enum;
      prelim_size_sections ();

      for (o = link_info.output_bfd->sections; o != NULL; o = o->next)
	{
	  if ((o->flags & (SEC_ALLOC | SEC_CODE)) != (SEC_ALLOC | SEC_CODE))
	    continue;
	  if (o->rawsize == 0)
	    continue;
	  if (low > o->vma)
	    low = o->vma;
	  if (high < o->vma + o->rawsize - 1)
	    high = o->vma + o->rawsize - 1;
	}
      if (high > low && high - low > (1 << 25) - 1)
	params.branch_trampolines = 1;
    }

  if (params.branch_trampolines
      || params.ppc476_workaround
      || params.pic_fixup > 0)
    ENABLE_RELAXATION;
}

/* Replaces default zero fill padding in executable sections with
   "ba 0" instructions.  This works around the ppc476 icache bug if we
   have a function pointer tail call near the end of a page, some
   small amount of padding, then the function called at the beginning
   of the next page.  If the "ba 0" is ever executed we should hit a
   segv, so it's almost as good as an illegal instruction (zero).  */

static void
no_zero_padding (lang_statement_union_type *l)
{
  if (l->header.type == lang_padding_statement_enum
      && l->padding_statement.size != 0
      && l->padding_statement.output_section != NULL
      && (l->padding_statement.output_section->flags & SEC_CODE) != 0
      && l->padding_statement.fill->size == 0)
    {
      struct _ppc_fill_type
      {
	size_t size;
	unsigned char data[4];
      };
      static struct _ppc_fill_type fill_be = { 4, {0x48, 0, 0, 2} };
      static struct _ppc_fill_type fill_le = { 4, {2, 0, 0, 0x48} };

      if (bfd_big_endian (link_info.output_bfd))
	l->padding_statement.fill = (struct _fill_type *) &fill_be;
      else
	l->padding_statement.fill = (struct _fill_type *) &fill_le;
    }
}

static void
ppc_finish (void)
{
  if (params.ppc476_workaround)
    lang_for_each_statement (no_zero_padding);
  if (!ppc_finish_symbols (&link_info))
    einfo (_("%X%P: ppc_finish_symbols problem %E\n"));
  finish_default ();
}


static void
gldelf32ppcsim_before_parse (void)
{
  ldfile_set_output_arch ("powerpc:common", bfd_arch_powerpc);
  input_flags.dynamic = true;
  config.has_shared = true;
  config.separate_code = false;
  link_info.check_relocs_after_open_input = true;
  link_info.relro = DEFAULT_LD_Z_RELRO;
  link_info.separate_code = DEFAULT_LD_Z_SEPARATE_CODE;
  link_info.warn_execstack = DEFAULT_LD_WARN_EXECSTACK;
  link_info.no_warn_rwx_segments = ! DEFAULT_LD_WARN_RWX_SEGMENTS;
  link_info.default_execstack = DEFAULT_LD_EXECSTACK;
  link_info.error_execstack = DEFAULT_LD_ERROR_EXECSTACK;
  link_info.warn_is_error_for_rwx_segments = DEFAULT_LD_ERROR_RWX_SEGMENTS;
}


/* These variables are used to implement target options */

static char *audit; /* colon (typically) separated list of libs */
static char *depaudit; /* colon (typically) separated list of libs */


/* This is called before calling plugin 'all symbols read' hook.  */

static void
gldelf32ppcsim_before_plugin_all_symbols_read (void)
{
  ldelf_before_plugin_all_symbols_read (false, false,
				        false,
					false,
					32, "/usr");
}

/* This is called after all the input files have been opened.  */

static void
gldelf32ppcsim_after_open (void)
{
  ldelf_after_open (false, false,
		    false, false, 32, "/usr");
}


/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gldelf32ppcsim_before_allocation (void)
{
  ldelf_before_allocation (audit, depaudit, NULL);
}


static void
gldelf32ppcsim_after_allocation (void)
{
  int need_layout = bfd_elf_discard_info (link_info.output_bfd, &link_info);

  if (need_layout < 0)
    einfo (_("%X%P: .eh_frame/.stab edit: %E\n"));
  else
    ldelf_map_segments (need_layout);
}

static char *
gldelf32ppcsim_get_script (int *isfile)
{
  *isfile = 1;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return "ldscripts/elf32ppcsim.xu";
  else if (bfd_link_relocatable (&link_info))
    return "ldscripts/elf32ppcsim.xr";
  else if (!config.text_read_only)
    return "ldscripts/elf32ppcsim.xbn";
  else if (!config.magic_demand_paged)
    return "ldscripts/elf32ppcsim.xn";
  else if (bfd_link_pie (&link_info)
	   && link_info.combreloc
	   && link_info.relro
	   && (link_info.flags & DF_BIND_NOW))
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xdwe";
      else
	return "ldscripts/elf32ppcsim.xdw";
    }
  else if (bfd_link_pie (&link_info)
	   && link_info.combreloc)
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xdce";
      else
	return "ldscripts/elf32ppcsim.xdc";
    }
  else if (bfd_link_pie (&link_info))
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xde";
      else
	return "ldscripts/elf32ppcsim.xd";
    }
  else if (bfd_link_dll (&link_info) && link_info.combreloc
	   && link_info.relro && (link_info.flags & DF_BIND_NOW))
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xswe";
      else
	return "ldscripts/elf32ppcsim.xsw";
    }
  else if (bfd_link_dll (&link_info) && link_info.combreloc)
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xsce";
      else
	return "ldscripts/elf32ppcsim.xsc";
    }
  else if (bfd_link_dll (&link_info))
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xse";
      else
	return "ldscripts/elf32ppcsim.xs";
    }
  else if (link_info.combreloc && link_info.relro
	   && (link_info.flags & DF_BIND_NOW))
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xwe";
      else
	return "ldscripts/elf32ppcsim.xw";
    }
  else if (link_info.combreloc)
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xce";
      else
	return "ldscripts/elf32ppcsim.xc";
    }
  else
    {
      if (link_info.separate_code)
	return "ldscripts/elf32ppcsim.xe";
      else
	return "ldscripts/elf32ppcsim.x";
    }
}

 
#define OPTION_LD_GENERATED_UNWIND_INFO	301
#define OPTION_NO_LD_GENERATED_UNWIND_INFO 302

enum ppc32_opt
{
  OPTION_NO_TLS_OPT = 321,
  OPTION_NO_TLS_GET_ADDR_OPT,
  OPTION_NEW_PLT,
  OPTION_OLD_PLT,
  OPTION_PLT_ALIGN,
  OPTION_NO_PLT_ALIGN,
  OPTION_NO_INLINE_OPT,
  OPTION_OLD_GOT,
  OPTION_STUBSYMS,
  OPTION_NO_STUBSYMS,
  OPTION_PPC476_WORKAROUND,
  OPTION_NO_PPC476_WORKAROUND,
  OPTION_NO_PICFIXUP,
  OPTION_VLE_RELOC_FIXUP
};


enum elf_options
{
  OPTION_DISABLE_NEW_DTAGS = 400,
  OPTION_ENABLE_NEW_DTAGS,
  OPTION_GROUP,
  OPTION_EH_FRAME_HDR,
  OPTION_NO_EH_FRAME_HDR,
  OPTION_EXCLUDE_LIBS,
  OPTION_HASH_STYLE,
  OPTION_BUILD_ID,
  OPTION_PACKAGE_METADATA,
  OPTION_AUDIT,
  OPTION_COMPRESS_DEBUG
};

static void
gldelf32ppcsim_add_options
  (int ns, char **shortopts, int nl, struct option **longopts,
   int nrl ATTRIBUTE_UNUSED, struct option **really_longopts ATTRIBUTE_UNUSED)
{
  static const char xtra_short[] = "z:P:";
  static const struct option xtra_long[] = {
    {"audit", required_argument, NULL, OPTION_AUDIT},
    {"Bgroup", no_argument, NULL, OPTION_GROUP},
    {"build-id", optional_argument, NULL, OPTION_BUILD_ID},
    {"package-metadata", optional_argument, NULL, OPTION_PACKAGE_METADATA},
    {"compress-debug-sections", required_argument, NULL, OPTION_COMPRESS_DEBUG},
    {"depaudit", required_argument, NULL, 'P'},
    {"disable-new-dtags", no_argument, NULL, OPTION_DISABLE_NEW_DTAGS},
    {"enable-new-dtags", no_argument, NULL, OPTION_ENABLE_NEW_DTAGS},
    {"eh-frame-hdr", no_argument, NULL, OPTION_EH_FRAME_HDR},
    {"no-eh-frame-hdr", no_argument, NULL, OPTION_NO_EH_FRAME_HDR},
    {"exclude-libs", required_argument, NULL, OPTION_EXCLUDE_LIBS},
    {"hash-style", required_argument, NULL, OPTION_HASH_STYLE},
    
  {"ld-generated-unwind-info", no_argument, NULL,
   OPTION_LD_GENERATED_UNWIND_INFO},
  {"no-ld-generated-unwind-info", no_argument, NULL,
   OPTION_NO_LD_GENERATED_UNWIND_INFO},

  { "emit-stub-syms", no_argument, NULL, OPTION_STUBSYMS },
  { "no-emit-stub-syms", no_argument, NULL, OPTION_NO_STUBSYMS },
  { "no-tls-optimize", no_argument, NULL, OPTION_NO_TLS_OPT },
  { "no-tls-get-addr-optimize", no_argument, NULL, OPTION_NO_TLS_GET_ADDR_OPT },
  { "secure-plt", no_argument, NULL, OPTION_NEW_PLT },
  { "bss-plt", no_argument, NULL, OPTION_OLD_PLT },
  { "plt-align", optional_argument, NULL, OPTION_PLT_ALIGN },
  { "no-plt-align", no_argument, NULL, OPTION_NO_PLT_ALIGN },
  { "no-inline-optimize", no_argument, NULL, OPTION_NO_INLINE_OPT },
  { "sdata-got", no_argument, NULL, OPTION_OLD_GOT },
  { "ppc476-workaround", optional_argument, NULL, OPTION_PPC476_WORKAROUND },
  { "no-ppc476-workaround", no_argument, NULL, OPTION_NO_PPC476_WORKAROUND },
  { "no-pic-fixup", no_argument, NULL, OPTION_NO_PICFIXUP },
  { "vle-reloc-fixup", no_argument, NULL, OPTION_VLE_RELOC_FIXUP },

    {NULL, no_argument, NULL, 0}
  };

  *shortopts = (char *) xrealloc (*shortopts, ns + sizeof (xtra_short));
  memcpy (*shortopts + ns, &xtra_short, sizeof (xtra_short));
  *longopts = (struct option *)
    xrealloc (*longopts, nl * sizeof (struct option) + sizeof (xtra_long));
  memcpy (*longopts + nl, &xtra_long, sizeof (xtra_long));
}

#define DEFAULT_BUILD_ID_STYLE	"sha1"

static bool
gldelf32ppcsim_handle_option (int optc)
{
  switch (optc)
    {
    default:
      return false;

    case OPTION_BUILD_ID:
      free ((char *) ldelf_emit_note_gnu_build_id);
      ldelf_emit_note_gnu_build_id = NULL;
      if (optarg == NULL)
	optarg = DEFAULT_BUILD_ID_STYLE;
      if (strcmp (optarg, "none"))
	ldelf_emit_note_gnu_build_id = xstrdup (optarg);
      break;

    case OPTION_PACKAGE_METADATA:
      free ((char *) ldelf_emit_note_fdo_package_metadata);
      ldelf_emit_note_fdo_package_metadata = NULL;
      if (optarg != NULL && strlen(optarg) > 0)
	ldelf_emit_note_fdo_package_metadata = xstrdup (optarg);
      break;

    case OPTION_COMPRESS_DEBUG:
      config.compress_debug = bfd_get_compression_algorithm (optarg);
      if (strcasecmp (optarg, "zstd") == 0)
	{
#ifndef HAVE_ZSTD
	  if (config.compress_debug == COMPRESS_DEBUG_ZSTD)
	    einfo (_ ("%F%P: --compress-debug-sections=zstd: ld is not built "
		  "with zstd support\n"));
#endif
	}
      if (config.compress_debug == COMPRESS_UNKNOWN)
	einfo (_("%F%P: invalid --compress-debug-sections option: `%s'\n"),
	       optarg);
      break;
    case OPTION_AUDIT:
	ldelf_append_to_separated_string (&audit, optarg);
	break;

    case 'P':
	ldelf_append_to_separated_string (&depaudit, optarg);
	break;

    case OPTION_DISABLE_NEW_DTAGS:
      link_info.new_dtags = false;
      break;

    case OPTION_ENABLE_NEW_DTAGS:
      link_info.new_dtags = true;
      break;

    case OPTION_EH_FRAME_HDR:
      link_info.eh_frame_hdr_type = DWARF2_EH_HDR;
      break;

    case OPTION_NO_EH_FRAME_HDR:
      link_info.eh_frame_hdr_type = 0;
      break;

    case OPTION_GROUP:
      link_info.flags_1 |= (bfd_vma) DF_1_GROUP;
      /* Groups must be self-contained.  */
      link_info.unresolved_syms_in_objects = RM_DIAGNOSE;
      link_info.unresolved_syms_in_shared_libs = RM_DIAGNOSE;
      break;

    case OPTION_EXCLUDE_LIBS:
      add_excluded_libs (optarg);
      break;

    case OPTION_HASH_STYLE:
      link_info.emit_hash = false;
      link_info.emit_gnu_hash = false;
      if (strcmp (optarg, "sysv") == 0)
	link_info.emit_hash = true;
      else if (strcmp (optarg, "gnu") == 0)
	link_info.emit_gnu_hash = true;
      else if (strcmp (optarg, "both") == 0)
	{
	  link_info.emit_hash = true;
	  link_info.emit_gnu_hash = true;
	}
      else
	einfo (_("%F%P: invalid hash style `%s'\n"), optarg);
      break;

    case 'z':
      if (strcmp (optarg, "defs") == 0)
	link_info.unresolved_syms_in_objects = RM_DIAGNOSE;
      else if (strcmp (optarg, "undefs") == 0)
	link_info.unresolved_syms_in_objects = RM_IGNORE;
      else if (strcmp (optarg, "muldefs") == 0)
	link_info.allow_multiple_definition = true;
      else if (startswith (optarg, "max-page-size="))
	{
	  char *end;

	  link_info.maxpagesize = strtoul (optarg + 14, &end, 0);
	  if (*end
	      || (link_info.maxpagesize & (link_info.maxpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid maximum page size `%s'\n"),
		   optarg + 14);
	  link_info.maxpagesize_is_set = true;
	}
      else if (startswith (optarg, "common-page-size="))
	{
	  char *end;
	  link_info.commonpagesize = strtoul (optarg + 17, &end, 0);
	  if (*end
	      || (link_info.commonpagesize & (link_info.commonpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid common page size `%s'\n"),
		   optarg + 17);
	  link_info.commonpagesize_is_set = true;
	}
      else if (startswith (optarg, "stack-size="))
	{
	  char *end;
	  link_info.stacksize = strtoul (optarg + 11, &end, 0);
	  if (*end || link_info.stacksize < 0)
	    einfo (_("%F%P: invalid stack size `%s'\n"), optarg + 11);
	  if (!link_info.stacksize)
	    /* Use -1 for explicit no-stack, because zero means
	       'default'.   */
	    link_info.stacksize = -1;
	}
      else if (strcmp (optarg, "execstack") == 0)
	{
	  link_info.execstack = true;
	  link_info.noexecstack = false;
	}
      else if (strcmp (optarg, "noexecstack") == 0)
	{
	  link_info.noexecstack = true;
	  link_info.execstack = false;
	}
      else if (strcmp (optarg, "unique-symbol") == 0)
	link_info.unique_symbol = true;
      else if (strcmp (optarg, "nounique-symbol") == 0)
	link_info.unique_symbol = false;
      else if (strcmp (optarg, "globalaudit") == 0)
	{
	  link_info.flags_1 |= DF_1_GLOBAUDIT;
	}
      else if (startswith (optarg, "start-stop-gc"))
	link_info.start_stop_gc = true;
      else if (startswith (optarg, "nostart-stop-gc"))
	link_info.start_stop_gc = false;
      else if (startswith (optarg, "start-stop-visibility="))
	{
	  if (strcmp (optarg, "start-stop-visibility=default") == 0)
	    link_info.start_stop_visibility = STV_DEFAULT;
	  else if (strcmp (optarg, "start-stop-visibility=internal") == 0)
	    link_info.start_stop_visibility = STV_INTERNAL;
	  else if (strcmp (optarg, "start-stop-visibility=hidden") == 0)
	    link_info.start_stop_visibility = STV_HIDDEN;
	  else if (strcmp (optarg, "start-stop-visibility=protected") == 0)
	    link_info.start_stop_visibility = STV_PROTECTED;
	  else
	    einfo (_("%F%P: invalid visibility in `-z %s'; "
		     "must be default, internal, hidden, or protected"),
		   optarg);
	}
      else if (strcmp (optarg, "sectionheader") == 0)
	config.no_section_header = false;
      else if (strcmp (optarg, "nosectionheader") == 0)
	config.no_section_header = true;
      else if (strcmp (optarg, "global") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_GLOBAL;
      else if (strcmp (optarg, "initfirst") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INITFIRST;
      else if (strcmp (optarg, "interpose") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INTERPOSE;
      else if (strcmp (optarg, "loadfltr") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_LOADFLTR;
      else if (strcmp (optarg, "nodefaultlib") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODEFLIB;
      else if (strcmp (optarg, "nodelete") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODELETE;
      else if (strcmp (optarg, "nodlopen") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NOOPEN;
      else if (strcmp (optarg, "nodump") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODUMP;
      else if (strcmp (optarg, "now") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 |= (bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "lazy") == 0)
	{
	  link_info.flags &= ~(bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 &= ~(bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "origin") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_ORIGIN;
	  link_info.flags_1 |= (bfd_vma) DF_1_ORIGIN;
	}
      else if (strcmp (optarg, "unique") == 0)
	link_info.gnu_flags_1 |= (bfd_vma) DF_GNU_1_UNIQUE;
      else if (strcmp (optarg, "nounique") == 0)
	link_info.gnu_flags_1 &= ~(bfd_vma) DF_GNU_1_UNIQUE;
      else if (strcmp (optarg, "combreloc") == 0)
	link_info.combreloc = true;
      else if (strcmp (optarg, "nocombreloc") == 0)
	link_info.combreloc = false;
      else if (strcmp (optarg, "nocopyreloc") == 0)
	link_info.nocopyreloc = true;
      else if (strcmp (optarg, "relro") == 0)
	link_info.relro = true;
      else if (strcmp (optarg, "norelro") == 0)
	link_info.relro = false;
      else if (strcmp (optarg, "separate-code") == 0)
	link_info.separate_code = true;
      else if (strcmp (optarg, "noseparate-code") == 0)
	link_info.separate_code = false;
      else if (strcmp (optarg, "common") == 0)
	link_info.elf_stt_common = elf_stt_common;
      else if (strcmp (optarg, "nocommon") == 0)
	link_info.elf_stt_common = no_elf_stt_common;
      else if (strcmp (optarg, "text") == 0)
	link_info.textrel_check = textrel_check_error;
      else if (strcmp (optarg, "notext") == 0)
	link_info.textrel_check = textrel_check_none;
      else if (strcmp (optarg, "textoff") == 0)
	link_info.textrel_check = textrel_check_none;
  
      else if (strcmp (optarg, "dynamic-undefined-weak") == 0)
	link_info.dynamic_undefined_weak = true;
      else if (strcmp (optarg, "nodynamic-undefined-weak") == 0)
	link_info.dynamic_undefined_weak = false;

      else
	einfo (_("%P: warning: -z %s ignored\n"), optarg);
      break;
 
    case OPTION_LD_GENERATED_UNWIND_INFO:
      link_info.no_ld_generated_unwind_info = false;
      break;

    case OPTION_NO_LD_GENERATED_UNWIND_INFO:
      link_info.no_ld_generated_unwind_info = true;
      break;

    case OPTION_STUBSYMS:
      params.emit_stub_syms = 1;
      break;

    case OPTION_NO_STUBSYMS:
      params.emit_stub_syms = 0;
      break;

    case OPTION_NO_TLS_OPT:
      notlsopt = 1;
      break;

    case OPTION_NO_TLS_GET_ADDR_OPT:
      params.no_tls_get_addr_opt = 1;
      break;

    case OPTION_NEW_PLT:
      params.plt_style = PLT_NEW;
      break;

    case OPTION_OLD_PLT:
      params.plt_style = PLT_OLD;
      break;

    case OPTION_PLT_ALIGN:
      if (optarg != NULL)
	{
	  char *end;
	  unsigned long val = strtoul (optarg, &end, 0);
	  if (*end || val > 5)
	    einfo (_("%F%P: invalid --plt-align `%s'\n"), optarg);
	  params.plt_stub_align = val;
	}
      else
	params.plt_stub_align = 5;
      break;

    case OPTION_NO_PLT_ALIGN:
      params.plt_stub_align = 0;
      break;

    case OPTION_NO_INLINE_OPT:
      no_inline_opt = 1;
      break;

    case OPTION_OLD_GOT:
      old_got = 1;
      break;

    case OPTION_TRADITIONAL_FORMAT:
      notlsopt = 1;
      params.no_tls_get_addr_opt = 1;
      return false;

    case OPTION_PPC476_WORKAROUND:
      params.ppc476_workaround = 1;
      if (optarg != NULL)
	{
	  char *end;
	  params.pagesize = strtoul (optarg, &end, 0);
	  if (*end
	      || (params.pagesize < 4096 && params.pagesize != 0)
	      || params.pagesize != (params.pagesize & -params.pagesize))
	    einfo (_("%F%P: invalid pagesize `%s'\n"), optarg);
	}
      break;

    case OPTION_NO_PPC476_WORKAROUND:
      params.ppc476_workaround = 0;
      break;

    case OPTION_NO_PICFIXUP:
      params.pic_fixup = -1;
      break;

    case OPTION_VLE_RELOC_FIXUP:
      params.vle_reloc_fixup = 1;
      break;

    }

  return true;
}


static void
gldelf32ppcsim_list_options (FILE * file)
{
  
  fprintf (file, _("\
  -z dynamic-undefined-weak   Make undefined weak symbols dynamic\n\
  -z nodynamic-undefined-weak Do not make undefined weak symbols dynamic\n"));

  fprintf (file, _("\
  --emit-stub-syms            Label linker stubs with a symbol\n"
		   ));
  fprintf (file, _("\
  --no-emit-stub-syms         Don't label linker stubs with a symbol\n"
		   ));
  fprintf (file, _("\
  --no-tls-optimize           Don't try to optimize TLS accesses\n"
		   ));
  fprintf (file, _("\
  --no-tls-get-addr-optimize  Don't use a special __tls_get_addr call\n"
		   ));\
  fprintf (file, _("\
  --secure-plt                Use new-style PLT if possible\n"
		   ));
  fprintf (file, _("\
  --bss-plt                   Force old-style BSS PLT\n"
		   ));
  fprintf (file, _("\
  --plt-align                 Align PLT call stubs to fit cache lines\n"
		   ));
  fprintf (file, _("\
  --no-plt-align              Dont't align individual PLT call stubs\n"
		   ));
  fprintf (file, _("\
  --no-inline-optimize        Don't convert inline PLT to direct calls\n"
		   ));
  fprintf (file, _("\
  --sdata-got                 Force GOT location just before .sdata\n"
		   ));\
  fprintf (file, _("\
  --ppc476-workaround [=pagesize]\n\
                              Avoid a cache bug on ppc476\n"
		   ));
  fprintf (file, _("\
  --no-ppc476-workaround      Disable workaround\n"
		   ));
  fprintf (file, _("\
  --no-pic-fixup              Don't edit non-pic to pic\n"
		   ));
  fprintf (file, _("\
  --vle-reloc-fixup           Correct old object file 16A/16D relocation\n"
		   ));

}

struct ld_emulation_xfer_struct ld_elf32ppcsim_emulation =
{
  gldelf32ppcsim_before_parse,
  syslib_default,
  hll_default,
  ldelf_after_parse,
  gldelf32ppcsim_before_plugin_all_symbols_read,
  gldelf32ppcsim_after_open,
  ppc_after_check_relocs,
  ldelf_before_place_orphans,
  gldelf32ppcsim_after_allocation,
  ldelf_set_output_arch,
  ldemul_default_target,
  ppc_before_allocation,
  gldelf32ppcsim_get_script,
  "elf32ppcsim",
  "elf32-powerpc",
  ppc_finish,
  ppc_after_open_output,
  ldelf_open_dynamic_archive,
  ldelf_place_orphan,
  NULL,
  NULL,
  gldelf32ppcsim_add_options,
  gldelf32ppcsim_handle_option,
  NULL,
  gldelf32ppcsim_list_options,
  ldelf_load_symbols,
  NULL,
  NULL,
  NULL,
  ldelf_emit_ctf_early,
  ldelf_acquire_strings_for_ctf,
  ldelf_new_dynsym_for_ctf,
  NULL
};
