/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*  
 *  (C) 2003 by Argonne National Laboratory and Northwestern University.
 *      See COPYRIGHT in top-level directory.
 *
 * This file is automatically generated by command:
 *     ./buildiface -infile=../../../src/include/pnetcdf.h -deffile=./defs
 * DO NOT EDIT
 */
#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif
#include "mpinetcdf_impl.h"


/* Prototypes for the Fortran interfaces */
#include "mpifnetcdf.h"

#ifdef F77_NAME_UPPER
#define nfmpi_create_ NFMPI_CREATE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_create_ nfmpi_create__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_create_ nfmpi_create
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_create_ ( MPI_Fint *v1, char *v2 FORT_MIXED_LEN(d2), MPI_Fint *v3, MPI_Fint *v4, int *v5 FORT_END_LEN(d2) ){
    int ierr;
    char *p2, *pt2;
    int l5;

    pt2 = v2 + d2 - 1; /* point to the end of string v2 */
    while (*pt2 == ' ' && pt2 > v2) pt2--; /* find the last non-blank */
    pt2++;
    /* it is possible character array v2 is of exact lenght d2 */
    p2 = (char *) malloc((size_t)(pt2-v2) + 1);
    memcpy(p2, v2, (size_t)(pt2-v2));
    p2[pt2-v2] = '\0';
    ierr = ncmpi_create( MPI_Comm_f2c(*v1), p2, (int)(*v3), MPI_Info_f2c(*v4), &l5 );
    free(p2);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_open_ NFMPI_OPEN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_open_ nfmpi_open__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_open_ nfmpi_open
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_open_ ( MPI_Fint *v1, char *v2 FORT_MIXED_LEN(d2), MPI_Fint *v3, MPI_Fint *v4, int *v5 FORT_END_LEN(d2) ){
    int ierr;
    char *p2, *pt2;
    int l5;

    pt2 = v2 + d2 - 1; /* point to the end of string v2 */
    while (*pt2 == ' ' && pt2 > v2) pt2--; /* find the last non-blank */
    pt2++;
    /* it is possible character array v2 is of exact lenght d2 */
    p2 = (char *) malloc((size_t)(pt2-v2) + 1);
    memcpy(p2, v2, (size_t)(pt2-v2));
    p2[pt2-v2] = '\0';
    ierr = ncmpi_open( MPI_Comm_f2c(*v1), p2, (int)(*v3), MPI_Info_f2c(*v4), &l5 );
    free(p2);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_file_info_ NFMPI_INQ_FILE_INFO
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_file_info_ nfmpi_inq_file_info__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_file_info_ nfmpi_inq_file_info
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_file_info_ ( MPI_Fint *v1, MPI_Fint *v2 ){
    int ierr;
    MPI_Info info;

    ierr = ncmpi_inq_file_info( (int)(*v1), &info );
    *v2 = MPI_Info_c2f(info);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_file_info_ NFMPI_GET_FILE_INFO
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_file_info_ nfmpi_get_file_info__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_file_info_ nfmpi_get_file_info
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_file_info_ ( MPI_Fint *v1, MPI_Fint *v2 ){
    int ierr;
    MPI_Info info;

    ierr = ncmpi_get_file_info( (int)(*v1), &info );
    *v2 = MPI_Info_c2f(info);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_delete_ NFMPI_DELETE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_delete_ nfmpi_delete__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_delete_ nfmpi_delete
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_delete_ ( char *v1 FORT_MIXED_LEN(d1), MPI_Fint *v2 FORT_END_LEN(d1) ){
    int ierr;
    char *p1, *pt1;

    pt1 = v1 + d1 - 1; /* point to the end of string v1 */
    while (*pt1 == ' ' && pt1 > v1) pt1--; /* find the last non-blank */
    pt1++;
    /* it is possible character array v1 is of exact lenght d1 */
    p1 = (char *) malloc((size_t)(pt1-v1) + 1);
    memcpy(p1, v1, (size_t)(pt1-v1));
    p1[pt1-v1] = '\0';
    ierr = ncmpi_delete( p1, MPI_Info_f2c(*v2) );
    free(p1);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_enddef_ NFMPI_ENDDEF
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_enddef_ nfmpi_enddef__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_enddef_ nfmpi_enddef
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_enddef_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_enddef( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi__enddef_ NFMPI__ENDDEF
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi__enddef_ nfmpi__enddef__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi__enddef_ nfmpi__enddef
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi__enddef_ ( MPI_Fint *v1, MPI_Offset *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5 ){
    int ierr;
    ierr = ncmpi__enddef( (int)(*v1), *v2, *v3, *v4, *v5 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_redef_ NFMPI_REDEF
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_redef_ nfmpi_redef__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_redef_ nfmpi_redef
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_redef_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_redef( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_set_default_format_ NFMPI_SET_DEFAULT_FORMAT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_set_default_format_ nfmpi_set_default_format__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_set_default_format_ nfmpi_set_default_format
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_set_default_format_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_set_default_format( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_default_format_ NFMPI_INQ_DEFAULT_FORMAT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_default_format_ nfmpi_inq_default_format__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_default_format_ nfmpi_inq_default_format
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_default_format_ ( int *v1 ){
    int ierr;
    int l1;
    ierr = ncmpi_inq_default_format( &l1 );

    if (ierr == NC_NOERR) *v1 = (int)l1; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_sync_ NFMPI_SYNC
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_sync_ nfmpi_sync__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_sync_ nfmpi_sync
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_sync_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_sync( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_flush_ NFMPI_FLUSH
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_flush_ nfmpi_flush__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_flush_ nfmpi_flush
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_flush_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_flush( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_sync_numrecs_ NFMPI_SYNC_NUMRECS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_sync_numrecs_ nfmpi_sync_numrecs__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_sync_numrecs_ nfmpi_sync_numrecs
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_sync_numrecs_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_sync_numrecs( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_abort_ NFMPI_ABORT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_abort_ nfmpi_abort__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_abort_ nfmpi_abort
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_abort_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_abort( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_begin_indep_data_ NFMPI_BEGIN_INDEP_DATA
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_begin_indep_data_ nfmpi_begin_indep_data__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_begin_indep_data_ nfmpi_begin_indep_data
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_begin_indep_data_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_begin_indep_data( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_end_indep_data_ NFMPI_END_INDEP_DATA
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_end_indep_data_ nfmpi_end_indep_data__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_end_indep_data_ nfmpi_end_indep_data
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_end_indep_data_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_end_indep_data( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_close_ NFMPI_CLOSE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_close_ nfmpi_close__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_close_ nfmpi_close
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_close_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_close( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_set_fill_ NFMPI_SET_FILL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_set_fill_ nfmpi_set_fill__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_set_fill_ nfmpi_set_fill
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_set_fill_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    int l3;
    ierr = ncmpi_set_fill( (int)(*v1), (int)(*v2), &l3 );

    if (ierr == NC_NOERR) *v3 = (int)l3; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_def_var_fill_ NFMPI_DEF_VAR_FILL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_def_var_fill_ nfmpi_def_var_fill__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_def_var_fill_ nfmpi_def_var_fill
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_def_var_fill_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, void *v4 ){
    int ierr;
    ierr = ncmpi_def_var_fill( (int)(*v1), (int)(*v2 - 1), (int)(*v3), v4 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_fill_var_rec_ NFMPI_FILL_VAR_REC
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_fill_var_rec_ nfmpi_fill_var_rec__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_fill_var_rec_ nfmpi_fill_var_rec
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_fill_var_rec_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3 ){
    int ierr;
    MPI_Offset l3 = *v3 - 1;
    ierr = ncmpi_fill_var_rec( (int)(*v1), (int)(*v2 - 1), l3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_def_dim_ NFMPI_DEF_DIM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_def_dim_ nfmpi_def_dim__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_def_dim_ nfmpi_def_dim
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_def_dim_ ( MPI_Fint *v1, char *v2 FORT_MIXED_LEN(d2), MPI_Offset *v3, int *v4 FORT_END_LEN(d2) ){
    int ierr;
    char *p2, *pt2;
    int l4;

    pt2 = v2 + d2 - 1; /* point to the end of string v2 */
    while (*pt2 == ' ' && pt2 > v2) pt2--; /* find the last non-blank */
    pt2++;
    /* it is possible character array v2 is of exact lenght d2 */
    p2 = (char *) malloc((size_t)(pt2-v2) + 1);
    memcpy(p2, v2, (size_t)(pt2-v2));
    p2[pt2-v2] = '\0';
    ierr = ncmpi_def_dim( (int)(*v1), p2, *v3, &l4 );
    free(p2);

    if (ierr == NC_NOERR) *v4 = l4 + 1;
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_def_var_ NFMPI_DEF_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_def_var_ nfmpi_def_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_def_var_ nfmpi_def_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_def_var_ ( MPI_Fint *v1, char *v2 FORT_MIXED_LEN(d2), MPI_Fint *v3, MPI_Fint *v4, int *v5, int *v6 FORT_END_LEN(d2) ){
    int ierr;
    char *p2, *pt2;
    int *l5=NULL;
    int ln5;
    int l6;

    pt2 = v2 + d2 - 1; /* point to the end of string v2 */
    while (*pt2 == ' ' && pt2 > v2) pt2--; /* find the last non-blank */
    pt2++;
    /* it is possible character array v2 is of exact lenght d2 */
    p2 = (char *) malloc((size_t)(pt2-v2) + 1);
    memcpy(p2, v2, (size_t)(pt2-v2));
    p2[pt2-v2] = '\0';

    ln5 = *v4;
    if (ln5 > 0) {
        int li;
        l5 = (int*) malloc( (size_t)ln5 * SIZEOF_INT);
        for (li=0; li<ln5; li++) /* convert Fortran order to C order */
            l5[li] = v5[ln5-li-1]-1; /* convert 1-based MPI_Fint to 0-based int */
    }
    
    ierr = ncmpi_def_var( (int)(*v1), p2, (nc_type)(*v3), (int)(*v4), l5, &l6 );
    free(p2);
    if (l5 != NULL) free(l5);

    if (ierr == NC_NOERR) *v6 = l6 + 1;
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_rename_dim_ NFMPI_RENAME_DIM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_rename_dim_ nfmpi_rename_dim__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_rename_dim_ nfmpi_rename_dim
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_rename_dim_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_rename_dim( (int)(*v1), (int)(*v2 - 1), p3 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_rename_var_ NFMPI_RENAME_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_rename_var_ nfmpi_rename_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_rename_var_ nfmpi_rename_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_rename_var_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_rename_var( (int)(*v1), (int)(*v2 - 1), p3 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_ NFMPI_INQ
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_ nfmpi_inq__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_ nfmpi_inq
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_ ( MPI_Fint *v1, int *v2, int *v3, int *v4, int *v5 ){
    int ierr;
    int l2;
    int l3;
    int l4;
    int l5;
    ierr = ncmpi_inq( (int)(*v1), &l2, &l3, &l4, &l5 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */

    if (ierr == NC_NOERR) *v3 = (int)l3; /* cast int to MPI_Fint */

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */

    if (ierr == NC_NOERR) *v5 = (l5 == -1) ? -1 : (l5 + 1);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_format_ NFMPI_INQ_FORMAT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_format_ nfmpi_inq_format__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_format_ nfmpi_inq_format
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_format_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_format( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_file_format_ NFMPI_INQ_FILE_FORMAT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_file_format_ nfmpi_inq_file_format__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_file_format_ nfmpi_inq_file_format
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_file_format_ ( char *v1 FORT_MIXED_LEN(d1), int *v2 FORT_END_LEN(d1) ){
    int ierr;
    char *p1, *pt1;
    int l2;

    pt1 = v1 + d1 - 1; /* point to the end of string v1 */
    while (*pt1 == ' ' && pt1 > v1) pt1--; /* find the last non-blank */
    pt1++;
    /* it is possible character array v1 is of exact lenght d1 */
    p1 = (char *) malloc((size_t)(pt1-v1) + 1);
    memcpy(p1, v1, (size_t)(pt1-v1));
    p1[pt1-v1] = '\0';
    ierr = ncmpi_inq_file_format( p1, &l2 );
    free(p1);

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_version_ NFMPI_INQ_VERSION
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_version_ nfmpi_inq_version__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_version_ nfmpi_inq_version
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_version_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_version( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_striping_ NFMPI_INQ_STRIPING
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_striping_ nfmpi_inq_striping__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_striping_ nfmpi_inq_striping
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_striping_ ( MPI_Fint *v1, int *v2, int *v3 ){
    int ierr;
    int l2;
    int l3;
    ierr = ncmpi_inq_striping( (int)(*v1), &l2, &l3 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */

    if (ierr == NC_NOERR) *v3 = (int)l3; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_ndims_ NFMPI_INQ_NDIMS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_ndims_ nfmpi_inq_ndims__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_ndims_ nfmpi_inq_ndims
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_ndims_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_ndims( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_nvars_ NFMPI_INQ_NVARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_nvars_ nfmpi_inq_nvars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_nvars_ nfmpi_inq_nvars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_nvars_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_nvars( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_num_rec_vars_ NFMPI_INQ_NUM_REC_VARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_num_rec_vars_ nfmpi_inq_num_rec_vars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_num_rec_vars_ nfmpi_inq_num_rec_vars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_num_rec_vars_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_num_rec_vars( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_num_fix_vars_ NFMPI_INQ_NUM_FIX_VARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_num_fix_vars_ nfmpi_inq_num_fix_vars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_num_fix_vars_ nfmpi_inq_num_fix_vars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_num_fix_vars_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_num_fix_vars( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_natts_ NFMPI_INQ_NATTS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_natts_ nfmpi_inq_natts__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_natts_ nfmpi_inq_natts
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_natts_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_natts( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_unlimdim_ NFMPI_INQ_UNLIMDIM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_unlimdim_ nfmpi_inq_unlimdim__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_unlimdim_ nfmpi_inq_unlimdim
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_unlimdim_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_unlimdim( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (l2 == -1) ? -1 : (l2 + 1);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_dimid_ NFMPI_INQ_DIMID
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_dimid_ nfmpi_inq_dimid__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_dimid_ nfmpi_inq_dimid
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_dimid_ ( MPI_Fint *v1, char *v2 FORT_MIXED_LEN(d2), int *v3 FORT_END_LEN(d2) ){
    int ierr;
    char *p2, *pt2;
    int l3;

    pt2 = v2 + d2 - 1; /* point to the end of string v2 */
    while (*pt2 == ' ' && pt2 > v2) pt2--; /* find the last non-blank */
    pt2++;
    /* it is possible character array v2 is of exact lenght d2 */
    p2 = (char *) malloc((size_t)(pt2-v2) + 1);
    memcpy(p2, v2, (size_t)(pt2-v2));
    p2[pt2-v2] = '\0';
    ierr = ncmpi_inq_dimid( (int)(*v1), p2, &l3 );
    free(p2);

    if (ierr == NC_NOERR) *v3 = l3 + 1;
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_dim_ NFMPI_INQ_DIM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_dim_ nfmpi_inq_dim__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_dim_ nfmpi_inq_dim
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_dim_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Offset *v4 FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_inq_dim( (int)(*v1), (int)(*v2 - 1), v3, v4 );

    if (ierr == NC_NOERR) {
        /* fill trailing Fortran character array with blanks */
        size_t len_v3 = strlen(v3);
        memset(v3+len_v3, ' ', d3-len_v3);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_dimname_ NFMPI_INQ_DIMNAME
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_dimname_ nfmpi_inq_dimname__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_dimname_ nfmpi_inq_dimname
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_dimname_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_inq_dimname( (int)(*v1), (int)(*v2 - 1), v3 );

    if (ierr == NC_NOERR) {
        /* fill trailing Fortran character array with blanks */
        size_t len_v3 = strlen(v3);
        memset(v3+len_v3, ' ', d3-len_v3);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_dimlen_ NFMPI_INQ_DIMLEN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_dimlen_ nfmpi_inq_dimlen__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_dimlen_ nfmpi_inq_dimlen
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_dimlen_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3 ){
    int ierr;
    ierr = ncmpi_inq_dimlen( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_var_ NFMPI_INQ_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_var_ nfmpi_inq_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_var_ nfmpi_inq_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_var_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, int *v5, int *v6, int *v7 FORT_END_LEN(d3) ){
    int ierr;
    int l5;
    int *l6;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l6 = (int*) malloc((size_t)ndims * SIZEOF_INT);
    
    ierr = ncmpi_inq_var( (int)(*v1), (int)(*v2 - 1), v3, (nc_type *)(v4), &l5, l6, &l7 );

    if (ierr == NC_NOERR) {
        /* fill trailing Fortran character array with blanks */
        size_t len_v3 = strlen(v3);
        memset(v3+len_v3, ' ', d3-len_v3);
    }

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */

    if (ierr == NC_NOERR) {
        for (li=0; li<ndims; li++) /* convert C order to Fortran order */
            v6[li] = l6[ndims-1-li] + 1; /* convert 0-based int to 1-based MPI_Fint */
    }
    free(l6);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_varid_ NFMPI_INQ_VARID
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_varid_ nfmpi_inq_varid__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_varid_ nfmpi_inq_varid
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_varid_ ( MPI_Fint *v1, char *v2 FORT_MIXED_LEN(d2), int *v3 FORT_END_LEN(d2) ){
    int ierr;
    char *p2, *pt2;
    int l3;

    pt2 = v2 + d2 - 1; /* point to the end of string v2 */
    while (*pt2 == ' ' && pt2 > v2) pt2--; /* find the last non-blank */
    pt2++;
    /* it is possible character array v2 is of exact lenght d2 */
    p2 = (char *) malloc((size_t)(pt2-v2) + 1);
    memcpy(p2, v2, (size_t)(pt2-v2));
    p2[pt2-v2] = '\0';
    ierr = ncmpi_inq_varid( (int)(*v1), p2, &l3 );
    free(p2);

    if (ierr == NC_NOERR) *v3 = l3 + 1;
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_varname_ NFMPI_INQ_VARNAME
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_varname_ nfmpi_inq_varname__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_varname_ nfmpi_inq_varname
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_varname_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_inq_varname( (int)(*v1), (int)(*v2 - 1), v3 );

    if (ierr == NC_NOERR) {
        /* fill trailing Fortran character array with blanks */
        size_t len_v3 = strlen(v3);
        memset(v3+len_v3, ' ', d3-len_v3);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_vartype_ NFMPI_INQ_VARTYPE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_vartype_ nfmpi_inq_vartype__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_vartype_ nfmpi_inq_vartype
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_vartype_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3 ){
    int ierr;
    int l3;
    ierr = ncmpi_inq_vartype( (int)(*v1), (int)(*v2 - 1), &l3 );

    if (ierr == NC_NOERR) *v3 = (int)l3; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_varndims_ NFMPI_INQ_VARNDIMS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_varndims_ nfmpi_inq_varndims__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_varndims_ nfmpi_inq_varndims
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_varndims_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    int l3;
    ierr = ncmpi_inq_varndims( (int)(*v1), (int)(*v2 - 1), &l3 );

    if (ierr == NC_NOERR) *v3 = (int)l3; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_vardimid_ NFMPI_INQ_VARDIMID
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_vardimid_ nfmpi_inq_vardimid__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_vardimid_ nfmpi_inq_vardimid
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_vardimid_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    int *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (int*) malloc((size_t)ndims * SIZEOF_INT);
    
    ierr = ncmpi_inq_vardimid( (int)(*v1), (int)(*v2 - 1), l3 );

    if (ierr == NC_NOERR) {
        for (li=0; li<ndims; li++) /* convert C order to Fortran order */
            v3[li] = l3[ndims-1-li] + 1; /* convert 0-based int to 1-based MPI_Fint */
    }
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_varnatts_ NFMPI_INQ_VARNATTS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_varnatts_ nfmpi_inq_varnatts__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_varnatts_ nfmpi_inq_varnatts
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_varnatts_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    int l3;
    ierr = ncmpi_inq_varnatts( (int)(*v1), (int)(*v2 - 1), &l3 );

    if (ierr == NC_NOERR) *v3 = (int)l3; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_varoffset_ NFMPI_INQ_VAROFFSET
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_varoffset_ nfmpi_inq_varoffset__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_varoffset_ nfmpi_inq_varoffset
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_varoffset_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3 ){
    int ierr;
    ierr = ncmpi_inq_varoffset( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_put_size_ NFMPI_INQ_PUT_SIZE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_put_size_ nfmpi_inq_put_size__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_put_size_ nfmpi_inq_put_size
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_put_size_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_inq_put_size( (int)(*v1), v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_get_size_ NFMPI_INQ_GET_SIZE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_get_size_ nfmpi_inq_get_size__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_get_size_ nfmpi_inq_get_size
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_get_size_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_inq_get_size( (int)(*v1), v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_header_size_ NFMPI_INQ_HEADER_SIZE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_header_size_ nfmpi_inq_header_size__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_header_size_ nfmpi_inq_header_size
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_header_size_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_inq_header_size( (int)(*v1), v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_header_extent_ NFMPI_INQ_HEADER_EXTENT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_header_extent_ nfmpi_inq_header_extent__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_header_extent_ nfmpi_inq_header_extent
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_header_extent_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_inq_header_extent( (int)(*v1), v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_malloc_size_ NFMPI_INQ_MALLOC_SIZE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_malloc_size_ nfmpi_inq_malloc_size__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_malloc_size_ nfmpi_inq_malloc_size
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_malloc_size_ ( MPI_Offset *v1 ){
    int ierr;
    ierr = ncmpi_inq_malloc_size( v1 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_malloc_max_size_ NFMPI_INQ_MALLOC_MAX_SIZE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_malloc_max_size_ nfmpi_inq_malloc_max_size__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_malloc_max_size_ nfmpi_inq_malloc_max_size
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_malloc_max_size_ ( MPI_Offset *v1 ){
    int ierr;
    ierr = ncmpi_inq_malloc_max_size( v1 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_malloc_list_ NFMPI_INQ_MALLOC_LIST
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_malloc_list_ nfmpi_inq_malloc_list__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_malloc_list_ nfmpi_inq_malloc_list
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_malloc_list_ ( void ){
    int ierr;
    ierr = ncmpi_inq_malloc_list(  );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_files_opened_ NFMPI_INQ_FILES_OPENED
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_files_opened_ nfmpi_inq_files_opened__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_files_opened_ nfmpi_inq_files_opened
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_files_opened_ ( int *v1, int *v2 ){
    int ierr;
    int l1;
    int *l2=NULL;

    l2 = (int*) malloc((size_t)*v1 * sizeof(int));
    
    ierr = ncmpi_inq_files_opened( &l1, l2 );

    if (ierr == NC_NOERR) *v1 = (int)l1; /* cast int to MPI_Fint */

    {
        int li;
        for (li=0; li<*v1; li++)
            v2[li] = l2[li]; /* convert C int to MPI_Fint */
    }
    free(l2);
    
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_recsize_ NFMPI_INQ_RECSIZE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_recsize_ nfmpi_inq_recsize__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_recsize_ nfmpi_inq_recsize
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_recsize_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_inq_recsize( (int)(*v1), v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_var_fill_ NFMPI_INQ_VAR_FILL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_var_fill_ nfmpi_inq_var_fill__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_var_fill_ nfmpi_inq_var_fill
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_var_fill_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3, void *v4 ){
    int ierr;
    int l3;
    ierr = ncmpi_inq_var_fill( (int)(*v1), (int)(*v2 - 1), &l3, v4 );

    if (ierr == NC_NOERR) *v3 = (int)l3; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_path_ NFMPI_INQ_PATH
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_path_ nfmpi_inq_path__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_path_ nfmpi_inq_path
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_path_ ( MPI_Fint *v1, int *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_path( (int)(*v1), &l2, v3 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_att_ NFMPI_INQ_ATT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_att_ nfmpi_inq_att__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_att_ nfmpi_inq_att
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_att_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_inq_att( (int)(*v1), (int)(*v2 - 1), p3, (nc_type *)(v4), v5 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_attid_ NFMPI_INQ_ATTID
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_attid_ nfmpi_inq_attid__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_attid_ nfmpi_inq_attid
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_attid_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), int *v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;
    int l4;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_inq_attid( (int)(*v1), (int)(*v2 - 1), p3, &l4 );
    free(p3);

    if (ierr == NC_NOERR) *v4 = l4 + 1;
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_atttype_ NFMPI_INQ_ATTTYPE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_atttype_ nfmpi_inq_atttype__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_atttype_ nfmpi_inq_atttype
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_atttype_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_inq_atttype( (int)(*v1), (int)(*v2 - 1), p3, (nc_type *)(v4) );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_attlen_ NFMPI_INQ_ATTLEN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_attlen_ nfmpi_inq_attlen__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_attlen_ nfmpi_inq_attlen
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_attlen_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Offset *v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_inq_attlen( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_attname_ NFMPI_INQ_ATTNAME
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_attname_ nfmpi_inq_attname__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_attname_ nfmpi_inq_attname
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_attname_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, char *v4 FORT_MIXED_LEN(d4) FORT_END_LEN(d4) ){
    int ierr;
    ierr = ncmpi_inq_attname( (int)(*v1), (int)(*v2 - 1), (int)(*v3 - 1), v4 );

    if (ierr == NC_NOERR) {
        /* fill trailing Fortran character array with blanks */
        size_t len_v4 = strlen(v4);
        memset(v4+len_v4, ' ', d4-len_v4);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_copy_att_ NFMPI_COPY_ATT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_copy_att_ nfmpi_copy_att__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_copy_att_ nfmpi_copy_att
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_copy_att_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Fint *v5 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_copy_att( (int)(*v1), (int)(*v2 - 1), p3, (int)(*v4), (int)(*v5 - 1) );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_rename_att_ NFMPI_RENAME_ATT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_rename_att_ nfmpi_rename_att__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_rename_att_ nfmpi_rename_att
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_rename_att_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), char *v4 FORT_MIXED_LEN(d4) FORT_END_LEN(d3) FORT_END_LEN(d4) ){
    int ierr;
    char *p3, *pt3;
    char *p4, *pt4;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';

    pt4 = v4 + d4 - 1; /* point to the end of string v4 */
    while (*pt4 == ' ' && pt4 > v4) pt4--; /* find the last non-blank */
    pt4++;
    /* it is possible character array v4 is of exact lenght d4 */
    p4 = (char *) malloc((size_t)(pt4-v4) + 1);
    memcpy(p4, v4, (size_t)(pt4-v4));
    p4[pt4-v4] = '\0';
    ierr = ncmpi_rename_att( (int)(*v1), (int)(*v2 - 1), p3, p4 );
    free(p3);
    free(p4);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_del_att_ NFMPI_DEL_ATT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_del_att_ nfmpi_del_att__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_del_att_ nfmpi_del_att
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_del_att_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_del_att( (int)(*v1), (int)(*v2 - 1), p3 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_ NFMPI_PUT_ATT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_ nfmpi_put_att__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_ nfmpi_put_att
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5, void *v6 FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_put_att( (int)(*v1), (int)(*v2), v3, (nc_type)(*v4), *v5, v6 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_text_ NFMPI_PUT_ATT_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_text_ nfmpi_put_att_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_text_ nfmpi_put_att_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_text_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5) FORT_END_LEN(d3) FORT_END_LEN(d5) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_put_att_text( (int)(*v1), (int)(*v2 - 1), p3, *v4, v5 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_int1_ NFMPI_PUT_ATT_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_int1_ nfmpi_put_att_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_int1_ nfmpi_put_att_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_int1_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5, const signed char * v6 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_put_att_schar( (int)(*v1), (int)(*v2 - 1), p3, (nc_type)(*v4), *v5, v6 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_int2_ NFMPI_PUT_ATT_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_int2_ nfmpi_put_att_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_int2_ nfmpi_put_att_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_int2_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5, short *v6 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_put_att_short( (int)(*v1), (int)(*v2 - 1), p3, (nc_type)(*v4), *v5, v6 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_int_ NFMPI_PUT_ATT_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_int_ nfmpi_put_att_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_int_ nfmpi_put_att_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_int_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5, int *v6 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_put_att_int( (int)(*v1), (int)(*v2 - 1), p3, (nc_type)(*v4), *v5, v6 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_real_ NFMPI_PUT_ATT_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_real_ nfmpi_put_att_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_real_ nfmpi_put_att_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_real_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5, float *v6 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_put_att_float( (int)(*v1), (int)(*v2 - 1), p3, (nc_type)(*v4), *v5, v6 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_double_ NFMPI_PUT_ATT_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_double_ nfmpi_put_att_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_double_ nfmpi_put_att_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_double_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5, double *v6 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_put_att_double( (int)(*v1), (int)(*v2 - 1), p3, (nc_type)(*v4), *v5, v6 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_att_int8_ NFMPI_PUT_ATT_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_att_int8_ nfmpi_put_att_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_att_int8_ nfmpi_put_att_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_att_int8_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), MPI_Fint *v4, MPI_Offset *v5, const long long * v6 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_put_att_longlong( (int)(*v1), (int)(*v2 - 1), p3, (nc_type)(*v4), *v5, v6 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_ NFMPI_GET_ATT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_ nfmpi_get_att__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_ nfmpi_get_att
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), void *v4 FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_get_att( (int)(*v1), (int)(*v2), v3, v4 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_text_ NFMPI_GET_ATT_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_text_ nfmpi_get_att_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_text_ nfmpi_get_att_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_text_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), char *v4 FORT_MIXED_LEN(d4) FORT_END_LEN(d3) FORT_END_LEN(d4) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_get_att_text( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_int1_ NFMPI_GET_ATT_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_int1_ nfmpi_get_att_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_int1_ nfmpi_get_att_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_int1_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), signed char * v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_get_att_schar( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_int2_ NFMPI_GET_ATT_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_int2_ nfmpi_get_att_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_int2_ nfmpi_get_att_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_int2_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), short *v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_get_att_short( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_int_ NFMPI_GET_ATT_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_int_ nfmpi_get_att_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_int_ nfmpi_get_att_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_int_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), int *v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_get_att_int( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_real_ NFMPI_GET_ATT_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_real_ nfmpi_get_att_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_real_ nfmpi_get_att_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_real_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), float *v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_get_att_float( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_double_ NFMPI_GET_ATT_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_double_ nfmpi_get_att_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_double_ nfmpi_get_att_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_double_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), double *v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_get_att_double( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_att_int8_ NFMPI_GET_ATT_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_att_int8_ nfmpi_get_att_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_att_int8_ nfmpi_get_att_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_att_int8_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), long long * v4 FORT_END_LEN(d3) ){
    int ierr;
    char *p3, *pt3;

    pt3 = v3 + d3 - 1; /* point to the end of string v3 */
    while (*pt3 == ' ' && pt3 > v3) pt3--; /* find the last non-blank */
    pt3++;
    /* it is possible character array v3 is of exact lenght d3 */
    p3 = (char *) malloc((size_t)(pt3-v3) + 1);
    memcpy(p3, v3, (size_t)(pt3-v3));
    p3[pt3-v3] = '\0';
    ierr = ncmpi_get_att_longlong( (int)(*v1), (int)(*v2 - 1), p3, v4 );
    free(p3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_ NFMPI_PUT_VAR1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_ nfmpi_put_var1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_ nfmpi_put_var1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1( (int)(*v1), (int)(*v2 - 1), l3, v4, *v5, MPI_Type_f2c(*v6) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_all_ NFMPI_PUT_VAR1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_all_ nfmpi_put_var1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_all_ nfmpi_put_var1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_all( (int)(*v1), (int)(*v2 - 1), l3, v4, *v5, MPI_Type_f2c(*v6) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_text_ NFMPI_PUT_VAR1_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_text_ nfmpi_put_var1_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_text_ nfmpi_put_var1_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, char *v4 FORT_MIXED_LEN(d4) FORT_END_LEN(d4) ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_text( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_text_all_ NFMPI_PUT_VAR1_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_text_all_ nfmpi_put_var1_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_text_all_ nfmpi_put_var1_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, char *v4 FORT_MIXED_LEN(d4) FORT_END_LEN(d4) ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_text_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int1_ NFMPI_PUT_VAR1_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int1_ nfmpi_put_var1_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int1_ nfmpi_put_var1_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const signed char * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_schar( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int1_all_ NFMPI_PUT_VAR1_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int1_all_ nfmpi_put_var1_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int1_all_ nfmpi_put_var1_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const signed char * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_schar_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int2_ NFMPI_PUT_VAR1_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int2_ nfmpi_put_var1_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int2_ nfmpi_put_var1_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, short *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_short( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int2_all_ NFMPI_PUT_VAR1_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int2_all_ nfmpi_put_var1_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int2_all_ nfmpi_put_var1_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, short *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_short_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int_ NFMPI_PUT_VAR1_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int_ nfmpi_put_var1_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int_ nfmpi_put_var1_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, int *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_int( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int_all_ NFMPI_PUT_VAR1_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int_all_ nfmpi_put_var1_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int_all_ nfmpi_put_var1_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, int *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_int_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_real_ NFMPI_PUT_VAR1_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_real_ nfmpi_put_var1_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_real_ nfmpi_put_var1_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, float *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_float( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_real_all_ NFMPI_PUT_VAR1_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_real_all_ nfmpi_put_var1_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_real_all_ nfmpi_put_var1_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, float *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_float_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_double_ NFMPI_PUT_VAR1_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_double_ nfmpi_put_var1_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_double_ nfmpi_put_var1_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, double *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_double( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_double_all_ NFMPI_PUT_VAR1_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_double_all_ nfmpi_put_var1_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_double_all_ nfmpi_put_var1_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, double *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_double_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int8_ NFMPI_PUT_VAR1_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int8_ nfmpi_put_var1_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int8_ nfmpi_put_var1_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const long long * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_longlong( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var1_int8_all_ NFMPI_PUT_VAR1_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var1_int8_all_ nfmpi_put_var1_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var1_int8_all_ nfmpi_put_var1_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var1_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const long long * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_put_var1_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_ NFMPI_GET_VAR1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_ nfmpi_get_var1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_ nfmpi_get_var1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1( (int)(*v1), (int)(*v2 - 1), l3, v4, *v5, MPI_Type_f2c(*v6) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_all_ NFMPI_GET_VAR1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_all_ nfmpi_get_var1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_all_ nfmpi_get_var1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_all( (int)(*v1), (int)(*v2 - 1), l3, v4, *v5, MPI_Type_f2c(*v6) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_text_ NFMPI_GET_VAR1_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_text_ nfmpi_get_var1_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_text_ nfmpi_get_var1_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, char *v4 FORT_MIXED_LEN(d4) FORT_END_LEN(d4) ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_text( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_text_all_ NFMPI_GET_VAR1_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_text_all_ nfmpi_get_var1_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_text_all_ nfmpi_get_var1_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, char *v4 FORT_MIXED_LEN(d4) FORT_END_LEN(d4) ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_text_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int1_ NFMPI_GET_VAR1_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int1_ nfmpi_get_var1_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int1_ nfmpi_get_var1_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, signed char * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_schar( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int1_all_ NFMPI_GET_VAR1_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int1_all_ nfmpi_get_var1_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int1_all_ nfmpi_get_var1_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, signed char * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_schar_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int2_ NFMPI_GET_VAR1_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int2_ nfmpi_get_var1_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int2_ nfmpi_get_var1_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, short *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_short( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int2_all_ NFMPI_GET_VAR1_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int2_all_ nfmpi_get_var1_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int2_all_ nfmpi_get_var1_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, short *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_short_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int_ NFMPI_GET_VAR1_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int_ nfmpi_get_var1_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int_ nfmpi_get_var1_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, int *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_int( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int_all_ NFMPI_GET_VAR1_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int_all_ nfmpi_get_var1_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int_all_ nfmpi_get_var1_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, int *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_int_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_real_ NFMPI_GET_VAR1_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_real_ nfmpi_get_var1_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_real_ nfmpi_get_var1_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, float *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_float( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_real_all_ NFMPI_GET_VAR1_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_real_all_ nfmpi_get_var1_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_real_all_ nfmpi_get_var1_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, float *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_float_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_double_ NFMPI_GET_VAR1_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_double_ nfmpi_get_var1_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_double_ nfmpi_get_var1_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, double *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_double( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_double_all_ NFMPI_GET_VAR1_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_double_all_ nfmpi_get_var1_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_double_all_ nfmpi_get_var1_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, double *v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_double_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int8_ NFMPI_GET_VAR1_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int8_ nfmpi_get_var1_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int8_ nfmpi_get_var1_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, long long * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_longlong( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var1_int8_all_ NFMPI_GET_VAR1_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var1_int8_all_ nfmpi_get_var1_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var1_int8_all_ nfmpi_get_var1_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var1_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, long long * v4 ){
    int ierr;
    MPI_Offset *l3;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_get_var1_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, v4 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_ NFMPI_PUT_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_ nfmpi_put_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_ nfmpi_put_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_ ( MPI_Fint *v1, MPI_Fint *v2, void *v3, MPI_Offset *v4, MPI_Fint *v5 ){
    int ierr;
    ierr = ncmpi_put_var( (int)(*v1), (int)(*v2 - 1), v3, *v4, MPI_Type_f2c(*v5) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_all_ NFMPI_PUT_VAR_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_all_ nfmpi_put_var_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_all_ nfmpi_put_var_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_all_ ( MPI_Fint *v1, MPI_Fint *v2, void *v3, MPI_Offset *v4, MPI_Fint *v5 ){
    int ierr;
    ierr = ncmpi_put_var_all( (int)(*v1), (int)(*v2), v3, *v4, MPI_Type_f2c(*v5) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_text_ NFMPI_PUT_VAR_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_text_ nfmpi_put_var_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_text_ nfmpi_put_var_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_text_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_put_var_text( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_text_all_ NFMPI_PUT_VAR_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_text_all_ nfmpi_put_var_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_text_all_ nfmpi_put_var_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_put_var_text_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int1_ NFMPI_PUT_VAR_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int1_ nfmpi_put_var_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int1_ nfmpi_put_var_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int1_ ( MPI_Fint *v1, MPI_Fint *v2, const signed char * v3 ){
    int ierr;
    ierr = ncmpi_put_var_schar( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int1_all_ NFMPI_PUT_VAR_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int1_all_ nfmpi_put_var_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int1_all_ nfmpi_put_var_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, const signed char * v3 ){
    int ierr;
    ierr = ncmpi_put_var_schar_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int2_ NFMPI_PUT_VAR_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int2_ nfmpi_put_var_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int2_ nfmpi_put_var_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int2_ ( MPI_Fint *v1, MPI_Fint *v2, short *v3 ){
    int ierr;
    ierr = ncmpi_put_var_short( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int2_all_ NFMPI_PUT_VAR_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int2_all_ nfmpi_put_var_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int2_all_ nfmpi_put_var_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, short *v3 ){
    int ierr;
    ierr = ncmpi_put_var_short_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int_ NFMPI_PUT_VAR_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int_ nfmpi_put_var_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int_ nfmpi_put_var_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    ierr = ncmpi_put_var_int( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int_all_ NFMPI_PUT_VAR_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int_all_ nfmpi_put_var_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int_all_ nfmpi_put_var_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    ierr = ncmpi_put_var_int_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_real_ NFMPI_PUT_VAR_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_real_ nfmpi_put_var_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_real_ nfmpi_put_var_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_real_ ( MPI_Fint *v1, MPI_Fint *v2, float *v3 ){
    int ierr;
    ierr = ncmpi_put_var_float( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_real_all_ NFMPI_PUT_VAR_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_real_all_ nfmpi_put_var_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_real_all_ nfmpi_put_var_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, float *v3 ){
    int ierr;
    ierr = ncmpi_put_var_float_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_double_ NFMPI_PUT_VAR_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_double_ nfmpi_put_var_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_double_ nfmpi_put_var_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_double_ ( MPI_Fint *v1, MPI_Fint *v2, double *v3 ){
    int ierr;
    ierr = ncmpi_put_var_double( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_double_all_ NFMPI_PUT_VAR_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_double_all_ nfmpi_put_var_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_double_all_ nfmpi_put_var_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, double *v3 ){
    int ierr;
    ierr = ncmpi_put_var_double_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int8_ NFMPI_PUT_VAR_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int8_ nfmpi_put_var_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int8_ nfmpi_put_var_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int8_ ( MPI_Fint *v1, MPI_Fint *v2, const long long * v3 ){
    int ierr;
    ierr = ncmpi_put_var_longlong( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_var_int8_all_ NFMPI_PUT_VAR_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_var_int8_all_ nfmpi_put_var_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_var_int8_all_ nfmpi_put_var_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_var_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, const long long * v3 ){
    int ierr;
    ierr = ncmpi_put_var_longlong_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_ NFMPI_GET_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_ nfmpi_get_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_ nfmpi_get_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_ ( MPI_Fint *v1, MPI_Fint *v2, void *v3, MPI_Offset *v4, MPI_Fint *v5 ){
    int ierr;
    ierr = ncmpi_get_var( (int)(*v1), (int)(*v2 - 1), v3, *v4, MPI_Type_f2c(*v5) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_all_ NFMPI_GET_VAR_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_all_ nfmpi_get_var_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_all_ nfmpi_get_var_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_all_ ( MPI_Fint *v1, MPI_Fint *v2, void *v3, MPI_Offset *v4, MPI_Fint *v5 ){
    int ierr;
    ierr = ncmpi_get_var_all( (int)(*v1), (int)(*v2 - 1), v3, *v4, MPI_Type_f2c(*v5) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_text_ NFMPI_GET_VAR_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_text_ nfmpi_get_var_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_text_ nfmpi_get_var_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_text_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_get_var_text( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_text_all_ NFMPI_GET_VAR_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_text_all_ nfmpi_get_var_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_text_all_ nfmpi_get_var_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3) FORT_END_LEN(d3) ){
    int ierr;
    ierr = ncmpi_get_var_text_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int1_ NFMPI_GET_VAR_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int1_ nfmpi_get_var_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int1_ nfmpi_get_var_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int1_ ( MPI_Fint *v1, MPI_Fint *v2, signed char * v3 ){
    int ierr;
    ierr = ncmpi_get_var_schar( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int1_all_ NFMPI_GET_VAR_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int1_all_ nfmpi_get_var_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int1_all_ nfmpi_get_var_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, signed char * v3 ){
    int ierr;
    ierr = ncmpi_get_var_schar_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int2_ NFMPI_GET_VAR_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int2_ nfmpi_get_var_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int2_ nfmpi_get_var_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int2_ ( MPI_Fint *v1, MPI_Fint *v2, short *v3 ){
    int ierr;
    ierr = ncmpi_get_var_short( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int2_all_ NFMPI_GET_VAR_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int2_all_ nfmpi_get_var_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int2_all_ nfmpi_get_var_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, short *v3 ){
    int ierr;
    ierr = ncmpi_get_var_short_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int_ NFMPI_GET_VAR_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int_ nfmpi_get_var_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int_ nfmpi_get_var_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    ierr = ncmpi_get_var_int( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int_all_ NFMPI_GET_VAR_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int_all_ nfmpi_get_var_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int_all_ nfmpi_get_var_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3 ){
    int ierr;
    ierr = ncmpi_get_var_int_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_real_ NFMPI_GET_VAR_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_real_ nfmpi_get_var_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_real_ nfmpi_get_var_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_real_ ( MPI_Fint *v1, MPI_Fint *v2, float *v3 ){
    int ierr;
    ierr = ncmpi_get_var_float( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_real_all_ NFMPI_GET_VAR_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_real_all_ nfmpi_get_var_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_real_all_ nfmpi_get_var_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, float *v3 ){
    int ierr;
    ierr = ncmpi_get_var_float_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_double_ NFMPI_GET_VAR_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_double_ nfmpi_get_var_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_double_ nfmpi_get_var_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_double_ ( MPI_Fint *v1, MPI_Fint *v2, double *v3 ){
    int ierr;
    ierr = ncmpi_get_var_double( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_double_all_ NFMPI_GET_VAR_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_double_all_ nfmpi_get_var_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_double_all_ nfmpi_get_var_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, double *v3 ){
    int ierr;
    ierr = ncmpi_get_var_double_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int8_ NFMPI_GET_VAR_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int8_ nfmpi_get_var_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int8_ nfmpi_get_var_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int8_ ( MPI_Fint *v1, MPI_Fint *v2, long long * v3 ){
    int ierr;
    ierr = ncmpi_get_var_longlong( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_var_int8_all_ NFMPI_GET_VAR_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_var_int8_all_ nfmpi_get_var_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_var_int8_all_ nfmpi_get_var_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_var_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, long long * v3 ){
    int ierr;
    ierr = ncmpi_get_var_longlong_all( (int)(*v1), (int)(*v2 - 1), v3 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_ NFMPI_PUT_VARA
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_ nfmpi_put_vara__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_ nfmpi_put_vara
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, void *v5, MPI_Offset *v6, MPI_Fint *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, *v6, MPI_Type_f2c(*v7) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_all_ NFMPI_PUT_VARA_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_all_ nfmpi_put_vara_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_all_ nfmpi_put_vara_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, void *v5, MPI_Offset *v6, MPI_Fint *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, *v6, MPI_Type_f2c(*v7) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_text_ NFMPI_PUT_VARA_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_text_ nfmpi_put_vara_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_text_ nfmpi_put_vara_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5) FORT_END_LEN(d5) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_text( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_text_all_ NFMPI_PUT_VARA_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_text_all_ nfmpi_put_vara_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_text_all_ nfmpi_put_vara_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5) FORT_END_LEN(d5) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_text_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int1_ NFMPI_PUT_VARA_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int1_ nfmpi_put_vara_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int1_ nfmpi_put_vara_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const signed char * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int1_all_ NFMPI_PUT_VARA_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int1_all_ nfmpi_put_vara_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int1_all_ nfmpi_put_vara_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const signed char * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_schar_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int2_ NFMPI_PUT_VARA_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int2_ nfmpi_put_vara_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int2_ nfmpi_put_vara_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, short *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_short( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int2_all_ NFMPI_PUT_VARA_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int2_all_ nfmpi_put_vara_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int2_all_ nfmpi_put_vara_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, short *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_short_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int_ NFMPI_PUT_VARA_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int_ nfmpi_put_vara_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int_ nfmpi_put_vara_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_int( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int_all_ NFMPI_PUT_VARA_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int_all_ nfmpi_put_vara_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int_all_ nfmpi_put_vara_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_int_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_real_ NFMPI_PUT_VARA_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_real_ nfmpi_put_vara_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_real_ nfmpi_put_vara_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, float *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_float( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_real_all_ NFMPI_PUT_VARA_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_real_all_ nfmpi_put_vara_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_real_all_ nfmpi_put_vara_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, float *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_float_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_double_ NFMPI_PUT_VARA_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_double_ nfmpi_put_vara_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_double_ nfmpi_put_vara_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, double *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_double( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_double_all_ NFMPI_PUT_VARA_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_double_all_ nfmpi_put_vara_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_double_all_ nfmpi_put_vara_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, double *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_double_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int8_ NFMPI_PUT_VARA_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int8_ nfmpi_put_vara_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int8_ nfmpi_put_vara_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const long long * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vara_int8_all_ NFMPI_PUT_VARA_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vara_int8_all_ nfmpi_put_vara_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vara_int8_all_ nfmpi_put_vara_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vara_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const long long * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_put_vara_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_ NFMPI_GET_VARA
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_ nfmpi_get_vara__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_ nfmpi_get_vara
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, void *v5, MPI_Offset *v6, MPI_Fint *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, *v6, MPI_Type_f2c(*v7) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_all_ NFMPI_GET_VARA_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_all_ nfmpi_get_vara_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_all_ nfmpi_get_vara_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, void *v5, MPI_Offset *v6, MPI_Fint *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, *v6, MPI_Type_f2c(*v7) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_text_ NFMPI_GET_VARA_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_text_ nfmpi_get_vara_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_text_ nfmpi_get_vara_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5) FORT_END_LEN(d5) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_text( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_text_all_ NFMPI_GET_VARA_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_text_all_ nfmpi_get_vara_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_text_all_ nfmpi_get_vara_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5) FORT_END_LEN(d5) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_text_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int1_ NFMPI_GET_VARA_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int1_ nfmpi_get_vara_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int1_ nfmpi_get_vara_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, signed char * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int1_all_ NFMPI_GET_VARA_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int1_all_ nfmpi_get_vara_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int1_all_ nfmpi_get_vara_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, signed char * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_schar_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int2_ NFMPI_GET_VARA_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int2_ nfmpi_get_vara_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int2_ nfmpi_get_vara_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, short *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_short( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int2_all_ NFMPI_GET_VARA_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int2_all_ nfmpi_get_vara_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int2_all_ nfmpi_get_vara_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, short *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_short_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int_ NFMPI_GET_VARA_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int_ nfmpi_get_vara_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int_ nfmpi_get_vara_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_int( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int_all_ NFMPI_GET_VARA_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int_all_ nfmpi_get_vara_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int_all_ nfmpi_get_vara_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_int_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_real_ NFMPI_GET_VARA_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_real_ nfmpi_get_vara_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_real_ nfmpi_get_vara_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, float *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_float( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_real_all_ NFMPI_GET_VARA_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_real_all_ nfmpi_get_vara_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_real_all_ nfmpi_get_vara_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, float *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_float_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_double_ NFMPI_GET_VARA_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_double_ nfmpi_get_vara_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_double_ nfmpi_get_vara_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, double *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_double( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_double_all_ NFMPI_GET_VARA_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_double_all_ nfmpi_get_vara_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_double_all_ nfmpi_get_vara_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, double *v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_double_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int8_ NFMPI_GET_VARA_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int8_ nfmpi_get_vara_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int8_ nfmpi_get_vara_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, long long * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vara_int8_all_ NFMPI_GET_VARA_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vara_int8_all_ nfmpi_get_vara_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vara_int8_all_ nfmpi_get_vara_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vara_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, long long * v5 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_get_vara_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, l4, v5 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_ NFMPI_PUT_VARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_ nfmpi_put_vars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_ nfmpi_put_vars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, *v7, MPI_Type_f2c(*v8) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_all_ NFMPI_PUT_VARS_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_all_ nfmpi_put_vars_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_all_ nfmpi_put_vars_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, *v7, MPI_Type_f2c(*v8) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_text_ NFMPI_PUT_VARS_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_text_ nfmpi_put_vars_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_text_ nfmpi_put_vars_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_text_all_ NFMPI_PUT_VARS_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_text_all_ nfmpi_put_vars_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_text_all_ nfmpi_put_vars_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_text_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int1_ NFMPI_PUT_VARS_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int1_ nfmpi_put_vars_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int1_ nfmpi_put_vars_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int1_all_ NFMPI_PUT_VARS_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int1_all_ nfmpi_put_vars_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int1_all_ nfmpi_put_vars_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_schar_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int2_ NFMPI_PUT_VARS_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int2_ nfmpi_put_vars_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int2_ nfmpi_put_vars_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int2_all_ NFMPI_PUT_VARS_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int2_all_ nfmpi_put_vars_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int2_all_ nfmpi_put_vars_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_short_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int_ NFMPI_PUT_VARS_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int_ nfmpi_put_vars_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int_ nfmpi_put_vars_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int_all_ NFMPI_PUT_VARS_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int_all_ nfmpi_put_vars_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int_all_ nfmpi_put_vars_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_int_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_real_ NFMPI_PUT_VARS_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_real_ nfmpi_put_vars_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_real_ nfmpi_put_vars_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_real_all_ NFMPI_PUT_VARS_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_real_all_ nfmpi_put_vars_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_real_all_ nfmpi_put_vars_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_float_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_double_ NFMPI_PUT_VARS_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_double_ nfmpi_put_vars_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_double_ nfmpi_put_vars_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_double_all_ NFMPI_PUT_VARS_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_double_all_ nfmpi_put_vars_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_double_all_ nfmpi_put_vars_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_double_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int8_ NFMPI_PUT_VARS_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int8_ nfmpi_put_vars_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int8_ nfmpi_put_vars_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vars_int8_all_ NFMPI_PUT_VARS_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vars_int8_all_ nfmpi_put_vars_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vars_int8_all_ nfmpi_put_vars_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vars_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_put_vars_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_ NFMPI_GET_VARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_ nfmpi_get_vars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_ nfmpi_get_vars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, *v7, MPI_Type_f2c(*v8) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_all_ NFMPI_GET_VARS_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_all_ nfmpi_get_vars_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_all_ nfmpi_get_vars_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, *v7, MPI_Type_f2c(*v8) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int1_ NFMPI_GET_VARS_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int1_ nfmpi_get_vars_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int1_ nfmpi_get_vars_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, signed char * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int1_all_ NFMPI_GET_VARS_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int1_all_ nfmpi_get_vars_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int1_all_ nfmpi_get_vars_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, signed char * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_schar_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_text_ NFMPI_GET_VARS_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_text_ nfmpi_get_vars_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_text_ nfmpi_get_vars_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_text_all_ NFMPI_GET_VARS_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_text_all_ nfmpi_get_vars_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_text_all_ nfmpi_get_vars_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_text_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int2_ NFMPI_GET_VARS_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int2_ nfmpi_get_vars_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int2_ nfmpi_get_vars_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int2_all_ NFMPI_GET_VARS_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int2_all_ nfmpi_get_vars_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int2_all_ nfmpi_get_vars_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_short_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int_ NFMPI_GET_VARS_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int_ nfmpi_get_vars_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int_ nfmpi_get_vars_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int_all_ NFMPI_GET_VARS_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int_all_ nfmpi_get_vars_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int_all_ nfmpi_get_vars_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_int_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_real_ NFMPI_GET_VARS_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_real_ nfmpi_get_vars_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_real_ nfmpi_get_vars_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_real_all_ NFMPI_GET_VARS_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_real_all_ nfmpi_get_vars_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_real_all_ nfmpi_get_vars_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_float_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_double_ NFMPI_GET_VARS_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_double_ nfmpi_get_vars_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_double_ nfmpi_get_vars_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_double_all_ NFMPI_GET_VARS_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_double_all_ nfmpi_get_vars_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_double_all_ nfmpi_get_vars_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_double_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int8_ NFMPI_GET_VARS_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int8_ nfmpi_get_vars_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int8_ nfmpi_get_vars_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, long long * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vars_int8_all_ NFMPI_GET_VARS_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vars_int8_all_ nfmpi_get_vars_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vars_int8_all_ nfmpi_get_vars_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vars_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, long long * v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_get_vars_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_ NFMPI_PUT_VARM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_ nfmpi_put_varm__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_ nfmpi_put_varm
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, void *v7, MPI_Offset *v8, MPI_Fint *v9 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, *v8, MPI_Type_f2c(*v9) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_all_ NFMPI_PUT_VARM_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_all_ nfmpi_put_varm_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_all_ nfmpi_put_varm_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, void *v7, MPI_Offset *v8, MPI_Fint *v9 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, *v8, MPI_Type_f2c(*v9) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_text_ NFMPI_PUT_VARM_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_text_ nfmpi_put_varm_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_text_ nfmpi_put_varm_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, char *v7 FORT_MIXED_LEN(d7) FORT_END_LEN(d7) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_text_all_ NFMPI_PUT_VARM_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_text_all_ nfmpi_put_varm_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_text_all_ nfmpi_put_varm_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, char *v7 FORT_MIXED_LEN(d7) FORT_END_LEN(d7) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_text_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int1_ NFMPI_PUT_VARM_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int1_ nfmpi_put_varm_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int1_ nfmpi_put_varm_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const signed char * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int1_all_ NFMPI_PUT_VARM_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int1_all_ nfmpi_put_varm_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int1_all_ nfmpi_put_varm_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const signed char * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_schar_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int2_ NFMPI_PUT_VARM_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int2_ nfmpi_put_varm_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int2_ nfmpi_put_varm_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, short *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int2_all_ NFMPI_PUT_VARM_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int2_all_ nfmpi_put_varm_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int2_all_ nfmpi_put_varm_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, short *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_short_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int_ NFMPI_PUT_VARM_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int_ nfmpi_put_varm_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int_ nfmpi_put_varm_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int_all_ NFMPI_PUT_VARM_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int_all_ nfmpi_put_varm_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int_all_ nfmpi_put_varm_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_int_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_real_ NFMPI_PUT_VARM_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_real_ nfmpi_put_varm_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_real_ nfmpi_put_varm_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, float *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_real_all_ NFMPI_PUT_VARM_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_real_all_ nfmpi_put_varm_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_real_all_ nfmpi_put_varm_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, float *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_float_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_double_ NFMPI_PUT_VARM_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_double_ nfmpi_put_varm_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_double_ nfmpi_put_varm_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, double *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_double_all_ NFMPI_PUT_VARM_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_double_all_ nfmpi_put_varm_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_double_all_ nfmpi_put_varm_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, double *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_double_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int8_ NFMPI_PUT_VARM_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int8_ nfmpi_put_varm_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int8_ nfmpi_put_varm_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const long long * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varm_int8_all_ NFMPI_PUT_VARM_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varm_int8_all_ nfmpi_put_varm_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varm_int8_all_ nfmpi_put_varm_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varm_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const long long * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_put_varm_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_ NFMPI_GET_VARM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_ nfmpi_get_varm__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_ nfmpi_get_varm
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, void *v7, MPI_Offset *v8, MPI_Fint *v9 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, *v8, MPI_Type_f2c(*v9) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_all_ NFMPI_GET_VARM_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_all_ nfmpi_get_varm_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_all_ nfmpi_get_varm_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, void *v7, MPI_Offset *v8, MPI_Fint *v9 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, *v8, MPI_Type_f2c(*v9) );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int1_ NFMPI_GET_VARM_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int1_ nfmpi_get_varm_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int1_ nfmpi_get_varm_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, signed char * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int1_all_ NFMPI_GET_VARM_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int1_all_ nfmpi_get_varm_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int1_all_ nfmpi_get_varm_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, signed char * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_schar_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_text_ NFMPI_GET_VARM_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_text_ nfmpi_get_varm_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_text_ nfmpi_get_varm_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, char *v7 FORT_MIXED_LEN(d7) FORT_END_LEN(d7) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_text_all_ NFMPI_GET_VARM_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_text_all_ nfmpi_get_varm_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_text_all_ nfmpi_get_varm_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, char *v7 FORT_MIXED_LEN(d7) FORT_END_LEN(d7) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_text_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int2_ NFMPI_GET_VARM_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int2_ nfmpi_get_varm_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int2_ nfmpi_get_varm_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, short *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int2_all_ NFMPI_GET_VARM_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int2_all_ nfmpi_get_varm_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int2_all_ nfmpi_get_varm_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, short *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_short_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int_ NFMPI_GET_VARM_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int_ nfmpi_get_varm_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int_ nfmpi_get_varm_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int_all_ NFMPI_GET_VARM_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int_all_ nfmpi_get_varm_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int_all_ nfmpi_get_varm_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_int_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_real_ NFMPI_GET_VARM_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_real_ nfmpi_get_varm_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_real_ nfmpi_get_varm_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, float *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_real_all_ NFMPI_GET_VARM_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_real_all_ nfmpi_get_varm_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_real_all_ nfmpi_get_varm_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, float *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_float_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_double_ NFMPI_GET_VARM_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_double_ nfmpi_get_varm_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_double_ nfmpi_get_varm_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, double *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_double_all_ NFMPI_GET_VARM_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_double_all_ nfmpi_get_varm_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_double_all_ nfmpi_get_varm_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, double *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_double_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int8_ NFMPI_GET_VARM_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int8_ nfmpi_get_varm_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int8_ nfmpi_get_varm_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, long long * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varm_int8_all_ NFMPI_GET_VARM_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varm_int8_all_ nfmpi_get_varm_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varm_int8_all_ nfmpi_get_varm_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varm_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, long long * v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_get_varm_longlong_all( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7 );
    free(l3);
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_ NFMPI_PUT_VARN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_ nfmpi_put_varn__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_ nfmpi_put_varn
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, *v7, MPI_Type_f2c(*v8) );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_all_ NFMPI_PUT_VARN_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_all_ nfmpi_put_varn_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_all_ nfmpi_put_varn_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, *v7, MPI_Type_f2c(*v8) );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_ NFMPI_GET_VARN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_ nfmpi_get_varn__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_ nfmpi_get_varn
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, *v7, MPI_Type_f2c(*v8) );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_all_ NFMPI_GET_VARN_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_all_ nfmpi_get_varn_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_all_ nfmpi_get_varn_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, *v7, MPI_Type_f2c(*v8) );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_text_ NFMPI_PUT_VARN_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_text_ nfmpi_put_varn_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_text_ nfmpi_put_varn_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_text( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_text_all_ NFMPI_PUT_VARN_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_text_all_ nfmpi_put_varn_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_text_all_ nfmpi_put_varn_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_text_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int1_ NFMPI_PUT_VARN_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int1_ nfmpi_put_varn_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int1_ nfmpi_put_varn_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_schar( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int1_all_ NFMPI_PUT_VARN_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int1_all_ nfmpi_put_varn_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int1_all_ nfmpi_put_varn_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_schar_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int2_ NFMPI_PUT_VARN_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int2_ nfmpi_put_varn_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int2_ nfmpi_put_varn_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_short( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int2_all_ NFMPI_PUT_VARN_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int2_all_ nfmpi_put_varn_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int2_all_ nfmpi_put_varn_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_short_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int_ NFMPI_PUT_VARN_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int_ nfmpi_put_varn_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int_ nfmpi_put_varn_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_int( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int_all_ NFMPI_PUT_VARN_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int_all_ nfmpi_put_varn_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int_all_ nfmpi_put_varn_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_int_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_real_ NFMPI_PUT_VARN_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_real_ nfmpi_put_varn_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_real_ nfmpi_put_varn_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_float( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_real_all_ NFMPI_PUT_VARN_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_real_all_ nfmpi_put_varn_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_real_all_ nfmpi_put_varn_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_float_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_double_ NFMPI_PUT_VARN_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_double_ nfmpi_put_varn_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_double_ nfmpi_put_varn_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_double( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_double_all_ NFMPI_PUT_VARN_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_double_all_ nfmpi_put_varn_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_double_all_ nfmpi_put_varn_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_double_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int8_ NFMPI_PUT_VARN_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int8_ nfmpi_put_varn_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int8_ nfmpi_put_varn_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_longlong( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_varn_int8_all_ NFMPI_PUT_VARN_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_varn_int8_all_ nfmpi_put_varn_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_varn_int8_all_ nfmpi_put_varn_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_varn_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_put_varn_longlong_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_text_ NFMPI_GET_VARN_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_text_ nfmpi_get_varn_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_text_ nfmpi_get_varn_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_text( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_text_all_ NFMPI_GET_VARN_TEXT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_text_all_ nfmpi_get_varn_text_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_text_all_ nfmpi_get_varn_text_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_text_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6) FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_text_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int1_ NFMPI_GET_VARN_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int1_ nfmpi_get_varn_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int1_ nfmpi_get_varn_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, signed char * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_schar( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int1_all_ NFMPI_GET_VARN_INT1_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int1_all_ nfmpi_get_varn_int1_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int1_all_ nfmpi_get_varn_int1_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int1_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, signed char * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_schar_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int2_ NFMPI_GET_VARN_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int2_ nfmpi_get_varn_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int2_ nfmpi_get_varn_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_short( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int2_all_ NFMPI_GET_VARN_INT2_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int2_all_ nfmpi_get_varn_int2_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int2_all_ nfmpi_get_varn_int2_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int2_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_short_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int_ NFMPI_GET_VARN_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int_ nfmpi_get_varn_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int_ nfmpi_get_varn_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_int( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int_all_ NFMPI_GET_VARN_INT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int_all_ nfmpi_get_varn_int_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int_all_ nfmpi_get_varn_int_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_int_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_real_ NFMPI_GET_VARN_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_real_ nfmpi_get_varn_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_real_ nfmpi_get_varn_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_float( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_real_all_ NFMPI_GET_VARN_REAL_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_real_all_ nfmpi_get_varn_real_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_real_all_ nfmpi_get_varn_real_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_real_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_float_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_double_ NFMPI_GET_VARN_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_double_ nfmpi_get_varn_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_double_ nfmpi_get_varn_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_double( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_double_all_ NFMPI_GET_VARN_DOUBLE_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_double_all_ nfmpi_get_varn_double_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_double_all_ nfmpi_get_varn_double_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_double_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_double_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int8_ NFMPI_GET_VARN_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int8_ nfmpi_get_varn_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int8_ nfmpi_get_varn_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, long long * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_longlong( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_varn_int8_all_ NFMPI_GET_VARN_INT8_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_varn_int8_all_ nfmpi_get_varn_int8_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_varn_int8_all_ nfmpi_get_varn_int8_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_varn_int8_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, long long * v6 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_get_varn_longlong_all( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vard_ NFMPI_GET_VARD
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vard_ nfmpi_get_vard__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vard_ nfmpi_get_vard
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vard_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    ierr = ncmpi_get_vard( (int)(*v1), (int)(*v2 - 1), MPI_Type_f2c(*v3), v4, *v5, MPI_Type_f2c(*v6) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_get_vard_all_ NFMPI_GET_VARD_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_get_vard_all_ nfmpi_get_vard_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_get_vard_all_ nfmpi_get_vard_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_get_vard_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    ierr = ncmpi_get_vard_all( (int)(*v1), (int)(*v2 - 1), MPI_Type_f2c(*v3), v4, *v5, MPI_Type_f2c(*v6) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vard_ NFMPI_PUT_VARD
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vard_ nfmpi_put_vard__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vard_ nfmpi_put_vard
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vard_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    ierr = ncmpi_put_vard( (int)(*v1), (int)(*v2 - 1), MPI_Type_f2c(*v3), v4, *v5, MPI_Type_f2c(*v6) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_put_vard_all_ NFMPI_PUT_VARD_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_put_vard_all_ nfmpi_put_vard_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_put_vard_all_ nfmpi_put_vard_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_put_vard_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6 ){
    int ierr;
    ierr = ncmpi_put_vard_all( (int)(*v1), (int)(*v2 - 1), MPI_Type_f2c(*v3), v4, *v5, MPI_Type_f2c(*v6) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_wait_ NFMPI_WAIT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_wait_ nfmpi_wait__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_wait_ nfmpi_wait
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_wait_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint v3[], MPI_Fint v4[] ){
    int ierr;
    int *l3=NULL;
    int *l4=NULL;

    {
        int li;
        l3 = (int*) malloc((size_t)*v2 * sizeof(int));
        for (li=0; li<*v2; li++)
            l3[li] = v3[li]; /* convert MPI_Fint to C int */
    }

    l4 = (int*) malloc((size_t)*v2 * sizeof(int));
    
    ierr = ncmpi_wait( (int)(*v1), (int)(*v2), l3, l4 );
    free(l3);

    {
        int li;
        for (li=0; li<*v2; li++)
            v4[li] = l4[li]; /* convert C int to MPI_Fint */
    }
    free(l4);
    
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_wait_all_ NFMPI_WAIT_ALL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_wait_all_ nfmpi_wait_all__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_wait_all_ nfmpi_wait_all
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_wait_all_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint v3[], MPI_Fint v4[] ){
    int ierr;
    int *l3=NULL;
    int *l4=NULL;

    {
        int li;
        l3 = (int*) malloc((size_t)*v2 * sizeof(int));
        for (li=0; li<*v2; li++)
            l3[li] = v3[li]; /* convert MPI_Fint to C int */
    }

    l4 = (int*) malloc((size_t)*v2 * sizeof(int));
    
    ierr = ncmpi_wait_all( (int)(*v1), (int)(*v2), l3, l4 );
    free(l3);

    {
        int li;
        for (li=0; li<*v2; li++)
            v4[li] = l4[li]; /* convert C int to MPI_Fint */
    }
    free(l4);
    
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_cancel_ NFMPI_CANCEL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_cancel_ nfmpi_cancel__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_cancel_ nfmpi_cancel
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_cancel_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3, int *v4 ){
    int ierr;
    int *l3=NULL;
    int *l4=NULL;

    {
        int li;
        l3 = (int*) malloc((size_t)*v2 * sizeof(int));
        for (li=0; li<*v2; li++)
            l3[li] = v3[li]; /* convert MPI_Fint to C int */
    }

    l4 = (int*) malloc((size_t)*v2 * sizeof(int));
    
    ierr = ncmpi_cancel( (int)(*v1), (int)(*v2), l3, l4 );
    free(l3);

    {
        int li;
        for (li=0; li<*v2; li++)
            v4[li] = l4[li]; /* convert C int to MPI_Fint */
    }
    free(l4);
    
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_buffer_attach_ NFMPI_BUFFER_ATTACH
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_buffer_attach_ nfmpi_buffer_attach__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_buffer_attach_ nfmpi_buffer_attach
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_buffer_attach_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_buffer_attach( (int)(*v1), *v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_buffer_detach_ NFMPI_BUFFER_DETACH
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_buffer_detach_ nfmpi_buffer_detach__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_buffer_detach_ nfmpi_buffer_detach
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_buffer_detach_ ( MPI_Fint *v1 ){
    int ierr;
    ierr = ncmpi_buffer_detach( (int)(*v1) );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_buffer_usage_ NFMPI_INQ_BUFFER_USAGE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_buffer_usage_ nfmpi_inq_buffer_usage__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_buffer_usage_ nfmpi_inq_buffer_usage
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_buffer_usage_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_inq_buffer_usage( (int)(*v1), v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_buffer_size_ NFMPI_INQ_BUFFER_SIZE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_buffer_size_ nfmpi_inq_buffer_size__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_buffer_size_ nfmpi_inq_buffer_size
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_buffer_size_ ( MPI_Fint *v1, MPI_Offset *v2 ){
    int ierr;
    ierr = ncmpi_inq_buffer_size( (int)(*v1), v2 );
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_inq_nreqs_ NFMPI_INQ_NREQS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_inq_nreqs_ nfmpi_inq_nreqs__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_inq_nreqs_ nfmpi_inq_nreqs
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_inq_nreqs_ ( MPI_Fint *v1, int *v2 ){
    int ierr;
    int l2;
    ierr = ncmpi_inq_nreqs( (int)(*v1), &l2 );

    if (ierr == NC_NOERR) *v2 = (int)l2; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_ NFMPI_IPUT_VAR1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_ nfmpi_iput_var1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_ nfmpi_iput_var1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1( (int)(*v1), (int)(*v2 - 1), l3, v4, *v5, MPI_Type_f2c(*v6), &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_text_ NFMPI_IPUT_VAR1_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_text_ nfmpi_iput_var1_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_text_ nfmpi_iput_var1_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, char *v4 FORT_MIXED_LEN(d4), int *v5 FORT_END_LEN(d4) ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1_text( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_int1_ NFMPI_IPUT_VAR1_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_int1_ nfmpi_iput_var1_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_int1_ nfmpi_iput_var1_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const signed char * v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1_schar( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_int2_ NFMPI_IPUT_VAR1_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_int2_ nfmpi_iput_var1_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_int2_ nfmpi_iput_var1_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, short *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1_short( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_int_ NFMPI_IPUT_VAR1_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_int_ nfmpi_iput_var1_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_int_ nfmpi_iput_var1_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, int *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1_int( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_real_ NFMPI_IPUT_VAR1_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_real_ nfmpi_iput_var1_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_real_ nfmpi_iput_var1_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, float *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1_float( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_double_ NFMPI_IPUT_VAR1_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_double_ nfmpi_iput_var1_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_double_ nfmpi_iput_var1_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, double *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1_double( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var1_int8_ NFMPI_IPUT_VAR1_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var1_int8_ nfmpi_iput_var1_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var1_int8_ nfmpi_iput_var1_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var1_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const long long * v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iput_var1_longlong( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_ NFMPI_IGET_VAR1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_ nfmpi_iget_var1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_ nfmpi_iget_var1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1( (int)(*v1), (int)(*v2 - 1), l3, v4, *v5, MPI_Type_f2c(*v6), &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_int1_ NFMPI_IGET_VAR1_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_int1_ nfmpi_iget_var1_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_int1_ nfmpi_iget_var1_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, signed char * v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1_schar( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_text_ NFMPI_IGET_VAR1_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_text_ nfmpi_iget_var1_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_text_ nfmpi_iget_var1_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, char *v4 FORT_MIXED_LEN(d4), int *v5 FORT_END_LEN(d4) ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1_text( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_int2_ NFMPI_IGET_VAR1_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_int2_ nfmpi_iget_var1_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_int2_ nfmpi_iget_var1_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, short *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1_short( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_int_ NFMPI_IGET_VAR1_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_int_ nfmpi_iget_var1_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_int_ nfmpi_iget_var1_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, int *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1_int( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_real_ NFMPI_IGET_VAR1_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_real_ nfmpi_iget_var1_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_real_ nfmpi_iget_var1_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, float *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1_float( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_double_ NFMPI_IGET_VAR1_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_double_ nfmpi_iget_var1_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_double_ nfmpi_iget_var1_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, double *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1_double( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var1_int8_ NFMPI_IGET_VAR1_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var1_int8_ nfmpi_iget_var1_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var1_int8_ nfmpi_iget_var1_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var1_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, long long * v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_iget_var1_longlong( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_ NFMPI_BPUT_VAR1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_ nfmpi_bput_var1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_ nfmpi_bput_var1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, void *v4, MPI_Offset *v5, MPI_Fint *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1( (int)(*v1), (int)(*v2 - 1), l3, v4, *v5, MPI_Type_f2c(*v6), &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_text_ NFMPI_BPUT_VAR1_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_text_ nfmpi_bput_var1_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_text_ nfmpi_bput_var1_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, char *v4 FORT_MIXED_LEN(d4), int *v5 FORT_END_LEN(d4) ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1_text( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_int1_ NFMPI_BPUT_VAR1_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_int1_ nfmpi_bput_var1_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_int1_ nfmpi_bput_var1_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const signed char * v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1_schar( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_int2_ NFMPI_BPUT_VAR1_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_int2_ nfmpi_bput_var1_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_int2_ nfmpi_bput_var1_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, short *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1_short( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_int_ NFMPI_BPUT_VAR1_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_int_ nfmpi_bput_var1_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_int_ nfmpi_bput_var1_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, int *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1_int( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_real_ NFMPI_BPUT_VAR1_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_real_ nfmpi_bput_var1_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_real_ nfmpi_bput_var1_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, float *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1_float( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_double_ NFMPI_BPUT_VAR1_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_double_ nfmpi_bput_var1_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_double_ nfmpi_bput_var1_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, double *v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1_double( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var1_int8_ NFMPI_BPUT_VAR1_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var1_int8_ nfmpi_bput_var1_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var1_int8_ nfmpi_bput_var1_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var1_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, const long long * v4, int *v5 ){
    int ierr;
    MPI_Offset *l3;
    int l5;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 1 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */
    ierr = ncmpi_bput_var1_longlong( (int)(*v1), (int)(*v2 - 1), l3, v4, &l5 );
    free(l3);

    if (ierr == NC_NOERR) *v5 = (int)l5; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_ NFMPI_IPUT_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_ nfmpi_iput_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_ nfmpi_iput_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_ ( MPI_Fint *v1, MPI_Fint *v2, void *v3, MPI_Offset *v4, MPI_Fint *v5, int *v6 ){
    int ierr;
    int l6;
    ierr = ncmpi_iput_var( (int)(*v1), (int)(*v2 - 1), v3, *v4, MPI_Type_f2c(*v5), &l6 );

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_int1_ NFMPI_IPUT_VAR_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_int1_ nfmpi_iput_var_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_int1_ nfmpi_iput_var_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_int1_ ( MPI_Fint *v1, MPI_Fint *v2, const signed char * v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iput_var_schar( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_text_ NFMPI_IPUT_VAR_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_text_ nfmpi_iput_var_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_text_ nfmpi_iput_var_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_text_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), int *v4 FORT_END_LEN(d3) ){
    int ierr;
    int l4;
    ierr = ncmpi_iput_var_text( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_int2_ NFMPI_IPUT_VAR_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_int2_ nfmpi_iput_var_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_int2_ nfmpi_iput_var_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_int2_ ( MPI_Fint *v1, MPI_Fint *v2, short *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iput_var_short( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_int_ NFMPI_IPUT_VAR_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_int_ nfmpi_iput_var_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_int_ nfmpi_iput_var_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_int_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iput_var_int( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_real_ NFMPI_IPUT_VAR_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_real_ nfmpi_iput_var_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_real_ nfmpi_iput_var_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_real_ ( MPI_Fint *v1, MPI_Fint *v2, float *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iput_var_float( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_double_ NFMPI_IPUT_VAR_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_double_ nfmpi_iput_var_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_double_ nfmpi_iput_var_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_double_ ( MPI_Fint *v1, MPI_Fint *v2, double *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iput_var_double( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_var_int8_ NFMPI_IPUT_VAR_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_var_int8_ nfmpi_iput_var_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_var_int8_ nfmpi_iput_var_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_var_int8_ ( MPI_Fint *v1, MPI_Fint *v2, const long long * v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iput_var_longlong( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_ NFMPI_IGET_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_ nfmpi_iget_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_ nfmpi_iget_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_ ( MPI_Fint *v1, MPI_Fint *v2, void *v3, MPI_Offset *v4, MPI_Fint *v5, int *v6 ){
    int ierr;
    int l6;
    ierr = ncmpi_iget_var( (int)(*v1), (int)(*v2 - 1), v3, *v4, MPI_Type_f2c(*v5), &l6 );

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_int1_ NFMPI_IGET_VAR_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_int1_ nfmpi_iget_var_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_int1_ nfmpi_iget_var_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_int1_ ( MPI_Fint *v1, MPI_Fint *v2, signed char * v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iget_var_schar( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_text_ NFMPI_IGET_VAR_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_text_ nfmpi_iget_var_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_text_ nfmpi_iget_var_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_text_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), int *v4 FORT_END_LEN(d3) ){
    int ierr;
    int l4;
    ierr = ncmpi_iget_var_text( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_int2_ NFMPI_IGET_VAR_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_int2_ nfmpi_iget_var_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_int2_ nfmpi_iget_var_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_int2_ ( MPI_Fint *v1, MPI_Fint *v2, short *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iget_var_short( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_int_ NFMPI_IGET_VAR_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_int_ nfmpi_iget_var_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_int_ nfmpi_iget_var_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_int_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iget_var_int( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_real_ NFMPI_IGET_VAR_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_real_ nfmpi_iget_var_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_real_ nfmpi_iget_var_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_real_ ( MPI_Fint *v1, MPI_Fint *v2, float *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iget_var_float( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_double_ NFMPI_IGET_VAR_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_double_ nfmpi_iget_var_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_double_ nfmpi_iget_var_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_double_ ( MPI_Fint *v1, MPI_Fint *v2, double *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iget_var_double( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_var_int8_ NFMPI_IGET_VAR_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_var_int8_ nfmpi_iget_var_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_var_int8_ nfmpi_iget_var_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_var_int8_ ( MPI_Fint *v1, MPI_Fint *v2, long long * v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_iget_var_longlong( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_ NFMPI_BPUT_VAR
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_ nfmpi_bput_var__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_ nfmpi_bput_var
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_ ( MPI_Fint *v1, MPI_Fint *v2, void *v3, MPI_Offset *v4, MPI_Fint *v5, int *v6 ){
    int ierr;
    int l6;
    ierr = ncmpi_bput_var( (int)(*v1), (int)(*v2 - 1), v3, *v4, MPI_Type_f2c(*v5), &l6 );

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_int1_ NFMPI_BPUT_VAR_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_int1_ nfmpi_bput_var_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_int1_ nfmpi_bput_var_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_int1_ ( MPI_Fint *v1, MPI_Fint *v2, const signed char * v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_bput_var_schar( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_text_ NFMPI_BPUT_VAR_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_text_ nfmpi_bput_var_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_text_ nfmpi_bput_var_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_text_ ( MPI_Fint *v1, MPI_Fint *v2, char *v3 FORT_MIXED_LEN(d3), int *v4 FORT_END_LEN(d3) ){
    int ierr;
    int l4;
    ierr = ncmpi_bput_var_text( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_int2_ NFMPI_BPUT_VAR_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_int2_ nfmpi_bput_var_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_int2_ nfmpi_bput_var_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_int2_ ( MPI_Fint *v1, MPI_Fint *v2, short *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_bput_var_short( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_int_ NFMPI_BPUT_VAR_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_int_ nfmpi_bput_var_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_int_ nfmpi_bput_var_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_int_ ( MPI_Fint *v1, MPI_Fint *v2, int *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_bput_var_int( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_real_ NFMPI_BPUT_VAR_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_real_ nfmpi_bput_var_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_real_ nfmpi_bput_var_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_real_ ( MPI_Fint *v1, MPI_Fint *v2, float *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_bput_var_float( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_double_ NFMPI_BPUT_VAR_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_double_ nfmpi_bput_var_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_double_ nfmpi_bput_var_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_double_ ( MPI_Fint *v1, MPI_Fint *v2, double *v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_bput_var_double( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_var_int8_ NFMPI_BPUT_VAR_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_var_int8_ nfmpi_bput_var_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_var_int8_ nfmpi_bput_var_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_var_int8_ ( MPI_Fint *v1, MPI_Fint *v2, const long long * v3, int *v4 ){
    int ierr;
    int l4;
    ierr = ncmpi_bput_var_longlong( (int)(*v1), (int)(*v2 - 1), v3, &l4 );

    if (ierr == NC_NOERR) *v4 = (int)l4; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_ NFMPI_IPUT_VARA
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_ nfmpi_iput_vara__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_ nfmpi_iput_vara
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, void *v5, MPI_Offset *v6, MPI_Fint *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, *v6, MPI_Type_f2c(*v7), &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_int1_ NFMPI_IPUT_VARA_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_int1_ nfmpi_iput_vara_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_int1_ nfmpi_iput_vara_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const signed char * v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_text_ NFMPI_IPUT_VARA_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_text_ nfmpi_iput_vara_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_text_ nfmpi_iput_vara_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5), int *v6 FORT_END_LEN(d5) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara_text( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_int2_ NFMPI_IPUT_VARA_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_int2_ nfmpi_iput_vara_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_int2_ nfmpi_iput_vara_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, short *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara_short( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_int_ NFMPI_IPUT_VARA_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_int_ nfmpi_iput_vara_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_int_ nfmpi_iput_vara_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, int *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara_int( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_real_ NFMPI_IPUT_VARA_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_real_ nfmpi_iput_vara_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_real_ nfmpi_iput_vara_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, float *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara_float( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_double_ NFMPI_IPUT_VARA_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_double_ nfmpi_iput_vara_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_double_ nfmpi_iput_vara_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, double *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara_double( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vara_int8_ NFMPI_IPUT_VARA_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vara_int8_ nfmpi_iput_vara_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vara_int8_ nfmpi_iput_vara_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vara_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const long long * v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iput_vara_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_ NFMPI_IGET_VARA
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_ nfmpi_iget_vara__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_ nfmpi_iget_vara
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, void *v5, MPI_Offset *v6, MPI_Fint *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, *v6, MPI_Type_f2c(*v7), &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_int1_ NFMPI_IGET_VARA_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_int1_ nfmpi_iget_vara_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_int1_ nfmpi_iget_vara_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, signed char * v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_text_ NFMPI_IGET_VARA_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_text_ nfmpi_iget_vara_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_text_ nfmpi_iget_vara_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5), int *v6 FORT_END_LEN(d5) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara_text( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_int2_ NFMPI_IGET_VARA_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_int2_ nfmpi_iget_vara_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_int2_ nfmpi_iget_vara_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, short *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara_short( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_int_ NFMPI_IGET_VARA_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_int_ nfmpi_iget_vara_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_int_ nfmpi_iget_vara_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, int *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara_int( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_real_ NFMPI_IGET_VARA_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_real_ nfmpi_iget_vara_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_real_ nfmpi_iget_vara_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, float *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara_float( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_double_ NFMPI_IGET_VARA_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_double_ nfmpi_iget_vara_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_double_ nfmpi_iget_vara_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, double *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara_double( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vara_int8_ NFMPI_IGET_VARA_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vara_int8_ nfmpi_iget_vara_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vara_int8_ nfmpi_iget_vara_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vara_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, long long * v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_iget_vara_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_ NFMPI_BPUT_VARA
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_ nfmpi_bput_vara__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_ nfmpi_bput_vara
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, void *v5, MPI_Offset *v6, MPI_Fint *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, *v6, MPI_Type_f2c(*v7), &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_int1_ NFMPI_BPUT_VARA_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_int1_ nfmpi_bput_vara_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_int1_ nfmpi_bput_vara_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const signed char * v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_text_ NFMPI_BPUT_VARA_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_text_ nfmpi_bput_vara_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_text_ nfmpi_bput_vara_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, char *v5 FORT_MIXED_LEN(d5), int *v6 FORT_END_LEN(d5) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara_text( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_int2_ NFMPI_BPUT_VARA_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_int2_ nfmpi_bput_vara_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_int2_ nfmpi_bput_vara_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, short *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara_short( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_int_ NFMPI_BPUT_VARA_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_int_ nfmpi_bput_vara_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_int_ nfmpi_bput_vara_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, int *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara_int( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_real_ NFMPI_BPUT_VARA_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_real_ nfmpi_bput_vara_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_real_ nfmpi_bput_vara_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, float *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara_float( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_double_ NFMPI_BPUT_VARA_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_double_ nfmpi_bput_vara_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_double_ nfmpi_bput_vara_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, double *v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara_double( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vara_int8_ NFMPI_BPUT_VARA_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vara_int8_ nfmpi_bput_vara_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vara_int8_ nfmpi_bput_vara_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vara_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, const long long * v5, int *v6 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    int l6;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 2 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];
    ierr = ncmpi_bput_vara_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, v5, &l6 );
    free(l3);

    if (ierr == NC_NOERR) *v6 = (int)l6; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_ NFMPI_IPUT_VARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_ nfmpi_iput_vars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_ nfmpi_iput_vars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8, int *v9 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l9;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, *v7, MPI_Type_f2c(*v8), &l9 );
    free(l3);

    if (ierr == NC_NOERR) *v9 = (int)l9; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_int1_ NFMPI_IPUT_VARS_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_int1_ nfmpi_iput_vars_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_int1_ nfmpi_iput_vars_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_text_ NFMPI_IPUT_VARS_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_text_ nfmpi_iput_vars_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_text_ nfmpi_iput_vars_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6), int *v7 FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_int2_ NFMPI_IPUT_VARS_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_int2_ nfmpi_iput_vars_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_int2_ nfmpi_iput_vars_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_int_ NFMPI_IPUT_VARS_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_int_ nfmpi_iput_vars_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_int_ nfmpi_iput_vars_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_real_ NFMPI_IPUT_VARS_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_real_ nfmpi_iput_vars_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_real_ nfmpi_iput_vars_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_double_ NFMPI_IPUT_VARS_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_double_ nfmpi_iput_vars_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_double_ nfmpi_iput_vars_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_vars_int8_ NFMPI_IPUT_VARS_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_vars_int8_ nfmpi_iput_vars_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_vars_int8_ nfmpi_iput_vars_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_vars_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iput_vars_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_ NFMPI_IGET_VARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_ nfmpi_iget_vars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_ nfmpi_iget_vars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8, int *v9 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l9;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, *v7, MPI_Type_f2c(*v8), &l9 );
    free(l3);

    if (ierr == NC_NOERR) *v9 = (int)l9; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_int1_ NFMPI_IGET_VARS_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_int1_ nfmpi_iget_vars_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_int1_ nfmpi_iget_vars_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, signed char * v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_text_ NFMPI_IGET_VARS_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_text_ nfmpi_iget_vars_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_text_ nfmpi_iget_vars_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6), int *v7 FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_int2_ NFMPI_IGET_VARS_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_int2_ nfmpi_iget_vars_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_int2_ nfmpi_iget_vars_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_int_ NFMPI_IGET_VARS_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_int_ nfmpi_iget_vars_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_int_ nfmpi_iget_vars_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_real_ NFMPI_IGET_VARS_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_real_ nfmpi_iget_vars_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_real_ nfmpi_iget_vars_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_double_ NFMPI_IGET_VARS_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_double_ nfmpi_iget_vars_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_double_ nfmpi_iget_vars_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_vars_int8_ NFMPI_IGET_VARS_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_vars_int8_ nfmpi_iget_vars_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_vars_int8_ nfmpi_iget_vars_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_vars_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, long long * v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_iget_vars_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_ NFMPI_BPUT_VARS
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_ nfmpi_bput_vars__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_ nfmpi_bput_vars
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8, int *v9 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l9;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, *v7, MPI_Type_f2c(*v8), &l9 );
    free(l3);

    if (ierr == NC_NOERR) *v9 = (int)l9; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_int1_ NFMPI_BPUT_VARS_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_int1_ nfmpi_bput_vars_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_int1_ nfmpi_bput_vars_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_text_ NFMPI_BPUT_VARS_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_text_ nfmpi_bput_vars_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_text_ nfmpi_bput_vars_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6), int *v7 FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_int2_ NFMPI_BPUT_VARS_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_int2_ nfmpi_bput_vars_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_int2_ nfmpi_bput_vars_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_int_ NFMPI_BPUT_VARS_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_int_ nfmpi_bput_vars_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_int_ nfmpi_bput_vars_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_real_ NFMPI_BPUT_VARS_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_real_ nfmpi_bput_vars_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_real_ nfmpi_bput_vars_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_double_ NFMPI_BPUT_VARS_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_double_ nfmpi_bput_vars_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_double_ nfmpi_bput_vars_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_vars_int8_ NFMPI_BPUT_VARS_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_vars_int8_ nfmpi_bput_vars_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_vars_int8_ nfmpi_bput_vars_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_vars_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6, int *v7 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    int l7;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 3 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];
    ierr = ncmpi_bput_vars_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, v6, &l7 );
    free(l3);

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_ NFMPI_IPUT_VARM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_ nfmpi_iput_varm__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_ nfmpi_iput_varm
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, void *v7, MPI_Offset *v8, MPI_Fint *v9, int *v10 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l10;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, *v8, MPI_Type_f2c(*v9), &l10 );
    free(l3);

    if (ierr == NC_NOERR) *v10 = (int)l10; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_int1_ NFMPI_IPUT_VARM_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_int1_ nfmpi_iput_varm_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_int1_ nfmpi_iput_varm_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const signed char * v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_text_ NFMPI_IPUT_VARM_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_text_ nfmpi_iput_varm_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_text_ nfmpi_iput_varm_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, char *v7 FORT_MIXED_LEN(d7), int *v8 FORT_END_LEN(d7) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_int2_ NFMPI_IPUT_VARM_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_int2_ nfmpi_iput_varm_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_int2_ nfmpi_iput_varm_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, short *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_int_ NFMPI_IPUT_VARM_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_int_ nfmpi_iput_varm_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_int_ nfmpi_iput_varm_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, int *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_real_ NFMPI_IPUT_VARM_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_real_ nfmpi_iput_varm_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_real_ nfmpi_iput_varm_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, float *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_double_ NFMPI_IPUT_VARM_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_double_ nfmpi_iput_varm_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_double_ nfmpi_iput_varm_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, double *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varm_int8_ NFMPI_IPUT_VARM_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varm_int8_ nfmpi_iput_varm_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varm_int8_ nfmpi_iput_varm_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varm_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const long long * v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iput_varm_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_ NFMPI_IGET_VARM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_ nfmpi_iget_varm__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_ nfmpi_iget_varm
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, void *v7, MPI_Offset *v8, MPI_Fint *v9, int *v10 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l10;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, *v8, MPI_Type_f2c(*v9), &l10 );
    free(l3);

    if (ierr == NC_NOERR) *v10 = (int)l10; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_int1_ NFMPI_IGET_VARM_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_int1_ nfmpi_iget_varm_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_int1_ nfmpi_iget_varm_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, signed char * v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_text_ NFMPI_IGET_VARM_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_text_ nfmpi_iget_varm_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_text_ nfmpi_iget_varm_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, char *v7 FORT_MIXED_LEN(d7), int *v8 FORT_END_LEN(d7) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_int2_ NFMPI_IGET_VARM_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_int2_ nfmpi_iget_varm_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_int2_ nfmpi_iget_varm_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, short *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_int_ NFMPI_IGET_VARM_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_int_ nfmpi_iget_varm_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_int_ nfmpi_iget_varm_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, int *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_real_ NFMPI_IGET_VARM_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_real_ nfmpi_iget_varm_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_real_ nfmpi_iget_varm_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, float *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_double_ NFMPI_IGET_VARM_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_double_ nfmpi_iget_varm_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_double_ nfmpi_iget_varm_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, double *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varm_int8_ NFMPI_IGET_VARM_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varm_int8_ nfmpi_iget_varm_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varm_int8_ nfmpi_iget_varm_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varm_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, long long * v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_iget_varm_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_ NFMPI_BPUT_VARM
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_ nfmpi_bput_varm__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_ nfmpi_bput_varm
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, void *v7, MPI_Offset *v8, MPI_Fint *v9, int *v10 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l10;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, *v8, MPI_Type_f2c(*v9), &l10 );
    free(l3);

    if (ierr == NC_NOERR) *v10 = (int)l10; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_int1_ NFMPI_BPUT_VARM_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_int1_ nfmpi_bput_varm_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_int1_ nfmpi_bput_varm_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const signed char * v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm_schar( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_text_ NFMPI_BPUT_VARM_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_text_ nfmpi_bput_varm_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_text_ nfmpi_bput_varm_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, char *v7 FORT_MIXED_LEN(d7), int *v8 FORT_END_LEN(d7) ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm_text( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_int2_ NFMPI_BPUT_VARM_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_int2_ nfmpi_bput_varm_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_int2_ nfmpi_bput_varm_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, short *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm_short( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_int_ NFMPI_BPUT_VARM_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_int_ nfmpi_bput_varm_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_int_ nfmpi_bput_varm_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, int *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm_int( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_real_ NFMPI_BPUT_VARM_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_real_ nfmpi_bput_varm_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_real_ nfmpi_bput_varm_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, float *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm_float( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_double_ NFMPI_BPUT_VARM_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_double_ nfmpi_bput_varm_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_double_ nfmpi_bput_varm_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, double *v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm_double( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varm_int8_ NFMPI_BPUT_VARM_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varm_int8_ nfmpi_bput_varm_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varm_int8_ nfmpi_bput_varm_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varm_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Offset *v3, MPI_Offset *v4, MPI_Offset *v5, MPI_Offset *v6, const long long * v7, int *v8 ){
    int ierr;
    MPI_Offset *l3;
    MPI_Offset *l4;
    MPI_Offset *l5;
    MPI_Offset *l6;
    int l8;

    int ndims, li;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    l3 = (MPI_Offset*) malloc((size_t)ndims * 4 * SIZEOF_MPI_OFFSET);
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l3[li] = v3[ndims-1-li] - 1; /* convert 1-based to 0-based */

    l4 = l3 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l4[li] = v4[ndims-1-li];

    l5 = l4 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l5[li] = v5[ndims-1-li];

    l6 = l5 + ndims;
    for (li=0; li<ndims; li++) /* convert Fortran order to C order */
        l6[li] = v6[ndims-1-li];
    ierr = ncmpi_bput_varm_longlong( (int)(*v1), (int)(*v2 - 1), l3, l4, l5, l6, v7, &l8 );
    free(l3);

    if (ierr == NC_NOERR) *v8 = (int)l8; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_ NFMPI_IPUT_VARN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_ nfmpi_iput_varn__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_ nfmpi_iput_varn
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8, int *v9 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l9;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, *v7, MPI_Type_f2c(*v8), &l9 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v9 = (int)l9; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_ NFMPI_IGET_VARN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_ nfmpi_iget_varn__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_ nfmpi_iget_varn
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8, int *v9 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l9;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, *v7, MPI_Type_f2c(*v8), &l9 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v9 = (int)l9; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_text_ NFMPI_IPUT_VARN_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_text_ nfmpi_iput_varn_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_text_ nfmpi_iput_varn_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6), int *v7 FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn_text( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_int1_ NFMPI_IPUT_VARN_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_int1_ nfmpi_iput_varn_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_int1_ nfmpi_iput_varn_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn_schar( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_int2_ NFMPI_IPUT_VARN_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_int2_ nfmpi_iput_varn_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_int2_ nfmpi_iput_varn_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn_short( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_int_ NFMPI_IPUT_VARN_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_int_ nfmpi_iput_varn_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_int_ nfmpi_iput_varn_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn_int( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_real_ NFMPI_IPUT_VARN_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_real_ nfmpi_iput_varn_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_real_ nfmpi_iput_varn_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn_float( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_double_ NFMPI_IPUT_VARN_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_double_ nfmpi_iput_varn_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_double_ nfmpi_iput_varn_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn_double( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iput_varn_int8_ NFMPI_IPUT_VARN_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iput_varn_int8_ nfmpi_iput_varn_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iput_varn_int8_ nfmpi_iput_varn_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iput_varn_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iput_varn_longlong( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_text_ NFMPI_IGET_VARN_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_text_ nfmpi_iget_varn_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_text_ nfmpi_iget_varn_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6), int *v7 FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn_text( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_int1_ NFMPI_IGET_VARN_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_int1_ nfmpi_iget_varn_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_int1_ nfmpi_iget_varn_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, signed char * v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn_schar( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_int2_ NFMPI_IGET_VARN_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_int2_ nfmpi_iget_varn_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_int2_ nfmpi_iget_varn_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn_short( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_int_ NFMPI_IGET_VARN_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_int_ nfmpi_iget_varn_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_int_ nfmpi_iget_varn_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn_int( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_real_ NFMPI_IGET_VARN_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_real_ nfmpi_iget_varn_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_real_ nfmpi_iget_varn_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn_float( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_double_ NFMPI_IGET_VARN_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_double_ nfmpi_iget_varn_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_double_ nfmpi_iget_varn_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn_double( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_iget_varn_int8_ NFMPI_IGET_VARN_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_iget_varn_int8_ nfmpi_iget_varn_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_iget_varn_int8_ nfmpi_iget_varn_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_iget_varn_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, long long * v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_iget_varn_longlong( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_ NFMPI_BPUT_VARN
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_ nfmpi_bput_varn__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_ nfmpi_bput_varn
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, void *v6, MPI_Offset *v7, MPI_Fint *v8, int *v9 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l9;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, *v7, MPI_Type_f2c(*v8), &l9 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v9 = (int)l9; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_text_ NFMPI_BPUT_VARN_TEXT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_text_ nfmpi_bput_varn_text__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_text_ nfmpi_bput_varn_text
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_text_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, char *v6 FORT_MIXED_LEN(d6), int *v7 FORT_END_LEN(d6) ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn_text( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_int1_ NFMPI_BPUT_VARN_INT1
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_int1_ nfmpi_bput_varn_int1__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_int1_ nfmpi_bput_varn_int1
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_int1_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const signed char * v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn_schar( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_int2_ NFMPI_BPUT_VARN_INT2
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_int2_ nfmpi_bput_varn_int2__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_int2_ nfmpi_bput_varn_int2
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_int2_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, short *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn_short( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_int_ NFMPI_BPUT_VARN_INT
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_int_ nfmpi_bput_varn_int__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_int_ nfmpi_bput_varn_int
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_int_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, int *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn_int( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_real_ NFMPI_BPUT_VARN_REAL
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_real_ nfmpi_bput_varn_real__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_real_ nfmpi_bput_varn_real
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_real_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, float *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn_float( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_double_ NFMPI_BPUT_VARN_DOUBLE
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_double_ nfmpi_bput_varn_double__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_double_ nfmpi_bput_varn_double
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_double_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, double *v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn_double( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}

#ifdef F77_NAME_UPPER
#define nfmpi_bput_varn_int8_ NFMPI_BPUT_VARN_INT8
#elif defined(F77_NAME_LOWER_2USCORE)
#define nfmpi_bput_varn_int8_ nfmpi_bput_varn_int8__
#elif !defined(F77_NAME_LOWER_USCORE)
#define nfmpi_bput_varn_int8_ nfmpi_bput_varn_int8
/* Else leave name alone */
#endif

FORTRAN_API int FORT_CALL nfmpi_bput_varn_int8_ ( MPI_Fint *v1, MPI_Fint *v2, MPI_Fint *v3, MPI_Offset *v4, MPI_Offset *v5, const long long * v6, int *v7 ){
    int ierr;
    MPI_Offset **l4=NULL;
    MPI_Offset **l5=NULL;
    int l7;

    int ndims, li, lj;
    ierr = ncmpi_inq_varndims((int)(*v1), (int)(*v2-1), &ndims); /* get number of dimensions */
    if (ierr != NC_NOERR) return ierr;

    if (*v3 > 0) {
        l4    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l4[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l4[lj] = l4[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l4[lj][li] = v4[lj*ndims + ndims-1-li] - 1; /* convert 1-based to 0-based */
    

    if (*v3 > 0) {
        l5    = (MPI_Offset**) malloc((size_t)*v3 * sizeof(MPI_Offset*));
        l5[0] = (MPI_Offset*)  malloc((size_t)*v3 * (size_t)ndims * SIZEOF_MPI_OFFSET);
    }
    for (lj=1; lj<*v3; lj++)
        l5[lj] = l5[lj-1] + ndims;
    for (lj=0; lj<*v3; lj++)
        for (li=0; li<ndims; li++) /* convert Fortran order to C order */
            l5[lj][li] = v5[lj*ndims + ndims-1-li];
    
    ierr = ncmpi_bput_varn_longlong( (int)(*v1), (int)(*v2 - 1), (int)(*v3), l4, l5, v6, &l7 );

    if (*v3 > 0) {
       free(l4[0]);
       free(l4);
    }

    if (*v3 > 0) {
       free(l5[0]);
       free(l5);
    }

    if (ierr == NC_NOERR) *v7 = (int)l7; /* cast int to MPI_Fint */
    return ierr;
}
