/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 30 "gram.y"

#include "pmapi.h"
#include "libpcp.h"
#include "logger.h"

int		mystate = GLOBAL;	/* config file parser state */

__pmHashCtl	pm_hash;
task_t		*tasklist;		/* task list for logging configuration */
dynroot_t	*dyn_roots;		/* dynamic root list for handling PMCD_NAMES_CHANGE */
int		n_dyn_roots = 0;

static task_t	*tp;
static int	numinst;
static int	*intlist;
static char	**extlist;
static int	state;			/* logging state, current block */
static char	*metricName;		/* current metric, current block */

typedef struct _hl {
    struct _hl	*hl_next;
    char	*hl_name;
    int		hl_line;
} hostlist_t;

static hostlist_t	*hl_root;
static hostlist_t	*hl_last;
static hostlist_t	*hlp;
static hostlist_t	*prevhlp;
static int		opmask;		/* operations mask */
static int		specmask;	/* specifications mask */
static int		allow;		/* host allow/disallow state */

static int lookup_metric_name(const char *);
static void activate_new_metric(const char *);
static void activate_cached_metric(const char *, int);
static task_t *findtask(int, struct timeval *);
static void append_dynroot_list(const char *, int, int, struct timeval *);


#line 112 "gram.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "gram.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_LSQB = 3,                       /* LSQB  */
  YYSYMBOL_RSQB = 4,                       /* RSQB  */
  YYSYMBOL_COMMA = 5,                      /* COMMA  */
  YYSYMBOL_LBRACE = 6,                     /* LBRACE  */
  YYSYMBOL_RBRACE = 7,                     /* RBRACE  */
  YYSYMBOL_COLON = 8,                      /* COLON  */
  YYSYMBOL_SEMICOLON = 9,                  /* SEMICOLON  */
  YYSYMBOL_LOG = 10,                       /* LOG  */
  YYSYMBOL_MANDATORY = 11,                 /* MANDATORY  */
  YYSYMBOL_ADVISORY = 12,                  /* ADVISORY  */
  YYSYMBOL_ON = 13,                        /* ON  */
  YYSYMBOL_OFF = 14,                       /* OFF  */
  YYSYMBOL_MAYBE = 15,                     /* MAYBE  */
  YYSYMBOL_EVERY = 16,                     /* EVERY  */
  YYSYMBOL_ONCE = 17,                      /* ONCE  */
  YYSYMBOL_DEFAULT = 18,                   /* DEFAULT  */
  YYSYMBOL_MSEC = 19,                      /* MSEC  */
  YYSYMBOL_SECOND = 20,                    /* SECOND  */
  YYSYMBOL_MINUTE = 21,                    /* MINUTE  */
  YYSYMBOL_HOUR = 22,                      /* HOUR  */
  YYSYMBOL_ACCESS = 23,                    /* ACCESS  */
  YYSYMBOL_ENQUIRE = 24,                   /* ENQUIRE  */
  YYSYMBOL_ALLOW = 25,                     /* ALLOW  */
  YYSYMBOL_DISALLOW = 26,                  /* DISALLOW  */
  YYSYMBOL_ALL = 27,                       /* ALL  */
  YYSYMBOL_EXCEPT = 28,                    /* EXCEPT  */
  YYSYMBOL_NAME = 29,                      /* NAME  */
  YYSYMBOL_STRING = 30,                    /* STRING  */
  YYSYMBOL_IPSPEC = 31,                    /* IPSPEC  */
  YYSYMBOL_HOSTNAME = 32,                  /* HOSTNAME  */
  YYSYMBOL_URL = 33,                       /* URL  */
  YYSYMBOL_NUMBER = 34,                    /* NUMBER  */
  YYSYMBOL_YYACCEPT = 35,                  /* $accept  */
  YYSYMBOL_config = 36,                    /* config  */
  YYSYMBOL_specopt = 37,                   /* specopt  */
  YYSYMBOL_spec = 38,                      /* spec  */
  YYSYMBOL_stmt = 39,                      /* stmt  */
  YYSYMBOL_dowhat = 40,                    /* dowhat  */
  YYSYMBOL_logopt = 41,                    /* logopt  */
  YYSYMBOL_action = 42,                    /* action  */
  YYSYMBOL_cntrl = 43,                     /* cntrl  */
  YYSYMBOL_frequency = 44,                 /* frequency  */
  YYSYMBOL_everyopt = 45,                  /* everyopt  */
  YYSYMBOL_timeunits = 46,                 /* timeunits  */
  YYSYMBOL_somemetrics = 47,               /* somemetrics  */
  YYSYMBOL_48_1 = 48,                      /* $@1  */
  YYSYMBOL_metriclist = 49,                /* metriclist  */
  YYSYMBOL_metricspec = 50,                /* metricspec  */
  YYSYMBOL_51_2 = 51,                      /* $@2  */
  YYSYMBOL_optinst = 52,                   /* optinst  */
  YYSYMBOL_instancelist = 53,              /* instancelist  */
  YYSYMBOL_instance = 54,                  /* instance  */
  YYSYMBOL_accessopt = 55,                 /* accessopt  */
  YYSYMBOL_ctllist = 56,                   /* ctllist  */
  YYSYMBOL_ctl = 57,                       /* ctl  */
  YYSYMBOL_allow = 58,                     /* allow  */
  YYSYMBOL_hostlist = 59,                  /* hostlist  */
  YYSYMBOL_host = 60,                      /* host  */
  YYSYMBOL_hostspec = 61,                  /* hostspec  */
  YYSYMBOL_operation = 62,                 /* operation  */
  YYSYMBOL_operlist = 63,                  /* operlist  */
  YYSYMBOL_op = 64                         /* op  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  8
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   69

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  35
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  30
/* YYNRULES -- Number of rules.  */
#define YYNRULES  63
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  83

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   289


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   100,   100,   103,   104,   107,   108,   111,   120,   163,
     164,   167,   185,   186,   195,   196,   197,   200,   201,   202,
     209,   210,   213,   214,   215,   216,   219,   219,   220,   223,
     224,   225,   229,   228,   299,   300,   303,   304,   305,   308,
     309,   310,   313,   314,   317,   318,   321,   350,   351,   354,
     355,   358,   378,   379,   380,   381,   384,   390,   398,   406,
     407,   410,   411,   412
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "LSQB", "RSQB",
  "COMMA", "LBRACE", "RBRACE", "COLON", "SEMICOLON", "LOG", "MANDATORY",
  "ADVISORY", "ON", "OFF", "MAYBE", "EVERY", "ONCE", "DEFAULT", "MSEC",
  "SECOND", "MINUTE", "HOUR", "ACCESS", "ENQUIRE", "ALLOW", "DISALLOW",
  "ALL", "EXCEPT", "NAME", "STRING", "IPSPEC", "HOSTNAME", "URL", "NUMBER",
  "$accept", "config", "specopt", "spec", "stmt", "dowhat", "logopt",
  "action", "cntrl", "frequency", "everyopt", "timeunits", "somemetrics",
  "$@1", "metriclist", "metricspec", "$@2", "optinst", "instancelist",
  "instance", "accessopt", "ctllist", "ctl", "allow", "hostlist", "host",
  "hostspec", "operation", "operlist", "op", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-62)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-5)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      13,   -62,     8,    17,    31,   -62,    -1,     0,   -62,    32,
     -62,   -62,   -62,   -62,   -62,   -62,   -12,   -62,   -62,    19,
      38,    15,    51,   -62,    21,   -62,    27,    -3,   -62,     6,
     -62,   -62,   -62,   -62,   -62,    22,   -62,   -62,   -62,    27,
      14,    15,   -62,   -62,   -62,   -62,   -62,    53,    -5,    29,
     -62,   -62,   -62,   -62,   -62,    50,    54,   -62,   -62,   -62,
       6,   -62,   -62,   -62,   -62,   -62,   -62,     3,    14,   -62,
     -62,   -62,   -62,    33,    55,   -62,    57,   -62,    -2,   -62,
      -2,   -62,   -62
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
      10,     9,     0,    43,    10,     5,     0,    16,     1,     0,
       2,     6,    26,    32,     7,    28,    14,    15,     8,     0,
       0,     0,    35,    13,    21,    12,     0,     0,    29,     0,
      33,    20,    18,    19,    11,     0,    47,    48,    42,    44,
       0,     0,    27,    30,    39,    41,    40,     0,    36,     0,
      45,    55,    52,    54,    53,     0,    49,    51,    31,    34,
       0,    37,    22,    23,    24,    25,    17,     0,     0,    38,
      62,    61,    63,    57,     0,    56,    59,    50,     0,    46,
       0,    58,    60
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -62,   -62,   -62,   -62,    56,   -62,   -62,   -62,   -62,   -62,
     -62,   -62,   -62,   -62,   -62,   -20,   -62,   -62,   -42,   -62,
     -62,    24,   -62,   -62,     1,   -62,   -62,   -62,   -61,   -62
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     2,     3,     4,     5,     6,     7,    18,    19,    34,
      35,    66,    14,    21,    27,    15,    22,    30,    47,    48,
      10,    38,    39,    40,    55,    56,    57,    74,    75,    76
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      60,    28,    41,    23,    42,    12,    61,    43,     8,    70,
      71,    16,    17,    -4,    70,    71,    -4,    81,    69,    82,
       9,    58,    72,     1,    44,    45,    13,    72,    13,    46,
      73,    -3,    24,    25,    -3,    44,    45,    31,    32,    33,
      46,     1,    26,    51,    13,    52,    53,    54,    62,    63,
      64,    65,    36,    37,    29,    20,    49,    59,    67,    68,
      11,    78,    80,    50,    79,     0,     0,     0,     0,    77
};

static const yytype_int8 yycheck[] =
{
       5,    21,     5,    15,     7,     6,    48,    27,     0,    11,
      12,    11,    12,     0,    11,    12,     3,    78,    60,    80,
       3,    41,    24,    10,    29,    30,    29,    24,    29,    34,
      27,     0,    13,    14,     3,    29,    30,    16,    17,    18,
      34,    10,     4,    29,    29,    31,    32,    33,    19,    20,
      21,    22,    25,    26,     3,    23,    34,     4,     8,     5,
       4,    28,     5,    39,     9,    -1,    -1,    -1,    -1,    68
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    10,    36,    37,    38,    39,    40,    41,     0,     3,
      55,    39,     6,    29,    47,    50,    11,    12,    42,    43,
      23,    48,    51,    15,    13,    14,     4,    49,    50,     3,
      52,    16,    17,    18,    44,    45,    25,    26,    56,    57,
      58,     5,     7,    50,    29,    30,    34,    53,    54,    34,
      56,    29,    31,    32,    33,    59,    60,    61,    50,     4,
       5,    53,    19,    20,    21,    22,    46,     8,     5,    53,
      11,    12,    24,    27,    62,    63,    64,    59,    28,     9,
       5,    63,    63
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    35,    36,    37,    37,    38,    38,    39,    40,    41,
      41,    42,    42,    42,    43,    43,    43,    44,    44,    44,
      45,    45,    46,    46,    46,    46,    48,    47,    47,    49,
      49,    49,    51,    50,    52,    52,    53,    53,    53,    54,
      54,    54,    55,    55,    56,    56,    57,    58,    58,    59,
      59,    60,    61,    61,    61,    61,    62,    62,    62,    63,
      63,    64,    64,    64
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     1,     0,     1,     2,     2,     2,     1,
       0,     3,     2,     2,     1,     1,     0,     3,     1,     1,
       1,     0,     1,     1,     1,     1,     0,     4,     1,     1,
       2,     3,     0,     3,     3,     0,     1,     2,     3,     1,
       1,     1,     4,     0,     1,     2,     5,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       3,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 7: /* stmt: dowhat somemetrics  */
#line 112 "gram.y"
                {
		    mystate = GLOBAL;
		    if (tp->t_numvalid)
			linkback(tp);
		    state = 0;
                }
#line 1223 "gram.tab.c"
    break;

  case 8: /* dowhat: logopt action  */
#line 121 "gram.y"
                {
		    struct timeval ldelta;

		    ldelta.tv_sec = (yyvsp[0].lval) / 1000;
		    ldelta.tv_usec = 1000 * ((yyvsp[0].lval) % 1000);

		    /*
		     * Search for an existing task for this state/interval;
		     * only allocate and setup a new task if none exists.
		     */
		    if ((tp = findtask(state, &ldelta)) == NULL) {
			if ((tp = (task_t *)calloc(1, sizeof(task_t))) == NULL) {
			    char emess[256];
			    pmsprintf(emess, sizeof(emess), "malloc failed: %s", osstrerror());
			    yyerror(emess);
			} else {
			    task_t	*ltp;

			    /*
			     * Add to end of tasklist ... this means the
			     * first records to appear in the archive
			     * are more likely to follow the order of
			     * clauses in the configuration.
			     * Exceptions are "log once" that will appear
			     * first, and clauses combined into the same
			     * task.
			     */
			    for (ltp = tasklist; ltp != NULL && ltp->t_next != NULL; ltp = ltp->t_next)
				;
			    if (ltp == NULL)
				tasklist = tp;
			    else
				ltp->t_next = tp;
			    tp->t_next = NULL;
			    tp->t_delta = ldelta;
			    tp->t_state = state;
			}
		    }
		    state = 0;
		}
#line 1268 "gram.tab.c"
    break;

  case 11: /* action: cntrl ON frequency  */
#line 168 "gram.y"
                { 
		    char emess[256];
                    if ((yyvsp[0].lval) < 0) {
			pmsprintf(emess, sizeof(emess),
				"Logging delta (%ld msec) must be positive",(yyvsp[0].lval));
			yyerror(emess);
		    }
		    else if ((yyvsp[0].lval) >  PMLC_MAX_DELTA) {
			pmsprintf(emess, sizeof(emess),
				"Logging delta (%ld msec) cannot be bigger "
				"than %d msec", (yyvsp[0].lval), PMLC_MAX_DELTA);
			yyerror(emess);
		    }

                    PMLC_SET_ON(state, 1); 
                    (yyval.lval) = (yyvsp[0].lval);
                }
#line 1290 "gram.tab.c"
    break;

  case 12: /* action: cntrl OFF  */
#line 185 "gram.y"
                                                { PMLC_SET_ON(state, 0);(yyval.lval) = 0;}
#line 1296 "gram.tab.c"
    break;

  case 13: /* action: MANDATORY MAYBE  */
#line 187 "gram.y"
                {
                    PMLC_SET_MAND(state, 0);
                    PMLC_SET_ON(state, 0);
                    PMLC_SET_MAYBE(state, 1);
                    (yyval.lval) = 0;
                }
#line 1307 "gram.tab.c"
    break;

  case 14: /* cntrl: MANDATORY  */
#line 195 "gram.y"
                                                { PMLC_SET_MAND(state, 1); }
#line 1313 "gram.tab.c"
    break;

  case 15: /* cntrl: ADVISORY  */
#line 196 "gram.y"
                                                { PMLC_SET_MAND(state, 0); }
#line 1319 "gram.tab.c"
    break;

  case 16: /* cntrl: %empty  */
#line 197 "gram.y"
                                                { PMLC_SET_MAND(state, 0); }
#line 1325 "gram.tab.c"
    break;

  case 17: /* frequency: everyopt NUMBER timeunits  */
#line 200 "gram.y"
                                                { (yyval.lval) = (yyvsp[-1].lval)*(yyvsp[0].lval); }
#line 1331 "gram.tab.c"
    break;

  case 18: /* frequency: ONCE  */
#line 201 "gram.y"
                                                { (yyval.lval) = 0; }
#line 1337 "gram.tab.c"
    break;

  case 19: /* frequency: DEFAULT  */
#line 203 "gram.y"
                { 
                    extern struct timeval delta; /* default logging interval */
                    (yyval.lval) = delta.tv_sec*1000 + delta.tv_usec/1000;
                }
#line 1346 "gram.tab.c"
    break;

  case 22: /* timeunits: MSEC  */
#line 213 "gram.y"
                                { (yyval.lval) = 1; }
#line 1352 "gram.tab.c"
    break;

  case 23: /* timeunits: SECOND  */
#line 214 "gram.y"
                                { (yyval.lval) = 1000; }
#line 1358 "gram.tab.c"
    break;

  case 24: /* timeunits: MINUTE  */
#line 215 "gram.y"
                                { (yyval.lval) = 60000; }
#line 1364 "gram.tab.c"
    break;

  case 25: /* timeunits: HOUR  */
#line 216 "gram.y"
                                { (yyval.lval) = 3600000; }
#line 1370 "gram.tab.c"
    break;

  case 26: /* $@1: %empty  */
#line 219 "gram.y"
                         { mystate = INSPEC; }
#line 1376 "gram.tab.c"
    break;

  case 32: /* $@2: %empty  */
#line 229 "gram.y"
                {
                    if ((metricName = strdup((yyvsp[0].str))) == NULL) {
			char emess[256];
			pmsprintf(emess, sizeof(emess), "malloc failed: %s", osstrerror());
                        yyerror(emess);
		    }
                }
#line 1388 "gram.tab.c"
    break;

  case 33: /* metricspec: NAME $@2 optinst  */
#line 237 "gram.y"
                {
		    int index, sts;
		    pmID id;

		    /*
		     * search names for previously seen metrics for this task
		     * (note that name may be non-terminal in the PMNS here);
		     * if already found in this task, skip namespace PDUs.
		     */
		    if ((index = lookup_metric_name(metricName)) < 0) {
			if (cache_lookup(metricName, NULL, NULL)) {
			    /* it is a leaf node and in the pass0 cache */
			    activate_new_metric(metricName);
			}
			else {
			    if ((sts = pmTraversePMNS(metricName, activate_new_metric)) < 0 ) {
				char emess[256];
				pmsprintf(emess, sizeof(emess),
					"Problem with lookup for metric \"%s\" "
					"... logging not activated", metricName);
				yywarn(emess);
				fprintf(stderr, "Reason: %s\n", pmErrStr(sts));
				if (sts == PM_ERR_IPC) {
				    fprintf(stderr, "Arrgh, giving up!\n");
				    exit(1);
				}
			    }

			    /*
			     * Check if metricName is a potential dynamic root. If metricName
			     * is not a leaf, then it could be a dynamic root non-leaf node,
			     * even if it currently has no children. The PMAPI says that 
			     * pmTraversePMNS(name, func) returns 1 if name is a leaf node
			     * (or a derived metric) and _also_ 1 if it's a non-leaf node with
			     * exactly one child.
			     *
			     * So metricName is a potential dynamic root if
			     * sts < 0                   : unknown name or an error
			     * sts == 0                  : childless dynamic root
			     * sts > 1                   : non-leaf with children
			     * sts == 1 and not a leaf   : non-leaf with exactly one child
			     */
			    if (sts <= 0 || sts > 1 || pmLookupName(1, (const char **)&metricName, &id) != 1) {
				/*
				 * Add it to the list for future traversal when a fetch returns
				 * with the PMCD_NAMES_CHANGE flag set.
				 */
				append_dynroot_list(metricName,
				    PMLC_GET_ON(tp->t_state) ? PM_LOG_ON : PM_LOG_MAYBE, /* TODO PMLOG_OFF? */
				    PMLC_GET_MAND(tp->t_state) ? PM_LOG_MANDATORY : PM_LOG_ADVISORY,
				    &tp->t_delta);
			    }
			}
		    }
		    else {	/* name is cached already, handle instances */
			activate_cached_metric(metricName, index);
		    }
		    freeinst(&numinst, intlist, extlist);
		    free(metricName);
		}
#line 1453 "gram.tab.c"
    break;

  case 39: /* instance: NAME  */
#line 308 "gram.y"
                                { buildinst(&numinst, &intlist, &extlist, -1, (yyvsp[0].str)); }
#line 1459 "gram.tab.c"
    break;

  case 40: /* instance: NUMBER  */
#line 309 "gram.y"
                                { buildinst(&numinst, &intlist, &extlist, (yyvsp[0].lval), NULL); }
#line 1465 "gram.tab.c"
    break;

  case 41: /* instance: STRING  */
#line 310 "gram.y"
                                { buildinst(&numinst, &intlist, &extlist, -1, (yyvsp[0].str)); }
#line 1471 "gram.tab.c"
    break;

  case 46: /* ctl: allow hostlist COLON operation SEMICOLON  */
#line 322 "gram.y"
                {
                    prevhlp = NULL;
                    for (hlp = hl_root; hlp != NULL; hlp = hlp->hl_next) {
			int sts;

                        if (prevhlp != NULL) {
                            free(prevhlp->hl_name);
                            free(prevhlp);
                        }
                        sts = __pmAccAddHost(hlp->hl_name, specmask, 
                                             opmask, 0);
                        if (sts < 0) {
                            fprintf(stderr, "error was on line %d\n", 
                                hlp->hl_line);
                            YYABORT;
                        }
                        prevhlp = hlp;
                    }
                    if (prevhlp != NULL) {
                        free(prevhlp->hl_name);
                        free(prevhlp);
                    }
                    opmask = 0;
                    specmask = 0;
                    hl_root = hl_last = NULL;
                }
#line 1502 "gram.tab.c"
    break;

  case 47: /* allow: ALLOW  */
#line 350 "gram.y"
                                        { allow = 1; }
#line 1508 "gram.tab.c"
    break;

  case 48: /* allow: DISALLOW  */
#line 351 "gram.y"
                                        { allow = 0; }
#line 1514 "gram.tab.c"
    break;

  case 51: /* host: hostspec  */
#line 359 "gram.y"
                {
		    size_t sz = sizeof(hostlist_t);

                    hlp = (hostlist_t *)malloc(sz);
                    if (hlp == NULL) {
                        pmNoMem("adding new host", sz, PM_FATAL_ERR);
                    }
                    if (hl_last != NULL) {
                        hl_last->hl_next = hlp;
                        hl_last = hlp;
                    }
                    else
                        hl_root = hl_last = hlp;
                    hlp->hl_next = NULL;
                    hlp->hl_name = strdup((yyvsp[0].str));
                    hlp->hl_line = lineno;
                }
#line 1536 "gram.tab.c"
    break;

  case 56: /* operation: operlist  */
#line 385 "gram.y"
                {
                    specmask = opmask;
                    if (allow)
                        opmask = ~opmask;
                }
#line 1546 "gram.tab.c"
    break;

  case 57: /* operation: ALL  */
#line 391 "gram.y"
                {
                    specmask = PM_OP_ALL;
                    if (allow)
                        opmask = PM_OP_NONE;
                    else
                        opmask = PM_OP_ALL;
                }
#line 1558 "gram.tab.c"
    break;

  case 58: /* operation: ALL EXCEPT operlist  */
#line 399 "gram.y"
                {
                    specmask = PM_OP_ALL;
                    if (!allow)
                        opmask = ~opmask;
                }
#line 1568 "gram.tab.c"
    break;

  case 61: /* op: ADVISORY  */
#line 410 "gram.y"
                                        { opmask |= PM_OP_LOG_ADV; }
#line 1574 "gram.tab.c"
    break;

  case 62: /* op: MANDATORY  */
#line 411 "gram.y"
                                        { opmask |= PM_OP_LOG_MAND; }
#line 1580 "gram.tab.c"
    break;

  case 63: /* op: ENQUIRE  */
#line 412 "gram.y"
                                        { opmask |= PM_OP_LOG_ENQ; }
#line 1586 "gram.tab.c"
    break;


#line 1590 "gram.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 415 "gram.y"


/*
 * Search the cache for previously seen metrics for active task.
 * Returns -1 if not found, else an index into tp->t_namelist.
 */
static int
lookup_metric_name(const char *name)
{
    int		j;

    for (j = 0; j < tp->t_numpmid; j++)
	if (strcmp(tp->t_namelist[j], name) == 0)
	    return j;
    return -1;
}

/*
 * Assumed calling context ...
 *	tp		the correct task for the requested metric
 *	numinst		number of instances associated with this request
 *	extlist[]	external instance names if numinst > 0
 *	intlist[]	internal instance identifier if numinst > 0 and
 *			corresponding extlist[] entry is NULL
 */
static void
activate_cached_metric(const char *name, int index)
{
    int		sts = 0;
    int		inst;
    int		i;
    int		j;
    int		skip = 0;
    pmID	pmid;
    pmDesc	*dp;
    optreq_t	*rqp;
    char	emess[1024];

    /*
     * need new malloc'd pmDesc, even if metric found in cache, as
     * the fetchctl keeps its own (non-realloc-movable!) pointer.
     */
    dp = (pmDesc *)malloc(sizeof(pmDesc));
    if (dp == NULL)
	goto nomem;

    if (index < 0) {
	if (cache_lookup((char *)name, &pmid, dp) == 0) {
	    /*
	     * not in the name cache, this is the "old" expensive path
	     * in terms of PDU round trips
	     */
	    if ((sts = pmLookupName(1, &name, &pmid)) < 0 || pmid == PM_ID_NULL) {
		pmsprintf(emess, sizeof(emess),
			"Metric \"%s\" is unknown ... not logged", name);
		goto snarf;
	    }
	    if ((sts = pmLookupDesc(pmid, dp)) < 0) {
		pmsprintf(emess, sizeof(emess),
			"Description unavailable for metric \"%s\" ... not logged",
			name);
		goto snarf;
	    }
	}
	/* is this a derived metric? */
	if (IS_DERIVED(pmid))
	    tp->t_dm++;

	tp->t_numpmid++;
	tp->t_namelist = (char **)realloc(tp->t_namelist, tp->t_numpmid * sizeof(char *));
	if (tp->t_namelist == NULL)
	    goto nomem;
	if ((tp->t_namelist[tp->t_numpmid-1] = strdup(name)) == NULL)
	    goto nomem;
	tp->t_pmidlist = (pmID *)realloc(tp->t_pmidlist, tp->t_numpmid * sizeof(pmID));
	if (tp->t_pmidlist == NULL)
	    goto nomem;
	tp->t_desclist = (pmDesc *)realloc(tp->t_desclist, tp->t_numpmid * sizeof(pmDesc));
	if (tp->t_desclist == NULL)
	    goto nomem;
	tp->t_pmidlist[tp->t_numpmid-1] = pmid;
	tp->t_desclist[tp->t_numpmid-1] = *dp;	/* struct assignment */
    }
    else {
	*dp = tp->t_desclist[index];
	pmid = tp->t_pmidlist[index];
    }

    rqp = (optreq_t *)calloc(1, sizeof(optreq_t));
    if (rqp == NULL)
	goto nomem;
    rqp->r_desc = dp;
    rqp->r_numinst = numinst;

    if (numinst) {
	/*
	 * malloc here, and keep ... gets buried in optFetch data structures
	 */
	rqp->r_instlist = (int *)malloc(numinst * sizeof(rqp->r_instlist[0]));
	if (rqp->r_instlist == NULL)
	    goto nomem;
	j = 0;
	for (i = 0; i < numinst; i++) {
	    if (extlist[i] != NULL) {
		sts = pmLookupInDom(dp->indom, extlist[i]);
		if (sts < 0) {
                    pmsprintf(emess, sizeof(emess),
			"Instance \"%s\" is not defined for the metric \"%s\"",
			extlist[i], name);
                    yywarn(emess);
		    rqp->r_numinst--;
		    continue;
		}
		inst = sts;
	    }
	    else {
		char	*p;
		sts = pmNameInDom(dp->indom, intlist[i], &p);
		if (sts < 0) {
                    pmsprintf(emess, sizeof(emess),
			"Instance \"%d\" is not defined for the metric \"%s\"",
			intlist[i], name);
                    yywarn(emess);
		    rqp->r_numinst--;
		    continue;
		}
		free(p);
		inst = intlist[i];
	    }
	    if ((sts = chk_one(tp, pmid, inst)) < 0) {
                pmsprintf(emess, sizeof(emess),
			"Incompatible request for metric \"%s\" "
			"and instance \"%s\"", name, extlist[i]);
                yywarn(emess);
                fprintf(stderr, "%s\n", chk_emess[-sts]);
                rqp->r_numinst--;
	    }
	    else if (sts == 0)
		rqp->r_instlist[j++] = inst;
	    else	/* already have this instance */
		rqp->r_numinst--;
	}
	if (rqp->r_numinst == 0)
	    skip = 1;
    }
    else {
	if ((sts = chk_all(tp, pmid)) < 0) {
            pmsprintf(emess, sizeof(emess),
		    "Incompatible request for metric \"%s\"", name);
            yywarn(emess);

	    skip = 1;
	}
	else if (sts == 1)
	    skip = 1;
    }

    if (!skip) {
	__pmOptFetchAdd(&tp->t_fetch, rqp);
	linkback(tp);
	if (pmDebugOptions.optfetch && pmDebugOptions.desperate) {
	    fprintf(stderr, "Task " PRINTF_P_PFX "%p -> t_fetch ...\n", tp);
	    __pmOptFetchDump(stderr, tp->t_fetch);
	}
	if ((sts = __pmHashAdd(pmid, (void *)rqp, &pm_hash)) < 0) {
	    pmsprintf(emess, sizeof(emess), "__pmHashAdd failed "
		    "for metric \"%s\" ... logging not activated", name);
	    goto snarf;
	}
	tp->t_numvalid++;
    }
    else {
	free(dp);
	if (rqp->r_instlist != NULL)
	    free(rqp->r_instlist);
	free(rqp);
    }
    return;

nomem:
    pmsprintf(emess, sizeof(emess), "malloc failed: %s", osstrerror());
    yyerror(emess);

snarf:
    yywarn(emess);
    fprintf(stderr, "Reason: %s\n", pmErrStr(sts));
    if (sts == PM_ERR_IPC) {
	fprintf(stderr, "Arrgh: lost connection to pmcd, giving up!\n");
	exit(1);
    }
    if (dp != NULL)
        free(dp);
    return;
}

static void
activate_new_metric(const char *name)
{
    activate_cached_metric(name, lookup_metric_name(name));
}

/*
 * Given a logging state and an interval, return a matching task
 * or NULL if none exists for that value pair.
 */
task_t *
findtask(int arg_state, struct timeval *arg_delta)
{
    task_t	*ltp;

    for (ltp = tasklist; ltp != NULL; ltp = ltp->t_next) {
	if (arg_state == ltp->t_state &&
	    arg_delta->tv_sec == ltp->t_delta.tv_sec &&
	    arg_delta->tv_usec == ltp->t_delta.tv_usec)
	    break;
    }
    return ltp;
}

/*
 * Append 'name' to the list of non-leaf PMNS nodes to be traversed for
 * new metrics when a fetch returns with the PMCD_NAMES_CHANGE flag set.
 * Note: 'name' is not a PMNS leaf and may or may not be a non-leaf,
 * since it may appear dynamically in the future. This list is traversed
 * by check_dynamic_metrics() when a fetch returns with the PMCD_NAMES_CHANGE
 * flag set.
 */
static void
append_dynroot_list(const char *name, int arg_state, int control, struct timeval *timedelta)
{
    int i;
    dynroot_t *d;

    for (i=0, d=dyn_roots; i < n_dyn_roots; i++, d++) {
	if (strcmp(d->name, name) == 0)
	    return; /* already present, don't add it again */
    }
    if ((dyn_roots = (dynroot_t *)realloc(dyn_roots, ++n_dyn_roots * sizeof(dynroot_t))) == NULL)
	pmNoMem("extending dyn_roots list", n_dyn_roots * sizeof(dynroot_t), PM_FATAL_ERR);
    d = &dyn_roots[n_dyn_roots-1];
    if ((d->name = strdup(name)) == NULL)
	pmNoMem("strdup name in dyn_roots list", strlen(name) + 1, PM_FATAL_ERR);
    d->state = arg_state;
    d->control = control;
    d->delta = *timedelta;

    if (pmDebugOptions.log) {
	fprintf(stderr, "pmlogger: possible dynamic root \"%s\", state=0x%x, control=0x%x, delta=%ld.%06ld\n",
	    name, arg_state, control, (long)timedelta->tv_sec, (long)timedelta->tv_usec);
    }
}

/*
 * Complete the delayed processing of task elements, which can only
 * be done once all configuration file parsing is complete.
 */
void
yyend(void)
{
    /*
     * The value of blink is chosen to ensure the tasks that require
     * repeated scheduling are not all done with the "log once" tasks.
     * In onlalarm() in the AF.c code of libpcp, there is a 10msec
     * window in which any task that is scheduled for within 10msec
     * of the time that the alarm goes off will be run, and we need
     * to go outside this window, hence blink is 20msec.
     */
    struct timeval blink = { 0, 20000 };
    /*
     * First pass to initialize and do the "log once" tasks.
     * We want the "log once" cases to come first in the
     * archive so that things like the hinv.* metrics are defined
     * _before_ any of the useful data, otherwise the first useful
     * data sample will be wasted, e.g. if hinv.ncpu does not
     * (yet) have a value in the archive.
     */
    for (tp = tasklist; tp != NULL; tp = tp->t_next) {
	if (tp->t_numvalid == 0)
	    continue;
	PMLC_SET_MAYBE(tp->t_state, 0);	/* clear req */
	if (PMLC_GET_ON(tp->t_state) && (tp->t_delta.tv_sec == 0 && tp->t_delta.tv_usec == 0)) {
	    tp->t_afid = __pmAFregister(&tp->t_delta, (void *)tp, log_callback);
	}
    }
    /* Second pass for the other tasks */
    for (tp = tasklist; tp != NULL; tp = tp->t_next) {
	if (tp->t_numvalid == 0)
	    continue;
	if (PMLC_GET_ON(tp->t_state) && (tp->t_delta.tv_sec != 0 || tp->t_delta.tv_usec != 0)) {
	    /*
	     * log as soon as possible and then every t_delta units of
	     * time thereafter
	     */
	    tp->t_afid = __pmAFsetup(&blink, &tp->t_delta, (void *)tp, log_callback);
	}
    }
}
