#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkImageDivergence_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageDotProduct_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageLogarithmicScale_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageLogic_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageMagnitude_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageMaskBits_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageMathematics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageWeightedSum_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkImagingMathCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkImageDivergence_Init(csi);
  vtkImageDotProduct_Init(csi);
  vtkImageLogarithmicScale_Init(csi);
  vtkImageLogic_Init(csi);
  vtkImageMagnitude_Init(csi);
  vtkImageMaskBits_Init(csi);
  vtkImageMathematics_Init(csi);
  vtkImageWeightedSum_Init(csi);
}
