// python wrapper for vtkPVDataSetAlgorithmSelectorFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVDataSetAlgorithmSelectorFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVDataSetAlgorithmSelectorFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVDataSetAlgorithmSelectorFilter_ClassNew(); }


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVDataSetAlgorithmSelectorFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVDataSetAlgorithmSelectorFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVDataSetAlgorithmSelectorFilter *tempr = vtkPVDataSetAlgorithmSelectorFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataSetAlgorithmSelectorFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVDataSetAlgorithmSelectorFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVDataSetAlgorithmSelectorFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVDataSetAlgorithmSelectorFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_RegisterFilter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterFilter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    int tempr = (ap.IsBound() ?
      op->RegisterFilter(temp0) :
      op->vtkPVDataSetAlgorithmSelectorFilter::RegisterFilter(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_UnRegisterFilter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnRegisterFilter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UnRegisterFilter(temp0);
    }
    else
    {
      op->vtkPVDataSetAlgorithmSelectorFilter::UnRegisterFilter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_ClearFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearFilters();
    }
    else
    {
      op->vtkPVDataSetAlgorithmSelectorFilter::ClearFilters();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_GetNumberOfFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfFilters() :
      op->vtkPVDataSetAlgorithmSelectorFilter::GetNumberOfFilters());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_GetFilter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFilter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetFilter(temp0) :
      op->vtkPVDataSetAlgorithmSelectorFilter::GetFilter(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_GetActiveFilter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveFilter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetActiveFilter() :
      op->vtkPVDataSetAlgorithmSelectorFilter::GetActiveFilter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_SetActiveFilter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveFilter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->SetActiveFilter(temp0) :
      op->vtkPVDataSetAlgorithmSelectorFilter::SetActiveFilter(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkPVDataSetAlgorithmSelectorFilter::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataSetAlgorithmSelectorFilter_ProcessRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataSetAlgorithmSelectorFilter *op = static_cast<vtkPVDataSetAlgorithmSelectorFilter *>(vp);

  vtkInformation *temp0 = nullptr;
  vtkCollection *temp1 = nullptr;
  vtkInformationVector *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkInformationVector"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessRequest(temp0, temp1, temp2) :
      op->vtkPVDataSetAlgorithmSelectorFilter::ProcessRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataSetAlgorithmSelectorFilter_Methods[] = {
  {"IsTypeOf", PyvtkPVDataSetAlgorithmSelectorFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVDataSetAlgorithmSelectorFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVDataSetAlgorithmSelectorFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkPVDataSetAlgorithmSelectorFilter\nC++: static vtkPVDataSetAlgorithmSelectorFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVDataSetAlgorithmSelectorFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVDataSetAlgorithmSelectorFilter\nC++: vtkPVDataSetAlgorithmSelectorFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVDataSetAlgorithmSelectorFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVDataSetAlgorithmSelectorFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"RegisterFilter", PyvtkPVDataSetAlgorithmSelectorFilter_RegisterFilter, METH_VARARGS,
   "RegisterFilter(self, filter:vtkAlgorithm) -> int\nC++: int RegisterFilter(vtkAlgorithm *filter)\n\nRegister a new filter that can be used underneath in the\nrequestData call. The return value is the index of that\nregistered filter that should be use to activate it later on.\n(This number can became wrong in case you remove some previous\nregistered filter)\n"},
  {"UnRegisterFilter", PyvtkPVDataSetAlgorithmSelectorFilter_UnRegisterFilter, METH_VARARGS,
   "UnRegisterFilter(self, index:int) -> None\nC++: void UnRegisterFilter(int index)\n\nUnRegister an existing filter that was previously registered\n"},
  {"ClearFilters", PyvtkPVDataSetAlgorithmSelectorFilter_ClearFilters, METH_VARARGS,
   "ClearFilters(self) -> None\nC++: void ClearFilters()\n\nRemove all the registered filters.\n"},
  {"GetNumberOfFilters", PyvtkPVDataSetAlgorithmSelectorFilter_GetNumberOfFilters, METH_VARARGS,
   "GetNumberOfFilters(self) -> int\nC++: int GetNumberOfFilters()\n\nReturn the current number of registered filters\n"},
  {"GetFilter", PyvtkPVDataSetAlgorithmSelectorFilter_GetFilter, METH_VARARGS,
   "GetFilter(self, index:int) -> vtkAlgorithm\nC++: vtkAlgorithm *GetFilter(int index)\n\nReturn the filter that lies at the given index of the filters\nregistration queue.\n"},
  {"GetActiveFilter", PyvtkPVDataSetAlgorithmSelectorFilter_GetActiveFilter, METH_VARARGS,
   "GetActiveFilter(self) -> vtkAlgorithm\nC++: vtkAlgorithm *GetActiveFilter()\n\nReturn the current active filter if any otherwise return nullptr\n"},
  {"SetActiveFilter", PyvtkPVDataSetAlgorithmSelectorFilter_SetActiveFilter, METH_VARARGS,
   "SetActiveFilter(self, index:int) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *SetActiveFilter(int index)\n\nSet the active filter based on the given index of the filters\nregistration queue. And return the corresponding active filter.\n"},
  {"GetMTime", PyvtkPVDataSetAlgorithmSelectorFilter_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverride GetMTime because we delegate to other filters to do the\nreal work\n"},
  {"ProcessRequest", PyvtkPVDataSetAlgorithmSelectorFilter_ProcessRequest, METH_VARARGS,
   "ProcessRequest(self, request:vtkInformation, inInfo:vtkCollection,\n     outInfo:vtkInformationVector) -> int\nC++: virtual int ProcessRequest(vtkInformation *request,\n    vtkCollection *inInfo, vtkInformationVector *outInfo)\n\nForward those methods to the underneath filters\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVDataSetAlgorithmSelectorFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("active_filter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataSetAlgorithmSelectorFilter_GetActiveFilter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveFilter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataSetAlgorithmSelectorFilter_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVDataSetAlgorithmSelectorFilter_Doc =
  "vtkPVDataSetAlgorithmSelectorFilter - is a generic vtkAlgorithm that\nallow the user to register several vtkAlgorithm to it and be able to\nswitch the active one on the fly.\n\n"
  "Superclass: vtkAlgorithm\n\n"
  "The idea behind that filter is to merge the usage of any number of\n"
  "existing vtk filter and allow to easily switch from one\n"
  "implementation to another without changing anything in your pipeline.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVDataSetAlgorithmSelectorFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkPVDataSetAlgorithmSelectorFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVDataSetAlgorithmSelectorFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVDataSetAlgorithmSelectorFilter_StaticNew()
{
  return vtkPVDataSetAlgorithmSelectorFilter::New();
}

PyObject *PyvtkPVDataSetAlgorithmSelectorFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVDataSetAlgorithmSelectorFilter_Type, PyvtkPVDataSetAlgorithmSelectorFilter_Methods,
    "vtkPVDataSetAlgorithmSelectorFilter",
 &PyvtkPVDataSetAlgorithmSelectorFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVDataSetAlgorithmSelectorFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVDataSetAlgorithmSelectorFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVDataSetAlgorithmSelectorFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVDataSetAlgorithmSelectorFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

