// python wrapper for vtkImageSimpleSource
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkImageSimpleSource.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkImageSimpleSource(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkImageSimpleSource_ClassNew(); }


static PyObject *
PyvtkImageSimpleSource_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkImageSimpleSource::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkImageSimpleSource::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkImageSimpleSource *tempr = vtkImageSimpleSource::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageSimpleSource *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkImageSimpleSource::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkImageSimpleSource::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkImageSimpleSource::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_GetWholeExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWholeExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetWholeExtent() :
      op->vtkImageSimpleSource::GetWholeExtent());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_SetWholeExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWholeExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  int temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetWholeExtent(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkImageSimpleSource::SetWholeExtent(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_GetEnableDistanceSquaredData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableDistanceSquaredData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableDistanceSquaredData() :
      op->vtkImageSimpleSource::GetEnableDistanceSquaredData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_SetEnableDistanceSquaredData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableDistanceSquaredData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableDistanceSquaredData(temp0);
    }
    else
    {
      op->vtkImageSimpleSource::SetEnableDistanceSquaredData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_EnableDistanceSquaredDataOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableDistanceSquaredDataOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableDistanceSquaredDataOn();
    }
    else
    {
      op->vtkImageSimpleSource::EnableDistanceSquaredDataOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_EnableDistanceSquaredDataOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableDistanceSquaredDataOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableDistanceSquaredDataOff();
    }
    else
    {
      op->vtkImageSimpleSource::EnableDistanceSquaredDataOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_GetEnableSwirlData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableSwirlData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableSwirlData() :
      op->vtkImageSimpleSource::GetEnableSwirlData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_SetEnableSwirlData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableSwirlData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableSwirlData(temp0);
    }
    else
    {
      op->vtkImageSimpleSource::SetEnableSwirlData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_EnableSwirlDataOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableSwirlDataOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableSwirlDataOn();
    }
    else
    {
      op->vtkImageSimpleSource::EnableSwirlDataOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageSimpleSource_EnableSwirlDataOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableSwirlDataOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageSimpleSource *op = static_cast<vtkImageSimpleSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableSwirlDataOff();
    }
    else
    {
      op->vtkImageSimpleSource::EnableSwirlDataOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkImageSimpleSource_Methods[] = {
  {"IsTypeOf", PyvtkImageSimpleSource_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkImageSimpleSource_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkImageSimpleSource_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkImageSimpleSource\nC++: static vtkImageSimpleSource *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkImageSimpleSource_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkImageSimpleSource\nC++: vtkImageSimpleSource *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkImageSimpleSource_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkImageSimpleSource_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetWholeExtent", PyvtkImageSimpleSource_GetWholeExtent, METH_VARARGS,
   "GetWholeExtent(self) -> (int, int, int, int, int, int)\nC++: virtual int *GetWholeExtent()\n\nSet/Get the extent of the whole output image.\n"},
  {"SetWholeExtent", PyvtkImageSimpleSource_SetWholeExtent, METH_VARARGS,
   "SetWholeExtent(self, xMinx:int, xMax:int, yMin:int, yMax:int,\n    zMin:int, zMax:int) -> None\nC++: void SetWholeExtent(int xMinx, int xMax, int yMin, int yMax,\n    int zMin, int zMax)\n\n"},
  {"GetEnableDistanceSquaredData", PyvtkImageSimpleSource_GetEnableDistanceSquaredData, METH_VARARGS,
   "GetEnableDistanceSquaredData(self) -> bool\nC++: virtual bool GetEnableDistanceSquaredData()\n\nEnable/Disable DistanceSquared data array.\n"},
  {"SetEnableDistanceSquaredData", PyvtkImageSimpleSource_SetEnableDistanceSquaredData, METH_VARARGS,
   "SetEnableDistanceSquaredData(self, _arg:bool) -> None\nC++: virtual void SetEnableDistanceSquaredData(bool _arg)\n\n"},
  {"EnableDistanceSquaredDataOn", PyvtkImageSimpleSource_EnableDistanceSquaredDataOn, METH_VARARGS,
   "EnableDistanceSquaredDataOn(self) -> None\nC++: virtual void EnableDistanceSquaredDataOn()\n\n"},
  {"EnableDistanceSquaredDataOff", PyvtkImageSimpleSource_EnableDistanceSquaredDataOff, METH_VARARGS,
   "EnableDistanceSquaredDataOff(self) -> None\nC++: virtual void EnableDistanceSquaredDataOff()\n\n"},
  {"GetEnableSwirlData", PyvtkImageSimpleSource_GetEnableSwirlData, METH_VARARGS,
   "GetEnableSwirlData(self) -> bool\nC++: virtual bool GetEnableSwirlData()\n\nEnable/Disable Swirl data array.\n"},
  {"SetEnableSwirlData", PyvtkImageSimpleSource_SetEnableSwirlData, METH_VARARGS,
   "SetEnableSwirlData(self, _arg:bool) -> None\nC++: virtual void SetEnableSwirlData(bool _arg)\n\n"},
  {"EnableSwirlDataOn", PyvtkImageSimpleSource_EnableSwirlDataOn, METH_VARARGS,
   "EnableSwirlDataOn(self) -> None\nC++: virtual void EnableSwirlDataOn()\n\n"},
  {"EnableSwirlDataOff", PyvtkImageSimpleSource_EnableSwirlDataOff, METH_VARARGS,
   "EnableSwirlDataOff(self) -> None\nC++: virtual void EnableSwirlDataOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkImageSimpleSource_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("whole_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkImageSimpleSource_GetWholeExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageSimpleSource_SetWholeExtent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageSimpleSource_SetWholeExtent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWholeExtent/SetWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_distance_squared_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkImageSimpleSource_GetEnableDistanceSquaredData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageSimpleSource_SetEnableDistanceSquaredData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageSimpleSource_SetEnableDistanceSquaredData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableDistanceSquaredData/SetEnableDistanceSquaredData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_swirl_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkImageSimpleSource_GetEnableSwirlData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageSimpleSource_SetEnableSwirlData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageSimpleSource_SetEnableSwirlData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableSwirlData/SetEnableSwirlData\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkImageSimpleSource_Doc =
  "vtkImageSimpleSource - Create a 3-D image with simple-to-compute\npixel values.\n\n"
  "Superclass: vtkThreadedImageAlgorithm\n\n"
  "vtkImageSimpleSource produces images with pixel values that can be\n"
  "obtained with relatively low computational load. The output point\n"
  "data contains 1-3 arrays:\n"
  "- \"X\": A scalar double array labeled \"X\" is always generated. Its\n"
  "  values are set to the X coordinate at each point.\n"
  "- \"DistanceSquared\": A scalar double array labeled \"DistanceSquared\"\n"
  "  is generated by default, but can be omitted by setting\n"
  "  EnableDistanceSquaredData false. The values are set to the\n"
  "  Euclidean distance of each point from the origin (X*X + Y*Y + Z*Z).\n"
  "- \"Swirl\": A vector double array labeled \"Swirl\" is generated by\n"
  "  default, but can be omitted by setting EnableSwirlData false. The\n"
  "  values at each point are set to the <Y, Z, X> coordinates.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkImageSimpleSource_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkImageSimpleSource", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkImageSimpleSource_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkImageSimpleSource_StaticNew()
{
  return vtkImageSimpleSource::New();
}

PyObject *PyvtkImageSimpleSource_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkImageSimpleSource_Type, PyvtkImageSimpleSource_Methods,
    "vtkImageSimpleSource",
 &PyvtkImageSimpleSource_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkThreadedImageAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkImageSimpleSource_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkImageSimpleSource(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkImageSimpleSource_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkImageSimpleSource", o) != 0)
  {
    Py_DECREF(o);
  }

}

