/* Window.c generated by valac 0.56.17, the Vala compiler
 * generated from Window.vala, do not modify */

/*-
 * Copyright (c) 2013-2019 elementary Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Tom Beckmann <tomjonabc@gmail.com>
 *              Cody Garver <cody@elementaryos.org>
 *              Artem Anufrij <artem.anufrij@live.de>
 *              Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <adwaita.h>
#include <granite-7.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define AUDIENCE_WINDOW_ACTION_GROUP_PREFIX "win"
#define AUDIENCE_WINDOW_ACTION_PREFIX AUDIENCE_WINDOW_ACTION_GROUP_PREFIX "."
#define AUDIENCE_WINDOW_ACTION_BACK "back"
#define AUDIENCE_WINDOW_ACTION_FULLSCREEN "action-fullscreen"
#define AUDIENCE_WINDOW_ACTION_OPEN_FILE "action-open-file"
#define AUDIENCE_WINDOW_ACTION_QUIT "action-quit"
#define AUDIENCE_WINDOW_ACTION_SEARCH "action-search"
#define AUDIENCE_WINDOW_ACTION_UNDO "action-undo"
#define AUDIENCE_APP_ACTION_PLAY_PAUSE "action-play-pause"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;
typedef struct _AudienceWindowPrivate AudienceWindowPrivate;

#define AUDIENCE_TYPE_EPISODES_PAGE (audience_episodes_page_get_type ())
#define AUDIENCE_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage))
#define AUDIENCE_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))
#define AUDIENCE_IS_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_IS_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_EPISODES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))

typedef struct _AudienceEpisodesPage AudienceEpisodesPage;
typedef struct _AudienceEpisodesPageClass AudienceEpisodesPageClass;

#define AUDIENCE_TYPE_LIBRARY_PAGE (audience_library_page_get_type ())
#define AUDIENCE_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage))
#define AUDIENCE_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))
#define AUDIENCE_IS_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_IS_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_LIBRARY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))

typedef struct _AudienceLibraryPage AudienceLibraryPage;
typedef struct _AudienceLibraryPageClass AudienceLibraryPageClass;

#define AUDIENCE_TYPE_PLAYER_PAGE (audience_player_page_get_type ())
#define AUDIENCE_PLAYER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYER_PAGE, AudiencePlayerPage))
#define AUDIENCE_PLAYER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYER_PAGE, AudiencePlayerPageClass))
#define AUDIENCE_IS_PLAYER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYER_PAGE))
#define AUDIENCE_IS_PLAYER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYER_PAGE))
#define AUDIENCE_PLAYER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYER_PAGE, AudiencePlayerPageClass))

typedef struct _AudiencePlayerPage AudiencePlayerPage;
typedef struct _AudiencePlayerPageClass AudiencePlayerPageClass;

#define AUDIENCE_TYPE_WELCOME_PAGE (audience_welcome_page_get_type ())
#define AUDIENCE_WELCOME_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WELCOME_PAGE, AudienceWelcomePage))
#define AUDIENCE_WELCOME_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WELCOME_PAGE, AudienceWelcomePageClass))
#define AUDIENCE_IS_WELCOME_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WELCOME_PAGE))
#define AUDIENCE_IS_WELCOME_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WELCOME_PAGE))
#define AUDIENCE_WELCOME_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WELCOME_PAGE, AudienceWelcomePageClass))

typedef struct _AudienceWelcomePage AudienceWelcomePage;
typedef struct _AudienceWelcomePageClass AudienceWelcomePageClass;
enum  {
	AUDIENCE_WINDOW_0_PROPERTY,
	AUDIENCE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* audience_window_properties[AUDIENCE_WINDOW_NUM_PROPERTIES];
typedef enum  {
	AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES
} AudienceWindowNavigationPage;

#define AUDIENCE_WINDOW_TYPE_NAVIGATION_PAGE (audience_window_navigation_page_get_type ())
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;
typedef struct _Block2Data Block2Data;
typedef void (*AudienceFuncOverDir) (GFile* file_under_dir, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block4Data Block4Data;

#define AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM (audience_objects_media_item_get_type ())
#define AUDIENCE_OBJECTS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))

typedef struct _AudienceObjectsMediaItem AudienceObjectsMediaItem;
typedef struct _AudienceObjectsMediaItemClass AudienceObjectsMediaItemClass;
enum  {
	AUDIENCE_WINDOW_MEDIA_VOLUMES_CHANGED_SIGNAL,
	AUDIENCE_WINDOW_NUM_SIGNALS
};
static guint audience_window_signals[AUDIENCE_WINDOW_NUM_SIGNALS] = {0};

struct _AudienceWindow {
	GtkApplicationWindow parent_instance;
	AudienceWindowPrivate * priv;
};

struct _AudienceWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _AudienceWindowPrivate {
	AdwNavigationView* navigation_view;
	GraniteToast* app_notification;
	AudienceEpisodesPage* episodes_page;
	AudienceLibraryPage* library_page;
	AudiencePlayerPage* player_page;
	AudienceWelcomePage* welcome_page;
};

struct _Block2Data {
	int _ref_count_;
	AudienceWindow* self;
	gchar** videos;
	gint videos_length1;
	gint _videos_size_;
};

struct _Block3Data {
	int _ref_count_;
	AudienceWindow* self;
	GtkFileChooserNative* file;
	gboolean clear_playlist;
	gboolean force_play;
};

struct _Block4Data {
	int _ref_count_;
	AudienceWindow* self;
	AudiencePlaybackManager* playback_manager;
};

static gint AudienceWindow_private_offset;
static gpointer audience_window_parent_class = NULL;
static GeeMultiMap* audience_window_action_accelerators;
static GeeMultiMap* audience_window_action_accelerators = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
VALA_EXTERN GType audience_episodes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceEpisodesPage, g_object_unref)
VALA_EXTERN GType audience_library_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryPage, g_object_unref)
VALA_EXTERN GType audience_player_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlayerPage, g_object_unref)
VALA_EXTERN GType audience_welcome_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWelcomePage, g_object_unref)
VALA_EXTERN GType audience_window_navigation_page_get_type (void) G_GNUC_CONST ;
static void audience_window_action_back (AudienceWindow* self);
static void _audience_window_action_back_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void audience_window_action_fullscreen (AudienceWindow* self);
static void _audience_window_action_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void audience_window_action_open_file (AudienceWindow* self);
static void _audience_window_action_open_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void audience_window_action_quit (AudienceWindow* self);
static void _audience_window_action_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void audience_window_action_search (AudienceWindow* self);
static void _audience_window_action_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void audience_window_action_undo (AudienceWindow* self);
static void _audience_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
VALA_EXTERN void audience_window_run_open_file (AudienceWindow* self,
                                    gboolean clear_playlist,
                                    gboolean force_play);
VALA_EXTERN void audience_library_page_search (AudienceLibraryPage* self);
VALA_EXTERN void audience_episodes_page_search (AudienceEpisodesPage* self);
VALA_EXTERN gboolean audience_is_sandboxed (void);
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
VALA_EXTERN void audience_services_library_manager_undo_delete_item (AudienceServicesLibraryManager* self);
VALA_EXTERN gboolean audience_window_match_keycode (AudienceWindow* self,
                                        guint keyval,
                                        guint code);
VALA_EXTERN void audience_window_handle_key_press (AudienceWindow* self,
                                       guint keyval,
                                       guint keycode,
                                       GdkModifierType state);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN void audience_player_page_seek_jump_seconds (AudiencePlayerPage* self,
                                             gint seconds);
VALA_EXTERN void audience_window_resume_last_videos (AudienceWindow* self);
VALA_EXTERN void audience_window_show_library (AudienceWindow* self);
VALA_EXTERN void audience_window_open_files (AudienceWindow* self,
                                 GFile** files,
                                 gint files_length1,
                                 gboolean clear_playlist_items,
                                 gboolean force_play);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN void audience_playback_manager_clear_playlist (AudiencePlaybackManager* self,
                                               gboolean should_stop);
VALA_EXTERN void audience_recurse_over_dir (GFile* file_to_process,
                                AudienceFuncOverDir func,
                                gpointer func_target);
static void _____lambda27_ (Block2Data* _data2_,
                     GFile* file_ret);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ______lambda27__audience_func_over_dir (GFile* file_under_dir,
                                             gpointer self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                                   gchar** uris,
                                                   gint uris_length1);
VALA_EXTERN AudienceWindowNavigationPage audience_library_page_prepare_to_play (AudienceLibraryPage* self,
                                                                    const gchar* file);
VALA_EXTERN void audience_window_play_file (AudienceWindow* self,
                                const gchar* uri,
                                AudienceWindowNavigationPage origin,
                                gboolean from_beginning);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda26_ (Block3Data* _data3_,
                  gint response);
static void _vala_array_add3 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void ___lambda26__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void audience_window_on_player_ended (AudienceWindow* self);
VALA_EXTERN void audience_playback_manager_play_file (AudiencePlaybackManager* self,
                                          const gchar* uri,
                                          gboolean from_beginning);
static void audience_window_update_navigation (AudienceWindow* self);
VALA_EXTERN gint64 audience_playback_manager_get_position (AudiencePlaybackManager* self);
static GVariant* _variant_new3 (gboolean value);
static GVariant* _variant_new4 (gboolean value);
VALA_EXTERN AudienceWindow* audience_window_new (void);
VALA_EXTERN AudienceWindow* audience_window_construct (GType object_type);
static GObject * audience_window_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN AudienceLibraryPage* audience_library_page_get_instance (void);
VALA_EXTERN AudienceWelcomePage* audience_welcome_page_new (void);
VALA_EXTERN AudienceWelcomePage* audience_welcome_page_construct (GType object_type);
VALA_EXTERN AudiencePlayerPage* audience_player_page_new (void);
VALA_EXTERN AudiencePlayerPage* audience_player_page_construct (GType object_type);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_new (void);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_construct (GType object_type);
VALA_EXTERN GType audience_objects_media_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsMediaItem, g_object_unref)
static void _audience_window___lambda72_ (AudienceWindow* self,
                                   AudienceObjectsMediaItem* item);
VALA_EXTERN const gchar* audience_objects_media_item_get_title (AudienceObjectsMediaItem* self);
static void _audience_window_action_undo_granite_toast_default_action (GraniteToast* _sender,
                                                                gpointer self);
static void __audience_window___lambda72__audience_services_library_manager_media_item_trashed (AudienceServicesLibraryManager* _sender,
                                                                                         AudienceObjectsMediaItem* item,
                                                                                         gpointer self);
static void _audience_window___lambda73_ (AudienceWindow* self,
                                   AudienceObjectsMediaItem* item,
                                   gboolean setup_only);
VALA_EXTERN void audience_episodes_page_set_show (AudienceEpisodesPage* self,
                                      AudienceObjectsMediaItem* item);
static void __audience_window___lambda73__audience_library_page_show_episodes (AudienceLibraryPage* _sender,
                                                                        AudienceObjectsMediaItem* item,
                                                                        gboolean setup_only,
                                                                        gpointer self);
static void _audience_window___lambda74_ (AudienceWindow* self);
static void __audience_window___lambda74__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
VALA_EXTERN GtkStringList* audience_playback_manager_get_play_queue (AudiencePlaybackManager* self);
static void _audience_window___lambda75_ (Block4Data* _data4_,
                                   guint pos,
                                   guint removed,
                                   guint added);
VALA_EXTERN gchar* audience_get_title (const gchar* filename);
static void __audience_window___lambda75__g_list_model_items_changed (GListModel* _sender,
                                                               guint position,
                                                               guint removed,
                                                               guint added,
                                                               gpointer self);
static void _audience_window_on_player_ended_audience_playback_manager_ended (AudiencePlaybackManager* _sender,
                                                                       gpointer self);
static void _audience_window_handle_key_press_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                              guint keyval,
                                                                              guint keycode,
                                                                              GdkModifierType state,
                                                                              gpointer self);
static gboolean _audience_window___lambda76_ (AudienceWindow* self,
                                       GValue* val);
static void _vala_array_add4 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static gboolean __audience_window___lambda76__gtk_drop_target_drop (GtkDropTarget* _sender,
                                                             GValue* value,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self);
static void audience_window_finalize (GObject * obj);
static GType audience_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry AUDIENCE_WINDOW_ACTION_ENTRIES[6] = {{AUDIENCE_WINDOW_ACTION_BACK, _audience_window_action_back_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_FULLSCREEN, _audience_window_action_fullscreen_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_OPEN_FILE, _audience_window_action_open_file_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_QUIT, _audience_window_action_quit_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_SEARCH, _audience_window_action_search_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_UNDO, _audience_window_action_undo_gsimple_action_activate_callback}};

static inline gpointer
audience_window_get_instance_private (AudienceWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceWindow_private_offset);
}

static GType
audience_window_navigation_page_get_type_once (void)
{
	static const GEnumValue values[] = {{AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME, "AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME", "welcome"}, {AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY, "AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY", "library"}, {AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES, "AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES", "episodes"}, {0, NULL, NULL}};
	GType audience_window_navigation_page_type_id;
	audience_window_navigation_page_type_id = g_enum_register_static ("AudienceWindowNavigationPage", values);
	return audience_window_navigation_page_type_id;
}

GType
audience_window_navigation_page_get_type (void)
{
	static volatile gsize audience_window_navigation_page_type_id__once = 0;
	if (g_once_init_enter (&audience_window_navigation_page_type_id__once)) {
		GType audience_window_navigation_page_type_id;
		audience_window_navigation_page_type_id = audience_window_navigation_page_get_type_once ();
		g_once_init_leave (&audience_window_navigation_page_type_id__once, audience_window_navigation_page_type_id);
	}
	return audience_window_navigation_page_type_id__once;
}

static void
_audience_window_action_back_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	audience_window_action_back ((AudienceWindow*) self);
}

static void
_audience_window_action_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	audience_window_action_fullscreen ((AudienceWindow*) self);
}

static void
_audience_window_action_open_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	audience_window_action_open_file ((AudienceWindow*) self);
}

static void
_audience_window_action_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	audience_window_action_quit ((AudienceWindow*) self);
}

static void
_audience_window_action_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	audience_window_action_search ((AudienceWindow*) self);
}

static void
_audience_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	audience_window_action_undo ((AudienceWindow*) self);
}

static void
audience_window_action_back (AudienceWindow* self)
{
	AdwNavigationView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	adw_navigation_view_pop (_tmp0_);
}

static void
audience_window_action_fullscreen (AudienceWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_object_get ((GtkWindow*) self, "fullscreened", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gtk_window_unfullscreen ((GtkWindow*) self);
	} else {
		gtk_window_fullscreen ((GtkWindow*) self);
	}
}

static void
audience_window_action_open_file (AudienceWindow* self)
{
	g_return_if_fail (self != NULL);
	audience_window_run_open_file (self, FALSE, TRUE);
}

static void
audience_window_action_quit (AudienceWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_window_destroy ((GtkWindow*) self);
}

static void
audience_window_action_search (AudienceWindow* self)
{
	AdwNavigationView* _tmp0_;
	AdwNavigationPage* _tmp1_;
	AdwNavigationPage* _tmp2_;
	AudienceLibraryPage* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	_tmp1_ = adw_navigation_view_get_visible_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->library_page;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, adw_navigation_page_get_type (), AdwNavigationPage)) {
		AudienceLibraryPage* _tmp4_;
		_tmp4_ = self->priv->library_page;
		audience_library_page_search (_tmp4_);
	} else {
		AdwNavigationView* _tmp5_;
		AdwNavigationPage* _tmp6_;
		AdwNavigationPage* _tmp7_;
		AudienceEpisodesPage* _tmp8_;
		_tmp5_ = self->priv->navigation_view;
		_tmp6_ = adw_navigation_view_get_visible_page (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->episodes_page;
		if (_tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, adw_navigation_page_get_type (), AdwNavigationPage)) {
			AudienceEpisodesPage* _tmp9_;
			_tmp9_ = self->priv->episodes_page;
			audience_episodes_page_search (_tmp9_);
		} else {
			GdkDisplay* _tmp10_;
			_tmp10_ = gdk_display_get_default ();
			gdk_display_beep (_tmp10_);
		}
	}
}

static void
audience_window_action_undo (AudienceWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!audience_is_sandboxed ()) {
		AudienceServicesLibraryManager* _tmp0_;
		AudienceServicesLibraryManager* _tmp1_;
		_tmp0_ = audience_services_library_manager_get_instance ();
		_tmp1_ = _tmp0_;
		audience_services_library_manager_undo_delete_item (_tmp1_);
		_g_object_unref0 (_tmp1_);
	}
}

/** Returns true if the code parameter matches the keycode of the keyval parameter for
    * any keyboard group or level (in order to allow for non-QWERTY keyboards) **/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
audience_window_match_keycode (AudienceWindow* self,
                               guint keyval,
                               guint code)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkDisplay* _tmp2_;
	GdkKeymapKey* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp5_ = gdk_display_map_keyval (_tmp2_, keyval, &_tmp3_, &_tmp4_);
	keys = (g_free (keys), NULL);
	keys = _tmp3_;
	keys_length1 = _tmp4_;
	_keys_size_ = keys_length1;
	if (_tmp5_) {
		GdkKeymapKey* _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = keys;
		_tmp6__length1 = keys_length1;
		{
			GdkKeymapKey* key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp6_;
			key_collection_length1 = _tmp6__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				GdkKeymapKey key = {0};
				key = key_collection[key_it];
				{
					GdkKeymapKey _tmp7_;
					_tmp7_ = key;
					if (code == _tmp7_.keycode) {
						result = TRUE;
						keys = (g_free (keys), NULL);
						_g_object_unref0 (display);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	keys = (g_free (keys), NULL);
	_g_object_unref0 (display);
	return result;
}

void
audience_window_handle_key_press (AudienceWindow* self,
                                  guint keyval,
                                  guint keycode,
                                  GdkModifierType state)
{
	AdwNavigationView* _tmp2_;
	AdwNavigationPage* _tmp3_;
	AdwNavigationPage* _tmp4_;
	AudiencePlayerPage* _tmp5_;
	g_return_if_fail (self != NULL);
	if (keyval == GDK_KEY_Escape) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		g_object_get ((GtkWindow*) self, "fullscreened", &_tmp0_, NULL);
		_tmp1_ = _tmp0_;
		if (_tmp1_) {
			gtk_window_unfullscreen ((GtkWindow*) self);
		} else {
			gtk_window_destroy ((GtkWindow*) self);
		}
	}
	_tmp2_ = self->priv->navigation_view;
	_tmp3_ = adw_navigation_view_get_visible_page (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player_page;
	if (_tmp4_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, adw_navigation_page_get_type (), AdwNavigationPage)) {
		gboolean _tmp6_ = FALSE;
		gboolean shift_pressed = FALSE;
		if (audience_window_match_keycode (self, GDK_KEY_space, keycode)) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = audience_window_match_keycode (self, GDK_KEY_p, keycode);
		}
		if (_tmp6_) {
			GAction* play_pause_action = NULL;
			GApplication* _tmp7_;
			GAction* _tmp8_;
			GAction* _tmp9_;
			GAction* _tmp10_;
			_tmp7_ = g_application_get_default ();
			_tmp8_ = g_action_map_lookup_action ((GActionMap*) _tmp7_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
			_tmp9_ = _g_object_ref0 (_tmp8_);
			play_pause_action = _tmp9_;
			_tmp10_ = play_pause_action;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_simple_action_get_type (), GSimpleAction), "activate", NULL);
			_g_object_unref0 (play_pause_action);
		} else {
			if (audience_window_match_keycode (self, GDK_KEY_a, keycode)) {
				AudiencePlaybackManager* _tmp11_;
				_tmp11_ = audience_playback_manager_get_default ();
				g_signal_emit_by_name (_tmp11_, "next-audio");
			} else {
				if (audience_window_match_keycode (self, GDK_KEY_s, keycode)) {
					AudiencePlaybackManager* _tmp12_;
					_tmp12_ = audience_playback_manager_get_default ();
					g_signal_emit_by_name (_tmp12_, "next-text");
				}
			}
		}
		shift_pressed = (state & GDK_SHIFT_MASK) == GDK_SHIFT_MASK;
		switch (keyval) {
			case GDK_KEY_Down:
			{
				gint _tmp13_ = 0;
				AudiencePlayerPage* _tmp14_;
				if (shift_pressed) {
					_tmp13_ = -5;
				} else {
					_tmp13_ = -60;
				}
				_tmp14_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp14_, _tmp13_);
				break;
			}
			case GDK_KEY_Left:
			{
				gint _tmp15_ = 0;
				AudiencePlayerPage* _tmp16_;
				if (shift_pressed) {
					_tmp15_ = -1;
				} else {
					_tmp15_ = -10;
				}
				_tmp16_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp16_, _tmp15_);
				break;
			}
			case GDK_KEY_Right:
			{
				gint _tmp17_ = 0;
				AudiencePlayerPage* _tmp18_;
				if (shift_pressed) {
					_tmp17_ = 1;
				} else {
					_tmp17_ = 10;
				}
				_tmp18_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp18_, _tmp17_);
				break;
			}
			case GDK_KEY_Up:
			{
				gint _tmp19_ = 0;
				AudiencePlayerPage* _tmp20_;
				if (shift_pressed) {
					_tmp19_ = 5;
				} else {
					_tmp19_ = 60;
				}
				_tmp20_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp20_, _tmp19_);
				break;
			}
			case GDK_KEY_Page_Down:
			{
				AudiencePlayerPage* _tmp21_;
				_tmp21_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp21_, -600);
				break;
			}
			case GDK_KEY_Page_Up:
			{
				AudiencePlayerPage* _tmp22_;
				_tmp22_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp22_, 600);
				break;
			}
			default:
			{
				break;
			}
		}
	} else {
		AdwNavigationView* _tmp23_;
		AdwNavigationPage* _tmp24_;
		AdwNavigationPage* _tmp25_;
		AudienceWelcomePage* _tmp26_;
		_tmp23_ = self->priv->navigation_view;
		_tmp24_ = adw_navigation_view_get_visible_page (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->welcome_page;
		if (_tmp25_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, adw_navigation_page_get_type (), AdwNavigationPage)) {
			gboolean ctrl_pressed = FALSE;
			gboolean _tmp27_ = FALSE;
			ctrl_pressed = (state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
			if (audience_window_match_keycode (self, GDK_KEY_p, keycode)) {
				_tmp27_ = TRUE;
			} else {
				_tmp27_ = audience_window_match_keycode (self, GDK_KEY_space, keycode);
			}
			if (_tmp27_) {
				audience_window_resume_last_videos (self);
			} else {
				gboolean _tmp28_ = FALSE;
				if (ctrl_pressed) {
					_tmp28_ = audience_window_match_keycode (self, GDK_KEY_b, keycode);
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					audience_window_show_library (self);
				}
			}
		}
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		AudienceWindow* self;
		self = _data2_->self;
		_data2_->videos = (_vala_array_free (_data2_->videos, _data2_->videos_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_____lambda27_ (Block2Data* _data2_,
                GFile* file_ret)
{
	AudienceWindow* self;
	gchar* _tmp0_;
	self = _data2_->self;
	g_return_if_fail (file_ret != NULL);
	_tmp0_ = g_file_get_uri (file_ret);
	_vala_array_add1 (&_data2_->videos, &_data2_->videos_length1, &_data2_->_videos_size_, _tmp0_);
}

static void
______lambda27__audience_func_over_dir (GFile* file_under_dir,
                                        gpointer self)
{
	_____lambda27_ (self, file_under_dir);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
audience_window_open_files (AudienceWindow* self,
                            GFile** files,
                            gint files_length1,
                            gboolean clear_playlist_items,
                            gboolean force_play)
{
	Block2Data* _data2_;
	gchar** _tmp1_;
	AudiencePlaybackManager* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (clear_playlist_items) {
		AudiencePlaybackManager* _tmp0_;
		_tmp0_ = audience_playback_manager_get_default ();
		audience_playback_manager_clear_playlist (_tmp0_, FALSE);
	}
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	_data2_->videos = _tmp1_;
	_data2_->videos_length1 = 0;
	_data2_->_videos_size_ = _data2_->videos_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp2_;
			GFile* file = NULL;
			_tmp2_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp2_;
			{
				GFile* _tmp3_;
				_tmp3_ = file;
				if (g_file_query_file_type (_tmp3_, 0, NULL) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp4_;
					_tmp4_ = file;
					audience_recurse_over_dir (_tmp4_, ______lambda27__audience_func_over_dir, _data2_);
				} else {
					GFile* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = file;
					_tmp6_ = g_file_get_uri (_tmp5_);
					_vala_array_add2 (&_data2_->videos, &_data2_->videos_length1, &_data2_->_videos_size_, _tmp6_);
				}
				_g_object_unref0 (file);
			}
		}
	}
	_tmp7_ = audience_playback_manager_get_default ();
	_tmp8_ = _data2_->videos;
	_tmp8__length1 = _data2_->videos_length1;
	audience_playback_manager_append_to_playlist (_tmp7_, _tmp8_, (gint) _tmp8__length1);
	if (force_play) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = _data2_->videos;
		_tmp10__length1 = _data2_->videos_length1;
		_tmp9_ = _tmp10__length1 > 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* videofile = NULL;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		AudienceWindowNavigationPage page = 0;
		AudienceLibraryPage* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp11_ = _data2_->videos;
		_tmp11__length1 = _data2_->videos_length1;
		_tmp12_ = _tmp11_[0];
		_tmp13_ = g_strdup (_tmp12_);
		videofile = _tmp13_;
		_tmp14_ = self->priv->library_page;
		_tmp15_ = videofile;
		page = audience_library_page_prepare_to_play (_tmp14_, _tmp15_);
		_tmp16_ = videofile;
		audience_window_play_file (self, _tmp16_, page, TRUE);
		_g_free0 (videofile);
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

void
audience_window_resume_last_videos (AudienceWindow* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = audience_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "current-video");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = audience_settings;
		_tmp5_ = g_settings_get_string (_tmp4_, "current-video");
		_tmp6_ = _tmp5_;
		audience_window_play_file (self, _tmp6_, AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME, FALSE);
		_g_free0 (_tmp6_);
	} else {
		audience_window_action_open_file (self);
	}
}

void
audience_window_show_library (AudienceWindow* self)
{
	AdwNavigationView* _tmp0_;
	AudienceLibraryPage* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	_tmp1_ = self->priv->library_page;
	adw_navigation_view_push (_tmp0_, (AdwNavigationPage*) _tmp1_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		AudienceWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->file);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_vala_array_add3 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda26_ (Block3Data* _data3_,
             gint response)
{
	AudienceWindow* self;
	self = _data3_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile** files = NULL;
		GFile** _tmp0_;
		gint files_length1;
		gint _files_size_;
		GListModel* files_list = NULL;
		GListModel* _tmp1_;
		GFile** _tmp7_;
		gint _tmp7__length1;
		GSettings* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp0_ = g_new0 (GFile*, 0 + 1);
		files = _tmp0_;
		files_length1 = 0;
		_files_size_ = files_length1;
		_tmp1_ = gtk_file_chooser_get_files ((GtkFileChooser*) _data3_->file);
		files_list = _tmp1_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GListModel* _tmp4_;
					GListModel* _tmp5_;
					GObject* _tmp6_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = files_list;
					if (!(((guint) i) < g_list_model_get_n_items (_tmp4_))) {
						break;
					}
					_tmp5_ = files_list;
					_tmp6_ = g_list_model_get_item (_tmp5_, (guint) i);
					_vala_array_add3 (&files, &files_length1, &_files_size_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_file_get_type (), GFile));
				}
			}
		}
		_tmp7_ = files;
		_tmp7__length1 = files_length1;
		audience_window_open_files (self, _tmp7_, (gint) _tmp7__length1, _data3_->clear_playlist, _data3_->force_play);
		_tmp8_ = audience_settings;
		_tmp9_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _data3_->file);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_path (_tmp10_);
		_tmp12_ = _tmp11_;
		g_settings_set_string (_tmp8_, "last-folder", _tmp12_);
		_g_free0 (_tmp12_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (files_list);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data3_->file);
}

static void
___lambda26__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda26_ (self, response_id);
}

void
audience_window_run_open_file (AudienceWindow* self,
                               gboolean clear_playlist,
                               gboolean force_play)
{
	Block3Data* _data3_;
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* video_filter = NULL;
	GtkFileFilter* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->clear_playlist = clear_playlist;
	_data3_->force_play = force_play;
	_tmp0_ = gtk_file_filter_new ();
	all_files_filter = _tmp0_;
	gtk_file_filter_set_name (all_files_filter, _ ("All files"));
	gtk_file_filter_add_pattern (all_files_filter, "*");
	_tmp1_ = gtk_file_filter_new ();
	video_filter = _tmp1_;
	gtk_file_filter_set_name (video_filter, _ ("Video files"));
	gtk_file_filter_add_mime_type (video_filter, "video/*");
	_tmp2_ = gtk_file_chooser_native_new (_ ("Open"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Open"), _ ("_Cancel"));
	_data3_->file = _tmp2_;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _data3_->file, TRUE);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data3_->file, video_filter);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data3_->file, all_files_filter);
	{
		GSettings* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp3_ = audience_settings;
		_tmp4_ = g_settings_get_string (_tmp3_, "last-folder");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _data3_->file, _tmp7_, &_inner_error0_);
		_g_object_unref0 (_tmp7_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("Window.vala:341: Failed to set last folder as current folder: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (video_filter);
		_g_object_unref0 (all_files_filter);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_connect_data ((GtkNativeDialog*) _data3_->file, "response", (GCallback) ___lambda26__gtk_native_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data3_->file);
	_g_object_unref0 (video_filter);
	_g_object_unref0 (all_files_filter);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
audience_window_on_player_ended (AudienceWindow* self)
{
	AdwNavigationView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	adw_navigation_view_pop (_tmp0_);
}

void
audience_window_play_file (AudienceWindow* self,
                           const gchar* uri,
                           AudienceWindowNavigationPage origin,
                           gboolean from_beginning)
{
	AdwNavigationView* _tmp0_;
	AudiencePlayerPage* _tmp1_;
	AudiencePlaybackManager* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->navigation_view;
	_tmp1_ = self->priv->player_page;
	adw_navigation_view_push (_tmp0_, (AdwNavigationPage*) _tmp1_);
	_tmp2_ = audience_playback_manager_get_default ();
	audience_playback_manager_play_file (_tmp2_, uri, from_beginning);
}

static GVariant*
_variant_new3 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new4 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
audience_window_update_navigation (AudienceWindow* self)
{
	gint64 position = 0LL;
	AudiencePlaybackManager* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GAction* play_pause_action = NULL;
	GApplication* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	AdwNavigationView* _tmp7_;
	AdwNavigationPage* _tmp8_;
	AdwNavigationPage* _tmp9_;
	AudiencePlayerPage* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = audience_playback_manager_get_default ();
	_tmp1_ = audience_playback_manager_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	position = _tmp2_;
	if (position > ((gint64) 0)) {
		GSettings* _tmp3_;
		_tmp3_ = audience_settings;
		g_settings_set_int64 (_tmp3_, "last-stopped", position);
	}
	_tmp4_ = g_application_get_default ();
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	play_pause_action = _tmp6_;
	_tmp7_ = self->priv->navigation_view;
	_tmp8_ = adw_navigation_view_get_visible_page (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->player_page;
	if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, adw_navigation_page_get_type (), AdwNavigationPage)) {
		GAction* _tmp11_;
		GVariant* _tmp12_;
		_tmp11_ = play_pause_action;
		_tmp12_ = _variant_new3 (TRUE);
		g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_simple_action_get_type (), GSimpleAction), _tmp12_);
		_g_variant_unref0 (_tmp12_);
	} else {
		GAction* _tmp13_;
		GVariant* _tmp14_;
		_tmp13_ = play_pause_action;
		_tmp14_ = _variant_new4 (FALSE);
		g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_simple_action_get_type (), GSimpleAction), _tmp14_);
		_g_variant_unref0 (_tmp14_);
	}
	_g_object_unref0 (play_pause_action);
}

AudienceWindow*
audience_window_construct (GType object_type)
{
	AudienceWindow * self = NULL;
	self = (AudienceWindow*) g_object_new (object_type, NULL);
	return self;
}

AudienceWindow*
audience_window_new (void)
{
	return audience_window_construct (AUDIENCE_TYPE_WINDOW);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		AudienceWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->playback_manager);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_audience_window_action_undo_granite_toast_default_action (GraniteToast* _sender,
                                                           gpointer self)
{
	audience_window_action_undo ((AudienceWindow*) self);
}

static void
_audience_window___lambda72_ (AudienceWindow* self,
                              AudienceObjectsMediaItem* item)
{
	GraniteToast* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GraniteToast* _tmp9_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->app_notification;
	_tmp1_ = audience_objects_media_item_get_title (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Video '%s' Removed."), _tmp2_);
	_tmp4_ = _tmp3_;
	granite_toast_set_title (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	if (!audience_is_sandboxed ()) {
		GraniteToast* _tmp5_;
		GraniteToast* _tmp6_;
		guint _tmp7_;
		GraniteToast* _tmp8_;
		_tmp5_ = self->priv->app_notification;
		granite_toast_set_default_action (_tmp5_, _ ("Restore"));
		_tmp6_ = self->priv->app_notification;
		g_signal_parse_name ("default-action", GRANITE_TYPE_TOAST, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _audience_window_action_undo_granite_toast_default_action, self);
		_tmp8_ = self->priv->app_notification;
		g_signal_connect_object (_tmp8_, "default-action", (GCallback) _audience_window_action_undo_granite_toast_default_action, self, 0);
	}
	_tmp9_ = self->priv->app_notification;
	granite_toast_send_notification (_tmp9_);
}

static void
__audience_window___lambda72__audience_services_library_manager_media_item_trashed (AudienceServicesLibraryManager* _sender,
                                                                                    AudienceObjectsMediaItem* item,
                                                                                    gpointer self)
{
	_audience_window___lambda72_ ((AudienceWindow*) self, item);
}

static void
_audience_window___lambda73_ (AudienceWindow* self,
                              AudienceObjectsMediaItem* item,
                              gboolean setup_only)
{
	AudienceEpisodesPage* _tmp0_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->episodes_page;
	audience_episodes_page_set_show (_tmp0_, item);
	if (!setup_only) {
		AdwNavigationView* _tmp1_;
		AudienceEpisodesPage* _tmp2_;
		_tmp1_ = self->priv->navigation_view;
		_tmp2_ = self->priv->episodes_page;
		adw_navigation_view_push (_tmp1_, (AdwNavigationPage*) _tmp2_);
	}
}

static void
__audience_window___lambda73__audience_library_page_show_episodes (AudienceLibraryPage* _sender,
                                                                   AudienceObjectsMediaItem* item,
                                                                   gboolean setup_only,
                                                                   gpointer self)
{
	_audience_window___lambda73_ ((AudienceWindow*) self, item, setup_only);
}

static void
_audience_window___lambda74_ (AudienceWindow* self)
{
	audience_window_update_navigation (self);
}

static void
__audience_window___lambda74__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	_audience_window___lambda74_ ((AudienceWindow*) self);
}

static void
_audience_window___lambda75_ (Block4Data* _data4_,
                              guint pos,
                              guint removed,
                              guint added)
{
	AudienceWindow* self;
	AudiencePlaybackManager* _tmp0_;
	GtkStringList* _tmp1_;
	GtkStringList* _tmp2_;
	GraniteToast* _tmp3_;
	self = _data4_->self;
	_tmp0_ = _data4_->playback_manager;
	_tmp1_ = audience_playback_manager_get_play_queue (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_list_model_get_n_items ((GListModel*) _tmp2_) == ((guint) 1)) {
		return;
	}
	_tmp3_ = self->priv->app_notification;
	granite_toast_set_default_action (_tmp3_, NULL);
	if (added == ((guint) 1)) {
		gchar* title = NULL;
		AudiencePlaybackManager* _tmp4_;
		GtkStringList* _tmp5_;
		GtkStringList* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GraniteToast* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GraniteToast* _tmp13_;
		_tmp4_ = _data4_->playback_manager;
		_tmp5_ = audience_playback_manager_get_play_queue (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gtk_string_list_get_string (_tmp6_, pos);
		_tmp8_ = audience_get_title (_tmp7_);
		title = _tmp8_;
		_tmp9_ = self->priv->app_notification;
		_tmp10_ = title;
		_tmp11_ = g_strdup_printf (_ ("“%s” added to playlist"), _tmp10_);
		_tmp12_ = _tmp11_;
		granite_toast_set_title (_tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = self->priv->app_notification;
		granite_toast_send_notification (_tmp13_);
		_g_free0 (title);
	} else {
		if (added > ((guint) 1)) {
			GraniteToast* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GraniteToast* _tmp17_;
			_tmp14_ = self->priv->app_notification;
			_tmp15_ = g_strdup_printf (ngettext ("%u item added to playlist", "%u items added to playlist", (gulong) added), added);
			_tmp16_ = _tmp15_;
			granite_toast_set_title (_tmp14_, _tmp16_);
			_g_free0 (_tmp16_);
			_tmp17_ = self->priv->app_notification;
			granite_toast_send_notification (_tmp17_);
		}
	}
}

static void
__audience_window___lambda75__g_list_model_items_changed (GListModel* _sender,
                                                          guint position,
                                                          guint removed,
                                                          guint added,
                                                          gpointer self)
{
	_audience_window___lambda75_ (self, position, removed, added);
}

static void
_audience_window_on_player_ended_audience_playback_manager_ended (AudiencePlaybackManager* _sender,
                                                                  gpointer self)
{
	audience_window_on_player_ended ((AudienceWindow*) self);
}

static void
_audience_window_handle_key_press_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                         guint keyval,
                                                                         guint keycode,
                                                                         GdkModifierType state,
                                                                         gpointer self)
{
	audience_window_handle_key_press ((AudienceWindow*) self, keyval, keycode, state);
}

static void
_vala_array_add4 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_audience_window___lambda76_ (AudienceWindow* self,
                              GValue* val)
{
	GFile** files = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GSList* file_list = NULL;
	void* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	GFile** _tmp5_;
	gint _tmp5__length1;
	gboolean result;
	g_return_val_if_fail (val != NULL, FALSE);
	if (G_VALUE_TYPE (val) != gdk_file_list_get_type ()) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_value_get_boxed (val);
	_tmp1_ = gdk_file_list_get_files ((GdkFileList*) _tmp0_);
	file_list = _tmp1_;
	_tmp2_ = file_list;
	{
		GSList* file_collection = NULL;
		GSList* file_it = NULL;
		file_collection = _tmp2_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* file = NULL;
			file = (GFile*) file_it->data;
			{
				GFile* _tmp3_;
				GFile* _tmp4_;
				_tmp3_ = file;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				_vala_array_add4 (&files, &files_length1, &_files_size_, _tmp4_);
			}
		}
	}
	_tmp5_ = files;
	_tmp5__length1 = files_length1;
	audience_window_open_files (self, _tmp5_, (gint) _tmp5__length1, FALSE, TRUE);
	result = TRUE;
	(file_list == NULL) ? NULL : (file_list = (g_slist_free (file_list), NULL));
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static gboolean
__audience_window___lambda76__gtk_drop_target_drop (GtkDropTarget* _sender,
                                                    GValue* value,
                                                    gdouble x,
                                                    gdouble y,
                                                    gpointer self)
{
	gboolean result;
	result = _audience_window___lambda76_ ((AudienceWindow*) self, value);
	return result;
}

static GObject *
audience_window_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceWindow * self;
	Block4Data* _data4_;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	AudienceLibraryPage* _tmp21_;
	AudienceWelcomePage* _tmp22_;
	AudiencePlayerPage* _tmp23_;
	AudienceEpisodesPage* _tmp24_;
	AdwNavigationView* _tmp25_;
	AdwNavigationView* _tmp26_;
	AudienceWelcomePage* _tmp27_;
	GraniteToast* _tmp28_;
	GtkOverlay* overlay = NULL;
	AdwNavigationView* _tmp29_;
	GtkWidget* _tmp30_;
	GtkOverlay* _tmp31_ = NULL;
	GtkOverlay* _tmp32_;
	GraniteToast* _tmp33_;
	GtkGrid* _tmp34_ = NULL;
	GtkGrid* _tmp35_;
	GtkOverlay* _tmp36_;
	AudienceServicesLibraryManager* manager = NULL;
	AudienceServicesLibraryManager* _tmp37_;
	AudienceServicesLibraryManager* _tmp38_;
	AudienceLibraryPage* _tmp39_;
	AdwNavigationView* _tmp40_;
	AudiencePlaybackManager* _tmp41_;
	AudiencePlaybackManager* _tmp42_;
	AudiencePlaybackManager* _tmp43_;
	GtkStringList* _tmp44_;
	GtkStringList* _tmp45_;
	AudiencePlaybackManager* _tmp46_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp47_;
	GtkOverlay* _tmp48_;
	GtkEventControllerKey* _tmp49_;
	GtkEventController* _tmp50_;
	GtkEventControllerKey* _tmp51_;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp52_;
	AdwNavigationView* _tmp53_;
	GtkDropTarget* _tmp54_;
	GtkEventController* _tmp55_;
	GtkDropTarget* _tmp56_;
	parent_class = G_OBJECT_CLASS (audience_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_WINDOW, AudienceWindow);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, AUDIENCE_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (AUDIENCE_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp1_;
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp2_ = audience_window_action_accelerators;
		_tmp3_ = gee_multi_map_get_keys (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_action_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gchar* action = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GtkApplication* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GeeMultiMap* _tmp14_;
			const gchar* _tmp15_;
			GeeCollection* _tmp16_;
			GeeCollection* _tmp17_;
			gint _tmp18_ = 0;
			gpointer* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp7_ = _action_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _action_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			action = (gchar*) _tmp9_;
			_tmp10_ = application_instance;
			_tmp11_ = action;
			_tmp12_ = g_strconcat (AUDIENCE_WINDOW_ACTION_PREFIX, _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = audience_window_action_accelerators;
			_tmp15_ = action;
			_tmp16_ = gee_multi_map_get (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp19_ = gee_collection_to_array (_tmp17_, &_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp20__length1 = _tmp18_;
			gtk_application_set_accels_for_action (_tmp10_, _tmp13_, _tmp20_);
			_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	gtk_window_set_default_size ((GtkWindow*) self, 1000, 680);
	_tmp21_ = audience_library_page_get_instance ();
	_g_object_unref0 (self->priv->library_page);
	self->priv->library_page = _tmp21_;
	_tmp22_ = audience_welcome_page_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->welcome_page);
	self->priv->welcome_page = _tmp22_;
	_tmp23_ = audience_player_page_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->player_page);
	self->priv->player_page = _tmp23_;
	_tmp24_ = audience_episodes_page_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->episodes_page);
	self->priv->episodes_page = _tmp24_;
	_tmp25_ = (AdwNavigationView*) adw_navigation_view_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->navigation_view);
	self->priv->navigation_view = _tmp25_;
	_tmp26_ = self->priv->navigation_view;
	_tmp27_ = self->priv->welcome_page;
	adw_navigation_view_add (_tmp26_, (AdwNavigationPage*) _tmp27_);
	_tmp28_ = granite_toast_new ("");
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->app_notification);
	self->priv->app_notification = _tmp28_;
	_tmp29_ = self->priv->navigation_view;
	_tmp30_ = _g_object_ref0 ((GtkWidget*) _tmp29_);
	_tmp31_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp31_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	overlay = _tmp31_;
	_tmp32_ = overlay;
	_tmp33_ = self->priv->app_notification;
	gtk_overlay_add_overlay (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp34_, FALSE);
	g_object_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = overlay;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp36_);
	gtk_window_present ((GtkWindow*) self);
	_tmp37_ = audience_services_library_manager_get_instance ();
	manager = _tmp37_;
	_tmp38_ = manager;
	g_signal_connect_object (_tmp38_, "media-item-trashed", (GCallback) __audience_window___lambda72__audience_services_library_manager_media_item_trashed, self, 0);
	_tmp39_ = self->priv->library_page;
	g_signal_connect_object (_tmp39_, "show-episodes", (GCallback) __audience_window___lambda73__audience_library_page_show_episodes, self, 0);
	_tmp40_ = self->priv->navigation_view;
	g_signal_connect_object ((GObject*) _tmp40_, "notify::visible-page", (GCallback) __audience_window___lambda74__g_object_notify, self, 0);
	_tmp41_ = audience_playback_manager_get_default ();
	_tmp42_ = _g_object_ref0 (_tmp41_);
	_data4_->playback_manager = _tmp42_;
	_tmp43_ = _data4_->playback_manager;
	_tmp44_ = audience_playback_manager_get_play_queue (_tmp43_);
	_tmp45_ = _tmp44_;
	g_signal_connect_data ((GListModel*) _tmp45_, "items-changed", (GCallback) __audience_window___lambda75__g_list_model_items_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp46_ = _data4_->playback_manager;
	g_signal_connect_object (_tmp46_, "ended", (GCallback) _audience_window_on_player_ended_audience_playback_manager_ended, self, 0);
	_tmp47_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp47_;
	_tmp48_ = overlay;
	_tmp49_ = key_controller;
	_tmp50_ = _g_object_ref0 ((GtkEventController*) _tmp49_);
	gtk_widget_add_controller ((GtkWidget*) _tmp48_, _tmp50_);
	_tmp51_ = key_controller;
	g_signal_connect_object (_tmp51_, "key-released", (GCallback) _audience_window_handle_key_press_gtk_event_controller_key_key_released, self, 0);
	_tmp52_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp52_;
	_tmp53_ = self->priv->navigation_view;
	_tmp54_ = drop_target;
	_tmp55_ = _g_object_ref0 ((GtkEventController*) _tmp54_);
	gtk_widget_add_controller ((GtkWidget*) _tmp53_, _tmp55_);
	_tmp56_ = drop_target;
	g_signal_connect_object (_tmp56_, "drop", (GCallback) __audience_window___lambda76__gtk_drop_target_drop, self, 0);
	_g_object_unref0 (drop_target);
	_g_object_unref0 (key_controller);
	_g_object_unref0 (manager);
	_g_object_unref0 (overlay);
	_g_object_unref0 (application_instance);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
audience_window_class_init (AudienceWindowClass * klass,
                            gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	GeeMultiMap* _tmp6_;
	audience_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = audience_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_window_finalize;
	audience_window_signals[AUDIENCE_WINDOW_MEDIA_VOLUMES_CHANGED_SIGNAL] = g_signal_new ("media-volumes-changed", AUDIENCE_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	audience_window_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp1_, AUDIENCE_WINDOW_ACTION_FULLSCREEN, "F");
	_tmp2_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp2_, AUDIENCE_WINDOW_ACTION_FULLSCREEN, "F11");
	_tmp3_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp3_, AUDIENCE_WINDOW_ACTION_OPEN_FILE, "<Control>O");
	_tmp4_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp4_, AUDIENCE_WINDOW_ACTION_QUIT, "<Control>Q");
	_tmp5_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp5_, AUDIENCE_WINDOW_ACTION_SEARCH, "<Control>F");
	_tmp6_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp6_, AUDIENCE_WINDOW_ACTION_UNDO, "<Control>Z");
}

static void
audience_window_instance_init (AudienceWindow * self,
                               gpointer klass)
{
	self->priv = audience_window_get_instance_private (self);
}

static void
audience_window_finalize (GObject * obj)
{
	AudienceWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_WINDOW, AudienceWindow);
	_g_object_unref0 (self->priv->navigation_view);
	_g_object_unref0 (self->priv->app_notification);
	_g_object_unref0 (self->priv->episodes_page);
	_g_object_unref0 (self->priv->library_page);
	_g_object_unref0 (self->priv->player_page);
	_g_object_unref0 (self->priv->welcome_page);
	G_OBJECT_CLASS (audience_window_parent_class)->finalize (obj);
}

static GType
audience_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceWindow), 0, (GInstanceInitFunc) audience_window_instance_init, NULL };
	GType audience_window_type_id;
	audience_window_type_id = g_type_register_static (gtk_application_window_get_type (), "AudienceWindow", &g_define_type_info, 0);
	AudienceWindow_private_offset = g_type_add_instance_private (audience_window_type_id, sizeof (AudienceWindowPrivate));
	return audience_window_type_id;
}

GType
audience_window_get_type (void)
{
	static volatile gsize audience_window_type_id__once = 0;
	if (g_once_init_enter (&audience_window_type_id__once)) {
		GType audience_window_type_id;
		audience_window_type_id = audience_window_get_type_once ();
		g_once_init_leave (&audience_window_type_id__once, audience_window_type_id);
	}
	return audience_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

