/* Utils.c generated by valac 0.56.17, the Vala compiler
 * generated from Utils.vala, do not modify */

/*-
 * Copyright (c) 2013-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Tom Beckmann <tomjonabc@gmail.com>
 */

#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <glib/gstdio.h>

#define AUDIENCE_DISCOVERER_TIMEOUT 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*AudienceFuncOverDir) (GFile* file_under_dir, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

VALA_EXTERN void audience_recurse_over_dir (GFile* file_to_process,
                                AudienceFuncOverDir func,
                                gpointer func_target);
VALA_EXTERN gchar* audience_get_title (const gchar* filename);
VALA_EXTERN gchar* audience_get_basename (const gchar* filename);
VALA_EXTERN GstDiscovererInfo* audience_get_discoverer_info (const gchar* uri);
VALA_EXTERN gboolean audience_is_sandboxed (void);

void
audience_recurse_over_dir (GFile* file_to_process,
                           AudienceFuncOverDir func,
                           gpointer func_target)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file_to_process != NULL);
	if (g_file_query_file_type (file_to_process, 0, NULL) == G_FILE_TYPE_DIRECTORY) {
		{
			GFileEnumerator* files = NULL;
			GFileEnumerator* _tmp0_;
			GFileInfo* info = NULL;
			_tmp0_ = g_file_enumerate_children (file_to_process, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			files = _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp1_ = NULL;
				GFileEnumerator* _tmp2_;
				GFileInfo* _tmp3_;
				GFileInfo* _tmp4_;
				GFileInfo* _tmp5_;
				GFile* file = NULL;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				GFileInfo* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				_tmp2_ = files;
				_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
				_tmp1_ = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					_g_object_unref0 (files);
					goto __catch0_g_error;
				}
				_tmp4_ = _tmp1_;
				_tmp1_ = NULL;
				_g_object_unref0 (info);
				info = _tmp4_;
				_tmp5_ = info;
				if (!(_tmp5_ != NULL)) {
					_g_object_unref0 (_tmp1_);
					break;
				}
				_tmp6_ = g_file_get_uri (file_to_process);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (_tmp7_, "/", NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = info;
				_tmp11_ = g_file_info_get_name (_tmp10_);
				_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_file_new_for_uri (_tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (_tmp9_);
				_g_free0 (_tmp7_);
				file = _tmp15_;
				_tmp16_ = file;
				audience_recurse_over_dir (_tmp16_, func, func_target);
				_g_object_unref0 (file);
				_g_object_unref0 (_tmp1_);
			}
			_g_object_unref0 (info);
			_g_object_unref0 (files);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_critical ("Utils.vala:34: %s", _tmp18_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		func (file_to_process, func_target);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
audience_get_title (const gchar* filename)
{
	gchar* title = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = audience_get_basename (filename);
	title = _tmp0_;
	_tmp1_ = title;
	_tmp2_ = g_uri_unescape_string (_tmp1_, NULL);
	_g_free0 (title);
	title = _tmp2_;
	_tmp3_ = title;
	_tmp4_ = string_replace (_tmp3_, "_", " ");
	_tmp5_ = _tmp4_;
	_tmp6_ = string_replace (_tmp5_, ".", " ");
	_tmp7_ = _tmp6_;
	_tmp8_ = string_replace (_tmp7_, "  ", " ");
	_g_free0 (title);
	title = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	result = title;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
audience_get_basename (const gchar* filename)
{
	gchar* basename = NULL;
	gchar* _tmp0_;
	gint index_of_last_dot = 0;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* launcher_base = NULL;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_path_get_basename (filename);
	basename = _tmp0_;
	_tmp1_ = basename;
	index_of_last_dot = string_last_index_of (_tmp1_, ".", 0);
	if (index_of_last_dot >= 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = basename;
		_tmp4_ = string_slice (_tmp3_, (glong) 0, (glong) index_of_last_dot);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = basename;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = g_strdup (_tmp2_);
	launcher_base = _tmp7_;
	result = launcher_base;
	_g_free0 (_tmp2_);
	_g_free0 (basename);
	return result;
}

GstDiscovererInfo*
audience_get_discoverer_info (const gchar* uri)
{
	GstDiscoverer* discoverer = NULL;
	GstDiscovererInfo* discoverer_info = NULL;
	GError* _inner_error0_ = NULL;
	GstDiscovererInfo* result;
	g_return_val_if_fail (uri != NULL, NULL);
	discoverer = NULL;
	{
		GstDiscoverer* _tmp0_ = NULL;
		GstDiscoverer* _tmp1_;
		GstDiscoverer* _tmp2_;
		_tmp1_ = gst_discoverer_new ((GstClockTime) (AUDIENCE_DISCOVERER_TIMEOUT * GST_SECOND), &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (discoverer);
		discoverer = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("Utils.vala:62: Could not create Gst discoverer object: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (discoverer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	discoverer_info = NULL;
	{
		GstDiscovererInfo* _tmp5_ = NULL;
		GstDiscoverer* _tmp6_;
		GstDiscovererInfo* _tmp7_;
		GstDiscovererInfo* _tmp8_;
		_tmp6_ = discoverer;
		_tmp7_ = gst_discoverer_discover_uri (_tmp6_, uri, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (discoverer_info);
		discoverer_info = _tmp8_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_debug ("Utils.vala:69: Discoverer Error %d: %s\n", _tmp9_->code, _tmp11_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (discoverer_info);
		_g_object_unref0 (discoverer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = discoverer_info;
	_g_object_unref0 (discoverer);
	return result;
}

gboolean
audience_is_sandboxed (void)
{
	gboolean result;
	result = g_file_test ("/.flatpak-info", G_FILE_TEST_EXISTS);
	return result;
}

