/* ui.c generated by valac 0.56.18, the Vala compiler
 * generated from ui.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
adjustment_relation_get_type_once (void)
{
	static const GEnumValue values[] = {{ADJUSTMENT_RELATION_BELOW, "ADJUSTMENT_RELATION_BELOW", "below"}, {ADJUSTMENT_RELATION_IN_RANGE, "ADJUSTMENT_RELATION_IN_RANGE", "in-range"}, {ADJUSTMENT_RELATION_ABOVE, "ADJUSTMENT_RELATION_ABOVE", "above"}, {0, NULL, NULL}};
	GType adjustment_relation_type_id;
	adjustment_relation_type_id = g_enum_register_static ("AdjustmentRelation", values);
	return adjustment_relation_type_id;
}

GType
adjustment_relation_get_type (void)
{
	static volatile gsize adjustment_relation_type_id__once = 0;
	if (g_once_init_enter (&adjustment_relation_type_id__once)) {
		GType adjustment_relation_type_id;
		adjustment_relation_type_id = adjustment_relation_get_type_once ();
		g_once_init_leave (&adjustment_relation_type_id__once, adjustment_relation_type_id);
	}
	return adjustment_relation_type_id__once;
}

SpitTransitionsDirection
direction_to_transition_direction (Direction self)
{
	SpitTransitionsDirection result;
	switch (self) {
		case DIRECTION_FORWARD:
		{
			result = SPIT_TRANSITIONS_DIRECTION_FORWARD;
			return result;
		}
		case DIRECTION_BACKWARD:
		{
			result = SPIT_TRANSITIONS_DIRECTION_BACKWARD;
			return result;
		}
		default:
		{
			GEnumValue* _tmp0_;
			_tmp0_ = g_enum_get_value (g_type_class_ref (TYPE_DIRECTION), self);
			g_error ("ui.vala:39: Unknown Direction %s", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
		}
	}
}

static GType
direction_get_type_once (void)
{
	static const GEnumValue values[] = {{DIRECTION_FORWARD, "DIRECTION_FORWARD", "forward"}, {DIRECTION_BACKWARD, "DIRECTION_BACKWARD", "backward"}, {0, NULL, NULL}};
	GType direction_type_id;
	direction_type_id = g_enum_register_static ("Direction", values);
	return direction_type_id;
}

GType
direction_get_type (void)
{
	static volatile gsize direction_type_id__once = 0;
	if (g_once_init_enter (&direction_type_id__once)) {
		GType direction_type_id;
		direction_type_id = direction_get_type_once ();
		g_once_init_leave (&direction_type_id__once, direction_type_id);
	}
	return direction_type_id__once;
}

void
spin_event_loop (void)
{
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
}

AdjustmentRelation
get_adjustment_relation (GtkAdjustment* adjustment,
                         gint value)
{
	AdjustmentRelation result;
	g_return_val_if_fail (adjustment != NULL, 0);
	if (value < ((gint) gtk_adjustment_get_value (adjustment))) {
		result = ADJUSTMENT_RELATION_BELOW;
		return result;
	} else {
		if (value > ((gint) (gtk_adjustment_get_value (adjustment) + gtk_adjustment_get_page_size (adjustment)))) {
			result = ADJUSTMENT_RELATION_ABOVE;
			return result;
		} else {
			result = ADJUSTMENT_RELATION_IN_RANGE;
			return result;
		}
	}
}

void
get_adjustment_page (GtkAdjustment* hadj,
                     GtkAdjustment* vadj,
                     GdkRectangle* result)
{
	GdkRectangle rect = {0};
	g_return_if_fail (hadj != NULL);
	g_return_if_fail (vadj != NULL);
	memset (&rect, 0, sizeof (GdkRectangle));
	rect.x = (gint) gtk_adjustment_get_value (hadj);
	rect.y = (gint) gtk_adjustment_get_value (vadj);
	rect.width = (gint) gtk_adjustment_get_page_size (hadj);
	rect.height = (gint) gtk_adjustment_get_page_size (vadj);
	*result = rect;
	return;
}

gboolean
has_only_key_modifier (GdkModifierType field,
                       GdkModifierType mask)
{
	gboolean result;
	result = (field & ((((((((GDK_SHIFT_MASK | GDK_CONTROL_MASK) | GDK_MOD1_MASK) | GDK_MOD3_MASK) | GDK_MOD4_MASK) | GDK_MOD5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK)) == mask;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
build_dummy_ui_string (GtkActionGroup** groups,
                       gint groups_length1)
{
	gchar* ui_string = NULL;
	gchar* _tmp0_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	_tmp0_ = g_strdup ("<ui>");
	ui_string = _tmp0_;
	{
		GtkActionGroup** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = groups;
		group_collection_length1 = groups_length1;
		for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
			GtkActionGroup* _tmp1_;
			GtkActionGroup* group = NULL;
			_tmp1_ = _g_object_ref0 (group_collection[group_it]);
			group = _tmp1_;
			{
				GtkActionGroup* _tmp2_;
				GList* _tmp3_;
				_tmp2_ = group;
				_tmp3_ = gtk_action_group_list_actions (_tmp2_);
				{
					GList* action_collection = NULL;
					GList* action_it = NULL;
					action_collection = _tmp3_;
					for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
						GtkAction* _tmp4_;
						GtkAction* action = NULL;
						_tmp4_ = _g_object_ref0 ((GtkAction*) action_it->data);
						action = _tmp4_;
						{
							const gchar* _tmp5_;
							GtkAction* _tmp6_;
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							GtkAction* _tmp9_;
							const gchar* _tmp10_;
							const gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							_tmp5_ = ui_string;
							_tmp6_ = action;
							_tmp7_ = gtk_action_get_name (_tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = action;
							_tmp10_ = gtk_action_get_name (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = g_strdup_printf ("<accelerator name=\"%s\" action=\"%s\" />", _tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_strconcat (_tmp5_, _tmp13_, NULL);
							_g_free0 (ui_string);
							ui_string = _tmp14_;
							_g_free0 (_tmp13_);
							_g_object_unref0 (action);
						}
					}
					(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
				}
				_g_object_unref0 (group);
			}
		}
	}
	_tmp15_ = ui_string;
	_tmp16_ = g_strconcat (_tmp15_, "</ui>", NULL);
	_g_free0 (ui_string);
	ui_string = _tmp16_;
	result = ui_string;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

