/* ParserDe.c generated by valac 0.56.17, the Vala compiler
 * generated from ParserDe.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2015 elementary LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Mario Guerriero <marioguerriero33@gmail.com>
 *              pantor
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_SERVICES_TYPE_EVENT_PARSER (maya_services_event_parser_get_type ())
#define MAYA_SERVICES_EVENT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER, MayaServicesEventParser))
#define MAYA_SERVICES_IS_EVENT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER))
#define MAYA_SERVICES_EVENT_PARSER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER, MayaServicesEventParserIface))

typedef struct _MayaServicesEventParser MayaServicesEventParser;
typedef struct _MayaServicesEventParserIface MayaServicesEventParserIface;

#define MAYA_SERVICES_TYPE_PARSED_EVENT (maya_services_parsed_event_get_type ())
#define MAYA_SERVICES_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEvent))
#define MAYA_SERVICES_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))
#define MAYA_SERVICES_IS_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_IS_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_PARSED_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))

typedef struct _MayaServicesParsedEvent MayaServicesParsedEvent;
typedef struct _MayaServicesParsedEventClass MayaServicesParsedEventClass;

#define MAYA_SERVICES_TYPE_PARSER_DE (maya_services_parser_de_get_type ())
#define MAYA_SERVICES_PARSER_DE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_PARSER_DE, MayaServicesParserDe))
#define MAYA_SERVICES_PARSER_DE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_SERVICES_TYPE_PARSER_DE, MayaServicesParserDeClass))
#define MAYA_SERVICES_IS_PARSER_DE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_PARSER_DE))
#define MAYA_SERVICES_IS_PARSER_DE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_SERVICES_TYPE_PARSER_DE))
#define MAYA_SERVICES_PARSER_DE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_SERVICES_TYPE_PARSER_DE, MayaServicesParserDeClass))

typedef struct _MayaServicesParserDe MayaServicesParserDe;
typedef struct _MayaServicesParserDeClass MayaServicesParserDeClass;
typedef struct _MayaServicesParserDePrivate MayaServicesParserDePrivate;
enum  {
	MAYA_SERVICES_PARSER_DE_0_PROPERTY,
	MAYA_SERVICES_PARSER_DE_NUM_PROPERTIES
};
static GParamSpec* maya_services_parser_de_properties[MAYA_SERVICES_PARSER_DE_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAYA_SERVICES_PARSER_DE_TYPE_STRING_EVENT (maya_services_parser_de_string_event_get_type ())
typedef struct _MayaServicesParserDeStringEvent MayaServicesParserDeStringEvent;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef void (*MayaServicesParserDetranscribe_analysis) (MayaServicesParserDeStringEvent* data, gpointer user_data);
typedef struct _Block16Data Block16Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MayaServicesParsedEventPrivate MayaServicesParsedEventPrivate;

struct _MayaServicesEventParserIface {
	GTypeInterface parent_iface;
	MayaServicesParsedEvent* (*parse_source) (MayaServicesEventParser* self, const gchar* source);
	gchar* (*get_language) (MayaServicesEventParser* self);
};

struct _MayaServicesParserDe {
	GObject parent_instance;
	MayaServicesParserDePrivate * priv;
	GDateTime* simulated_dt;
	gchar* source;
};

struct _MayaServicesParserDeClass {
	GObjectClass parent_class;
};

struct _MayaServicesParserDePrivate {
	gchar* remaining_source;
	gchar** months;
	gint months_length1;
	gint months_length2;
	gchar** weekdays;
	gint weekdays_length1;
	gint weekdays_length2;
	gchar* months_regex;
	gchar* weekdays_regex;
};

struct _MayaServicesParserDeStringEvent {
	gboolean matched;
	gchar* matched_string;
	gint pos;
	gint length;
	GArray* p;
};

struct _Block16Data {
	int _ref_count_;
	MayaServicesParserDe* self;
	MayaServicesParsedEvent* event;
};

struct _MayaServicesParsedEvent {
	GObject parent_instance;
	MayaServicesParsedEventPrivate * priv;
	gchar* title;
	gchar* location;
	gchar* participants;
	GDateTime* from;
	GDateTime* to;
	gboolean* all_day;
	gboolean date_parsed;
	gboolean time_parsed;
};

struct _MayaServicesParsedEventClass {
	GObjectClass parent_class;
};

static gint MayaServicesParserDe_private_offset;
static gpointer maya_services_parser_de_parent_class = NULL;
static MayaServicesEventParserIface * maya_services_parser_de_maya_services_event_parser_parent_iface = NULL;

VALA_EXTERN GType maya_services_parsed_event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesParsedEvent, g_object_unref)
VALA_EXTERN GType maya_services_event_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesEventParser, g_object_unref)
VALA_EXTERN GType maya_services_parser_de_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesParserDe, g_object_unref)
VALA_EXTERN MayaServicesParserDe* maya_services_parser_de_new (GDateTime* _simulated_dt);
VALA_EXTERN MayaServicesParserDe* maya_services_parser_de_construct (GType object_type,
                                                         GDateTime* _simulated_dt);
static gint maya_services_parser_de_get_number_of_month (MayaServicesParserDe* self,
                                                  const gchar* entry);
static gint maya_services_parser_de_get_number_of_weekday (MayaServicesParserDe* self,
                                                    const gchar* entry);
static GType maya_services_parser_de_string_event_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static MayaServicesParserDeStringEvent* maya_services_parser_de_string_event_dup (const MayaServicesParserDeStringEvent* self);
static void maya_services_parser_de_string_event_free (MayaServicesParserDeStringEvent* self);
static void maya_services_parser_de_string_event_copy (const MayaServicesParserDeStringEvent* self,
                                                MayaServicesParserDeStringEvent* dest);
static void maya_services_parser_de_string_event_destroy (MayaServicesParserDeStringEvent* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (MayaServicesParserDeStringEvent, maya_services_parser_de_string_event_destroy)
static void maya_services_parser_de_complete_string (MayaServicesParserDe* self,
                                              const gchar* pattern,
                                              MayaServicesParserDeStringEvent* result);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
static void maya_services_parser_de_analyze_pattern (MayaServicesParserDe* self,
                                              const gchar* pattern,
                                              MayaServicesParserDetranscribe_analysis del,
                                              gpointer del_target);
static MayaServicesParsedEvent* maya_services_parser_de_real_parse_source (MayaServicesEventParser* base,
                                                                    const gchar* _source);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
VALA_EXTERN MayaServicesParsedEvent* maya_services_parsed_event_new (const gchar* _title,
                                                         GDateTime* _from,
                                                         GDateTime* _to,
                                                         const gchar* _location,
                                                         gboolean* _all_day,
                                                         const gchar* _participants,
                                                         gboolean _date_parsed,
                                                         gboolean _time_parsed);
VALA_EXTERN MayaServicesParsedEvent* maya_services_parsed_event_construct (GType object_type,
                                                               const gchar* _title,
                                                               GDateTime* _from,
                                                               GDateTime* _to,
                                                               const gchar* _location,
                                                               gboolean* _all_day,
                                                               const gchar* _participants,
                                                               gboolean _date_parsed,
                                                               gboolean _time_parsed);
VALA_EXTERN void maya_services_parsed_event_from_set_minute (MayaServicesParsedEvent* self,
                                                 gint minute);
VALA_EXTERN void maya_services_parsed_event_from_set_second (MayaServicesParsedEvent* self,
                                                 gint second);
VALA_EXTERN void maya_services_parsed_event_set_length_to_hours (MayaServicesParsedEvent* self,
                                                     gint hours);
static void __lambda95_ (Block16Data* _data16_,
                  MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_one_entire_day (MayaServicesParsedEvent* self);
static void ___lambda95__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                           gpointer self);
static void __lambda96_ (Block16Data* _data16_,
                  MayaServicesParserDeStringEvent* data);
static void ___lambda96__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                           gpointer self);
static void __lambda97_ (Block16Data* _data16_,
                  MayaServicesParserDeStringEvent* data);
static void ___lambda97__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                           gpointer self);
static void __lambda98_ (Block16Data* _data16_,
                  MayaServicesParserDeStringEvent* data);
static void ___lambda98__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                           gpointer self);
static void __lambda99_ (Block16Data* _data16_,
                  MayaServicesParserDeStringEvent* data);
static void ___lambda99__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                           gpointer self);
static void __lambda100_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda100__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda101_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda101__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda102_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda102__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda103_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda103__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda104_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda104__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda105_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_from_set_day (MayaServicesParsedEvent* self,
                                              gint day);
VALA_EXTERN void maya_services_parsed_event_from_set_month (MayaServicesParsedEvent* self,
                                                gint month);
VALA_EXTERN void maya_services_parsed_event_to_set_month (MayaServicesParsedEvent* self,
                                              gint month);
VALA_EXTERN void maya_services_parsed_event_from_set_year (MayaServicesParsedEvent* self,
                                               gint year);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_year (MayaServicesParsedEvent* self,
                                                               GDateTime* simulated_dt);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_month (MayaServicesParsedEvent* self,
                                                                GDateTime* simulated_dt);
static void ___lambda105__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda106_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_to_set_day (MayaServicesParsedEvent* self,
                                            gint day);
VALA_EXTERN void maya_services_parsed_event_set_all_day (MayaServicesParsedEvent* self);
static void ___lambda106__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda107_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda107__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda108_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda108__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda109_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_from_set_hour (MayaServicesParsedEvent* self,
                                               gint hour,
                                               const gchar* half);
static gboolean* _bool_dup (gboolean* self);
static void ___lambda109__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda110_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda110__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda111_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda111__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda112_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda112__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda113_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda113__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda114_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda114__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda115_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda115__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda116_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_to_set_hour (MayaServicesParsedEvent* self,
                                             gint hour,
                                             const gchar* half);
VALA_EXTERN void maya_services_parsed_event_to_set_minute (MayaServicesParsedEvent* self,
                                               gint minute);
static void ___lambda116__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda117_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda117__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda118_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_length_to_minutes (MayaServicesParsedEvent* self,
                                                       gint minutes);
static void ___lambda118__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda119_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda119__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda120_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_length_to_days (MayaServicesParsedEvent* self,
                                                    gint days);
static void ___lambda120__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda121_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_length_to_weeks (MayaServicesParsedEvent* self,
                                                     gint weeks);
static void ___lambda121__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda122_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda122__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static void __lambda123_ (Block16Data* _data16_,
                   MayaServicesParserDeStringEvent* data);
static void ___lambda123__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                            gpointer self);
static gchar* maya_services_parser_de_real_get_language (MayaServicesEventParser* base);
VALA_EXTERN MayaServicesParsedEvent* maya_services_event_parser_parse_source (MayaServicesEventParser* self,
                                                                  const gchar* source);
VALA_EXTERN gchar* maya_services_event_parser_get_language (MayaServicesEventParser* self);
static void maya_services_parser_de_finalize (GObject * obj);
static GType maya_services_parser_de_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
maya_services_parser_de_get_instance_private (MayaServicesParserDe* self)
{
	return G_STRUCT_MEMBER_P (self, MayaServicesParserDe_private_offset);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

MayaServicesParserDe*
maya_services_parser_de_construct (GType object_type,
                                   GDateTime* _simulated_dt)
{
	MayaServicesParserDe * self = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_val_if_fail (_simulated_dt != NULL, NULL);
	self = (MayaServicesParserDe*) g_object_new (object_type, NULL);
	_tmp0_ = _g_date_time_ref0 (_simulated_dt);
	_g_date_time_unref0 (self->simulated_dt);
	self->simulated_dt = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->source);
	self->source = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->remaining_source);
	self->priv->remaining_source = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->months_regex);
	self->priv->months_regex = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp7__length2;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp6_ = self->priv->months_regex;
				_tmp7_ = self->priv->months;
				_tmp7__length1 = self->priv->months_length1;
				_tmp7__length2 = self->priv->months_length2;
				_tmp8_ = _tmp7_[(i * _tmp7__length2) + 0];
				_tmp9_ = g_strconcat (_tmp8_, "|", NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
				_g_free0 (self->priv->months_regex);
				self->priv->months_regex = _tmp11_;
				_g_free0 (_tmp10_);
			}
		}
	}
	_tmp12_ = self->priv->months_regex;
	_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) -1);
	_g_free0 (self->priv->months_regex);
	self->priv->months_regex = _tmp13_;
	_tmp14_ = g_strdup ("");
	_g_free0 (self->priv->weekdays_regex);
	self->priv->weekdays_regex = _tmp14_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				gint _tmp18__length2;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				_tmp17_ = self->priv->weekdays_regex;
				_tmp18_ = self->priv->weekdays;
				_tmp18__length1 = self->priv->weekdays_length1;
				_tmp18__length2 = self->priv->weekdays_length2;
				_tmp19_ = _tmp18_[(i * _tmp18__length2) + 0];
				_tmp20_ = g_strconcat (_tmp19_, "|", NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat (_tmp17_, _tmp21_, NULL);
				_g_free0 (self->priv->weekdays_regex);
				self->priv->weekdays_regex = _tmp22_;
				_g_free0 (_tmp21_);
			}
		}
	}
	_tmp23_ = self->priv->weekdays_regex;
	_tmp24_ = string_slice (_tmp23_, (glong) 0, (glong) -1);
	_g_free0 (self->priv->weekdays_regex);
	self->priv->weekdays_regex = _tmp24_;
	return self;
}

MayaServicesParserDe*
maya_services_parser_de_new (GDateTime* _simulated_dt)
{
	return maya_services_parser_de_construct (MAYA_SERVICES_TYPE_PARSER_DE, _simulated_dt);
}

static gint
maya_services_parser_de_get_number_of_month (MayaServicesParserDe* self,
                                             const gchar* entry)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (entry != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				const gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp2_ = g_utf8_strdown (entry, (gssize) -1);
				_tmp3_ = _tmp2_;
				_tmp4_ = self->priv->months;
				_tmp4__length1 = self->priv->months_length1;
				_tmp4__length2 = self->priv->months_length2;
				_tmp5_ = _tmp4_[(i * _tmp4__length2) + 0];
				_tmp6_ = g_strcmp0 (_tmp3_, _tmp5_) == 0;
				_g_free0 (_tmp3_);
				if (_tmp6_) {
					gchar** _tmp7_;
					gint _tmp7__length1;
					gint _tmp7__length2;
					const gchar* _tmp8_;
					_tmp7_ = self->priv->months;
					_tmp7__length1 = self->priv->months_length1;
					_tmp7__length2 = self->priv->months_length2;
					_tmp8_ = _tmp7_[(i * _tmp7__length2) + 1];
					result = atoi (_tmp8_);
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

static gint
maya_services_parser_de_get_number_of_weekday (MayaServicesParserDe* self,
                                               const gchar* entry)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (entry != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				const gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp2_ = g_utf8_strdown (entry, (gssize) -1);
				_tmp3_ = _tmp2_;
				_tmp4_ = self->priv->weekdays;
				_tmp4__length1 = self->priv->weekdays_length1;
				_tmp4__length2 = self->priv->weekdays_length2;
				_tmp5_ = _tmp4_[(i * _tmp4__length2) + 0];
				_tmp6_ = g_strcmp0 (_tmp3_, _tmp5_) == 0;
				_g_free0 (_tmp3_);
				if (_tmp6_) {
					gchar** _tmp7_;
					gint _tmp7__length1;
					gint _tmp7__length2;
					const gchar* _tmp8_;
					_tmp7_ = self->priv->weekdays;
					_tmp7__length1 = self->priv->weekdays_length1;
					_tmp7__length2 = self->priv->weekdays_length2;
					_tmp8_ = _tmp7_[(i * _tmp7__length2) + 1];
					result = atoi (_tmp8_);
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static void
maya_services_parser_de_complete_string (MayaServicesParserDe* self,
                                         const gchar* pattern,
                                         MayaServicesParserDeStringEvent* result)
{
	GRegex* regex = NULL;
	GMatchInfo* match_info = NULL;
	gchar* matched_string = NULL;
	GMatchInfo* _tmp9_;
	gchar* _tmp10_;
	gint pos = 0;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint length = 0;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GArray* p = NULL;
	GArray* _tmp16_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GArray* _tmp30_;
	GArray* _tmp31_;
	MayaServicesParserDeStringEvent _tmp32_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pattern != NULL);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		gboolean is_matched = FALSE;
		GRegex* _tmp3_;
		const gchar* _tmp4_;
		GMatchInfo* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp1_ = g_regex_new (pattern, G_REGEX_CASELESS, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (regex);
		regex = _tmp2_;
		_tmp3_ = regex;
		_tmp4_ = self->priv->remaining_source;
		_tmp6_ = g_regex_match (_tmp3_, _tmp4_, 0, &_tmp5_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp5_;
		is_matched = _tmp6_;
		if (!is_matched) {
			MayaServicesParserDeStringEvent _tmp7_ = {0};
			memset (&_tmp7_, 0, sizeof (MayaServicesParserDeStringEvent));
			_tmp7_.matched = FALSE;
			*result = _tmp7_;
			_g_regex_unref0 (_tmp0_);
			_g_match_info_unref0 (match_info);
			_g_regex_unref0 (regex);
			return;
		}
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		MayaServicesParserDeStringEvent _tmp8_ = {0};
		g_clear_error (&_inner_error0_);
		memset (&_tmp8_, 0, sizeof (MayaServicesParserDeStringEvent));
		_tmp8_.matched = FALSE;
		*result = _tmp8_;
		_g_match_info_unref0 (match_info);
		_g_regex_unref0 (regex);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = match_info;
	_tmp10_ = g_match_info_fetch (_tmp9_, 0);
	matched_string = _tmp10_;
	_tmp11_ = self->priv->remaining_source;
	_tmp12_ = matched_string;
	pos = string_index_of (_tmp11_, _tmp12_, 0);
	_tmp13_ = matched_string;
	_tmp14_ = strlen (_tmp13_);
	_tmp15_ = _tmp14_;
	length = _tmp15_;
	_tmp16_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp16_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	p = _tmp16_;
	while (TRUE) {
		GMatchInfo* _tmp17_;
		_tmp17_ = match_info;
		if (!g_match_info_matches (_tmp17_)) {
			break;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					GArray* _tmp20_;
					GMatchInfo* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(i < 4)) {
						break;
					}
					_tmp20_ = p;
					_tmp21_ = match_info;
					_tmp22_ = g_strdup_printf ("%i", i + 1);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat ("p", _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_match_info_fetch_named (_tmp21_, _tmp25_);
					g_array_append_val (_tmp20_, _tmp26_);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp23_);
				}
			}
		}
		{
			GMatchInfo* _tmp27_;
			_tmp27_ = match_info;
			g_match_info_next (_tmp27_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch1_g_regex_error;
				}
				_g_array_unref0 (p);
				_g_free0 (matched_string);
				_g_match_info_unref0 (match_info);
				_g_regex_unref0 (regex);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally1;
		__catch1_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_array_unref0 (p);
			_g_free0 (matched_string);
			_g_match_info_unref0 (match_info);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp28_ = matched_string;
	_tmp29_ = g_strdup (_tmp28_);
	_tmp30_ = p;
	_tmp31_ = _g_array_ref0 (_tmp30_);
	memset (&_tmp32_, 0, sizeof (MayaServicesParserDeStringEvent));
	_tmp32_.matched = TRUE;
	_tmp32_.pos = pos;
	_tmp32_.length = length;
	_g_free0 (_tmp32_.matched_string);
	_tmp32_.matched_string = _tmp29_;
	_g_array_unref0 (_tmp32_.p);
	_tmp32_.p = _tmp31_;
	*result = _tmp32_;
	_g_array_unref0 (p);
	_g_free0 (matched_string);
	_g_match_info_unref0 (match_info);
	_g_regex_unref0 (regex);
	return;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static void
maya_services_parser_de_analyze_pattern (MayaServicesParserDe* self,
                                         const gchar* pattern,
                                         MayaServicesParserDetranscribe_analysis del,
                                         gpointer del_target)
{
	MayaServicesParserDeStringEvent data = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	MayaServicesParserDeStringEvent _tmp4_ = {0};
	MayaServicesParserDeStringEvent _tmp5_;
	MayaServicesParserDeStringEvent _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pattern != NULL);
	_tmp0_ = g_strconcat ("\\b", pattern, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\\b", NULL);
	_tmp3_ = _tmp2_;
	maya_services_parser_de_complete_string (self, _tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	data = _tmp5_;
	_tmp6_ = data;
	if (_tmp6_.matched) {
		const gchar* _tmp7_;
		MayaServicesParserDeStringEvent _tmp8_;
		MayaServicesParserDeStringEvent _tmp9_;
		MayaServicesParserDeStringEvent _tmp10_;
		gchar* _tmp11_;
		MayaServicesParserDeStringEvent _tmp12_;
		_tmp7_ = self->priv->remaining_source;
		_tmp8_ = data;
		_tmp9_ = data;
		_tmp10_ = data;
		_tmp11_ = string_splice (_tmp7_, (glong) _tmp8_.pos, (glong) (_tmp9_.pos + _tmp10_.length), NULL);
		_g_free0 (self->priv->remaining_source);
		self->priv->remaining_source = _tmp11_;
		_tmp12_ = data;
		del (&_tmp12_, del_target);
	}
	maya_services_parser_de_string_event_destroy (&data);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		MayaServicesParserDe* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->event);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda95_ (Block16Data* _data16_,
             MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->date_parsed = TRUE;
	_tmp0_ = _data16_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, -2);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda95__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                      gpointer self)
{
	__lambda95_ (self, data);
}

static void
__lambda96_ (Block16Data* _data16_,
             MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->date_parsed = TRUE;
	_tmp0_ = _data16_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, -1);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda96__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                      gpointer self)
{
	__lambda96_ (self, data);
}

static void
__lambda97_ (Block16Data* _data16_,
             MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->date_parsed = TRUE;
	_tmp0_ = _data16_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, 1);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda97__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                      gpointer self)
{
	__lambda97_ (self, data);
}

static void
__lambda98_ (Block16Data* _data16_,
             MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->date_parsed = TRUE;
	_tmp0_ = _data16_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, 2);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda98__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                      gpointer self)
{
	__lambda98_ (self, data);
}

static void
__lambda99_ (Block16Data* _data16_,
             MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda99__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                      gpointer self)
{
	__lambda99_ (self, data);
}

static void
__lambda100_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint days = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	days = atoi (_tmp2_);
	_data16_->event->date_parsed = TRUE;
	_tmp3_ = _data16_->event->from;
	_tmp4_ = g_date_time_add_days (_tmp3_, -days);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp4_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda100__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda100_ (self, data);
}

static void
__lambda101_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint days = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	days = atoi (_tmp2_);
	_data16_->event->date_parsed = TRUE;
	_tmp3_ = _data16_->event->from;
	_tmp4_ = g_date_time_add_days (_tmp3_, days);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp4_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda101__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda101_ (self, data);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda102_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint weekday = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint add_days = 0;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weekday = maya_services_parser_de_get_number_of_weekday (self, _tmp2_);
	_tmp3_ = self->simulated_dt;
	add_days = ((weekday - g_date_time_get_day_of_week (_tmp3_)) + 7) % 7;
	_data16_->event->date_parsed = TRUE;
	_tmp4_ = _data16_->event->from;
	_tmp5_ = g_date_time_add_days (_tmp4_, add_days);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp5_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda102__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda102_ (self, data);
}

static void
__lambda103_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint weekday = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint add_days = 0;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weekday = maya_services_parser_de_get_number_of_weekday (self, _tmp2_);
	_tmp3_ = self->simulated_dt;
	add_days = ((weekday - g_date_time_get_day_of_week (_tmp3_)) + 7) % 7;
	_data16_->event->date_parsed = TRUE;
	_tmp4_ = _data16_->event->from;
	_tmp5_ = g_date_time_add_days (_tmp4_, add_days);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp5_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda103__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda103_ (self, data);
}

static void
__lambda104_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint weekday = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint add_days = 0;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weekday = maya_services_parser_de_get_number_of_weekday (self, _tmp2_);
	_tmp3_ = self->simulated_dt;
	add_days = ((weekday - g_date_time_get_day_of_week (_tmp3_)) + 7) % 7;
	_data16_->event->date_parsed = TRUE;
	_tmp4_ = _data16_->event->from;
	_tmp5_ = g_date_time_add_weeks (_tmp4_, 1);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp5_;
	_tmp6_ = _data16_->event->from;
	_tmp7_ = g_date_time_add_days (_tmp6_, add_days);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp7_;
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
}

static void
___lambda104__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda104_ (self, data);
}

static void
__lambda105_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint day = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint month = 0;
	MayaServicesParserDeStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	MayaServicesParserDeStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	GDateTime* _tmp13_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	day = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	month = atoi (_tmp5_);
	_data16_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data16_->event, day);
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
	maya_services_parsed_event_from_set_month (_data16_->event, month);
	maya_services_parsed_event_to_set_month (_data16_->event, month);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 2);
	if (_tmp8_ != NULL) {
		gint year = 0;
		MayaServicesParserDeStringEvent _tmp9_;
		GArray* _tmp10_;
		const gchar* _tmp11_;
		GDateTime* _tmp12_;
		_tmp9_ = *data;
		_tmp10_ = _tmp9_.p;
		_tmp11_ = g_array_index (_tmp10_, gchar*, (guint) 2);
		year = atoi (_tmp11_);
		maya_services_parsed_event_from_set_year (_data16_->event, year);
		_tmp12_ = self->simulated_dt;
		maya_services_parsed_event_if_elapsed_delay_to_next_year (_data16_->event, _tmp12_);
	}
	_tmp13_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_month (_data16_->event, _tmp13_);
}

static void
___lambda105__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda105_ (self, data);
}

static void
__lambda106_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint day_1 = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint day_2 = 0;
	MayaServicesParserDeStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	MayaServicesParserDeStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	GDateTime* _tmp13_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	day_1 = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	day_2 = atoi (_tmp5_);
	_data16_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data16_->event, day_1);
	maya_services_parsed_event_to_set_day (_data16_->event, day_2);
	maya_services_parsed_event_set_all_day (_data16_->event);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 2);
	if (_tmp8_ != NULL) {
		gint month = 0;
		MayaServicesParserDeStringEvent _tmp9_;
		GArray* _tmp10_;
		const gchar* _tmp11_;
		GDateTime* _tmp12_;
		_tmp9_ = *data;
		_tmp10_ = _tmp9_.p;
		_tmp11_ = g_array_index (_tmp10_, gchar*, (guint) 2);
		month = maya_services_parser_de_get_number_of_month (self, _tmp11_);
		maya_services_parsed_event_from_set_month (_data16_->event, month);
		maya_services_parsed_event_to_set_month (_data16_->event, month);
		_tmp12_ = self->simulated_dt;
		maya_services_parsed_event_if_elapsed_delay_to_next_year (_data16_->event, _tmp12_);
	}
	_tmp13_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_month (_data16_->event, _tmp13_);
}

static void
___lambda106__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda106_ (self, data);
}

static void
__lambda107_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint day = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint month = 0;
	MayaServicesParserDeStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	GDateTime* _tmp6_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	day = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	month = maya_services_parser_de_get_number_of_month (self, _tmp5_);
	_data16_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data16_->event, day);
	maya_services_parsed_event_from_set_month (_data16_->event, month);
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
	_tmp6_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data16_->event, _tmp6_);
}

static void
___lambda107__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda107_ (self, data);
}

static void
__lambda108_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	GDateTime* _tmp0_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_month (_data16_->event, 12);
	maya_services_parsed_event_from_set_day (_data16_->event, 24);
	maya_services_parsed_event_set_one_entire_day (_data16_->event);
	_tmp0_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data16_->event, _tmp0_);
}

static void
___lambda108__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda108_ (self, data);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static void
__lambda109_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, 9, "");
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp1_;
}

static void
___lambda109__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda109_ (self, data);
}

static void
__lambda110_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, 11, "");
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp1_;
}

static void
___lambda110__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda110_ (self, data);
}

static void
__lambda111_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, 12, "");
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp1_;
}

static void
___lambda111__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda111_ (self, data);
}

static void
__lambda112_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, 15, "");
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp1_;
}

static void
___lambda112__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda112_ (self, data);
}

static void
__lambda113_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, 18, "");
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp1_;
}

static void
___lambda113__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda113_ (self, data);
}

static void
__lambda114_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, 19, "");
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 3);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp1_;
}

static void
___lambda114__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda114_ (self, data);
}

static void
__lambda115_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint hour = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	MayaServicesParserDeStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp9_;
	gboolean* _tmp10_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hour = atoi (_tmp2_);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, hour, "");
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	if (_tmp5_ != NULL) {
		gint minute_1 = 0;
		MayaServicesParserDeStringEvent _tmp6_;
		GArray* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = *data;
		_tmp7_ = _tmp6_.p;
		_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 1);
		minute_1 = atoi (_tmp8_);
		maya_services_parsed_event_from_set_minute (_data16_->event, minute_1);
	}
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	_tmp9_ = FALSE;
	_tmp10_ = __bool_dup0 (&_tmp9_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp10_;
}

static void
___lambda115__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda115_ (self, data);
}

static void
__lambda116_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint hour_1 = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint hour_2 = 0;
	MayaServicesParserDeStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	MayaServicesParserDeStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	MayaServicesParserDeStringEvent _tmp12_;
	GArray* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp18_;
	gboolean* _tmp19_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hour_1 = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	hour_2 = atoi (_tmp5_);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, hour_1, "");
	maya_services_parsed_event_to_set_hour (_data16_->event, hour_2, "");
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 2);
	if (_tmp8_ != NULL) {
		gint minute_1 = 0;
		MayaServicesParserDeStringEvent _tmp9_;
		GArray* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = *data;
		_tmp10_ = _tmp9_.p;
		_tmp11_ = g_array_index (_tmp10_, gchar*, (guint) 2);
		minute_1 = atoi (_tmp11_);
		maya_services_parsed_event_from_set_minute (_data16_->event, minute_1);
	}
	_tmp12_ = *data;
	_tmp13_ = _tmp12_.p;
	_tmp14_ = g_array_index (_tmp13_, gchar*, (guint) 3);
	if (_tmp14_ != NULL) {
		gint minute_2 = 0;
		MayaServicesParserDeStringEvent _tmp15_;
		GArray* _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = *data;
		_tmp16_ = _tmp15_.p;
		_tmp17_ = g_array_index (_tmp16_, gchar*, (guint) 3);
		minute_2 = atoi (_tmp17_);
		maya_services_parsed_event_to_set_minute (_data16_->event, minute_2);
	}
	_tmp18_ = FALSE;
	_tmp19_ = __bool_dup0 (&_tmp18_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp19_;
}

static void
___lambda116__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda116_ (self, data);
}

static void
__lambda117_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint hour = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	MayaServicesParserDeStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp9_;
	gboolean* _tmp10_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hour = atoi (_tmp2_);
	_data16_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data16_->event, hour, "");
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	if (_tmp5_ != NULL) {
		gint minute_1 = 0;
		MayaServicesParserDeStringEvent _tmp6_;
		GArray* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = *data;
		_tmp7_ = _tmp6_.p;
		_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 1);
		minute_1 = atoi (_tmp8_);
		maya_services_parsed_event_from_set_minute (_data16_->event, minute_1);
	}
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	_tmp9_ = FALSE;
	_tmp10_ = __bool_dup0 (&_tmp9_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp10_;
}

static void
___lambda117__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda117_ (self, data);
}

static void
__lambda118_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint minutes = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean* _tmp4_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	minutes = atoi (_tmp2_);
	_data16_->event->date_parsed = TRUE;
	_data16_->event->time_parsed = TRUE;
	_tmp3_ = FALSE;
	_tmp4_ = __bool_dup0 (&_tmp3_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp4_;
	maya_services_parsed_event_set_length_to_minutes (_data16_->event, minutes);
}

static void
___lambda118__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda118_ (self, data);
}

static void
__lambda119_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint hours = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean* _tmp4_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hours = atoi (_tmp2_);
	_data16_->event->date_parsed = TRUE;
	_data16_->event->time_parsed = TRUE;
	_tmp3_ = FALSE;
	_tmp4_ = __bool_dup0 (&_tmp3_);
	_g_free0 (_data16_->event->all_day);
	_data16_->event->all_day = _tmp4_;
	maya_services_parsed_event_set_length_to_hours (_data16_->event, hours);
}

static void
___lambda119__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda119_ (self, data);
}

static void
__lambda120_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint days = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	days = atoi (_tmp2_);
	_data16_->event->date_parsed = TRUE;
	maya_services_parsed_event_set_length_to_days (_data16_->event, days);
}

static void
___lambda120__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda120_ (self, data);
}

static void
__lambda121_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	gint weeks = 0;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weeks = atoi (_tmp2_);
	_data16_->event->date_parsed = TRUE;
	maya_services_parsed_event_set_length_to_weeks (_data16_->event, weeks);
}

static void
___lambda121__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda121_ (self, data);
}

static void
__lambda122_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data16_->event->location);
	_data16_->event->location = _tmp3_;
}

static void
___lambda122__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda122_ (self, data);
}

static void
__lambda123_ (Block16Data* _data16_,
              MayaServicesParserDeStringEvent* data)
{
	MayaServicesParserDe* self;
	MayaServicesParserDeStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data16_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data16_->event->location);
	_data16_->event->location = _tmp3_;
}

static void
___lambda123__mayaservicesparserdetranscribe_analysis (MayaServicesParserDeStringEvent* data,
                                                       gpointer self)
{
	__lambda123_ (self, data);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static MayaServicesParsedEvent*
maya_services_parser_de_real_parse_source (MayaServicesEventParser* base,
                                           const gchar* _source)
{
	MayaServicesParserDe * self;
	Block16Data* _data16_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	MayaServicesParsedEvent* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	MayaServicesParsedEvent* _tmp28_;
	MayaServicesParsedEvent* result;
	self = (MayaServicesParserDe*) base;
	g_return_val_if_fail (_source != NULL, NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_source);
	_g_free0 (self->source);
	self->source = _tmp0_;
	_tmp1_ = self->source;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->remaining_source);
	self->priv->remaining_source = _tmp2_;
	_tmp3_ = maya_services_parsed_event_new ("", NULL, NULL, "", NULL, "", FALSE, FALSE);
	_data16_->event = _tmp3_;
	_tmp4_ = self->simulated_dt;
	_tmp5_ = g_date_time_add_hours (_tmp4_, 1);
	_g_date_time_unref0 (_data16_->event->from);
	_data16_->event->from = _tmp5_;
	maya_services_parsed_event_from_set_minute (_data16_->event, 0);
	maya_services_parsed_event_from_set_second (_data16_->event, 0);
	maya_services_parsed_event_set_length_to_hours (_data16_->event, 1);
	maya_services_parser_de_analyze_pattern (self, "vorgestern", ___lambda95__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "gestern", ___lambda96__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "(ab )?morgen", ___lambda97__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "(ab )?übermorgen", ___lambda98__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "(den ganzen tag|ganztägig)", ___lambda99__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "vor (?<p1>\\d+) tagen", ___lambda100__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "in (?<p1>\\d+) tagen", ___lambda101__mayaservicesparserdetranscribe_analysis, _data16_);
	_tmp6_ = self->priv->weekdays_regex;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("diesen (?<p1>", _tmp7_, ")", NULL);
	_tmp9_ = _tmp8_;
	maya_services_parser_de_analyze_pattern (self, _tmp9_, ___lambda102__mayaservicesparserdetranscribe_analysis, _data16_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->weekdays_regex;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("nächsten (?<p1>", _tmp11_, ")", NULL);
	_tmp13_ = _tmp12_;
	maya_services_parser_de_analyze_pattern (self, _tmp13_, ___lambda103__mayaservicesparserdetranscribe_analysis, _data16_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->weekdays_regex;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("übernächsten (?<p1>", _tmp15_, ")", NULL);
	_tmp17_ = _tmp16_;
	maya_services_parser_de_analyze_pattern (self, _tmp17_, ___lambda104__mayaservicesparserdetranscribe_analysis, _data16_);
	_g_free0 (_tmp17_);
	maya_services_parser_de_analyze_pattern (self, "am (?<p1>\\d+).(?<p2>\\d+)(.(?<p3>\\d+))?", ___lambda105__mayaservicesparserdetranscribe_analysis, _data16_);
	_tmp18_ = self->priv->months_regex;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = g_strconcat ("vom (?<p1>\\d+). bis (?<p2>\\d+). ((?<p3>", _tmp19_, "))?", NULL);
	_tmp21_ = _tmp20_;
	maya_services_parser_de_analyze_pattern (self, _tmp21_, ___lambda106__mayaservicesparserdetranscribe_analysis, _data16_);
	_g_free0 (_tmp21_);
	_tmp22_ = self->priv->months_regex;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = g_strconcat ("am (?<p1>\\d+)(.)?( (?<p2>", _tmp23_, "))?", NULL);
	_tmp25_ = _tmp24_;
	maya_services_parser_de_analyze_pattern (self, _tmp25_, ___lambda107__mayaservicesparserdetranscribe_analysis, _data16_);
	_g_free0 (_tmp25_);
	maya_services_parser_de_analyze_pattern (self, "heiligabend", ___lambda108__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "früh", ___lambda109__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "vormittags", ___lambda110__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "mittag(s?)", ___lambda111__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "nachmittags", ___lambda112__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "abends", ___lambda113__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "spät", ___lambda114__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "(um|ab) (?<p1>\\d+)(:(?<p2>\\d+))?( (uhr|h))?", ___lambda115__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "von (?<p1>\\d+)(:(?<p3>\\d+))? bis (?<p2>\\d+)(:(?<p4>\\d+))?( uhr)?", ___lambda116__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "(?<p1>\\d+)(:(?<p2>\\d+))? (uhr|h)", ___lambda117__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "für (?<p1>\\d+)(\\s?min| Minuten)", ___lambda118__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "für (?<p1>\\d+)(\\s?h| Stunden)", ___lambda119__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "für (?<p1>\\d+)(\\s?d| Tage)", ___lambda120__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "für (?<p1>\\d+) Wochen", ___lambda121__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "(im|in dem) (?<p1>(\\w\\s?)+)", ___lambda122__mayaservicesparserdetranscribe_analysis, _data16_);
	maya_services_parser_de_analyze_pattern (self, "in( der)? (?<p1>[a-z]+)", ___lambda123__mayaservicesparserdetranscribe_analysis, _data16_);
	_tmp26_ = self->priv->remaining_source;
	_tmp27_ = string_strip (_tmp26_);
	_g_free0 (_data16_->event->title);
	_data16_->event->title = _tmp27_;
	_tmp28_ = _g_object_ref0 (_data16_->event);
	result = _tmp28_;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}

static gchar*
maya_services_parser_de_real_get_language (MayaServicesEventParser* base)
{
	MayaServicesParserDe * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaServicesParserDe*) base;
	_tmp0_ = g_strdup ("de");
	result = _tmp0_;
	return result;
}

static void
maya_services_parser_de_string_event_copy (const MayaServicesParserDeStringEvent* self,
                                           MayaServicesParserDeStringEvent* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	(*dest).matched = (*self).matched;
	_tmp0_ = (*self).matched_string;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).matched_string);
	(*dest).matched_string = _tmp1_;
	(*dest).pos = (*self).pos;
	(*dest).length = (*self).length;
	_tmp2_ = (*self).p;
	_tmp3_ = _g_array_ref0 (_tmp2_);
	_g_array_unref0 ((*dest).p);
	(*dest).p = _tmp3_;
}

static void
maya_services_parser_de_string_event_destroy (MayaServicesParserDeStringEvent* self)
{
	_g_free0 ((*self).matched_string);
	_g_array_unref0 ((*self).p);
}

static MayaServicesParserDeStringEvent*
maya_services_parser_de_string_event_dup (const MayaServicesParserDeStringEvent* self)
{
	MayaServicesParserDeStringEvent* dup;
	dup = g_new0 (MayaServicesParserDeStringEvent, 1);
	maya_services_parser_de_string_event_copy (self, dup);
	return dup;
}

static void
maya_services_parser_de_string_event_free (MayaServicesParserDeStringEvent* self)
{
	maya_services_parser_de_string_event_destroy (self);
	g_free (self);
}

static GType
maya_services_parser_de_string_event_get_type_once (void)
{
	GType maya_services_parser_de_string_event_type_id;
	maya_services_parser_de_string_event_type_id = g_boxed_type_register_static ("MayaServicesParserDeStringEvent", (GBoxedCopyFunc) maya_services_parser_de_string_event_dup, (GBoxedFreeFunc) maya_services_parser_de_string_event_free);
	return maya_services_parser_de_string_event_type_id;
}

static GType
maya_services_parser_de_string_event_get_type (void)
{
	static volatile gsize maya_services_parser_de_string_event_type_id__once = 0;
	if (g_once_init_enter (&maya_services_parser_de_string_event_type_id__once)) {
		GType maya_services_parser_de_string_event_type_id;
		maya_services_parser_de_string_event_type_id = maya_services_parser_de_string_event_get_type_once ();
		g_once_init_leave (&maya_services_parser_de_string_event_type_id__once, maya_services_parser_de_string_event_type_id);
	}
	return maya_services_parser_de_string_event_type_id__once;
}

static void
maya_services_parser_de_class_init (MayaServicesParserDeClass * klass,
                                    gpointer klass_data)
{
	maya_services_parser_de_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaServicesParserDe_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_services_parser_de_finalize;
}

static void
maya_services_parser_de_maya_services_event_parser_interface_init (MayaServicesEventParserIface * iface,
                                                                   gpointer iface_data)
{
	maya_services_parser_de_maya_services_event_parser_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_source = (MayaServicesParsedEvent* (*) (MayaServicesEventParser*, const gchar*)) maya_services_parser_de_real_parse_source;
	iface->get_language = (gchar* (*) (MayaServicesEventParser*)) maya_services_parser_de_real_get_language;
}

static void
maya_services_parser_de_instance_init (MayaServicesParserDe * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_;
	self->priv = maya_services_parser_de_get_instance_private (self);
	_tmp0_ = g_strdup ("januar");
	_tmp1_ = g_strdup ("1");
	_tmp2_ = g_strdup ("februar");
	_tmp3_ = g_strdup ("2");
	_tmp4_ = g_strdup ("märz");
	_tmp5_ = g_strdup ("3");
	_tmp6_ = g_strdup ("april");
	_tmp7_ = g_strdup ("4");
	_tmp8_ = g_strdup ("mai");
	_tmp9_ = g_strdup ("5");
	_tmp10_ = g_strdup ("juni");
	_tmp11_ = g_strdup ("6");
	_tmp12_ = g_strdup ("juli");
	_tmp13_ = g_strdup ("7");
	_tmp14_ = g_strdup ("august");
	_tmp15_ = g_strdup ("8");
	_tmp16_ = g_strdup ("september");
	_tmp17_ = g_strdup ("9");
	_tmp18_ = g_strdup ("oktober");
	_tmp19_ = g_strdup ("10");
	_tmp20_ = g_strdup ("november");
	_tmp21_ = g_strdup ("11");
	_tmp22_ = g_strdup ("dezember");
	_tmp23_ = g_strdup ("12");
	_tmp24_ = g_new0 (gchar*, (12 * 2) + 1);
	_tmp24_[0] = _tmp0_;
	_tmp24_[1] = _tmp1_;
	_tmp24_[2] = _tmp2_;
	_tmp24_[3] = _tmp3_;
	_tmp24_[4] = _tmp4_;
	_tmp24_[5] = _tmp5_;
	_tmp24_[6] = _tmp6_;
	_tmp24_[7] = _tmp7_;
	_tmp24_[8] = _tmp8_;
	_tmp24_[9] = _tmp9_;
	_tmp24_[10] = _tmp10_;
	_tmp24_[11] = _tmp11_;
	_tmp24_[12] = _tmp12_;
	_tmp24_[13] = _tmp13_;
	_tmp24_[14] = _tmp14_;
	_tmp24_[15] = _tmp15_;
	_tmp24_[16] = _tmp16_;
	_tmp24_[17] = _tmp17_;
	_tmp24_[18] = _tmp18_;
	_tmp24_[19] = _tmp19_;
	_tmp24_[20] = _tmp20_;
	_tmp24_[21] = _tmp21_;
	_tmp24_[22] = _tmp22_;
	_tmp24_[23] = _tmp23_;
	self->priv->months = _tmp24_;
	self->priv->months_length1 = 12;
	self->priv->months_length2 = 2;
	_tmp25_ = g_strdup ("montag");
	_tmp26_ = g_strdup ("1");
	_tmp27_ = g_strdup ("dienstag");
	_tmp28_ = g_strdup ("2");
	_tmp29_ = g_strdup ("mittwoch");
	_tmp30_ = g_strdup ("3");
	_tmp31_ = g_strdup ("donnerstag");
	_tmp32_ = g_strdup ("4");
	_tmp33_ = g_strdup ("freitag");
	_tmp34_ = g_strdup ("5");
	_tmp35_ = g_strdup ("samstag");
	_tmp36_ = g_strdup ("6");
	_tmp37_ = g_strdup ("sonntag");
	_tmp38_ = g_strdup ("7");
	_tmp39_ = g_new0 (gchar*, (7 * 2) + 1);
	_tmp39_[0] = _tmp25_;
	_tmp39_[1] = _tmp26_;
	_tmp39_[2] = _tmp27_;
	_tmp39_[3] = _tmp28_;
	_tmp39_[4] = _tmp29_;
	_tmp39_[5] = _tmp30_;
	_tmp39_[6] = _tmp31_;
	_tmp39_[7] = _tmp32_;
	_tmp39_[8] = _tmp33_;
	_tmp39_[9] = _tmp34_;
	_tmp39_[10] = _tmp35_;
	_tmp39_[11] = _tmp36_;
	_tmp39_[12] = _tmp37_;
	_tmp39_[13] = _tmp38_;
	self->priv->weekdays = _tmp39_;
	self->priv->weekdays_length1 = 7;
	self->priv->weekdays_length2 = 2;
}

static void
maya_services_parser_de_finalize (GObject * obj)
{
	MayaServicesParserDe * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_SERVICES_TYPE_PARSER_DE, MayaServicesParserDe);
	_g_date_time_unref0 (self->simulated_dt);
	_g_free0 (self->source);
	_g_free0 (self->priv->remaining_source);
	self->priv->months = (_vala_array_free (self->priv->months, self->priv->months_length1 * self->priv->months_length2, (GDestroyNotify) g_free), NULL);
	self->priv->weekdays = (_vala_array_free (self->priv->weekdays, self->priv->weekdays_length1 * self->priv->weekdays_length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->months_regex);
	_g_free0 (self->priv->weekdays_regex);
	G_OBJECT_CLASS (maya_services_parser_de_parent_class)->finalize (obj);
}

static GType
maya_services_parser_de_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaServicesParserDeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_services_parser_de_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaServicesParserDe), 0, (GInstanceInitFunc) maya_services_parser_de_instance_init, NULL };
	static const GInterfaceInfo maya_services_event_parser_info = { (GInterfaceInitFunc) maya_services_parser_de_maya_services_event_parser_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType maya_services_parser_de_type_id;
	maya_services_parser_de_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaServicesParserDe", &g_define_type_info, 0);
	g_type_add_interface_static (maya_services_parser_de_type_id, MAYA_SERVICES_TYPE_EVENT_PARSER, &maya_services_event_parser_info);
	MayaServicesParserDe_private_offset = g_type_add_instance_private (maya_services_parser_de_type_id, sizeof (MayaServicesParserDePrivate));
	return maya_services_parser_de_type_id;
}

GType
maya_services_parser_de_get_type (void)
{
	static volatile gsize maya_services_parser_de_type_id__once = 0;
	if (g_once_init_enter (&maya_services_parser_de_type_id__once)) {
		GType maya_services_parser_de_type_id;
		maya_services_parser_de_type_id = maya_services_parser_de_get_type_once ();
		g_once_init_leave (&maya_services_parser_de_type_id__once, maya_services_parser_de_type_id);
	}
	return maya_services_parser_de_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

