/* DateIterator.c generated by valac 0.56.17, the Vala compiler
 * generated from DateIterator.vala, do not modify */

/*
 * Copyright 2011-2018 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "elementary-calendar.h"
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CALENDAR_UTIL_DATE_ITERATOR_0_PROPERTY,
	CALENDAR_UTIL_DATE_ITERATOR_CURRENT_PROPERTY,
	CALENDAR_UTIL_DATE_ITERATOR_RANGE_PROPERTY,
	CALENDAR_UTIL_DATE_ITERATOR_VALID_PROPERTY,
	CALENDAR_UTIL_DATE_ITERATOR_READ_ONLY_PROPERTY,
	CALENDAR_UTIL_DATE_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* calendar_util_date_iterator_properties[CALENDAR_UTIL_DATE_ITERATOR_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CalendarUtilDateIteratorPrivate {
	GDateTime* _current;
	CalendarUtilDateRange* _range;
};

static gint CalendarUtilDateIterator_private_offset;
static gpointer calendar_util_date_iterator_parent_class = NULL;
static GeeTraversableIface * calendar_util_date_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * calendar_util_date_iterator_gee_iterator_parent_iface = NULL;

static gboolean calendar_util_date_iterator_real_foreach (GeeTraversable* base,
                                                   GeeForallFunc f,
                                                   gpointer f_target);
static gboolean calendar_util_date_iterator_real_next (GeeIterator* base);
static gboolean calendar_util_date_iterator_real_has_next (GeeIterator* base);
static GDateTime* calendar_util_date_iterator_real_get (GeeIterator* base);
static void calendar_util_date_iterator_real_remove (GeeIterator* base);
static void calendar_util_date_iterator_finalize (GObject * obj);
static GType calendar_util_date_iterator_get_type_once (void);
static void _vala_calendar_util_date_iterator_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_calendar_util_date_iterator_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
calendar_util_date_iterator_get_instance_private (CalendarUtilDateIterator* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarUtilDateIterator_private_offset);
}

CalendarUtilDateIterator*
calendar_util_date_iterator_construct (GType object_type,
                                       CalendarUtilDateRange* range)
{
	CalendarUtilDateIterator * self = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	g_return_val_if_fail (range != NULL, NULL);
	_tmp0_ = calendar_util_date_range_get_first_dt (range);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_add_days (_tmp1_, -1);
	_tmp3_ = _tmp2_;
	self = (CalendarUtilDateIterator*) g_object_new (object_type, "range", range, "current", _tmp3_, NULL);
	_g_date_time_unref0 (_tmp3_);
	return self;
}

CalendarUtilDateIterator*
calendar_util_date_iterator_new (CalendarUtilDateRange* range)
{
	return calendar_util_date_iterator_construct (CALENDAR_UTIL_TYPE_DATE_ITERATOR, range);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gboolean
calendar_util_date_iterator_real_foreach (GeeTraversable* base,
                                          GeeForallFunc f,
                                          gpointer f_target)
{
	CalendarUtilDateIterator * self;
	GDateTime* element = NULL;
	CalendarUtilDateRange* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gboolean result;
	self = (CalendarUtilDateIterator*) base;
	_tmp0_ = self->priv->_range;
	_tmp1_ = calendar_util_date_range_get_first_dt (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
	element = _tmp3_;
	while (TRUE) {
		GDateTime* _tmp4_;
		CalendarUtilDateRange* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		GDateTime* _tmp9_;
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		_tmp4_ = element;
		_tmp5_ = self->priv->_range;
		_tmp6_ = calendar_util_date_range_get_last_dt (_tmp5_);
		_tmp7_ = _tmp6_;
		if (!(g_date_time_compare (_tmp4_, _tmp7_) < 0)) {
			break;
		}
		_tmp8_ = element;
		_tmp9_ = _g_date_time_ref0 (_tmp8_);
		if (f (_tmp9_, f_target) == FALSE) {
			result = FALSE;
			_g_date_time_unref0 (element);
			return result;
		}
		_tmp10_ = element;
		_tmp11_ = g_date_time_add_days (_tmp10_, 1);
		_g_date_time_unref0 (element);
		element = _tmp11_;
	}
	result = TRUE;
	_g_date_time_unref0 (element);
	return result;
}

static gboolean
calendar_util_date_iterator_real_next (GeeIterator* base)
{
	CalendarUtilDateIterator * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gboolean result;
	self = (CalendarUtilDateIterator*) base;
	if (!gee_iterator_has_next ((GeeIterator*) self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->_current;
	_tmp1_ = g_date_time_add_days (_tmp0_, 1);
	_tmp2_ = _tmp1_;
	calendar_util_date_iterator_set_current (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
	result = TRUE;
	return result;
}

/** Returns true if the next day after current would fall inside of range, 
     *  false otherwise.
     */
static gboolean
calendar_util_date_iterator_real_has_next (GeeIterator* base)
{
	CalendarUtilDateIterator * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	CalendarUtilDateRange* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	self = (CalendarUtilDateIterator*) base;
	_tmp0_ = self->priv->_current;
	_tmp1_ = g_date_time_add_days (_tmp0_, 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_range;
	_tmp4_ = calendar_util_date_range_get_last_dt (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_date_time_compare (_tmp2_, _tmp5_) < 0;
	_g_date_time_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static GDateTime*
calendar_util_date_iterator_real_get (GeeIterator* base)
{
	CalendarUtilDateIterator * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* result;
	self = (CalendarUtilDateIterator*) base;
	_tmp0_ = self->priv->_current;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
calendar_util_date_iterator_real_remove (GeeIterator* base)
{
	CalendarUtilDateIterator * self;
	self = (CalendarUtilDateIterator*) base;
	g_assert_not_reached ();
}

GDateTime*
calendar_util_date_iterator_get_current (CalendarUtilDateIterator* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current;
	result = _tmp0_;
	return result;
}

void
calendar_util_date_iterator_set_current (CalendarUtilDateIterator* self,
                                         GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_util_date_iterator_get_current (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_current);
		self->priv->_current = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_util_date_iterator_properties[CALENDAR_UTIL_DATE_ITERATOR_CURRENT_PROPERTY]);
	}
}

CalendarUtilDateRange*
calendar_util_date_iterator_get_range (CalendarUtilDateIterator* self)
{
	CalendarUtilDateRange* result;
	CalendarUtilDateRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_range;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
calendar_util_date_iterator_set_range (CalendarUtilDateIterator* self,
                                       CalendarUtilDateRange* value)
{
	CalendarUtilDateRange* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_util_date_iterator_get_range (self);
	if (old_value != value) {
		CalendarUtilDateRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_range);
		self->priv->_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_util_date_iterator_properties[CALENDAR_UTIL_DATE_ITERATOR_RANGE_PROPERTY]);
	}
}

static gboolean
calendar_util_date_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	CalendarUtilDateIterator* self;
	self = (CalendarUtilDateIterator*) base;
	result = TRUE;
	return result;
}

static gboolean
calendar_util_date_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	CalendarUtilDateIterator* self;
	self = (CalendarUtilDateIterator*) base;
	result = FALSE;
	return result;
}

static void
calendar_util_date_iterator_class_init (CalendarUtilDateIteratorClass * klass,
                                        gpointer klass_data)
{
	calendar_util_date_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarUtilDateIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_calendar_util_date_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_calendar_util_date_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = calendar_util_date_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_UTIL_DATE_ITERATOR_CURRENT_PROPERTY, calendar_util_date_iterator_properties[CALENDAR_UTIL_DATE_ITERATOR_CURRENT_PROPERTY] = g_param_spec_boxed ("current", "current", "current", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_UTIL_DATE_ITERATOR_RANGE_PROPERTY, calendar_util_date_iterator_properties[CALENDAR_UTIL_DATE_ITERATOR_RANGE_PROPERTY] = g_param_spec_object ("range", "range", "range", CALENDAR_UTIL_TYPE_DATE_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_UTIL_DATE_ITERATOR_VALID_PROPERTY, calendar_util_date_iterator_properties[CALENDAR_UTIL_DATE_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_UTIL_DATE_ITERATOR_READ_ONLY_PROPERTY, calendar_util_date_iterator_properties[CALENDAR_UTIL_DATE_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
calendar_util_date_iterator_gee_traversable_get_g_type (CalendarUtilDateIterator* self)
{
	return (GType) G_TYPE_DATE_TIME;
}

static GBoxedCopyFunc
calendar_util_date_iterator_gee_traversable_get_g_dup_func (CalendarUtilDateIterator* self)
{
	return (GBoxedCopyFunc) g_date_time_ref;
}

static GDestroyNotify
calendar_util_date_iterator_gee_traversable_get_g_destroy_func (CalendarUtilDateIterator* self)
{
	return (GDestroyNotify) g_date_time_unref;
}

static void
calendar_util_date_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                            gpointer iface_data)
{
	calendar_util_date_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) calendar_util_date_iterator_real_foreach;
	iface->get_g_type = (GType (*) (GeeTraversable *)) calendar_util_date_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) calendar_util_date_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) calendar_util_date_iterator_gee_traversable_get_g_destroy_func;
}

static void
calendar_util_date_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                         gpointer iface_data)
{
	calendar_util_date_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) calendar_util_date_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) calendar_util_date_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) calendar_util_date_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) calendar_util_date_iterator_real_remove;
	iface->get_valid = calendar_util_date_iterator_real_get_valid;
	iface->get_read_only = calendar_util_date_iterator_real_get_read_only;
}

static void
calendar_util_date_iterator_instance_init (CalendarUtilDateIterator * self,
                                           gpointer klass)
{
	self->priv = calendar_util_date_iterator_get_instance_private (self);
}

static void
calendar_util_date_iterator_finalize (GObject * obj)
{
	CalendarUtilDateIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_UTIL_TYPE_DATE_ITERATOR, CalendarUtilDateIterator);
	_g_date_time_unref0 (self->priv->_current);
	_g_object_unref0 (self->priv->_range);
	G_OBJECT_CLASS (calendar_util_date_iterator_parent_class)->finalize (obj);
}

static GType
calendar_util_date_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarUtilDateIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_util_date_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarUtilDateIterator), 0, (GInstanceInitFunc) calendar_util_date_iterator_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) calendar_util_date_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) calendar_util_date_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType calendar_util_date_iterator_type_id;
	calendar_util_date_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "CalendarUtilDateIterator", &g_define_type_info, 0);
	g_type_add_interface_static (calendar_util_date_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (calendar_util_date_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	CalendarUtilDateIterator_private_offset = g_type_add_instance_private (calendar_util_date_iterator_type_id, sizeof (CalendarUtilDateIteratorPrivate));
	return calendar_util_date_iterator_type_id;
}

GType
calendar_util_date_iterator_get_type (void)
{
	static volatile gsize calendar_util_date_iterator_type_id__once = 0;
	if (g_once_init_enter (&calendar_util_date_iterator_type_id__once)) {
		GType calendar_util_date_iterator_type_id;
		calendar_util_date_iterator_type_id = calendar_util_date_iterator_get_type_once ();
		g_once_init_leave (&calendar_util_date_iterator_type_id__once, calendar_util_date_iterator_type_id);
	}
	return calendar_util_date_iterator_type_id__once;
}

static void
_vala_calendar_util_date_iterator_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	CalendarUtilDateIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_UTIL_TYPE_DATE_ITERATOR, CalendarUtilDateIterator);
	switch (property_id) {
		case CALENDAR_UTIL_DATE_ITERATOR_CURRENT_PROPERTY:
		g_value_set_boxed (value, calendar_util_date_iterator_get_current (self));
		break;
		case CALENDAR_UTIL_DATE_ITERATOR_RANGE_PROPERTY:
		g_value_set_object (value, calendar_util_date_iterator_get_range (self));
		break;
		case CALENDAR_UTIL_DATE_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case CALENDAR_UTIL_DATE_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_calendar_util_date_iterator_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	CalendarUtilDateIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_UTIL_TYPE_DATE_ITERATOR, CalendarUtilDateIterator);
	switch (property_id) {
		case CALENDAR_UTIL_DATE_ITERATOR_CURRENT_PROPERTY:
		calendar_util_date_iterator_set_current (self, g_value_get_boxed (value));
		break;
		case CALENDAR_UTIL_DATE_ITERATOR_RANGE_PROPERTY:
		calendar_util_date_iterator_set_range (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

